globals [ dSlope ; (negative of) demand curve slope: Price = priceIntercept - dSlope * totalQuantity
          episodeAbsoluteCount ; the number of episodes begun in the current run
          currentQ ; the sum of all the quantity bids in the current episode
          currentP ; the market price in the current episode, given the demand curve and currentQ
          marketTotalReward
          quantityIntercept
          priceIntercept ; redundant with pIntercept
          m-quantity ; monopoly quantity, assuming costs are proportional to quantities: ki*Qi
          m-price ; monopoly price, assuming we have the m-quantity
          runningAverageBidList ; used to hold runningAvgLength currentQs
          runningAverageBid ; mean of runningAverageBidList
          runningAverageBidSD ; standard deviation of runningAverageBidList
          cournotQuantity
          runningAverageCournotList ; for the Cournot values
          runningAverageCournot          
          runningAverageMonopolyList ; for the monopoly values, m-quantity
          runningAverageMonopoly
          competitiveQuantity
          runningAverageCompetitiveList ; for the Cournot values
          runningAverageCompetitive
          totalUnitProductionCost ; the sum of all the production costs for all the turtles
          monopolyQFirm0 monopolyQFirm1
          daVersion
          RepetitionCounter ; 
          ratioOfferedCournot ; ratio of runningAverageBid to runningAverageCournot.  Collusion if < 1.
          rPrime ; see paper with Fred
  ] ; end of globals

breed [pAndAers pAndA]     ; Probe-and-Adjust

turtles-own [quantityBid totalReward bidsWon unitProductionCost 
             netReward ; equivalent to Fred's totreward. See FindNetReward
             myEpochBids ; list of bids I made during the present epoch
             marketEpochBids ; list of all bids made during the present epoch
             ]
pAndAers-own [epsilon delta currentBaseValue epochLength episodeCount 
              upRewards downRewards ; for "Own Rewards"
              marketUpRewards marketDownRewards ; for "Market Rewards"
              updateType pricesUp pricesDown PQUp PQdown
              runningAverageReward ; each pAndA player will keep track of the running average of its rewards, across episodes
              marketOwnMixture ; in [0, 1] 100% = Market Rewards, 0% = Own Rewards, 75% = 75% Market Rewards, 25% Own Rewards
              upMarketOwnMixedRewards downMarketOwnMixedRewards ; for Market-Own Mixed Rewards, used with parameter marketOwnMixture
               ;
              ]   
          ;delta ; probe-and-adjust parameter
          ;epsilon ; probe-and-adjust parameter
          ;currentBaseValue ; probe-and-adjust parameter, the base from which probes are made
          ;epochLength ; probe-and-adjust parameter; the number of episodes in an epoch
          ;episodeCount ; the count of the number of episodes in the current epoch
          ;upRewards ; list of rewards received, P*Q(i), when bidding at or above currentAnchorValue
          ;downRewards ; list of rewards received, P*Q(i), when bidding below currentAnchorValue

to Setup ;[daRepetitionCount]
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  ;set RepetitionCount daRepetitionCount
  set daVersion "$Id: OligopolyPutQuantity.nlogo 4089 2014-03-20 21:01:52Z sok $"
  if (daRandomSeed != "system clock")
    [random-seed daRandomSeed]  
  set priceIntercept InitPIntercept 
  set quantityIntercept (InitPIntercept / InitDSlope)
  set dSlope InitDSlope

  set runningAverageBidList []
  set runningAverageCournotList []
  set runningAverageMonopolyList []
  set runningAverageCompetitiveList []

  if (initialBaseQuantityFirm0 > initialBaseQuantityFirm1)
    [print "WARNING! initialBaseQuantityFirm0 > initialBaseQuantityFirm1."]
  
  ;PlotInitialDemandCurve
  ; Initialize other globals
  set episodeAbsoluteCount 0
  
  ; Create agents/firms supplying product to the market
  create-pAndAers numPandAFirms
  ask turtles [set totalReward 0
               set bidsWon 0
               set netReward 0
               set myEpochBids []
               set marketEpochBids []]
  ask pAndAers [set upRewards []   
                set downRewards [] 
                set marketUpRewards []
                set marketDownRewards []
                set pricesUp []
                set pricesDown []
                set PQUp []
                set PQDown []
                set runningAverageReward []
                set marketOwnMixture  (runresult ((word "marketOwnMixtureFirm"  [who] of self))) 
                set upMarketOwnMixedRewards []
                set downMarketOwnMixedRewards []
                ]  
  ; Initialize agents/firms supplying product to the market
  if (numPandAFirms = 1)
    [ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
      ]
  if (numPandAFirms = 2)
    [ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
    ask pAndA 1
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue initialBaseQuantityFirm1
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ]
  ] ; end of if numPandAFirms = 2
  if (numPandAFirms = 3)
    [Setup3PandAFirms]
  if (numPandAFirms = 4)
    [Setup4PandAFirms]
  if (numPandAFirms = 5)
    [Setup5PandAFirms]
  if (numPandAFirms = 10)
    [Setup10PandAFirms]

  set totalUnitProductionCost 0
  ask turtles
    [set totalUnitProductionCost (totalUnitProductionCost + unitProductionCost)]
   ;;;;
   ; priceIntercept and dSlope determine the quantityIntercept
   ; Price = PriceIntercept - dSlope*Quantity
   ; QuantityIntercept is the Quantity when Price = 0
   ; So, quantityIntercept = priceIntercept/dSlope
   set quantityIntercept priceIntercept / dSlope
   ; This is the monopolist's quantity when the monopolist has costs 
   ; proportional to quantity: k*Quantity
   ; Here we explicitly assume that Firm0's costs are universal wrt
   ; determining the monopoly quantity.
   set m-quantity ((priceIntercept - unitCostFirm0) / (2 * dSlope))   
   set m-price (InitPIntercept - InitDSlope * m-quantity)
   set cournotQuantity (numPandAFirms * priceIntercept - totalUnitProductionCost) / ((numPandAFirms + 1) * dSlope) 
   set competitiveQuantity (priceIntercept - unitCostFirm0) / dSlope
   PlotInitialDemandCurve
end ; of setup

to Go
  ; See the documentation in the Information tab.
  set episodeAbsoluteCount episodeAbsoluteCount + 1
  ; 0. Perturb the demand curve if we're doing random-walk-as
  if (random-walk-as)
   [set priceIntercept (random-float 2 * aDelta) - aDelta + priceIntercept
   set quantityIntercept priceIntercept / dSlope
   ; This is the monopolist's quantity given proportional costs of totalUnitProductionCost
   set m-quantity ((priceIntercept - totalUnitProductionCost) / (2 * dSlope))   
   ] ; if of if (random-as)

  ; 1. All of the turtles are asked to determine a bid quantity. Each records his own, in quantityBid.
  ask turtles [
    set-quantityBid
  ] ; end of ask turtles
  ; 2. Sum the bids, the Q(i)s, to get currentQ
  set currentQ 0
  ask turtles [set currentQ (currentQ + quantityBid)]
  ; 2a. Collect quantities bid
  let quantitiesBid []
  ask turtles [set quantitiesBid lput quantityBid quantitiesBid]
  ask turtles [Update-QuantitiesBid(quantitiesBid)]
  ; 3. Determine the current price, P, for the episode
  set currentP PriceGivenQuantity(currentQ)
  ask turtles [findnetreward]
  ; Calculate total profits by all players:
  set marketTotalReward 0
  ask turtles [set marketTotalReward (marketTotalReward + netReward)]   
  ; 4. Turtles observe currentP, and record stats for the episode
  ask turtles [Observe-and-Record(currentP)(currentQ)]
  ; 5. Have agents/suppliers postpare episode
  ask turtles [Postpare-Episode]
  ; 6. Collect and calculate statistics
  set runningAverageBidList lput currentQ runningAverageBidList
  if (length runningAverageBidList > runningAvgLength)
    [set runningAverageBidList but-first runningAverageBidList]
  set runningAverageBid mean runningAverageBidList  
  if length runningAverageBidList > 1
    [set runningAverageBidSD standard-deviation runningAverageBidList]
  ;set runningAverageCournotList lput cournotQuantity runningAverageCournotList
  ;if (length runningAverageCournotList > runningAvgLength)
   ; [set runningAverageCournotList but-first runningAverageCournotList]
  ;set runningAverageCournot mean runningAverageCournotList    
  set runningAverageMonopolyList lput m-Quantity runningAverageMonopolyList
  if (length runningAverageMonopolyList > runningAvgLength)
    [set runningAverageMonopolyList but-first runningAverageMonopolyList]
  set runningAverageMonopoly mean runningAverageMonopolyList    
  set runningAverageCompetitiveList lput competitiveQuantity runningAverageCompetitiveList
  if (length runningAverageCompetitiveList > runningAvgLength)
    [set runningAverageCompetitiveList but-first runningAverageCompetitiveList]
  set runningAverageCompetitive mean runningAverageCompetitiveList  
  ; 7. Plot monopoly quantity, bid Qs, and other statistics:
  ;ifelse (runningAverageCournot > 0)
   ;  [set ratioOfferedCournot (runningAverageBid / runningAverageCournot)]
    ; [set ratioOfferedCournot "N/A"]
  set ratioOfferedCournot (runningAverageBid / cournotQuantity)
  if (cournotQuantity - m-quantity > 0)
   [set rPrime (cournotQuantity - runningAverageBid) / (cournotQuantity - m-quantity)]
;  ifelse (runningAverageCournot - runningAverageMonopoly > 0)
;     [set rPrime (runningAverageCournot - runningAverageBid) / (runningAverageCournot - runningAverageMonopoly)]
;     [set rPrime "N/A"]
  Plot-Quantities(m-quantity)(currentQ) ; (priceIntercept / (2 * dSlope))(currentQ)
  Plot-Bids
  Plot-Average-Rewards  
end ; of Go

to Postpare-Episode
  ;print "episodeAbsoluteCount = " + episodeAbsoluteCount + " " + who-of self
  if (is-pAndA? self) [
    let meanUp 0
    let meanDown 0
    if (episodeCount >= epochLength) ; then update and reset
      [; The following I added for debugging purposes 2007-5-25, but
       ; it's a better way to handle things anyway.
       let meanUpMarketReturns 0
       let meanDownMarketReturns 0
       ifelse (marketUpRewards = [])
         [set meanUpMarketReturns 0]
         [set meanUpMarketReturns mean marketUpRewards]       
       ifelse (marketDownRewards = [])
         [set meanDownMarketReturns 0]
         [set meanDownMarketReturns mean marketDownRewards]

       let meanUpMarketOwnMixedRewards  0
       let meanDownMarketOwnMixedRewards  0
       ifelse (upMarketOwnMixedRewards = [])
         [set meanUpMarketOwnMixedRewards 0]
         [set meanUpMarketOwnMixedRewards mean upMarketOwnMixedRewards]
       ifelse (downMarketOwnMixedRewards = [])
         [set meanDownMarketOwnMixedRewards 0]
         [set meanDownMarketOwnMixedRewards mean downMarketOwnMixedRewards]
       ;print "111: " + who-of self + " " + meanUpMarketReturns + " " + meanUpMarketOwnMixedRewards + " " + meanDownMarketReturns + " " + meanDownMarketOwnMixedRewards
       ;print "222: " + who-of self + " " + marketUpRewards 
       ;print "333: " + who-of self + " " + upMarketOwnMixedRewards
       ; end of added for debugging
       if (updateType = "Own Returns") [
       ifelse (upRewards = [])
         [set meanUp 0]
         [set meanUp mean upRewards]
       ifelse (downRewards = [])
         [set meanDown 0]
         [set meanDown mean downRewards]
       ifelse (meanUp > meanDown) 
         [set currentBaseValue currentBaseValue + epsilon]
         [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))]
         ] ; end of if (updateType = "Own Returns")

       if (updateType = "Market Returns") [
         ifelse (marketUpRewards = [])
           [set meanUp 0]
           [set meanUp mean marketUpRewards]
         ; oops! this looks like a bug!! 2007-5-25: ifelse (downRewards = [])
         ; should be: It is a bug. But it didn't make much difference.
         ifelse (marketDownRewards = [])
           [set meanDown 0]
           [set meanDown mean marketDownRewards]
         ifelse (meanUp > meanDown) 
           [set currentBaseValue currentBaseValue + epsilon]
           [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
         ] ; end of if (updateType = "Market Returns")

       if (updateType = "Market Prices") [
         ifelse (pricesUp = [])
           [set meanUp 0]
           [set meanUp mean pricesUp]
         ifelse (pricesDown = [])
           [set meanDown 0]
           [set meanDown mean pricesDown]
         ifelse (meanUp > meanDown) 
           [set currentBaseValue currentBaseValue + epsilon]
           [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
         ] ; end of if (updateType = "Market Prices")

       if (updateType = "Market P*Q") [
         ifelse (PQUp = [])
           [set meanUp 0]
           [set meanUp mean PQUp]
         ifelse (PQDown = [])
           [set meanDown 0]
           [set meanDown mean PQDown]
         ifelse (meanUp > meanDown) 
           [set currentBaseValue currentBaseValue + epsilon]
           [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
         ] ; end of if (updateType = "Market P*Q")
         
       if (updateType = "Market Returns, Constrained by Own Returns") [
         let referenceLevel 0
         let tolerance 0
         if (referenceBidGroup = "All bids")
           [set referenceLevel mean marketEpochBids
            set tolerance epsilon]
         if (referenceBidGroup = "Upper quartile of bids")
           [set referenceLevel mean UpperQuartile(marketEpochBids)
            set tolerance delta]       
         ifelse (mean myEpochBids + tolerance <= referenceLevel) 
           [set currentBaseValue currentBaseValue + epsilon]  
           [ ; else, I'm ok so I play the good citizen
            ifelse (marketUpRewards = [])
             [set meanUp 0]
             [set meanUp mean marketUpRewards]
            ifelse (downRewards = [])
             [set meanDown 0]
             [set meanDown mean marketDownRewards]
            ifelse (meanUp > meanDown) 
             [set currentBaseValue currentBaseValue + epsilon]
             [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
            ] ; end of else in ifelse (mean myEpochBids...
         ] ; end of if (updateType = "Market Returns and Own Returns")

       if (updateType = "Market Prices and Own Returns") [
         ifelse ((mean myEpochBids) + epsilon <= mean marketEpochBids) 
           [set currentBaseValue currentBaseValue + epsilon]  
           [ ; else, I'm ok so I play the good citizen
            ifelse (pricesUp = [])
             [set meanUp 0]
             [set meanUp mean pricesUp]
            ifelse (pricesDown = [])
             [set meanDown 0]
             [set meanDown mean pricesDown]
             ;print "meanUp = " + meanUp + " meanDown = " + meanDown
            ifelse (meanUp > meanDown) 
             [set currentBaseValue currentBaseValue + epsilon]
             [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
            ] ; end of else in ifelse (mean myEpochBids...
         ] ; end of if (updateType = "Market Prices and Own Returns")

       if (updateType = "Market Prices and Own Returns") [
         ifelse ((mean myEpochBids) + epsilon <= mean marketEpochBids) 
           [set currentBaseValue currentBaseValue + epsilon]  
           [ ; else, I'm ok so I play the good citizen
            ifelse (PQUp = [])
             [set meanUp 0]
             [set meanUp mean PQUp]
            ifelse (PQDown = [])
             [set meanDown 0]
             [set meanDown mean PQDown]
            ifelse (meanUp > meanDown) 
             [set currentBaseValue currentBaseValue + epsilon]
             [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
            ] ; end of else in ifelse (mean myEpochBids...
         ] ; end of if (updateType = "Market Prices and Own Returns")
 
        if (updateType = "Mixture of Market and Own Returns") [
            ifelse (upMarketOwnMixedRewards = [])
             [set meanUp 0]
             [set meanUp mean upMarketOwnMixedRewards]
            ifelse (downMarketOwnMixedRewards = [])
             [set meanDown 0]
             [set meanDown mean downMarketOwnMixedRewards]
            ifelse (meanUp > meanDown) 
             [set currentBaseValue currentBaseValue + epsilon]
             [set currentBaseValue max (list epsilon (currentBaseValue - epsilon))] 
         ] ; end of if (updateType = "Mixture of Market Own Returns")
         
       set upRewards []
       set downRewards []
       set marketUpRewards []
       set marketDownRewards []
       set pricesUp []
       set pricesDown []
       set PQUp []
       set PQDown []
       set upMarketOwnMixedRewards []
       set downMarketOwnMixedRewards []
       set marketEpochBids []
       set myEpochBids []
       set episodeCount 0
      ] ; of if episodeCount >= epochLength
   ] ; end of if is-pAndA?
end ; of postpare-episode

to Plot-Bids
  set-current-plot "Individual Bids"
  set-current-plot-pen "Agent0"
  plot [currentbasevalue] of panda 0 
  if (numPandAFirms > 1)
    [set-current-plot-pen "Agent1"
     plot [currentbasevalue] of panda 1] 
  if (numPandAFirms > 2)
    [set-current-plot-pen "Agent2"
     plot [currentbasevalue] of panda 2] 
  if (numPandAFirms > 3)
    [set-current-plot-pen "Agent3"
     plot [currentbasevalue] of panda 3] 
  if (numPandAFirms > 4)
    [set-current-plot-pen "Agent4"
     plot [currentbasevalue] of panda 4
     ] 
  if (numPandAFirms > 5)
    [set-current-plot-pen "Agent5"
     plot [currentbasevalue] of panda 5
     ] 
  if (numPandAFirms > 6)
    [set-current-plot-pen "Agent6"
     plot [currentbasevalue] of panda 6
     ] 
  if (numPandAFirms > 7)
    [set-current-plot-pen "Agent7"
     plot [currentbasevalue] of panda 7
     ] 
  if (numPandAFirms > 8)
    [set-current-plot-pen "Agent8"
     plot [currentbasevalue] of panda 8
     ] 
  if (numPandAFirms > 9)
    [set-current-plot-pen "Agent9"
     plot [currentbasevalue] of panda 9
     ] 
end ; of Plot-Bids

to Plot-Average-Rewards
  set-current-plot "Average Rewards"
  set-current-plot-pen "Agent0"
  let daAvg ([totalReward] of panda 0 / episodeAbsoluteCount)
  plot daAvg
  if (numPandAFirms > 1)
    [set-current-plot-pen "Agent1"
     set daAvg ([totalReward] of panda 1 / episodeAbsoluteCount)
     plot daAvg] 
  if (numPandAFirms > 2)
    [set-current-plot-pen "Agent2"
     set daAvg ([totalReward] of panda 2 / episodeAbsoluteCount)
     plot daAvg] 
  if (numPandAFirms > 3)
    [set-current-plot-pen "Agent3"
     set daAvg ([totalReward] of panda 3 / episodeAbsoluteCount)
     plot daAvg] 
  if (numPandAFirms > 4)
    [set-current-plot-pen "Agent4"
     set daAvg ([totalReward] of panda 4 / episodeAbsoluteCount)
     plot daAvg
     ] 
  if (numPandAFirms > 5)
    [set-current-plot-pen "Agent5"
     set daAvg ([totalReward] of panda 5 / episodeAbsoluteCount)
     plot daAvg
     ] 
  if (numPandAFirms > 6)
    [set-current-plot-pen "Agent6"
     set daAvg ([totalReward] of panda 6 / episodeAbsoluteCount)
     plot daAvg
     ] 
  if (numPandAFirms > 7)
    [set-current-plot-pen "Agent7"
     set daAvg ([totalReward] of panda 7 / episodeAbsoluteCount)
     plot daAvg
     ] 
  if (numPandAFirms > 8)
    [set-current-plot-pen "Agent8"
     set daAvg ([totalReward] of panda 8 / episodeAbsoluteCount)
     plot daAvg
     ] 
  if (numPandAFirms > 9)
    [set-current-plot-pen "Agent9"
     set daAvg ([totalReward] of panda 9 / episodeAbsoluteCount)
     plot daAvg
     ] 
end ; of Plot-Average-Rewards

to Plot-Quantities [daMonopoly daTotalBid]
  set-current-plot "Quantities Bid"
  set-current-plot-pen "Total Quantity Bid"
  plot daTotalBid
  ;set-current-plot-pen "Monopoly Quantity"
  ;plot daMonopoly
  ;set competitiveQuantity priceIntercept / dSlope 
  set-current-plot-pen "Competitive Quantity"
  plot competitiveQuantity
  ; set cournotQuantity (numPandAFirms * priceIntercept - totalUnitProductionCost) / ((numPandAFirms + 1) * dSlope) 
  set-current-plot-pen "Cournot Quantity"
  plot cournotQuantity
  set-current-plot-pen "Monopoly Q, Firm(s) 1"
  if (numPandAFirms > 1)
    [set monopolyQFirm1 ((priceIntercept - [unitProductionCost] of pAndA 1) / (2 * dSlope))
     plot monopolyQFirm1] 
  set-current-plot-pen "Monopoly Q, Firm 0"
  set monopolyQFirm0 ((priceIntercept - [unitProductionCost] of pAndA 0) / (2 * dSlope))
  plot monopolyQFirm0
  set-current-plot-pen "Monopoly Quantity"
  plot daMonopoly
end ; of Plot-Quantities

to Observe-and-Record [price quantity]
  if (is-pAndA? self) [
    let reward (price * quantityBid) - (unitProductionCost * quantityBid)
    let mixedReward (1 - marketOwnMixture) * reward + (marketOwnMixture * (marketTotalReward )  / numPandAFirms)
    ;print reward + " " + mixedReward + " " + marketTotalReward
    set totalReward totalReward + reward
    ifelse (quantityBid >= currentBaseValue)
      [set upRewards lput reward upRewards
       ;set pricesDown lput 0 pricesDown
       set pricesUp lput price pricesUp
       set PQUp lput (price * quantity) PQUp]
      [set downRewards lput reward downRewards
       ;set pricesUp lput 0 pricesUp
       set pricesDown lput price pricesDown
       set PQDown lput (price * quantity) PQDown]
    ifelse (quantityBid >= currentBaseValue)
      [set marketUpRewards lput marketTotalReward marketUpRewards
       set upMarketOwnMixedRewards lput mixedReward upMarketOwnMixedRewards]
      [set marketDownRewards lput marketTotalReward marketDownRewards
       set downMarketOwnMixedRewards  lput mixedReward downMarketOwnMixedRewards]
   ] ; end of if is-pAndA?
end ; of observe-and-record

to Set-QuantityBid
 if (is-pAndA? self) [
  set quantityBid max (list 0 ((random-float 2 * delta) - delta + currentBaseValue))
  set episodeCount episodeCount + 1
  set myEpochBids lput quantityBid myEpochBids ; record my bid in the epoch record
 ]
end ; of Set-QuantityBid

to PlotInitialDemandCurve
  set-current-plot "Initial Demand Curve"
  set-current-plot-pen "Demand Curve"
  plot-pen-up
  plotxy 0 InitPIntercept
  plot-pen-down
  plotxy InitPIntercept / InitDSlope 0 ; plot to the quantity intercept 
  let InitMonopolyQ m-quantity ; InitPIntercept / 2
  let InitMonopolyP InitPIntercept - dSlope * InitMonopolyQ ;InitPIntercept / (2 * InitDSlope)
  set-current-plot-pen "Monopoly Q"
  plot-pen-up
  plotxy InitMonopolyQ 0
  plot-pen-down
  plotxy InitMonopolyQ InitMonopolyP
  set-current-plot-pen "Monopoly P"
  plot-pen-up
  plotxy 0 InitMonopolyP
  plot-pen-down
  plotxy InitMonopolyQ InitMonopolyP
end ; of PlotInitialDemandCurve

to-report PriceGivenQuantity [daQuantity]
  let daPrice priceIntercept - dSlope * daQuantity
  report max (list 0 daPrice)
end ; of to-report PriceGivenQuantity

to FindNetReward 
  set netReward 0
  if (is-pAndA? self) [
  set netReward ((CurrentP * quantityBid) - (unitProductionCost * quantityBid))
  set runningAverageReward lput netReward runningAverageReward
   if (length runningAverageReward > runningAvgLength)
    [set runningAverageReward but-first runningAverageReward]
  ]
end ; of FindNetReward

to Update-QuantitiesBid [daBids]
 if (is-pAndA? self) [
  foreach daBids [
  set marketEpochBids lput ? marketEpochBids
  ] ; end of foreach
 ]
end ; of Update-QuantitiesBid

to Setup3PandAFirms
    ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
    ask pAndA 1
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue initialBaseQuantityFirm1
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ]
    ask pAndA 2
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue ((initialBaseQuantityFirm1 + initialBaseQuantityFirm0) / 2)
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
end ; of Setup3PandAFirms

to Setup4PandAFirms
  let increment (initialBaseQuantityFirm1 - initialBaseQuantityFirm0)
    ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
    ask pAndA 1
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue initialBaseQuantityFirm1
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ]
    ask pAndA 2
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue  (initialBaseQuantityFirm1 + increment) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 3
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue  (initialBaseQuantityFirm1 + (2 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    

end ; of Setup4PandAFirms

to Setup5PandAFirms
  let increment (initialBaseQuantityFirm1 - initialBaseQuantityFirm0)
    ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
    ask pAndA 1
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue initialBaseQuantityFirm1
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ]
    ask pAndA 2
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue  (initialBaseQuantityFirm1 + increment) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 3
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue  (initialBaseQuantityFirm1 + (2 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 4
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue  (initialBaseQuantityFirm1 + (3 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 

end ; of Setup5PandAFirms

to Setup10PandAFirms
  let increment (initialBaseQuantityFirm1 - initialBaseQuantityFirm0)
    ask pAndA 0
      [set epsilon epsilonFirm0
       set delta deltaFirm0
       set currentBaseValue initialBaseQuantityFirm0
       set unitProductionCost unitCostFirm0
       set epochLength epochLengthFirm0
       set episodeCount 0
       set updateType updateTypeFirm0
      ]
    ask pAndA 1
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue initialBaseQuantityFirm1
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ]
    ask pAndA 2
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + increment) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 3
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (2 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 4
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (3 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 5
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (4 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 6
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (5 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 7
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (6 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 8
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (7 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
    ask pAndA 9
     [set epsilon epsilonFirm1
     set delta deltaFirm1
     set currentBaseValue (initialBaseQuantityFirm1 + (8 * increment)) 
     set unitProductionCost unitCostFirm1
     set epochLength epochLengthFirm1
     set episodeCount 0
     set updateType updateTypeFirm1
    ] 
end ; of Setup10PandAFirms

to-report UpperQuartile [ aList ]
  if (empty? aList)
   [print "In UpperQuartile reporter. The list is empty."
    let bob 1 / 1]  ; fix this to halt
  let bList reverse sort aList
  ;print bList
  let daQuartileSize int (length aList / 4)
  ;print daQuartileSize
  ifelse (length bList mod 4 = 0)
    [report sublist bList 0 (daQuartileSize)]
    [report sublist bList 0 (daQuartileSize + 1)]
  ;ifelse (daRemainder 

end

to RRepetitions
print "Output coming from the RRepetitions procedure:"
;let daRepetitionCount RepetitionCount
if (file-exists? "oligopolyBidQuantity-repetitions.txt")
  [file-delete "oligopolyBidQuantity-repetitions.txt"]
; Open the parameter sweep file and print the column headers.
; Also print the column headers to the output window
; Then close the parameter sweep file

file-open "oligopolyBidQuantity-repetitions.txt"
file-print "RepetitionCount,runningAverageBid,runningAverageBidSd,ratioOfferedCournot,rPrime,meanRewardFirm0,meanRewardFirm1"
file-close
print "RepetitionCount,runningAverageBid,runningAverageBidSd,ratioOfferedCournot,rPrime,meanRewardFirm0,meanRewardFirm1"
let numFirms numPandAFirms
let runningAverageBidAccumulator []
;let pAndAAccumulator []
let pAndA0Accumulator []
let pAndA1Accumulator []
let pAndA2Accumulator []
let pAndA3Accumulator []
let pAndA4Accumulator []
let pAndA5Accumulator []
let pAndA6Accumulator []
let pAndA7Accumulator []
let pAndA8Accumulator []
let pAndA9Accumulator []
;foreach (n-values NumRepetitions [?])
let RepetitionCount 0
while [RepetitionCount < NumRepetitions]
[
Setup ; (RepetitionCount)
let torun numEpisodesToRun
while [torun > 0]
[go
set torun torun - 1
]
set RepetitionCount RepetitionCount + 1
set RepetitionCounter RepetitionCount
;set rPrime (runningAverageCournot - runningAverageBid) / (runningAverageCournot - runningAverageMonopoly)
file-open "oligopolyBidQuantity-repetitions.txt"
file-print (word RepetitionCount  ","  runningAverageBid  ","  runningAverageBidSD  ","  ratioOfferedCournot  ","  rPrime  ","  mean [runningAverageReward] of pAndA 0  ","  mean [runningAverageReward] of pAndA 1)
file-close
print (word RepetitionCount   ","   runningAverageBid   ","   runningAverageBidSD   ","   ratioOfferedCournot   ","   rPrime    ","   mean [runningAverageReward] of pAndA 0   ","   mean [runningAverageReward] of pAndA 1)
set runningAverageBidAccumulator fput runningAverageBid runningAverageBidAccumulator

; This is really inelegant, but I couldn't get run and runresult to do it for me.
; Could use lists as arrays... well I'm in a hurry and the max is 10
; Actually, to test in the future, I can try creating local agents mirroring
; the panda agents. The local ones won't be zapped by Setup. I tried it doesn't work.
set pAnda0Accumulator fput mean [runningAverageReward] of pAndA 0 pAnda0Accumulator
if (numFirms > 1)
[set pAnda1Accumulator fput mean [runningAverageReward] of pAndA 1 pAnda1Accumulator]
if (numFirms > 2)
[set pAnda2Accumulator fput mean [runningAverageReward] of pAndA 2 pAnda2Accumulator]
if (numFirms > 3)
[set pAnda3Accumulator fput mean [runningAverageReward] of pAndA 3 pAnda3Accumulator]
if (numFirms > 4)
[set pAnda4Accumulator fput mean [runningAverageReward] of pAndA 4 pAnda4Accumulator]
if (numFirms > 5)
[set pAnda5Accumulator fput mean [runningAverageReward] of pAndA 5 pAnda5Accumulator]
if (numFirms > 6)
[set pAnda6Accumulator fput mean [runningAverageReward] of pAndA 6 pAnda6Accumulator]
if (numFirms > 7)
[set pAnda7Accumulator fput mean [runningAverageReward] of pAndA 7 pAnda7Accumulator]
if (numFirms > 8)
[set pAnda8Accumulator fput mean [runningAverageReward] of pAndA 8 pAnda8Accumulator]
if (numFirms > 9)
[set pAnda9Accumulator fput mean [runningAverageReward] of pAndA 9 pAnda9Accumulator]


] ; end of  while
if (RepetitionCounter > 1)
[
print (word "overall mean sd of avg. bid,"   mean runningAverageBidAccumulator   ","   standard-deviation runningAverageBidAccumulator)
print "\\begin{center}"
print "\\begin{tabular}{|r|r|r|}\\hline"
print "Firm & Mean of Running Averages & SD of Running Averages \\\\ \\hline\\hline"
if (numFirms > 0)
[print (word "0 & "   mean pAnda0Accumulator   " & "   standard-deviation pAnda0Accumulator   "\\\\ \\hline")]
if (numFirms > 1)
[print (word "1 & "  mean pAnda1Accumulator  " & "  standard-deviation pAnda1Accumulator  "\\\\ \\hline")]
if (numFirms > 2)
[print (word "2 & "  mean pAnda2Accumulator  " & "  standard-deviation pAnda2Accumulator  "\\\\ \\hline")]
if (numFirms > 3)
[print (word "3 &"  mean pAnda3Accumulator  " & "  standard-deviation pAnda3Accumulator   "\\\\ \\hline")]
if (numFirms > 4)
[print (word "4 & "  mean pAnda4Accumulator  " & "  standard-deviation pAnda4Accumulator  "\\\\ \\hline")]
if (numFirms > 5)
[print (word "5 & "  mean pAnda5Accumulator  " & "  standard-deviation pAnda5Accumulator   "\\\\ \\hline")]
if (numFirms > 6)
[print (word "6 & "  mean pAnda6Accumulator  " & "  standard-deviation pAnda6Accumulator  "\\\\ \\hline")]
if (numFirms > 7)
[print (word "7 & "  mean pAnda7Accumulator  " & "  standard-deviation pAnda7Accumulator  "\\\\ \\hline")]
if (numFirms > 8)
[print (word "8 & "  mean pAnda8Accumulator  " & "  standard-deviation pAnda8Accumulator  "\\\\ \\hline")]
if (numFirms >                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               