extensions [ gis csv ]
globals [ regions-dataset
  regions_ras-dataset ]
breed [ region-labels region-label]
breed [ migrants migrant]
breed [seconds second]
breed [thirds third]
breed [fourths fourth]
breed [fifths fifth]
breed [sixths sixth]
breed [sevenths seven]
patches-own [ region ]
migrants-own [origin destination energy ]





to setup
  clear-all
  ; Note that setting the coordinate system here is optional, as
  ; long as all of your datasets use the same coordinate system.
  ; gis:load-coordinate-system (word "data/" projection ".prj")
  ; Load all of our datasets
  set regions-dataset gis:load-dataset "BFA_adm1_UTM.shp"
  set regions_ras-dataset gis:load-dataset "BFA_adm1_UTM_ascii.asc"
  ; Set the world envelope to the union of all of our dataset's envelopes
  gis:set-world-envelope (gis:envelope-of regions-dataset)
  set-default-shape migrants "people"

  display-regions

  display-raster-in-patches

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; CREATES MIGRANTS ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  create-turtles 1      ;;Boucle de Mouhoun
 [ set xcor -41 set ycor 5    ;; These breeds of turtles, seconds, thirds etc, are used as
     set color red ]          ;; heading anchors that are invisible (same color as pcolor),
                              ;;but allow other turtle to face them and go towards that region xycor

  create-seconds 1
  [ set xcor -60 set ycor -41  ;;Second 14, Cascades
    set color 15  ]

  create-thirds 1               ;; Third 15, EST
  [set xcor 46 set ycor 0
    set color grey ]

  create-fourths 1
  [set xcor 9 set ycor -16      ;; Fourth 16, Center Sud
    set color grey]

  create-fifths 1
  [set xcor -66 set ycor -31   ;;Fifth 17, N Cascades
    set color grey]

  create-sixths 1
  [set xcor 17 set ycor 41 ;; Sixth 18, Sahel
    set color 45]
create-sevenths 1
  [set xcor -57 set ycor -18 ;Seventh 19
    set color 17]

  ask n-of 200 patches [
   ifelse (region = 10) ; Nord
   [sprout-migrants 20]
   [ifelse (region = 1) ; Boucle du Mouhoun
    [sprout-migrants 20]
      [ifelse (region = 2) ; Cascades
        [sprout-migrants 20]
        [ifelse (region = 3) ; Centre
          [sprout-migrants 20]
          [ifelse (region = 4) ; Centre-Est
            [sprout-migrants 20]
            [ifelse (region = 5) ; Centre-Nord
              [sprout-migrants 20]
             [ifelse (region = 6) ; Centre-Ouest
              [sprout-migrants 20]
                [ifelse (region = 7) ; Centre-Sud
                  [sprout-migrants 20]
                  [ifelse (region = 8) ; Est
                    [sprout-migrants 20]
                    [ifelse (region = 9) ; Hauts-Bassins
                      [sprout-migrants 20]
                      [ifelse (region = 11); Plateau Central
                        [sprout-migrants 20]
                        [ifelse (region = 12) ; Sahel
                          [sprout-migrants 20]
                          [ifelse (region = 13) ; Sud-Ouest
                            [sprout-migrants 20]
    [sprout-migrants 0]
  ]]]]]]]]]]]]]

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;;;; COLORS MIGRANTS ;;;;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  ask migrants [
   ifelse (region = 1) ; Boucle du Mohoun
    [ set color 16 set energy 20]
    [ ifelse (region = 2) ; Cascades
      [set color 15 set energy 20]
    [ifelse (region = 3)  ; Centre
        [set color 16.5 set energy 10]
    [ifelse (region = 4)  ; Centre-Est
        [set color 36 set energy 20]
    [ifelse (region = 5) ; Centre-Nord
        [set color 97 set energy 10]
    [ifelse (region = 6) ; Centre-Ouest
        [set color sky set energy 15]
    [ifelse (region = 7)  ; Centre-Sud
        [set color 27 set energy 20]
    [ifelse (region = 8) ; Est
        [set color 47 set energy 20]
    [ifelse (region = 9) ; Hauts-Bassins
        [set color 17 set energy 100]
    [ifelse (region = 10) ; Nord
        [set color blue set energy 40]
    [ifelse (region = 11) ; Plateau Central
        [set color 37 set energy 20]
    [ifelse (region = 12) ; Sahel
        [set color yellow set energy 160]
    [ifelse (region = 13) ; Sud-Ouest
        [set color 38 set energy 20]
    [ set color gray ]
                          ]
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ]


  reset-ticks
end

; Drawing polygon data from a shapefile, and optionally loading some
; of the data into turtles, if label-countries is true
to display-regions
  ask region-labels [ die ]
  gis:set-drawing-color white
  gis:draw regions-dataset 1
  if label-regions
  [ foreach gis:feature-list-of regions-dataset [ vector-feature ->
      let centroid gis:location-of gis:centroid-of vector-feature
      ; centroid will be an empty list if it lies outside the bounds
      ; of the current NetLogo world, as defined by our current GIS
      ; coordinate transformation
      if not empty? centroid
      [ create-region-labels 1
        [ set xcor item 0 centroid
          set ycor item 1 centroid
          set size 0
          set label gis:property-value vector-feature "ADM1"
        ]
      ]
    ]
  ]
end

to display-raster-in-patches
  ; This is the preferred way of copying values from a raster dataset
  ; into a patch variable: in one step, using gis:apply-raster.
 gis:apply-raster regions_ras-dataset region
  ; Hopefully, this will color the patches accordingly
 ask patches [
    ifelse (region = 1) ; Boucle du Mohoun
    [ set pcolor 16]
    [ ifelse (region = 2) ; Cascades
      [set pcolor 15]
    [ifelse (region = 3)  ; Centre
        [set pcolor 16.5]
    [ifelse (region = 4)  ; Centre-Est
        [set pcolor 36]
    [ifelse (region = 5) ; Centre-Nord
        [set pcolor 97]
    [ifelse (region = 6) ; Centre-Ouest
        [set pcolor sky]
    [ifelse (region = 7)  ; Centre-Sud
        [set pcolor 27]
    [ifelse (region = 8) ; Est
        [set pcolor 47]
    [ifelse (region = 9) ; Hauts-Bassins
        [set pcolor 17]
    [ifelse (region = 10) ; Nord
        [set pcolor blue]
    [ifelse (region = 11) ; Plateau Central
        [set pcolor 37]
    [ifelse (region = 12) ; Sahel
        [set pcolor yellow]
    [ifelse (region = 13) ; Sud-Ouest
        [set pcolor 29]
    [ set pcolor gray ]
                          ]
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ]
  ;give-energy
end

;to assign-origin ; Hopefully, this assigns an origin and MAYBE destination to migrants along
  ; with energy
 ; ask migrants [
   ; ifelse (region = 10)
    ;[ set origin 10
   ;   set energy 100
    ;  set destination





;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; 1975 ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to year-1975

  ask migrants with [color = blue][
    face turtle 13 ]
  check-arrival
  move-1975
  out-flow-1 ; Nord towards Boucle de Mouhoun

  ask migrants with [color = 95]
    [face turtle 13]  ; Centre Ouest to B de M
 check-arrival
 move-1975
  out-flow-1
; check-settled

ask migrants with [color = 27]
    [face third 15]
  check-arrival
  move-1975
  out-flow-1

   ask migrants with [color = 97]
  [face sixth 18]
    check-arrival
    move-1975
    out-flow-1

  tick
  if ticks = 150 [ stop ] ;;specify when to stop model after migration occurs!
end


 ;to check-settled ;force turtles to stay in place


 ; end
to check-arrival ;changes the path color of the region to a mixed color
  ask patches with [ pcolor = 16  ]
  [if any? migrants-here with [color = blue] [set pcolor 113] ]
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = blue] [set pcolor 117 ] ]
  ask patches with [pcolor = yellow]
  [if any? migrants-here with [color = blue] [set pcolor 57] ]
  ask patches with [pcolor = 16]
  [if any? migrants-here with [color = 95] [set pcolor 113]]
  ask patches with [pcolor = 47]
    [if any? migrants-here with [color = 27] [set pcolor 16] ]
  ask patches with [pcolor = 45]
  [if any? migrants-here with [color = 97 ] [set pcolor 66 ] ]

   ;supposed to change patches nearby to new color as well similar to diffuse color
    ;set pcolor violet]

end
to move-1975
  ask migrants with [color = blue]
    [rt random 90
    lt random 80
      fd 1
      if any? turtles-here [rt 180] ];;makes the turtles say relatively within the coutry by making them turn


  ask migrants with [color = 95]
    [ rt random 90
      lt random 80
      fd 1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 27]
    [ rt random 90
      lt random 80
      fd 1
      if any? turtles-here [rt 180] ]

  ask migrants with [color = 97]
  [rt random 90
  lt random 80
    fd .5
    if any? turtles-here [rt 180] ]

end

to out-flow-1 ;;OUT MIGRATION
  ask patches with [pcolor = 95] [
    if any? migrants-here with [color = 95] [set pcolor 96] ] ;changes centre ouest lighter
  ask patches with [pcolor = blue] [
    if any? migrants-here with [color = blue] [set pcolor 106] ] ;changes Nord lighter
  ask patches with [pcolor = 97] [
    if any? migrants-here with [color = 97] [set pcolor 98] ] ;changes centre nord lighter from out migration
  ask patches with [pcolor = 27] [
    if any? migrants-here with [color = 27] [set pcolor 28] ] ; lighter centre sud
end
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; 1985 ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to year-1985

  ask migrants with [color = blue] ; Nord to Cascades/ HB region
  [face fifth 17]
  check-arrival-1
  move-1985
  out-flow-2

  ask migrants with [color = 97] ; Centre Nord to Boucle de Mouhoun
   [face turtle 13]
 check-arrival-1
 move-1985
 out-flow-2

  ask migrants with [color = 95] ;;
  [face fifth 17]
  check-arrival-1
  move-1985
  out-flow-2
  ask migrants with [color = 27]
  [face third 15]
  check-arrival-1
  move-1985
  out-flow-2

  tick
  if ticks = 200 [stop]
end

to check-arrival-1
   ask patches with [ pcolor = 16  ]
  [if any? migrants-here with [color = blue] [set pcolor violet] ] ;Nord to Boucle de Mouhoun
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = blue] [set pcolor 113 ] ] ;Nord to Hauts Bassins
  ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = blue] [set pcolor 113] ] ;Nord to Centre
 ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = 97] [set pcolor 115] ]
  ask patches with [pcolor = 15]
  [if any? migrants-here with [color = blue] [set pcolor 113] ] ;Nord to Cascades
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = blue] [set pcolor 57] ] ;Nord to Est
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 97] [set pcolor 113]]
  ask patches with [pcolor = 95]
  [if any? migrants-here with [color = 97] [set pcolor 94]]
  ask patches with [pcolor = 15] [
    if any? migrants-here with [color = 95] [set pcolor 113]] ;centre nord to N. Cascades
 ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = 95] [set pcolor 115] ] ;centre nord to HB
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = 97] [set pcolor 57] ];Centre Nord to Est
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 95] [set pcolor 113]]
  ask patches with [pcolor = 16] [
    if any? migrants-here with [color = 95] [set pcolor 115]]
  ask patches with [pcolor = 47] [
    if any? migrants-here with [color = 27][ set pcolor 16]]

   ;supposed to change patches nearby to new color as well similar to diffuse color
    ;set pcolor violet]
end

to move-1985
  ask migrants with [color = blue]
    [ rt random 90
      lt random 80
      fd 1.2
     if any? turtles-here [rt 180] ]


  ask migrants with [color = 95]
     [ rt random 50
      lt random 100
      fd .5
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 97]
     [ rt random 80
      lt random 70
      fd 1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 27]
     [ rt random 70
      lt random 80
      fd 1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 36]
  [ rt random 70
      lt random 80
      fd 1
     if any? turtles-here [rt 180] ]


end

to out-flow-2
  ;ask patches with [pcolor = 95] [
  ;  if any? migrants-here with [color = 95] [set pcolor 96] ] ;changes centre ouest lighter
  ask patches with [pcolor = blue] [
    if any? migrants-here with [color = blue] [set pcolor 106] ] ;changes Nord lighter
  ask patches with [pcolor = 97] [
    if any? migrants-here with [color = 97] [set pcolor 98] ] ;changes centre nord lighter from out migration
  ask patches with [pcolor = 27] [
    if any? migrants-here with [color = 27] [set pcolor 28] ] ; lighter centre sud
end
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; 1996 ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to year-1996
 ask migrants with [color = blue]
  [face second 14] ;N Towards Cascades and Hauts Bassins Centre Sud
  check-arrival-2
  move-1996
  out-flow-3
; check-settled ]

  ask migrants with [color = 97]
  [ face third 15]
 check-arrival-2
 move-1996
 out-flow-3

  ask migrants with [color = 38]
  [face fourth 16]                      ;; to centre sud
  check-arrival-2
  move-1996
  out-flow-3
  ask migrants with [color = 45]
  [face fifth 17 ]
  check-arrival-2
  move-1996
  out-flow-3

   ask migrants with [color = 36]
  [face fourth 16 ]
  check-arrival-2
  move-1996
  out-flow-3

  tick
  if ticks = 160 [stop]


end

to check-arrival-2
  ask patches with [pcolor = 15]
  [if any? migrants-here with [color = blue] [set pcolor 113]]
   ask patches with [pcolor = 15]
  [if any? migrants-here with [color = 97] [set pcolor 113]] ; CASCADES color change influx
  ask patches with [pcolor = 15] [
    if any? migrants-here with [color = 45][set pcolor 113]]

  ask patches with [pcolor = 16] [
    if any? migrants-here with [pcolor = blue][set pcolor 115]] ; BDM color change influx
  ask patches with [pcolor = 16] [
    if any? migrants-here with [pcolor = 97][set pcolor 115]]
   ask patches with [ pcolor = 16  ]
  [if any? migrants-here with [color = blue] [set pcolor 117]]
  ask patches with [pcolor = 16]
  [if any? migrants-here with [color = blue] [set pcolor 117] ]
  ask patches with [pcolor = 16]
  [if any? migrants-here with [color = 45] [set pcolor 117] ]

  ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = blue] [set pcolor 113]] ;Centre change
  ask patches with [pcolor = 16.5] [
  if any? migrants-here with [color = 38] [set pcolor 113]]
ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = 45] [set pcolor 113] ]

  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = blue] [set pcolor 113 ] ]
  ask patches with [pcolor = 17]                                    ;HB color change
  [if any? migrants-here with [color = 97] [set pcolor 113]]
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 95] [set pcolor 113]]
  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 45] [set pcolor 113] ]


  ask patches with [pcolor = 27] [
    if any? migrants-here with [color = 38][set pcolor 113]]


  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = blue] [set pcolor lime]]
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = 95] [set pcolor lime]]
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = 97] [set pcolor lime]]


  ask patches with [pcolor = 95]
  [if any? migrants-here with [color = 97] [set pcolor 94]]
  ask patches with [pcolor = 95]
  [if any? migrants-here with [color = blue] [set pcolor 94] ]

  ask patches with [pcolor = 37][
    if any? migrants-here with [color = 38][set pcolor 113]]
  ask patches with [pcolor = 37]
  [if any? migrants-here with [color = 45] [set pcolor 113] ]


ask patches with [pcolor = 27][
    if any? migrants-here with [color = 36][set pcolor 113]]
end

to move-1996
  ask migrants with [color = blue] ;N to HB and Cascades highest influx
     [ rt random 90
      lt random 60
      fd 1.1
     if any? turtles-here [rt 180] ]


  ask migrants with [color = 97]
    [ rt random 90
      lt random 80
      fd .4
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 45]
  [ lt random 20 rt random 35 fd .2]

ask migrants with [color = 38]
  [ lt random 80
    rt random 30
    fd .2 ]

  ask migrants with [color = 36] ;S
  [ lt random 60
    rt random 80
    fd .1 ]



end

to out-flow-3

  ask patches with [pcolor = blue] [                 ;;Out flux from north
    if any? migrants-here with [color = blue] [set pcolor 106]]

    ask patches with [pcolor = 45] [                 ;;Out flux from sahel
    if any? migrants-here with [color = 45] [set pcolor 46]]

  ask patches with [pcolor = 36] [
    if any? migrants-here with [color = 36][set pcolor 38]]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; 2006 ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

  to year-2006
  ask migrants with [color = blue] ; Nord to Cascades/ HB region
  [face fourth 16]
   check-arrival-3
  move-1985
 out-flow-4

  ask migrants with [color = 97] ;
    [face second 14]
 check-arrival-3
 move-2006
 out-flow-4


  ask migrants with [color = 95]
 [face third 15]
    check-arrival-3
    move-2006
  out-flow-4

  ask migrants with [color = 38]
  [face fifth 17]
  check-arrival-3
  move-2006
out-flow-4

  ask migrants with [color = 36]
  [face fifth 17]
  check-arrival-3
  move-2006
out-flow-4

   ask migrants with [color = 16]
  [face fifth 17]
  check-arrival-3
  move-2006
  out-flow-4

 ask migrants with [color = 45]
  [face fifth 17]
  check-arrival-3
  move-2006
  out-flow-4


  tick
  if ticks = 150 [stop]
end

to check-arrival-3
  ; ask patches with [ pcolor = 16  ]
  ;[if any? migrants-here with [color = blue] [set pcolor violet] ] ;Nord to Boucle de Mouhoun
   ask patches with [pcolor = 15]
  [if any? migrants-here with [color = 95] [set pcolor 113]]
  ask patches with [pcolor = 15]
  [if any? migrants-here with [color = 97] [set pcolor 113]]
  ask patches with [pcolor = 15]
  [if any? migrants-here with [color = blue] [set pcolor 113]]
  ask patches with [pcolor = 15]
  [if any? migrants-here with [color = 38] [set pcolor 113]]

  ask patches with [pcolor = 16.5]
  [if any? migrants-here with [color = blue] [set pcolor 113] ] ;Nord to Centre

  ask patches with [pcolor = 17]
  [if any? migrants-here with [color = blue] [set pcolor 113 ] ] ;Nord to Hauts Bassins
   ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 97] [set pcolor 113]]
   ask patches with [pcolor = 17]
  [if any? migrants-here with [color = 36 ] [set pcolor 113]]



  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = blue] [set pcolor lime] ] ;Nord to Est
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = 97] [set pcolor lime]]
  ask patches with [pcolor = 47]
  [if any? migrants-here with [color = 95] [set pcolor lime]]

  ask patches with [pcolor = 27]
  [if any? migrants-here with [color = blue] [ set pcolor 132]]



end

to move-2006
  ask migrants with [color = blue]
     [ rt random 40
      lt random 100
      fd .1
     if any? turtles-here [rt 180] ]


  ask migrants with [color = 97]
    [ rt random 90
      lt random 60
      fd 1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 95]
    [ rt random 90
      lt random 60
      fd .1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 38]
  [ rt random 90
      lt random 60
      fd 1
     if any? turtles-here [rt 180] ]

   ask migrants with [color = 36] ; to N cascades
  [ rt random 70
      lt random 60
      fd 1
     if any? turtles-here [rt 180] ]

  ask migrants with [color = 45]
   [ rt random 50
      lt random 30
      fd 1
     if any? turtles-here [rt 180] ]


end

to out-flow-4
  ask patches with [pcolor = 37]
  [if any? migrants-here with [color = 37] [set pcolor 38]]

  ask patches with [pcolor = 16]
  [if any? migrants-here with [color = 16][set pcolor 17]]

  ask patches with [pcolor = 45]
  [if any? migrants-here with [color = 45][set pcolor 46]]

  ask patches with [pcolor = 29]
 [if any? migrants-here with [color = 38][set pcolor 9]]

end


; Public Domain: Creation by C.T. West & J.L. Deview of the University of North Carolina at Chapel Hill
; Information from C. T. West's research in Burkina Faso and census data.
@#$#@#$#@
GRAPHICS-WINDOW
185
10
797
455
-1
-1
4.0
1
8
1
1
1
0
0
0
1
-75
75
-54
54
0
0
1
ticks
30.0

SWITCH
6
297
176
330
label-regions
label-regions
0
1
-1000

BUTTON
2
334
182
367
NIL
clear-drawing
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
5
60
175
93
NIL
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
96
131
129
NIL
year-1975
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
136
131
169
NIL
year-1985
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
177
131
210
NIL
year-1996
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
216
131
249
NIL
year-2006
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model was built to test and demonstrate the functionality of the GIS NetLogo extension. In particular it visualizes census data of migration flows for Burkina Faso between regions during 1975, 1985, 1996 and 2006.

## HOW IT WORKS

This model loads two different GIS datasets: raster data of the country's regions and vector data of the regions' borders, and labels for each region (in French). It demostrates the ability to use maps and visualizations to give a better understanding of migration concepts with the use of Netlogo and the information brought in from ArcMap 10.8. 

Specifically this model implements the procedure "display-raster-in-patches," which uses the NetLogo GIS extension apply raster. This applies the region number to individual patches. Also this model implements the procedure draw to visualize the region boundaries using vector data.The gis:location-of and gis:centroid-of GIS extensions were used to display labels.

The breeds within the model represent destination patches within regions for the migrants and give the migrants a heading toward one of the breeds. These migrants sprout from their origin region and have the same color as their region of origin. These breeds (headings) change depending on the year. 

The procedure "check-arrival" works as follows. As migrants move, the patches within a specified destination region's color will mix with the origin region color of the migrant. For example, the blue (Nord) migrant goes to a red (Boucle du Mouhoun) destination region then the patches will turn purple. Depending on the census migration data, if incoming migration is higher, the shade will be darker. This is done by asking the patches to change color when a migrant of a specific origin region color comes into contact with it. As an example, blue migrants moving to yellow destination regions (Est) make the patches green.

WARNING ***This model needs to have two files for the GIS extension to work properly. The files, BFA_adm1_UTM.shp and BFA_adm1_UTM_ascii.asc files, must also be saved in a folder labeled "data" together in order for the path to work and for NetLogo to pull the information into the model.
## HOW TO USE IT

Select "setup" from the menu, then click the chosen year. If you want to see another year, make sure to repress the button of the year you are looking at to stop the model and then press setup to start it over, then press the new year.
## THINGS TO TRY
Try finding patterns of migration in each year. What regions have the most incoming migrants? See if the patterns continue or change over time and how they change. 


## EXTENDING THE MODEL

This model interestingly shows accurate data patterns from these time periods about the movement patterns of migration. You can easily borrow code from the Code tab to create future patterns for Burkina Faso or put it into a new model that uses your own data to replicate the process for another country's migration fluxuations. 

## RELATED MODELS

GIS General Example provides another example of how to use the GIS extension but does not include moving agents, only the GIS aspect of Netlogo.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

people
false
0
Polygon -1 true false 101 90 104 78 124 77 198 77 244 145 105 85
Polygon -1 true false 184 181 219 287 169 298 163 298 161 298 145 229 182 186
Polygon -1 true false 116 184 84 283 83 286 139 297 154 227 118 198
Polygon -1 true false 195 84 248 149 230 188 194 145 196 85
Polygon -1 true false 109 143 115 199 185 195 193 143 105 145
Polygon -1 true false 107 120 65 175 71 191 112 145 107 121 103 135
Polygon -1 true false 102 80 50 146 68 179 69 182 108 141 104 82 102 81
Rectangle -1 true false 105 85 200 148
Rectangle -1 true false 120 75 180 90
Circle -1 true false 105 0 90
Circle -1 false false 105 0 90
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 84 120 189 90 279 105 294 135 294 150 219 165 294 195 294 210 279 180 189 195 84
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 84 240 144 225 174 165 99
Polygon -7500403 true true 106 85 61 145 76 175 136 100
Line -1 false 135 90 135 90
Polygon -1 true false 81 145 81 140

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
setup
display-cities
display-countries
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
