breed [HAs HA]
breed [A-s A-]
breed [Bs B]
breed [BHs BH]
breed [H3OS H30]
breed [OHs OH]
breed [legends legend]

turtles-own[ ]
globals [Starting-pH
  kb ka
  Num-H-l Num-H-r
  Num-OH-l Num-OH-r
  num-B-l num-B-r
  num-BH-l num-BH-r
  num-HA-l num-HA-r
  num-A-l num-A-r
  vol-1-l vol-1-r
  vol-titrant-l vol-titrant-r
  current-conc-H-l current-conc-H-r
  current-conc-OH-l current-conc-OH-r
  current-conc-B-l current-conc-B-r
  current-conc-BH-l current-conc-BH-r
  current-conc-A-l current-conc-A-r
  current-conc-HA-l current-conc-HA-r
  current-ph-l current-ph-r
  current-pOH-l current-pOH-r
  M-H-l M-H-r
  M-T-l M-T-r
  M-OH-l M-OH-r
  M-BH-l M-BH-r
  M-B-l M-B-r
  M-B-1-l M-B-1-r
  M-HA-l M-HA-r
  M-HA-1-l M-HA-1-r
  M-A-l M-A-r
  unit-num-b
  unit-num-ha
]



;;;;;;;;;;;;;;;;;;;;;;;;;
;;                     ;;
;;  Setup procedures   ;;
;;                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  (ifelse
    Choose-a-test = "Strong Acid and Acidic Buffer"
    [ ca
      set-shapes
      set-bk
      set Starting-pH 3
      set-legends-a
      set-HCl
      set-acetic-acid]


    Choose-a-test = "Strong Base and Alkaline Buffer"
      [ca
       set-shapes
       set-bk
       set Starting-pH 11
       set-legends-b
       set-NaOH
        set-NH3])

  reset-ticks
end

to set-shapes
  set-default-shape ohs "ab-oh-1"
  set-default-shape h3os "ab-h3o-1"
  set-default-shape has "ab-ha-1"
  set-default-shape a-s "ab-ha-2"
  set-default-shape bs "ab-b-1"
  set-default-shape bhs "ab-b-2"
end

to set-bk
  ask patches [set pcolor 91.5 + random-float 0.5]
  ask patches with [ pycor >= max-pycor - 1 or pycor < 3] [set pcolor 101]
  ask patches with [ pxcor = max-pxcor or pxcor = min-pxcor] [set pcolor 101]
  ask patches with [ pxcor = 33 or pxcor = 34 or pxcor = 35] [set pcolor 101]
end

to set-tt-properties-l
   set size 1.25
   setxy 1 + random-float 31 4 + random-float (max-pycor - 7)
end

to set-tt-properties-r
   set size 1.25
   setxy 36 + random-float 31 4 + random-float (max-pycor - 7)
end

to set-legends-a
  create-legends 10

 ask legend 0
  [set shape "ab-h3o-1"
    set size 1.75
    setxy 12.5 1]

  ask legend 1
  [set shape "blank"
    set size 1.5
    set label "Hydronium (H3O+)"
    set label-color white
    setxy 22 1.3]

  ask legend 2
   [set shape "ab-OH-1"
    set size 1.75
    set color 85
    setxy 25 1]

  ask legend 3
  [set shape "blank"
    set size 1.5
    set label "Hydroxide (OH-)"
    set label-color white
    setxy 33 1.3]

  ask legend 4
   [set shape "ab-ha-1"
    set size 1.75
    set color 116.5
    setxy 36.5 1]

  ask legend 5
  [set shape "blank"
    set size 1.5
    set label "Acid molecule"
    set label-color white
    setxy 43.8 1.3]

  ask legend 6
   [set shape "ab-ha-2"
    set size 1.75
    set color 113.5
    setxy 47.5 1]

  ask legend 7
  [set shape "blank"
    set size 1.5
    set label "Conjugate base"
    set label-color white
    setxy 55.5 1.3]

  ask legend 8
  [set shape "blank"
    set size 3
    set label "Hydrocloric Acid (HCl)"
    set label-color white
    setxy 19.5 36.5]

  ask legend 9
  [set shape "blank"
    set size 3
    set label "Acetic acid/Acetate Buffer (CH3COOH/CH3COO-)"
    set label-color white
    setxy 62 36.5]

end

to set-legends-b
  create-legends 10

 ask legend 0
  [set shape "ab-h3o-1"
    set size 1.75
    setxy 13.5 1]

  ask legend 1
  [set shape "blank"
    set size 1.5
    set label "Hydronium (H3O+)"
    set label-color white
    setxy 22 1.3]

  ask legend 2
   [set shape "ab-OH-1"
    set size 1.75
    set color 85
    setxy 25.5 1]

  ask legend 3
  [set shape "blank"
    set size 1.5
    set label "Hydroxide (OH-)"
    set label-color white
    setxy 33 1.3]

  ask legend 4
   [set shape "ab-b-1"
    set size 1.75
    set color 42.5
    setxy 36.5 1]

  ask legend 5
  [set shape "blank"
    set size 1.5
    set label "Base molecule"
    set label-color white
    setxy 43.5 1.3]

  ask legend 6
   [set shape "ab-b-2"
    set size 1.75
    set color 62.5
    setxy 47.5 1]

  ask legend 7
  [set shape "blank"
    set size 1.5
    set label "Conjugate acid"
    set label-color white
    setxy 55 1.3]

  ask legend 8
  [set shape "blank"
    set size 3
    set label "Sodium Hydroxide (NaOH)"
    set label-color white
    setxy 20 36.5]

  ask legend 9
  [set shape "blank"
    set size 3
    set label "Ammonia-Ammonium Chloride Buffer (NH3/NH4+)"
    set label-color white
    setxy 62 36.5]

end

to set-HCl

  set vol-1-l 100
  set vol-titrant-l 0
  set current-conc-H-l 10 ^ (- Starting-pH)                  ;starting ph of hcl is 3.5
  set current-ph-l Starting-pH
  set M-H-l current-conc-H-l * vol-1-l * 0.001          ;determine the mole of H+
  set M-A-l M-H-l
  set M-HA-l M-H-l
  set current-conc-A-l (M-A-l / (vol-1-l * 0.001))  ;determine initial HA concentration
  set current-conc-HA-l 0                       ;there is no HA
  set current-Conc-OH-l 10 ^ (-14) / current-conc-H-l          ;calculate the concentration of OH-
  set M-OH-l current-Conc-OH-l * vol-1-l * 0.001                 ;calculate exisitng mole of OH-



  set num-H-l round (1000 * (1.3895 ^ (-1 * current-ph-l)))     ;find the amount of visual H+
  set num-OH-l round (10000 / (num-H-l))                        ;find the amount of visual OH-

  if Hide-acid-molecule-and-conjugate-base? = false
   [create-a-s num-H-l [set-tt-properties-l set size 1.25 set color 113.5]]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H-l round (1000 * (1.3895 ^ (-1 * current-ph-l)))     ;find the amount of visual H+
   set num-OH-l round (10000 / (num-H-l))                        ;find the amount of visual OH-
   create-h3os num-H-l [set-tt-properties-l set size 1.25 ]
   create-ohs num-OH-l [set-tt-properties-l set size 1.25 set color 85]]

end

to set-acetic-acid
  set ka 1.8 * (10 ^ -5)
  set vol-1-r 100
  set vol-titrant-r 0
  set current-conc-H-r 10 ^ (- Starting-pH)
  set current-ph-r Starting-pH
  set current-conc-HA-r (current-conc-H-r * (current-conc-H-r + ka) / ka)  ;determine initial HA concentration
  set current-conc-A-r current-conc-H-r                                   ;determine initial HA concentration
  set M-HA-r current-conc-HA-r * vol-1-r * 0.001   ;determine the mole of HA
  set M-H-r current-conc-H-r * vol-1-r * 0.001     ;determine the mole of H+
  set M-A-r M-H-r


  if Hide-acid-molecule-and-conjugate-base? = false
  [ set num-HA-r round (2500 * sqrt (sqrt (M-HA-r)))
    set num-A-r round (100 * sqrt (sqrt (M-A-r)))
    create-has num-HA-r [set-tt-properties-r set size 1.25 set color 116.5]
    create-a-s num-A-r [set-tt-properties-r set size 1.25 set color 113.5]
    set unit-num-ha (M-HA-r / num-ha-r) ]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H-r round (1000 * (1.3895 ^ (-1 * current-ph-r)))     ;find the amount of visual H+
   set num-OH-r round (10000 / (num-H-r))                        ;find the amount of visual OH-
   create-h3os num-H-r [set-tt-properties-r set size 1.25 ]
   create-ohs num-OH-r [set-tt-properties-r set size 1.25 set color 85]]

 end

to set-NaOH

  set vol-1-l 100
  set vol-titrant-l 0
  set current-conc-OH-l 10 ^ (- (14 - Starting-pH))
  set current-ph-l Starting-pH
  set M-OH-l current-conc-OH-l * vol-1-l * 0.001   ;determine the mole of hydroxide
  set M-B-l M-OH-l
  set M-BH-l M-OH-l
  set current-conc-BH-l (M-BH-l / (vol-1-l * 0.001))  ;determine initial conjugate acid concentration
  set current-conc-B-l 0                       ;there is no base molecule
  set current-Conc-H-l 10 ^ (-14) / current-conc-OH-l          ;calculate the concentration of H+
  set M-H-l current-Conc-H-l * vol-1-l * 0.001                 ;calculate exisitng mole of H+

  set num-H-l round (1000 * (1.3895 ^ (-1 * current-ph-l)))     ;find the amount of visual H+
  set num-OH-l round (10000 / (num-H-l))                        ;find the amount of visual OH-

  if Hide-base-molecule-and-conjugate-acid? = false
   [create-BHs num-OH-l [set-tt-properties-l set size 1.25 set color 62]]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H-l round (1000 * (1.3895 ^ (-1 * current-ph-l)))     ;find the amount of visual H+
   set num-OH-l round (10000 / (num-H-l))                        ;find the amount of visual OH-
   create-h3os num-H-l [set-tt-properties-l set size 1.25 ]
   create-ohs num-OH-l [set-tt-properties-l set size 1.25 set color 85]]

end

to set-NH3

  set kb 1.8 * (10 ^ -5)
  set vol-1-r 100
  set vol-titrant-r 0
  set current-conc-OH-r 10 ^ (- (14 - Starting-pH))
  set current-ph-r Starting-pH
  set current-conc-B-r (current-conc-OH-r * (current-conc-OH-r - kb) / kb)  ;determine initial Base concentration
  set current-conc-BH-r current-conc-OH-r  ;determine initial conjugate acid concentration
  set M-B-r current-conc-B-r * vol-1-r * 0.001   ;determine the mole of base
  set M-OH-r current-conc-OH-r * vol-1-r * 0.001   ;determine the mole of OH-
  set M-BH-r M-OH-r

  if Hide-base-molecule-and-conjugate-acid? = false
  [set num-B-r round (2500 * sqrt (sqrt (M-B-r)))
   set num-BH-r round (100 * sqrt (sqrt (M-BH-r)))
   create-Bs num-B-r [set-tt-properties-r set size 1.25 set color 42]
   create-BHs num-BH-r[set-tt-properties-r set size 1.25 set color 62]
   set unit-num-b (M-b-r / num-b-r)]

  if Hide-hydronium-and-hydroxide? = false
  [set num-H-r round (1000 * (1.3895 ^ (-1 * current-ph-r)))     ;find the amount of visual H+
   set num-OH-r round (10000 / (num-H-r))                        ;find the amount of visual OH-
   create-h3os num-H-r [set-tt-properties-r set size 1.25 ]
   create-ohs num-OH-r [set-tt-properties-r set size 1.25 set color 85]]

 end


;;;;;;;;;;;;;;;;;;;;;;;;;
;;                     ;;
;;  GO procedures      ;;
;;                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;


to go
  move

 (ifelse
    Choose-a-test = "Strong Acid and Acidic Buffer"
     [if current-conc-BH-r != 0 [setup]

      titration-HCl
      titration-acetic-acid

      (ifelse
        Hide-acid-molecule-and-conjugate-base? = true and count a-s > 0
         [if any? a-s [ask a-s [die]] if any? has [ask has [die]]]
        Hide-acid-molecule-and-conjugate-base? = false and count a-s > 0
         [dissociation-a]
        Hide-acid-molecule-and-conjugate-base? = false and count a-s <= 0
         [ ;right box
            set M-HA-1-r (current-conc-HA-r * vol-1-r * 0.001)
            let num-HA-to-be round (M-HA-1-r / unit-num-ha)
            create-has num-HA-to-be [set-tt-properties-r set size 1.25 set color 116.5]
            create-a-s (num-HA-r - num-HA-to-be + num-A-r)[set-tt-properties-r set size 1.25 set color 113.5]

           ; left box
            create-a-s round (1000 * (1.3895 ^ ( - Starting-pH))) [set-tt-properties-l set size 1.25 set color 113.5]])

   (ifelse
    Hide-hydronium-and-hydroxide? = true and count OHs > 0
    [ask h3os [die] ask ohs [die]]
    Hide-hydronium-and-hydroxide? = false and count ohs > 0
    [acid-base-equilibrium]
    Hide-hydronium-and-hydroxide? = false and count ohs <= 0
    [;left box
     set num-H-l round (1000 * (1.3895 ^ (-1 * current-pH-l)))
     set num-OH-l round (10000 / (num-H-l))
     create-h3os num-H-l [set-tt-properties-l set size 1.25 ]
     create-ohs num-OH-l [set-tt-properties-l set size 1.25 set color 85]

     ;right box
     set num-H-r round (1000 * (1.3895 ^ (-1 * current-pH-r)))
     set num-OH-r round (10000 / (num-H-r))
     create-h3os num-H-r [set-tt-properties-r set size 1.25 ]
     create-ohs num-OH-r [set-tt-properties-r set size 1.25 set color 85]
    ])

     if (vol-titrant-l + vol-titrant-r) / 2  >= (Total-mL-of-titrant-added - 0.05) [user-message "Have added the specified amount of titrant." stop]
    ]

    Choose-a-test = "Strong Base and Alkaline Buffer"
    [ if current-conc-A-r != 0 [setup]

      titration-NaOH
      titration-NH3

  (ifelse
    Hide-base-molecule-and-conjugate-acid? = true and count BHs > 0
      [if any? BHs [ask BHs [die]] if any? Bs [ask Bs [die]]]
    Hide-base-molecule-and-conjugate-acid? = false and count BHs > 0
      [dissociation-b]
    Hide-base-molecule-and-conjugate-acid? = false and count BHs <= 0
    [;right box
      set M-B-1-r (current-conc-B-r * vol-1-r * 0.001)
      let num-B-to-be round (M-B-1-r / unit-num-b)
      create-bs num-b-to-be [set-tt-properties-r set size 1.25 set color 42]
      create-BHs (num-b-r - num-b-to-be + num-BH-r)[set-tt-properties-r set size 1.25 set color 62]
      ;left box
       create-BHs round (1000 * (1.3895 ^ ( - Starting-pH))) [set-tt-properties-l set size 1.25 set color 62]])

   (ifelse
    Hide-hydronium-and-hydroxide? = true and count OHs > 0
      [ask h3os [die] ask ohs [die]]
    Hide-hydronium-and-hydroxide? = false and count ohs > 0
       [acid-base-equilibrium]
    Hide-hydronium-and-hydroxide? = false and count ohs <= 0
     [;left box
      set num-H-l round (1000 * (1.3895 ^ (-1 * current-pH-l)))
      set num-OH-l round (10000 / (num-H-l))
      create-h3os num-H-l [set-tt-properties-l set size 1.25 ]
      create-ohs num-OH-l [set-tt-properties-l set size 1.25 set color 85]

      ;right box
      set num-H-r round (1000 * (1.3895 ^ (-1 * current-pH-r)))
      set num-OH-r round (10000 / (num-H-r))
      create-h3os num-H-r [set-tt-properties-r set size 1.25 ]
      create-ohs num-OH-r [set-tt-properties-r set size 1.25 set color 85]])
     if (vol-titrant-l + vol-titrant-r) / 2  >= (Total-mL-of-titrant-added - 0.05) [user-message "Have added the specified amount of titrant." stop]
  ])

  tick
end

to move
  ask turtles with [breed != legends]    ;ask non-legend turtles
  [rt random 360                            ;rotate
    if [pcolor] of patch-at dx dy <= 92 and [pcolor] of patch-at dx dy >= 91.5    ;if the patch-ahead has the proper color
      [fd 0.5                                                                       ;move forward
       if ycor < 4 [set ycor 4]                                                   ;if ycor is low, put ycor higher
  ]]
end


to acid-base-equilibrium

  ;left box
  set num-H-l round (1000 * (1.3895 ^ (-1 * current-pH-l)))
  set num-OH-l round (10000 / (num-H-l))

  let current-H-l count H3Os with [xcor < 33]
  let current-OH-l count OHs with [xcor < 33]

  (ifelse
    (num-H-l) > current-H-l
     [create-h3os abs ((num-H-l) - current-H-l) [set-tt-properties-l set size 1.25]]
    (num-H-l) < current-H-l
    [ask n-of abs ((num-H-l) - current-H-l) h3os with [xcor < 33][die]])

   (ifelse
    (num-OH-l) > current-OH-l
    [create-ohs abs ((num-OH-l) - current-OH-l) [set-tt-properties-l set size 1.25 set color 85]]
    (num-OH-l) < current-OH-l
    [ask n-of abs ((num-OH-l) - current-OH-l) OHs with [xcor < 33] [die]])

  ;right box
   set num-H-r round (1000 * (1.3895 ^ (-1 * current-pH-r)))
   set num-OH-r round (10000 / (num-H-r))

  let current-H-r count H3Os with [xcor > 35]
  let current-OH-r count OHs with [xcor > 35]

  (ifelse
    (num-H-r) > current-H-r
     [create-h3os abs ((num-H-r) - current-H-r) [set-tt-properties-r set size 1.25]]
    (num-H-r) < current-H-r
    [ask n-of abs ((num-H-r) - current-H-r) h3os with [xcor > 35][die]])

   (ifelse
    (num-OH-r) > current-OH-r
    [create-ohs abs ((num-OH-r) - current-OH-r) [set-tt-properties-r set size 1.25 set color 85]]
    (num-OH-r) < current-OH-r
    [ask n-of abs ((num-OH-r) - current-OH-r) OHs with [xcor > 35] [die]])

end

to dissociation-b
  set M-B-1-r (current-conc-b-r * vol-1-r * 0.001)
  let num-b-to-be round (M-b-1-r / unit-num-b)
  let current-num-b count bs with [xcor > 35]

  if current-num-b > num-b-to-be
   [if any? bs with [xcor > 35]
      [ask up-to-n-of (current-num-b - num-b-to-be) bs with [xcor > 35] [set breed bhs set color 62]]]

  let T-of-tick Titrant-concentration * 0.001 * Titrant-dose   ;calculate the added mole of H+ in this tick
  if M-B-r - M-T-r <= -0.5 * t-of-tick
    [if any? bs with [xcor > 35] [ask bs with [xcor > 35] [set breed bhs set color 62]]]

end


to dissociation-a

  set M-HA-1-r (current-conc-HA-r * vol-1-r * 0.001)
  let num-HA-to-be round (M-HA-1-r / unit-num-ha)
  let current-num-ha count has with [xcor > 35]

  if current-num-ha > num-HA-to-be
   [if any? Has with [xcor > 35]
      [ask up-to-n-of (current-num-ha - num-HA-to-be) has with [xcor > 35] [set breed a-s set color 113]]]

  let T-of-tick Titrant-concentration * 0.001 * Titrant-dose   ;calculate the added mole of OH- in this tick
  if M-HA-r - M-T-r <= -0.5 * t-of-tick
    [if any? Has with [xcor > 35] [ask has with [xcor > 35] [set breed a-s set color 113]]]
end

to titration-NaOH
     set current-Conc-H-l 10 ^ (-14) / current-conc-OH-l      ;calculate the concentration of H+
     set M-H-l current-Conc-H-l * (vol-1-l) * 0.001             ;calculate exisitng mole of H+
     set vol-titrant-l vol-titrant-l + Titrant-dose               ;increase Titrant volume
     set vol-1-l vol-1-l + Titrant-dose                           ;increase total volume
     let T-of-tick Titrant-concentration * 0.001 * Titrant-dose   ;calculate the added mole of H+ in this tick
     set M-T-l (M-T-l + t-of-tick)                                ;update total mole of titant

    (ifelse
       current-conc-OH-l >= 10 ^ (-7)                         ;if base + acid
        [(ifelse
          M-B-l > M-T-l                                          ;if more OH- than H+
          [set current-conc-OH-l (M-B-l - M-T-l) / (vol-1-l * 0.001)              ;calculate the concentration of OH-
           ifelse current-conc-OH-l > 10 ^ (-6)
            [set current-ph-l (14 - (- log current-conc-OH-l 10))]                   ;calculate the ph
            [set current-conc-OH-l (10 ^ (-7) + current-conc-OH-l)          ;consider water self-ionizaiton
             set current-ph-l (14 - (- log current-conc-OH-l 10))]]                 ; find current pH

          M-B-l < M-T-l
          [set M-H-l (M-T-l - M-B-l)                              ;if more H+ than OH-,calculate left mole of H+
           set current-conc-H-l M-H-l / (vol-1-l * 0.001)             ;calculate the concentration of OH-
           ifelse current-conc-H-l > 10 ^ (-6)
            [set current-ph-l (- log current-conc-H-l 10)]       ;calculate the concentration of H+
            [set current-conc-H-l ((10 ^ (-7) + current-conc-H-l))  ;consider water self-ionizaiton
             set current-ph-l (- log current-conc-H-l 10)]]         ;calculate the concentration of H+

          M-B-l = M-T-l
          [set current-conc-H-l 10 ^ (-7) set current-ph-l (- log current-conc-H-l 10)])
        ]

       current-conc-OH-l < 10 ^ (-7)                                 ;if acid + acid
        [let total-H-l (M-H-l + T-of-tick)                                ;calculate the total mole of H+
         set current-conc-H-l total-H-l / (vol-1-l * 0.001)           ;calculate the concentration of OH-
        set current-ph-l (- log current-conc-H-l 10)])               ;Find ph


end

to titration-NH3
     set vol-titrant-r vol-titrant-r + Titrant-dose               ;increase Titrant volume
     set vol-1-r vol-1-r + Titrant-dose                           ;increase total volume
     let T-of-tick Titrant-concentration * 0.001 * Titrant-dose                     ;calculate the added mole of OH- in this tick
     set M-T-r (M-T-r + t-of-tick)                                ;update total mole of titant


 (ifelse
      (M-B-r - M-T-r)  >= T-of-tick * 0.5                                     ;if more base (half tick mole) than H+, i.e., before the equivalent point
      [set current-conc-B-r (M-B-r - M-T-r) / (vol-1-r * 0.001)             ;update base concentration
       ifelse  ((M-BH-r + M-T-r) / (vol-1-r * 0.001)) -  (M-T-r / (vol-1-r * 0.001)) > 0.0008   ;update BH concentration. consider the initial BH concentration
        [set current-conc-BH-r ((M-BH-r + M-T-r) / (vol-1-r * 0.001))]
        [set current-conc-BH-r (M-T-r / (vol-1-r * 0.001))]
       set current-conc-OH-r (kb * current-conc-B-r / current-conc-BH-r)  ;find current OH- concentration
       set current-ph-r (14 - (- log current-conc-OH-r 10))]                 ; find current pH

      M-B-r - M-T-r < T-of-tick * 0.5  and  M-B-r - M-T-r > -0.5 * T-of-tick                    ;if at the equivalent point
      [set current-conc-BH-r (M-B-r / (vol-1-r * 0.001))                                ;update A- concentration
       let ka-r (10 ^ (-14) / kb)
       set current-conc-H-r (-0.5 * (ka-r - sqrt (ka-r * ka-r + 4 * ka-r * current-conc-BH-r)))  ;find H+ concentration using Ka
       set current-pH-r (- log current-conc-H-r 10)                                      ;find current ph using pH
       set current-conc-b-r current-conc-h-r]                                    ;update Base molecule concentration

      M-B-r - M-T-r <= -0.5 * T-of-tick                                          ; if after the equivalent point
      [set current-conc-b-r 0                                              ;update Base molecule concentration
       set current-conc-BH-r (M-B-r) / (vol-1-r * 0.001)                   ;update BH concentration
       set current-conc-H-r ((M-T-r - M-B-r) / (vol-1-r * 0.001))                ; find H+ concentration
       set current-ph-r (- log current-conc-H-r 10)])                        ;find current ph using pOH

end


to titration-HCl
     set current-Conc-OH-l 10 ^ (-14) / current-conc-H-l          ;calculate the concentration of OH-
     set M-OH-l current-Conc-OH-l * (vol-1-l) * 0.001   ;calculate exisitng mole of OH-
     set vol-titrant-l vol-titrant-l + Titrant-dose               ;increase Titrant volume
     set vol-1-l vol-1-l + Titrant-dose                           ;increase total volume
     let T-of-tick Titrant-concentration * 0.001 * Titrant-dose   ;calculate the added mole of OH- in this tick
     set M-T-l (M-T-l + t-of-tick)                                ;update total mole of titant

    (ifelse
       current-conc-H-l >= 10 ^ (-7)                         ;if acid + base
        [(ifelse
          M-HA-l > M-T-l                                          ;if more H+ than OH-
          [set current-conc-H-l (M-HA-l - M-T-l) / (vol-1-l * 0.001)              ;calculate the concentration of H+
           set current-conc-A-l (M-HA-l / (vol-1-l * 0.001))
           ifelse current-conc-H-l > 10 ^ (-6)
            [set current-ph-l (- log current-conc-H-l 10)]                   ;calculate the ph
            [set current-conc-H-l (10 ^ (-7) + current-conc-H-l);consider water self-ionizaiton
             set current-ph-l (- log current-conc-H-l 10)]]                  ; find current pH


          M-HA-l < M-T-l
          [set M-OH-l (M-T-l - M-HA-l)                              ;if more OH- than H+,calculate left mole of OH-
           set current-conc-OH-l M-OH-l / (vol-1-l * 0.001)             ;calculate the concentration of OH-
           set current-conc-A-l (M-HA-l / (vol-1-l * 0.001))
           ifelse current-conc-OH-l > 10 ^ (-6)
            [set current-conc-H-l 10 ^ (-14) / current-conc-OH-l set current-ph-l (- log current-conc-H-l 10)]       ;calculate the concentration of H+
            [set current-conc-OH-l (10 ^ (-7) + current-conc-OH-l)           ;consider water self-ionizaiton
             set current-conc-H-l 10 ^ (-14) / current-conc-OH-l set current-ph-l (- log current-conc-H-l 10)]]         ;calculate the concentration of H+

          M-HA-l = M-T-l
          [set current-conc-A-l (M-HA-l / (vol-1-l * 0.001))
           set current-conc-H-l 10 ^ (-7) set current-ph-l (- log current-conc-H-l 10)])
           ]

       current-conc-H-l < 10 ^ (-7)                                 ;if base + base
        [set current-conc-A-l (M-HA-l / (vol-1-l * 0.001))
         let total-OH-l (M-OH-l + T-of-tick)                                ;calculate the total mole of OH-
         set current-conc-OH-l total-OH-l / (vol-1-l * 0.001)           ;calculate the concentration of OH-
         set current-conc-H-l 10 ^ (-14) / current-conc-OH-l           ;calculate the concentration of H+
         set current-ph-l (- log current-conc-H-l 10)])               ;Find ph


end

to titration-acetic-acid
     set vol-titrant-r vol-titrant-r + Titrant-dose               ;increase Titrant volume
     set vol-1-r vol-1-r + Titrant-dose                           ;increase total volume
     let T-of-tick Titrant-concentration * 0.001 * Titrant-dose  ;calculate the added mole of OH- in this tick
     set M-T-r (M-T-r + t-of-tick)                                ;update total mole of titant


 (ifelse
      M-HA-r - M-T-r > 0.5 * t-of-tick                                             ;if more HA than OH-, i.e., before the equivalent point
      [set current-conc-HA-r (M-HA-r - M-t-r) / (vol-1-r * 0.001)             ;update HA concentration
      ifelse  ((M-A-r + M-T-r) / (vol-1-r * 0.001)) -  (M-T-r / (vol-1-r * 0.001)) > 0.0008     ;update A- concentration. consider the initial A concentration
         [set current-conc-A-r ((M-A-r + M-T-r) / (vol-1-r * 0.001))]
         [set current-conc-A-r (M-T-r / (vol-1-r * 0.001))]
       set current-conc-H-r (ka * current-conc-HA-r / current-conc-A-r)  ;find current H+ concentration
       set current-ph-r (- log current-conc-H-r 10)]                 ; find current pH

      M-HA-r - M-T-r <= 0.5 * t-of-tick and M-HA-r - M-T-r > -0.5 * t-of-tick                  ;if at the equivalent point
      [set current-conc-A-r (M-HA-r / (vol-1-r * 0.001))  ;update A- concentration
       let kb-r (10 ^ (-14) / ka)
       set current-conc-OH-r (-0.5 * (kb-r - sqrt (kb-r * kb-r + 4 * kb-r * current-conc-A-r))) ;find OH- concentration using Kb
       set current-pOH-r (- log current-conc-OH-r 10)            ;find current ph using pOH
       set current-ph-r (14 - current-pOH-r)            ;find current ph using pOH
       set current-conc-HA-r current-conc-OH-r]         ;update HA concentration


     M-HA-r - M-T-r <= -0.5 * t-of-tick                                   ; if after the equivalent point
      [set current-conc-HA-r 0                                          ;update HA concentration
       set current-conc-A-r (M-HA-r / (vol-1-r * 0.001))                    ;update A- concentration
       set current-conc-OH-r ((M-T-r - M-HA-r) / (vol-1-r * 0.001))           ; find OH- concentration
       set current-ph-r (14 - (- log current-conc-OH-r 10))])             ;find current ph using pOH

end
@#$#@#$#@
GRAPHICS-WINDOW
6
190
704
569
-1
-1
10.0
1
9
1
1
1
0
1
1
1
0
68
0
36
1
1
1
ticks
10.0

BUTTON
552
10
703
66
Set up/Restart
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
552
132
704
188
Titration (Manually)
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
709
139
1054
566
pH
Volume of Titrant Added (ml)
pH of Solution
0.0
10.0
0.0
14.0
true
true
"" ""
PENS
"pH-left" 1.0 0 -13791810 true "" "plotxy  vol-titrant-l current-ph-l "
"pH-right" 1.0 0 -2674135 true "" "plotxy vol-titrant-r current-ph-r"
"pH 7" 1.0 0 -4399183 true "" "plotxy vol-titrant-r 7"

BUTTON
552
70
704
128
Titration (Continously)
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
6
57
223
90
Titrant-concentration
Titrant-concentration
0.05
0.2
0.1
0.05
1
M
HORIZONTAL

SLIDER
6
92
223
125
Titrant-dose
Titrant-dose
0
0.2
0.1
0.05
1
ml/tick
HORIZONTAL

CHOOSER
6
10
223
55
Choose-a-test
Choose-a-test
"Strong Acid and Acidic Buffer" "Strong Base and Alkaline Buffer"
0

SWITCH
237
113
535
146
Hide-acid-molecule-and-conjugate-base?
Hide-acid-molecule-and-conjugate-base?
1
1
-1000

SWITCH
237
151
512
184
Hide-hydronium-and-hydroxide?
Hide-hydronium-and-hydroxide?
1
1
-1000

SWITCH
237
75
535
108
Hide-base-molecule-and-conjugate-acid?
Hide-base-molecule-and-conjugate-acid?
1
1
-1000

MONITOR
709
10
873
51
pH of Strong acid/base (left)
current-ph-l
2
1
10

MONITOR
882
10
1053
51
pH of Buffer (right)
current-ph-r
2
1
10

MONITOR
709
53
827
94
Total Volume (left)
vol-1-l
2
1
10

MONITOR
882
53
1004
94
Total Volume (right)
vol-1-r
2
1
10

MONITOR
709
95
873
136
Volume of Titrant Added (left)
vol-titrant-l
2
1
10

MONITOR
882
96
1054
137
Volume of Titrant Added (right)
vol-titrant-r
2
1
10

INPUTBOX
6
128
223
188
Total-mL-of-titrant-added
70.0
1
0
Number

TEXTBOX
230
12
553
69
-------------------------------------------------\n* NaOH is used as titrant for strong acid and acidic buffer. \n* HCl is used as titrant for strong base and alkaline buffer. \n-------------------------------------------------
10
125.0
1

@#$#@#$#@
## WHAT IS IT?

How does a buffer behave differently from a strong acid or a strong base during titration? Check this model. Starting at the same pH level, see how much more titrant is needed to cause a significant pH change.  

## HOW IT WORKS

* A strong acid and an acid buffer are compared side by side. They both start at a ph of 3 and are titrated by NaOH.  Ka = 1.8E-5

* A strong base and an alkaline buffer are compared side by side. They both start at a ph of 11 and are titrated by HCl. Kb = 1.8E-5

* The starting pHs are 3 for acidic solutions and 11 for basic solutions. We do not let users set up a random starting pH because every buffer has a particular buffer zone. 


## HOW TO USE IT

1. Choose a test, and then determine the titrant concentration and dose. 
2. Run the model to titrate.

Note: 
-Don't change the titrant's concentration and dose during titration. 
-Use switches to hide some molecules or ions to help observations.

## THINGS TO NOTICE

* Dissociation of the strong acid/base and weak acid/base.
* The pH changes in the titration processes of the strong acid/base and buffer.

## RELATED MODELS

See more chemistry models at https://sites.google.com/view/3d-science-abm/physics-chemistry

## CREDITS AND REFERENCES

Dr. Lin Xiang created this module at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Buffer Titration. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

ab-ace-acid
true
0
Circle -1 true false 9 174 42
Circle -1 true false 24 69 42
Circle -16777216 true false 15 75 150
Circle -1 true false 24 114 42
Circle -2674135 true false 150 30 120
Circle -16777216 true false 90 75 150
Circle -2674135 true false 165 135 120
Circle -1 true false 204 234 42

ab-ace-acid-1
true
0
Circle -1 true false 9 174 42
Circle -1 true false 24 69 42
Circle -16777216 true false 15 75 150
Circle -1 true false 24 114 42
Circle -2674135 true false 150 30 120
Circle -16777216 true false 90 75 150
Circle -2674135 true false 165 135 120

ab-ace-acid-2
true
0
Circle -7500403 true true 105 30 150
Circle -16777216 true false 15 75 180
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 161 134 120
Circle -1 true false 204 234 42

ab-ace-acid-3
true
0
Circle -7500403 true true 15 75 180
Circle -7500403 true true 105 30 150
Circle -7500403 true true 165 135 120

ab-ace-acid-4
true
0
Circle -7500403 true true 105 30 150
Circle -16777216 true false 15 75 180
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 161 134 120

ab-ace-acid-5
true
0
Circle -7500403 true true 105 30 150
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 160 134 120
Circle -1 true false 204 234 42

ab-ace-acid-6
true
0
Circle -7500403 true true 105 30 150
Circle -7500403 true true 14 76 180
Circle -16777216 true false 161 133 120
Circle -7500403 true true 160 134 120

ab-b-1
true
0
Circle -7500403 true true 165 225 60
Circle -7500403 true true 15 75 60
Circle -7500403 true true 30 30 240
Circle -7500403 true true 45 210 60

ab-b-2
true
0
Circle -7500403 true true 165 225 60
Circle -7500403 true true 15 75 60
Circle -7500403 true true 30 30 240
Circle -7500403 true true 50 211 60
Circle -1 true false 203 40 60

ab-h2o
true
0
Circle -11221820 true false 90 90 120
Circle -1 true false 84 174 42
Circle -1 true false 189 144 42

ab-h2o-1
true
0
Circle -7500403 false true 90 90 118
Circle -7500403 true true 84 174 42
Circle -7500403 true true 189 144 42

ab-h3o-1
true
0
Circle -1 true false 111 65 42
Circle -2674135 true false 90 90 120
Circle -1 true false 84 174 42
Circle -1 true false 189 144 42

ab-ha-1
true
0
Circle -7500403 true true 45 45 210
Circle -1 true false 219 69 42
Circle -7500403 true true 30 45 120
Circle -7500403 true true 105 165 120

ab-ha-2
true
0
Circle -7500403 true true 45 45 210
Circle -7500403 true true 30 45 120
Circle -7500403 true true 105 165 120

ab-oh-1
true
0
Circle -13791810 true false 90 90 120
Circle -1 true false 189 159 42

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

blank
true
0

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

oa-co2
true
0
Circle -2674135 true false 180 90 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120

oa-co3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120

oa-h2co3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120
Circle -1 true false 122 0 42
Circle -1 true false 163 253 42

oa-h3o
true
0
Circle -1 true false 114 69 42
Circle -2674135 true false 90 90 120
Circle -1 true false 84 174 42
Circle -1 true false 189 159 42

oa-hco3
true
0
Circle -2674135 true false 120 0 120
Circle -16777216 true false 60 60 180
Circle -2674135 true false 0 90 120
Circle -2674135 true false 150 165 120
Circle -1 true false 163 253 42

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

plus
false
0
Rectangle -7500403 true true 142 0 157 300
Rectangle -7500403 true true 0 150 300 165

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
