; Coded in 2022 by Lin Xiang; Last revised in 2022 by Lin Xiang (lxiang75@gmail.com; lin.xiang@uky.edu)
;;
;; If you mention this model in a publication, we ask that you include the citations below.
;;
;; Xiang, L. (2022). Herbivory and Animal Interspecific Competition. Department of STEM Education, University of Kentucky, Lexington, KY.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


breed [plant1s plant1]
breed [plant2s plant2]
breed [animal1s animal1 ]
breed [animal2s animal2 ]
breed [legends legend]

plant1s-own [ num-seed-1 erg-0]
plant2s-own [ num-seed-2 erg-00]
animal1s-own [erg-1 life-1]
animal2s-own [erg-2 life-2]

patches-own []

Globals [
  running-avg-list1  running-avg-list2
  running-avg-lista1  running-avg-lista2

  mean-total-1 mean-total-2
  mean-total-a1 mean-total-a2
]

to-report empty-patches
  report patches with [pcolor >= 79 and pcolor <= 79.5 and not any? plant1s-here and not any? plant2s-here]
end


to setup
  clear-all

  setup-patches
  setup-legends
  add-plants
  add-mice1
  add-mice2


  set running-avg-list1 []
  set running-avg-list2 []
  set running-avg-lista1 []
  set running-avg-lista2 []

  reset-ticks
end

to setup-patches
  ask patches [set pcolor 79 + random-float 0.5]
  ask patches with [pycor = max-pycor or pycor < 2] [set pcolor white]
end

to add-plants

ask up-to-n-of number-of-plants empty-patches
    [sprout-plant2s 1
    [set shape "plant-1"
    set size 0.6 + random-float 0.4
    set erg-00 10]]
end

to add-mice1

create-animal1s number-of-mice1
 [set color 34
  set size 0.65
  set erg-1 5 + random 10
  set shape "mouse"
  setxy 1 + random (max-pxcor - 1) 2 + random (max-pycor - 2)
 ]
end


to add-mice2
  create-animal2s number-of-mice2
 [set color 37
  set size 0.75
  set erg-2 5 + random 10
  set shape "mouse"
  setxy 1 + random (max-pxcor - 1) 2 + random (max-pycor - 2)
 ]

end
;;;;;;;;;;;;;;;;;;;;;
;;   GO PROCEDURE  ;;
;;;;;;;;;;;;;;;;;;;;;


to go
 every 0.05[
  if ticks >= Years [stop]
  move
  feeding
  reproduce-2
  death
  find-running-avg
    tick
]

end

to move
  if any? animal1s [ask animal1s
                     [ifelse life-1 >= 2 + mouse1-lifespan * 3 [die] [set life-1 life-1 + 1]
                      right random 360
                       if [pcolor] of patch-at dx dy <= 79.5 and [pcolor] of patch-at dx dy >= 79  [fd 1 if ycor < 2 [set ycor 2] set erg-1 erg-1 - 1]
                      if erg-1 <= 0 [die]]]

  if any? animal2s [ask animal2s
                      [ifelse life-2 >= 2 + mouse2-lifespan * 3 [die] [set life-2 life-2 + 1]
                       right random 360
                       if [pcolor] of patch-at dx dy <= 79.5 and [pcolor] of patch-at dx dy >= 79  [fd 1 if ycor < 2 [set ycor 2] set erg-2 erg-2 - 1]
                       if erg-2 <= 0 [die]]]

end

to feeding
  (ifelse
    any? animal1s and not any? animal2s
    [feeding-1]

    any? animal2s and not any? animal1s
    [feeding-2]

    any? animal1s and any? animal2s
    [ifelse random 2 = 0
       [feeding-1 feeding-2]
       [feeding-2 feeding-1]]
    )


end


to feeding-1
 ask animal1s [
    if any? plant2s-here [
      let food one-of plant2s-here
      set erg-1 erg-1 + [erg-00] of food
      ask food [die]]]

  ask animal1s [
    if erg-1 > 20 [if random 100 < 20
      [hatch 1 [set erg-1 5 set life-1 0]
        set erg-1 erg-1 - 10]]]

end

to feeding-2
 ask animal2s [
    if any? plant2s-here [
      let food one-of plant2s-here
      set erg-2 erg-2 + [erg-00] of food
      ask food [die]]]

   ask animal2s [
    if erg-2 > 20 [if random 100 < 20
      [hatch 1 [set erg-2 5 set life-2 0]
      set erg-2 erg-2 - 10]]]
end

to reproduce-2
  if any? plant2s
    [ask plant2s
       [set num-seed-2 1 + random 2
        ask up-to-n-of num-seed-2 neighbors with [pcolor <= 79.5 and pcolor >= 79 and not any? plant1s-here and not any? plant2s-here]
           [sprout-plant2s 1
            [set shape "plant-1"
             set size 0.6 + random-float 0.4
             set erg-00 10]]
  ]]
end


to death

  ask plant2s
  [if random 100 < 30 [die]]  ;a mortality of 30%-50% is optimal

end

to find-running-avg  ;find the 5-year running averages
   (ifelse
    ticks < 10
     [set running-avg-list1 lput (count plant1s) running-avg-list1 set mean-total-1 mean running-avg-list1
      set running-avg-list2 lput (count plant2s) running-avg-list2 set mean-total-2 mean running-avg-list2

      set running-avg-lista1 lput (count animal1s) running-avg-lista1 set mean-total-a1 mean running-avg-lista1
      set running-avg-lista2 lput (count animal2s) running-avg-lista2 set mean-total-a2 mean running-avg-lista2]

     [set running-avg-list1 lput count plant1s running-avg-list1 set running-avg-list1 remove-item 0 running-avg-list1 set mean-total-1 mean running-avg-list1
      set running-avg-list2 lput count plant2s running-avg-list2 set running-avg-list2 remove-item 0 running-avg-list2 set mean-total-2 mean running-avg-list2

      set running-avg-lista1 lput count animal1s running-avg-lista1 set running-avg-lista1 remove-item 0 running-avg-lista1 set mean-total-a1 mean running-avg-lista1
      set running-avg-lista2 lput count animal2s running-avg-lista2 set running-avg-lista2 remove-item 0 running-avg-lista2 set mean-total-a2 mean running-avg-lista2])

end

to setup-legends
   create-legends 9

  ask legend 0
  [set shape "plant-1"
    set size 1
    setxy 6 0.6]

  ask legend 1
  [set shape "mouse"
    set color 34
    set size 0.9
    setxy 3 1]


  ask legend 2
  [set shape "mouse"
    set color 36
    set size 1
    setxy 9 1]

  ask legend 3
  [set shape "line"
    set color 8
    set size 12
    set heading 90
    setxy 6 1.5]

  ask legend 4
  [set shape "arrow-1"
    set color 136
    set size 1.5
    set heading -75
    setxy 4.5 0.75]

  ask legend 5
  [set shape "arrow-1"
    set color 136
    set size 1.5
    set heading 75
    setxy 7.5 0.75]

  ask legend 6
  [set shape "blank"
    set color 136
    set size 1.5
    set label "Mouse-2"
    set label-color 35
    set heading 75
    setxy 9 1]

  ask legend 7
  [set shape "blank"
    set color 136
    set size 1.5
    set label "Mouse-1"
    set label-color 33
    set heading 75
    setxy 3 1]

  ask legend 8
  [set shape "blank"
    set color 136
    set size 1
    set label "Both mouse species feed on the same type of plants."
    set label-color 0
    set heading 75
    setxy 10 0.2]
end
@#$#@#$#@
GRAPHICS-WINDOW
14
10
382
529
-1
-1
30.0
1
10
1
1
1
0
1
1
1
0
11
0
16
0
0
1
Years
15.0

BUTTON
392
125
480
186
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
564
125
655
185
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
659
125
750
185
Run a year
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
388
280
756
528
Populations(10-year running average)
Years
# of Organisms
0.0
10.0
0.0
150.0
true
true
"" ""
PENS
"Plants" 1.0 0 -10899396 true "" "(ifelse ticks > 0 and plot-plants?[plotxy ticks round mean-total-2]ticks = 0 and plot-plants?[plotxy ticks count plant2s])"
"Mice1" 1.0 0 -6459832 true "" "(ifelse ticks > 0 and plot-mice1?[plotxy ticks round mean-total-a1]ticks = 0 and plot-plants?[plotxy ticks count animal1s])"
"Mice2" 1.0 0 -955883 true "" "(ifelse ticks > 0 and plot-mice2?[plotxy ticks round mean-total-a2]ticks = 0 and plot-plants?[plotxy ticks count animal2s])"

MONITOR
388
237
452
278
Plants
count plant2s
17
1
10

SLIDER
390
193
566
226
mouse1-lifespan
mouse1-lifespan
2
5
2.0
1
1
years
HORIZONTAL

SLIDER
569
192
745
225
mouse2-lifespan
mouse2-lifespan
2
5
3.0
1
1
years
HORIZONTAL

MONITOR
452
237
517
278
Mice1
count animal1s
17
1
10

MONITOR
517
237
582
278
Mice2
count animal2s
17
1
10

INPUTBOX
484
125
558
185
Years
200.0
1
0
Number

SWITCH
554
10
671
43
plot-plants?
plot-plants?
0
1
-1000

SWITCH
554
47
671
80
plot-mice1?
plot-mice1?
0
1
-1000

SWITCH
554
84
671
117
plot-mice2?
plot-mice2?
0
1
-1000

SLIDER
389
47
551
80
number-of-mice1
number-of-mice1
0
90
15.0
1
1
NIL
HORIZONTAL

SLIDER
389
83
551
116
number-of-mice2
number-of-mice2
0
90
15.0
1
1
NIL
HORIZONTAL

SLIDER
389
10
551
43
number-of-plants
number-of-plants
0
90
50.0
1
1
NIL
HORIZONTAL

MONITOR
583
237
640
278
Years
ticks
17
1
10

@#$#@#$#@
## WHAT IS IT?

This model simulates animal interspecific competition and herbivory. 

## HOW IT WORKS

### Agents:

There are three types of agents: plants, mice1, and mice2.

### Model Rules:

1. There are 168 patches (light blue squares) in the model. The nutrients in each patch may support and only support one plant. 

2. Both species of mice feed on the same type of plants. Plants regrow every year.

3. Mice lose energy when they move around to search for food and die when running out of energy.

4. Mice gain energy when they find food and will produce offspring when they accumulate enough energy.

5. Mice' life spans are determined by the slides “mouse1-lifespan” and “mouse2-lifespan”. 

## HOW TO USE IT

1.	Use sliders **number-of-plants** and other similar sliders to set up the number of organisms. Click **Start/Reset** to confirm the settings.

2.	Put a number in **years** to define when the model ends.

3.	Click **Run/Pause** to run or pause the model. Good for gaining an overview and a long-term result.

4.	Click **Run a year** to run the model for a hypothetical year. Good for systematically collecting data. 

5.	Use **plot-plants?** and other similar switches to decide whether or not to plot certain organisms in the real-time plot. Good for providing a clear visualization.

6.	Use **mouse1-lifespan** and **mouse1-lifespan** to define the lifespans of the mouse species.


## THINGS TO TRY

* What population patterns emerge in the model when plants and one mouse species are present?

* What population patterns emerge when plants and mouse species are present in the model? 

* How do mouse lifespans affect the interaction between two species of mice?

* What population patterns indicate herbivory interaction? Why?

* What population patterns indicate a competition interaction? Why?


## RELATED MODELS

Find more community interaction models at http://3dsciencemodeling.com


## CREDITS AND REFERENCES

Dr. Lin Xiang (lin.xiang@uky.edu) created this module at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Herbivory and Animal Interspecific Competition. Department of STEM Education, University of Kentucky, Lexington, KY.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

arrow-1
true
0
Polygon -7500403 true true 150 0 120 90 135 75 145 303 156 301 165 75 180 90

bee
true
0
Polygon -1184463 true false 195 150 105 150 90 165 90 225 105 270 135 300 165 300 195 270 210 225 210 165 195 150
Rectangle -16777216 true false 90 165 212 185
Polygon -16777216 true false 90 207 90 226 210 226 210 207
Polygon -16777216 true false 103 266 198 266 203 246 96 246
Polygon -6459832 true false 120 150 105 135 105 75 120 60 180 60 195 75 195 135 180 150
Polygon -6459832 true false 150 15 120 30 120 60 180 60 180 30
Circle -16777216 true false 105 30 30
Circle -16777216 true false 165 30 30
Polygon -7500403 true true 120 90 75 105 15 90 30 75 120 75
Polygon -7500403 true true 180 75 180 90 225 105 285 90 270 75
Polygon -7500403 true true 180 75 180 90 195 105 240 195 270 210 285 210 285 150 255 105
Polygon -7500403 true true 120 75 45 105 15 150 15 210 30 210 60 195 105 105 120 90
Polygon -16777216 true false 135 300 165 300 180 285 120 285

beehive
false
0
Circle -7500403 true true 195 223 62
Circle -7500403 true true 43 223 62
Circle -7500403 true true 208 192 62
Circle -7500403 true true 31 189 62
Circle -7500403 true true 205 150 62
Circle -7500403 true true 33 150 62
Circle -7500403 true true 69 77 62
Circle -7500403 true true 171 78 62
Circle -7500403 true true 196 112 62
Circle -7500403 true true 44 110 62
Circle -7500403 true true 142 55 62
Circle -7500403 true true 96 55 62
Circle -7500403 true true 120 49 62
Rectangle -7500403 true true 84 99 222 282
Circle -16777216 true false 97 170 110
Polygon -1 true false 81 151 151 135 229 154 151 139
Polygon -1 true false 106 110 149 99 201 110 151 102
Polygon -1 true false 130 72 149 67 174 71 149 69

blank
false
0

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

moose
false
0
Polygon -7500403 true true 196 228 198 297 180 297 178 244 166 213 136 213 106 213 79 227 73 259 50 257 49 229 38 197 26 168 26 137 46 120 101 122 147 102 181 111 217 121 256 136 294 151 286 169 256 169 241 198 211 188
Polygon -7500403 true true 74 258 87 299 63 297 49 256
Polygon -7500403 true true 25 135 15 186 10 200 23 217 25 188 35 141
Polygon -7500403 true true 270 150 253 100 231 94 213 100 208 135
Polygon -7500403 true true 225 120 204 66 207 29 185 56 178 27 171 59 150 45 165 90
Polygon -7500403 true true 225 120 249 61 241 31 265 56 272 27 280 59 300 45 285 90

mouse
false
0
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

plant-1
false
0
Polygon -10899396 true false 45 165 90 195 120 240 135 300 150 300 135 240 105 195 60 165
Polygon -10899396 true false 150 300 135 195 150 120 195 45 210 45 165 120 150 195 165 300
Polygon -10899396 true false 165 300 180 300 195 240 240 195 225 195 180 240
Polygon -10899396 true false 135 255 105 240 75 240 60 255 75 270 120 270 135 255
Polygon -10899396 true false 106 210 76 195 46 195 31 210 46 225 91 225 106 210
Polygon -10899396 true false 195 240 225 225 255 225 270 240 255 255 210 255 195 240
Polygon -10899396 true false 180 240 195 210 195 180 180 165 165 180 165 225 180 240
Polygon -10899396 true false 105 195 90 165 90 135 105 120 120 135 120 180 105 195
Polygon -10899396 true false 165 105 150 75 120 60 90 60 105 90 135 105 165 105
Polygon -10899396 true false 165 120 195 105 225 105 240 120 225 135 180 135 165 120
Polygon -955883 true false 185 64 182 47 182 30 194 12 211 7 221 5 214 20 227 13 222 28 237 24 234 37 228 50 211 62 197 67
Polygon -955883 true false 69 177 66 152 56 135 40 130 42 146 30 139 36 154 24 151 29 165 41 175 63 181
Polygon -955883 true false 223 202 223 184 242 169 257 174 257 185 248 202 234 207

plant-11
false
0
Polygon -10899396 true false 45 165 90 195 120 240 135 300 150 300 135 240 105 195 60 165
Polygon -10899396 true false 150 300 135 195 150 120 195 45 210 45 165 120 150 195 165 300
Polygon -10899396 true false 165 300 180 300 195 240 240 195 225 195 180 240
Polygon -10899396 true false 135 255 105 240 75 240 60 255 75 270 120 270 135 255
Polygon -10899396 true false 106 210 76 195 46 195 31 210 46 225 91 225 106 210
Polygon -10899396 true false 195 240 225 225 255 225 270 240 255 255 210 255 195 240
Polygon -10899396 true false 180 240 195 210 195 180 180 165 165 180 165 225 180 240
Polygon -10899396 true false 105 195 90 165 90 135 105 120 120 135 120 180 105 195
Polygon -10899396 true false 165 105 150 75 120 60 90 60 105 90 135 105 165 105
Polygon -10899396 true false 165 120 195 105 225 105 240 120 225 135 180 135 165 120
Polygon -955883 true false 185 64 182 47 182 30 194 12 211 7 221 5 214 20 227 13 222 28 237 24 234 37 228 50 211 62 197 67
Polygon -955883 true false 69 177 66 152 56 135 40 130 42 146 30 139 36 154 24 151 29 165 41 175 63 181
Polygon -955883 true false 223 202 223 184 242 169 257 174 257 185 248 202 234 207

rabbit
false
0
Polygon -7500403 true true 61 150 76 180 91 195 103 214 91 240 76 255 61 270 76 270 106 255 132 209 151 210 181 210 211 240 196 255 181 255 166 247 151 255 166 270 211 270 241 255 240 210 270 225 285 165 256 135 226 105 166 90 91 105
Polygon -7500403 true true 75 164 94 104 70 82 45 89 19 104 4 149 19 164 37 162 59 153
Polygon -7500403 true true 64 98 96 87 138 26 130 15 97 36 54 86
Polygon -7500403 true true 49 89 57 47 78 4 89 20 70 88
Circle -16777216 true false 37 103 16
Line -16777216 false 44 150 104 150
Line -16777216 false 39 158 84 175
Line -16777216 false 29 159 57 195
Polygon -5825686 true false 0 150 15 165 15 150
Polygon -5825686 true false 76 90 97 47 130 32
Line -16777216 false 180 210 165 180
Line -16777216 false 165 180 180 165
Line -16777216 false 180 165 225 165
Line -16777216 false 180 210 210 240

rabbit-1
false
0
Polygon -7500403 true true 87 116 93 104 102 98 113 96 115 84 118 71 121 60 126 52 134 45 142 50 141 64 137 78 127 100 136 106 141 116 142 128 160 125 176 126 193 129 210 139 222 151 230 172 233 194 235 208 236 225 236 235 242 243 236 253 226 256 218 250 214 248 219 252 207 257 188 258 165 256 149 254 133 255 131 243 144 242 162 244 172 236 159 231 151 225 143 219 136 213 137 213 130 205 131 214 121 232 111 244 106 255 97 255 88 255 89 249 99 243 101 234 105 223 104 208 104 197 102 188 100 177 98 169 98 169 97 165 96 158 97 148 98 145 98 147 95 144 88 142 78 137 74 129 81 124
Polygon -7500403 true true 110 100 106 91 103 76 103 65 103 54 105 48 112 42 119 46 121 55 120 67 117 85 116 103
Polygon -16777216 true false 94 118 94 125 102 117

seed
true
0
Polygon -7500403 true true 150 15 105 105 75 225 105 285 150 300 195 285 225 225 195 105

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

sunflower
false
0
Polygon -7500403 true true 116 183 116 193 115 207 108 216 79 237 80 220 71 226 70 214 60 217 64 185 75 173 88 166 97 168
Polygon -7500403 true true 156 110 151 97 152 86 162 76 161 61 170 54 180 45 198 67 207 81 212 90 211 102 206 114 191 117 174 117
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 178 195 178 205 179 219 186 228 215 249 214 232 223 238 224 226 234 229 230 197 219 185 206 178 197 180
Polygon -7500403 true true 80 146 70 146 56 147 47 154 43 168 41 177 33 188 48 192 58 197 78 198 90 187 97 174 95 165
Polygon -7500403 true true 144 190 149 203 148 214 138 224 129 230 118 239 110 251 102 233 93 219 88 210 89 198 94 186 109 183 126 183
Polygon -7500403 true true 209 142 219 142 233 143 242 150 246 164 248 173 256 184 241 188 231 193 211 194 199 183 192 170 194 161
Polygon -7500403 true true 211 162 221 162 235 161 244 151 261 142 250 132 258 120 243 116 233 111 213 110 201 121 194 134 196 143
Polygon -7500403 true true 91 142 81 142 67 143 55 143 46 149 40 156 32 164 59 188 69 193 89 194 101 183 108 170 106 161
Polygon -7500403 true true 133 101 133 91 132 77 125 68 111 64 102 62 86 59 87 71 82 79 81 99 92 111 105 118 114 116
Polygon -7500403 true true 144 110 149 97 148 86 138 76 139 61 130 54 120 45 102 67 93 81 88 90 89 102 94 114 109 117 126 117
Polygon -7500403 true true 156 190 151 203 152 214 162 224 153 243 161 249 170 258 198 233 207 219 212 210 211 198 206 186 191 183 174 183
Polygon -7500403 true true 80 154 70 154 56 153 47 146 43 132 41 123 33 112 48 108 58 103 78 102 90 113 97 126 95 135
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 203 125 216 120 227 121 237 131 251 135 242 153 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 125 214 120 225 121 241 124 250 137 240 154 262 159 244 167 230 176 221 181 209 180 197 175 194 160 194 143
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 214 77 225 75 208 111 195 118 186 116
Polygon -16777216 true false 178 107 194 88 184 105
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 203 139 213 139 227 138 236 131 240 117 242 108 250 97 235 93 235 83 205 87 193 98 186 111 188 120
Polygon -16777216 true false 191 128 201 114 220 110 204 116

sunflower-0
false
0
Polygon -7500403 true true 116 183 116 193 115 207 108 216 79 237 80 220 71 226 70 214 60 217 64 185 75 173 88 166 97 168
Polygon -7500403 true true 156 110 151 97 152 86 162 76 161 61 170 54 180 45 198 67 207 81 212 90 211 102 206 114 191 117 174 117
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 178 195 178 205 179 219 186 228 215 249 214 232 223 238 224 226 234 229 230 197 219 185 206 178 197 180
Polygon -7500403 true true 80 146 70 146 56 147 47 154 43 168 41 177 33 188 48 192 58 197 78 198 90 187 97 174 95 165
Polygon -7500403 true true 144 190 149 203 148 214 138 224 129 230 118 239 110 251 102 233 93 219 88 210 89 198 94 186 109 183 126 183
Polygon -7500403 true true 209 142 219 142 233 143 242 150 246 164 248 173 256 184 241 188 231 193 211 194 199 183 192 170 194 161
Polygon -7500403 true true 211 162 221 162 235 161 244 151 261 142 250 132 258 120 243 116 233 111 213 110 201 121 194 134 196 143
Polygon -7500403 true true 91 142 81 142 67 143 55 143 46 149 40 156 32 164 59 188 69 193 89 194 101 183 108 170 106 161
Polygon -7500403 true true 133 101 133 91 132 77 125 68 111 64 102 62 86 59 87 71 82 79 81 99 92 111 105 118 114 116
Polygon -7500403 true true 144 110 149 97 148 86 138 76 139 61 130 54 120 45 102 67 93 81 88 90 89 102 94 114 109 117 126 117
Polygon -7500403 true true 156 190 151 203 152 214 162 224 153 243 161 249 170 258 198 233 207 219 212 210 211 198 206 186 191 183 174 183
Polygon -7500403 true true 80 154 70 154 56 153 47 146 43 132 41 123 33 112 48 108 58 103 78 102 90 113 97 126 95 135
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 203 125 216 120 227 121 237 131 251 135 242 153 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 125 214 120 225 121 241 124 250 137 240 154 262 159 244 167 230 176 221 181 209 180 197 175 194 160 194 143
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -1184463 true false 110 110 80
Circle -10899396 true false 120 120 60
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 214 77 225 75 208 111 195 118 186 116
Polygon -16777216 true false 178 107 194 88 184 105
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 203 139 213 139 227 138 236 131 240 117 242 108 250 97 235 93 235 83 205 87 193 98 186 111 188 120
Polygon -16777216 true false 191 128 201 114 220 110 204 116

sunflower-1
true
0
Circle -14835848 true false 75 75 150
Polygon -16777216 true false -1 148 23 165 49 170 70 165 105 150 72 133 50 126 21 132
Polygon -16777216 true false 152 -1 135 23 130 49 135 70 150 105 167 72 174 50 168 21
Polygon -16777216 true false 152 301 135 277 130 251 135 230 150 195 167 228 174 250 168 279
Polygon -16777216 true false 301 148 277 165 251 170 230 165 196 150 228 133 250 126 279 132
Polygon -16777216 true false 14 210 39 212 62 210 87 193 107 165 75 163 44 169 23 188
Polygon -16777216 true false 90 14 88 39 91 60 110 87 136 106 137 75 131 44 112 23
Polygon -16777216 true false 210 14 212 39 209 60 190 89 166 106 163 75 169 44 188 23
Polygon -16777216 true false 210 286 212 261 209 240 189 214 165 195 163 225 169 256 188 277
Polygon -16777216 true false 91 283 89 258 92 237 112 211 136 195 138 222 132 253 113 274
Polygon -16777216 true false 286 210 261 212 240 209 214 189 196 166 225 163 256 169 277 188
Polygon -16777216 true false 284 89 259 87 238 90 212 110 195 135 223 136 254 130 275 111
Polygon -16777216 true false 14 90 39 88 60 91 87 108 106 135 75 137 44 131 23 112
Polygon -16777216 true false 45 255 48 229 59 209 80 187 123 180 110 217 92 241 70 254
Polygon -16777216 true false 45 45 48 71 59 91 80 113 122 122 110 83 92 59 70 46
Polygon -16777216 true false 255 45 252 71 241 91 220 113 182 120 190 83 208 59 230 46
Polygon -16777216 true false 255 255 252 229 241 209 220 187 180 180 190 217 208 241 230 254
Circle -1184463 true false 113 113 74
Circle -10899396 true false 120 120 60
Polygon -7500403 true true 152 -1 135 23 130 49 135 70 150 102 167 72 174 50 168 21
Polygon -7500403 true true 205 13 212 39 209 60 190 89 166 104 163 75 169 44 188 23
Polygon -7500403 true true 255 45 252 71 241 91 220 113 183 118 190 83 208 59 230 46
Polygon -7500403 true true 284 89 259 87 238 90 212 110 199 133 223 136 254 130 275 111
Polygon -7500403 true true 300 150 277 165 251 170 230 165 199 151 228 133 250 126 279 132
Polygon -7500403 true true 286 210 261 212 240 209 214 189 199 167 225 163 256 169 277 188
Polygon -7500403 true true 255 255 252 229 241 209 220 187 182 179 190 217 208 241 230 254
Polygon -7500403 true true 210 283 212 261 209 240 189 214 166 196 163 225 169 256 188 277
Polygon -7500403 true true 152 301 135 277 130 251 135 230 150 199 167 228 174 250 168 279
Polygon -7500403 true true 91 283 89 258 92 237 112 211 136 198 138 222 132 253 113 274
Polygon -7500403 true true 48 261 48 229 59 209 80 187 121 182 110 217 92 241 70 254
Polygon -7500403 true true 16 209 39 212 62 210 87 193 104 166 75 163 44 169 23 188
Polygon -7500403 true true -1 148 23 165 49 170 70 165 103 151 72 133 50 126 21 132
Polygon -7500403 true true 14 90 39 88 60 91 87 108 104 136 75 137 44 131 23 112
Polygon -7500403 true true 45 46 48 71 59 91 80 113 120 121 110 83 92 59 70 46
Polygon -7500403 true true 90 15 88 39 91 60 110 87 135 104 137 75 131 44 112 23
Polygon -16777216 true false 107 193 78 219 61 240
Polygon -16777216 true false 107 107 81 78 60 61
Polygon -16777216 true false 193 107 222 81 239 60
Polygon -16777216 true false 193 193 219 222 240 239
Polygon -16777216 true false 220 177 236 181 267 199
Polygon -16777216 true false 72 182 52 195 33 199
Polygon -16777216 true false 123 80 105 50 101 33
Polygon -16777216 true false 220 123 245 114 267 101
Polygon -16777216 true false 177 220 188 233 199 267
Polygon -16777216 true false 123 220 112 233 101 267
Polygon -16777216 true false 80 123 67 112 33 101
Polygon -16777216 true false 177 80 188 67 199 33
Polygon -16777216 true false 151 84 155 36 152 17
Polygon -16777216 true false 84 149 74 152 17 148
Polygon -16777216 true false 216 149 229 147 283 148
Polygon -16777216 true false 151 216 155 264 152 283

sunflower-2
true
0
Circle -14835848 true false 75 75 150
Polygon -16777216 true false -1 148 23 165 49 170 70 165 105 150 72 133 50 126 21 132
Polygon -16777216 true false 152 -1 135 23 130 49 135 70 150 105 167 72 174 50 168 21
Polygon -16777216 true false 152 301 135 277 130 251 135 230 150 195 167 228 174 250 168 279
Polygon -16777216 true false 301 148 277 165 251 170 230 165 196 150 228 133 250 126 279 132
Polygon -16777216 true false 14 210 39 212 62 210 87 193 107 165 75 163 44 169 23 188
Polygon -16777216 true false 90 14 88 39 91 60 110 87 136 106 137 75 131 44 112 23
Polygon -16777216 true false 210 14 212 39 209 60 190 89 166 106 163 75 169 44 188 23
Polygon -16777216 true false 210 286 212 261 209 240 189 214 165 195 163 225 169 256 188 277
Polygon -16777216 true false 91 283 89 258 92 237 112 211 136 195 138 222 132 253 113 274
Polygon -16777216 true false 286 210 261 212 240 209 214 189 196 166 225 163 256 169 277 188
Polygon -16777216 true false 284 89 259 87 238 90 212 110 195 135 223 136 254 130 275 111
Polygon -16777216 true false 14 90 39 88 60 91 87 108 106 135 75 137 44 131 23 112
Polygon -16777216 true false 45 255 48 229 59 209 80 187 123 180 110 217 92 241 70 254
Polygon -16777216 true false 45 45 48 71 59 91 80 113 122 122 110 83 92 59 70 46
Polygon -16777216 true false 255 45 252 71 241 91 220 113 182 120 190 83 208 59 230 46
Polygon -16777216 true false 255 255 252 229 241 209 220 187 180 180 190 217 208 241 230 254
Circle -5825686 true false 94 94 112
Circle -16777216 true false 141 140 18
Polygon -7500403 true true 152 -1 135 23 130 49 135 70 150 102 167 72 174 50 168 21
Polygon -7500403 true true 205 13 212 39 209 60 190 89 166 104 163 75 169 44 188 23
Polygon -7500403 true true 255 45 252 71 241 91 220 113 183 118 190 83 208 59 230 46
Polygon -7500403 true true 284 89 259 87 238 90 212 110 199 133 223 136 254 130 275 111
Polygon -7500403 true true 300 150 277 165 251 170 230 165 199 151 228 133 250 126 279 132
Polygon -7500403 true true 286 210 261 212 240 209 214 189 199 167 225 163 256 169 277 188
Polygon -7500403 true true 255 255 252 229 241 209 220 187 182 179 190 217 208 241 230 254
Polygon -7500403 true true 210 283 212 261 209 240 189 214 166 196 163 225 169 256 188 277
Polygon -7500403 true true 152 301 135 277 130 251 135 230 150 199 167 228 174 250 168 279
Polygon -7500403 true true 91 283 89 258 92 237 112 211 136 198 138 222 132 253 113 274
Polygon -7500403 true true 48 261 48 229 59 209 80 187 121 182 110 217 92 241 70 254
Polygon -7500403 true true 16 209 39 212 62 210 87 193 104 166 75 163 44 169 23 188
Polygon -7500403 true true -1 148 23 165 49 170 70 165 103 151 72 133 50 126 21 132
Polygon -7500403 true true 14 90 39 88 60 91 87 108 104 136 75 137 44 131 23 112
Polygon -7500403 true true 45 46 48 71 59 91 80 113 120 121 110 83 92 59 70 46
Polygon -7500403 true true 90 15 88 39 91 60 110 87 135 104 137 75 131 44 112 23
Polygon -16777216 true false 107 193 78 219 61 240
Polygon -16777216 true false 107 107 81 78 60 61
Polygon -16777216 true false 193 107 222 81 239 60
Polygon -16777216 true false 193 193 219 222 240 239
Polygon -16777216 true false 220 177 236 181 267 199
Polygon -16777216 true false 72 182 52 195 33 199
Polygon -16777216 true false 123 80 105 50 101 33
Polygon -16777216 true false 220 123 245 114 267 101
Polygon -16777216 true false 177 220 188 233 199 267
Polygon -16777216 true false 123 220 112 233 101 267
Polygon -16777216 true false 80 123 67 112 33 101
Polygon -16777216 true false 177 80 188 67 199 33
Polygon -16777216 true false 151 84 155 36 152 17
Polygon -16777216 true false 84 149 74 152 17 148
Polygon -16777216 true false 216 149 229 147 283 148
Polygon -16777216 true false 151 216 155 264 152 283
Circle -16777216 true false 129 139 10
Circle -16777216 true false 161 139 10
Circle -16777216 true false 151 161 10
Circle -16777216 true false 129 151 10
Circle -16777216 true false 139 129 10
Circle -16777216 true false 151 129 10
Circle -16777216 true false 161 151 10
Circle -16777216 true false 139 161 10
Circle -16777216 true false 173 145 10
Circle -16777216 true false 145 117 10
Circle -16777216 true false 126 126 10
Circle -16777216 true false 145 173 10
Circle -16777216 true false 117 145 10
Circle -16777216 true false 164 126 10
Circle -16777216 true false 164 164 10
Circle -16777216 true false 126 164 10
Circle -16777216 true false 158 113 10
Circle -16777216 true false 132 113 10
Circle -16777216 true false 177 132 10
Circle -16777216 true false 158 177 10
Circle -16777216 true false 113 158 10
Circle -16777216 true false 177 158 10
Circle -16777216 true false 132 177 10
Circle -16777216 true false 113 132 10
Circle -16777216 true false 174 117 10
Circle -16777216 true false 174 117 10
Circle -16777216 true false 173 174 10
Circle -16777216 true false 116 173 10
Circle -16777216 true false 117 116 10
Circle -16777216 true false 104 146 10
Circle -16777216 true false 144 104 10
Circle -16777216 true false 186 144 10
Circle -16777216 true false 146 186 10
Circle -16777216 true false 192 128 10
Circle -16777216 true false 98 128 10
Circle -16777216 true false 162 98 10
Circle -16777216 true false 192 162 10
Circle -16777216 true false 128 192 10
Circle -16777216 true false 162 192 10
Circle -16777216 true false 98 162 10
Circle -16777216 true false 128 98 10
Circle -16777216 true false 176 104 10
Circle -16777216 true false 114 186 10
Circle -16777216 true false 104 114 10
Circle -16777216 true false 91 145 10
Circle -16777216 true false 186 176 10
Circle -16777216 true false 104 176 10
Circle -16777216 true false 114 104 10
Circle -16777216 true false 186 114 10
Circle -16777216 true false 176 186 10
Circle -16777216 true false 145 91 10
Circle -16777216 true false 199 145 10
Circle -16777216 true false 145 199 10

sunflower-3
true
0
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 188 179
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 127 110
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 159 107 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 107 123 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 168 106 167 91 168 77 175 68 189 64 198 62 209 54 213 69 218 79 219 99 208 111 195 118 186 116
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 204 140 214 140 228 139 237 132 241 118 243 109 251 98 236 94 226 89 206 88 194 99 187 112 189 128
Polygon -16777216 true false 203 125 216 120 227 121 237 131 243 140 252 151 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 124 214 119 225 120 235 130 241 139 250 150 262 158 244 166 230 175 221 180 209 179 197 174 194 159 194 142
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 171 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 202 178 215 177 226 167 236 158 242 147 251 139 263 131 245 122 231 117 222 118 210 123 198 138 195 155 195
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 128 190 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 172
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 180 103 196 84 186 101
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 200 124 210 110 229 106 213 112
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -1184463 true false 112 113 76
Circle -10899396 true false 121 122 58

sunflower-4
true
0
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 218 79 219 99 208 111 195 118 186 116
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 204 140 214 140 228 139 237 132 241 118 243 109 251 98 236 94 226 89 206 88 194 99 187 112 189 121
Polygon -16777216 true false 203 125 216 120 227 121 237 131 243 140 252 151 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 124 214 119 225 120 235 130 241 139 250 150 262 158 244 166 230 175 221 180 209 179 197 174 194 159 194 142
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 180 103 196 84 186 101
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 200 124 210 110 229 106 213 112
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8

sunflower-5
true
0
Circle -14835848 true false 90 90 120
Polygon -7500403 true true 104 217 102 227 109 224 107 233 111 227 112 235 117 231 120 239 124 234 127 239 134 231 139 222 144 206 133 195 121 191 110 200 99 211 99 218
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8
Polygon -7500403 true true 137 235 140 242 144 237 147 242 151 237 156 242 158 237 162 241 166 237 169 240 173 234 172 226 172 216 168 202 157 196 144 194 132 207 132 222 131 239
Polygon -7500403 true true 132 61 135 54 139 59 142 54 146 59 151 54 153 59 157 55 161 59 164 56 168 62 167 70 167 80 163 94 152 100 139 102 127 89 127 74 126 57
Polygon -7500403 true true 61 162 54 159 59 155 54 152 59 148 54 143 59 141 55 137 59 133 56 130 62 126 70 127 80 127 94 131 100 142 102 155 89 167 74 167 57 168
Polygon -7500403 true true 237 161 244 158 239 154 244 151 239 147 244 142 239 140 243 136 239 132 242 129 236 125 228 126 218 126 204 130 196 139 196 154 209 166 224 166 241 167
Polygon -7500403 true true 76 105 66 103 69 110 60 108 66 112 58 113 62 118 54 121 59 125 54 128 62 135 71 140 97 145 102 133 105 122 93 111 82 100 75 100
Polygon -7500403 true true 100 80 98 70 105 73 103 64 107 70 108 62 113 66 116 58 120 63 123 58 130 66 135 75 140 97 131 104 120 111 108 103 95 86 95 79
Polygon -7500403 true true 219 102 229 100 226 107 235 105 229 109 237 110 233 115 241 118 236 122 241 125 233 132 224 137 208 142 197 131 193 119 202 108 213 97 220 97
Polygon -7500403 true true 198 217 200 227 193 224 195 233 191 227 190 235 185 231 182 239 178 234 175 239 168 231 163 222 158 206 169 195 181 191 192 200 203 211 203 218
Polygon -7500403 true true 78 192 68 194 71 187 62 189 68 185 60 184 64 179 56 176 61 172 56 169 64 162 73 157 89 152 100 163 104 175 95 186 84 197 77 197
Polygon -7500403 true true 199 79 201 69 194 72 196 63 192 69 191 61 186 65 183 57 179 62 176 57 169 65 164 74 159 90 170 101 182 105 193 96 204 85 204 78
Polygon -7500403 true true 217 192 227 194 224 187 233 189 227 185 235 184 231 179 239 176 234 172 239 169 231 162 222 157 206 152 195 163 191 175 200 186 211 197 218 197
Polygon -7500403 true true 87 211 80 213 82 206 76 206 74 202 86 185 99 181 109 182 116 186 121 195 115 210 105 221 94 223 95 214 88 218
Polygon -7500403 true true 85 88 83 81 90 83 90 77 94 75 111 87 115 100 114 110 110 117 101 122 86 116 75 106 73 95 82 96 78 89
Polygon -7500403 true true 218 88 225 86 223 93 229 93 231 97 219 114 206 118 196 117 189 113 184 104 190 89 200 78 211 76 210 85 217 81
Polygon -7500403 true true 215 210 217 217 210 215 210 221 206 223 189 211 185 198 18                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             