;;  Model name:   "GenderRace"   version 1.0
;;  Author: R. Wade Schuette
;;  Copyright (c) 2020
;;  by Shewnexti LLC
;;  ( http://shewnexti.com )
;;
;  This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <https://www.gnu.org/licenses/>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; purpose:  To illustrate that a culture of asking for and giving help overcomes individual disadvantages,
;;           resulting in superior team performance. See the INFO section for more details.
;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  this was written and tested using NetLogo 6.1.1 for Windows 10 for development
;;  and NetLogo Web 2.8.1
;;  see http://ccl.northwestern.edu/netlogo/
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

globals [

  ;; VERBOSE           ;  true if we want to fire the debugging print commands, false otherwise, set in a slider
  STOPFLAG          ;  set this to true to stop the run from deep inside a loop
                    ;  because a simple "stop" command only breaks out of that loop

  MAXTICKS          ;  set to prevent infinite running
  myCounter         ;  utility counter for testing and debugging;

  MDoneCount      ;
  MDoneTick       ;
  FDoneCount    ;
  FDoneTick     ;
  failsBeforeAsking ;
  totalTryCount     ;

  ;; the following are set by sliders

  ;; hurdleM ;    How hard a task is this for a m working alone
  ;; hurdleF;   How hard a task is this for a f working alone

  ;; humilityM and humilityF ;; How willing is a person to admit they are stuck and ask for help?
  ;; empathyM  and empathyF  ;; How willing is a person to stop and go back to help someone else?

  masculineColor;   you can reset this in setup below
  feminineColor;    you can reset this in setup below
  GENDERXX ;;  parameter passed to subroutines, will be either "F" or "M""
  HOTAGENT  ;; the turtle being analyzed within the STILLWORking worklist
 ;; PEEPS     ;; number of members of each team, set by slider at the far right of the screen

 ];

turtles-own ;; PROPERTIES / ATTRIBUTES of individuals
[
   gender;     M or F,   feminine or masculine spirit
   task  ;     #1 to 10, which step of today's work are they on?

  ;; personal difficulty completing their task alone?
  hurdle;

  ;; How many times have they tried and failedd with this task
  ;; since startup or since the last time they succeeded?
  failCount;

  ;; Has the program's bookkeeper noted this person's state?
  tallied;

  ;; "character" traits
  oddsGiveHelp    ;   Likelihood that will give help if someone asks
  oddsAskForHelp  ;   Likelihood that they will ask for help themselves if they are stuck

  failCountTrigger;   inverse of humility,  how many times must they fail before they ask for help?

  ;; utility bookkeeping variables
  isMyHandRaised;  Have I asked for help?

  didHelpArrive;   Did someone offer to help?
  whoIsMyHelper;   Who offered to help?   ( draw a link to that person )

  amIHelpingOut;   Am I already occupied helping someone else?
  whoAmIHelping;   Who am I helping?

]




to setup
  clear-all;       clear all variables
  print "\nStarting a new run...";

  ;; set variables for testint and debugging here
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;set VERBOSE true;    set in a slider to true to use extra print commands
  set myCounter 0;

  ;; set universal run parameters
  set MAXTICKS 500;   to prevent the program from running forever
  set feminineColor  pink;
  set masculineColor green;

 ;; no-display;   shut off the screen display while updating so it runs faster, turned back on below
 ;;  no-display is not compatible with NETLOGO WEB which is why it is commented out here.

  ;; SET the initial values for this run
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  set totalTryCount 0;
  let numpeeps  PEEPS;
  set  failsBeforeAsking 10;


  ;; draw a grey vertical finish line;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    let LINECOLOR grey;
    let y -13;
    let x   7;
    repeat 25 [ set y (y + 1)  ask patch x y [ set pcolor LINECOLOR ]];



  ;;; Create people of feminine gender and place them on the board
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  set x   -12;
  set y    0;
  repeat numpeeps ;; make #numpeeps people on the upper half of the board
  [
    set y (y + 2);
    create-turtles 1 [  setxy x y  set gender "F"   ];
    ask patch (x - 2) y [ set plabel "F" set plabel-color feminineColor ]

  ]

  ;;  add "f" traits read from the sliders for the F group
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ask turtles with [ gender = "F" ]
  [
   set color feminineColor;
   set hurdle hurdleF;
   set oddsAskForHelp humilityF;
   set oddsGiveHelp empathyF;
  ]

  ;; create people with masculine gender on the bottom half of the board
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;

  set x -12;
  set y   0;
  repeat numpeeps
  [
    set y   (y - 2);
    create-turtles 1 [ setxy x y set gender "M"  ];
    ask patch (x - 2) y [ set plabel "M" set plabel-color masculineColor ]
  ]

  ;; add masculine traits read from the sliders for the M group
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ask turtles with [ gender = "M" ]
  [
   set color masculineColor;
   set hurdle hurdleM;
   set oddsAskForHelp humilityM;
   set oddsGiveHelp empathyM;
  ]

  ;;  put bottom task-numbeers on the picture
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  let zx -14;  what patch on the horizontal grid
  let zn 0  ;  what number task
  repeat 10
  [ set zx (zx + 2);
    set zn (zn + 1);
    ask patch zx -14
       [
          set plabel zn;
          set plabel-color red ;
       ]
  ]

  ;; Set heading, size, shape, and numeric varible to their initial values
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;; convert the slider value into a better numeric value for using in calculations and prevent divide-by-zero error
  ask turtles [    set failCountTrigger  ( 3 /( oddsAskForHelp + 0.01)) ]  ;

  ask turtles
  [
    set tallied 0
    set heading 90
    set size 1.5
    set shape "person"
    set task 1
    set failCount 0

    set isMyHandRaised 0

    set didHelpArrive 0
    ;;set whoIsMyHelper  will be set later

    set amIHelpingOut 0
   ;; whoAmIHelping will be set later

    ;;  for calculations we will map the humility slider values in the [0,1] range
    ;;  into a fail-count number in the [300, 2.99] range
    ;;  which is rather arbitrary but accomplishes what we want and lets the sliders all be similar
    ;;  so the user interface looks a little bit tidier.
    ;;
    ;;  There is no magic to the "3", just replace 3 with the smallest number we'd ever user.
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    set failCountTrigger  ( 3 /( oddsAskForHelp + 0.01));

  ]

 ;; display;  not a valid NETLOGO WEB command
  reset-ticks;
  tick;   so we start at one not zero for new users comfort

          ;; start clock at time two tick instead of zero for convenience in programming below.
           ;; otherwise has no impact on the outcome.
end; ;; of the SETUP step

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; note - excatly the same code runs for "go" or "step", it's just that for "go"
;; it automtically loops and keeps on going,  but for "step" it makes one pass and pauses
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go

  if (STOPFLAG = true) [ stop ] ;; stpp if this flag was set by some prior loop

  let tickcount ticks;     ( I pulled this out up front so i don't inadvertently change it below )

  set totalTryCount ( totalTryCount + 1 )     ;   keep track of how many times this loop has been run
                                              ;   because it might be useful later in testing or debugging

  let StillWorking turtles with [ task < 11 ] ;   Similarly, pull out a fixed set of agents ( "turtles")
                                              ;   up front so there's no chance I accidentally change that
                                              ;   list in the code below.

                                              ;   in our case, a randomly ordered set of all the people
                                              ;   who are not yet over the finish line.

  ask StillWorking ;; this is an agentset, initially 2*PEEPS agents in it
  [
       set myCounter ( myCounter + 1 )

       set HOTAGENT who;  print (word "looking at agent " HOTAGENT);
       ;; if ( VERBOSE = true ) [ print ( word "current agent being considered is " HOTAGENT ); ];


       ;; BEFORE I do anything else, see if someone needs help who hasn't received it;
       ;;        in case I am willing to let that change my plans
       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       ;; if there are any fs with hands raised and not being helped at this instant
       ;; AND if I am f and I am not currently helping someone else out
       ;; THEN

       ;;  FFF only link to FFF,  MMM only link to MMM, so we need to write this code twice?

       set GENDERXX "F";
       if (( 0 < count  other turtles with [ gender = GENDERXX and isMyHandRaised = 1 and didHelpArrive = 0]  )
              and (gender = GENDERXX and amIHelpingOut = 0))
       ;; THEN ...
       ;;      pick any one waiting for help
       ;;      create a link with it
       ;;      ask it to record thathelp has in fact now arrived from me
       ;;      note in my own record that I am now helping out so I won't pick up another one to help
       ;;      and finally note who it is I'm helping out. ( They already linked to me )

       [
           let needy one-of other turtles with [ gender = GENDERXX and isMyHandRaised = 1 and didHelpArrive = 0]

          ;; now,  they may be asking but am I the answering type?
          let diceroll2 random-float 1.0;
          if (diceroll2 < empathyF)
          [
             create-link-to needy;
             ask needy
                [
                   set didHelpArrive 1
                   set whoIsMyHelper needy
                   set isMyHandRaised 0 ;
                   set size 1.5         ;
                   set failCount 0;
                ]
             set amIHelpingOut 1
             set whoAmIHelping needy;
          ]
       ]

      set GENDERXX "M"
       if (( 0 < count  other turtles with [ gender = GENDERXX and isMyHandRaised = 1 and didHelpArrive = 0]  )
              and (gender = GENDERXX and amIHelpingOut = 0))
       ;; THEN ...
       ;;      pick any one waiting for help
       ;;      create a link with it
       ;;      ask it to record thathelp has in fact now arrived from me
       ;;      note in my own record that I am now helping out so I won't pick up another one to help
       ;;      and finally note who it is I'm helping out. ( They already linked to me )
       [
           let needy one-of other turtles with [ gender = GENDERXX and isMyHandRaised = 1 and didHelpArrive = 0]

          ;; now,  they may be asking but am I the answering type?
          let diceroll2 random-float 1.0;
          if (diceroll2 < empathyM)
          [
             create-link-to needy;
             ask needy
                [
                   set didHelpArrive 1
                   set whoIsMyHelper needy
                   set isMyHandRaised 0 ;
                   set size 1.5         ;
                   set failCount 0;
                ]
             set amIHelpingOut 1
             set whoAmIHelping needy;
          ]
       ]





       ;;;;;;;;;;;;;;;;;; ok,  we may have linked to someone to help, in which case "amIHelpingOut = 1"

       let rolldice random-float 1.0;    make one attempt to do my current task

       ;; TEST FOR SUCCESS but first,  divide the HURDLE size ( task difficulty ) by the number in my tiny workgroup
       ;;   other mappings could be used but this seems like an easy first cut. with 2 people the task will be half as hard.

       ;;   ifelse (rolldice >= hurdle )

       let pairsize 1;                     this is a new variable saying whether I'm a "pair" of size 1 or 2 or 3 etc.
       if (didHelpArrive = 1)  [ Set pairsize 2];    ;; if help arrived ASSUME it will never leave again.

       ifelse ( rolldice >=  ( hurdle / pairsize ))  ;; I or possibly WE SUCCEDED!
       [

          set task (task + 1)  ;;   advance to next assignment
          forward 2;           ;;   move my marker on the board
          set failCount 0;    ;;   reset count of how many fails since last success or starting.


          ;; Now it's possible that the "forward 2" command got the guy past the finish line
          ;;   also known as task now working on is #11
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          if ((task >= 11) and (tallied = 0))   ;; if over the line and not yet TALLIED as "done" , update statistcs
          [
            if (gender = "M")  [ set MDoneCount   (MDoneCount   + 1)  set MDoneTick   tickcount set tallied 1 set size 2]
            if (gender = "F")  [ set FDoneCount (FDoneCount + 1)  set FDoneTick tickcount set tallied 1 set size 2]

            if ( task >= 11) [   set size 2  ]  ;; make it more obvious who is done
          ] ;; end of what to do when I cross the finish line

       ]

       ;;;;;;;;;;;;;;;;;;;;;;;;;; end of success , the ELSE clause deals with what if I did NOT accomplish this task on this try

       ;; ... ELSE ...
       [  ;; begin activities if FAILED this current task, possibly even with help

        set failCount (failCount + 1)  ;;  record one more failure

        ;;if (failCount > totalTryCount)  [ print ( word "tickcount " tickcount who " gender " gender ",  tries " totalTryCount ",  fails: " failCount ) ]

        ;; now combine # of times failed with humilty setting to determine if raise hand or not
        ;; need some equation that captures that

        if ( failCount > failCountTrigger)
          [
              set size 3  set isMyHandRaised 1
          ]

      ] ;; end activities if FAILED yet one more time


    ] ;; end of one pass thrugh the stillworking list



 ;; stopping condition for the simulation
 ;; if there are no turtles left that have not had success tallied
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 if (0 = count turtles with [ tallied = 0 ] )
  [
      set STOPFLAG true;

      if (display_Below = true )
      [
        print (word "\n\nNormal completion: " PEEPS " people per team, and everyone is done.");
        print (word "You set:   Hurdle: "  hurdleM "-" hurdleF ", Humility: " humilityM "-" humilityF ", Empathy: " empathyM "-" empathyF
        "\n   and got this result: MMM:" " count "  MDoneCount   " at time " MDoneTick     " ; " "FFF: count " FDoneCount " at time " FDoneTick   );
      ]

  ]

 ;; We didn't just stop so the overall run is not yet complete, but check to see if we are out of time.
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    if ( ticks >= MAXTICKS ) [ print (word "Maximum time of " MAXTICKS " was hit, so I stopped the run.") set STOPFLAG true ]

 ;; We're not done, and we're not outof time, so advance the clock and go around again!
    ;;if (STOPFLAG = false ) [tick];
  tick;

end; ;; of the GO step

;;;;;;;;;;;  UTILITY routines -- factored out from above to make the above code easier to read and understand
@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
58
104
159
137
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
59
185
159
218
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
12
304
110
349
# MMM done 
mDoneCount
0
1
11

MONITOR
115
305
200
350
MMM's time
mDoneTick
0
1
11

MONITOR
13
369
109
414
# FFF done
fDoneCount
0
1
11

MONITOR
114
370
200
415
FFF''s time
fDoneTick
0
1
11

SLIDER
724
97
846
130
hurdleM
hurdleM
0
1.0
0.7
0.1
1
NIL
HORIZONTAL

SLIDER
723
135
846
168
hurdleF
hurdleF
0
1.0
0.8
0.1
1
NIL
HORIZONTAL

BUTTON
57
144
156
177
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
676
60
897
94
How hard is this kind of task for any one solo  individual?
14
0.0
1

TEXTBOX
678
194
891
228
How willing is anyone to ask for help?\n
14
0.0
1

TEXTBOX
675
329
907
380
How willing is anyone to go\nback and help someone else?\n
14
0.0
1

SLIDER
727
229
840
262
humilityM
humilityM
0
1.0
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
729
266
838
299
humilityF
humilityF
0
1.0
0.9
0.1
1
NIL
HORIZONTAL

SLIDER
726
378
847
411
empathyM
empathyM
0
1.0
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
727
420
846
453
empathyF
empathyF
0
1.0
0.9
0.1
1
NIL
HORIZONTAL

TEXTBOX
16
12
201
59
 \"Gendercase - v1\"
18
95.0
1

TEXTBOX
26
108
51
126
1)
17
15.0
1

TEXTBOX
27
150
44
168
2)
17
15.0
1

TEXTBOX
27
190
45
211
3)
17
15.0
1

TEXTBOX
35
59
185
91
        To run \n--------------------
16
15.0
1

TEXTBOX
857
123
893
141
Hard\n
14
15.0
1

TEXTBOX
689
126
723
144
Easy
14
0.0
1

TEXTBOX
856
252
892
286
Very \nwilling
14
95.0
1

TEXTBOX
687
252
733
303
Not\nwilling
14
15.0
1

TEXTBOX
685
394
726
428
Not\nwilling
14
15.0
1

TEXTBOX
863
396
904
430
Very\nwilling
14
105.0
1

TEXTBOX
48
245
199
311
      Results\n-------------------
18
35.0
1

TEXTBOX
717
17
867
61
      Settings\n--------------------
18
95.0
1

SWITCH
27
429
160
462
display_below
display_below
0
1
-1000

SLIDER
938
99
1116
132
PEEPS
PEEPS
1
7
5.0
1
1
people per team
HORIZONTAL

TEXTBOX
765
465
838
483
( more ---> )
11
85.0
1

TEXTBOX
568
465
640
483
( more ---> )
11
85.0
1

SWITCH
950
358
1058
391
VERBOSE
VERBOSE
0
1
-1000

TEXTBOX
946
327
1121
369
For use in debugging\n====================
11
75.0
1

TEXTBOX
941
33
1125
75
Rarely used settings\n====================
11
85.0
1

@#$#@#$#@
## WHAT IS IT?

This model ishows one way that teamwork can overcome the limitations of individual team members.  In this model two teams compete to complete ten tasks.   Sometimes even if the team members are not highly skilled, the overall team can be made stronger by collaboration and out-perform teams which do not use collaboration.

The user can set different values for each team of three variables -- how hard the task is to them,  how much "humility" they have, and how much "empathy" they have.   Humility is measured by willingness to admit one needs help and ask for it.   Empathy is measured by willingness to help someone else who has asked for help. 

## HOW IT WORKS

The completion of tasks is shown as a race across the screen from left to right.

Each team member starts at the left with a first task which they might complete each time step.  If they complete task #1, they move on to task #2. The task numbers are at the bottom of the display.  When everyone has completed ten tasks, the play stops and a summary may print at the bottom if you have that feature turned on.

There are two team names, "F" and "M",  historically reflecting a more "feminine" approach to decision making and a "masculine"approach. The meaning of F and M and the nature of the culture each team's members share is up to you. The two team types are treated identically by the computer, but you can give them different attributes by using the sliders.
 
If they fail to complete the task they keep on trying. After a certain number of failures in a row, they get visibly larger, raise their hands and broadcast a request for help. At that point, other members of the same team may elect to respond to the request for help, or they might ignore it. If they choose to respond, they will link up to the one having the problem, and divide the work,  increasing the odds that it will be completed each tick.  

The odds that a task will get done by that type of team member, their willingness to admit a problem and raise their hand, and the willingness of other team members to respond and come to help  are all set by sliders.

## HOW TO USE IT

The "action"  all takes place in the black graphics area.  Frequenty used items are on the left of the screen, less frequently used ones are to the right, possibly out of sight, in which case you can use a big grey slider to move your view, or you can expand the window size to see everything at once. 

The number of members of each team is controlled by a slider at the top and far right side of the screen, possibly out of sight, in which case you need to expand the window size by dragging the right edge, or to move your view using a grey slider along the bottom which shows up if the window is too small to show everything at once.
 
To make things happen click the buttons at the left, starting with SETUP. After SETUP runs you can advance the clock one tick, one step , by clicking STEP, but that is not required.  You can STEP as many times as you like.  When you are ready to, click the GO button and the clock will start running.  The speed of the clock is controlled by a slider at the very top of the display.  You can ignore everything else at the top of the dispay in the grey bar. 

Clicking SETUP puts two teams on the board, color coded and labelled. Clicking STEP will advance the clock 1 tick, and some of the agents will complete their tasks and move one step to the right.  Clicking GO ( "run/puase") will let the clock run until either all the work is done or the game hits a safety timeout and stops;  the team members will migrate at different speeds across the board to the finish line.

Before starting a new round of the model, the sliders at the right can be set to desired values.  

NOTE: Please set them before hitting SETUP -- the results of changing the sliders in the middle of a run are unpredictable. 

Each variable ( task-difficulty, humilty, empathy) can be set by you to have one value for each team, and every member of that team will use those same values, but the other team may have different values.


## THINGS TO NOTICE

Everying that happens is based on random factors, based on a roll of the dice that affects whether a task gets done,  whether a team member who has humility or empathy uses it.  So the results of each run with the exact same settings will be slightly different -- this is a "feature" not a "bug" of so-called "Agent-Based Models".

A team with high humility and high empathy will tend to link up and move as a group, typically faster than solo team members. The links are shown as lines.   Team members who are still asking for help and haven't yet partnered-up are shown at twice the usual size. 
As the clock ticks and the team members move left to right,  the number of players on each team who are done is shown in a small monitor window on the bottom left.  The time a player last succceeded is shown in another small window, one each for the f and M teams.
When every player on a team is done and to the right of the grey bar,  the tick-count is the final time it took for the last team member to complete all tasks.

If you turn on the switch on the far right to DISPLAY_BELOW the settings of the switches and the results are shown in text at the very bottom in the control center.  This can be shut off if is annoying or distracting. When it is turned on it allows you to record what settings produced an interesting result for trying again later or discussing.


## THINGS TO TRY

If you set difficulty low for both teams,  and set both empathy and humility to their lowest levels,  both teams should commplete the ten tasks in ten ticks of the clock.

REMEMBER if things happen too fast when you click the GO button,  you can use the slider at the very top in the grey bar area to controls the speed that the clock rolls forward,  very very slowly at the left,  faster and faster as you move it further to the right. 

If you want to examine behavnior more slowly, instead of hitting the RUN/PAUSE button you can hit the STEP button and examine the results. 

Try setting the difficulty for both teams at 0.5,  the empathy and humility maximum for the F team and zero for the M team, and running the model.    There should be a slight improvement in time for the cooperating team.   Then click the difficulty up one notch and run it again,  click it up ane more notch and run it again, and notice that theharder the work becomes, the more collaboration improves the outcomes.

Then set the difficulty for the F team, say, to 0.7, and for the M team to 0.5. This represents tasks which the F players have a harder time with than the M players.  Notice that maximizing colloaboration overcomes that hurdle and the F team still wins.

As always this very simple model doesn't "prove" anything, it simply lets you get some intution about how things might work.



## EXTENDING THE MODEL

These extensions require some programming experience and require that you have downloaded the model to your mac or windows computer.  No one else will see your changes unless you then upload your changed model back to the Modeling Commons.  How to do that is beyond these instructions.

Color assignemtns to the team is made in a single line near the top of the SETUP section.
If you don't like pink and blue,  some other colros are predefined like red, blue, green, yellow, etc.

In the current version, the member giving assistance is not penalized and continues completing their own tasks.  As an extension you might explore changing that.

Right now only one team member can help one member who needs help, they stop helping once they have finished their own tasks and they ae not slowed down by helping one another.All those could be changed. 

You can explore the impact of adding  up to two more team members on each team by changing the value of PEEPS, also found at the top of the SETUP section, from 5 to 7.   Beyond that you will need to expand the window which is beyond this instruction set. 

## NETLOGO FEATURES

No unusual NetLogo features were used.

## RELATED MODELS

This model is standalone at this time ( 1-Novemer-2020 ). There are no related models.

## CREDITS AND REFERENCES

A video demonstrating use of this model may be available shortly in the author's YouTube videos, available at https://www.youtube.com/user/wadediscovery  .
  
(c) copyright 2020 by R. Wade Schuette, Shewnexti LLC  ( see https://shewnexti.com )

;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
