;; This  model accompanies Joyce, J. forthcoming, Modelling agricultural strategies in the Dutch Roman limes zone via agent-based modelling (ROMFARMS). Springer (Basel)
;; and Joyce, J. forthcoming, Farming along the limes. Using agent-based modelling to investigate possibilities for subsistence and surplus-based agricultural production in the Lower Rhine delta between 12BC and 270AD, PhD thesis, Vrije Universiteit Amsterdam.

extensions [ gis ]

breed [ settlements settlement ]

breed [ persons person ]

breed [ animals animal ]

globals [
  raster
  settlement-density
  area
  d-pop
  d1-pop
  elderly-male-list
  elderly-female-list
  adult-male-list
  adult-female-list
  male-4th-list
  female-4th-list
  male-3rd-list
  female-3rd-list
  male-2nd-list
  female-2nd-list
  male-1st-list
  female-1st-list
  count-children-list
  pop-growth
  calories-in-crops
  fallow-time
  basic-yield
  sowing-rate
  yield-increase-manure
  N-content-manure
  sowing-time
  ploughing-time
  manuring-time
  harvesting-time
  ploughing-labour-list
  total-ploughing-labour-list
  sowing-labour-list
  total-sowing-labour-list
  manuring-labour-list
  total-manuring-labour-list
  harvesting-labour-list
  total-harvesting-labour-list
  min-arable-land-list
  arable-land-list
  yield-list
  surplus-list
  grain-deficit-list
  count-famines
  cattle-meat-list
  cattle-milk-list
  cattle-manure-list
  sheep-meat-list
  sheep-milk-list
  sheep-wool-list
  horse-surplus-list
  meadow-land-list
  pasture-land-list
  fodder-collection-time
  total-fodder-labour-list
  fodder-labour-list
  horse-pop-list
  cattle-pop-list
  sheep-pop-list
  d-pop-cattle
  d1-pop-cattle
  d-pop-horse
  d1-pop-horse
  d-pop-sheep
  d1-pop-sheep
  pop-growth-sheep
  pop-growth-cattle
  pop-growth-horse
  adult-weight-cattle
  immature-weight-cattle
  young-weight-cattle
  adult-weight-sheep
  immature-weight-sheep
  young-weight-sheep
  %-edible-carcass-cattle
  %-edible-carcass-sheep
  milk-yield-cattle
  milk-yield-sheep
  lactation-length-cattle
  lactation-length-sheep
  wool-yield-sheep
  manure-daily-yield
  twinning-rate-sheep
  alphaS
  alphaC
  alphaH
  alpha
  neonatal-mortality-sheep
  neonatal-mortality-cattle
  neonatal-mortality-horse
  annual-mortality-rate
  CYMR
  CIMR
  CAMR
  SYMR
  SIMR
  SAMR
  HIMR
  fodder-sheep
  fodder-cattle
  fodder-horse
  pasture-land-sheep
  pasture-land-cattle
  pasture-land-horse
  yield-grassland
  walking-speed
  max-load-adult-male
  max-load-adult-female
  max-load-other
  fuel-collection-time
  timber-collection-time
  fuel-workforce-list
  total-fuel-labour-list
  fuel-labour-list
  fuel-deficit-list
  distance-travelled-fuel-list
  construction-labour-list
  construction-workforce-list
  timber-deficit-list
  distance-travelled-construction-list
  biomass-list
  biomass-forest-list
  catchment-area
]

patches-own [
  raster-value
  patch-owner
  landscape-type
  use
  biomass
  countdown-fallow
  countdown-reforest
]

settlements-own [
  no-households
  age
  people
  livestock
  catchment
  calories-required
  min-grain-store
  ploughing-labour-1
  ploughing-labour-2
  sowing-labour-1
  sowing-labour-2
  manuring-labour-1
  manuring-labour-2
  harvesting-labour-1
  harvesting-labour-2
  grain-store
  max-arable-land-land
  max-arable-land-grain
  max-arable-land-labour
  min-arable-land
  arable-land
  yield-grain
  surplus-grain
  grain-deficit
  SNM
  CNM
  SYM
  CYM
  SIM
  CIM
  SAM
  CAM
  cattle-meat-yield
  sheep-meat-yield
  cattle-milk-yield
  sheep-milk-yield
  sheep-wool-yield
  cattle-manure-yield
  horse-surplus
  pasture-land
  meadow-land
  fodder-labour-1
  fodder-labour-2
  fuel-workforce
  fuel-store
  fuel-target
  fuel-requirement
  fuel-labour-1
  fuel-labour-2
  construction-requirement
  construction-store
  construction-target
  construction-workforce
  construction-labour
]

persons-own [
  sex
  age
  my-spouse
  my-house
  distance-travelled-fuel
  distance-travelled-construction
  count-children
  mortality
  fertility
  load
  max-load
  processing-time-fuel
  processing-time-timber
]

animals-own [
  age
  sex
  species
  fertility
  survivorship
  my-owner
  lactating
]

to setup
  ca
  setup-landscape
  setup-globals
  setup-agents
  reset-ticks
end

to go
  if ticks = runtime[
    stop
  ]
  if not any? settlements [
    stop
  ]
  go-demography
  go-arable
  go-pastoral
  go-fuel
  go-construction
  update-globals
  update-patches
  ask settlements [
    ifelse age = reconstruction-frequency [
      set age 0
    ]
    [
      set age age + 1
    ]
  ]
  tick
end

to setup-landscape ;; sub-process generates landscape within which agents interact. Landscapes can be randomly-generated ("hyp") or reconstructed from palaeogeographic data (1-32).
   if region = "hyp" [
    resize-world -16 16 -16 16
    set-patch-size 13
    if area-levee > 0 [
      ask one-of patches [
        set pcolor brown
        set landscape-type "levee"
      ]
      while [ count patches with [ pcolor = brown ] < ( count patches * area-levee ) ] [
        ask one-of patches with [ pcolor = brown ] [
          if any? neighbors with [ pcolor != brown ] [
            ask one-of neighbors with [ pcolor != brown ] [
              set pcolor brown
              set landscape-type "levee"
            ]
          ]
        ]
      ]
    ]
    if area-floodbasin > 0 [
      while [ count patches with [ pcolor = green ] < ( count patches * area-floodbasin ) and any? patches with [ pcolor = brown and any? neighbors with [ pcolor != brown and pcolor != green ] ] ] [
        ask one-of patches with [ pcolor = brown ] [
          if any? neighbors with [ pcolor != brown and pcolor != green ] [
            ask one-of neighbors with [ pcolor != brown and pcolor != green ] [
              set pcolor green
              set landscape-type "floodbasin"
            ]
          ]
        ]
      ]
      while [ count patches with [ pcolor = green ] < ( count patches * area-floodbasin ) and count patches with [ pcolor = black ] > 0 ] [
        ask one-of patches with [ pcolor = green ] [
          if any? neighbors with [ pcolor != brown and pcolor != green ] [
            ask one-of neighbors with [ pcolor != green and pcolor != brown ] [
              set pcolor green
              set landscape-type "floodbasin"
            ]
          ]
        ]
      ]
    ]
    ask patches [
      set raster-value "null"
    ]
  ]
  ask patches [
    set raster-value "null"
  ]
  if region != "hyp" [ ;; if a reconstructed landscaped is simulate, sub-process loads the relevant raster file and assigns a settlement density value depending on period to be simulated.
    gis:load-coordinate-system "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/UTM_zone31N.prj"
    resize-world -50 50 -50 50
    set-patch-size 5
    if region = 1 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_1.asc"
      if period = "IJZ" [
        set settlement-density 0.0141
      ]
      if period = "ROMVA" [
        set settlement-density 0.0212
      ]
      if period = "ROMVB" [
        set settlement-density 0.0226
      ]
      if period = "ROMMA" [
        set settlement-density 0.0268
      ]
      if period = "ROMMB" [
        set settlement-density 0.0254
      ]
    ]
    if region = 2 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_2.asc"
      if period = "IJZ" [
        set settlement-density 0.0034
      ]
      if period = "ROMVA" [
        set settlement-density 0.0127
      ]
      if period = "ROMVB" [
        set settlement-density 0.0127
      ]
      if period = "ROMMA" [
        set settlement-density 0.0141
      ]
      if period = "ROMMB" [
        set settlement-density 0.0141
      ]
    ]
    if region = 3 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_3.asc"
      if period = "IJZ" [
        set settlement-density 0
      ]
      if period = "ROMVA" [
        set settlement-density 0
      ]
      if period = "ROMVB" [
        set settlement-density 0.0035
      ]
      if period = "ROMMA" [
        set settlement-density 0.0035
      ]
      if period = "ROMMB" [
        set settlement-density 0.0035
      ]
    ]
    if region = 4 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_4.asc"
      if period = "IJZ" [
        set settlement-density 0
      ]
      if period = "ROMVA" [
        set settlement-density 0
      ]
      if period = "ROMVB" [
        set settlement-density 0
      ]
      if period = "ROMMA" [
        set settlement-density 0
      ]
      if period = "ROMMB" [
        set settlement-density 0.003
      ]
    ]
    if region = 5 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_5.asc"
      if period = "IJZ" [
        set settlement-density 0.0075
      ]
      if period = "ROMVA" [
        set settlement-density 0.0114
      ]
      if period = "ROMVB" [
        set settlement-density 0.0122
      ]
      if period = "ROMMA" [
        set settlement-density 0.0114
      ]
      if period = "ROMMB" [
        set settlement-density 0.0107
      ]
    ]
    if region = 6 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_6.asc"
      if period = "IJZ" [
        set settlement-density 0.007
      ]
      if period = "ROMVA" [
        set settlement-density 0.0106
      ]
      if period = "ROMVB" [
        set settlement-density 0.0106
      ]
      if period = "ROMMA" [
        set settlement-density 0.013
      ]
      if period = "ROMMB" [
        set settlement-density 0.0127
      ]
    ]
    if region = 7 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_7.asc"
      if period = "IJZ" [
        set settlement-density 0.0083
      ]
      if period = "ROMVA" [
        set settlement-density 0.0147
      ]
      if period = "ROMVB" [
        set settlement-density 0.0147
      ]
      if period = "ROMMA" [
        set settlement-density 0.019
      ]
      if period = "ROMMB" [
        set settlement-density 0.019
      ]
    ]
    if region = 8 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_8.asc"
      if period = "IJZ" [
        set settlement-density 0.0016
      ]
      if period = "ROMVA" [
        set settlement-density 0.0063
      ]
      if period = "ROMVB" [
        set settlement-density 0.0067
      ]
      if period = "ROMMA" [
        set settlement-density 0.0129
      ]
      if period = "ROMMB" [
        set settlement-density 0.0129
      ]
    ]
    if region = 9 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_9.asc"
      if period = "IJZ" [
        set settlement-density 0.0059
      ]
      if period = "ROMVA" [
        set settlement-density 0.0148
      ]
      if period = "ROMVB" [
        set settlement-density 0.0148
      ]
      if period = "ROMMA" [
        set settlement-density 0.0207
      ]
      if period = "ROMMB" [
        set settlement-density 0.0207
      ]
    ]
    if region = 10 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_10.asc"
      if period = "IJZ" [
        set settlement-density 0.0041
      ]
      if period = "ROMVA" [
        set settlement-density 0.0068
      ]
      if period = "ROMVB" [
        set settlement-density 0.0068
      ]
      if period = "ROMMA" [
        set settlement-density 0.0084
      ]
      if period = "ROMMB" [
        set settlement-density 0.0084
      ]
    ]
    if region = 11 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_11.asc"
      if period = "IJZ" [
        set settlement-density 0.0064
      ]
      if period = "ROMVA" [
        set settlement-density 0.0142
      ]
      if period = "ROMVB" [
        set settlement-density 0.0144
      ]
      if period = "ROMMA" [
        set settlement-density 0.0187
      ]
      if period = "ROMMB" [
        set settlement-density 0.0187
      ]
    ]
    if region = 12 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_12.asc"
      if period = "IJZ" [
        set settlement-density 0.0046
      ]
      if period = "ROMVA" [
        set settlement-density 0.0082
      ]
      if period = "ROMVB" [
        set settlement-density 0.0082
      ]
      if period = "ROMMA" [
        set settlement-density 0.0115
      ]
      if period = "ROMMB" [
        set settlement-density 0.0115
      ]
    ]
    if region = 13 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_13.asc"
      if period = "IJZ" [
        set settlement-density 0.0038
      ]
      if period = "ROMVA" [
        set settlement-density 0.0064
      ]
      if period = "ROMVB" [
        set settlement-density 0.0066
      ]
      if period = "ROMMA" [
        set settlement-density 0.0064
      ]
      if period = "ROMMB" [
        set settlement-density 0.0062
      ]
    ]
    if region = 14 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_14.asc"
            if period = "IJZ" [
        set settlement-density 0.0057
      ]
      if period = "ROMVA" [
        set settlement-density 0.0068
      ]
      if period = "ROMVB" [
        set settlement-density 0.0068
      ]
      if period = "ROMMA" [
        set settlement-density 0.0075
      ]
      if period = "ROMMB" [
        set settlement-density 0.007
      ]
    ]
    if region = 15 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_15.asc"
      if period = "IJZ" [
        set settlement-density 0.0065
      ]
      if period = "ROMVA" [
        set settlement-density 0.0092
      ]
      if period = "ROMVB" [
        set settlement-density 0.0092
      ]
      if period = "ROMMA" [
        set settlement-density 0.0097
      ]
      if period = "ROMMB" [
        set settlement-density 0.0099
      ]
    ]
    if region = 16 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_16.asc"
      if period = "IJZ" [
        set settlement-density 0.0034
      ]
      if period = "ROMVA" [
        set settlement-density 0.0041
      ]
      if period = "ROMVB" [
        set settlement-density 0.0043
      ]
      if period = "ROMMA" [
        set settlement-density 0.0041
      ]
      if period = "ROMMB" [
        set settlement-density 0.0041
      ]
    ]
    if region = 17 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_17.asc"
      if period = "IJZ" [
        set settlement-density 0.0026
      ]
      if period = "ROMVA" [
        set settlement-density 0.0031
      ]
      if period = "ROMVB" [
        set settlement-density 0.0031
      ]
      if period = "ROMMA" [
        set settlement-density 0.0034
      ]
      if period = "ROMMB" [
        set settlement-density 0.0034
      ]
    ]
    if region = 18 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_18.asc"
      if period = "IJZ" [
        set settlement-density 0.0044
      ]
      if period = "ROMVA" [
        set settlement-density 0.0208
      ]
      if period = "ROMVB" [
        set settlement-density 0.0295
      ]
      if period = "ROMMA" [
        set settlement-density 0.0438
      ]
      if period = "ROMMB" [
        set settlement-density 0.0416
      ]
    ]
    if region = 19 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_19.asc"
      if period = "IJZ" [
        set settlement-density 0.0047
      ]
      if period = "ROMVA" [
        set settlement-density 0.0117
      ]
      if period = "ROMVB" [
        set settlement-density 0.0117
      ]
      if period = "ROMMA" [
        set settlement-density 0.0152
      ]
      if period = "ROMMB" [
        set settlement-density 0.0187
      ]
    ]
    if region = 20 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_20.asc"
      if period = "IJZ" [
        set settlement-density 0.0037
      ]
      if period = "ROMVA" [
        set settlement-density 0.0064
      ]
      if period = "ROMVB" [
        set settlement-density 0.0092
      ]
      if period = "ROMMA" [
        set settlement-density 0.0147
      ]
      if period = "ROMMB" [
        set settlement-density 0.0175
      ]
    ]
    if region = 21 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_21.asc"
      if period = "IJZ" [
        set settlement-density 0.0085
      ]
      if period = "ROMVA" [
        set settlement-density 0.0318
      ]
      if period = "ROMVB" [
        set settlement-density 0.0318
      ]
      if period = "ROMMA" [
        set settlement-density 0.0425
      ]
      if period = "ROMMB" [
        set settlement-density 0.0361
      ]
    ]
    if region = 22 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_22.asc"
      if period = "IJZ" [
        set settlement-density 0
      ]
      if period = "ROMVA" [
        set settlement-density 0.0031
      ]
      if period = "ROMVB" [
        set settlement-density 0.0031
      ]
      if period = "ROMMA" [
        set settlement-density 0.0031
      ]
      if period = "ROMMB" [
        set settlement-density 0.0031
      ]
    ]
    if region = 23 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_23.asc"
      if period = "IJZ" [
        set settlement-density 0.0048
      ]
      if period = "ROMVA" [
        set settlement-density 0.0061
      ]
      if period = "ROMVB" [
        set settlement-density 0.0061
      ]
      if period = "ROMMA" [
        set settlement-density 0.0145
      ]
      if period = "ROMMB" [
        set settlement-density 0.0145
      ]
    ]
    if region = 24 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_24.asc"
      if period = "IJZ" [
        set settlement-density 0
      ]
      if period = "ROMVA" [
        set settlement-density 0
      ]
      if period = "ROMVB" [
        set settlement-density 0
      ]
      if period = "ROMMA" [
        set settlement-density 0.0063
      ]
      if period = "ROMMB" [
        set settlement-density 0.0063
      ]
    ]
    if region = 25 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_25.asc"
      if period = "IJZ" [
        set settlement-density 0
      ]
      if period = "ROMVA" [
        set settlement-density 0.0047
      ]
      if period = "ROMVB" [
        set settlement-density 0.0047
      ]
      if period = "ROMMA" [
        set settlement-density 0.0047
      ]
      if period = "ROMMB" [
        set settlement-density 0.0047
      ]
    ]
    if region = 26 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_26.asc"
      if period = "IJZ" [
        set settlement-density 0.0019
      ]
      if period = "ROMVA" [
        set settlement-density 0.0033
      ]
      if period = "ROMVB" [
        set settlement-density 0.0033
      ]
      if period = "ROMMA" [
        set settlement-density 0.009
      ]
      if period = "ROMMB" [
        set settlement-density 0.0095
      ]
    ]
    if region = 27 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_27.asc"
      if period = "IJZ" [
        set settlement-density 0.0047
      ]
      if period = "ROMVA" [
        set settlement-density 0.0093
      ]
      if period = "ROMVB" [
        set settlement-density 0.0093
      ]
      if period = "ROMMA" [
        set settlement-density 0.0114
      ]
      if period = "ROMMB" [
        set settlement-density 0.0114
      ]
    ]
    if region = 28 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_28.asc"
      if period = "IJZ" [
        set settlement-density 0.0017
      ]
      if period = "ROMVA" [
        set settlement-density 0.0067
      ]
      if period = "ROMVB" [
        set settlement-density 0.0071
      ]
      if period = "ROMMA" [
        set settlement-density 0.0067
      ]
      if period = "ROMMB" [
        set settlement-density 0.0067
      ]
    ]
    if region = 29 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_29.asc"
      if period = "IJZ" [
        set settlement-density 0.0083
      ]
      if period = "ROMVA" [
        set settlement-density 0.01
      ]
      if period = "ROMVB" [
        set settlement-density 0.0102
      ]
      if period = "ROMMA" [
        set settlement-density 0.0105
      ]
      if period = "ROMMB" [
        set settlement-density 0.01
      ]
    ]
    if region = 30 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_30.asc"
      if period = "IJZ" [
        set settlement-density 0.0095
      ]
      if period = "ROMVA" [
        set settlement-density 0.0102
      ]
      if period = "ROMVB" [
        set settlement-density 0.0102
      ]
      if period = "ROMMA" [
        set settlement-density 0.01
      ]
      if period = "ROMMB" [
        set settlement-density 0.01
      ]
    ]
    if region = 31 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_31.asc"
      if period = "IJZ" [
        set settlement-density 0.0165
      ]
      if period = "ROMVA" [
        set settlement-density 0.0225
      ]
      if period = "ROMVB" [
        set settlement-density 0.024
      ]
      if period = "ROMMA" [
        set settlement-density 0.0262
      ]
      if period = "ROMMB" [
        set settlement-density 0.0255
      ]
    ]
    if region = 32 [
      set raster gis:load-dataset "C:/Users/jamaa/Documents/USB 10072017/Palaeogeography/clip_32.asc"
      if period = "IJZ" [
        set settlement-density 0.0162
      ]
      if period = "ROMVA" [
        set settlement-density 0.0324
      ]
      if period = "ROMVB" [
        set settlement-density 0.0324
      ]
      if period = "ROMMA" [
        set settlement-density 0.0306
      ]
      if period = "ROMMB" [
        set settlement-density 0.0288
      ]
    ]
    gis:set-world-envelope-ds gis:envelope-of raster
    gis:apply-raster raster raster-value
  ]
  ask patches [
    if raster-value = 1 or raster-value = 4 or raster-value = 7 or raster-value = 9 [ ;; ROMFARMS sets different colours for different reconstructed landscape elements but only assigns values to levees and floodbasins.
      set landscape-type "levee"
      set pcolor brown
    ]
    if raster-value = 11 or raster-value = 12 [
      set pcolor green
      set landscape-type "floodbasin"
    ]
    if raster-value = 24 or raster-value = 0 or raster-value = 33 [
      set pcolor blue
    ]
    if raster-value = 14 or raster-value = 15 or raster-value = 17  [
      set pcolor 12
    ]
    if raster-value = 25 or raster-value = 28 or raster-value = 21  [
      set pcolor 125
    ]
    if raster-value = 20 or raster-value = 32 or raster-value = 31 [
      set pcolor 47
    ]
    set patch-owner nobody
    set use "none"
  ]
  setup-forest
end

to setup-globals ;; assigns values to the numerous variables used in ROMFARMS and sets the initial values for list variables.
  ask settlements [
    set elderly-male-list lput count people with [ sex = "male" and age >= 50 ] elderly-male-list
    set elderly-female-list lput count people with [ sex = "female" and age >= 50 ] elderly-female-list
    set adult-male-list lput count people with [ sex = "male" and age >= 16 and age < 50 ] adult-male-list
    set adult-female-list lput count people with [ sex = "female" and age >= 16 and age < 50 ] adult-female-list
    set male-4th-list lput count people with [ sex = "male" and age >= 10 and age < 16 ] male-4th-list
    set female-4th-list lput count people with [ sex = "female" and age >= 10 and age < 16 ] female-4th-list
    set male-3rd-list lput count people with [ sex = "male" and age >= 5 and age < 10 ] male-3rd-list
    set female-3rd-list lput count people with [ sex = "female" and age >= 5 and age < 10 ] female-3rd-list
    set male-2nd-list lput count people with [ sex = "male" and age >= 1 and age < 5 ] male-2nd-list
    set female-2nd-list lput count people with [ sex = "female" and age >= 1 and age < 5 ] female-2nd-list
    set male-1st-list lput count people with [ sex = "male" and age < 1 ] male-1st-list
    set female-1st-list lput count people with [ sex = "female" and age < 1 ] female-1st-list
  ]
  set calories-in-crops 3100 ;; kCal/kg
  set basic-yield 1000 ;; kg/ha
  set sowing-rate 200 ;; kg/ha
  set yield-increase-manure 15 ;; kg per 1kg N
  set N-content-manure 0.006 ;; 6kg per ton manure
  set sowing-time 3 ;;hrs/ha
  set ploughing-time 30 ;; hrs/ha
  set manuring-time 30 ;; hrs/ha
  set harvesting-time 24 ;; hrs/ha
  set adult-weight-cattle 200 ;; kg per head
  set immature-weight-cattle 150 ;; kg per head
  set young-weight-cattle 35 ;; kg per head
  set adult-weight-sheep 25 ;; kg per head
  set immature-weight-sheep 18.75 ;; kg per head
  set young-weight-sheep 10 ;; kg per head
  set %-edible-carcass-cattle 0.6 ;; % of live weight
  set %-edible-carcass-sheep 0.3 ;; % of live weight
  set milk-yield-cattle 1.2 ;; litres per day
  set milk-yield-sheep 0.2 ;; litres per day
  set lactation-length-cattle 200 ;; days
  set lactation-length-sheep 135 ;; days
  set wool-yield-sheep 2 ;; kg per head
  set manure-daily-yield 0.06 ;; % of live weight per days
  set twinning-rate-sheep 0.2 ;; % probability of adult sheep producing two offspring
  set alphaS 7.5 ;; maximum age sheep - standard deviation
  set alphaC 17.5 ;; maximum age cattle - standard deviation
  set alphaH 27.5 ;; maximum age horse - standard deviation
  set alpha 2.5 ;; standard deviation (see above)
  set neonatal-mortality-sheep 0.32 ;; % probability of neonatal sheep dying from natural causes
  set neonatal-mortality-cattle 0.2 ;; % probability of neonatal cattle dying from natural causes
  set neonatal-mortality-horse 0.2 ;; % probability of neonatal horse dying from natural causes
  set annual-mortality-rate 0.014 ;; % probability of all animals to die per year
  set fodder-sheep 252 ;; kg/adult head for four months
  set fodder-cattle 756 ;; kg/adult head for four months
  set fodder-horse 756 ;; kg/adult head for four months
  set fodder-collection-time 16 ;; hrs/ha
  set pasture-land-sheep 9 ;; no. heads/ha
  set pasture-land-cattle 3 ;; no. heads/ha
  set pasture-land-horse 3 ;; no.heads/ha
  set yield-grassland 3000 ;; kg/ha
  set walking-speed 5 ;; km/hr
  set max-load-adult-male 30 ;; kg of firewood
  set max-load-adult-female 20 ;; kg of firewood
  set max-load-other 15 ;; kg of firewood
  set fuel-collection-time 3 ;; hrs/trip
  set timber-collection-time 6 ;; hrs/trip
  set biomass-forest-list [ ]
  set biomass-list [ ]
  ask patches with [ use = "forest" or use = "coppice" ] [
    set biomass-forest-list lput biomass biomass-forest-list
  ]
  ask patches with [ use = "forest" or use = "coppice" or use = "alt-wood" ] [
    set biomass-list lput biomass biomass-list
  ]
  set catchment-area 1
end

to setup-agents ;;  sub-process generates settlement agents and places them randomly in the landscape on a levee patch. The number of agents generated depends on the values for the relevant interface parameters.
  set-default-shape settlements "house"
  while [ count settlements with [ no-households = 1 ] < no-1-household-settlements and any? patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] ] [
    ask one-of patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] [
      sprout 1 [
        set breed settlements
        set age 0
        set no-households 1
        set size 1
        set color white
        set people turtle-set [ ]
        set livestock turtle-set [ ]
        ]
      ]
    ]
  while [ count settlements with [ no-households = 2 ] < no-2-household-settlements and any? patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] ] [
    ask one-of patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] [
      sprout 1 [
        set breed settlements
        set age 0
        set no-households 2
        set size 1.25
        set color white
        set people turtle-set [ ]
        set livestock turtle-set [ ]
      ]
    ]
  ]
  while [ count settlements with [ no-households = 3 ] < no-3-household-settlements and any? patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] ] [
    ask one-of patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] [
      sprout 1 [
        set breed settlements
        set age 0
        set no-households 3
        set size 1.5
        set color white
        set people turtle-set [ ]
        set livestock turtle-set [ ]
      ]
    ]
  ]
  while [ count settlements with [ no-households = 5 ] < no-5-household-settlements and any? patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] ] [
    ask one-of patches with [ landscape-type = "levee" and use = "none" and count turtles-on neighbors = 0 ] [
      sprout 1 [
        set breed settlements
        set age 0
        set no-households 5
        set size 1.75
        set color white
        set people turtle-set [ ]
        set livestock turtle-set [ ]
      ]
    ]
  ]
  ask settlements [
    repeat no-households [
      hatch 1 [ ;; produces one male adult per household and sets initial variables
        ht
        set breed persons
        set sex "male"
        set my-spouse nobody
        set age 16
        set distance-travelled-fuel 0
        set distance-travelled-construction 0
        set my-house myself
        ask my-house [
          set people ( turtle-set people myself )
        ]
      ]
      hatch 1 [
        ht ;; produces one female adult per household and sets initial variables
        set breed persons
        set sex "female"
        set my-spouse nobody
        set age 16
        set distance-travelled-fuel 0
        set distance-travelled-construction 0
        set count-children 0
        set my-house myself
        ask my-house [
          set people ( turtle-set people myself )
        ]
        set my-spouse one-of other persons with [ sex = "male" and age >= 16 and age < 50 and my-spouse = nobody and my-house = [ my-house ] of myself ] ;; sets spouse as one of other adults with opposite sex in the same settlement
        ask my-spouse [
          set my-spouse myself
        ]
      ]
      repeat 4 [
        hatch 1 [ ;; produces four sub-adults per household, ages set randomly between 0 and 15
          ht
          set breed persons
          set sex one-of ( list "male" "female" )
          set age 0 + random 15
          set distance-travelled-fuel 0
          set distance-travelled-construction 0
          set my-spouse nobody
          set my-house myself
          ask my-house [
            set people ( turtle-set people myself )
          ]
        ]
      ]
    ]
    config-settlements
  ]
end

to go-demography
  set elderly-male-list [ ]
  set elderly-female-list [ ]
  set adult-male-list [ ]
  set adult-female-list [ ]
  set male-4th-list [ ]
  set female-4th-list [ ]
  set male-3rd-list [ ]
  set female-3rd-list [ ]
  set male-2nd-list [ ]
  set female-2nd-list [ ]
  set male-1st-list [ ]
  set female-1st-list [ ]
  set count-children-list [ ]
  set d1-pop d-pop
  update-settlements-1
  births
  deaths
  marriages
  ask settlements [
    set elderly-male-list lput count people with [ sex = "male" and age >= 50 ] elderly-male-list
    set elderly-female-list lput count people with [ sex = "female" and age >= 50 ] elderly-female-list
    set adult-male-list lput count people with [ sex = "male" and age >= 16 and age < 50 ] adult-male-list
    set adult-female-list lput count people with [ sex = "female" and age >= 16 and age < 50 ] adult-female-list
    set male-4th-list lput count people with [ sex = "male" and age >= 10 and age < 16 ] male-4th-list
    set female-4th-list lput count people with [ sex = "female" and age >= 10 and age < 16 ] female-4th-list
    set male-3rd-list lput count people with [ sex = "male" and age >= 5 and age < 10 ] male-3rd-list
    set female-3rd-list lput count people with [ sex = "female" and age >= 5 and age < 10 ] female-3rd-list
    set male-2nd-list lput count people with [ sex = "male" and age >= 1 and age < 5 ] male-2nd-list
    set female-2nd-list lput count people with [ sex = "female" and age >= 1 and age < 5 ] female-2nd-list
    set male-1st-list lput count people with [ sex = "male" and age < 1 ] male-1st-list
    set female-1st-list lput count people with [ sex = "female" and age < 1 ] female-1st-list
  ]
  ask persons [
    set age age + 1 ;; increases the age of all surviving inhabitants by one year
  ]
  update-settlements-2
end

to go-arable
  set arable-land-list [ ]
  set min-arable-land-list []
  set yield-list [ ]
  set surplus-list [ ]
  set grain-deficit-list [ ]
  set sowing-labour-list [ ]
  set total-sowing-labour-list [ ]
  set ploughing-labour-list [ ]
  set total-ploughing-labour-list [ ]
  set manuring-labour-list [ ]
  set total-manuring-labour-list [ ]
  set harvesting-labour-list [ ]
  set total-harvesting-labour-list [ ]
  ifelse strategy-arable = "none" or strategy-arable = "extensification" [
    set fallow-time 2
  ]
  [
    set fallow-time 0
  ]
  calculate-land-arable
  calculate-yield-arable
  calculate-surplus-arable
end

to go-pastoral
  ask animals [
    set age age + 1
  ]
  set d1-pop-horse d-pop-horse
  set d1-pop-cattle d-pop-cattle
  set d1-pop-sheep d-pop-sheep
  set sheep-pop-list [ ]
  set cattle-pop-list [ ]
  set horse-pop-list [ ]
  set sheep-meat-list [ ]
  set cattle-meat-list [ ]
  set sheep-milk-list [ ]
  set cattle-milk-list [ ]
  set sheep-wool-list [ ]
  set cattle-manure-list [ ]
  set horse-surplus-list [ ]
  set meadow-land-list [ ]
  set pasture-land-list [ ]
  set total-fodder-labour-list [ ]
  set fodder-labour-list [ ]
  set-mortality-rates
  births-animals
  natural-mortality
  slaughter
end

to go-fuel
  ask persons [ ;; assigns the value for the maximum carrying load per person depending on age.
    if age >= 10 and age < 16 [
      set max-load max-load-other
    ]
    if age >= 16 and age < 50 and sex = "male" [
      set max-load max-load-adult-male
    ]
    if age >= 16 and age < 50 and sex = "female" [
      set max-load max-load-adult-female
    ]
    if age >= 50 [
      set max-load max-load-other
    ]
  ]
  set fuel-workforce-list [ ]
  set total-fuel-labour-list [ ]
  set fuel-labour-list [ ]
  set fuel-deficit-list [ ]
  set distance-travelled-fuel-list [ ]
  ask persons [
    set processing-time-fuel 0
    set distance-travelled-fuel 0
  ]
  calc-workforce-fuel
end

to go-construction
  set construction-labour-list [ ]
  set construction-workforce-list []
  set timber-deficit-list [ ]
  set distance-travelled-construction-list [ ]
  ask persons [
    set processing-time-timber 0
    set distance-travelled-construction 0
  ]
  calc-workforce-construction
end

to update-globals
  set d-pop count persons
  set d-pop-horse count animals with [ species = "horse" ]
  set d-pop-sheep count animals with [ species = "sheep" ]
  set d-pop-cattle count animals with [ species = "cattle" ]
  if ticks > 1 [ ;; calculates herd population growth as the percentage increase or decrease from the previous year
    set pop-growth ( d-pop - d1-pop ) / d1-pop
    if sheep? = TRUE [
      set pop-growth-sheep ( d-pop-sheep - d1-pop-sheep ) / d1-pop-sheep
    ]
    if cattle? = TRUE [
      set pop-growth-cattle ( ( d-pop-cattle - d1-pop-cattle ) / d1-pop-cattle )
    ]
    if horse? = TRUE [
      set pop-growth-horse ( d-pop-horse - d1-pop-horse ) / d1-pop-horse
    ]
  ]
  ask settlements [ ;; updates the values for the various labour expenditures and yields of grain and animal products.
    set arable-land-list lput arable-land arable-land-list
    set yield-list lput yield-grain yield-list
    set surplus-list lput surplus-grain surplus-list
    set grain-deficit-list lput grain-deficit grain-deficit-list
    set total-sowing-labour-list lput sowing-labour-1 total-sowing-labour-list
    set sowing-labour-list lput sowing-labour-2 sowing-labour-list
    set total-ploughing-labour-list lput ploughing-labour-1 total-ploughing-labour-list
    set ploughing-labour-list lput ploughing-labour-2 ploughing-labour-list
    if strategy-arable = "intensification" [
      set total-manuring-labour-list lput manuring-labour-1 total-manuring-labour-list
      set manuring-labour-list lput manuring-labour-2 manuring-labour-list
    ]
    set total-harvesting-labour-list lput harvesting-labour-1 total-harvesting-labour-list
    set harvesting-labour-list lput harvesting-labour-2 harvesting-labour-list
    set sheep-pop-list lput count livestock with [ species = "sheep" ] sheep-pop-list
    set cattle-pop-list lput count livestock with [ species = "cattle" ] cattle-pop-list
    set horse-pop-list lput count livestock with [ species = "horse" ] horse-pop-list
    set sheep-meat-list lput sheep-meat-yield sheep-meat-list
    set cattle-meat-list lput cattle-meat-yield cattle-meat-list
    set sheep-milk-list lput sheep-milk-yield sheep-milk-list
    set cattle-milk-list lput cattle-milk-yield cattle-milk-list
    set sheep-wool-list lput sheep-wool-yield sheep-wool-list
    set cattle-manure-list lput cattle-manure-yield cattle-manure-list
    set horse-surplus-list lput horse-surplus horse-surplus-list
    set meadow-land-list lput meadow-land meadow-land-list
    set pasture-land-list lput pasture-land pasture-land-list
    set total-fodder-labour-list lput fodder-labour-1 total-fodder-labour-list
    set fodder-labour-list lput fodder-labour-2 fodder-labour-list
    set total-fuel-labour-list lput fuel-labour-1 total-fuel-labour-list
    set fuel-labour-list lput fuel-labour-2 fuel-labour-list
    set construction-labour-list lput construction-labour construction-labour-list
    if fuel-requirement > fuel-store [
      set fuel-deficit-list lput ( fuel-requirement - fuel-store ) fuel-deficit-list
    ]
    if construction-requirement > construction-store and age = reconstruction-frequency [
      set timber-deficit-list lput ( construction-requirement - construction-store ) timber-deficit-list
    ]
  ]
  ask persons with [ distance-travelled-fuel > 0 ] [
    set distance-travelled-fuel-list lput distance-travelled-fuel distance-travelled-fuel-list
  ]
  ask persons with [ sex = "female" and age >= 16 ] [
    set count-children-list lput count-children count-children-list
  ]
  set biomass-list [ ]
  set biomass-forest-list [ ]
  ask patches with [ use = "forest" or use = "coppice" or use = "alt-wood" ] [
    set biomass-list lput biomass biomass-list
    if use = "forest" or use = "coppice" [
      set biomass-forest-list lput biomass biomass-forest-list
    ]
  ]
end

to update-patches
  ask patches with [ countdown-reforest > 0 ] [ ;; time to regeneration of deforested patches reduced by 1 and if it reaches 0, patches regenerate
    set countdown-reforest countdown-reforest - 1
    if countdown-reforest = 0 [
      if landscape-type = "levee" and use = "forest" [
        set biomass ( 100 + random 20 ) * 439
      ]
      if landscape-type = "floodbasin" and use = "forest" [
        set biomass ( 110 + random 30 ) * 439
      ]
      if landscape-type = "fen" [
        set biomass ( 65 + random 20 ) * 439
      ]
      if use = "coppice" [
        set biomass ( 180 + random 40 ) * 439
      ]
    ]
  ]
  ask patches with [ landscape-type = "levee" and countdown-fallow > 0 ] [ ;; time for patches to be reused as arable land reduced by 1 and restores arable land to available to use when this value reaches 0.
    set countdown-fallow countdown-fallow - 1
    if countdown-fallow = 0 [
      set pcolor brown
    ]
  ]
  ask patches with [ biomass > 0 ] [
    set pcolor scale-color green biomass 100000 1000
  ]
end

to births
  set-fertility
  ask persons with [ my-spouse != nobody and sex = "female" and age >= 16 and age < 50 ] [
    if random-float 1.0 < fertility [ ;; generates a random value lfrom 0 to 1. If the number is less than the fertility rate assigned to each married woman between 16 and 49 one child is generated. The sex of the child is assigned randomly.
      hatch 1 [
        set breed persons
        set age 0
        set sex one-of ( list "male" "female" )
        set my-house [ my-house ] of myself
        set my-spouse nobody
        set distance-travelled-fuel 0
        set distance-travelled-construction 0
      ]
      set count-children count-children + 1
    ]
  ]
end

to deaths
  set-mortality
  ask persons [
    if random-float 1.0 < mortality [ ;; generates a random value from 0 to 1. If the number is less than the mortality rate assigned to each person, the person dies and is removed from the simulation.
      die
    ]
  ]
end

to marriages
  ask persons with [ sex = "male" and age >= 16 and age < 50 and my-spouse = nobody ] [ ;; if a male aged 16 to 49 is unmarried, they will seek a new spouse. If no unmarried females between 16 and 49 are available, the sub-process ends.
    if any? other persons with [ sex = "female" and age >= 16 and age < 50 and my-spouse = nobody and my-house != [ my-house ] of myself ] [
      ifelse [ count people with [ my-spouse != nobody ] ] of my-house < ( [ no-households ] of my-house * 2 ) [ ;; if there is space for the new couple, the couple move to the male spouse's settlement. If not, the new couple moves to the female spouse's settlement.
        set my-spouse one-of other persons with [ sex = "female" and age >= 16 and age < 50 and my-spouse = nobody and my-house != [ my-house ] of myself ]
        ask my-spouse [
          set my-spouse myself
          set my-house [ my-house ] of myself
        ]
      ]
      [
        set my-spouse one-of other persons with [ sex = "female" and age >= 16 and age < 50 and my-spouse = nobody and my-house != [ my-house ] of myself ]
        ask my-spouse [
          set my-spouse myself
        ]
        new-settlement ;; if no space in either of the new spouse's original settlements, the sub-process for creation of a new settlement is called.
      ]
    ]
  ]
end

to update-settlements-1 ;; updates the value for the calories required for the new population of each settlement once births, marriages and deaths have taken place.
  ask settlements [
    ifelse grain-store >= ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) [
      set grain-store grain-store - ( ( calories-required * %-calories-from-crops ) / calories-in-crops )
    ]
    [
      set grain-deficit  ( ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) - grain-store )
      set grain-store 0
    ]
    set calories-required ( count people with [ age >= 16 and age < 50 and sex = "male" ] * 3250 * 365 + count people with [ age >= 16 and age < 50 and sex = "male" ] * 550 * 6 * 7 ) ;; calculates total annual calories required by inhabitants of settlement
    set calories-required calories-required + ( count people with [ age > 50 and sex = "male" ] * 2650 * 365 )
    set calories-required calories-required + ( count people with [ age >= 16 and age < 50 and sex = "female" ] * 2800 * 365 + count people with [ age >= 16 and age < 50 and sex = "female" ] * 400 * 6 * 7 )
    set calories-required calories-required + ( count people with [ age >= 50 and sex = "female" ] * 2450 * 365 )
    set calories-required calories-required + ( count people with [ age < 1 ] * 675 * 365 )
    set calories-required calories-required + ( count people with [ age >= 1 and age < 5 ] * 1360 * 365 )
    set calories-required calories-required + ( count people with [ age >= 5 and age < 10 ] * 2010 * 365 )
    set calories-required calories-required + ( count people with [ age >= 10 and age < 16 and sex = "male" ] * 2750 * 365 )
    set calories-required calories-required + ( count people with [ age >= 10 and age < 16 and sex = "female" ] * 2420 * 365 )
    set min-grain-store ( ( calories-required * %-calories-from-crops ) / 3110 ) * store-size
    set fuel-requirement count people * 365 * daily-per-capita-fuel-use
    set fuel-store 0
  ]
end

to update-settlements-2
  ask settlements [ ;; checks whether a settlement contains a least one adult or if a settlement is devoid of any inhabitants. If so, the settlement is removed and any remaining dependents sent to the nearest settlement. Any coppiced plot managed by the removed settlement reverts to unmanaged woodland and livestock owned by the removed settlement are removed also.
    set people ( turtle-set persons with [ my-house = myself ] )
    if count people = 0 [
      ask livestock [
        die
      ]
      if any? catchment with [ use = "coppice" and patch-owner = myself ] [
        ask catchment with [ use = "coppice" and patch-owner = myself ] [
          set use "forest"
        ]
      ]
      ask catchment with [ patch-owner = myself ] [
        set patch-owner nobody
      ]
      die
    ]
    if count people with [ age >= 16 and age < 50 ] = 0 [
      if any? catchment with [ use = "coppice" and patch-owner = myself ] [
        ask catchment with [ use = "coppice" and patch-owner = myself ] [
          set use "forest"
        ]
      ]
      ask catchment with [ patch-owner = myself ] [
        set patch-owner nobody
      ]
      ifelse any? other settlements with [ self != myself ] [
        let a one-of other settlements with [ self != myself ]
        ask people [
          set my-house a
        ]
        ask livestock [
          die
        ]
        die
      ]
      [
        ask people [
          die
        ]
        ask livestock [
          die
        ]
        die
      ]
    ]
    set people ( turtle-set persons with [ my-house = myself ] )
    set livestock ( turtle-set animals with [ my-owner = myself ] )
  ]

end

to calculate-land-arable
  ask settlements [
    set arable-land 0
    set min-arable-land ( ( min-grain-store / basic-yield ) + ( ( ( min-grain-store / basic-yield ) * sowing-rate ) / basic-yield ) ) ;; first calculates the minimum area that each settlement must cultivate to produce sufficient food, sowing seed and a buffer.
    set min-arable-land-list lput min-arable-land min-arable-land-list
    set max-arable-land-land count catchment with [ use != "coppice" and countdown-fallow = 0 and landscape-type = "levee" ] ;; calculates the maximum area of land that can be cultivated as restricted by land availability
    if max-arable-land-land < 0 [
      set max-arable-land-land 0
    ]
    set max-arable-land-labour count people with [ age >= 16 and age < 50 ] * 3.2 ;; calculates the maximum area of land that can be cultivated with available land
    if max-arable-land-labour < 0 [
      set max-arable-land-labour 0
    ]
    set max-arable-land-grain ( grain-store / sowing-rate ) ;; calculates the maximum area of land that can be cultivated with available sowing seed.
    if max-arable-land-grain < 0 [
      set max-arable-land-grain 0
    ]
    let max-arable-land min ( list max-arable-land-land max-arable-land-labour max-arable-land-grain ) ;; sets the maximum area of land as the lower of the three areas calculated above.
    ifelse min-arable-land <= max-arable-land [
      set arable-land min-arable-land ;; sets the area of land to be cultivated as the minimum area of land or the maximum area of land, whichever is lower.
      if strategy-arable = "extensification" and surplus-grain > 0 [ ;; if settlements undertake extensification as per interface parameter, the extra area of land that can be cultivated with available land, labour or sowing seed is calculated.
        let d max-arable-land-land - arable-land
        let f max-arable-land-labour - arable-land
        let g ( surplus-grain / sowing-rate )
        let extra-land min ( list d f g )
        set surplus-grain surplus-grain - ( extra-land * sowing-rate )
        set arable-land arable-land + extra-land ;; increases the area of land to be cultivated by the area of extra land that can be cultivated when settlements practice extensification.
      ]
    ]
    [
      set arable-land max-arable-land
    ]
    if arable-land < 0 [
      set arable-land 0
    ]
    set surplus-grain 0
    set grain-store grain-store - ( arable-land * sowing-rate ) ;; reduces grain store by the quantity needed to sow the area of land to be cultivated
    if count catchment with [ landscape-type = "levee" and use != "forest" and use != "coppice" and countdown-fallow = 0 ] >= arable-land [ ;; updates the nearest patches of arable land to the settlement to reflect its use in the current year and resets the fallowing countdown.
      ask min-n-of arable-land catchment with [ landscape-type = "levee" and  use != "forest" and use != "coppice" and countdown-fallow = 0 ] [ distance myself ] [
        set use "arable"
        set pcolor brown + 2
        set countdown-fallow fallow-time
      ]
    ]
    if count catchment with [ landscape-type = "levee" and  use != "forest" and use != "coppice" and countdown-fallow = 0 ] < arable-land [ ;; if any potential arable land contains woodland but is requried for arable farming, the woodland is removed and the fuel store of the settlements in increased accordingly.
      let x count catchment with [ landscape-type = "levee" and  use != "forest" and use != "coppice" and countdown-fallow = 0 ]
      let y arable-land - x
      ask min-n-of x catchment with [ landscape-type = "levee" and  use != "forest" and use != "coppice" and countdown-fallow = 0 ] [ distance myself ] [
        set use "arable"
        set pcolor brown + 2
        set countdown-fallow fallow-time
      ]
    ask min-n-of y catchment with [ landscape-type = "levee" and   use != "coppice" ] [ distance myself ] [
      set use "arable"
      set pcolor brown + 2
      set biomass 0
      ask myself [
        set fuel-store fuel-store + [ biomass ] of myself
      ]
    ]
  ]
  if strategy-arable = "intensification" [ ;; calculates the labour expenditure for manuring (when settlements undertake intensification only), ploughing, sowing and harvesting.
    set manuring-labour-1 ( arable-land * manuring-time )
    set manuring-labour-2 ( arable-land * manuring-time ) / ( count people with [ age >= 16 and age < 50 ] )
    ]
  set ploughing-labour-1 ( arable-land *  ploughing-time )
  set ploughing-labour-2 ( arable-land * ploughing-time ) / ( count people with [ age >= 16 and age < 50 ] )
  set sowing-labour-1 ( arable-land * sowing-time )
  set sowing-labour-2 ( arable-land * sowing-time ) / ( count people with [ age >= 10 ] )
  set harvesting-labour-1 ( arable-land * harvesting-time )
  set harvesting-labour-2 ( arable-land * harvesting-time ) / ( count people with [ age >= 16 and age < 50 ] )
  ]
end

to calculate-yield-arable
  let factor ( -0.2 + random-float 0.4 )
  ask settlements [
    set yield-grain ( arable-land * ( basic-yield * ( 1 + factor ) ) ) ;; calculates the yield of grain as the area of land cultivated multiplied by the basic yield and increased/decreased randomly within the range +/- 20%.
    if strategy-arable = "intensification" [
      ifelse cattle-manure-yield >= ( arable-land * 10000 ) [ ;; calculates the extra yield of grain as a result of incorporating manure into the soil. The amount of nitrogen added depends on the amount of manure which comes from cattle herds.
        let a ( arable-land * ( 10000 * N-content-manure * yield-increase-manure ) * ( 1 + factor ) )
        set yield-grain yield-grain + a
      ]
      [
        let b ( cattle-manure-yield / arable-land )
        let c ( arable-land * ( b * N-content-manure * yield-increase-manure ) * ( 1 + factor ) )
        set yield-grain yield-grain + c
      ]
    ]
    set grain-store yield-grain
  ]
end

to calculate-surplus-arable
  ask settlements [
    if grain-store > min-grain-store [
      set surplus-grain ( grain-store - min-grain-store ) ;; reduces the grain yield by the amount required by the inhabitants for consumption, buffer and sowing seed
      set surplus-grain surplus-grain * ( 1 - surplus-takeoff )
    ]
    while [ any? other settlements with [ surplus-grain > 0 ] and grain-store < ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) ] [ ;; if settlements produce too little grain, grain can be taken from another settlement or other settlements with surplus grain. The surplus grain of the other settlement(s) is reduced accordingly.
      let a one-of other settlements with [ surplus-grain > 0 ]
      ifelse [ surplus-grain ] of a >= ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) - grain-store [
         ask a [
           set surplus-grain surplus-grain - ( [ min-grain-store - grain-store ] of myself )
         ]
         set grain-store min-grain-store
      ]
      [
        set grain-store grain-store + [ surplus-grain ] of a
        ask a [
          set surplus-grain 0
        ]
      ]
    ]
    if grain-store < ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) [ ;; if settlements can not produce or borrow enough grain, a famine is recorded.
      set grain-deficit ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) - grain-store
      set count-famines count-famines + 1
    ]
  ]
end

to set-mortality-rates ;; sets the mortality rates of each animal depending on age range, species and exploitations strategy
  if sheep-strategy = "milk" [
    set SYMR 0.44 ;; mortality rate of young sheep
    set SIMR 0.01 ;; mortality rate of immature sheep
    set SAMR 0.01 ;; mortality rate of adult sheep
  ]
  if sheep-strategy = "meat" [
    set SYMR 0.01
    set SIMR 0.45
    set SAMR 0.01
  ]
  if sheep-strategy = "wool" [
    set SYMR 0.1
    set SIMR 0.2
    set SAMR 0.1
  ]
  if cattle-strategy = "milk" [
    set CYMR 0.5 ;; mortality rate of young cattle
    set CIMR 0.01 ;; mortality rate of immature cattle
    set CAMR 0.08 ;; mortality rate of adult cattle
  ]
  if cattle-strategy = "meat" [
    set CYMR 0.01
    set CIMR 0.45
    set CAMR 0.01
  ]
  if cattle-strategy = "manure" [
    set CYMR 0.2
    set CIMR 0
    set CAMR 0.2
  ]
  set HIMR 0.55 ;; removal rate of surplus immature horses
end

to births-animals
  ask animals [
    set lactating "N"
  ]
  ask animals with [ species = "sheep" and age >= 2 ] [
    if random-float 1.0 < fertility [ ;; for each adult sheep a random number between 0 and 1 is generated. If this is less than the fertility rate of female sheep, the sheep will reproduce. The sex is assigned randomly.
      ifelse random-float 1.0 < twinning-rate-sheep [ ;; for each adult sheep that will reproduce, a random number is generated. If this number is less than the probability that than twinning rate of sheep, two offspring are produced. Otherwise one offspring is produced.
        hatch 2 [
          create-link-with myself
          set breed animals
          set species "sheep"
          set age 0
          set sex one-of ( list "male" "female" )
          set survivorship random-float 1.0
          set fertility 0.8
          set my-owner [ my-owner ] of myself
        ]
        set lactating "Y"
      ]
      [
        hatch 1 [
          create-link-with myself
          set breed animals
          set species "sheep"
          set age 0
          set sex one-of ( list "male" "female" )
          set survivorship random-float 1.0
          set fertility 0.8
          set my-owner [ my-owner ] of myself
        ]
        set lactating "Y"
      ]
    ]
  ]
  ask animals with [ species = "cattle" and age >= 3 ] [
    if random-float 1.0 < fertility [ ;; for each adult cattle a random number between 0 and 1 is generated. If this is less than the fertility rate of female cattle, the cow will reproduce. Sex is assigned randomly.
      hatch 1 [
        create-link-with myself
        set breed animals
        set species "cattle"
        set age 0
        set sex one-of ( list "male" "female" )
        set survivorship random-float 1.0
        set fertility 0.7
        set my-owner [ my-owner ] of myself
      ]
      set lactating "Y"
    ]
  ]
  ask animals with [ species = "horse" and age >= 3 and sex = "female" ] [ ;; for each adult horse a random number between 0 and 1 is generated. If this is less than the fertility rate of female horses, the horse will reproduce. Sex is assigned randomly.
    if random-float 1.0 < fertility [
      hatch 1 [
        set breed animals
        set species "horse"
        set age 0
        set sex one-of ( list "male" "female" )
        set survivorship random-float 1.0
        set fertility 0.6
        set my-owner [ my-owner ] of myself
      ]
    ]
  ]
  ask settlements [
    set livestock ( turtle-set animals with [ my-owner = myself ] )
  ]
end

to natural-mortality
  ask animals with [ species = "sheep" and age < 1 ] [ ;; for each animal, if a random number between 0 and 1 is less than the mortality rate, the animal dies. These commands mimic deaths due to natural mortality.
    if random-float 1.0 < 0.32 [
      die
    ]
  ]
  ask animals with [ species = "cattle" and age < 1 ] [
    if random-float 1.0 < 0.2 [
      die
    ]
  ]
  ask animals with [ species = "horse" and age < 1 ] [
    if random-float 1.0 < 0.2 [
      die
    ]
  ]
  ask animals with [ species = "sheep" ] [
    let survivorship2 exp ( ( - annual-mortality-rate * floor age ) - exp ( - alphaS / alpha ) * ( exp ( floor age / alpha ) - 1 ) )
    if survivorship > survivorship2 [
      die
    ]
  ]
  ask animals with [ species = "cattle" ] [
    let survivorship2 exp ( ( - annual-mortality-rate * floor age ) - exp ( - alphaC / alpha ) * ( exp ( floor age / alpha ) - 1 ) )
    if survivorship > survivorship2 [
      die
    ]
  ]
  ask animals with [ species = "horse" ] [
    let survivorship2 exp ( ( - annual-mortality-rate * floor age ) - exp ( - alphaH / alpha ) * ( exp ( floor age / alpha ) - 1 ) )
    if survivorship > survivorship2 [
      die
    ]
  ]
end

to slaughter
  ask settlements [
    set cattle-meat-yield 0
    set sheep-meat-yield 0
    set cattle-milk-yield 0
    set sheep-milk-yield 0
    set sheep-wool-yield 0
    set cattle-manure-yield 0
    set horse-surplus 0
    set pasture-land 0
    set meadow-land 0
    set fodder-labour-1 0
    set fodder-labour-2 0
    set SNM 0
    set CNM 0
    set SYM 0
    set CYM 0
    set SIM 0
    set CIM 0
    set SAM 0
    set CAM 0
    ask livestock with [ species = "sheep" and sex = "male" ] [ ;; for each animal, a random number is generate between 0 and 1. If the mortality rate is more than the ranodmly-generated number, the animal dies (or for horse is removed). In this sub-process the deaths of animals are recorded to calculated meat yields and surplus horses available each year.
      ask my-owner [ ;; animals are slaughtered in an order determined by their age. First male neonatal animals are slaughtered, followed by young animals, then immature animals and finally adult animals.
        set SNM SNM + 1
      ]
      die
    ]
    ask livestock with [ species = "cattle" and sex = "male" ] [
      ask my-owner [
        set CNM CNM + 1
      ]
      die
    ]
    ask livestock with [ species = "horse" and age >= 1 and age < 3 ] [
      if random-float 1.0 < HIMR [
        ask my-owner [
          set horse-surplus horse-surplus + 1
        ]
        die
      ]
    ]
    ask livestock with [ species = "sheep" and age < 1 ] [
      if random-float 1.0 < SYMR [
        ask my-owner [
          set SYM SYM + 1
        ]
        die
      ]
    ]
    ask livestock with [ species = "cattle" and age < 1 ] [
      if random-float 1.0 < CYMR [
        ask my-owner [
          set CYM CYM + 1
        ]
        die
      ]
    ]
    let a ( count livestock with [ species = "sheep" and age >= 2 ] / pasture-land-sheep ) ;; pasture land required per settlement for animal herds is calculated
    let b ( ( count livestock with [ species = "sheep" and age >= 1 and age < 2 ] * 0.8 ) / pasture-land-sheep )
    let c ( ( count livestock with [ species = "sheep" and age < 1 ] * 0.15 ) / pasture-land-sheep )
    let SLR a + b + c
    let d ( count livestock with [ species = "cattle" and age >= 3 ] / pasture-land-cattle )
    let f ( ( count livestock with [ species = "cattle" and age >= 1 and age < 3 ] * 0.8 ) / pasture-land-cattle )
    let g ( ( count livestock with [ species = "cattle" and age < 1 ] * 0.15 ) / pasture-land-cattle )
    let CLR d + f + g
    let h ( count livestock with [ species = "horse" and age >= 3 ] / pasture-land-horse )
    let i ( ( count livestock with [ species = "horse" and age >= 1 and age < 3 ] * 0.8 ) / pasture-land-horse )
    let j ( ( count livestock with [ species = "horse" and age < 1 ] * 0.15 ) / pasture-land-horse )
    let HLR h + i + j
    set pasture-land SLR + CLR + HLR
    set cattle-milk-yield ( count animals with [ species = "cattle" and lactating = "Y" and count link-neighbors = 0 ] * milk-yield-cattle * lactation-length-cattle ) ;; milk yields per animal herd per settlement are calculated
    set cattle-milk-yield cattle-milk-yield + ( ( count animals with [ species = "cattle" and lactating = "Y" and count link-neighbors > 0 ] / 2 ) * milk-yield-cattle * lactation-length-cattle )
    set sheep-milk-yield ( count animals with [ species = "sheep" and lactating = "Y" and count link-neighbors = 0 ] * milk-yield-sheep * lactation-length-sheep )
    set sheep-milk-yield sheep-milk-yield + ( ( count animals with [ species = "sheep" and lactating = "Y" and count link-neighbors = 0 ] / 2 ) * milk-yield-sheep * lactation-length-sheep )
    set sheep-wool-yield ( count livestock with [ species = "sheep" and age >= 1 ] * wool-yield-sheep )
    ask livestock with [ species = "sheep" and age >= 2 ] [
      if random-float 1.0 < SAMR [
        ask my-owner [
          set SAM SAM + 1
        ]
        die
      ]
    ]
    ask livestock with [ species = "sheep" and age >= 1 and age < 2 ] [
      if random-float 1.0 < SIMR [
        ask my-owner [
          set SIM SIM + 1
        ]
        die
      ]
    ]
    ask livestock with [ species = "cattle" and age >= 3 ] [
      if random-float 1.0 < CAMR [
        ask my-owner [
          set CAM CAM + 1
        ]
        die
      ]
    ]
    ask livestock with [ species = "cattle" and age >= 1 and age < 3 ] [
      if random-float 1.0 < CIMR [
        ask my-owner [
          set CIM CIM + 1
        ]
        die
      ]
    ]
    set cattle-meat-yield CAM * ( adult-weight-cattle * %-edible-carcass-cattle ) + CIM * ( immature-weight-cattle * %-edible-carcass-cattle ) + CYM * ( young-weight-cattle * %-edible-carcass-cattle ) ;; calculates total meat yields per settlement from animal herds
    set sheep-meat-yield SAM * ( adult-weight-sheep * %-edible-carcass-sheep ) + SIM * ( immature-weight-sheep * %-edible-carcass-sheep ) + SYM * ( young-weight-sheep * %-edible-carcass-sheep )
    set cattle-manure-yield ( ( count livestock with [ species = "cattle" and age >= 3 ] * manure-daily-yield * adult-weight-cattle ) + ( count livestock with [ species = "cattle" and age >= 1 and age < 3 ] * manure-daily-yield * immature-weight-cattle ) + ( count livestock with [ species = "cattle" and age < 1 ] * manure-daily-yield * young-weight-cattle ) ) * 120
    let SFR ( ( count livestock with [ species = "sheep" and age >= 2 ] ) + ( count livestock with [ species = "sheep" and age >= 1 and age < 2 ] * 0.8 ) + ( count livestock with [ species = "sheep" and age < 1 ] * 0.15 ) ) * fodder-sheep ;; calculates the quantity of fodder needed each winter for each animal herd.
    let CFR ( ( count livestock with [ species = "cattle" and age >= 3 ] ) + ( count livestock with [ species = "cattle" and age >= 1 and age < 3 ] * 0.8 ) + ( count livestock with [ species = "cattle" and age < 1 ] * 0.15 ) ) * fodder-cattle
    let HFR ( ( count livestock with [ species = "horse" and age >= 3 ] ) + ( count livestock with [ species = "horse" and age >= 1 and age < 3 ] * 0.8 ) + ( count livestock with [ species = "horse" and age < 1 ] * 0.15 ) ) * fodder-horse
    set meadow-land ( SFR + CFR + HFR ) / yield-grassland
    set fodder-labour-1 ( meadow-land * fodder-collection-time ) ;; labour expenditure per settlement for fodder collection is calculated.
    set fodder-labour-2 ( meadow-land * fodder-collection-time ) / ( count people with [ age >= 16 and age < 50 ] )
  ]
end

to calc-workforce-fuel
  ask settlements [
    set fuel-workforce turtle-set [ ]
    set fuel-labour-1 0
    set fuel-labour-2 0
    let a fuel-requirement / ( 365 / collection-frequency )
    let b count people with [ age >= 16 and age < 50 and sex = "male" ] * max-load-adult-male ;; calculates the minimum number of inhabitants required to collect sufficient fuel. ROMFARMS seeks to send the fewest number of "strong" workforce (adult males and females) before it utilises the labour of the "weak" workforce (adolescents and the elderley).
    if b > a [
      set fuel-workforce turtle-set n-of ( ceiling ( a / max-load-adult-male ) ) people with [ age >= 16 and age < 50 and sex = "male" ]
    ]
    if b = a [
      set fuel-workforce turtle-set people with [ age >= 16 and age < 50 and sex = "male" ]
    ]
    if b < a [
      set fuel-workforce turtle-set people with [ age >= 16 and age < 50 and sex = "male" ]
      let c ( a - b )
      let d count people with [ age >= 16 and age < 50 and sex = "female" ] * max-load-adult-female
      if d > c [
        set fuel-workforce ( turtle-set fuel-workforce n-of ( ceiling ( c / max-load-adult-female ) ) people with [ age >= 16 and age < 50 and sex = "female" ] )
      ]
      if d = c [
        set fuel-workforce ( turtle-set fuel-workforce people with [ age >= 16 and age < 50 and sex = "female" ] )
      ]
      if d < c [
        set fuel-workforce ( turtle-set fuel-workforce people with [ age >= 16 and age < 50 and sex = "female" ] )
        let f ( a - ( b + d ) )
        let g count people with [ age >= 10 and age < 16 or age > 50 ] * max-load-other
        if g > f [
          set fuel-workforce ( turtle-set fuel-workforce n-of ( ceiling ( f / max-load-other ) ) people with [ age >= 10 and age < 16 or age > 50 ] )
        ]
        if g = f [
          set fuel-workforce ( turtle-set fuel-workforce people with [ age >= 10 and age < 16 or age > 50 ] )
        ]
        if g < f [
          set fuel-workforce ( turtle-set fuel-workforce people with [ age >= 10 and age < 16 or age > 50 ] )
        ]
      ]
    ]
    set fuel-workforce-list lput count fuel-workforce fuel-workforce-list
    repeat ceiling ( 365 / collection-frequency ) [
      find-fuel
    ]
  ]
end

to calc-workforce-construction
  ask patches with [ use = "forest" or use = "coppice" ] [
    set biomass-forest-list lput biomass biomass-forest-list
  ]
  ask patches with [ use = "forest" or use = "coppice" or use = "alt-wood"  ] [
    set biomass-list lput biomass biomass-list
  ]
  ask settlements [ ;; calculates the minimum number of inhabitants required to collect timber. Only members of the "strong" workforce can collect timber.
    set construction-labour 0
    if age = reconstruction-frequency [
      set construction-workforce turtle-set [ ]
      let a count people with [ age >= 16 and age < 50 and sex = "male" ] * max-load-adult-male
      let b count people with [ age >= 16 and age < 50 and sex = "female" ] * max-load-adult-female
      if a >= construction-requirement [
        set construction-workforce ( turtle-set n-of ceiling ( construction-requirement / max-load-adult-male ) people with [ age >= 16 and age < 50 and sex = "male" ] )
      ]
      if a < construction-requirement [
        set construction-workforce ( turtle-set people with [ age >= 16 and age < 50 and sex = "male" ] )
        let c construction-requirement - a
        if b >= c [
          set construction-workforce ( turtle-set construction-workforce n-of ceiling ( c / max-load-adult-female ) people with [ age >= 16 and age < 50 and sex = "female" ] )
        ]
        if b < c [
          set construction-workforce ( turtle-set construction-workforce people with [ age >= 16 and age < 50 and sex = "female" ] )
        ]
      ]
      while [ any? patches with [ use != "alt-wood" and biomass > 0 ] and construction-store < construction-requirement ] [
        find-timber
      ]
      set construction-workforce-list lput count construction-workforce construction-workforce-list
      set construction-workforce turtle-set [ ]
    ]
  ]
end

to setup-forest
  ask n-of ( count patches with [ landscape-type = "levee" or landscape-type = "floodbasin" ] * forest-cover ) patches with [ landscape-type = "levee" or landscape-type = "floodbasin" ] [
    set use "forest"
    if landscape-type = "levee" [
      set biomass ( 100 + random 20 ) * 439 ;; 100 +/- 20m3 is volume wood per ha, 439kg/m3 is density of wood
    ]
    if landscape-type = "floodbasin" [
      set biomass ( 110 + random 30 ) * 439 ;; see above
    ]
  ]
    ask n-of ( fen-cover * count patches with [ pcolor = black ] ) patches with [ pcolor = black ] [
      set use "alt-wood"
      set landscape-type "fen"
      set biomass ( 65 + random 20 ) * 439 ;; see above
    ]
    ask patches with [ biomass > 0 ] [
      set pcolor scale-color green biomass 100000 1000
    ]
end

to config-settlements
  set calories-required ( count people with [ age >= 16 and age < 50 and sex = "male" ] * 3250 * 365 + count people with [ age >= 16 and age < 50 and sex = "male" ] * 550 * 6 * 7 ) ;; sets calories-required as annual requirement for adult men (3250 per day ) plus extra calories for 6 weeks heavy labour
  set calories-required calories-required + ( count people with [ age >= 16 and age < 50 and sex = "female" ] * 2800 * 365 + count people with [ age >= 6 and age < 50 and sex = "female" ] * 400 * 6 * 7 ) ;; adds annual requirement for adult women to calorie requirement (2800 per day) plus extra for six weeks hard labour
  set calories-required calories-required + ( count people with [ age >= 50 and sex = "male" ] * 2650 * 365 ) ;; adds requirement of elderly males (aged >= 50 )to calorie requirement
  set calories-required calories-required + ( count people with [ age >= 50 and sex = "female" ] * 2450 * 365 ) ;; adds requirement of elderly females (aged >= 50) to calorie requirement
  set calories-required calories-required + ( count people with [ age < 1 ] * 675 * 180 + count people with [ age < 1 ] * 285 * 90 + count people with [ age < 1 ] * 475 * 90 ) ;; adds requirement of lactating adult females to calorie requirement
  set calories-required calories-required + ( count people with [ age >= 1 and age < 5 ] * 1360 * 365 ) ;; adds requirement of 2nd cohort persons (aged 1-4) to calorie requirement
  set calories-required calories-required + ( count people with [ age >= 5 and age < 10 ] * 2010 * 365 ) ;; adds requirement of 3rd cohort persons (aged 5-9) to calorie requirement
  set calories-required calories-required + ( count people with [ age >= 10 and age < 16 and sex = "male" ] * 2750 * 365 ) ;; adds requirement of male 4th cohort (aged 10-15) to calorie requirement
  set calories-required calories-required + ( count people with [ age >= 10 and age < 16 and sex = "female" ] * 2420 * 365 ) ;; adds requirement of female 4th cohort (aged 10-15) to calorie requirement
  set min-grain-store ( ( calories-required * %-calories-from-crops ) / calories-in-crops ) * store-size ;; sets minimum amount of grain required by settlement as amount of grain to satisfy a % of the total calories required (determined by %-calories-from-crops input) plus a buffer (determined by store-size input)
  set grain-store ( min-grain-store + ( ( min-grain-store / basic-yield ) * 200 ) ) ;; sets initial grain-store as the minimum grain store
  set fuel-target nobody
  set fuel-requirement count people * 365 * daily-per-capita-fuel-use
  set fuel-labour-1 0
  set fuel-labour-2 0
  set fuel-store 0
  set construction-labour 0
  set construction-requirement 8525.4 * no-households
  set construction-store 0
  set construction-target nobody
  if cattle? = TRUE [ ;; generates herds of cattle, sheep and horses for each settlement.
    repeat 30 [
      hatch 1 [
        ht
        set breed animals
        set species "cattle"
        set age 3
        set sex "female"
        set fertility 0.7
        set survivorship random-float 1.0
        set my-owner myself
        ask myself [
          set livestock ( turtle-set livestock myself )
        ]
      ]
    ]
  ]
  if sheep? = TRUE [
    repeat 30 [
      hatch 1 [
        ht
        set breed animals
        set species "sheep"
        set age 2
        set sex "female"
        set fertility 0.8
        set survivorship random-float 1.0
        set my-owner myself
        ask myself [
          set livestock ( turtle-set livestock myself )
        ]
      ]
    ]
  ]
  if horse? = TRUE [
    repeat 30 [
      hatch 1 [
        ht
        set breed animals
        set species "horse"
        set age 3
        set sex one-of ( list "male" "female" )
        set fertility 0.6
        set survivorship random-float 1.0
        set my-owner myself
        ask myself [
          set livestock ( turtle-set livestock myself )
        ]
      ]
    ]
  ]
  set catchment patch-set [ ]
  set catchment ( patch-set catchment patches with [ landscape-type = "levee" and not any? settlements-here ] in-radius ( catchment-area * 50 ) )
  set catchment ( patch-set catchment patch-here )
  if coppicing? = TRUE and count catchment > 1 [
      ask one-of catchment with [ use != "forest" and use != "coppice" ] [
      set use "coppice"
      set patch-owner myself
      set biomass ( 180 + random 40 ) * 439
      set pcolor scale-color green biomass 100000 1000
    ]
  ]
  ask patch-here [
    set patch-owner myself
  ]
end

to set-fertility
  ask persons with [ my-spouse != nobody and sex = "female" ] [
    if age >= 16 and age < 19 [
      set fertility 0.411
    ]
    if age >= 19 and age < 24 [
      set fertility 0.46
    ]
    if age >= 24 and age < 29 [
      set fertility 0.431
    ]
    if age >= 29 and age < 34 [
      set fertility 0.395
    ]
    if age >= 34 and age < 39 [
      set fertility 0.322
    ]
    if age >= 39 and age < 44 [
      set fertility 0.167
    ]
    if age >= 44 and age < 50 [
      set fertility 0.024
    ]
  ]
end

to set-mortality
  ask persons [
    if age >= 0 and age < 1 [
      set mortality 0.3056
    ]
    if age >= 1 and age < 5 [
      set mortality 0.2158 / 4
    ]
    if age >= 5 and age < 10 [
      set mortality 0.0606 / 5
    ]
    if age >= 10 and age < 15 [
      set mortality 0.0474 / 5
    ]
    if age >= 15 and age < 20 [
      set mortality 0.0615 / 5
    ]
    if age >= 20 and age < 25 [
      set mortality 0.0766 / 5
    ]
    if age >= 25 and age < 30 [
      set mortality 0.0857 / 5
    ]
    if age >= 30 and age < 35 [
      set mortality 0.0965 / 5
    ]
    if age >= 35 and age < 40 [
      set mortality 0.1054 / 5
    ]
    if age >= 40 and age < 45 [
      set mortality 0.1123 / 5
    ]
    if age >= 45 and age < 50 [
      set mortality 0.1197 / 5
    ]
    if age >= 50 and age < 55 [
      set mortality 0.1529 / 5
    ]
    if age >= 55 and age < 60 [
      set mortality 0.1912 / 5
    ]
    if age >= 60 and age < 65 [
      set mortality 0.2715 / 5
    ]
    if age >= 65 and age < 70 [
      set mortality 0.3484 / 5
    ]
    if age >= 70 and age < 75 [
      set mortality 0.4713 / 5
    ]
    if age >= 75 and age < 80 [
      set mortality 0.6081 / 5
    ]
    if age >= 80 and age < 85 [
      set mortality 0.7349 / 5
    ]
    if age >= 85 and age < 90 [
      set mortality 0.8650 / 5
    ]
    if age >= 90 and age < 95 [
      set mortality 0.9513 / 5
    ]
    if age >= 95 [
      set mortality 1
    ]
  ]
end

to find-fuel ;; sub-process is looped until workforces have collected the maximum amount of fuel in the landscape or enough fuel.
  while [ any? fuel-workforce with [ load < max-load ] and any? patches with [ biomass > 0 ] ] [ ;; settlements target a specific patch containing woodland.
    ifelse any? catchment with [ use = "coppice" and patch-owner = myself and biomass > 0 ] [
      set fuel-target one-of catchment with [ use = "coppice" and biomass > 0 ]
    ]
    [
      ifelse any? patches with [ use = "forest" and biomass > mean ( biomass-forest-list ) ] [
        set fuel-target max-one-of patches with [ use = "forest" and biomass > 0 ] [ distance myself ]
      ]
      [
        ifelse any? patches with [ use = "forest" and biomass > 0 ] [
          set fuel-target min-one-of patches with [ use = "forest" and biomass > 0 ] [ distance myself ]
        ]
        [
        if any? patches with [ biomass > 0 ] [
          set fuel-target min-one-of patches with [ biomass > 0 ] [ distance myself ]
        ]
      ]
    ]
  ]
  if fuel-target != nobody [
    take-fuel
    set fuel-target nobody
  ]
  ]
  set fuel-store fuel-store + sum ( [ load ] of fuel-workforce ) ;; workforces process and collect fuel
  set fuel-labour-1 fuel-labour-1 + sum ( [ processing-time-fuel ] of fuel-workforce ) ;; time spent processing fuel per member of the workforce and the sum total for the whole workforce is calculated.
  set fuel-labour-2 fuel-labour-2 + ( sum ( [ processing-time-fuel ] of fuel-workforce ) / count fuel-workforce )
  ask fuel-workforce [
    let a patch-here
    move-to my-house
    set distance-travelled-fuel distance-travelled-fuel + distance a
    ask my-house [
      set fuel-labour-1 fuel-labour-1 + ( sum ( [ distance-travelled-fuel ] of fuel-workforce ) / 10 / walking-speed ) ;; the cumulative distance travelled per member of the workforce between patches and the settlement and the sum total for the whole workforce is calculated.
      set fuel-labour-2 fuel-labour-2 + ( ( sum ( [ distance-travelled-fuel ] of fuel-workforce ) / 10 / walking-speed ) / count fuel-workforce )
    ]
    set load 0
    set distance-travelled-fuel 0
    set processing-time-fuel 0
  ]
end

to find-timber ;; same process as above
  while [ any? construction-workforce with [ load != max-load ] and any? patches with [ biomass > 0 ] ] [
    ifelse any? catchment with [ use = "coppice" and patch-owner  = myself and biomass > 0 ] [
      set construction-target max-one-of catchment with [ use = "coppice" and patch-owner = myself and biomass > 0 ] [ biomass ]
    ]
    [
      ifelse any? patches with [ use = "forest" and biomass > mean ( biomass-forest-list ) ] [
        set construction-target max-one-of patches with [ use = "forest" and biomass > mean ( biomass-forest-list ) ] [ biomass ]
      ]
      [
        if any? patches with [ use = "forest" and biomass > 0 ] [
          set construction-target min-one-of patches with [ use = "forest" and biomass > 0 ] [ distance myself ]
        ]
      ]
    ]
    if construction-target != nobody [
      take-timber
      set construction-target nobody
    ]
  ]
  set construction-store construction-store + sum ( [ load ] of construction-workforce )
  set construction-labour construction-labour + sum ( [ processing-time-timber ] of construction-workforce )
  ask construction-workforce [
    let a patch-here
    move-to my-house
    set distance-travelled-construction distance-travelled-construction + distance a
    ask my-house [
      set construction-labour construction-labour + ( ( sum ( [ distance-travelled-construction ] ) of construction-workforce ) / 10 / walking-speed )
    ]
    set load 0
    set distance-travelled-construction 0
    set processing-time-timber 0
  ]
end

to new-settlement ;; creates a new settlement when a new married couple must leave their original settlement due to overcrowding. If settlement density will be exceeded, no new settlement is produced and the couple is removed.
  ifelse any? patches with [ landscape-type = "levee" and use != "settlement" and count settlements-on neighbors = 0 ] and ( precision ( ( count settlements + 1 ) / count patches with [ landscape-type = "levee" ] ) 4 ) <= settlement-density [
    let a self
    ask one-of patches with [ landscape-type = "levee" and use != "settlement" and count settlements-on neighbors = 0 ] [
      sprout 1 [
        set breed settlements
        set age 0
        set no-households [ no-households ] of [ my-house ] of a
        set color white
        set size 1 + ( ( no-households - 1 ) / 4 )
        set livestock turtle-set [ ]
        set people turtle-set [ ]
        set people ( turtle-set people a )
        set people ( turtle-set people [ my-spouse ] of a )
        ask a [
          set my-house myself
          ask my-spouse [
            set my-house [ my-house ] of a
          ]
        ]
        if [ biomass ] of patch-here > 0 [
          set fuel-store fuel-store + [ biomass ] of patch-here
          ask patch-here [
            set biomass 0
          ]
        ]
        config-settlements
      ]
    ]
  ]
  [
    ask my-spouse [
      die
    ]
    die
  ]
end

to take-fuel
  ask fuel-workforce [
    let a patch-here
    move-to [ fuel-target ] of my-house
    set distance-travelled-fuel distance-travelled-fuel + distance a
    ifelse [ biomass ] of [ fuel-target ] of my-house >= ( max-load - load ) [
      ask [ fuel-target ] of my-house [
        set biomass biomass - [ max-load - load ] of myself
        if biomass = 0 [
          if use = "coppice" [
            set countdown-reforest 12
          ]
          if use = "forest" or use = "alt-wood" [
            set countdown-reforest 15
          ]
        ]
      ]
      set load load + ( max-load - load )
      set processing-time-fuel processing-time-fuel + fuel-collection-time
    ]
    [
      set load load + [ biomass ] of [ fuel-target ] of my-house
      set processing-time-fuel processing-time-fuel + fuel-collection-time
      ask [ fuel-target ] of my-house [
        set biomass 0
        if use = "coppice" [
          set countdown-reforest 12
        ]
        if use = "forest" [
          set countdown-reforest 15
        ]
      ]
    ]
  ]
end

to take-timber
  ask construction-workforce [
    let a patch-here
    move-to [ construction-target ] of my-house
    set distance-travelled-construction distance-travelled-construction + distance a
    ifelse [ biomass ] of [ construction-target ] of my-house >= ( max-load - load ) [
      ask [ construction-target ] of my-house [
        set biomass biomass - [ max-load - load ] of myself
        if biomass = 0 [
          if use = "coppice" [
            set countdown-reforest 12
          ]
          if use = "forest" or use = "alt-wood" [
            set countdown-reforest 15
          ]
        ]
      ]
      set load load + ( max-load - load )
      set processing-time-timber processing-time-timber + timber-collection-time
    ]
    [
      set load load + [ biomass ] of [ construction-target ] of my-house
      set processing-time-timber processing-time-timber + timber-collection-time
      ask [ construction-target ] of my-house [
        set biomass 0
        if use = "coppice" [
          set countdown-reforest 12
        ]
        if use = "forest" [
          set countdown-reforest 15
        ]
      ]
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
175
13
612
451
-1
-1
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

INPUTBOX
703
15
858
75
area-levee
0.0
1
0
Number

INPUTBOX
703
74
858
134
area-floodbasin
0.0
1
0
Number

INPUTBOX
703
133
858
193
forest-cover
0.0
1
0
Number

INPUTBOX
703
193
858
253
fen-cover
0.0
1
0
Number

INPUTBOX
10
12
165
72
no-1-household-settlements
0.0
1
0
Number

INPUTBOX
10
70
165
130
no-2-household-settlements
0.0
1
0
Number

INPUTBOX
10
129
165
189
no-3-household-settlements
0.0
1
0
Number

INPUTBOX
10
188
165
248
no-5-household-settlements
0.0
1
0
Number

INPUTBOX
860
15
1015
75
%-calories-from-crops
0.0
1
0
Number

INPUTBOX
860
75
1015
135
store-size
0.0
1
0
Number

INPUTBOX
1034
15
1189
75
daily-per-capita-fuel-use
0.0
1
0
Number

SWITCH
1203
18
1306
51
cattle?
cattle?
1
1
-1000

SWITCH
1203
50
1306
83
sheep?
sheep?
1
1
-1000

SWITCH
1203
82
1306
115
horse?
horse?
1
1
-1000

SWITCH
1034
74
1146
107
coppicing?
coppicing?
1
1
-1000

CHOOSER
1203
115
1341
160
sheep-strategy
sheep-strategy
"milk" "meat" "wool"
1

CHOOSER
1204
162
1342
207
cattle-strategy
cattle-strategy
"milk" "meat" "manure"
2

CHOOSER
861
135
999
180
strategy-arable
strategy-arable
"none" "extensification" "intensification"
1

INPUTBOX
11
308
166
368
runtime
0.0
1
0
Number

BUTTON
12
374
75
407
NIL
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
75
374
138
407
NIL
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

INPUTBOX
1035
108
1190
168
collection-frequency
0.0
1
0
Number

CHOOSER
12
422
168
467
region
region
"hyp" 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32
0

CHOOSER
12
473
150
518
period
period
"IJZ" "ROMVA" "ROMVB" "ROMMA" "ROMMB"
0

INPUTBOX
861
179
1016
239
surplus-takeoff
0.0
1
0
Number

INPUTBOX
1036
175
1191
235
reconstruction-frequency
0.0
1
0
Number

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
