breed [ sellers a-seller]
breed [ consumers a-consumer]
breed [ Kproducers a-Kproducer]

globals
[
  total-money-consumers ;total money owned bt all consumers
  total-money-sellers ;idem for sellers
  total-money-Kproducers ;idem for capital producers

  total-trade ;goods and capital traded at tick
  total-Ktrade ;capital units traded at tick
  total-stock ;stock of goods currently in the sellers hands
  total-Kstock ;stock of capital currently in the capital producers hands

  state-budget ;this variable show how much money the State currently owns at this tick

  helped-sellers ;this variable shows the number of sellers currently or previously helped by the state
  helped-consumers ;idem for consumers
  helped-Kproducers ;idem for capital producers
  employed-consumers ;number of consumers employed at this tick

  mean-price ;sum of sellers prices divided by the number of sellers
  mean-Kprice ;idem with capital producers

  employment-rate ;fraction of consumers that are employed

  an-consumers ;number of consumers alive at tick

  GDP ;economic output of the market
]

sellers-own
[
  ownprice ;their price
  ownsales ;the number of sales done in all their life
  money ;their money
  ownstock ;their stock
  trade? ;boolean variable activated if there was some trade this tick
  trade-at-tick ;number of trades done at this tick
  already-helped? ;boolean variable activated if there was some help in the seller's life
  capital ;capital stock
  target-capital ; capital demand of the agent
  target-production ; production objective of the agent
  failed-trades-stock ;number of trades that failed because of a too small stock
  failed-trades-price ;number of trades taht failed because of a too high price
  visits ;number of trade attempts at tick
  react-to-capital-rationnal? ;if trading is not rationnal (i.e. the agent won't make profits from it), then this boolean variables, if turned on, starts a procedure to improve the profits opportunities
]

consumers-own
[
  money
  bought-this-round? ;boolean variable set true if the consumer bought a good this tick
  goods-bought ;number of goods boughts in the consumer's life
  already-helped? ;idem for consumers
  employed? ;true if the consumer was employed this turn
  days-employed ;number of ticks in which the consumer was employed
  energy ;energy (biological) of the consumer, lost by living and working, and gained by consuming goods
  needs ; this variable shows how many goods the consumer wants to buy
]

Kproducers-own
[
  ; the agent variables are here the same than the sellers variables, but applied to capital producers
  money
  target-Kproduction
  ownKstock
  already-helped?
  ownKprice
  ownKsales
  Ktrade-at-tick
  wage
  failed-trades-stock
  failed-trades-price
  trade?
  visits
  react-to-price-rationnal?
]

to setup

  clear-all

  set state-budget 0
  set helped-sellers 0
  set helped-consumers 0
  set mean-price 0
  set employed-consumers 0
  set an-consumers n-consumers
  set helped-Kproducers 0
  set mean-Kprice 0
  set GDP 0

create-sellers n-sellers
  [
  setxy random-xcor random-ycor
  set shape "house"
  set color white
  set money random-normal initial-endowment-producers 1
  set size 2
  set ownprice random-normal initial-price-sellers 1
  set ownstock 0
  set money random-normal 10 0.1
  set ownsales 0
  set trade? false
  set already-helped? false
  set target-production random 10
  set failed-trades-stock 0
  set failed-trades-price 0
  set target-capital random-normal 3 0.1
  set capital 0
  set visits 0
  ]

  create-consumers n-consumers
  [
  setxy random-xcor random-ycor
  set size 1
  set shape "person"
  set color yellow
  set money random-normal initial-endowment-consumers 1
  set bought-this-round? false
  set already-helped? false
  set days-employed 0
  set energy random 20
  set needs random-normal 3 0.5
  ]

  create-Kproducers n-Kproducers
  [
  setxy random-xcor random-ycor
  set size 2
  set shape "square"
  set color blue
  set money random-normal initial-endowment-producers 1
  set ownKstock 0
  set already-helped? false
  set target-Kproduction random 10
  set ownKprice random-normal 4 0.5
  set ownKsales 0
  set Ktrade-at-tick 0
  set wage random-normal 2 0.2
  set failed-trades-stock 0
  set failed-trades-price 0
  set trade? false
  ]

reset-ticks
end

to go

  ; If there is nobody in our Market, we stop the model
  if count sellers = 0 [stop]
  if count consumers = 0 [stop]
  if count Kproducers = 0 [stop]

  ; This procedure sets the daily variables
  set-beginning-values

  ; The agents check if they have enough money to stay in the market
  check-if-defaut

  ; The Kproducers employs the consumers to create capital K, and give them wages
  work

  ; The Gproducers buy some capital to the Kproducers
  trade-capital

  ; The Gproducers use the capital to create goods
  produce-goods

  ; The consumers buy goods A and B to the Gproducers
  trade-goods

  ; The agents adjust their strategies based on what happened this day
  adjust

  ; There are taxes
  tax

  ; This procedure sets some daily variables at the end of the day
  set-end-values

tick
end

to set-beginning-values

ask sellers
  [
    set trade-at-tick 0
    set trade? false
    set failed-trades-stock 0
    set failed-trades-price 0
    set target-capital (target-production / capital-productivity)
    set visits 0
    set ownsales 0
    set color white
    set react-to-capital-rationnal? false
  ]

ask consumers
  [
    set employed? false
    set color yellow
    set employed-consumers 0
    set bought-this-round? false
    set energy energy - daily-energy-consumption
  ]

ask Kproducers
  [
    set Ktrade-at-tick 0
    set failed-trades-stock 0
    set failed-trades-price 0
    set visits 0
    set ownKsales 0
    set color blue
    set react-to-price-rationnal? false
  ]

  ;globals
  set GDP 0

end

to check-if-defaut

  ; sellers first
ask sellers [

    if new-sellers? = true [
      if random 100 < sellers-newcomers% [
        hatch 1 [
          setxy random-xcor random-ycor
          set shape "house"
          set color white
          set money random-normal initial-endowment-producers 1
          set size 2
          set ownprice random-normal initial-price-sellers 1
          set ownstock 0
          set money random-normal 10 0.1
          set ownsales 0
          set trade? false
          set already-helped? false
          set target-production random 10
          set failed-trades-stock 0
          set failed-trades-price 0
        ] ; end hatch
      ] ; end if random 100
    ] ; end if new sellers true

    if money <= 0 [

      if ownstock <= 0 [
        if already-helped? = true [
          die
          set helped-sellers helped-sellers - 1
        ]
        if already-helped? = false
        [
          if state-help-sellers? = true [
            set already-helped? true
            set money money + state-help-sellers
            set helped-sellers helped-sellers + 1
            set state-budget state-budget - state-help-sellers
          ]
        ]

        if already-helped? = false and state-budget < 0
        [
          set color grey
        ] ; end if already-helped
      ] ; end if ownstock < 0

      if ownstock > 0 [
        if already-helped? = false [
        if state-intervention-sellers? = true [
          ; then the state buys even without profit, the stock, and restore the seller's financial health
          set money money + ownprice * ownstock
          set GDP GDP + ownprice * ownstock
          set state-budget state-budget - ownprice * ownstock
          set ownstock 0
          set already-helped? true
        ] ; end if state-intervention? true
        if state-intervention-sellers? = false [
            die
        ]
        ]
        if already-helped? = true
        [
          die]
      ] ; end if ownstock > 0
    ] ; end if money < 0
  ] ; end ask sellers


; now consumers procedure
ask consumers [

  ; if they run out of energy, they die
  if energy <= 0 [
      die
    ]

  ; some new consumers could enter in the market
  if new-consumers? = true [
      if random 100 < consumers-newcomers% [
      hatch 1 [
          setxy random-xcor random-ycor
          set size 1
          set shape "person"
          set color yellow
          set money random-normal initial-endowment-consumers 1
          set bought-this-round? false
          set already-helped? false
          set days-employed 0
        ] ; end hatch
      ] ; end if random 100 < newcomers for consumers
    ] ; end if new consumers = true

    ; if they don't have money, they die or get helped by the state
    if money <= 0 [
      if already-helped? = true
      [
      die
      set helped-consumers helped-consumers - 1
      set an-consumers an-consumers - 1
      ]
    if already-helped? = false and state-budget > 0
      [
        if state-help-consumers? = true [
      set already-helped? true
      set money money + state-help-consumers
      set helped-consumers helped-consumers + 1
      set state-budget state-budget - state-help-consumers
      ]
      ]
     if already-helped? = false and state-budget < 0
      [
      set color grey
      ]
    ] ; end if money <= 0
  ] ; end ask consumers

  ask consumers [
if basic-income? = true [
    if state-budget > basic-income [
      set money money + basic-income
      set state-budget state-budget - basic-income
    ] ; end if state has enough money
  ] ; end if basic income true
  ] ; end ask consumers

  ; now Kproducers proceduref
  ask Kproducers [

    if new-Kproducers? = true [
      if random 100 < Kprod-newcomers% [
        hatch 1 [
          setxy random-xcor random-ycor
          set size 2
          set shape "square"
          set color blue
          set money random-normal initial-endowment-producers 1
          set ownKstock 0
          set already-helped? false
          set target-Kproduction random 10
          set ownKprice random-normal 4 0.5
          set ownKsales 0
          set Ktrade-at-tick 0
          set wage random-normal 2 0.2
          set failed-trades-stock 0
          set failed-trades-price 0
        ] ; end hatch
      ] ; end if random < TR
    ]; end if new-Kproducers = true

    if money <= 0 and ownKstock <= 0 [
      if already-helped? = true [
        die
        set helped-Kproducers helped-Kproducers - 1
      ] ; end if state help Kprod true

      if already-helped? = false and state-budget > 0 [
        if state-help-Kprod? = true [
          set already-helped? true
          set money money + state-help-Kprod
          set helped-Kproducers helped-Kproducers + 1
          set state-budget state-budget - state-help-Kprod
        ] ; end if SHK true
      ] ; end AH false & state budget > 0

      if already-helped? = false and state-budget < 0
      [
        set color grey
      ]
    ] ; end if money <= 0 ownKstock <= 0

    if money <= 0 and ownKstock > 0 [

      if state-intervention-Kprod? = true and state-budget > 0 [
        ; then the state buys even without profit, the stock, and restore the seller's financial health
        set money money + ownKprice * ownKstock
        set state-budget state-budget - ownKprice * ownKstock
        set GDP GDP + ownKstock * ownKprice
        set ownKstock 0
      ] ; end if state-intervention? true

      if state-intervention-Kprod? = false [
        ; do nothing
        ] ; if SI false

    ] ; end if money negative and ownKstock positive
  ] ; end ask Kproducers

end

to work

  ask Kproducers [

    ; As a capital producer, I have a target production of capital (target-Kproduction)
    ; I want to produce this quantity using the workforce around me, each worker is able to create one unit of capital per day of work
    ; First, I need enough money !

    if money >= wage * target-Kproduction [

      ; then, I need my choice to product capital to be rationnal, i.e. economically adequate considering the price, the wage, and the taxes

      if target-Kproduction * ownKprice >= (wage + tax-sale-Kprod) * target-Kproduction [

        let k target-Kproduction
        let w wage

        ;let target k of consumers in-radius reach
        let employable-consumers consumers with [employed? = false]

        if count employable-consumers in-radius reach >= target-Kproduction [

          ask n-of k employable-consumers in-radius reach [

            set employed? true
            set color green
            set employed-consumers employed-consumers + 1
            set money money + w
            set energy energy - work-energy-cost
            set days-employed days-employed + 1
            set employment-rate ((employed-consumers * 100) / count consumers)
          ] ; end ask targets workers

          ; we know still ask the Kproducers as employers
          set color violet
          set money money - wage * target-Kproduction
          set ownKstock ownKstock + target-Kproduction
          set GDP GDP + wage * target-Kproduction

        ] ; end if count employable-consumers around is enough to produce my target Kproduction
          ; if we don't have enough workers around, we still try to produce as much as we can, even if we are not satisfied
        if count employable-consumers in-radius reach < target-Kproduction [

          if count employable-consumers in-radius reach != 0 [

            let h count employable-consumers in-radius reach

            ask n-of h employable-consumers in-radius reach [
              set employed? true
              set color green
              set employed-consumers employed-consumers + 1
              set money money + w
              set energy energy - work-energy-cost
              set days-employed days-employed + 1
              set employment-rate ((employed-consumers * 100) / count consumers)
              ; so we produced h goods, such that h < target-Kproduction

            ] ; end ask employable consumer in radius reach, we now ask Kproducers
            set money money - wage * h
            set ownKstock ownKstock + h
            set GDP GDP + wage * h

            set color orange
            right random 90
            left random 90
            forward reach / 2

          ] ; end if count employable-consumers in-radius reach != 0

          if count employable-consumers in-radius reach = 0 [
            set color red
            right random 90
            left random 90
            forward reach
          ] ; end if count employable-consumers in-radius reach = 0
        ] ; end if count employable-consumers in-rdius reach < target-production
      ] ; end if target-Kproduction * ownKprice >= target-Kproduction * (wage + tax-sale-Kprod)
      if target-Kproduction * ownKprice < target-Kproduction * (wage + tax-sale-Kprod) [
        set wage wage - rationnal-wage-delta / 2
        set ownKprice ownKprice + d-price / 2
      ] ; end if target-Kproduction * ownKprice < target-Kproduction * (wage + tax-sale-Kprod)
    ] ; end if money >= wage * target-Kproduction [
    if money < wage * target-Kproduction [
      set wage wage - rationnal-wage-delta
    ] ; end if money < wage * target-Kproduction
  ] ; end ask Kproducers





  ask consumers [
    ; if there were not employed, consumers find another location in where they could eventualy work
    if employed? = false [
      right random 90
      left random 90
      forward reach
    ] ; end if eployed false
  ] ; end ask consumers


end

to trade-capital

ask sellers [

    ; we create a temporrary variable z that is the demand in capital of the seller
    let z target-production / capital-productivity

    ; First, we need at least one Kproducer
    if count Kproducers != 0 [

      if target-production != 0 [
        ; the agent selects the cheapest shop in a certain radius
        let target min-one-of Kproducers in-radius reach [ownKprice]

        if target != nobody [

          ; Second : is the trade rationnal for the Kproducer considering eventual taxes?
          ask target [
            if ownKprice * z - tax-sale-Kprod >= 0 [

                ; Third : is the trade rationnal for the seller considering eventual taxes?
              ; i.e. : will he be able to make profit selling these goods considering the capital cost ?
              ask sellers [
                if ownprice * target-production - tax-sale-sellers >= z * [ownKprice] of target [

                  ; Now, there is a visit, that result on a success or in different types of failures
                  ask target [
                    set visits visits + 1
                  ] ; end ask target

                  ; Fourth : as a seller, does my target have enough capital to satisfy my demand?
                  if z <= [ownKstock] of target [

                    ; Fifth : as a seller, do I have enough money to buy the capital I want?
                    if money >= z * [ownKprice] of target [

                      ; if both are true, I can process the trade!
                      ; we ask globals
                      set total-Ktrade total-Ktrade + z
                      set GDP GDP + z * [ownKprice] of target

                      ; we are still asking sellers
                      set money money - z * [ownKprice] of target
                      set capital capital + z

                      ask target [
                        set money money + ownKprice * z
                        set ownKstock ownKstock - z
                        set ownKsales ownKsales + z
                        set Ktrade-at-tick Ktrade-at-tick + z
                        set GDP GDP + ownKprice * z
                        set ownKprice ownKprice + greedy-price
                      ] ; end ask target

                    ] ; end if money >= [ownKprice] of target
                    if money < z * [ownKprice] of target [
                      ask target [
                        set failed-trades-price failed-trades-price + 1
                      ]; end ask target
                    ] ; end if not enough money

                  ] ; end if enough stock
                  if target-production / capital-productivity > [ownKstock] of target [
                    ask target [
                      set failed-trades-stock failed-trades-stock + 1
                    ] ; end ask target
                  ]; end if not enough stock

                ] ; end rationnality sellers true
                if (ownprice - tax-sale-sellers) * target-production < z * [ownKprice] of target [
                  if react-to-capital-rationnal? = false [
                    set react-to-capital-rationnal? true
                    set ownprice ownprice + ownprice * d-price * 0.01
                  ]
                  if react-to-capital-rationnal? = true [
                  set color yellow
                  right random 30
                  left random 30
                  forward 1
                  ]
                ] ; end rationality sellers false
              ] ; end ask sellers
            ] ; end rationnality Kproducers true

            if ownKprice * z - tax-sale-Kprod * z < 0 [
              if react-to-price-rationnal? = false [
                set ownKprice ownKprice + d-price
                set react-to-price-rationnal? true
              ]
              if react-to-price-rationnal? = true []
            ]; end if rationnality Kproducer is false
          ] ; end ask target in condition 2
        ] ; end if target is not nobody

        if target = nobody [
        ; if there is no Kproducer to sell capital around, then the seller moves to a better location
          right random 90
          left random 90
          forward reach
      ] ; end if target nobody

    ] ; end if target-production != 0
  ] ; end if count producers not equal to 0
  ] ; end ask sellers

end

to produce-goods
  ask sellers [
    if capital > 0 [
      set ownstock (capital * capital-productivity)
      set capital 0
    ] ; end if capital > 0
  ] ; end ask sellers
end

to trade-goods
; The consumers will now finally consume!

  ask consumers [

    ; First : we need at least one seller in the world
    if count sellers != 0 [

      ; the consumers select the cheapest seller around them
      let target min-one-of sellers in-radius reach [ownprice]

      if target != nobody [
      ;let target min-one-of Kproducers [distance myself]

        ask target [
          set visits visits + 1
        ] ; end ask target

        ; Second : as a consumer, do I have enough money to buy my desired quantity of goods ?
        if money >= needs * [ownprice] of target [

          ; Third : does my seller have enough stock to sell me what I want?
          if needs <= [ownstock] of target [

            ; if these 3 conditions are satisfied, then we can trade and be happy
            ; we ask globals
            let m needs
            set total-Ktrade total-Ktrade + m
            set GDP GDP + m * [ownprice] of target

            ; we are still ask sellers
            set money money - m * [ownprice] of target
            set goods-bought goods-bought + m
            set bought-this-round? true
            set total-trade total-trade + m
            set energy energy + energy-gain-from-good * m

            ask target [
              set money money + ownprice * m
              set ownstock ownstock - m
              set ownsales ownsales + m
              set trade-at-tick trade-at-tick + m
            ] ; end ask target

          ] ; end if needs <= ownstock of target

          if needs > [ownstock] of target [
            let r needs
            ask target [
              set failed-trades-stock failed-trades-stock + r
            ] ; end ask target
          ] ; end if needs > [ownstock] of target

        ] ; end if enough money

        if money < needs * [ownprice] of target [
          let r needs
          ask target [
            set failed-trades-price failed-trades-price + r
          ] ; end ask target
        ] ; end of not enough money to trade

      ] ; end if target nobody

      ; if there is no seller around, the consumer move to another location!
      if target = nobody [
        right random 90
        left random 90
        forward reach
      ] ; end target is nobody

    ] ;end if count sellers
  ] ; end ask consumers
end

to tax

  ;; tax on sale for sellers
  ask sellers [
    set money money - tax-sale-sellers * trade-at-tick
    set GDP GDP + tax-sale-sellers * trade-at-tick
    set state-budget state-budget + tax-sale-sellers * trade-at-tick
  ] ; end ask sellers

  ;; tax on sale for Kproducers
  ask Kproducers [
    set money money - tax-sale-Kprod * Ktrade-at-tick
    set GDP GDP + tax-sale-Kprod * Ktrade-at-tick
    set state-budget state-budget + tax-sale-Kprod * Ktrade-at-tick
  ] ; end ask Kprod

  ;; tax on fixed costs
  ask sellers [
    if fix-tax-sellers? = true [
    set money money - fixed-cost-sellers
    set state-budget state-budget + fixed-cost-sellers
    set GDP GDP + fixed-cost-sellers
    ]; end if FTS true
  ] ; end ask sellers

  ask Kproducers [
    if fix-tax-Kprod? = true [
    set money money - fixed-cost-Kprod
    set state-budget state-budget + fixed-cost-Kprod
    ] ; end if FTK true
  ] ; end ask Kproducers

  ;; tax on income for consumers that work
  ask consumers [
    if tax-income? = true [
      if employed? = true [
        set money money - tax-income
        set state-budget state-budget + tax-income
        set GDP GDP + tax-income
      ] ; end if employed = true
    ] ; end if tax income true
  ] ; end ask consumers
end

to adjust

  ; First, adjust prices
ask Kproducers [

   if visits = 0
  [
    ;change location
    right random 90
    left random 90
    forward 1
  ] ;end if visits

  if visits != 0
  [
    if failed-trades-price = 0
    [
      if failed-trades-stock = 0
      [
        if ownKstock = 0
        [
            set ownKprice ownKprice + greedy-price
        ] ; end if ownKstock = 0

        if ownKstock > 0
        [
            if ownKstock < Ktrade-at-tick
            [
              set target-Kproduction Ktrade-at-tick - ownKstock
            ] ;end if ownKstock < Ktrade-at-ticks

            if ownKstock >= Ktrade-at-tick
            [
              if ownKstock < stock-clearing-treshold [
                set target-Kproduction 0
              ] ;end if ownKstock < stock-clearing-treshold

              if ownKstock >= stock-clearing-treshold [
                set target-Kproduction 0
                set ownKprice ownKprice - stock-clearing-sensibility
              ] ; end if ownKstock >= stock-clearing-treshold
            ] ;end if ownKstock >= Ktrade-at-tick

        ] ;end if ownKstock > 0

      ] ; if FTST = 0

      if failed-trades-stock > 0
      [
        set target-Kproduction visits + failed-trades-stock
      ] ; if FTST > 0

    ] ;end if FTP = 0

    if failed-trades-price > 0
    [
      if failed-trades-stock = 0
      [
        if ownKstock = 0
        [
            set ownKprice ownKprice + d-price * failed-trades-price
        ] ; end if ownKstock = 0

        if ownKstock > 0
        [
            if ownKstock < Ktrade-at-tick
            [
              set ownKprice ownKprice - d-price * failed-trades-price
              set target-Kproduction Ktrade-at-tick - ownKstock
            ] ; end if ownKstock < Ktrade-at-tick

            if ownKstock >= Ktrade-at-tick
            [
              if ownKstock < stock-clearing-treshold [
              set ownKprice ownKprice - d-price * failed-trades-price
              set target-Kproduction 0
              ] ;end if ownKstock < stock-clearing-treshold

              if ownKstock >= stock-clearing-treshold [
                set target-Kproduction 0
                set ownKprice ownKprice - d-price * failed-trades-price - stock-clearing-sensibility
              ] ; end if ownKstock >= stock-clearing-treshold
            ] ; end if ownKstock >= Ktrade-at-tick

        ] ;end if ownKstock > 0

      ] ;end if FTST = 0

      if failed-trades-stock > 0
      [
        set ownKprice ownKprice + d-price * failed-trades-price
        set target-Kproduction visits + failed-trades-stock
      ] ; end if TFST > 0

    ] ;end if FTP > 0

  ] ;end if visits

] ;end ask Kproducers

;;; ADJUST WAGES

  ask Kproducers  [

    if wage < minimum-wage [

      set wage minimum-wage

    ] ; end of if wage < minimum-wage

    if wage >= minimum-wage [

      if money <= 0 [

        set wage minimum-wage
      ] ; end if money <= 0

      if money < wage [
        set wage minimum-wage
      ] ; end if money < wage

      if money > 0 [
        if money >= rich-firm-treshold [
          set wage wage + rich-firm-wage-delta
        ] ; end if firm is rich
      ] ; end if money > 0
    ] ; end if wage >= minimum-wage
  ] ; end of ask Kproducers


; adjust wages for rationnality?


;;; ADJUST FOR SELLERS
; first adjust prices

ask sellers [

   if visits = 0
  [
    ;change location
    right random 90
    left random 90
    forward 1
  ] ;end if visits

  if visits != 0
  [
    if failed-trades-price = 0
    [
      if failed-trades-stock = 0
      [
        if ownstock = 0
        [
            set ownprice ownprice + greedy-price
        ] ; end if ownKstock = 0

        if ownstock > 0
        [
            if ownstock < trade-at-tick
            [
              set target-production trade-at-tick - ownstock
            ] ;end if ownKstock < Ktrade-at-ticks

            if ownstock >= trade-at-tick
            [
               if ownstock < stock-clearing-treshold [
                set target-production 0
              ] ; end if ownstock < stock-clearing-treshold

              if ownstock >= stock-clearing-treshold [
                set target-production 0
                set ownprice ownprice - stock-clearing-sensibility
              ] ; end if ownstock >= stock-clearing-treshold
            ] ;end if ownKstock >= Ktrade-at-tick

        ] ;end if ownKstock > 0

      ] ; if FTST = 0

      if failed-trades-stock > 0
      [
        set target-production visits + failed-trades-stock
      ] ; if FTST > 0

    ] ;end if FTP = 0

    if failed-trades-price > 0
    [
      if failed-trades-stock = 0
      [
        if ownstock = 0
        [
            set ownprice ownprice - d-price * failed-trades-price
        ] ; end if ownKstock = 0

        if ownstock > 0
        [
            if ownstock < trade-at-tick
            [
              set ownprice ownprice - d-price * failed-trades-price
              set target-production trade-at-tick - ownstock
            ] ; end if ownKstock < Ktrade-at-tick

            if ownstock >= trade-at-tick
            [
              if ownstock < stock-clearing-treshold [
                set ownprice ownprice - d-price * failed-trades-price
                set target-production 0
              ] ; end if ownstock < stock-clearing-treshold

              if ownstock >= stock-clearing-treshold [
                set target-production 0
                set ownprice ownprice - d-price * failed-trades-price - stock-clearing-sensibility
              ] ; end if ownstock >= stock-clearing-treshold
            ] ; end if ownKstock >= Ktrade-at-tick

        ] ;end if ownKstock > 0

      ] ;end if FTST = 0

      if failed-trades-stock > 0
      [
        set ownprice ownprice - d-price * failed-trades-price
        set target-production visits + failed-trades-stock
      ] ; end if TFST > 0

    ] ;end if FTP > 0

  ] ;end if visits
    if ownprice < mean-price * 0.25 [
      set ownprice ownprice + greedy-price
    ] ; end if ownprice < 25% of average price

] ;end ask sellers

end

to set-end-values

  set total-money-sellers sum [money] of sellers
  set total-money-consumers sum [money] of consumers
  set total-money-Kproducers sum [money] of Kproducers

  set total-stock sum [ownstock] of sellers

  set total-Kstock sum [ownKstock] of Kproducers
  set total-Ktrade sum [ownKsales] of Kproducers



if count sellers != 0 [
  set mean-price sum [ownprice] of sellers / count sellers
  ]
if count Kproducers != 0 [
  set mean-Kprice sum [ownKprice] of Kproducers / count Kproducers
  ]


end
@#$#@#$#@
GRAPHICS-WINDOW
199
16
716
534
-1
-1
5.04
1
10
1
1
1
0
1
1
1
-50
50
-50
50
0
0
1
ticks
30.0

BUTTON
-1
221
54
254
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
112
221
167
254
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
56
222
111
255
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
1420
20
1880
279
Mean Money per Agent (Seller / Buyer / Kproducer)
Days
Value
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"sellers money" 1.0 0 -2674135 true "" "plot (sum [money]of sellers / count sellers)"
"consumers money" 1.0 0 -11221820 true "" "plot ( sum [money] of consumers / count consumers)"
"Kproducers money" 1.0 0 -955883 true "" "plot (sum [money] of Kproducers / count Kproducers)"
"0" 1.0 0 -7500403 true "" "plot 0"

PLOT
1054
19
1412
282
Prices vs Time
Days
Price
0.0
5.0
0.0
5.0
true
true
"" ""
PENS
"mean-price" 1.0 0 -16777216 true "" "plot sum [ownprice] of sellers / count sellers"
"mean-price of capital" 1.0 0 -955883 true "" "plot sum [ownKprice] of Kproducers / count Kproducers"
"0" 1.0 0 -7500403 true "" "plot 0"

SLIDER
-1
42
171
75
n-sellers
n-sellers
1
500
179.0
1
1
NIL
HORIZONTAL

SLIDER
0
75
172
108
n-consumers
n-consumers
1
2000
765.0
1
1
NIL
HORIZONTAL

SLIDER
-1
187
170
220
initial-price-sellers
initial-price-sellers
0
10
10.0
0.1
1
NIL
HORIZONTAL

SLIDER
-1
154
170
187
initial-endowment-consumers
initial-endowment-consumers
0
100
100.0
1
1
NIL
HORIZONTAL

MONITOR
891
65
970
110
%employed
employment-rate
1
1
11

PLOT
724
20
1056
283
Employment-rate vs Wage 
Days
Value
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"Employment rate" 1.0 0 -16777216 true "" "plot employment-rate"
"Mean-wage * 5" 1.0 0 -2674135 true "" "plot (5 * sum [wage] of Kproducers) / count Kproducers"

SLIDER
0
10
172
43
n-Kproducers
n-Kproducers
1
500
147.0
1
1
NIL
HORIZONTAL

SLIDER
-1
123
170
156
initial-endowment-producers
initial-endowment-producers
0
100
100.0
1
1
NIL
HORIZONTAL

SLIDER
2
339
174
372
capital-productivity
capital-productivity
0
10
1.3
0.1
1
NIL
HORIZONTAL

SLIDER
2
304
174
337
minimum-wage
minimum-wage
0
50
0.65
0.01
1
NIL
HORIZONTAL

SLIDER
318
611
491
644
stock-clearing-treshold
stock-clearing-treshold
1
1000
50.0
1
1
NIL
HORIZONTAL

SLIDER
319
576
489
609
stock-clearing-sensibility
stock-clearing-sensibility
0
10
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
141
576
315
609
rationnal-wage-delta
rationnal-wage-delta
0
1
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
684
610
856
643
rich-firm-wage-delta
rich-firm-wage-delta
-1
1
0.1
0.01
1
NIL
HORIZONTAL

PLOT
724
289
1486
534
GDP vs Time
Days
GDP
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot GDP"
"pen-1" 1.0 0 -7500403 true "" "plot 0"

SLIDER
506
611
678
644
greedy-price
greedy-price
0
1
0.25
0.01
1
NIL
HORIZONTAL

SLIDER
143
612
315
645
d-price
d-price
0
1
0.4
0.01
1
NIL
HORIZONTAL

PLOT
1493
573
1873
769
Sellers / Kproducers Stock Dynamics
Days
Values
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"FTST sellers" 1.0 0 -2674135 true "" "plot sum [failed-trades-stock] of sellers / count sellers"
"TP sellers" 1.0 0 -955883 true "" "plot sum [target-production] of sellers / count sellers"
"Sales Kprod" 1.0 0 -13840069 true "" "plot sum [ownKsales] of Kproducers / count Kproducers"
"FTST Kprod" 1.0 0 -13210332 true "" "plot sum [failed-trades-stock] of Kproducers / count Kproducers"
"TKP Kprod" 1.0 0 -11221820 true "" "plot sum [target-Kproduction] of Kproducers / count Kproducers"
"GStock" 1.0 0 -5825686 true "" "plot sum [ownstock] of sellers / count sellers"
"Kstock" 1.0 0 -10141563 true "" "plot sum [ownKstock] of Kproducers / count Kproducers"
"KTAT" 1.0 0 -13345367 true "" "plot sum [Ktrade-at-tick] of Kproducers / count Kproducers"
"GTAT" 1.0 0 -2064490 true "" "plot sum [trade-at-tick] of sellers / count sellers"

MONITOR
1296
107
1352
152
m-Kprice
sum [ownKprice] of Kproducers / count Kproducers
1
1
11

MONITOR
1297
162
1354
207
m-Gprice
sum [ownprice] of sellers / count sellers
1
1
11

MONITOR
946
153
1041
198
NIL
employment-rate
1
1
11

MONITOR
957
94
1035
139
mean-wage
sum [wage] of Kproducers / count Kproducers
1
1
11

MONITOR
1767
119
1862
164
K mean-money
sum [money] of Kproducers / count Kproducers
1
1
11

SLIDER
612
706
776
739
state-help-sellers
state-help-sellers
0
500
200.0
1
1
NIL
HORIZONTAL

SWITCH
85
749
260
782
state-intervention-sellers?
state-intervention-sellers?
0
1
-1000

SLIDER
1
269
173
302
reach
reach
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   