globals [
mylist-x
mylist-y
  sheep-birth-rate
  predation-rate
  predator-efficiency
  wolf-death-rate
  sheep
  wolves
  dt
]

to setup
  ;clear-all
  clear-globals
  clear-ticks
  clear-patches
  clear-all-plots
  ask patches with [ pxcor = 0 ] [  set pcolor white ]
  ask patches with [ pycor = 0 ] [  set pcolor white ]
  setup-coordinates
  set mylist-x list 0 (sheep)
  set mylist-y list 0 (wolves)
  system-dynamics-setup
  system-dynamics-do-plot
end

to system-dynamics-setup
  reset-ticks
  set dt 0.009
  set sheep-birth-rate sheep-birth-rate-slider
  set predation-rate predation-rate-slider
  set predator-efficiency .8
  set wolf-death-rate 0.15
  set sheep sheep-num
  set wolves wolves-num
end

to clear-picture
  ca
end

to go
  system-dynamics-go
  system-dynamics-do-plot
  set mylist-x lput result-x mylist-x
  set mylist-y lput result-y mylist-y
  crt 1 [
    set color select-phase-plot-color
    set xcor (last mylist-x * 0.15)
    set ycor (last mylist-y * 0.15)
    set size 0.5
    set shape "circle"
  ]

  if ticks >= 300 [ stop ]
end

to system-dynamics-go

  let local-sheep-births sheep-births
  let local-sheep-deaths sheep-deaths
  let local-wolf-births wolf-births
  let local-wolf-deaths wolf-deaths

  let new-sheep max( list 0 ( sheep + local-sheep-births - local-sheep-deaths ) )
  let new-wolves max( list 0 ( wolves + local-wolf-births - local-wolf-deaths ) )
  set sheep new-sheep
  set wolves new-wolves

  tick-advance dt
end

to-report sheep-births
  report ( sheep-birth-rate * sheep
  ) * dt
end

to-report sheep-deaths
  report ( sheep * predation-rate * wolves
  ) * dt
end

to-report wolf-births
  report ( wolves * predator-efficiency * predation-rate * sheep
  ) * dt
end

to-report wolf-deaths
  report ( wolves * wolf-death-rate
  ) * dt
end

to-report result-x
  report sheep
end

to-report result-y
    report  wolves
end

to setup-coordinates
  ask patch -5 5
  [ set plabel "0"
    set plabel-color white ]

  ask patch -7 160
  [ set plabel "1000"
    set plabel-color white ]

  ask patch -7 80
  [ set plabel "500"
    set plabel-color white ]

  ask patch 160 -5
  [ set plabel "1000"
    set plabel-color white ]

  ask patch 320 -5
  [ set plabel "2000"
    set plabel-color white ]

  ask patch -5 -48
  [ set plabel "-50"
    set plabel-color white ]

  ask patch -40 -5
  [ set plabel "-50"
    set plabel-color white ]

  ask patch -10 193
  [ set plabel "Wolves"
    set plabel-color blue ]

  ask patch 380 -10
  [ set plabel "Sheep"
    set plabel-color red ]
end

to system-dynamics-do-plot
  if plot-pen-exists? "sheep" [
    set-current-plot-pen "sheep"
    plotxy ticks sheep
  ]
  if plot-pen-exists? "wolves" [
    set-current-plot-pen "wolves"
    plotxy ticks wolves
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
328
23
1006
501
-1
-1
1.33733
1
10
1
1
1
0
1
1
1
-50
450
-50
300
1
1
1
ticks
30.0

BUTTON
39
13
143
46
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
164
14
262
47
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
37
60
143
105
NIL
sheep
3
1
11

MONITOR
164
60
270
105
NIL
wolves
3
1
11

PLOT
10
114
312
275
Populations
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"wolves" 1.0 0 -13345367 true "" ""
"sheep" 1.0 0 -2674135 true "" ""

SLIDER
11
336
213
369
sheep-num
sheep-num
50
150
100.0
1
1
NIL
HORIZONTAL

SLIDER
11
375
213
408
wolves-num
wolves-num
20
50
30.0
1
1
NIL
HORIZONTAL

SLIDER
11
414
213
447
sheep-birth-rate-slider
sheep-birth-rate-slider
0.01
0.07
0.03
0.01
1
NIL
HORIZONTAL

SLIDER
11
451
213
484
predation-rate-slider
predation-rate-slider
0.0003
0.001
3.0E-4
0.0001
1
NIL
HORIZONTAL

BUTTON
223
422
320
500
Clear-drawing
ca
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
43
281
207
326
Select-phase-plot-color
Select-phase-plot-color
55 35 45 115
0

TEXTBOX
240
281
371
356
Colors:\n55 - green\n35 - red\n45 - yellow\n115 - violet\n
12
0.0
1

@#$#@#$#@
NB: Since this model is very slow while run in NetLogo Web it is recommended to download and run it on your PC.

## WHAT IS IT?

This is a model of a phase-space plot of the Lotka-Volterra equations. It is based on the Wolf Sheep Predation (System Dynamics) Model in NetLogo library.

The Lotka-Volterra equations are a pair of first order, non-linear, differential equations that describe the dynamics of biological systems in which two species interact.

## HOW IT WORKS

The Lotka–Volterra equations, also known as the predator–prey equations represent a system of two dimensional, first-order, nonlinear, differential equations frequently used to describe the dynamics of biological systems in which two species interact, one as a predator and the other as prey. The populations change through time according to the pair of equations:

dX/dt = αX - βXY (1)
dY/dt = δXY - γY (2)

where

* X is the number of prey (in this model, sheep);
* Y is the number of some predator (in this model, wolves);

* dX/dt and dY/dt represent the growth rates of the two populations over time;
* t represents time; 
* α, β, γ, δ are positive real parameters describing the interaction of the two species.

* αX represents the exponential growth of the pray population (in this model as 'sheep-births' flow which is added to sheep stock) and the rate of predation upon the prey is assumed to be proportional to the rate at which the predators and the prey meet (in the actual model this is 'sheep-deaths' flow which is subtracted from the sheep stock): this is represented by βxy. If either x or y is zero then there can be no predation.

* δXY represents the growth of the predator population and γY represents the loss rate of the predators due to either natural death or emigration; it leads to an exponential decay in the absence of prey. 

Each flow is calculated in terms of the variables, and stocks that are linked to it.
 
Governed by these equations and calculations a phase-space plot is generated where X-axis represents the number of pray and Y-axis represents the number of predators. With each calculation a turtle is generated and plotted on the plane with respective coordinates. 

After 300 ticks (i.e. time-steps) the model automatically stops. 


## HOW TO USE IT

Press the buttons (in respective numerical order): 

(1) Setup: creates basic conditions for the model to run (i.e. erases data from previous runs, generates X and Y axes, etc.). The plots from previous runs are preserved for further comparison.

(2) Go: starts running the model with generation of new points (turtles) in accordance with numeric values as a result of calculations, performed every time-step. 

(3) and (4): These two monitors show the number of sheep and wolves at any particular time-step during the model run. 

Activating/Pressing the above buttons will run the model with initial settings, which are close to the Wolf Sheep Predation (System Dynamics) Model in NetLogo library.

The sliders and chooser below allow to change some of the equations parameters and select the color of the plot to be generated during new runs of the model: 

(5) This chooser is for selecting the color of the plot for the next model run. Colors are presented by their number on color swatches pallet. On the right there is a list of available colors and their numeric values.

(6), (7), (8) and (9) are sliders which allow to change some parameters of the equations (e.g. number of sheep and wolves, sheep-birth-rate, predation-rate). These values can be changed before a model run/before pressing 'Setup' and 'Go' buttons.

(10) 'Clear-drawing' button clear all the values: globals, ticks, turtles, patches, drawing, plots, and output.  
  
## THINGS TO NOTICE

Initially the model parameters are set close to the ones in the Sheep Predation (System Dynamics) Model in NetLogo library (i.e. number of sheep = 100, number of wolves = 30, sheep birth-rate (α) = 0.04, predation rate (β) = .0003, predator efficiency (δ) = 0.8 , wolf death-rate (γ) = 0.15)

Changing these parameters will lead to change in phase-plot shape. Running the model with different values of the parameters may help to clarify the impact of a certain parameter(s) on the phase-plot shape. 

## THINGS TO TRY

You can change model parameters one by one or combined and observe the impact of these changes on the phase-plot. Which combinations will provide the max number of sheep/wolves during the model run with the selected parameters? Try to find combinations that will lead to one of species extinction.  

Before running the model with new settings you should first set the parameters using respective sliders, then select the color for the new plot and then press "Setup" and "Go". 

## EXTENDING THE MODEL

The number of parameters that can be varied by sliders in this model is limited. An extension of the model would be adding sliders for additional parameters (e.g. predation efficiency, wolf death-rate, etc.). 

## NETLOGO FEATURES

This model is based on Wolf Sheep Predation (System Dynamics) Model in NetLogo library. In some aspects it was converted from 'System Dynamics' version to a 'regular' one by recompiling the code and adding new pieces of the code with respective changes/additions in the model interface (buttons, sliders, etc.).

## RELATED MODELS

* Wolf Sheep Predation (System Dynamics) Model
* Wolf Sheep Predation (Docked Hybrid) Model, both present in NetLogo model library
* Van Der Pol Oscillator Model

## CREDITS AND REFERENCES

This simple abstract model was developed by Victor Iapascurta, MD. At time of development he was in the Department of Anesthesia and Intensive Care at University of Medicine and Pharmacy in Chisinau, Moldova / ICU at City Emergency Hospital in Chisinau. Please email any questions or comments to viapascurta@yahoo.com

The model was created in NetLogo 6.0.1, Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

This model was inspired by Introduction to Dynamical Systems and Chaos (Fall, 2017) MOOC by David Feldman @ Complexity Explorer (https://www.complexityexplorer.org/courses).
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          