
; set up different molecules
breed [ oxygens oxygen]
breed [ mitos mito ] ; mitochondries mitochondrie
breed [ ATPs ATP ] ; Adenosine Tri Phosphate
breed [ CO2s CO2 ] ; carbon dioxide

; set up a transporter
breed [ hbs hb] ; hemoglobins hemoglobin


; set up different kind of environment
patches-own [ lung-cell? muscle-cell? blood-cell? ]

; internal variables
hbs-own [ oxygen-fixed CO2-fixed]
CO2s-own [ life ]

;;;; SETUP AND GO ;;;;;;;;;;;

to setup
  clear-all
  setup-hbs
  setup-oxygens
  setup-mitos
  setup-ATPs
  setup-patches
  reset-ticks
; let world-area (2 * max-pxcor + 1) * (2 * max-pycor + 1)
end

to go
  move-hbs
  move-oxygens
  move-mitos
  move-CO2s
  move-ATPs
  ask hbs [
    HB-get-oxygen
    HB-drop-oxygen
    HB-get-CO2
    HB-drop-CO2
  ]
  ask mitos [
    mitos-creates-ATP
  ]
  ask CO2s [
  CO2-loose-life
  ]
  tick
end

;to breathe
;  breathe-in
;  breathe-out
;end

to move
  move-consumption
end

; a button to make some oxygen go in the lungs with a slider breath-oxy
to breath
  create-oxygens breath-oxy [
    set shape "dot"
    setxy (- 7 - random-float (15 - 8 + 1 )) ( 15 -  random-float (32 ))
    set color blue
  ]
end



;;;;;;;;; SETTING UP ;;;;;;;;;;;;;

; setup patches with 3 aeras: from left to right lungs in cyan, vessels in white and muscle in pink.
to setup-patches
  ask patches [
    if ( pxcor > -16 ) and ( pxcor < -4 ) [set pcolor cyan + 3
      set lung-cell? true ]
    if ( pxcor > -5 and pxcor < 5 ) [set pcolor white
      set blood-cell? true ]
    if ( pxcor > 4 and pxcor < 16 ) [set pcolor pink + 3
      set muscle-cell? true]
    if ( pxcor = -16 ) or ( pxcor = 16 ) [set pcolor grey ]
  ]
end

; setup hemoglobin with by default 1 oxygen on
to setup-hbs
  create-hbs NBhb
  ask hbs [
    set shape "orbit 1"
    setxy random-xcor random-ycor
    set color red
    set size 1
    set oxygen-fixed 1
  ]
end

; definition of hemoglobin moves and go backward if a grey wall is met
to move-hbs
  ask hbs [
    right random 50
    left random 50
    if [pcolor] of patch-ahead 1 = grey [ lt 180 ]
    forward 1
  ]
end

; setup oxygen only in lungs
to setup-oxygens
  create-oxygens NBoxygen
  ask oxygens [
    set shape "dot"
    setxy (- 7 - random-float (15 - 8 + 1 )) ( 15 -  random-float (32 ))
    set color blue
  ]
end

; definition of oxygen moves only between white and grey
to move-oxygens
  ask oxygens[
    right random 60
    if [pcolor] of patch-ahead 1 = white [ lt 180 ]
    if [pcolor] of patch-ahead 1 = grey [ lt 180 ]
    forward 1
  ]
end

; setup the number of mitochondrias in the muscle (more there is more ATP can be produced
to setup-mitos
  create-mitos NBmitos
  ask mitos [
    set shape "factory"
    setxy (15 - random-float (15 - 7 + 1 )) ( 15 -  random-float (32 ))
    set color green
  ]
end

; definition of mitochondrias moves
to move-mitos
  ask mitos[
    right random 50
    left random 50
    if [pcolor] of patch-ahead 1 = white [ lt 180 ]
    if [pcolor] of patch-ahead 1 = grey [ lt 180 ]
    forward 1
  ]
end

; definition of CO2 moves
to move-CO2s
  ask CO2s[
    right random 50
    left random 50
    if [pcolor] of patch-ahead 1 = white [ lt 180 ]
    if [pcolor] of patch-ahead 1 = grey [ lt 180 ]
    forward 1
  ]
end

; definition of ATP moves
to move-ATPs
  ask ATPs[
    right random 50
    left random 50
    if [pcolor] of patch-ahead 1 = white [ lt 180 ]
    if [pcolor] of patch-ahead 1 = grey [ lt 180 ]
    forward 1
  ]
end

; setup of ATPs style
to setup-ATPs
  ask ATPs [
    set shape "dot"
    set size 2
    set color yellow
  ]
end

;;;;;;;;;;;;;;;;; Procedures ;;;;;;;;;;;;;;;;;;


;;;;;;;;; HB ;;;;;;;;
; function to stick O2 on hemoglobins
to HB-get-oxygen
  let oxygen-consumed one-of oxygens-here
  if oxygen-consumed != nobody and oxygen-fixed = 1 [
    ask oxygen-consumed [ die ]
    set oxygen-fixed 2 set shape "orbit 2"
  ]
  if oxygen-consumed != nobody and oxygen-fixed = 2 [
    ask oxygen-consumed [ die ]
    set oxygen-fixed 3 set shape "orbit 3"
  ]
  if oxygen-consumed != nobody and oxygen-fixed = 3 [
    ask oxygen-consumed [ die ]
    set oxygen-fixed 4 set shape "orbit 4"
  ]
end

; function to drop O2 from hemoglobins
to HB-drop-oxygen
  if pcolor = pink + 3 and oxygen-fixed = 4 [
    set oxygen-fixed 3 set shape "orbit 3"
    hatch-oxygens 1 [ set shape "dot" set color blue ]
  ]
  if pcolor = pink + 3 and oxygen-fixed = 3 [
    set oxygen-fixed 2 set shape "orbit 2"
    hatch-oxygens 1 [ set shape "dot" set color blue ]
  ]
  if pcolor = pink + 3 and oxygen-fixed = 2 [
    set oxygen-fixed 1 set shape "orbit 1"
    hatch-oxygens 1 [ set shape "dot" set color blue ]
  ]
end

; function to stick CO2 on hemoglobins (and take care of shapes)
to HB-get-CO2
  let CO2-consumed one-of CO2s-here
  if CO2-consumed != nobody and CO2-fixed = 0 and oxygen-fixed = 3 [
    ask CO2-consumed [ die ]
    set shape "orbit 4 with co2"
    set CO2-fixed 1
  ]
  if CO2-consumed != nobody and CO2-fixed = 1 and oxygen-fixed = 2 [
    ask CO2-consumed [ die ]
    set shape "orbit 4 with 2 co2"
    set CO2-fixed 2
  ]
  if CO2-consumed != nobody and CO2-fixed = 0 and oxygen-fixed = 2 [
    ask CO2-consumed [ die ]
    set shape "orbit 3 with co2"
    set CO2-fixed 1
  ]
  if CO2-consumed != nobody and CO2-fixed = 1 and oxygen-fixed = 1 [
    ask CO2-consumed [ die ]
    set shape "orbit 3 with 2 co2"
    set CO2-fixed 2
  ]
  if CO2-consumed != nobody and CO2-fixed = 0 and oxygen-fixed = 1 [
    ask CO2-consumed [ die ]

    set shape "orbit 2 with co2"
    set CO2-fixed 1
  ]
end

; function to drop CO2 from hemoglobins (and take care of shapes)
to HB-drop-CO2
  if pcolor = cyan + 3 and CO2-fixed = 2 and oxygen-fixed = 2 [
    set CO2-fixed 1 set shape "orbit 3 with co2"
    hatch-CO2s 1 [ set shape "dot" set color black set life 5 ]
  ]
  if pcolor = cyan + 3 and CO2-fixed = 2 and oxygen-fixed = 1 [
    set CO2-fixed 1 set shape "orbit 2 with co2"
    hatch-CO2s 1 [ set shape "dot" set color black set life 5 ]
  ]
  if pcolor = cyan + 3 and CO2-fixed = 1 and oxygen-fixed = 3 [
    set CO2-fixed 0 set shape "orbit 3"
    hatch-CO2s 1 [ set shape "dot" set color black set life 5 ]
  ]
  if pcolor = cyan + 3 and CO2-fixed = 1 and oxygen-fixed = 2 [
    set CO2-fixed 0 set shape "orbit 2"
    hatch-CO2s 1 [ set shape "dot" set color black set life 5 ]
  ]
  if pcolor = cyan + 3 and CO2-fixed = 1 and oxygen-fixed = 1 [
    set CO2-fixed 0 set shape "orbit 1"
    hatch-CO2s 1 [ set shape "dot" set color black set life 5 ]
  ]
end

;;;;;;; Muscles ;;;;;;;;

; function to create ATPs and CO2 from burning O2
to mitos-creates-ATP
  let oxygen-burned one-of oxygens-here
  if oxygen-burned != nobody [
    ask oxygen-burned [ die ]
    hatch-ATPs 19 [ set shape "lightning" set size 1 ]
    hatch-CO2s 1 [ set shape "dot" set color black]
  ]
end

; function to define how the button move consumes ATP
to move-consumption
   let atp-burned one-of ATPs-here
  if atp-burned != nobody and pcolor = pink + 3 [
    ask atp-burned [ die ]
  ]
end


;;;;;;; lungs ;;;;;;;

; function to make CO2 disappear slowly
to CO2-loose-life
  if pcolor = cyan + 3 [ set life life - 1 ]
  if life < 0 [ die ]
end


;; Copyright 2024 Antoine Herbet
@#$#@#$#@
GRAPHICS-WINDOW
718
63
1282
628
-1
-1
16.85
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
189
96
309
166
SETUP
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
256
195
485
228
NBhb
NBhb
100
1000
360.0
10
1
NIL
HORIZONTAL

BUTTON
454
97
581
166
GO
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
256
234
484
267
NBoxygen
NBoxygen
100
1000
400.0
50
1
NIL
HORIZONTAL

SLIDER
257
271
483
304
NBmitos
NBmitos
20
100
55.0
5
1
NIL
HORIZONTAL

PLOT
175
448
375
598
Oxygen 
NIL
NIL
0.0
10.0
0.0
1000.0
true
false
"" ""
PENS
"default" 1.0 0 -13345367 true "" "plot count oxygens"
"pen-1" 1.0 0 -16777216 true "" "plot count CO2s"

PLOT
398
447
598
597
ATP Stock
NIL
NIL
0.0
10.0
0.0
50.0
true
false
"" ""
PENS
"default" 1.0 0 -4079321 true "" "plot count ATPs"

BUTTON
525
299
657
382
MOVE
move
T
1
T
TURTLE
NIL
NIL
NIL
NIL
1

BUTTON
91
194
216
280
BREATH
breath
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
256
310
483
343
breath-oxy
breath-oxy
50
800
300.0
50
1
NIL
HORIZONTAL

BUTTON
525
192
657
291
MOVE
move
NIL
1
T
TURTLE
NIL
NIL
NIL
NIL
1

BUTTON
92
290
217
375
BREATH Locked
breath
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
319
96
446
166
GO - One tick
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model is trying to show how Hemoglobin takes some oxygen from lungs and transport it to muscles to produce ATP (energy). This energy can be consumed by moving. Some CO2 is produced and need to be evacuated by the lungs. 

## HOW IT WORKS

Oxygen can't go through blood (in white) and need to use hemoglobin to go in the muscle to drop oxygen. This oxygen will then be consumed by mitochondrias to produce ATP. The ATP (yellow lightnings) can be consumed by moving. 

## HOW TO USE IT

Use SETUP to create the world: cyan for lungs, white for blood, pink for muscles.
Push GO to through one tick
Push BREATHE to breathe and create more oxygen in the lungs (you can select how many oxygen you want to create with breath-oxy slider)
Push MOVE to consum ATP 
Use NBmitos slider to create more mitochondrias at setup.
Use NBhb slider to create more hemoglobins at the beginning


## THINGS TO NOTICE

In this model hemoglobin can bring 1 to 4 molecules of oxygen (blue dots on the red circle) and 1 to 2 CO2 (red dots). In real life the O2 saturation follows a sigmoide curve always above 95% except for some diseases and CO2 can be transported by hemoglobin but in less proportion. In real life a very few O2 may go through blood without transport but it's more common to have CO2 dissolved in blood.  

## THINGS TO TRY

You can breathe and move and vary every nb on sliders to see how it can evolve. 

## EXTENDING THE MODEL

To extend the model it is possible to do many things:
	- code for all energy production pathways in the cell with perfect chemistry proportions ( glycolysis, CRP, krebs cycle, ...)
	- code to let O2 and CO2 go through blood without using hemoglobins
	- code for buffer systems (NADH, FADH2...)
	- code for acid-base balance with CO2, O2 and pH thanks to  
	- code for HEAT and H2O management
	- correlate a full chemistry model with external variables (VO2max, Tlim, ...) to try to predict performance

## NETLOGO FEATURES

Segment some aeras with specific rules to move. 
Transportation of molecules. 
Shape of hemoglobins changing with saturation with O2 (blue balls) and CO2 (black balls)


## RELATED MODELS

no idea not found

## CREDITS AND REFERENCES

http://pneumocourlancy.fr/popup/physiologie-respiratoire.pdf
https://fr.wikipedia.org/wiki/Respiration_cellulaire

HERBET Antoine 2024
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

factory
false
0
Rectangle -7500403 true true 76 194 285 270
Rectangle -7500403 true true 36 95 59 231
Rectangle -16777216 true false 90 210 270 240
Line -7500403 true 90 195 90 255
Line -7500403 true 120 195 120 255
Line -7500403 true 150 195 150 240
Line -7500403 true 180 195 180 255
Line -7500403 true 210 210 210 240
Line -7500403 true 240 210 240 240
Line -7500403 true 90 225 270 225
Circle -1 true false 37 73 32
Circle -1 true false 55 38 54
Circle -1 true false 96 21 42
Circle -1 true false 105 40 32
Circle -1 true false 129 19 42
Rectangle -7500403 true true 14 228 78 270

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

lightning
false
0
Polygon -1184463 true false 120 135 90 195 135 195 105 300 225 165 180 165 210 105 165 105 195 0 75 135

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

orbit 1
true
0
Circle -13345367 true false 116 11 67
Circle -7500403 false true 41 41 218

orbit 2
true
0
Circle -13345367 true false 116 221 67
Circle -13345367 true false 116 11 67
Circle -7500403 false true 44 44 212

orbit 2 with co2
true
0
Circle -13345367 true false 116 221 67
Circle -16777216 true false 116 11 67
Circle -7500403 false true 44 44 212

orbit 3
true
0
Circle -13345367 true false 116 11 67
Circle -13345367 true false 26 176 67
Circle -13345367 true false 206 176 67
Circle -7500403 false true 45 45 210

orbit 3 with 2 co2
true
0
Circle -16777216 true false 116 11 67
Circle -16777216 true false 26 176 67
Circle -13345367 true false 206 176 67
Circle -7500403 false true 45 45 210

orbit 3 with co2
true
0
Circle -16777216 true false 116 11 67
Circle -13345367 true false 26 176 67
Circle -13345367 true false 206 176 67
Circle -7500403 false true 45 45 210

orbit 4
true
0
Circle -13345367 true false 116 11 67
Circle -13345367 true false 116 221 67
Circle -13345367 true false 221 116 67
Circle -7500403 false true 45 45 210
Circle -13345367 true false 11 116 67

orbit 4 with 2 co2
true
0
Circle -13345367 true false 116 11 67
Circle -13345367 true false 116 221 67
Circle -16777216 true false 221 116 67
Circle -7500403 false true 45 45 210
Circle -16777216 true false 11 116 67

orbit 4 with co2
true
0
Circle -13345367 true false 116 11 67
Circle -13345367 true false 116 221 67
Circle -16777216 true false 221 116 67
Circle -7500403 false true 45 45 210
Circle -13345367 true false 11 116 67

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
