extensions [ gis ]

globals [socioeco-dataset
         aquifer1-dataset
         aquifer2-dataset
         aquifer3-dataset
         ish-dataset
         z1-dataset
         z2-dataset
         z3-dataset
         socioeco2-dataset
         social-dataset
         ecological-dataset
         boundaries-dataset
          elevation-dataset
          landprice-dataset
          i8t-dataset]

breed [ socioeco-vertices socioeco-vertex]
breed [ aquifer1-vertices aquifer1-vertex]
breed [ aquifer2-vertices aquifer2-vertex]
breed [ aquifer3-vertices aquifer3-vertex]
breed [ ish-vertices ish-vertex]
breed [ z1-vertices z1-vertex]
breed [ z2-vertices z2-vertex]
breed [ z3-vertices z3-vertex]
breed [ social-vertices social-vertex]
breed [ ecological-vertices ecological-vertex]
breed [ landprice-labels landprice-label ]
breed [ boundaries-labels boundaries-label ]
breed [ boundaries-vertices boundaries-vertex]

patches-own [i8t socioeco aquifer1 aquifer2 aquifer3 ish z1 z2 z3 socioeco2 social ecological landprice elevation boundaries]



;SETUP!
to setup
  ca
  ;set x-dataset gis:load-dataset "data/x.shp"
  set socioeco-dataset gis:load-dataset "data/N_socialeco.asc"
  set aquifer1-dataset gis:load-dataset "data/N_aa1.asc"
  set aquifer2-dataset gis:load-dataset "data/N_aa2.asc"
  set aquifer3-dataset gis:load-dataset "data/N_aa3.asc"
   set ish-dataset gis:load-dataset "data/N_ISHa.asc"
   set z1-dataset gis:load-dataset "data/N_Z1a.asc"
   set z2-dataset gis:load-dataset "data/N_Z2a.asc"
   set z3-dataset gis:load-dataset "data/N_Z3a.asc"
  set i8t-dataset gis:load-dataset "data/i8_t.asc"
  set ecological-dataset gis:load-dataset "data/ecologicalresilience.asc"
  set elevation-dataset gis:load-dataset "data/slopemaybe.asc"
  set landprice-dataset gis:load-dataset "data/landprice_raster.asc"
  set boundaries-dataset gis:load-dataset "data/statesmaybe.shp"
  ; Set the world envelope to the union of all of our dataset's envelopes
  gis:set-world-envelope (gis:envelope-union-of (gis:envelope-of socioeco-dataset)
                                                (gis:envelope-of aquifer1-dataset)
                                                (gis:envelope-of aquifer2-dataset)
                                                (gis:envelope-of aquifer3-dataset)
                                                (gis:envelope-of ish-dataset)
                                                (gis:envelope-of z1-dataset)
                                                (gis:envelope-of z2-dataset)
                                                (gis:envelope-of z3-dataset)
                                                (gis:envelope-of ecological-dataset)
                                                (gis:envelope-of landprice-dataset)
                                                (gis:envelope-of boundaries-dataset))
end




; TO TRANSFORM RASTER INTO PATCHES
to sample-socioeco-with-patches
  let min-socioeco gis:minimum-of socioeco-dataset
  let max-socioeco gis:maximum-of socioeco-dataset
  ask patches
  [ set socioeco gis:raster-sample socioeco-dataset self]
end

to sample-aquifer1-with-patches
  let min-aquifer1 gis:minimum-of aquifer1-dataset
  let max-aquifer1 gis:maximum-of aquifer1-dataset
  ask patches
  [ set aquifer1 gis:raster-sample aquifer1-dataset self]
end

to sample-aquifer2-with-patches
  let min-aquifer2 gis:minimum-of aquifer2-dataset
  let max-aquifer2 gis:maximum-of aquifer2-dataset
  ask patches
  [ set aquifer2 gis:raster-sample aquifer2-dataset self]
end

to sample-aquifer3-with-patches
  let min-aquifer3 gis:minimum-of aquifer3-dataset
  let max-aquifer3 gis:maximum-of aquifer3-dataset
  ask patches
  [ set aquifer3 gis:raster-sample aquifer3-dataset self]
end

to sample-ish-with-patches
  let min-ish gis:minimum-of ish-dataset
  let max-ish gis:maximum-of ish-dataset
  ask patches
  [ set ish gis:raster-sample ish-dataset self]
end

to sample-z1-with-patches
  let min-z1 gis:minimum-of z1-dataset
  let max-z1 gis:maximum-of z1-dataset
  ask patches
  [ set z1 gis:raster-sample z1-dataset self]
end

to sample-z2-with-patches
  let min-z2 gis:minimum-of z2-dataset
  let max-z2 gis:maximum-of z2-dataset
  ask patches
  [ set z2 gis:raster-sample z2-dataset self]
end

to sample-z3-with-patches
  let min-z3 gis:minimum-of z3-dataset
  let max-z3 gis:maximum-of z3-dataset
  ask patches
  [ set z3 gis:raster-sample z3-dataset self]
end


; TO INTERVENTIONS

to evaluate
if socioeco  <= 5 [set pcolor red + 4.9]
if socioeco > 5 and socioeco <= 10 [set pcolor red + 4.5]
if socioeco > 10 and socioeco <= 15 [set pcolor red + 4]
if socioeco > 15 and socioeco <= 20 [set pcolor red + 3.5]
if socioeco > 20 and socioeco <= 25 [set pcolor red + 3]
if socioeco > 25 and socioeco <= 30 [set pcolor red + 2.5]
if socioeco > 30 and socioeco <= 35 [set pcolor red + 2]
if socioeco > 35 and socioeco <= 40 [set pcolor red + 1.5]
if socioeco > 40 and socioeco <= 45 [set pcolor red + 1]
if socioeco > 45 and socioeco <= 50 [set pcolor red + 0.5]
if socioeco > 50 and socioeco <= 55 [set pcolor red + 0]
if socioeco > 55 and socioeco <= 60 [set pcolor red - 0.5]
if socioeco > 60 and socioeco <= 65 [set pcolor red - 1]
if socioeco > 65 and socioeco <= 70 [set pcolor red - 1.5]
if socioeco > 70 and socioeco <= 76 [set pcolor red - 2]
if socioeco > 75 and socioeco <= 80 [set pcolor red - 2.5]
if socioeco > 80 and socioeco <= 85 [set pcolor red - 3]
if socioeco > 85 and socioeco <= 90 [set pcolor red - 3.5]
if socioeco > 90 and socioeco <= 95 [set pcolor red - 4]
if socioeco > 95 and socioeco <= 100 [set pcolor red - 4.5]
end

to wtp-a-ss/2
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.87 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.87]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.87]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.18]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.83]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + .83]
end

to wtp-i-10/2
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.9]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.9 ]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.9 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.32]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.42]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.43]
end

to wtp-a/2
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.05 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.05]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.05]
  ask patches with [ish = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.725]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.21]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.22]
end

to z2-h/2
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.25]
end

to z3-h/3
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.75]
end

to z2-25-Rainfall/2
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.06 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.31]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.165]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.185]
end

to z2-50-Rainfall/3
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.37 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.41]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.03]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.016]
end

to z3-25-Rainfall/2
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.06 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.61]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.045]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.025]
end


to z3-50-Rainfall/3
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.37 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.82]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.06]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.033]
end

to wells-increase/3
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco - 3.04]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco - 15.66]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco - 12.28]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;,;ZONES

to z1-h
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 25]
end

to z2-h
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 16.5]
end


to z3-h
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 8.25]
end

to ISH-wetland
  ask patches with [ish = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.1 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.4]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.35]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.45]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;,,,RAINFALL
to ISH-Rainfall
  ask patches with [ish = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.08]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.63]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.58]
end


to z1-25-Rainfall
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.085]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.045]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.205]
end


to z1-50-Rainfall
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.17]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.095]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.41]
end


to z1-75-Rainfall
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.25]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.14]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.615]
end

to z1-100-Rainfall
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.34]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.19]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.82]
end

to z2-12-Rainfall
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.31]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.165]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.185]
end

to z2-25-Rainfall
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.62]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.33]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.37]
end

to z2-50-Rainfall
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.24]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.66]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.74]
end

to z3-12-Rainfall
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.615]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.045]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.025]
end


to z3-25-Rainfall
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.235]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.09]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.05]
end


to z3-50-Rainfall
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.12 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.475]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.18]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.10]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; WTP

to wtp-i
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 9.68 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 9.68 ]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 9.68 ]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.64]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.84]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.86]
end

to wtp-a
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 16.13 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 16.13]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 16.13]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.45]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.42]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 6.44]
end

to wtp-a2
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.68 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.68]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.68]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.37]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
end

to wtp-a3
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.785 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.785]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.785]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.805]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
end

to wtp-a-ss
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 13.745 ]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 13.745]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 13.745]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.375]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.66]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.675]
end

to wtp-a2-ss
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.285]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.285]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.285]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.615]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
end

to wtp-a3-ss
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.565]
  ask patches with [z2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.565]
  ask patches with [z3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.565]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.47]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  WETLANDS

to wetland-z1-25
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.013]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.007]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.17]
end

to wetland-z1-50
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.025]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.15]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.38]
end

to wetland-z1-75
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.05]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.025]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.765]
end

to wetland-z1
  ask patches with [z1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.1]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.45]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.5]
end

to wetland-z2-12
  ask patches with [z2 = 2 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.135]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.155]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.29]
end

to wetland-z2-25
  ask patches with [z2 = 2 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.275]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.29]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + .58]
end

to wetland-z2-50
  ask patches with [z2 = 2 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.55]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.55]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.15]
end

to wetland-z3-12
  ask patches with [z3 = 3 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.27]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.035]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.02]
end

to wetland-z3-25
  ask patches with [z3 = 3 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.54]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.07]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.04]
end

to wetland-z3-50
  ask patches with [z3 = 3 and socioeco <= 100 ] [set socioeco socioeco + 3.05]
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.095]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.14]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.125]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; WATER EXTRACTION

to wells-increase
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco - 9.212]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco - 47.07]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco - 36.845]
end

to lagoon
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.025]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.985]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 4.345]
end


to lagoon-z2
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.75]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 12.65]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 3.04]
end

to lagoon-z3
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.445]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 16.3]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 5.915]
end

to well
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
end

to well-z2
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
end

to well-z3
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.21]
end

to inyection
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.115]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.34]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.445]
end



to vegetation_low
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.44]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.17]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.87]
end

to vegetation_high
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.095]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.525]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.025]
end


to terracing_low
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.31]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.83]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.325]
end


to terracing_high
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.065]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.395]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.725]
end

to vegetationterracing_low
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.575]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.53]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 2.44]
end

to vegetationterracing_high
  ask patches with [aquifer1 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.125]
  ask patches with [aquifer2 = 1 and socioeco <= 100 ] [set socioeco socioeco + 0.685]
  ask patches with [aquifer3 = 1 and socioeco <= 100 ] [set socioeco socioeco + 1.335]
end


; TO WORK WITH NEIGHBOURS
to regeneration-10
if (z1 = 1) and (socioeco >= 25)
  [ask neighbors [set pcolor magenta]]
end



to regeneration-20
if ( pcolor = magenta) and (socioeco >= 25)
  [ask neighbors [set pcolor magenta]]
end


to regeneration-30
if ( pcolor = magenta) and (socioeco >= 25)
  [ask neighbors [set pcolor magenta]]
end





; TO STORE!
to store
  let patches_out nobody
  ask one-of patches [
    set patches_out gis:patch-dataset pcolor
  ]
  gis:store-dataset patches_out "R_E_Process_20y2.asc"
end
@#$#@#$#@
GRAPHICS-WINDOW
10
50
819
860
-1
-1
1.0
1
10
1
1
1
0
0
0
1
0
800
-800
0
1
1
1
ticks
30.0

BUTTON
2281
256
2695
290
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2281
329
2485
362
NIL
sample-aquifer1-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2281
293
2485
326
NIL
sample-socioeco-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
132
957
167
Zone 1
z1-h
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2281
437
2695
470
Store
store
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
55
1595
92
Evaluate
evaluate
NIL
1
T
PATCH
NIL
NIL
NIL
NIL
1

BUTTON
832
208
957
243
Regeneration 10
regeneration-10
NIL
1
T
PATCH
NIL
NIL
NIL
NIL
1

BUTTON
2280
365
2485
398
NIL
sample-aquifer2-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2281
401
2485
434
NIL
sample-aquifer3-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2488
293
2695
326
NIL
sample-ish-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2488
329
2695
362
NIL
sample-z1-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2488
365
2695
398
NIL
sample-z2-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2488
401
2695
434
NIL
sample-z3-with-patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
959
208
1084
243
Regeneration 20
regeneration-20
NIL
1
T
PATCH
NIL
NIL
NIL
NIL
1

BUTTON
1087
208
1212
243
Regeneration 30
regeneration-30
NIL
1
T
PATCH
NIL
NIL
NIL
NIL
1

BUTTON
2728
903
2791
936
NIL
z2-h\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2728
938
2791
971
NIL
z3-h
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
170
1339
205
Zone 1 - 25%
z1-25-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
208
1338
243
Zone 1 - 50%
z1-50-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
245
1338
280
Zone 1 - 75%
z1-75-Rainfall\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
283
1339
318
Zone 1 - 100%
z1-100-Rainfall\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
132
1466
166
Zone 2 - 12.5%
z2-12-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2631
745
2793
779
Zone 2 - 25% (Rainfall)
z2-25-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2631
712
2793
746
Zone 2 - 50% (Rainfall)
z2-50-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
132
1593
166
Zone 3 - 12.5%
z3-12-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2631
782
2793
816
Zone 3 - 25% (Rainfall)
z3-25-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2631
815
2793
849
Zone 3 - 50% (Rainfall)
z3-50-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2638
865
2708
898
NIL
wtp-i
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
435
1019
469
Conv. to Anaerobic WTP/ 2
wtp-a/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
473
1019
507
New Anaerobic Zone 2 
wtp-a2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
510
1019
544
New Anaerobic Zone 3
wtp-a3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1023
435
1210
469
Conv. to Anaerobic + SS / 2
wtp-a-ss/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1023
473
1210
507
New Anaerobic Zone 2+ SS
wtp-a2-ss
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1023
510
1210
544
New Anaerobic Zone 3 + SS
wtp-a3-ss
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
435
1339
470
Zone 1 - 25%
wetland-z1-25
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
473
1339
508
Zone 1 - 50%
wetland-z1-50
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
510
1339
545
Zone 1 - 75%
wetland-z1-75
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
548
1339
583
Zone 1 - 100%
wetland-z1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
399
1467
434
Zone 2 - 12.5%
wetland-z2-12
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
435
1467
470
Zone 2 - 25%
wetland-z2-25
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
473
1467
508
Zone 2 - 50%
wetland-z2-50
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
399
1594
434
Zone 3 - 12.5%
wetland-z3-12
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
435
1594
470
Zone 3 - 25%
wetland-z3-25
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
473
1594
508
Zone 3 - 50%
wetland-z3-50
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
833
853
1021
887
Extraction Wells/ 3
wells-increase/3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
663
1404
698
Artificial Lagoons
lagoon
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
700
1404
735
Artificial Lagoons (w/o Zone 2)
lagoon-z2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
738
1404
773
Artificial Lagoons (w/o Zone 3)
lagoon-z3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1407
663
1595
698
Infiltration Well
well
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1407
700
1595
735
Infiltration Well (w/o Zone 2)
well-z2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1407
738
1595
773
Infiltration Well (w/o Zone 3)
well-z3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1407
775
1595
810
Injection Well
inyection
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
663
1019
697
Vegetation Low
vegetation_low
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1022
663
1211
697
Vegetation High
vegetation_high
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
700
1019
734
Terracing Low
terracing_low
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1022
700
1211
734
Terracing High
terracing_high
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
738
1019
772
Veget. + Terrac. Low
vegetationterracing_low
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1022
738
1211
772
Veget. + Terrac. High
vegetationterracing_high
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
959
132
1084
167
Zone 2 / 2
z2-h/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1087
132
1212
167
Zone 3 / 3
z3-h/3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
170
1466
204
Zone 2 - 25% / 2
z2-25-Rainfall/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1342
209
1466
243
Zone 2 - 50% / 3
z2-50-Rainfall/3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
170
1593
204
Zone 3 - 25% / 2
z3-25-Rainfall/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
209
1594
243
Zone 3 - 50% / 3
z3-50-Rainfall/3
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1468
280
1592
315
ISH - Rainfall
ISH-Rainfall
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
399
1019
433
Improved WTPs / 2
wtp-i-10/2
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1469
547
1594
582
ISH - Wetlands
ISH-wetland
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
94
1594
128
Catchment of Rainfall
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
2261
533
2613
567
Treatment of Waste Water in Wetlands
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
625
1211
659
Landscape Changes
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
94
1212
129
Development of Social Housing
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
324
1595
359
Treatment of Wastewater in WTP and/or Wetlands
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
362
1019
396
WTP w/o Source Separation
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
362
1594
397
Wetlands w/ Source Separation
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
170
1212
205
Regeneration
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1214
625
1594
660
Development of lagoons and/or wells
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
832
589
1595
623
Increased runoff infiltration in/with
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
833
817
1596
851
Increased groundwater extraction with
j
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1023
362
1211
397
WTP w/ Source Separation
s
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model was built to test and demonstrate the functionality of the GIS NetLogo extension. It simulates raindrops flowing downhill over the Earth's surface.

## HOW IT WORKS

This model loads a raster file of surface elevation for a small area near Cincinnati, Ohio. It uses a combination of the `gis:convolve` primitive and simple NetLogo code to compute the slope (vertical angle) and aspect (horizontal angle) of the earth surface using the surface elevation data. Then it simulates raindrops flowing downhill over that surface by having turtles constantly reorient themselves in the direction of the aspect while moving forward at a constant rate.

## HOW TO USE IT

Press the setup button, then press the go button. You may press any of the "display-..." buttons at any time; they don't affect the functioning of the model.

## EXTENDING THE MODEL

It could be interesting to extend the model so that the "raindrop" turtles flow more quickly over steeper terrain. You could also add land cover information, and adjust the speed with which the turtles flow based on the land cover.

## RELATED MODELS

The other GIS code example, GIS General Examples, provides a greater variety of examples of how to use the GIS extension.

<!-- 2008 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
setup
repeat 20 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
