;extensions [table]
breed [rabbit rabbits]
breed [parents parent]
breed [trees tree]
breed [hawks hawk]
breed [offsprings offspring]
breed [wolves wolf]
breed [rabbit-holes rabbit-hole]
breed [carrots carrot]
breed [lakes lake]

globals[
  t1-mean
  t1-var
  t2-mean
  t2-var
  t3-mean
  t3-var
  t4-mean
  t4-var
]

parents-own[
  trait1-p
  trait2-p
  trait3-p
  trait4-p
  t1-parent
  t1-offspring
  t2-parent
  t2-offspring
  t3-parent
  t3-offspring
  t4-parent
  t4-offspring
]
offsprings-own [
  trait1-o
  trait2-o
  trait3-o
  trait4-o
]

to setup-population
  ca
  reset-ticks
  ask patches [; create unknown background
    set pcolor 4 - (random 3)
  ]
  create-parents 1000 [
    set trait1-p median (list 0 (random-normal 55 5) 100)
    set t1-parent median (list 30 (random-normal 55 5) 70)
    set t1-offspring (t1-parent * median (list 0 (random-normal .5 .02) 1))
    set trait2-p median (list 0 (random-normal 55 6) 100)
    set t2-parent median (list 30 (random-normal 55 5) 70)
    set t2-offspring (t2-parent * median (list 0 (random-normal .3 .02) 1))
    set trait3-p median (list 0 (random-normal 25 7) 100)
    set t3-parent median (list 0 (random-normal 25 7) 100)
    set t3-offspring (t3-parent * median (list 0 (random-normal .90 .02) 1))
    set trait4-p median (list 0 (random-normal 165 20) 260)
    set t4-parent median (list 0 (random-normal 165 20) 260)
    set t4-offspring (t4-parent * median (list 0 (random-normal .10 .02) 1))
    set shape "rabbit"
    setxy random-xcor random-ycor
    set color white

  ]
  set t1-mean "NA"
  set t1-var "NA"
  set t2-mean "NA"
  set t2-var "NA"
  set t3-mean "NA"
  set t3-var "NA"
  set t4-mean "NA"
  set t4-var "NA"
  tick
end

to setup-habitat
  ask trees [die]
  ask hawks [die]
  ask wolves [die]
  ask rabbit-holes [die]
  ask carrots [die]
  ask parents[
    set hidden? TRUE
  ]
  ask offsprings[
    set hidden? TRUE
  ]

  ask patches [; create grass
    set pcolor 61 + grass-color + (random-float 0.4167 * grass-patchiness)
  ]
  ask n-of water patches [set pcolor sky]
  create-rabbit-holes n-rabbit-holes[
    set shape "circle"
    set size .3
    setxy random-xcor random-ycor
    set color black
  ]
  create-wolves n-wolves[
    set shape "wolf"
    set size 2
    setxy random-xcor random-ycor
    set color 2
  ]

  create-trees n-trees[
    set shape "tree pine"
    set color 51
    setxy random-xcor random-ycor
    set size 3
  ]
  create-carrots n-carrots[
    set shape "carrot"
    setxy random-xcor random-ycor
    set size 1.5
  ]
  create-hawks n-hawks[
    set shape "hawk"
    set size 1.5
    setxy random-xcor random-ycor
    set color brown
  ]
end

to unhide-pop
  clear-output
  reset-ticks
  ask trees [die]
  ask hawks [die]
  ask wolves [die]
  ask offsprings [die]
  ask rabbit-holes [die]
  ask carrots [die]
  ask patches [; create unknown background
    set pcolor 4 - (random 3)
  ]
  ask parents [
    set hidden? FALSE
  ]
  tick

end

to setup-offspring

  setup-habitat
  reset-ticks
  tick
  ask offsprings [die]
  ask parents[
    set hidden? TRUE
  ]
  ask offsprings[
    set hidden? FALSE
  ]

  create-offsprings 1000 [

   ;if (grass-color = 2) [set trait1-o median (list 0 (random-normal (t1-mean) (sqrt(12.5 + (12.5 * ((0.5 * (grass-patchiness / 6)) +(0.5 * (n-carrots / 50))))))) 100)]
    set trait1-o median (list 0 (random-normal (59 - grass-color * 2) (sqrt(12.5 + (12.5 * ((0.5 * (grass-patchiness / 6)) +(0.5 * (n-carrots / 50))))))) 100)
    if (n-wolves = 0) and (n-hawks = 0) [set trait2-o median (list 0 (random-normal 55 6) 100)]
    if (n-wolves = 0) and (n-hawks != 0) [set trait2-o median (list 20 (random-normal (55 + (15 * (n-hawks / 20))) 5.25) 75)]
    if (n-wolves != 0) and (n-hawks = 0) [set trait2-o median (list 35 (random-normal (55 - (30 * (n-wolves / 20))) 5.25) 85)]
    ;if (n-wolves != 0) and (n-hawks != 0) [set trait2-o ifelse-value (random-float 1 < 0.5) [median (list 20 (random-normal (55 - (35 * (n-wolves / 20))) 5) 100)] [ median (list 0 (random-normal (55 + (10 * (n-hawks / 20))) 5) 85)]]
    if (n-wolves != 0) and (n-hawks != 0) [set trait2-o median (list (20 + (0.5 * n-hawks)) (random-normal (55 - ((1.5 * n-wolves)- (0.75 * n-hawks))) (6 - (3 * (((2 * n-wolves) + n-hawks) / 40)))) (85 - (1 * n-wolves)))]
    if (n-wolves = 10) and (n-hawks = 20) [set trait2-o median (list (20 + (0.5 * n-hawks)) (random-normal 55 (6 * ((n-wolves / 20) / (n-hawks / 20)))) (85 - (1 * n-wolves)))]
    ;set trait3-o median (list 0 (random-normal (20 + (15 * (n-rabbit-holes / 100))) 7) 100)
    set trait3-o ifelse-value (random-float 1 < 0.5) [median (list 0 (random-normal (25 - (10 * (2 * n-rabbit-holes / 100))) 5) 100)] [ median (list 0 (random-normal (25 + (10 * (2 * n-rabbit-holes / 100))) 5) 100)]
    set trait4-o median (list 0 (random-normal (100 + water) 20) 260)
    set shape "rabbit"
    setxy random-xcor random-ycor
    set color white
  ]
  ifelse (grass-color = 2) [set t1-mean mean [trait1-p] of parents] [set t1-mean mean [trait1-o] of offsprings]
  ifelse (grass-patchiness = 6) and (n-carrots = 50) [set t1-var variance [trait1-p] of parents] [set t1-var variance [trait1-o] of offsprings]
  ifelse (n-wolves = 0) and (n-hawks = 0) [set t2-mean mean [trait2-p] of parents set t2-var variance [trait2-p] of parents] [set t2-mean mean [trait2-o] of offsprings set t2-var variance [trait2-o] of offsprings]
  ifelse (n-rabbit-holes = 25) [set t3-mean mean [trait3-p] of parents set t3-var variance [trait3-p] of parents] [set t3-mean mean [trait3-o] of offsprings set t3-var variance [trait3-o] of offsprings]
  ifelse (water = 65) [set t4-mean mean [trait4-p] of parents set t4-var variance [trait4-p] of parents] [set t4-mean mean [trait4-o] of offsprings set t4-var variance [trait4-o] of offsprings]
tick
end
@#$#@#$#@
GRAPHICS-WINDOW
260
30
694
465
-1
-1
11.514
1
10
1
1
1
0
1
1
1
-18
18
-18
18
0
0
1
Generation
30.0

TEXTBOX
51
13
237
47
1) Setup Original Population
14
0.0
1

PLOT
710
30
1130
330
Frequency Distribution (Trait 1)
Size of trait
Individuals
35.0
75.0
0.0
100.0
true
true
"set-histogram-num-bars 100\n" "clear-plot"
PENS
"Original" 1.0 1 -16777216 true "" "histogram [trait1-p] of parents"
"Offspring" 1.0 1 -5825686 true "" "histogram [trait1-o] of offsprings"
"parent mean" 1.0 0 -7500403 false "" "carefully [plotxy mean [trait1-p] of parents 0][]\ncarefully [plotxy mean [trait1-p] of parents 185][]"
"offspring mean" 1.0 0 -3508570 false "" "carefully [plotxy mean [trait1-o] of offsprings 0][]\ncarefully [plotxy mean [trait1-o] of offsprings 185][]"

MONITOR
320
545
377
590
______
mean [trait1-p] of parents
2
1
11

MONITOR
396
545
453
590
______
variance [trait1-p] of parents
2
1
11

PLOT
15
875
365
1190
Parent-Offspring Regression (Trait 1)
Parent
Offspring
35.0
80.0
5.0
50.0
true
true
"\n" "clear-plot"
PENS
"" 1.0 2 -16777216 false "" "ask parents [plotxy t1-parent t1-offspring]"
"slope = 1" 1.0 0 -4539718 true "" "carefully [plotxy (median [t1-parent] of parents - 17) (median [t1-offspring] of parents - 17)][]\ncarefully [plotxy (median [t1-parent] of parents + 20) (median [t1-offspring] of parents + 20)][]"
"slope = 0.5" 1.0 0 -16777216 true "" "carefully [plotxy (median [t1-parent] of parents - 17) (median [t1-offspring] of parents - 8.5)][]\ncarefully [plotxy (median [t1-parent] of parents + 20) (median [t1-offspring] of parents + 10)][]"

BUTTON
50
40
217
73
Original Population Setup
setup-population
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
40
595
200
628
Preview Habitat
setup-habitat
NIL
1
T
OBSERVER
NIL
H
NIL
NIL
1

SLIDER
45
205
217
238
grass-color
grass-color
0
6
2.0
1
1
NIL
HORIZONTAL

BUTTON
40
640
112
706
Original
unhide-pop
NIL
1
T
OBSERVER
NIL
P
NIL
NIL
1

BUTTON
122
640
200
709
Offspring
setup-offspring
NIL
1
T
OBSERVER
NIL
O
NIL
NIL
1

TEXTBOX
30
151
248
179
___________________________________
11
0.0
1

PLOT
710
345
1130
645
Frequency Distribution (Trait 2)
Size of trait
Individuals
0.0
100.0
0.0
100.0
true
true
"set-histogram-num-bars 100" "clear-plot"
PENS
"Original" 2.0 1 -16777216 true "" "histogram [trait2-p] of parents"
"Offspring" 2.0 1 -955883 true "" "histogram [trait2-o] of offsprings"
"parent mean" 1.0 0 -7500403 false "" "carefully [plotxy mean [trait2-p] of parents 0][]\ncarefully [plotxy mean [trait2-p] of parents 185][]"
"offspring mean" 1.0 0 -817084 false "" "carefully [plotxy mean [trait2-o] of offsprings 0][]\ncarefully [plotxy mean [trait2-o] of offsprings 185][]"

PLOT
380
875
730
1190
Parent-Offspring Regression (Trait 2)
Parent
Offspring
35.0
80.0
0.0
40.0
true
true
"" "clear-plot"
PENS
"" 1.0 2 -16777216 false "" "ask parents [plotxy t2-parent t2-offspring]"
"slope = 1" 1.0 0 -7500403 true "" "carefully [plotxy (median [t2-parent] of parents - 12.5) (median [t2-offspring] of parents - 12.5)][]\ncarefully [plotxy (median [t2-parent] of parents + 20) (median [t2-offspring] of parents + 20)][]"
"slope = 0.3" 1.0 0 -16777216 true "" "carefully [plotxy (median [t2-parent] of parents - 17) (median [t2-offspring] of parents - 5.1)][]\ncarefully [plotxy (median [t2-parent] of parents + 20) (median [t2-offspring] of parents + 6)][]"

PLOT
1145
30
1565
330
Frequency Distribution (Trait 3)
Size of trait
Individuals
0.0
60.0
0.0
100.0
true
true
"set-histogram-num-bars 100" "clear-plot"
PENS
"Original" 1.0 1 -16777216 true "" "histogram [trait3-p] of parents"
"Offspring" 1.0 1 -13345367 true "" "histogram [trait3-o] of offsprings"
"Parent mean" 1.0 0 -7500403 false "" "carefully [plotxy mean [trait3-p] of parents 0][]\ncarefully [plotxy mean [trait3-p] of parents 185][]"
"offspring mean" 1.0 0 -10649926 false "" "carefully [plotxy mean [trait3-o] of offsprings 0][]\ncarefully [plotxy mean [trait3-o] of offsprings 185][]"

PLOT
745
875
1095
1190
Parent-Offspring Regression (Trait 3)
Parent
Offspring
0.0
50.0
0.0
50.0
false
true
"" "clear-plot"
PENS
"" 1.0 2 -16777216 false "" "ask parents [plotxy t3-parent t3-offspring]"
"slope = 1" 1.0 0 -7500403 true "" "carefully [plotxy (median [t3-parent] of parents - 25) (median [t3-offspring] of parents - 25)][]\ncarefully [plotxy (median [t3-parent] of parents + 25) (median [t3-offspring] of parents + 25)][]"
"slope = 0.90" 1.0 0 -16777216 true "" "carefully [plotxy (median [t3-parent] of parents - 25) (median [t3-offspring] of parents - 22.5)][]\ncarefully [plotxy (median [t3-parent] of parents + 25) (median [t3-offspring] of parents + 22.5)][]"

SLIDER
45
249
218
282
grass-patchiness
grass-patchiness
0
6
4.0
1
1
NIL
HORIZONTAL

TEXTBOX
32
80
266
151
This randomly creates a parent population. Once a population is set, it is not reccomended to reset the population as comparisons with the offspring population are dependent on this unique parent population
11
0.0
1

SLIDER
44
409
216
442
n-wolves
n-wolves
0
10
8.0
1
1
NIL
HORIZONTAL

SLIDER
45
290
218
323
n-rabbit-holes
n-rabbit-holes
0
100
35.0
5
1
NIL
HORIZONTAL

TEXTBOX
268
510
305
731
Trait\n\n\n1\n\n\n2\n\n\n3\n\n\n4
14
0.0
1

TEXTBOX
325
509
475
543
          Original\nMean         Variance
14
0.0
1

TEXTBOX
517
509
667
543
         Offspring\nMean         Variance
14
0.0
1

MONITOR
318
598
375
643
______
mean [trait2-p] of parents
2
1
11

MONITOR
318
648
375
693
______
mean [trait3-p] of parents
2
1
11

MONITOR
394
598
451
643
______
variance [trait2-p] of parents
2
1
11

MONITOR
394
648
451
693
______
variance [trait3-p] of parents
2
1
11

MONITOR
509
546
566
591
______
t1-mean
2
1
11

MONITOR
508
598
565
643
______
t2-mean
2
1
11

MONITOR
508
648
565
693
______
t3-mean
2
1
11

MONITOR
589
546
646
591
______
t1-var
2
1
11

MONITOR
588
598
645
643
______
t2-var
2
1
11

MONITOR
588
649
645
694
______
t3-var
2
1
11

SLIDER
45
330
217
363
n-carrots
n-carrots
0
50
35.0
5
1
NIL
HORIZONTAL

SLIDER
45
370
217
403
n-trees
n-trees
0
100
35.0
5
1
NIL
HORIZONTAL

SLIDER
44
448
216
481
n-hawks
n-hawks
0
20
5.0
1
1
NIL
HORIZONTAL

TEXTBOX
64
176
211
210
2) Habitat Parameters
14
0.0
1

TEXTBOX
62
565
212
583
3) View Populations
14
0.0
1

TEXTBOX
245
475
837
531
___________________________________________________________________________
11
0.0
1

TEXTBOX
243
753
713
809
___________________________________________________________________________
11
0.0
1

TEXTBOX
24
724
233
794
As you change habitat paramaters, you can view the populations before (original) and after (offspring) the habitat changes.
11
0.0
1

TEXTBOX
525
785
930
845
Parent-offspring regressions were conducted under parental habitat conditions and will not change as you experiment with habitat parameters.
15
0.0
1

SLIDER
45
490
217
523
water
water
0
100
100.0
5
1
NIL
HORIZONTAL

PLOT
1145
345
1565
645
Frequency Distribution (Trait 4)
Size of trait
Individuals
0.0
260.0
0.0
100.0
true
true
"set-histogram-num-bars 100" "clear-plot"
PENS
"Original" 5.0 1 -16777216 true "" "histogram [trait4-p] of parents"
"Offspring" 5.0 1 -10899396 true "" "histogram [trait4-o] of offsprings"
"parent mean" 1.0 0 -7500403 false "" "carefully [plotxy mean [trait4-p] of parents 0][]\ncarefully [plotxy mean [trait4-p] of parents 185][]"
"offspring mean" 1.0 0 -10899396 false "" "carefully [plotxy mean [trait4-o] of offsprings 0][]\ncarefully [plotxy mean [trait4-o] of offsprings 185][]"

MONITOR
318
698
373
743
______
mean [trait4-p] of parents
2
1
11

MONITOR
395
698
450
743
______
variance [trait4-p] of parents
2
1
11

MONITOR
508
698
565
743
______
t4-mean
2
1
11

MONITOR
588
698
645
743
______
t4-var
2
1
11

PLOT
1110
875
1460
1190
Parent-Offspring Regression (Trait 4)
Parent
Offspring
94.0
250.0
0.0
42.0
false
true
"" "clear-plot"
PENS
"" 1.0 2 -16777216 false "" "ask parents [plotxy t4-parent t4-offspring]"
"slope = 1" 1.0 0 -7500403 true "" "carefully [plotxy (median [t4-parent] of parents - 75) (median [t4-offspring] of parents - 75)][]\ncarefully [plotxy (median [t4-parent] of parents + 75) (median [t4-offspring] of parents + 75)][]"
"slope = 0.1" 1.0 0 -16777216 true "" "carefully [plotxy (median [t4-parent] of parents - 100) (median [t4-offspring] of parents - 10)][]\ncarefully [plotxy (median [t4-parent] of parents + 100) (median [t4-offspring] of parents + 10)][]"

@#$#@#$#@
# NetLogo - Quantitative Genetics Experiment

## WHAT IS IT?

This model examines the fundamentals of quantitative genetics in a population of wild rabbits. Using the various sliders, experiments can be conducted on this theoretical population. Parameters such as population mean, population variance, and narrow sense heritability are directly reported by this simulation. Other important parameters can then be derived from those values.


## HOW IT WORKS

An original population (with unknown environmental conditions) is generated in the beginning of the simulation. By adjusting habitat parameters, you can design experiments to test the relationships between the three traits, the original population, and the environment. As you run offspring populations under different habitat parameters, the graphs will automatically update indicating the population's response to selection. **Note:** you are not directly provided information about those individuals from the original population who are actally able breed (i.e., the breeders/selected parents).

## HOW TO USE IT

**Set up the original population.** By pressing the _"Original Population Setup"_ button, you will generate a population of rabbits. This will automatically generate the frequency distribution for three continuous traits. You will also notice that "Parent-Offspring Regressions" are also plotted for each of these three traits. **Tip:** Think about what the the parent-offspring regression tells you about heritibility and variance components.

**Change habitat parameters.** While the environment of the original population is unknown, you can directly manipulate the environment of the offspring population by adjusting the various habitat parameter sliders. 

**Preview the habitat.** The _"Preview Habitat"_ button allows the user to view the habitat the offspring population will be born into. 

**View the offspring population.** The _"Offspring"_ button randomly generate a habitat (based on the habitat parameters) and populates the offspring population. 

**Revisit the original population.** The _"Original"_ button clears the offspring population and allows you to revisit the same original population. The only way to change the original population is to select the _"Original Population Setup"_ button (not recommended as distributions may change). 

**Plots and population data** Plots will automatically update as you run simulations of the offspring population. You shouldn't expect the distribution of the original population to change, however each offspring simulation will be unique. To keep track of these simulations, you can copy/export the graphs or write down the means and variances of the three continuous traits.



## THINGS TO TRY

Try treating this simulation like a lab experiment. Take into consideration which variables you want to manipulate and which you will keep constant.

## THINGS TO NOTICE

There are random processes underlying each simulation. While the underlying structure will remain consistent, the habitat and offspring distribution will vary slightly for each simulation.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

carrot
true
0
Polygon -955883 true false 0 150 210 120 210 180 0 150
Polygon -10899396 true false 210 150
Polygon -10899396 true false 210 135 225 150 210 165 210 135 225 150 270 150 285 135 285 165 270 150 225 150 285 180 285 195 225 150 285 120 285 105 225 150 285 90 270 75 225 150 285 210 270 225 225 150 255 225 240 225 225 150 255 75 240 75 225 150
Polygon -10899396 true false 225 150 270 165 255 150 270 135 225 150
Polygon -10899396 true false 255 150 285 165 285 135 255 150

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hawk
true
0
Polygon -7500403 true true 151 170 136 170 123 229 143 244 156 244 179 229 166 170
Polygon -16777216 true false 152 154 137 154 125 213 140 229 159 229 179 214 167 154
Polygon -7500403 true true 151 140 136 140 126 202 139 214 159 214 176 200 166 140
Polygon -16777216 true false 151 125 134 124 128 188 140 198 161 197 174 188 166 125
Polygon -7500403 true true 152 86 227 72 286 97 272 101 294 117 276 118 287 131 270 131 278 141 264 138 267 145 228 150 153 147
Polygon -7500403 true true 160 74 159 61 149 54 130 53 139 62 133 81 127 113 129 149 134 177 150 206 168 179 172 147 169 111
Circle -16777216 true false 144 55 7
Polygon -16777216 true false 129 53 135 58 139 54
Polygon -7500403 true true 148 86 73 72 14 97 28 101 6 117 24 118 13 131 30 131 22 141 36 138 33 145 72 150 147 147

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

mouse top
true
0
Polygon -7500403 true true 144 238 153 255 168 260 196 257 214 241 237 234 248 243 237 260 199 278 154 282 133 276 109 270 90 273 83 283 98 279 120 282 156 293 200 287 235 273 256 254 261 238 252 226 232 221 211 228 194 238 183 246 168 246 163 232
Polygon -7500403 true true 120 78 116 62 127 35 139 16 150 4 160 16 173 33 183 60 180 80
Polygon -7500403 true true 119 75 179 75 195 105 190 166 193 215 165 240 135 240 106 213 110 165 105 105
Polygon -7500403 true true 167 69 184 68 193 64 199 65 202 74 194 82 185 79 171 80
Polygon -7500403 true true 133 69 116 68 107 64 101 65 98 74 106 82 115 79 129 80
Polygon -16777216 true false 163 28 171 32 173 40 169 45 166 47
Polygon -16777216 true false 137 28 129 32 127 40 131 45 134 47
Polygon -16777216 true false 150 6 143 14 156 14
Line -7500403 true 161 17 195 10
Line -7500403 true 160 22 187 20
Line -7500403 true 160 22 201 31
Line -7500403 true 140 22 99 31
Line -7500403 true 140 22 113 20
Line -7500403 true 139 17 105 10

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rabbit
false
0
Polygon -7500403 true true 61 150 76 180 91 195 103 214 91 240 76 255 61 270 76 270 106 255 132 209 151 210 181 210 211 240 196 255 181 255 166 247 151 255 166 270 211 270 241 255 240 210 270 225 285 165 256 135 226 105 166 90 91 105
Polygon -7500403 true true 75 164 94 104 70 82 45 89 19 104 4 149 19 164 37 162 59 153
Polygon -7500403 true true 64 98 96 87 138 26 130 15 97 36 54 86
Polygon -7500403 true true 49 89 57 47 78 4 89 20 70 88
Circle -16777216 true false 37 103 16
Line -16777216 false 44 150 104 150
Line -16777216 false 39 158 84 175
Line -16777216 false 29 159 57 195
Polygon -5825686 true false 0 150 15 165 15 150
Polygon -5825686 true false 76 90 97 47 130 32
Line -16777216 false 180 210 165 180
Line -16777216 false 165 180 180 165
Line -16777216 false 180 165 225 165
Line -16777216 false 180 210 210 240

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

tree pine
false
0
Rectangle -6459832 true false 120 225 180 300
Polygon -7500403 true true 150 240 240 270 150 135 60 270
Polygon -7500403 true true 150 75 75 210 150 195 225 210
Polygon -7500403 true true 150 7 90 157 150 142 210 157 150 7

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
