extensions [gis]
breed [people person]
breed [cars car]
breed [destinations destrination]
globals [ tt-dataset TS-dataset LC-dataset time km avspeed atraveltime atraveldist]
patches-own [LC TT TS METERS roads ]
turtles-own [state pausetime traveltime traveldist]

to setup
    __clear-all-and-reset-ticks
  set-default-shape turtles "circle"
  ask patches [set  meters 50]
  setup-patches
end
to go
      ask people [checkspeed]
      ask turtles [atpusk]
      ask cars [move-cars]
      if cars-go   [startcars ask people [atroad]]
      if not any? people [ stop ]
      tick
end
to atroad
     ifelse (any? cars-on neighbors or any? cars-here) [set state "lift"]
      [ if (lc = 201 or lc = 202 or lc = 203 and state != "waiting") [set state "wait"] ]
end
to checkspeed
  if (pausetime < 1 or state = "lift") [ move ]
  ifelse (state = "waiting") [set pausetime pausetime - 1]
  [if (state = "wait")[set pausetime (30) set state "waiting"] ]
  ifelse (state = "go") [set pausetime (ts / 2) set state "pause"] [if (state = "pause") [set pausetime pausetime - 1] ]
  if traveltime > 120 [set color red set size 8 ]
end

to move-cars
  if (pausetime < 1 ) [  move-to  min-one-of neighbors with [lc > 200] [tt]      set state "go" ]
  ifelse (state = "go") [set pausetime (ts / 2) set state "pause"] [if (state = "pause") [set pausetime pausetime - 1] ]
end

to move
    move-to  min-one-of neighbors [tt]
    ifelse (state = "waiting" and lc = 201 or lc = 202 or lc = 203) [set traveltime 1 + traveltime] [set traveltime ((TS / 60) + traveltime) ]
    ask one-of people [ set atraveltime (traveltime) ]
    ask one-of people [ set traveldist ((.05) + traveldist) set atraveldist traveldist]
    set state "go"
end

to atpusk
  if (tt < 1 )
  [die]
  if (count people < 1) [stop]
end
to reset
  set km 0
  set avspeed .00001
  set time .01
end
to startcars
  let gocar random (200 - (traffic * 1.8))
   if gocar = 1 [
   ask n-of (random 8) patches with [LC = 201 and not any? other turtles-here][sprout-cars 1 [set shape "car" set color red set size 12 ]]
   ask n-of (random 3) patches with [LC = 202 and not any? other turtles-here][sprout-cars 1 [set shape "car" set color blue set size 12 ]]
   ask n-of (1) patches with [LC = 203 and not any? other turtles-here][sprout-cars 1 [set shape "car" set color green set size 12 ]]]
end
to  setup-patches
  set km 0
  set time 1
  import-pcolors-rgb "LandCover_png.png"
  set tt-dataset gis:load-dataset "Travel_time.asc"
  set TS-dataset gis:load-dataset "Travel_speed.asc"
  set LC-dataset gis:load-dataset "Landcover.asc"
  gis:apply-raster tt-dataset tt
  gis:apply-raster TS-dataset TS
  gis:apply-raster LC-dataset LC
  gis:set-world-envelope (gis:envelope-of LC-dataset)
  ask patches [ifelse (lc <= 0) or (lc >= 0) [set lc lc] [set lc 0]]
    ask patches [ifelse (tt <= 0) or (tt >= 0) [set tt tt] [set tt 0]]
ask patches with [ tt = 0 ] [sprout-destinations 1 [set shape "circle 2" set color yellow set size 12 ]]
end

To view-new
  if View = "Land Cover" [import-pcolors-rgb "LandCover_png.png"]
  if view = "Travel Time"  [ ask patches [ set pcolor scale-color red tt 500 0 ]]
  if view = "Land Cover2"  [ ask patches [ set pcolor scale-color blue LC 203 1]]
   if view = "Travel Time" [ ask patches with [ tt = 0 ] [sprout-destinations 1 [set color yellow set size 5 ]]]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
821
642
300
300
0.6
1
10
1
1
1
0
0
0
1
-300
300
-300
300
1
1
1
ticks
30.0

BUTTON
24
42
91
75
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
116
85
179
118
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
20
270
102
315
Travel Time
atraveltime
0
1
11

MONITOR
21
219
101
264
Distance KM
atraveldist
2
1
11

MONITOR
109
218
193
263
Average Speed
atraveldist / ((atraveltime) / 60 )
1
1
11

BUTTON
97
43
160
76
reset
reset reset-ticks clear-turtles
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
109
270
194
315
NIL
count people
17
1
11

BUTTON
23
83
111
116
Place person
 if (mouse-down?)\n    [ ask patch mouse-xcor mouse-ycor\n      [ if not any? turtles-here [ sprout-people 1 [set shape \"face sad\" set color yellow set size 15 set time 0 set state \"go\"]]]  display]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
23
126
115
159
cars-go
cars-go
0
1
-1000

CHOOSER
19
329
111
374
view
view
"Land Cover" "Travel Time" "Land Cover2"
1

BUTTON
20
379
105
412
NIL
view-new
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
23
170
115
203
traffic
traffic
0
100
52
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

Proximity to health services has been shown to be a key factor determining outcomes for a range of public health issues. Modelling travel time to health care using GIS has become a common of planning tool for identify populations remote from health services and to support better transport and infrastructure planning.   This model has two primary purposes. The first is to allow the placement of individuals to 'game' particular travel time scenarios. The second is to integrate travel on a transport network. In this case adding cars on roads to simulate the variable and random nature of car traffic simulating the time it may take to get a lift once a road is reached.

This is significant as most raster based models assume a constant travel time based on surface parameters alone. Whilst network models do not account for off network travel. This model integrates both off-network and network transport.

## HOW IT WORKS

The model uses GIS derived base grid data-sets that model travel time to health services with each cell atibuted the ammountof time it will take to a health service. This has been modelled in a GIS (SAGA-GIS) based on a hypothetical potential travel speed over various land cover and transport infrastructure types.

People (agents) placed into the model travel to the surrounding cell with the smallest travel time value value and so 'flow' towards the destination. However if the 'cars-go' variable is activated when a  person reaches a road value it continues to move at a walking speed untill a car arrives. It then takes a 'lift' with the car to the closest destination point 'health facility'. If an agent is traveling for more than two hours it turns red indicating that it is in a critical condition.


## HOW TO USE IT

Initiate the model with 'setup' then place a person some where in the landscape.
Press go to set the agent moving. A model can be reset at any time using the reset button (faster than set-up).

Destination points appear as black circles.

The default land cover display is:

Primary Road:       Red
Secondary Road:     Orange
Rivers:             Blue
Forest:             Green
Scrub:              Olive
Grass:              Light yellow

To have cars in the model turn 'cars-go' on. To change the number of car on the road network change the traffic slider from 1 (dead of night) to 100 (rush hour).

To view the underlying travel time grid select 'Travel-Time' on the view chooser box and press the view-new button.


## THINGS TO NOTICE
The difference in patient travel time with and without the car network model.


## THINGS TO TRY

Change the number of cars based on a late night or rush-hour senario.
Try running the model with and without the cars from the same position.

## EXTENDING THE MODEL

Different transport types could be included (Abulance, Bus, Truck, Motor bike.) that could move more or less on different road types and/or have different destination points.

There could be multiple underlying travel grids based on different environmental conditions.


## CREDITS AND REFERENCES

Credit Rohan Fisher, research institute for environment and livelihoods, Charles Darwin University
Rohan.fisher@cdu.edu.au

## COPYRIGHT AND LICENSE

Copyright 2016 Rohan Fisher.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
