globals [ ]

turtles-own [age]

breed [guppies guppy]
breed [weeds weed]
breed [pebbles pebble]
breed [predators predator]


to-report brightest-guppy
  report max [color] of guppies-here
end

;;;;;;;;;;;;;;;;;;;;;;;;
to setup
 set-default-shape weeds "weed"
 set-default-shape pebbles "pebble"
 set-default-shape predators "predator"
 ca
  setup-bk
 setup-weed random 3
 setup-pebble 100
 set-guppies
 reset-ticks

end

to set-guppies
  set-brightest-guppies
  set-bright-guppies
  set-drab-guppies
  set-drabbest-guppies
end

to set-brightest-guppies
 create-guppies Initial-number-of-fish * ( 1 - bright-drab-ratio) * 0.5
  [set size 10
   set color 10.5 + random-float 2.25
   set-shape
   set age random 6
   set-position
    if any? other guppies-on patch-here [set-position] ]
end

to set-bright-guppies
  create-guppies Initial-number-of-fish * ( 1 - bright-drab-ratio) * 0.5
  [set size 8
   set color 12.75 + random-float 2.25
   set-shape
   set age random 6
   set-position
    if any? other guppies-on patch-here [set-position] ]
end

to set-drab-guppies
  create-guppies Initial-number-of-fish * bright-drab-ratio * 0.5
  [set size 8
   set color 15 + random-float 2.25
   set-shape
   set age random 6
   set-position
    if any? other guppies-on patch-here [set-position] ]
end

to set-drabbest-guppies
 create-guppies Initial-number-of-fish * bright-drab-ratio * 0.5
  [set size 8
   set color 17.25 + random-float 2
   set-shape
   set age random 6
   set-position
    if any? other guppies-on patch-here [set-position] ]
end

to set-shape
   if color >= 17.25 [set shape "guppy-drabbest"]
   if color < 17.25 and color >=  15 [set shape "guppy-drab"]
   if color < 15 and color >=  12.75 [set shape "guppy-bright"]
   if color < 12.75 [set shape "guppy-brightest"]
end

to set-position
  setxy random-xcor random-ycor
end

to setup-pebble [number]
create-pebbles number
 [set color 32 + random-float 6
    set size 4
    setxy min-pxcor + random (abs min-pxcor * 2) min-pycor + random 5]
end

to setup-weed [number]
 create-weeds 1 + number
  [set color 61.5 + random-float 2
    if color = pcolor [ifelse random 2 = 0 [set color pcolor + 0.5][set color pcolor - 0.5]]
    set size 30
    setxy random-xcor  min-pxcor + 20 + random 3]
end

to setup-bk
  ask patches
  [set pcolor 74.75]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go

 if ticks >= months * 10 [user-message "The trial has reached the defined time. Click 'setup' to restart the experiment or incease the time to extend the trial." stop]
 if count guppies = 0 [user-message "All guppies die." stop]

    swim
  grow
    Habitation
    death
    over-population

   tick
end


to grow
  ask guppies
  [set age age + 0.5
  if size < 8 [set size size + 0.5]]
end

to swim
  ask guppies [ifelse any? other guppies-on patch-ahead 1 [rt random 360]
                            [ifelse random 10 = 0 [rt random 30 lt random 30 ifelse any? other guppies-on patch-ahead 1 [swim][fd 2 ]]
                                                    [fd 0.5 ]]]
end

to habitation
  if Habitat = "Habitat 1"
  [
    survive-H
    reproduce
    ]

  if Habitat = "Habitat 2"
  [
    reproduce]

  if Habitat = "Habitat 3"
  [
    survive-L
    reproduce
    ]
end

to survive-H
  ask guppies [
    if random-float 2750 < abs (color - 19.5) ^ 2 [die]
  ]
end

to survive-L
  ask guppies [
    if random-float 500 < abs (color - 19.5) ^ 2 [die]
  ]
end

to preying
  rt random 30 lt random 30 fd 1
  if random 500 = 0[
  let prey one-of guppies with-max [color]
  if prey != nobody
   [ask prey [die]]]
end

to reproduce
 ask guppies with [age >= 4 and size >=  8]
 [ if color >= 17.25 [if random 60 < abs (color - 20) [hatch-baby 1]]
   if color < 17.25 and color >=  15 [if random 72 < abs (color - 20) [hatch-baby 1]]
   if color < 15 and color >=  12.75 [if random 90 < abs (color - 20) [hatch-baby 1]]
   if color < 12.75 [if random 100 < abs (color - 20) [hatch-baby 1]]
 ]
end


to hatch-baby [number]
  hatch-guppies number [
                   set age 0
                   set size 4
                   set-position
    ifelse random-float 100 < 5
        [ifelse random 2 = 0 [set color color + random-float mutate-range][set color color - random-float mutate-range]]
                                [set color color]
                                if color > 19.5 [set color 19]
                                if color < 10.5 [set color 11]
                                set-shape
  ]
  end


to death
  ask guppies [if age >= 20 [die]]
end

to over-population
ask guppies[  if count guppies > Habitat_Capacity [if random 2 = 0 [die]]]
end
@#$#@#$#@
GRAPHICS-WINDOW
508
10
971
474
-1
-1
5.0
1
10
1
1
1
0
1
1
1
-45
45
-45
45
0
0
0
ticks
30.0

BUTTON
9
125
130
158
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
130
125
251
158
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

CHOOSER
10
10
143
55
Habitat
Habitat
"Habitat 1" "Habitat 2" "Habitat 3"
0

SLIDER
148
10
323
43
Initial-number-of-fish
Initial-number-of-fish
0
60
40.0
1
1
NIL
HORIZONTAL

PLOT
9
209
495
457
Coloration Distribution of Male Guppies
color
# of male guppies
10.5
19.5
0.0
10.0
true
false
"" ""
PENS
"default" 0.2 1 -15302303 true "" "histogram [color] of guppies"

MONITOR
150
456
264
493
Intermediate (Brighter)
count guppies with [color >= 12.75 and color < 15]
2
1
9

MONITOR
264
456
379
493
Intermediate (Drabber)
count guppies with [color >= 15 and color < 17.25]
2
1
9

SLIDER
148
45
367
78
Bright-drab-Ratio
Bright-drab-Ratio
0.1
0.9
0.5
0.1
1
NIL
HORIZONTAL

TEXTBOX
113
81
405
104
                     <--Brighter|       |Drabber-->
11
0.0
1

MONITOR
9
164
206
209
Total number of Male Guppies
count guppies
1
1
11

MONITOR
345
164
454
209
Months
ticks / 10
0
1
11

TEXTBOX
30
440
66
458
Bright
11
0.0
0

TEXTBOX
460
439
488
457
Drab
11
0.0
0

MONITOR
34
456
150
493
Brightest
Count guppies with [color < 12.75]
2
1
9

MONITOR
378
456
488
493
Drabbest
count guppies with [color > 17.25]
2
1
9

SLIDER
368
45
483
78
mutate-range
mutate-range
1
7
2.0
1
1
NIL
HORIZONTAL

MONITOR
206
164
345
209
Average male coloration
mean [color] of guppies
2
1
11

BUTTON
250
125
375
158
Run by clicking
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

INPUTBOX
10
57
143
117
Months
24.0
1
0
Number

SLIDER
324
10
483
43
Habitat_Capacity
Habitat_Capacity
100
500
250.0
50
1
NIL
HORIZONTAL

@#$#@#$#@
## WHTAT IS IT

In this model you will investigate guppy coloration patterns in various habitats and infer the underlying selection mechanisms.


## CREDITS AND REFERENCES

This model is made by Dr. Lin Xiang at the University of Kentucky. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2015). Selection in Guppies. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish-3
true
0
Polygon -7500403 true true 151 21 135 30 120 60 105 105 105 135 150 269 195 135 195 105 180 60 165 30 151 22
Polygon -1 true false 195 105 210 165 195 135
Polygon -1 true false 105 105 90 165 105 135
Polygon -1 true false 150 211 111 294 142 270 154 281 150 211
Polygon -6459832 true false 148 83 148 68 176 77 148 82
Polygon -6459832 true false 152 83 152 68 124 77 152 82
Polygon -6459832 true false 150 116 150 101 182 109 150 115
Polygon -6459832 true false 150 115 150 101 119 110 149 114
Polygon -6459832 true false 150 145 150 130 181 139 150 144
Polygon -6459832 true false 151 145 151 130 120 139 151 144
Polygon -6459832 true false 149 172 150 160 171 167 149 172
Polygon -6459832 true false 151 172 150 160 129 167 151 172
Polygon -16777216 true false 151 66 140 198 150 164

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

guppy-1
true
0
Polygon -16777216 true false 147 0 162 15 177 60 177 120 162 180 155 210 188 240 205 280 162 300 132 300 96 279 117 240 132 210 132 180 125 135 109 108 111 63 132 15
Polygon -7500403 true true 150 0 165 15 180 60 180 120 165 180 158 210 191 240 208 280 165 300 135 300 99 279 120 240 135 210 135 180 128 135 112 108 114 63 135 15
Polygon -7500403 true true 178 123 195 150 194 174 180 180 166 173
Polygon -7500403 true true 129 133 103 160 107 175 115 179 135 180
Circle -16777216 true false 147 13 10
Circle -7500403 true true 148 161 18
Circle -2674135 true false 141 225 36
Circle -7500403 true true 114 262 26
Polygon -14835848 true false 164 69 169 113 164 133 165 165 180 121 180 75
Circle -7500403 true true 115 56 30
Polygon -11221820 true false 156 36 159 50 163 65 179 72 179 60 166 22
Circle -7500403 true true 156 272 18
Circle -7500403 true true 138 103 22
Circle -2674135 true false 134 143 12
Circle -7500403 true true 192 271 10
Polygon -11221820 true false 113 89 113 109 128 135 134 164 133 129 131 103

guppy-2
true
0
Polygon -16777216 true false 147 0 162 15 177 60 177 120 162 180 155 210 188 240 205 280 162 300 132 300 96 279 117 240 132 210 132 180 125 135 109 108 111 63 132 15
Polygon -7500403 true true 150 0 165 15 180 60 180 120 165 180 158 210 191 240 208 280 165 300 135 300 99 279 120 240 135 210 135 180 128 135 112 108 114 63 135 15
Polygon -7500403 true true 178 123 195 150 194 174 180 180 166 173
Polygon -7500403 true true 129 133 103 160 107 175 115 179 135 180
Circle -16777216 true false 147 13 10
Circle -7500403 true true 148 161 18
Circle -2674135 true false 141 225 36
Circle -7500403 true true 114 262 26
Polygon -14835848 true false 164 69 169 113 164 133 165 165 180 121 180 75
Circle -955883 true false 115 56 30
Polygon -11221820 true false 156 36 159 50 163 65 179 72 179 60 166 22
Circle -7500403 true true 156 272 18
Circle -7500403 true true 138 103 22
Circle -2674135 true false 134 143 12
Circle -2674135 true false 192 271 10
Polygon -11221820 true false 113 89 113 109 128 135 134 164 133 129 131 103

guppy-3
true
0
Polygon -16777216 true false 147 0 162 15 177 60 177 120 162 180 155 210 188 240 205 280 162 300 132 300 96 279 117 240 132 210 132 180 125 135 109 108 111 63 132 15
Polygon -7500403 true true 150 0 165 15 180 60 180 120 165 180 158 210 191 240 208 280 165 300 135 300 99 279 120 240 135 210 135 180 128 135 112 108 114 63 135 15
Polygon -7500403 true true 178 123 195 150 194 174 180 180 166 173
Polygon -7500403 true true 129 133 103 160 107 175 115 179 135 180
Circle -16777216 true false 147 13 10
Circle -7500403 true true 148 161 18
Circle -2674135 true false 141 225 36
Circle -7500403 true true 114 262 26
Polygon -14835848 true false 164 69 169 113 164 133 165 165 180 121 180 75
Circle -955883 true false 115 56 30
Polygon -11221820 true false 156 36 159 50 163 65 179 72 179 60 166 22
Circle -955883 true false 156 272 18
Circle -2674135 true false 138 103 22
Circle -2674135 true false 134 143 12
Circle -2674135 true false 192 271 10
Polygon -11221820 true false 113 89 113 109 128 135 134 164 133 129 131 103

guppy-4
true
0
Polygon -16777216 true false 147 0 162 15 177 60 177 120 162 180 155 210 188 240 205 280 162 300 132 300 96 279 117 240 132 210 132 180 125 135 109 108 111 63 132 15
Polygon -7500403 true true 150 0 165 15 180 60 180 120 165 180 158 210 191 240 208 280 165 300 135 300 99 279 120 240 135 210 135 180 128 135 112 108 114 63 135 15
Polygon -7500403 true true 178 123 195 150 194 174 180 180 166 173
Polygon -955883 true false 129 133 103 160 107 175 115 179 135 180
Circle -16777216 true false 147 13 10
Circle -955883 true false 148 161 18
Circle -2674135 true false 141 225 36
Circle -955883 true false 114 262 26
Polygon -14835848 true false 164 69 169 113 164 133 165 165 180 121 180 75
Circle -955883 true false 115 56 30
Polygon -11221820 true false 156 36 159 50 163 65 179 72 179 60 166 22
Circle -955883 true false 156 272 18
Circle -2674135 true false 138 103 22
Circle -2674135 true false 134 143 12
Circle -2674135 true false 192 271 10
Polygon -11221820 true false 113 89 113 109 128 135 134 164 133 129 131 103

guppy-5
true
0
Polygon -16777216 true false 147 0 162 15 177 60 177 120 162 180 155 210 188 240 205 280 162 300 132 300 96 279 117 240 132 210 132 180 125 135 109 108 111 63 132 15
Polygon -7500403 true true 150 0 165 15 180 60 180 120 165 180 158 210 191 240 208 280 165 300 135 300 99 279 120 240 135 210 135 180 128 135 112 108 114 63 135 15
Polygon -2674135 true false 178 123 195 150 194 174 180 180 166 173
Polygon -955883 true false 129 133 103 160 107 175 115 179 135 180
Circle -16777216 true false 147 13 10
Circle -955883 true false 148 161 18
Circle -2674135 true false 141 225 36
Circle -955883 true false 114 262 26
Polygon -14835848 true false 164 69 169 113 164 133 165 165 180 121 180 75
Circle -955883 true false 115 56 30
Polygon -11221820 true false 156 36 159 50 163 65 179 72 179 60 166 22
Circle -955883 true false 156 272 18
Circle -2674135 true false 138 103 22
Circle -2674135 true false 134 143 12
Circle -2674135 true false 192 271 10
Polygon -11221820 true false 113 89 113 109 128 135 134 164 133 129 131 103

guppy-body
true
0
Polygon -7500403 true true 158 0 164 11 181 92 181 118 198 122 195 152 178 139 162 216 194 251 205 283 179 296 162 290 149 296 132 288 119 296 92 283 104 251 137 216 134 176 133 151 119 156 102 162 108 146 119 131 130 115 125 85 126 44 138 9
Circle -16777216 true false 146 8 12
Polygon -7500403 true true 168 40 176 90
Polygon -10899396 true false 168 39 178 90 179 120 174 142 166 114 165 90

guppy-bright
false
0
Polygon -13345367 true false 2 142 13 136 94 119 120 119 124 102 154 105 141 122 218 138 253 106 285 95 298 121 292 138 298 151 290 168 298 181 285 208 253 196 218 163 178 166 153 167 158 181 164 198 148 192 133 181 117 170 87 175 46 174 11 162
Circle -16777216 true false 8 142 12
Circle -13840069 true false 217 132 34
Circle -2674135 true false 217 139 20
Circle -2674135 true false 254 111 24
Circle -955883 true false 274 160 12
Polygon -7500403 true true 40 132 90 124
Polygon -955883 true false 34 139 86 126 115 128 128 130 120 143 58 145
Polygon -955883 true false 140 133 134 149 156 156 186 152 203 143 171 136 149 129
Circle -16777216 true false 78 163 10
Circle -16777216 true false 93 163 6

guppy-brightest
false
0
Polygon -8630108 true false 2 143 13 137 94 120 120 120 124 103 154 106 141 123 172 135 199 85 284 75 254 96 265 117 258 142 270 166 260 187 300 225 212 207 187 182 170 160 153 168 158 182 164 199 148 193 133 182 117 171 87 176 46 175 11 163
Polygon -955883 true false 62 139 56 151 72 160 87 161 127 158 163 136 148 128 119 137 80 137
Circle -16777216 true false 8 142 12
Circle -1184463 true false 173 129 34
Circle -2674135 true false 175 136 20
Circle -2674135 true false 205 94 30
Circle -2674135 true false 216 163 22
Circle -955883 true false 229 137 16
Polygon -7500403 true true 40 132 90 124
Circle -2674135 true false 63 142 12
Circle -2674135 true false 130 141 20
Circle -2674135 true false 86 142 10
Polygon -16777216 true false 47 131 115 130 139 127 133 135 119 139 63 139
Polygon -955883 true false 39 132 90 122 120 121 142 126 114 134 90 135

guppy-drab
false
0
Polygon -13791810 true false 0 142 11 136 92 119 118 119 122 102 152 105 139 122 216 138 251 106 283 95 296 121 290 138 296 151 288 168 296 181 283 208 251 196 216 163 176 166 151 167 156 181 162 198 146 192 131 181 115 170 85 175 44 174 9 162
Circle -16777216 true false 8 142 12
Circle -10899396 true false 248 120 28
Circle -2064490 true false 266 172 14
Polygon -7500403 true true 40 132 90 124
Polygon -10899396 true false 39 132 90 122 120 121 142 126 114 134 90 135

guppy-drabbest
false
15
Polygon -14835848 true false 0 142 11 136 92 119 118 119 122 102 152 105 139 122 216 138 251 106 283 95 296 121 290 138 296 151 288 168 296 181 283 208 251 196 216 163 176 166 151 167 156 181 162 198 146 192 131 181 115 170 85 175 44 174 9 162
Circle -16777216 true false 8 142 12
Polygon -7500403 true false 40 132 90 124
Polygon -10899396 true false 39 132 90 122 120 121 142 126 114 134 90 135
Circle -13791810 true false 246 121 24

guppy-intermediate
true
0
Polygon -11221820 true false 142 0 136 11 119 92 119 118 102 122 105 152 122 139 138 216 106 251 95 283 121 296 138 290 151 296 168 288 181 296 208 283 196 251 163 216 166 176 167 151 181 156 198 162 192 146 181 131 170 115 175 85 174 44 162 9
Circle -16777216 true false 142 8 12
Circle -1184463 true false 132 217 34
Circle -955883 true false 139 217 20
Circle -2674135 true false 111 254 24
Circle -955883 true false 160 274 12
Polygon -7500403 true true 132 40 124 90
Polygon -10899396 true false 132 39 122 90 121 120 126 142 134 114 135 90

guppy-medium
true
0
Polygon -11221820 true false 142 0 136 11 119 92 119 118 102 122 105 152 122 139 138 216 106 251 95 283 121 296 138 290 151 296 168 288 181 296 208 283 196 251 163 216 166 176 167 151 181 156 198 162 192 146 181 131 170 115 175 85 174 44 162 9
Circle -16777216 true false 142 8 12
Circle -1184463 true false 132 217 34
Circle -955883 true false 139 217 20
Circle -10899396 true false 113 262 18
Circle -2064490 true false 173 267 12
Polygon -7500403 true true 132 40 124 90
Polygon -14835848 true false 132 39 122 90 121 120 126 142 134 114 135 90

guppy-spot
true
0
Circle -1184463 true false 134 217 34
Circle -7500403 true true 141 217 20
Circle -7500403 true true 165 254 24
Circle -7500403 true true 110 254 26
Circle -7500403 true true 143 274 12
Polygon -7500403 true true 168 40 176 90

guppy-tail
true
0
Polygon -11221820 true false 142 0 136 11 119 92 119 118 102 122 105 152 122 139 138 216 106 251 95 283 121 296 138 290 151 296 168 288 181 296 208 283 196 251 163 216 166 176 167 151 181 156 198 162 192 146 181 131 170 115 175 85 174 44 162 9
Circle -16777216 true false 142 8 12
Circle -1184463 true false 132 217 34
Circle -7500403 true true 139 217 20
Circle -7500403 true true 111 254 24
Circle -7500403 true true 164 254 26
Circle -7500403 true true 145 274 12
Polygon -7500403 true true 132 40 124 90
Polygon -14835848 true false 132 39 122 90 121 120 126 142 134 114 135 90

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pebble
false
0
Polygon -7500403 true true 45 150 30 135 30 105 45 90 75 75 105 60 165 45 210 45 240 60 270 90 285 120 285 135 255 165 210 180 150 180 90 165

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

predator
true
0
Polygon -7500403 true true 144 4 132 1 118 59 113 107 89 125 106 145 116 132 123 189 107 203 101 232 107 277 133 246 134 226 143 250 149 264 138 298 154 293 195 296 209 286 179 256 179 241 219 265 201 206 179 174 181 131 178 86 166 46 153 20
Line -16777216 false 141 93 131 82
Polygon -8630108 true false 135 4 158 64 156 88 143 92 146 72 141 40
Line -16777216 false 158 87 143 92
Circle -16777216 true false 136 25 12
Polygon -8630108 true false 132 225 131 242 119 204 107 207 123 193 129 211
Polygon -8630108 true false 178 178 198 207 202 224 186 200 178 238 178 200
Circle -8630108 false false 151 178 14
Circle -8630108 false false 159 210 8

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

weed
false
0
Polygon -7500403 true true 150 300 240 255 270 195 285 135 225 195 210 225 195 255
Polygon -7500403 true true 165 60 195 105 195 135 195 180 180 210 195 240 150 300 180 240 165 195 165 165 165 135 180 105
Polygon -7500403 true true 30 165 60 255 120 285 150 300 105 255 75 195
Polygon -7500403 true true 150 0 105 60 120 105 105 150 120 195 105 240 150 300 135 240 150 195 135 150 150 105 135 60

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
