; add model procedures here
globals [rat atp total_atp nad total_nad time]

to setup
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
set total_atp [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
set total_nad [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
ask patches with [(pxcor = (-1 * max-pxcor))] [set pcolor white] 
ask patches with [(pxcor = max-pxcor)] [set pcolor white]
ask patches with [(pycor = (-1 * max-pycor))] [set pcolor white]
ask patches with [(pycor = max-pycor)] [set pcolor white]
ask patches with [pycor = 0] [set pcolor white]

ask patches with [(pycor = 0) and (pxcor = -16)] [set pcolor blue] ;FeS1
ask patches with [(pycor = 0) and (pxcor = -14)] [set pcolor red] ;CytA
ask patches with [(pycor = 0) and (pxcor = -12)] [set pcolor blue] ;FeS2
ask patches with [(pycor = 0) and (pxcor = -10)] [set pcolor red] ;CytA
ask patches with [(pycor = 0) and (pxcor = -8)] [set pcolor blue] ;CytA
ask patches with [(pycor = 0) and (pxcor = -6)] [set pcolor red] ;CytA
ask patches with [(pycor = 0) and (pxcor = -4)] [set pcolor blue] ;CytA
ask patches with [(pycor = 0) and (pxcor = -2)] [set pcolor red] ;CytA

ask patches with [(pycor = 0) and (pxcor = 16)] [set pcolor blue] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 14)] [set pcolor red] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 12)] [set pcolor blue] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 10)] [set pcolor red] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 8)] [set pcolor blue] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 6)] [set pcolor red] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 4)] [set pcolor blue] ;ATP Synthase
ask patches with [(pycor = 0) and (pxcor = 2)] [set pcolor red] ;ATP Synthase

crt 100 [set shape "circle" set size 1 set color yellow set heading random 360 fd random 10]

end

to go 
let nad_cnt 0
  let atp_cnt 0
  
set nad_cnt 0
set atp_cnt 0
set rat count turtles with [ycor > 0]
ask turtles [

  fd 1
  rt random 60 
  lt random 60 
  if ([pcolor] of patch-at dx dy = white) and (NOT uncouplers) [set heading heading - 180]
  if ([pcolor] of patch-at dx dy = blue) [if (heading >= 270 or heading < 90 ) [ifelse (NOT poison_et) and (random 90 > rat) and (50 - nad > 0) [fd 2 set nad nad + 1 set nad_cnt nad_cnt + 1] [set heading heading - 180] ] ]
  if ([pcolor] of patch-at dx dy = blue) [if (heading  >= 90 and heading < 270 ) [set heading heading - 180]]
  if ([pcolor] of patch-at dx dy = red)  [if (heading  >= 90 and heading < 270 )  [ifelse (NOT poison_as) and (rat > 60 ) and (50 - atp > 0)[ fd 2  if (atp < 50) [set atp atp + 1 set atp_cnt atp_cnt + 1]] [set heading heading - 180] ] ]
  if ([pcolor] of patch-at dx dy = red)  [if (heading >= 270 or heading < 90) [set heading heading - 180]]
  ]
  if (random 200 < atp_consumption) and (atp > 1) [set atp atp - 1]
  if (random 200 < nad_consumption) and (nad > 1) [set nad nad - 1]
  no-display
  plot-levels
  plot-atp
  set total_nad replace-item time total_nad nad_cnt
  set total_atp replace-item time total_atp atp_cnt
    set time time + 1
  if(time >= 40) [set time 0]
  plot-rates 
  display
end

to plot-levels ;; this creates creates the bar graph 
    set-current-plot "Proton Gradient"
    clear-plot
    plot-pen-down
    set-current-plot-pen "matrix"
    plotxy 1 count turtles with [ycor < 0] 
    set-current-plot-pen "intermembrane"
  plotxy 2 rat 

end

to plot-atp ;; this creates creates the bar graph 
    set-current-plot "ADP-ATP NADH-NAD+"
    clear-plot
    plot-pen-down
    set-current-plot-pen "adp"
    plotxy 1 (50 - atp) 
    set-current-plot-pen "atp"
    plotxy 2 atp 
    set-current-plot-pen "nadh"
    plotxy 4 (50 - nad) 
    set-current-plot-pen "nad+"
    plotxy 5 nad

end

to plot-rates ;; this creates creates a line graph 
    set-current-plot "ATP and NAD Rates"
    plot-pen-down
    set-current-plot-pen "atp"
    plot ((sum total_atp) / 40) 
    set-current-plot-pen "nad"
    plot ((sum total_nad) / 40) 

end

; Copyright 2004 by Steven Brewer.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from the authors.
; Contact the authors for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Brewer, S.D. (2004).  Electron Transport: Simulating Proton Gradient,
; ADP-ATP, and NADH-NAD+ Interactions.  
; http://bcrc.bio.umass.edu/netlogo/models/ElectronTransport/
; Biology Computer Resource Center
;
; In other publications, please use:
; Copyright 2004 by Steven Brewer.  All rights reserved.  See
; http://bcrc.bio.umass.edu/netlogo/models/ElectronTransport/
@#$#@#$#@
GRAPHICS-WINDOW
322
10
647
230
17
10
9.0
1
10
1
1
1
0
1
1
1
-17
17
-10
10
0
0
1
ticks
30.0

BUTTON
13
10
79
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
101
10
164
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
190
10
318
43
Poison_AS
Poison_AS
1
1
-1000

SWITCH
190
48
319
81
Poison_ET
Poison_ET
1
1
-1000

PLOT
14
119
250
239
Proton Gradient
NIL
NIL
0.0
4.0
0.0
100.0
true
true
"" ""
PENS
"matrix" 1.0 1 -16777216 true "" ""
"intermembrane" 1.0 1 -65536 true "" ""

PLOT
12
241
249
424
ADP-ATP NADH-NAD+
NIL
NIL
0.0
5.0
0.0
50.0
true
true
"" ""
PENS
"ADP" 1.0 1 -16777216 true "" ""
"ATP" 1.0 1 -65536 true "" ""
"NADH" 1.0 1 -16711681 true "" ""
"NAD+" 1.0 1 -16776961 true "" ""

SLIDER
13
48
185
81
atp_consumption
atp_consumption
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
12
84
184
117
nad_consumption
nad_consumption
0
100
27
1
1
NIL
HORIZONTAL

SWITCH
189
84
319
117
uncouplers
uncouplers
1
1
-1000

PLOT
255
243
645
427
ATP and NAD Rates
NIL
NIL
0.0
20.0
0.0
1.0
true
true
"" ""
PENS
"ATP" 1.0 0 -65536 true "" ""
"NAD" 1.0 0 -16776961 true "" ""

TEXTBOX
331
206
446
224
mitochondrial matrix
11
0.0
0

TEXTBOX
330
37
452
55
intermembrane region
11
0.0
0

BUTTON
254
203
316
236
NIL
clear-all-plots
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This is a model of the electron transport chain that illustrates the behavior of the system when treated with poisons and uncouplers.  The space is divided into two regions: the lower region is the inside of the mitochrondrion and the upper space is the intermembrane region.  In electron transport, protons (yellow circles) are pumped into the intermembrane space in several stages (represented by the blue squares) using active transport and, when there is a strong enough proton gradient, they diffuse back into the inside the mitochrondion through ATP synthase (represented by red squares).  As each proton is pumped across the membrane, NADH is converted to NAD+ (consuming reducing power produced in other reactions in the cell).  As each proton diffuses back into the mitochondrion, ATP synthase captures the energy to phosphorylate ADP to ATP (which provides energy that is consumed in other reactions in the cell).

## HOW IT WORKS

Protons that are in the lower space can move into the upper space through the blue squares, but this can only occur when NADH is available to be reduced to NAD.  Furthermore, the propability reduces as the concentration gradient increases. Poisoning ET prevents protons from being pumped into the intermembrane space.  

Protons in the upper spaces can move into the lower space through the red squares, but only when there are more than 10 more protons in the upper than in the lower space and only when ADP is available.  Poisoning ATP synthase prevents protons from diffusing into the inside.

## HOW TO USE IT

Click the "setup" button to reset all of the parameters.

Click "go" to begin the simulation.

Switches are provided that can poison ATP synthase (poison_AS), poison an element in the electron transport chain (poison_ET), or add uncouplers to the system.  

Two sliders allow control of how quickly ATP and NAD are consumed in other reactions in the cell (which control availability of ATP and NADH, which are required for the electron transport chain to function).

Use the Proton Gradient graph to see numbers of protons in the mitochondrial matrix versus the intermembrane space.

Use the ADP-ATP NADH-NAD+ graph to see numbers of available ADP, ATP, NADH, and NAD+ molecules.

Use the ATP and NAD+ Rates graph to see a rolling average of the previous 40 units of time to see rates of production of ATP and NAD+.

## THINGS TO NOTICE

When the electron transport chain begins, which is produced first: NAD or ATP?  When various factors cause the chain to quit functioning, are both NAD and ATP production shut down at the same time?  Which follow the other?  Under what conditions? 

## THINGS TO TRY

Try to figure out how to produce NAD without producing ATP.

Can you produce ATP without producing NAD?  How or why not?

## EXTENDING THE MODEL

How could you speed up the rates of ATP or NAD production?

## CREDITS AND REFERENCES

Brewer, S.D. (2004).  Electron Transport: Simulating Proton Gradient,  
ADP-ATP, and NADH-NAD+ Interactions.    
http://bcrc.bio.umass.edu/netlogo/models/ElectronTransport/  
Biology Computer Resource Center

In other publications, please use:  
Copyright 2004 by Steven Brewer.  All rights reserved.  See  
http://bcrc.bio.umass.edu/netlogo/models/ElectronTransport/
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

ant
true
0
Polygon -7500403 true true 136 61 129 46 144 30 119 45 124 60 114 82 97 37 132 10 93 36 111 84 127 105 172 105 189 84 208 35 171 11 202 35 204 37 186 82 177 60 180 44 159 32 170 44 165 60
Polygon -7500403 true true 150 95 135 103 139 117 125 149 137 180 135 196 150 204 166 195 161 180 174 150 158 116 164 102
Polygon -7500403 true true 149 186 128 197 114 232 134 270 149 282 166 270 185 232 171 195 149 186
Polygon -7500403 true true 225 66 230 107 159 122 161 127 234 111 236 106
Polygon -7500403 true true 78 58 99 116 139 123 137 128 95 119
Polygon -7500403 true true 48 103 90 147 129 147 130 151 86 151
Polygon -7500403 true true 65 224 92 171 134 160 135 164 95 175
Polygon -7500403 true true 235 222 210 170 163 162 161 166 208 174
Polygon -7500403 true true 249 107 211 147 168 147 168 150 213 150

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bee
true
0
Polygon -1184463 true false 152 149 77 163 67 195 67 211 74 234 85 252 100 264 116 276 134 286 151 300 167 285 182 278 206 260 220 242 226 218 226 195 222 166
Polygon -16777216 true false 150 149 128 151 114 151 98 145 80 122 80 103 81 83 95 67 117 58 141 54 151 53 177 55 195 66 207 82 211 94 211 116 204 139 189 149 171 152
Polygon -7500403 true true 151 54 119 59 96 60 81 50 78 39 87 25 103 18 115 23 121 13 150 1 180 14 189 23 197 17 210 19 222 30 222 44 212 57 192 58
Polygon -16777216 true false 70 185 74 171 223 172 224 186
Polygon -16777216 true false 67 211 71 226 224 226 225 211 67 211
Polygon -16777216 true false 91 257 106 269 195 269 211 255
Line -1 false 144 100 70 87
Line -1 false 70 87 45 87
Line -1 false 45 86 26 97
Line -1 false 26 96 22 115
Line -1 false 22 115 25 130
Line -1 false 26 131 37 141
Line -1 false 37 141 55 144
Line -1 false 55 143 143 101
Line -1 false 141 100 227 138
Line -1 false 227 138 241 137
Line -1 false 241 137 249 129
Line -1 false 249 129 254 110
Line -1 false 253 108 248 97
Line -1 false 249 95 235 82
Line -1 false 235 82 144 100

bird1
false
0
Polygon -7500403 true true 2 6 2 39 270 298 297 298 299 271 187 160 279 75 276 22 100 67 31 0

bird2
false
0
Polygon -7500403 true true 2 4 33 4 298 270 298 298 272 298 155 184 117 289 61 295 61 105 0 43

boat1
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 33 230 157 182 150 169 151 157 156
Polygon -7500403 true true 149 55 88 143 103 139 111 136 117 139 126 145 130 147 139 147 146 146 149 55

boat2
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 157 54 175 79 174 96 185 102 178 112 194 124 196 131 190 139 192 146 211 151 216 154 157 154
Polygon -7500403 true true 150 74 146 91 139 99 143 114 141 123 137 126 131 129 132 139 142 136 126 142 119 147 148 147

boat3
false
0
Polygon -1 true false 63 162 90 207 223 207 290 162
Rectangle -6459832 true false 150 32 157 162
Polygon -13345367 true false 150 34 131 49 145 47 147 48 149 49
Polygon -7500403 true true 158 37 172 45 188 59 202 79 217 109 220 130 218 147 204 156 158 156 161 142 170 123 170 102 169 88 165 62
Polygon -7500403 true true 149 66 142 78 139 96 141 111 146 139 148 147 110 147 113 131 118 106 126 71

box
true
0
Polygon -7500403 true true 45 255 255 255 255 45 45 45

butterfly1
true
0
Polygon -16777216 true false 151 76 138 91 138 284 150 296 162 286 162 91
Polygon -7500403 true true 164 106 184 79 205 61 236 48 259 53 279 86 287 119 289 158 278 177 256 182 164 181
Polygon -7500403 true true 136 110 119 82 110 71 85 61 59 48 36 56 17 88 6 115 2 147 15 178 134 178
Polygon -7500403 true true 46 181 28 227 50 255 77 273 112 283 135 274 135 180
Polygon -7500403 true true 165 185 254 184 272 224 255 251 236 267 191 283 164 276
Line -7500403 true 167 47 159 82
Line -7500403 true 136 47 145 81
Circle -7500403 true true 165 45 8
Circle -7500403 true true 134 45 6
Circle -7500403 true true 133 44 7
Circle -7500403 true true 133 43 8

circle
false
0
Circle -7500403 true true 35 35 230

person
false
0
Circle -7500403 true true 155 20 63
Rectangle -7500403 true true 158 79 217 164
Polygon -7500403 true true 158 81 110 129 131 143 158 109 165 110
Polygon -7500403 true true 216 83 267 123 248 143 215 107
Polygon -7500403 true true 167 163 145 234 183 234 183 163
Polygon -7500403 true true 195 163 195 233 227 233 206 159

sheep
false
15
Rectangle -1 true true 90 75 270 225
Circle -1 true true 15 75 150
Rectangle -16777216 true false 81 225 134 286
Rectangle -16777216 true false 180 225 238 285
Circle -16777216 true false 1 88 92

spacecraft
true
0
Polygon -7500403 true true 150 0 180 135 255 255 225 240 150 180 75 240 45 255 120 135

thin-arrow
true
0
Polygon -7500403 true true 150 0 0 150 120 150 120 293 180 293 180 150 300 150

truck-down
false
0
Polygon -7500403 true true 225 30 225 270 120 270 105 210 60 180 45 30 105 60 105 30
Polygon -8630108 true false 195 75 195 120 240 120 240 75
Polygon -8630108 true false 195 225 195 180 240 180 240 225

truck-left
false
0
Polygon -7500403 true true 120 135 225 135 225 210 75 210 75 165 105 165
Polygon -8630108 true false 90 210 105 225 120 210
Polygon -8630108 true false 180 210 195 225 210 210

truck-right
false
0
Polygon -7500403 true true 180 135 75 135 75 210 225 210 225 165 195 165
Polygon -8630108 true false 210 210 195 225 180 210
Polygon -8630108 true false 120 210 105 225 90 210

turtle
true
0
Polygon -7500403 true true 138 75 162 75 165 105 225 105 225 142 195 135 195 187 225 195 225 225 195 217 195 202 105 202 105 217 75 225 75 195 105 187 105 135 75 142 75 105 135 105

wolf
false
0
Rectangle -7500403 true true 15 105 105 165
Rectangle -7500403 true true 45 90 105 105
Polygon -7500403 true true 60 90 83 44 104 90
Polygon -16777216 true false 67 90 82 59 97 89
Rectangle -1 true false 48 93 59 105
Rectangle -16777216 true false 51 96 55 101
Rectangle -16777216 true false 0 121 15 135
Rectangle -16777216 true false 15 136 60 151
Polygon -1 true false 15 136 23 149 31 136
Polygon -1 true false 30 151 37 136 43 151
Rectangle -7500403 true true 105 120 263 195
Rectangle -7500403 true true 108 195 259 201
Rectangle -7500403 true true 114 201 252 210
Rectangle -7500403 true true 120 210 243 214
Rectangle -7500403 true true 115 114 255 120
Rectangle -7500403 true true 128 108 248 114
Rectangle -7500403 true true 150 105 225 108
Rectangle -7500403 true true 132 214 155 270
Rectangle -7500403 true true 110 260 132 270
Rectangle -7500403 true true 210 214 232 270
Rectangle -7500403 true true 189 260 210 270
Line -7500403 true 263 127 281 155
Line -7500403 true 281 155 281 192

wolf-left
false
3
Polygon -6459832 true true 117 97 91 74 66 74 60 85 36 85 38 92 44 97 62 97 81 117 84 134 92 147 109 152 136 144 174 144 174 103 143 103 134 97
Polygon -6459832 true true 87 80 79 55 76 79
Polygon -6459832 true true 81 75 70 58 73 82
Polygon -6459832 true true 99 131 76 152 76 163 96 182 104 182 109 173 102 167 99 173 87 159 104 140
Polygon -6459832 true true 107 138 107 186 98 190 99 196 112 196 115 190
Polygon -6459832 true true 116 140 114 189 105 137
Rectangle -6459832 true true 109 150 114 192
Rectangle -6459832 true true 111 143 116 191
Polygon -6459832 true true 168 106 184 98 205 98 218 115 218 137 186 164 196 176 195 194 178 195 178 183 188 183 169 164 173 144
Polygon -6459832 true true 207 140 200 163 206 175 207 192 193 189 192 177 198 176 185 150
Polygon -6459832 true true 214 134 203 168 192 148
Polygon -6459832 true true 204 151 203 176 193 148
Polygon -6459832 true true 207 103 221 98 236 101 243 115 243 128 256 142 239 143 233 133 225 115 214 114

wolf-right
false
3
Polygon -6459832 true true 170 127 200 93 231 93 237 103 262 103 261 113 253 119 231 119 215 143 213 160 208 173 189 187 169 190 154 190 126 180 106 171 72 171 73 126 122 126 144 123 159 123
Polygon -6459832 true true 201 99 214 69 215 99
Polygon -6459832 true true 207 98 223 71 220 101
Polygon -6459832 true true 184 172 189 234 203 238 203 246 187 247 180 239 171 180
Polygon -6459832 true true 197 174 204 220 218 224 219 234 201 232 195 225 179 179
Polygon -6459832 true true 78 167 95 187 95 208 79 220 92 234 98 235 100 249 81 246 76 241 61 212 65 195 52 170 45 150 44 128 55 121 69 121 81 135
Polygon -6459832 true true 48 143 58 141
Polygon -6459832 true true 46 136 68 137
Polygon -6459832 true true 45 129 35 142 37 159 53 192 47 210 62 238 80 237
Line -16777216 false 74 237 59 213
Line -16777216 false 59 213 59 212
Line -16777216 false 58 211 67 192
Polygon -6459832 true true 38 138 66 149
Polygon -6459832 true true 46 128 33 120 21 118 11 123 3 138 5 160 13 178 9 192 0 199 20 196 25 179 24 161 25 148 45 140
Polygon -6459832 true true 67 122 96 126 63 144

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
