
turtles-own[
  high
  medium
  low
  
  prob-high
  prob-medium
  prob-low
  
  ;; expected time to reach node - based on expectation of previous nodes (linked)
  ;; this will be used for calculation of immediate rewards
  expectation
  
  ;; variable to store value obtained from value iteration
  value
]

links-own[
;  prob-high ;; for node linking node A to node B, this represents the probability that the driver will take 1 time step to reach node B when the traffic level at node A is high
;  prob-medium ;; for node linking node A to node B, this represents the probability that the driver will take 1 time step to reach node B when the traffic level at node A is medium
;  prob-low ;; for node linking node A to node B, this represents the probability that the driver will take 1 time step to reach node B when the traffic level at node A is low
]

to go
  ask turtle 9[value-iteration]
  
  ask turtles[
    set label (word who ": " value)
    set color blue
  ]
  tick
end

to value-iteration
    ifelse(who != 9)[
      set color red
      
      ;; count of possible ways to travel (out link neighbors)
      let count-n (count out-link-neighbors)
      
      ;; who of out link neighbors
      let who-n (sort ([who] of out-link-neighbors))
      
      ;; prob of main direction (for value iteration calculation)
      let main-prob (1 - ((count-n - 1) * 0.1))
      
      ;; list which stores all possible values of all actions taken in state s - used to computing max
      ;; immediate reward (R) is taken as negative of expected time to reach state/node s' (to reflect the reward function of rewarding user for reaching node early)
      let val-list []
      
      foreach who-n[
        let main-dir-node ?
        let val (main-prob * ([value] of turtle main-dir-node)) - ([expectation] of turtle main-dir-node)
        
        
        ;; iterate through other nodes
        foreach who-n[
          if(? != main-dir-node)[
            set val (val + (0.1 * ([value] of turtle ?)))
          ]
        ]
        
        set val-list lput val val-list
      ]
      
      ;; set value as max in val-list - value iteration
      set value (precision (max val-list) 2)
    ]
    [
      set value 100
    ]
    
    
    
    ;; recursively call value iteration on in link neighbors
    ask in-link-neighbors[value-iteration]
end

to update-expectation
  ;  0
  ifelse(who = 0)[
    set expectation 0
    set color red
  ]
  ;; for all other nodes
  [
    ;; boolean to check if all neighbors has expectation updated - will not proceed to update node if boolean is false (some neighbors not updated)
    let n-expect? true
    
    foreach([who] of in-link-neighbors)[
      if(([color] of turtle ?) != red)[
        set n-expect? false
      ]
    ]
    
    ;; proceed to update expectation if all neighbors are updated
    if(n-expect? = true)[
      ;; sum of expectation of all in-link neighbors
      let sum-expectation 0
      
      foreach([who] of in-link-neighbors)[
        let n-who ([who] of (turtle ?))
        let n-expectation ([expectation] of (turtle ?))
        
        set sum-expectation (sum-expectation + n-expectation + (mean-travel-time n-who (traffic-conditions n-who n-expectation)))
      ]
      
      ;; average over all neighbors
      set sum-expectation (sum-expectation / (length ([who] of in-link-neighbors)))
      
      set expectation sum-expectation
      
      set color red
    ]
    
  ]
  
  ;; recursively call update-expectation procedure to all out link neighbors
  ask out-link-neighbors[update-expectation]
end

to setup
  ca
  reset-ticks
  ask patches[set pcolor 69]
  
  setup-nodes
  setup-links
  
  ;; update expected time to reach all nodes
  ;; this will be used to compute the immediate reward
  ask turtle 0[update-expectation]
  
  ask turtle 9[set value 100]
  
  ask turtles[
    set label (word who ": " value)
    set color blue
  ]
end

;; setup nodes in the network
to setup-nodes
  crt 1[setxy 3 13 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 1 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 5 10 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 2 7 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 4 7 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 1 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 5 4 set shape "rounded-rectangle" set color blue set label who set label-color black]
  crt 1[setxy 3 1 set shape "rounded-rectangle" set color blue set label who set label-color black]
end

;; setup links between nodes
to setup-links
  crt-links 0 1
  crt-links 0 3
  crt-links 1 2
  crt-links 1 4
  crt-links 2 4
  crt-links 2 5
  crt-links 3 2
  crt-links 3 5
  crt-links 3 8
  crt-links 4 5
  crt-links 4 6
  crt-links 4 8
  crt-links 4 9
  crt-links 5 6
  crt-links 5 7
  crt-links 6 9
  crt-links 7 9
  crt-links 8 7
end

;; procedure to create links from turtle to turtle - used in setup-links procedure
to crt-links[from-turtle to-turtle]
  ask turtle from-turtle[create-link-to turtle to-turtle]
end

;; procedure to report mean travel time along an edge with source node (as input) given certain traffic conditions (input)
to-report mean-travel-time[node traffic]
  let prob 0

  if(node = 0)[
    if(traffic = "high")[
      set prob n0-high-prob
    ]
    if(traffic = "medium")[
      set prob n0-medium-prob
    ]
    if(traffic = "low")[
      set prob n0-low-prob
    ]
  ]
  if(node = 1)[
    if(traffic = "high")[
      set prob n1-high-prob
    ]
    if(traffic = "medium")[
      set prob n1-medium-prob
    ]
    if(traffic = "low")[
      set prob n1-low-prob
    ]
  ]
  if(node = 2)[
    if(traffic = "high")[
      set prob n2-high-prob
    ]
    if(traffic = "medium")[
      set prob n2-medium-prob
    ]
    if(traffic = "low")[
      set prob n2-low-prob
    ]
  ]
  if(node = 3)[
    if(traffic = "high")[
      set prob n3-high-prob
    ]
    if(traffic = "medium")[
      set prob n3-medium-prob
    ]
    if(traffic = "low")[
      set prob n3-low-prob
    ]
  ]
  if(node = 4)[
    if(traffic = "high")[
      set prob n4-high-prob
    ]
    if(traffic = "medium")[
      set prob n4-medium-prob
    ]
    if(traffic = "low")[
      set prob n4-low-prob
    ]
  ]
  if(node = 5)[
    if(traffic = "high")[
      set prob n5-high-prob
    ]
    if(traffic = "medium")[
      set prob n5-medium-prob
    ]
    if(traffic = "low")[
      set prob n5-low-prob
    ]
  ]
  if(node = 6)[
    if(traffic = "high")[
      set prob n6-high-prob
    ]
    if(traffic = "medium")[
      set prob n6-medium-prob
    ]
    if(traffic = "low")[
      set prob n6-low-prob
    ]
  ]
  if(node = 7)[
    if(traffic = "high")[
      set prob n7-high-prob
    ]
    if(traffic = "medium")[
      set prob n7-medium-prob
    ]
    if(traffic = "low")[
      set prob n7-low-prob
    ]
  ]
  if(node = 8)[
    if(traffic = "high")[
      set prob n8-high-prob
    ]
    if(traffic = "medium")[
      set prob n8-medium-prob
    ]
    if(traffic = "low")[
      set prob n8-low-prob
    ]
  ]
  if(node = 9)[
    if(traffic = "high")[
      set prob n9-high-prob
    ]
    if(traffic = "medium")[
      set prob n9-medium-prob
    ]
    if(traffic = "low")[
      set prob n9-low-prob
    ]
  ]
  
  report ((prob * 1.0) + ((1.0 - prob) * 2.0))
  
end

;; procedure to retrieve traffic conditions at a node at time step
to-report traffic-conditions[node timestep]
  ;; string to retrieve traffic
  let report-list ""
  
  if(node = 0)[
    set report-list n0-traffic-level
  ]
  if(node = 1)[
    set report-list n1-traffic-level
  ]
  if(node = 2)[
    set report-list n2-traffic-level
  ]
  if(node = 3)[
    set report-list n3-traffic-level
  ]
  if(node = 4)[
    set report-list n4-traffic-level
  ]
  if(node = 5)[
    set report-list n5-traffic-level
  ]
  if(node = 6)[
    set report-list n6-traffic-level
  ]
  if(node = 7)[
    set report-list n7-traffic-level
  ]
  if(node = 8)[
    set report-list n8-traffic-level
  ]
  if(node = 9)[
    set report-list n9-traffic-level
  ]
  
  ;; convert to list format
  set report-list (read-from-string report-list)
  
  ;; retrieve item in report-list based on timestep
  ifelse(timestep <= 10)[
    ;; 0 to 10
    report item 0 report-list
  ]
  [
    ifelse(timestep <= 15)[
      ;; 11 - 15
      report item 1 report-list
    ]
    [
      ifelse(timestep <= 30)[
        ;; 16 - 30
        report item 2 report-list
      ]
      [
        ifelse(timestep <= 100)[
          ;; 31 - 100
          report item 3 report-list
        ]
        [
          ;; nothing
          report 0
        ]
      ]
    ]
  ]
end

@#$#@#$#@
GRAPHICS-WINDOW
226
13
471
524
-1
-1
32.0
1
10
1
1
1
0
1
1
1
0
6
0
14
0
0
1
ticks
30.0

BUTTON
81
40
215
73
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
486
40
584
100
n0-high-prob
0.5
1
0
Number

INPUTBOX
486
100
584
160
n0-medium-prob
0.7
1
0
Number

INPUTBOX
486
160
584
220
n0-low-prob
0.9
1
0
Number

INPUTBOX
486
220
584
280
n1-high-prob
0.5
1
0
Number

INPUTBOX
486
280
584
340
n1-medium-prob
0.7
1
0
Number

INPUTBOX
486
340
584
400
n1-low-prob
0.9
1
0
Number

INPUTBOX
486
400
584
460
n2-high-prob
0.5
1
0
Number

INPUTBOX
486
460
584
520
n2-medium-prob
0.7
1
0
Number

INPUTBOX
486
520
584
580
n2-low-prob
0.9
1
0
Number

INPUTBOX
486
580
584
640
n3-high-prob
0.5
1
0
Number

INPUTBOX
486
640
584
700
n3-medium-prob
0.7
1
0
Number

INPUTBOX
486
700
584
760
n3-low-prob
0.9
1
0
Number

INPUTBOX
486
760
584
820
n4-high-prob
0.5
1
0
Number

INPUTBOX
486
820
584
880
n4-medium-prob
0.7
1
0
Number

INPUTBOX
486
880
584
940
n4-low-prob
0.9
1
0
Number

INPUTBOX
780
41
878
101
n5-high-prob
0.5
1
0
Number

INPUTBOX
780
101
878
161
n5-medium-prob
0.7
1
0
Number

INPUTBOX
780
161
878
221
n5-low-prob
0.9
1
0
Number

INPUTBOX
780
221
878
281
n6-high-prob
0.5
1
0
Number

INPUTBOX
780
281
878
341
n6-medium-prob
0.7
1
0
Number

INPUTBOX
780
341
878
401
n6-low-prob
0.9
1
0
Number

INPUTBOX
780
401
878
461
n7-high-prob
0.5
1
0
Number

INPUTBOX
780
461
878
521
n7-medium-prob
0.7
1
0
Number

INPUTBOX
780
521
878
581
n7-low-prob
0.9
1
0
Number

INPUTBOX
780
581
878
641
n8-high-prob
0.5
1
0
Number

INPUTBOX
780
641
878
701
n8-medium-prob
0.7
1
0
Number

INPUTBOX
780
701
878
761
n8-low-prob
0.9
1
0
Number

INPUTBOX
780
761
878
821
n9-high-prob
0.5
1
0
Number

INPUTBOX
780
821
878
881
n9-medium-prob
0.7
1
0
Number

INPUTBOX
780
881
878
941
n9-low-prob
0.9
1
0
Number

MONITOR
583
40
759
101
n0-high-prob : 2 step
(1 - n0-high-prob)
1
1
15

MONITOR
583
100
759
161
n0-medium-prob : 2 step
(1 - n0-medium-prob)
1
1
15

MONITOR
583
160
759
221
n0-low-prob : 2 step
(1 - n0-low-prob)
1
1
15

MONITOR
583
220
759
281
n1-high-prob : 2 step
(1 - n1-high-prob)
1
1
15

MONITOR
583
280
759
341
n1-medium-prob : 2 step
(1 - n1-medium-prob)
1
1
15

MONITOR
583
340
759
401
n1-low-prob : 2 step
(1 - n1-low-prob)
1
1
15

MONITOR
583
400
759
461
n2-high-prob : 2 step
(1 - n2-high-prob)
1
1
15

MONITOR
583
460
759
521
n2-medium-prob : 2 step
(1 - n2-medium-prob)
1
1
15

MONITOR
583
520
759
581
n2-low-prob : 2 step
(1 - n2-low-prob)
1
1
15

MONITOR
583
580
759
641
n3-high-prob : 2 step
(1 - n3-high-prob)
1
1
15

MONITOR
583
640
759
701
n3-medium-prob : 2 step
(1 - n3-medium-prob)
1
1
15

MONITOR
583
700
759
761
n3-low-prob : 2 step
(1 - n3-low-prob)
1
1
15

MONITOR
583
760
759
821
n4-high-prob : 2 step
(1 - n4-high-prob)
1
1
15

MONITOR
583
820
759
881
n4-medium-prob : 2 step
(1 - n4-medium-prob)
1
1
15

MONITOR
583
880
759
941
n4-low-prob : 2 step
(1 - n4-low-prob)
1
1
15

MONITOR
877
41
1053
102
n5-high-prob : 2 step
(1 - n5-high-prob)
1
1
15

MONITOR
877
101
1053
162
n5-medium-prob : 2 step
(1 - n5-medium-prob)
1
1
15

MONITOR
877
161
1053
222
n5-low-prob : 2 step
(1 - n5-low-prob)
1
1
15

MONITOR
877
221
1053
282
n6-high-prob : 2 step
(1 - n6-high-prob)
1
1
15

MONITOR
877
281
1053
342
n6-medium-prob : 2 step
(1 - n6-medium-prob)
1
1
15

MONITOR
877
341
1053
402
n6-low-prob : 2 step
(1 - n6-low-prob)
1
1
15

MONITOR
877
401
1053
462
n7-high-prob : 2 step
(1 - n7-high-prob)
1
1
15

MONITOR
877
461
1053
522
n7-medium-prob : 2 step
(1 - n7-medium-prob)
1
1
15

MONITOR
877
521
1053
582
n7-low-prob : 2 step
(1 - n7-low-prob)
1
1
15

MONITOR
877
581
1053
642
n8-high-prob : 2 step
(1 - n8-high-prob)
1
1
15

MONITOR
877
641
1053
702
n8-medium-prob : 2 step
(1 - n8-medium-prob)
1
1
15

MONITOR
877
701
1053
762
n8-low-prob : 2 step
(1 - n8-low-prob)
1
1
15

MONITOR
877
761
1053
822
n9-high-prob : 2 step
(1 - n9-high-prob)
1
1
15

MONITOR
877
821
1053
882
n9-medium-prob : 2 step
(1 - n9-medium-prob)
1
1
15

MONITOR
877
881
1053
942
n9-low-prob : 2 step
(1 - n9-low-prob)
1
1
15

TEXTBOX
1087
43
1507
252
[node]-[traffic]-prob\n=============\nshows the probability that it takes the driver to travel to another node in 1 time step from [node] specified given certain [traffic] condition\n\n[node]-[traffic]-prob : 2 steps\n==================\nshows the probability that it takes the driver to travel to another node in 2 time step from [node] specified given certain [traffic] condition
15
0.0
1

BUTTON
151
79
214
112
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
81
79
144
112
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
1086
539
1313
599
n0-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1086
599
1313
659
n1-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1086
659
1313
719
n2-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1086
718
1313
778
n3-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1086
777
1313
837
n4-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1313
539
1534
599
n5-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1313
599
1534
659
n6-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1312
659
1533
719
n7-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1313
718
1534
778
n8-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

INPUTBOX
1313
777
1534
837
n9-traffic-level
[\"high\" \"medium\" \"low\" \"high\"]
1
0
String

TEXTBOX
1083
305
1502
518
[node]-traffic-level\n============\nformat: [\"A\" \"B\" \"C\" \"D\"]\n\"A/B/C/D\" - \"high\"/\"medium\"/\"low\"\n\ninput for the traffic conditions at node [node] at time steps as shown below:\n\"A\" - 0 to 10\n\"B\" - 10 to 15\n\"C\" - 15 to 30\n\"D\" - 30 to 100\n
15
0.0
1

TEXTBOX
1080
269
1568
289
============================================
15
55.0
1

TEXTBOX
1063
273
1084
965
||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||\n||
15
55.0
1

TEXTBOX
31
175
181
371
Node 9 (termination node) has a value of 100.\n\nFor other nodes, the immediate reward (R) is taken as the negative of expected time taken to reach node.\n\nTo view the expected time to reach a node, right click on node -> select inspect node (node no.) -> look for expectation variable under the node attributes
11
0.0
1

@#$#@#$#@

## WHAT IS IT?

Route Planner

## CREDITS AND REFERENCES

This model is the work of Larry LIN Jun Jie.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rounded-rectangle
false
0
Circle -7500403 true true 0 75 150
Circle -7500403 true true 150 75 150
Rectangle -7500403 true true 75 75 225 225

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
