globals 
[patch-unit view-mode support-number f-targeted-plots w-targeted-firms w-targeted-housings 
  total-production total-demand employment-rate policy-sensor f-visibility w-visibility 

  f-quadrat w-quadrat
  Q-z-f-test Q-z-w-test 
  R-f N-z-stat-f
  R-w N-z-stat-w
  patches-1 patches-2 patches-3 patches-4 patches-5 patches-6 patches-7 patches-8 patches-9 patches-10
  patches-1-num patches-2-num  patches-3-num patches-4-num patches-5-num patches-6-num patches-7-num 
  patches-8-num patches-9-num patches-10-num  
 ;; keep tracking land area for CIs firms and CWs ;;total-demanding-CWs supplying-CWs 
;; f-quadrat w-quadrat, used to describe the cluster pattern
steps ; to record the ticks to help to calculate growth cycle
growth-cycle-count; to count the growth cycle
f-growth-variable;the growth power of the number of firms
w-growth-variable; the growth power of the number of workers
output-sold-rate;the rate that the production can be sold, the same to all the firms
CWs-special
CIs-special
UGs-special
plot-special;;to calculate individual agents

CIs-num
CWs-num
UGs-num
noland-CIs-num
nojob-CWs-num 
nohome-CWs-num 
noland-CIs-rate
nojob-CWs-rate 
nohome-CWs-rate

total-patch-firm-ok-num-1
total-patch-firm-ok-num-2
total-patch-firm-ok-num-3
total-patch-firm-ok-num-4
total-patch-firm-ok-num-5
total-patch-firm-ok-num-6
total-patch-firm-ok-num-7
total-patch-firm-ok-num-8
total-patch-firm-ok-num-9
total-patch-firm-ok-num-10
f-1-density
f-2-density
f-3-density
f-4-density
f-5-density
f-6-density
f-7-density
f-8-density
f-9-density
f-10-density


total-patch-worker-ok-num-1
total-patch-worker-ok-num-2
total-patch-worker-ok-num-3
total-patch-worker-ok-num-4
total-patch-worker-ok-num-5
total-patch-worker-ok-num-6
total-patch-worker-ok-num-7
total-patch-worker-ok-num-8
total-patch-worker-ok-num-9
total-patch-worker-ok-num-10
w-1-density
w-2-density
w-3-density
w-4-density
w-5-density
w-6-density
w-7-density
w-8-density
w-9-density
w-10-density

land-rent-1-mean
land-rent-2-mean
land-rent-3-mean
land-rent-4-mean
land-rent-5-mean
land-rent-6-mean
land-rent-7-mean
land-rent-8-mean
land-rent-9-mean
land-rent-10-mean

housing-rent-1-mean
housing-rent-2-mean
housing-rent-3-mean
housing-rent-4-mean
housing-rent-5-mean
housing-rent-6-mean
housing-rent-7-mean
housing-rent-8-mean
housing-rent-9-mean
housing-rent-10-mean

firm-real-size-max
firm-real-size-min
firm-real-size-mean
firm-real-size-median

worker-income-max
worker-income-min
worker-income-mean
worker-income-median

]

breed [CIs CI]
breed [CWs CW]
breed [UGs UG];;to define three new types of turtles
breed [river-creators river-creator];; to define rivers
breed [lake-creators lake-creator];; to define lakes
breed [hill-creators hill-creator];; to define hills

breed [ring-points ring-point];; to define ringway-outer
breed [ring1-points ring1-point];; to define ringway-inner1
breed [ring2-points ring2-point];; to define ringway-inner2
breed [ring3-points ring3-point];; to define ringway-inner3
breed [junct-creators junct-creator];; to define junctions for regional transportation
breed [sub-creator0s sub-creator0];; to define underground creators in the centre
breed [sub-creator1s sub-creator1];; to define underground creators moving at the end
breed [sub-stations sub-station];; to define underground stations linear
breed [sub-cstation1s sub-cstation1];; to define underground stations circle 1
breed [sub-cstation2s sub-cstation2];; to define underground stations circle 2
breed [green-parks green-park];; to define public parks
breed [universities university];; to define the location of university
breed [ind-parks ind-park];; to define industrial parks
breed [derelict-factories derelict-factory];; to define derelict factories
breed [old-illegal-housings old-illegal-housing];; to define old and illegal housing area
breed [subhouses subhouse] ;; to define suburban housing
breed [shoppingmalls shoppingmall];; to define shopping facilities
breed [cul-facilities cul-facility];; to define cultural faciliities

breed [helpers helper];; randomly used to create lines


patches-own [urban-area terrain  boundary land-type use-possible basic-mark transport-mark s-transport-mark rapidtrans-mark s-rapidtrans-mark 
  regionaltrans-mark s-regionaltrans-mark environment-mark s-environment-mark shopping-mark s-shopping-mark culture-mark s-culture-mark 
  milieu-mark s-milieu-mark talent-mark s-talent-mark proximity-mark s-proximity-mark land-rent s-land-rent land-rent-after-policy housing-rent s-housing-rent 
  building-quality policy-mark firm-utility worker-utility f-max-volume f-real-volume w-max-volume w-real-volume tax-reduction-rate
  patch-firm-number patch-firm-ok-number patch-worker-number patch-worker-ok-number patch-f-num-diference patch-w-num-difference 
  policy-package-num p-distance-to-centre]

;;use-possible idicate whether the patch is possible for creative industries or creative workers' housing (0 no 1 yes)
;; firms and CWs are both breeds of turtle
;; patch-firm-number patch-worker-number, used to calculate the turtle number in each patch
;; patch-f-num-diference patch-w-num-difference, used to calculate the (square (Xi minus X bar))
;; policy-package-num is used to store the UGs' num in a patch
;;land-rent-after-policy,describe the rent enjoyed by firms because of policy support


CIs-own [mark1 mark2 mark3 mark4 mark5 mark6 mark7 mark8 CI-utility got-land-or-not off-land-time expected-size real-size 
  wage output total-wagepaid ;output-sold-rate 
  land-expense-rate;;to see the percentage of expense in land of total sold value, so to decide whether the firm needs to move
  profit-rate profit tax-percent tax-paid capital nearest-distance]

CWs-own [grade1 grade2 grade3 grade4 grade5 CW-utility housing-area got-housing-or-not off-home-time inheritance?
  got-job-or-not off-job-time expected-income real-income capability company-id nearest-distance about-to-move] 
;;housing-area is the area each worker demands, calculated via normal distribution based on the statistics generated from fieldwork
;; capability is the productivity (in value) a worker can generate, calculated via expected income
;; about-to-move is used to mark the worker's intention to moving caused by high housing rent (0, not to moving, 1 to move)
UGs-own [policy-code cover-size tax-abate-rate land-rent-abate-rate milieu-promote-rate planned-time-in-service real-time-in-service]
;; urban government as advocator, regulator and controller
;;affect the behaviors of CIs via three approaches: land-rent-reduction, tax-reduction, and help in trade etc.
;; planned-time-in-service is based on average tenure controlled by the user interface

river-creators-own []
universities-own [place-id]
ind-parks-own [area-id]
derelict-factories-own [site-id]
old-illegal-housings-own [oldhousing-id]
subhouses-own [subhouse-id]
shoppingmalls-own [mall-id]
cul-facilities-own [culture-id]

to setup
  
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  set patch-unit (max-pxcor / 200)
  ask patches 
  [set terrain "plain"
    set boundary "nnn"
    set policy-mark 1
    set building-quality 1
    set view-mode "none"
    ;set pcolor white
    ]
 set policy-sensor 0 ;;to look over the policy intervene
 set f-visibility 1
 set w-visibility 1
  define-urban-area
  define-circle-belt
  create-rivers
  create-lakes
  create-hills
  
  create-ringways0
  create-ringways1
  create-ringways2
  create-ringways3
  create-cloverleaf
  create-road
  create-road-1
  create-underground
  create-public-greens
  create-university-etc
  create-industrial-park
  create-old-factory
  create-old-illegal-building  
  create-dailyshopping
  create-culture-facility  
  create-subhousing  
  define-farmland
  define-constructedland
  setup-landuse-type
  setup-buildingquality
  calculate-landfeaturesmark
  setup-policy
  setup-patch-volume-property
  setup-firms
  setup-workers
  set total-demand base-product-demand
  set growth-cycle-count 0
  set steps 0
  calculate-total-production
  if (total-demand = 0) [set total-demand 1];; to avoid demand is set to zero
  calculate-employment-rate
  calcualte-output-sold-rate
  ask CIs with [output > 0]
  [calculate-profit-rate calculate-capital]
  ifelse ((count CIs with [got-land-or-not = 1]) > 1 
    and (count CWs with [got-housing-or-not = 1]) > 1 )
  [do-plots]
  []
end 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to define-urban-area
   ask patches 
  [
    if ((pxcor * pxcor + pycor * pycor) < ((max-pxcor * max-pxcor) / (25 * 25)))     
    [;set pcolor 128;
      set urban-area "CBD"]   ;; to define area of CBD
    
    if ((pxcor * pxcor + pycor * pycor) >= ((max-pxcor * max-pxcor) / (25 * 25)))
    and ((pxcor * pxcor + pycor * pycor) < ((max-pxcor * max-pxcor) / (5 * 10)))
      [;set pcolor 125;
       set urban-area "inner-city-district"]   ;; to define area of inner city proper
    
    if ((pxcor * pxcor + pycor * pycor) >= ((max-pxcor * max-pxcor) / (5 * 10)))
    and ((pxcor * pxcor + pycor * pycor) < ((max-pxcor * max-pxcor) / (2.5 * 5)))
      [;set pcolor 123;
       set urban-area "outer-city-district"]   ;; to define area of outer city proper
    
    if ((pxcor * pxcor + pycor * pycor) >= ((max-pxcor * max-pxcor) / (2.5 * 5)))
    and ((pxcor * pxcor + pycor * pycor) < ((max-pxcor * max-pxcor) / (1 * 2.5)))
      [;set pcolor 121;
       set urban-area "inner-suburb"]   ;; to define area of inner suburb
    
    if ((pxcor * pxcor + pycor * pycor) >= ((max-pxcor * max-pxcor) / (1 * 2.5)))
      [;set pcolor 111;
       set urban-area "outer-suburb"] ;; to define outer suburb
  ]  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to define-circle-belt
  ask patches 
   [set p-distance-to-centre (sqrt ((pxcor ^ 2) + (pycor ^ 2)))]
     
  set patches-1 (patches with [p-distance-to-centre <= 10])
  set patches-2 (patches with [(p-distance-to-centre > 10) and (p-distance-to-centre <= 20)])
  set patches-3 (patches with [(p-distance-to-centre > 20) and (p-distance-to-centre <= 30)])
  set patches-4 (patches with [(p-distance-to-centre > 30) and (p-distance-to-centre <= 40)])
  set patches-5 (patches with [(p-distance-to-centre > 40) and (p-distance-to-centre <= 50)])
  set patches-6 (patches with [(p-distance-to-centre > 50) and (p-distance-to-centre <= 60)])
  set patches-7 (patches with [(p-distance-to-centre > 60) and (p-distance-to-centre <= 70)])
  set patches-8 (patches with [(p-distance-to-centre > 70) and (p-distance-to-centre <= 80)])
  set patches-9 (patches with [(p-distance-to-centre > 80) and (p-distance-to-centre <= 90)])
  set patches-10 (patches with [p-distance-to-centre > 90])
  
  set patches-1-num (count patches-1) 
  set patches-2-num (count patches-2) 
  set patches-3-num (count patches-3) 
  set patches-4-num (count patches-4) 
  set patches-5-num (count patches-5) 
  set patches-6-num (count patches-6) 
  set patches-7-num (count patches-7) 
  set patches-8-num (count patches-8) 
  set patches-9-num (count patches-9) 
  set patches-10-num (count patches-10) 
  
end 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-rivers
  create-river-creators river-number  
  ask river-creators  
  [setxy (random-xcor) (random-ycor)
    hide-turtle
    ask patch-here 
    [set pcolor 85
     set terrain "river"]
    
    if (xcor < (- max-pxcor / 2)) and ((abs ycor) < (max-pycor / 2))
    [;set heading 90
      loop
      [set heading (random 180)
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]      
     ]
    
    if (xcor > (max-pxcor / 2)) and ((abs ycor) < (max-pycor / 2))
    [;set heading 270
     loop
      [set heading ((random 180) + 180)
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]           
     ]
    
    if (ycor > (max-pycor / 2)) and ((abs xcor) < (max-pxcor / 2))
    [;set heading 180
     loop
      [set heading ((random 180) + 90)
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]            
     ]
    
    if (ycor < (- max-pycor / 2)) and ((abs xcor) < (max-pxcor / 2))
    [;set heading 0
     loop
      [let nn (random 2)
        ifelse (nn = 1)
        [set heading (random 90)]
        [set heading ((random 90) + 270)]
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]            
     ]
    
    if (xcor < (- max-pxcor / 2)) and (ycor < (- max-pycor / 2))
    [;set heading 45
     loop
      [let nn (random 3)
        ifelse (nn = 1)
        [set heading ((random 45) + 315)]
        [set heading (random 135)]
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]            
     ]
    
    if (xcor < (- max-pxcor / 2)) and (ycor > (max-pycor / 2))
    [;set heading 135
     loop
      [set heading ((random 180) + 90) 
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]             
     ]
    
    if (xcor > (max-pxcor / 2)) and (ycor < (- max-pycor / 2))
    [;set heading 315
     loop
      [let nn (random 3)
        ifelse (nn = 1)
        [set heading (random 45)]
        [set heading ((random 135) + 225)]
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]            
     ]
    
    if (xcor > (max-pxcor / 2)) and (ycor > (max-pycor / 2))
    [;set heading 225
     loop
      [set heading ((random 180) + 135) 
       forward 1
       ask patch-here 
       [set pcolor 85
        set terrain "river"]     
       if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
        [stop]
       ]             
     ]
;;;;; to deal with points in the center area   
    loop
    [set heading (random 180)
      forward 1
    ask patch-here 
     [set pcolor 85
      set terrain "river"]
     
     if ((xcor >= max-pxcor) 
       or (xcor <= (- max-pxcor))
       or (ycor >= max-pycor)
       or (ycor <= (- max-pycor)))
       [stop]
     ]
    ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-lakes
 set-default-shape lake-creators "fish" 
 create-lake-creators lake-number 
 [ hide-turtle     
   setxy 0 0
   set heading random 360
   forward ((random (50 * patch-unit)) + (30 * patch-unit))
   ask patch-here 
   [set pcolor 95
    set terrain "lake"]
    ask patches in-radius (6 * patch-unit) 
   [set pcolor 95
    set terrain "lake"]
   let nn 0
   loop
   [set heading (random 360)
     forward (5 * patch-unit)
     ask patches in-radius (6 * patch-unit) 
      [set pcolor 95
       set terrain "lake"]
     set nn nn + 1  
     if (nn >= ((random (5 * patch-unit)) + (4 * patch-unit)))
      [stop]  
   ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-hills
  create-hill-creators hill-number 
  ask hill-creators
   [hide-turtle 
     move-to one-of patches with [((terrain != "lake") or (terrain != "hill")) 
       and (urban-area != "CBD") and (urban-area != "inner-city-district") 
       and (urban-area != "outer-city-district")]
   ask patch-here 
   [set pcolor 65
    set terrain "hill"]
   ask patches in-radius (10 * patch-unit) 
   [if ((pcolor != 95) and (urban-area != "CBD") and (urban-area != "inner-city-district"))
    [set pcolor 65
      set terrain "hill"]
   ]
   let nn 0
   loop
   [set heading (random 360)
     forward (6 * patch-unit)
     ask patches in-radius 8 
      [if ((pcolor != 95) and (urban-area != "CBD") and (urban-area != "inner-city-district"))
       [set pcolor 65
        set terrain "hill"]
       ]
     set nn nn + 1  
     if (nn >= ((random (6 * patch-unit)) + (8 * patch-unit)))
      [stop]  
    ]
   ]
  ask patches with [terrain = "hill"]
  [set pcolor 65 ]
 end   
   
   

;;cut-off create-railway-station

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

;;to create ringways and define ringways boundary (outer ringway)

to create-ringways0
  create-ring-points 30
  [
    hide-turtle
    set color gray
    set size (10 * patch-unit)]
  layout-circle sort   ring-points int (max-pxcor / 1.6)
  ask ring-points
  [forward (int ((random (max-pxcor / 10) - (max-pxcor / 20))) * patch-unit)
    while [([terrain] of patch-here) != "plain"] [forward 1] ;; to create random-like ringways
    ]
  ask ring-points 
  [move-to patch-here] 
  
 let bestart (min [who] of ring-points)
 let endest (max [who] of ring-points)
 
  ask ring-point endest
  [hatch-helpers 1
    [
      hide-turtle
      set color gray
      set size (20 * patch-unit)
      ask patch-here 
      [set terrain "road"]]
    ask patches in-radius (2 * patch-unit)
      [set terrain "road"
        set boundary "yyyy"]
     ]
  
  let hh (bestart - 1)
  repeat 30
  [set hh hh + 1
   ask helpers
   [pendown    
    face (ring-point hh)
    loop
     [repeat 3
       [forward 1
         if (terrain = "plain") [set terrain "road"]
         ask (patches in-radius 1) [set boundary "yyyy"]
       ]
       forward 1
       if (terrain = "plain") [set terrain "road"]
       ask (patches in-radius 1) [set boundary "yyyy"]
       if ((any? (ring-points in-radius 2))) [stop]
       ]
     ]
    
   ]
  ask helpers
  [die]
end


;;to create ringways and define ringways boundary (inner1)

to create-ringways1
 create-ring1-points 30
  [
    hide-turtle
    set color red
    set size 10]
  layout-circle sort   ring1-points int (max-pxcor / 2.5)
  ask ring1-points
  [forward int (((random (max-pxcor / 15) - (max-pxcor / 30))) * patch-unit) 
    ;; to create random-like ringways (inner1)
    ]
  ask ring1-points 
  [move-to patch-here] 
  
 let bestart1 (min [who] of ring1-points)
 let endest1 (max [who] of ring1-points)
 
  ask ring1-point endest1
  [hatch-helpers 1
    [
      hide-turtle
      set color gray
      set size (50 * patch-unit)
      ask patch-here 
      [set terrain "road"]]
    ask patches in-radius 2
      [set terrain "road"
        set boundary "yyy"]
     ]
  
  let hh1 (bestart1 - 1)
  repeat 30
  [set hh1 hh1 + 1
   ask helpers
   [pendown    
    face (ring1-point hh1)
    loop
     [repeat 3
       [forward 1
         if (terrain = "plain") [set terrain "road"]
         ask (patches in-radius 1) [set boundary "yyy"]
        ]
       forward 1
       if (terrain = "plain") [set terrain "road"]
       ask (patches in-radius 1) [set boundary "yyy"]
       if ((any? (ring1-points in-radius 2))) [stop]
       ]
     ]
  
   ]
  ask helpers
  [die] 
end


;;to create ringways and define ringways boundary (inner2)

to create-ringways2
  create-ring2-points 20
  [
    hide-turtle
    set color red
    set size (10 * patch-unit)]
  layout-circle sort   ring2-points int (max-pxcor / 4)
  ask ring2-points
  [forward int (((random (max-pxcor / 20) - (max-pxcor / 40))) * patch-unit) 
    ;; to create random-like ringways (inner2)
    ]
  ask ring2-points 
  [move-to patch-here] 
  
 let bestart2 (min [who] of ring2-points)
 let endest2 (max [who] of ring2-points)
 
  ask ring2-point endest2
  [hatch-helpers 1
    [
      hide-turtle
      set color gray
      set size 50
      ask patch-here 
      [set terrain "road"]]
    ask patches in-radius 2
      [set terrain "road"
        set boundary "yy"]
     ]
  
  let hh2 (bestart2 - 1)
  repeat 20
  [set hh2 hh2 + 1
   ask helpers
   [pendown    
    face (ring2-point hh2)
    loop
     [repeat 3
       [forward 1
         if (terrain = "plain") [set terrain "road"]
       ask (patches in-radius 1) [set boundary "yy"]]
       forward 1
       if (terrain = "plain") [set terrain "road"]
       ask (patches in-radius 1) [set boundary "yy"]
       if ((any? (ring2-points in-radius 2))) [stop]
       ]
     ]
  
   ]
  ask helpers
  [die] 
end

;;to create ringways and define ringways boundary (inner3)

to create-ringways3
  create-ring3-points 10
  [
    hide-turtle
    set color red
    set size (10 * patch-unit)]
  layout-circle sort   ring3-points int (max-pxcor / 8)
  ask ring3-points
  [forward int (((random (max-pxcor / 25) - (max-pxcor / 50))) * patch-unit) 
    ; to create random-like ringways (inner2)
    ]
  ask ring3-points 
  [move-to patch-here] 
  
 let bestart3 (min [who] of ring3-points)
 let endest3 (max [who] of ring3-points)
 
  ask ring3-point endest3
  [hatch-helpers 1
    [
      hide-turtle
      set color gray
      set size (50 * patch-unit)
      ask patch-here 
      [set terrain "road"]]
    ask patches in-radius 2
      [set terrain "road"
        set boundary "y"]
     ]
  
  let hh3 (bestart3 - 1)
  repeat 10
  [set hh3 hh3 + 1
   ask helpers
   [pendown    
    face (ring3-point hh3)
    loop
     [repeat 3
       [forward 1
         if (terrain = "plain") [set terrain "road"]
         ask (patches in-radius 1) [set boundary "y"]
        ]
       forward 1
       if (terrain = "plain") [set terrain "road"]
       ask (patches in-radius 1) [set boundary "y"]
       if ((any? (ring3-points in-radius 2))) [stop]
       ]
     ]
  
   ]
  ask helpers
  [die] 
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to create-cloverleaf
  let nn 0
  if cloverleaf-number = "high"
  [set nn (random 3) + 5]
  if cloverleaf-number = "medium"
  [set nn (random 3) + 3]
  if cloverleaf-number = "low"
  [set nn (random 3) + 1]
  
  let new0 (min [who] of ring-points)
  repeat nn
  [ask ring-point new0
    [hatch-junct-creators 1
      [show-turtle
        set shape "junct"
        set color gray
        set size (20 * patch-unit)]
      ]
    set new0 (new0 + int (30 / nn))
  ]
  
  let mim (min [who] of junct-creators)
  let mam (max [who] of junct-creators)
 
  loop 
  [ask junct-creator mim
    [
     hatch-junct-creators 1
       [
         pen-down
         while [(abs ([pxcor] of patch-here) < max-pxcor) and (abs ([pycor] of patch-here) < max-pycor)]
         [if ((random 10) > 8)
           [left ((random 20) - 10)] 
           forward 1
           ask patch-here
           [if (terrain = "plain")[set terrain "road"]]
           ]
          die
        ]
    ]
    set mim mim + 1
    if (mim > mam) 
    [stop]    
   ]
end  

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to create-road
  
  
  let minr3 (min [who] of ring3-points)
  let maxr3 (max [who] of ring3-points)
  
  ;;;; starting point  vertical
  ask ring3-point minr3
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
     face ring3-point (minr3 + 5)
     ]
    
   ask helpers
   [repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]]
     loop
    [forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
     if ([boundary] of patch-here) = "y" [stop]
     ]
    ]
     ask helpers [die]
   ]
  
;;;; second point  vertical
  ask ring3-point (minr3 + 1)
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
     face ring3-point (minr3 + 4)
     ]
    
   ask helpers
   [repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]]
     loop
    [forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
     if ([boundary] of patch-here) = "y" [stop]
     ]
    ]
     ask helpers [die]
   ]
  
 ;;;; third point  vertical
  ask ring3-point (maxr3)
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
     face ring3-point (maxr3 - 3)
     ]
    
   ask helpers
   [repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]]
     loop
    [forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
     if ([boundary] of patch-here) = "y" [stop]
     ]
    ]
     ask helpers [die]
   ] 
;;;; starting point  horizontal
  ask ring3-point (maxr3 - 1)
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
     face ring3-point (minr3 + 2)
     ]
    
   ask helpers
   [repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]]
     loop
    [forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
     if ([boundary] of patch-here) = "y" [stop]
     ]
    ]
     ask helpers [die]
   ]
;;;; second point  horizontal  
 ask ring3-point (maxr3 - 2)
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
     face ring3-point (minr3 + 3)
     ]
    
   ask helpers
   [repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]]
     loop
    [forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
     if ([boundary] of patch-here) = "y" [stop]
     ]
    ]
     ask helpers [die]
   ]
    
;;;; radiant road from ring3 
ask ring3-points
[ifelse (any? (patches with [(terrain = "hill") or (terrain = "lake")]) in-radius 5)
  [ ]
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
    repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]] 
    loop
    [if (random 10 > 3) [right (random 20) - 10]
      forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
      if ([boundary] of patch-here) = "yy" [stop]
      ]   
     ]
   ]
 ask helpers 
 [die]
 ]

;;;; radiant road from ring2 
let gap 0
  if road-density = "high"
  [set gap 1]
  if road-density = "medium"
  [set gap 2]
  if road-density = "low"
  [set gap 3]

  let minr2 (min [who] of ring2-points)
  let maxr2 (max [who] of ring2-points)
 
loop
[ask ring2-point minr2
[ifelse (any? (patches with [(terrain = "hill") or (terrain = "lake")]) in-radius 5)
  [ ]
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
    repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]] 
    loop
    [if (random 10 > 3) [right (random 20) - 10]
      forward 1
      ask patch-here
      [if (terrain = "plain") [set terrain "road"]]
      if ([boundary] of patch-here) = "yyy" [stop]
      ]   
     ]
   ]
 ask helpers 
 [die]
 ]
set minr2 (minr2 + gap)
if (minr2 >= maxr2) [stop]
]
end

 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; radiant road from ring1  

to create-road-1
  let gap 0
  if road-density = "high"
  [set gap 1]
  if road-density = "medium"
  [set gap 2]
  if road-density = "low"
  [set gap 3]
  
let minr1 (min [who] of ring1-points)
let maxr1 (max [who] of ring1-points) 

loop
[ask ring1-point minr1
 [ifelse (any? (patches with [(terrain = "hill") or (terrain = "lake")]) in-radius 5)
  [ ]
  [hatch-helpers 1
    [set color gray
     set size (20 * patch-unit)
     pen-down
    repeat 5
     [forward 1
       if (terrain = "plain") [set terrain "road"]] 
    loop
    [if (random 10 > 5) [right (random 20) - 10]
      forward 1
      ask patch-here
       [if (terrain = "plain") [set terrain "road"]]
      if ([boundary] of patch-here) = "yyyy" [stop]
      ]   
     ]
   ]
 ask helpers [die]
 ]
set minr1 (minr1 + gap + 1)
if (minr1 >= maxr1) [stop]
]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; underground
to create-underground
  create-sub-creator0s 1
    [ hide-turtle
      set color red
      set size (10 * patch-unit)
      set shape "sub-creator"
      hatch-sub-stations 1 [set shape "sub-station"
        set hidden? false]
      ]
        
  if subway-number = "none" 
   [ask sub-stations [die]]
   
  if subway-number = "low"
   [let step 0
     repeat 4
     [ask sub-creator0s
       [hatch-sub-creator1s 1
         [pen-down
           set heading (90 * step)
           repeat ((random 2) + 5)
           [forward (max-pxcor / 10 )
             if ((terrain != "hill") and (terrain != "lake"))
             [hatch-sub-stations 1 [set hidden? false
                 set shape "sub-station"]
               ]
             ]
           ]
         ]
       set step (step + 1)]
     ] 
  if subway-number = "medium"
   [let step 0
     repeat 8
     [ask sub-creator0s
       [hatch-sub-creator1s 1
         [pen-down
           set heading (45 * step)
           repeat ((random 2) + 5)
           [forward (max-pxcor / 10 )
             if ((terrain != "hill") and (terrain != "lake"))
             [hatch-sub-stations 1 [set hidden? false
                 set shape "sub-station"]
               ]
             ]
           ]
         ]
       set step (step + 1)]
      
     ]
  if subway-number = "high";;;to create linear first then circles
   [let step 0
     repeat 8
     [ask sub-creator0s
       [hatch-sub-creator1s 1
         [pen-down
           set heading (45 * step)
           repeat ((random 2) + 5)
           [forward (max-pxcor / 10 )
             if ((terrain != "hill") and (terrain != "lake"))
             [hatch-sub-stations 1 [set hidden? false
                 set shape "sub-station"]
               ]
             ]
           ]
         ]
       set step (step + 1)]
     
     ;;;;;;;; to create underground circle 1;;;;;;;;;;;;;;;;;;;;;;
      ask sub-creator0s
        [hatch-sub-cstation1s 16
          [set hidden? false
            set shape "sub-station"
            layout-circle sort sub-cstation1s ((max-pxcor / 10) * 3)]
          
          
          let mincirn1 (min [who] of sub-cstation1s)
          let maxcirn1 (max [who] of sub-cstation1s) 
          
          ask sub-cstation1 mincirn1
          [create-link-with sub-cstation1 maxcirn1
            [set color red]]
          
          repeat 15
          [ask sub-cstation1 mincirn1
            [create-link-with sub-cstation1 (mincirn1 + 1)
              [set color red]
              ] 
            set mincirn1 (mincirn1 + 1)
            ] 
          ]
        ask sub-cstation1s
          [if ((terrain = "hill") or (terrain = "lake")) [set hidden? true]]
      ;;;;;;;;; to create underground circle 2;;;;;;;;;;;;;;;;;;;;
      ask sub-creator0s
        [hatch-sub-cstation2s 24
          [set hidden? false 
            set shape "sub-station"
            layout-circle sort sub-cstation2s ((max-pxcor / 10) * 5)]

            
          let mincirn2 (min [who] of sub-cstation2s)
          let maxcirn2 (max [who] of sub-cstation2s) 
          
          ask sub-cstation2 mincirn2
          [create-link-with sub-cstation2 maxcirn2
            [set color red]]
          
          repeat 23
          [ask sub-cstation2 mincirn2
            [create-link-with sub-cstation2 (mincirn2 + 1)
              [set color red]
              ] 
            set mincirn2 (mincirn2 + 1)
            ] 
          ]  
         ask sub-cstation2s
          [if ((terrain = "hill") or (terrain = "lake")) [set hidden? true]]
     ]
 end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to create-public-greens
  let green-num 0
  if green-park-number = "high" [set green-num 100]
  if green-park-number = "medium" [set green-num 50]
  if green-park-number = "low" [set green-num 20]
  create-green-parks green-num
   [set hidden? true
     let seed (random 100)
    if seed < 5 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                 ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 56
                     set terrain "green-park"
                   ]
                 ]
    if (seed >= 5 and seed < 25) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 56
                     set terrain "green-park"]
                   ]
                 ]
    if (seed >= 25 and seed < 60) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 ask patches in-radius ((2 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 56
                     set terrain "green-park"]
                   ]
                 ]
    if (seed >= 60 and seed < 95) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 ask patches in-radius ((2 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 56   
                     set terrain "green-park"]
                   ]
                 ]
    if (seed >= 95 and seed <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 ask patches in-radius ((3 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 56
                     set terrain "green-park"]
                   ]
                 ]
    ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-university-etc
  let univ-num 0
  if univ-etc-num = "high" [set univ-num 40]
  if univ-etc-num = "medium" [set univ-num 20]
  if univ-etc-num = "low" [set univ-num 10]
  create-universities univ-num
   [set hidden? true
     set shape "university"
     set size (10 * patch-unit)
     set color white
     let seed1 (random 100)
    if seed1 < 5 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set place-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 25
                     set terrain "university"
                   ]
                 ]
    if (seed1 >= 5 and seed1 < 25) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set place-id "inner-city-district"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 25
                     set terrain "university"]
                   ]
                 ]
    if (seed1 >= 25 and seed1 < 60) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set place-id "outer-city-district"
                 ask patches in-radius ((2 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 25
                     set terrain "university"]
                   ]
                 ]
    if (seed1 >= 60 and seed1 < 98) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 ;set place-id "inner-suburb"
                 let univ (count universities with [place-id = "inner-suburb"])
                 ifelse (univ > 3)
                   [let dec (random 100)
                     if dec < 30 [set place-id "inner-suburb"  ask patches in-radius ((3 + random 3) * patch-unit)
                                [if terrain = "plain" [set pcolor 25  set terrain "university"]]]
                     if dec >= 70 [set place-id "inner-suburb"  move-to one-of other universities with [place-id = "inner-suburb"]
                                    loop [forward (5 * patch-unit)  set heading (random 360) 
                                          if ((urban-area = "inner-suburb") and (terrain = "plain") 
                                           and (any? (patches with [terrain = "university"] in-radius (20 * patch-unit))))
                                          [ask patches in-radius ((3 + random 3) * patch-unit) [if terrain = "plain" 
                                              [set pcolor 25  set terrain "university"]]
                                               stop]
                                          ]
                                     
                                    ]
                     ]
                   [ask patches in-radius ((3 + random 3) * patch-unit) [if terrain = "plain" [set pcolor 25  set terrain "university" ]]]
                 ]
    if (seed1 >= 98 and seed1 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set place-id "outer-suburb"
                 ask patches in-radius ((2 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 25
                     set terrain "university"]
                   ]
                 ]
    ]
  
    
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to create-industrial-park
  let indpark-num 0
  if ind-park-num = "high" [set indpark-num 20]
  if ind-park-num = "medium" [set indpark-num 10]
  if ind-park-num = "low" [set indpark-num 5]
  if ind-park-num = "none" [set indpark-num 0]
  create-ind-parks indpark-num
   [set hidden? true
     set shape "flag"
     set size (10 * patch-unit)
     set color 15
     let seed2 (random 100)
    if seed2 < 0 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set area-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 36
                     set terrain "ind-park"
                   ]
                 ]
    if (seed2 >= 0 and seed2 < 25) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set area-id "inner-city-district"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 36
                     set terrain "ind-park"]
                   ]
                 ]
    if (seed2 >= 25 and seed2 < 75) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set area-id "outer-city-district"
                 ask patches in-radius ((3 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 36
                     set terrain "ind-park"]
                   ]
                 ]
    if (seed2 >= 75 and seed2 <= 99) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 set area-id "inner-suburb"
                 ask patches in-radius ((4 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 36
                     set terrain "ind-park"]
                   ]
                 ]
    if (seed2 > 99 and seed2 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set area-id "outer-suburb"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 36
                     set terrain "ind-park"]
                   ]
                 ]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-old-factory
  let old-fact 0
  if old-factory-num = "high" [set old-fact 20]
  if old-factory-num = "medium" [set old-fact 10]
  if old-factory-num = "low" [set old-fact 5]
  if old-factory-num = "none" [set old-fact 0]
  create-derelict-factories old-fact
   [set hidden? true
     set shape "oldfactory"
     set size (10 * patch-unit)
     set color 26
     let seed3 (random 100)
    if seed3 < 0 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set site-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 6
                     set terrain "derelict-factory"
                   ]
                 ]
    if (seed3 >= 0 and seed3 < 25) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set site-id "inner-city-district"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 6
                     set terrain "derelict-factory"]
                   ]
                 ]
    if (seed3 >= 25 and seed3 < 75) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set site-id "outer-city-district"
                 ask patches in-radius ((3 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 6
                     set terrain "derelict-factory"]
                   ]
                 ]
    if (seed3 >= 75 and seed3 <= 99) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 set site-id "inner-suburb"
                 ask patches in-radius ((4 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 6
                     set terrain "derelict-factory"]
                   ]
                 ]
    if (seed3 > 99 and seed3 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set site-id "outer-suburb"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 6
                     set terrain "derelict-factory"]
                   ]
                 ]
    ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-old-illegal-building
  let old-building 0
  if old-housing-num = "high" [set old-building 50]
  if old-housing-num = "medium" [set old-building 30]
  if old-housing-num = "low" [set old-building 10]
  if old-housing-num = "none" [set old-building 0]
  create-old-illegal-housings old-building
   [set hidden? true
     set shape "house"
     set size (10 * patch-unit)
     set color 46
     let seed4 (random 100)
    if seed4 < 5 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set oldhousing-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 46
                     set terrain "oldorillegal-housing"
                   ]
                 ]
    if (seed4 >= 5 and seed4 < 45) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set oldhousing-id "inner-city-district"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 46
                     set terrain "oldorillegal-housing"]
                   ]
                 ]
    if (seed4 >= 45 and seed4 < 85) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set oldhousing-id "outer-city-district"
                 ask patches in-radius ((3 + random 3) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 46
                     set terrain "oldorillegal-housing"]
                   ]
                 ]
    if (seed4 >= 85 and seed4 <= 95) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 set oldhousing-id "inner-suburb"
                 ask patches in-radius ((2 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 46
                     set terrain "oldorillegal-housing"]
                   ]
                 ]
    if (seed4 > 95 and seed4 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set oldhousing-id "outer-suburb"
                 ask patches in-radius ((1 + random 2) * patch-unit)
                 [if terrain = "plain" 
                   [set pcolor 46
                     set terrain "oldorillegal-housing"]
                   ]
                 ]
    ]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-dailyshopping
  let shopping-num 0
  if dailyshopping = "high" [set shopping-num 50]
  if dailyshopping = "medium" [set shopping-num 30]
  if dailyshopping = "low" [set shopping-num 20]
  if dailyshopping = "none" [set shopping-num 0]
  create-shoppingmalls shopping-num
  [;set hidden? true
     set shape "box"
     set size (5 * patch-unit)
     set color red
     let seed5 (random 100)
    if seed5 < 10 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set mall-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor red
                     set terrain "shoppingmall"
                   ]
                 ]
    if (seed5 >= 10 and seed5 < 35) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set mall-id "inner-city-district"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor red
                     set terrain "shoppingmall"]
                   ]
                 ]
    if (seed5 >= 35 and seed5 < 75) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set mall-id "outer-city-district"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor red
                     set terrain "shoppingmall"]
                   ]
                 ]
    if (seed5 >= 75 and seed5 <= 99) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 set mall-id "inner-suburb"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor red
                     set terrain "shoppingmall"]
                   ]
                 ]
    if (seed5 > 99 and seed5 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set mall-id "outer-suburb"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor red
                     set terrain "shoppingmall"]
                   ]
                 ]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-culture-facility
  let culture 0
  if culture-num = "high" [set culture 30]
  if culture-num = "medium" [set culture 20]
  if culture-num = "low" [set culture 10]
  if culture-num = "none" [set culture 0]
  create-cul-facilities culture
  [;set hidden? true
     set shape "leaf"
     set size (10 * patch-unit)
     set color 125 
     let seed6 (random 100)
    if seed6 < 10 [move-to one-of patches with [(urban-area = "CBD") and (terrain = "plain")]
                  set culture-id "CBD"
                  ask patch-here
                 [;if terrain = "plain" 
                   set pcolor 125
                     set terrain "culture"
                   ]
                 ]
    if (seed6 >= 10 and seed6 < 50) [move-to one-of patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
                 set culture-id "inner-city-district"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor 125
                     set terrain "culture"]
                   ]
                 ]
    if (seed6 >= 50 and seed6 < 80) [move-to one-of patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
                 set culture-id "outer-city-district"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor 125
                     set terrain "culture"]
                   ]
                 ]
    if (seed6 >= 80 and seed6 <= 99) [move-to one-of patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
                 set culture-id "inner-suburb"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor 125
                     set terrain "culture"]
                   ]
                 ]
    if (seed6 > 99 and seed6 <= 100) [move-to one-of patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
                 set culture-id "outer-suburb"
                 ask patches in-radius 1
                 [if terrain = "plain" 
                   [set pcolor 125
                     set terrain "culture"]
                   ]
                 ]
    ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to create-subhousing
  let subhouse-num 0
  if suburban-housing = "high" [set subhouse-num 30]
  if suburban-housing = "medium" [set subhouse-num 20]
  if suburban-housing = "low" [set subhouse-num 10]
  if suburban-housing = "none" [set subhouse-num 0]
  repeat subhouse-num
  [ask one-of patches with [(urban-area = "inner-suburb" or urban-area = "outer-suburb") and terrain = "road" ]
  [sprout-subhouses 1
    [set hidden? true
      set shape "house"      
      set size (10 * patch-unit)
      set color 46
      right ((random 180) - 90)
      forward ((10 + random 5) * patch-unit)
      ask patches in-radius ((2 + random 3) * patch-unit)
      [if terrain = "plain" 
       [set pcolor 44
        set terrain "subhousing"]
        ]
      ]
    ]
  ] 
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to define-farmland
 
  ask patches with [(urban-area = "outer-suburb") and (terrain = "plain")]
  [set terrain "farmland" ;set pcolor 5
    ]  
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to define-constructedland
  ask patches with [(urban-area = "inner-city-district") and (terrain = "plain")]
  [set terrain "constructedland" ;set pcolor 6
    ]
  ask patches with [(urban-area = "outer-city-district") and (terrain = "plain")]
  [set terrain "constructedland" ;set pcolor 6
    ]
  ask patches with [(urban-area = "inner-suburb") and (terrain = "plain")]
  [set terrain "constructedland"  ;set pcolor 6
    ]
  ask patches with [(urban-area = "CBD") and (terrain = "plain")]
  [set terrain "cbdland" ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to setup-landuse-type
  ask patches 
  [if terrain = "hill" [set land-type "hill" set use-possible 0]
    if terrain = "lake" [set land-type "lake" set use-possible 0] 
    if terrain = "river" [set land-type "river" set use-possible 0]
    if terrain = "road" [set land-type "road" set use-possible 1]      
    if terrain = "rail-station" [set land-type "rail-station" set use-possible 0] 
    if terrain = "green-park" [set land-type "green-park" set use-possible 0] 
    if terrain = "ind-park" [set land-type "ind-park" set use-possible 1] 
    if terrain = "derelict-factory" [set land-type "derelict-factory" set use-possible 1] 
    if terrain = "oldorillegal-housing" [set land-type "oldorillegal-housing" set use-possible 1] 
    if terrain = "shoppingmall" [set land-type "shoppingmall" set use-possible 0]
    if terrain = "culture" [set land-type "culture" set use-possible 0]
    if terrain = "university" [set land-type "university" set use-possible 0]
    if terrain = "subhousing" [set land-type "subhousing" set use-possible 1]  
    if terrain = "cbdland" [set land-type "cbdland" set use-possible 1]
    if terrain = "constructedland" [set land-type "constructedland" set use-possible 1]
    if terrain = "farmland" [set land-type "farmland" set use-possible 0] 
    ]
 end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-landfeaturesmark
  ask patches 
  [set basic-mark 1
    set transport-mark 1
    set rapidtrans-mark 1
    set regionaltrans-mark 1
    if urban-area = "CBD" [set environment-mark 1]
    if urban-area = "inner-city-district" [set environment-mark 1.01]
    if urban-area = "outer-city-district" [set environment-mark 1.02]
    if urban-area = "inner-suburb" [set environment-mark 1.03]
    if urban-area = "outer-suburb" [set environment-mark 1.04]
    set shopping-mark 1
    set culture-mark 1
    set talent-mark 1
    set housing-rent 1
    set proximity-mark 1
    set policy-mark 1
    set milieu-mark 1
    set land-rent 1
    
    ]
  calculate-basic-mark
  calculate-transport-mark
  calculate-rapidtrans-mark
  ;;cut-off (calculate-regionaltrans-mark)
  calculate-environment-mark
  calculate-shopping-mark
  calculate-culture-mark
  calculate-milieu-mark
  calculate-talent-mark
  standardize-marks
  calculate-rent ;;to calculate housing-rent and land-rent
end


to calculate-basic-mark
  ask patches
  [if urban-area = "CBD" [set basic-mark 1.1]
    if urban-area = "inner-city-district" [set basic-mark 1.08]
    if urban-area = "outer-city-district" [set basic-mark 1.06]
    if urban-area = "inner-suburb" [set basic-mark 1.04]
    if urban-area = "outer-suburb" [set basic-mark 1.02]
   ]  
end


to calculate-transport-mark
  ask patches with [(land-type = "road") ] ;and (urban-area != "outer-suburb")
  [ ask patches in-radius (4 * patch-unit) [set transport-mark (transport-mark * (1 + 1))]
    ask patches in-radius (8 * patch-unit) [set transport-mark (transport-mark * (1 + (1 / 2)))]
    ask patches in-radius (12 * patch-unit) [set transport-mark (transport-mark * (1 + (1 / 3)))]
    ask patches in-radius (16 * patch-unit) [set transport-mark (transport-mark * (1 + (1 / 4)))]
    ask patches in-radius (20 * patch-unit) [set transport-mark (transport-mark * (1 + (1 / 5)))]
   ]
  ask patches ;; to multiply an discount index to show bus service
  [if (urban-area = "outer-suburb") [set transport-mark transport-mark * 0.8]
   if (urban-area = "inner-suburb") [set transport-mark transport-mark * 0.9]
   if (urban-area = "outer-city-district") [set transport-mark transport-mark * 1.1]
    if (urban-area = "inner-city-district") [set transport-mark transport-mark * 1.2]
   ]
  
 
end  


to calculate-rapidtrans-mark
  let undergroundstations (turtle-set  sub-stations sub-cstation1s sub-cstation2s)
  ask undergroundstations 
  [ask patches in-radius (4 * patch-unit) [set rapidtrans-mark (rapidtrans-mark * (1 + 1))]
    ask patches in-radius (8 * patch-unit) [set rapidtrans-mark (rapidtrans-mark * (1 + (1 / 2)))]
    ask patches in-radius (12 * patch-unit) [set rapidtrans-mark (rapidtrans-mark * (1 + (1 / 3)))]
    ask patches in-radius (16 * patch-unit) [set rapidtrans-mark (rapidtrans-mark * (1 + (1 / 4)))]
    ask patches in-radius (20 * patch-unit) [set rapidtrans-mark (rapidtrans-mark * (1 + (1 / 5)))]
    ]  
end  

;;(cut-off to calculate-regionaltrans-mark)


to calculate-environment-mark
  let environment-patches (patches with [land-type = "hill" or land-type = "lake" or land-type = "river" or land-type = "green-park"])
  ask environment-patches 
  [ ask patches in-radius (4 * patch-unit) [set environment-mark (environment-mark * (1 + 1))]
    ask patches in-radius (8 * patch-unit) [set environment-mark (environment-mark * (1 + (1 / 2)))]
    ask patches in-radius (12 * patch-unit) [set environment-mark (environment-mark * (1 + (1 / 3)))]
    ask patches in-radius (16 * patch-unit) [set environment-mark (environment-mark * (1 + (1 / 4)))]
    ask patches in-radius (20 * patch-unit) [set environment-mark (environment-mark * (1 + (1 / 5)))]
   ]
end  
 
 

to calculate-shopping-mark
  ask patches with [land-type = "shoppingmall"]
  [ ask patches in-radius (4 * patch-unit) [set shopping-mark (shopping-mark * (1 + 1))]
    ask patches in-radius (8 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 2)))]
    ask patches in-radius (12 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 3)))]
    ask patches in-radius (16 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 4)))]
    ask patches in-radius (20 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 5)))]
    ask patches in-radius (24 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 6)))]
    ask patches in-radius (28 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 7)))]
    ask patches in-radius (32 * patch-unit) [set shopping-mark (shopping-mark * (1 + (1 / 8)))]
   ]
end  

  

to calculate-culture-mark
  ask patches with [land-type = "culture" or land-type = "university"]
  [ ask patches in-radius (4 * patch-unit) [set culture-mark (culture-mark * (1 + 1))]
    ask patches in-radius (6 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 2)))]
    ask patches in-radius (8 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 3)))]
    ask patches in-radius (10 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 4)))]
    ask patches in-radius (12 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 5)))]
    ask patches in-radius (14 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 6)))]
    ask patches in-radius (16 * patch-unit) [set culture-mark (culture-mark * (1 + (1 / 7)))]
   ]
end



to calculate-milieu-mark
  ask ind-parks
  [ ask patches in-radius (2 * patch-unit) [set milieu-mark (milieu-mark * (1 + 1))]
    ask patches in-radius (4 * patch-unit) [set milieu-mark (milieu-mark * (1 + (1 / 2)))]
    ask patches in-radius (6 * patch-unit) [set milieu-mark (milieu-mark * (1 + (1 / 3)))]
    ask patches in-radius (8 * patch-unit) [set milieu-mark (milieu-mark * (1 + (1 / 4)))]
   ]

 end



to calculate-talent-mark
  ask ind-parks
  [ ask patches in-radius (2 * patch-unit) [set talent-mark (talent-mark * (1 + 1))]
    ask patches in-radius (4 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 2)))]
    ask patches in-radius (6 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 3)))]
    ask patches in-radius (8 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 4)))]
    ask patches in-radius (10 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 5)))]
    ]

  ask universities 
  [ ask patches in-radius (2 * patch-unit) [set talent-mark (talent-mark * (1 + 1))]
    ask patches in-radius (4 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 2)))]
    ask patches in-radius (6 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 3)))]
    ask patches in-radius (8 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 4)))]
    ask patches in-radius (10 * patch-unit) [set talent-mark (talent-mark * (1 + (1 / 5)))]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to standardize-marks
  
 let biggest01 (max ([transport-mark] of (patches with [transport-mark > 1])))
  ask patches
   [if transport-mark > 1 [set s-transport-mark (1 + ((transport-mark - 1) / (biggest01 - 1)))]
     if transport-mark <= 1 [set s-transport-mark transport-mark]]
   
 let biggest02 (max ([rapidtrans-mark] of patches with [rapidtrans-mark > 1]))
   ask patches
   [if rapidtrans-mark > 1 [set s-rapidtrans-mark (1 + ((rapidtrans-mark - 1) / (biggest02 - 1)))]
     if rapidtrans-mark <= 1 [set s-rapidtrans-mark rapidtrans-mark]]
   
;;cut-off (standardize-marks for regional transport)
   
 let biggest04 (max ([environment-mark] of patches with [environment-mark > 1]))
    ask patches
    [if environment-mark > 1 [set s-environment-mark (1 + ((environment-mark - 1) / (biggest04 - 1)))] 
      if environment-mark <= 1 [set s-environment-mark environment-mark]]
    
  let biggest05 (max ([shopping-mark] of patches with [shopping-mark > 1]))
   ask patches
   [if shopping-mark > 1 [set s-shopping-mark (1 + ((shopping-mark - 1) / (biggest05 - 1)))]
     if shopping-mark <= 1 [set s-shopping-mark shopping-mark]]
      
  let biggest06 (max ([culture-mark] of (patches with [culture-mark > 1])))
   ask patches
   [if culture-mark > 1 [set s-culture-mark (1 + ((culture-mark - 1) / (biggest06 - 1)))]
     if culture-mark <= 1 [set s-culture-mark culture-mark]]
       
  let biggest07 (max ([milieu-mark] of patches with [milieu-mark > 1]))
   ask patches
   [if milieu-mark > 1 [set s-milieu-mark (1 + ((milieu-mark - 1) / (biggest07 - 1)))]
     if milieu-mark <= 1 [set s-milieu-mark milieu-mark]]
    
  let biggest08 (max ([talent-mark] of patches with [talent-mark > 1]))
   ask patches 
   [if talent-mark > 1 [set s-talent-mark (1 + ((talent-mark - 1) / (biggest08 - 1)))]
    if talent-mark <= 1 [set s-talent-mark talent-mark]]
  
  let biggest09 (max ([proximity-mark] of patches))
  ask patches 
  [if proximity-mark > 1 [set s-proximity-mark (1 + ((proximity-mark - 1) / (biggest09 - 1)))]
    if proximity-mark <= 1 [set s-proximity-mark proximity-mark]]    
   
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-rent
   ask patches 
   [let calculate1 ((((s-transport-mark + s-rapidtrans-mark) / 2) * 4) + (s-shopping-mark * 3) 
       + (s-environment-mark * 2) + s-culture-mark + basic-mark) 
     set s-housing-rent (calculate1 / (4 + 3 + 2 + 1 + 1))
     set housing-rent (calculate1 * 2.5) 
    
        ;;roughly, the basic lowest price for 1 square metre per month is 40 yuan.
     
    let calculate2 ((s-transport-mark * 6) + (s-rapidtrans-mark * 5) + (s-milieu-mark * 4) + (s-proximity-mark * 3) 
       + (s-talent-mark * 2) + s-environment-mark  + basic-mark)
    set s-land-rent (calculate2 / (6 + 5 + 4 + 3 + 2 + 1 + 1));; roughly, basic rent per square metre per month for firms are 2 - 3 times the rent for workers' housing
    set land-rent (calculate2 * 3.5)
    set land-rent-after-policy land-rent
    ]
   
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-buildingquality;; it will be used to evaluate the possibility for government to renew an area or  
  ;to calculate the CIs and CWs utility function
  ask patches with [use-possible = 1]
  [if land-type = "road" [set building-quality 1]
    if land-type = "ind-park" [set building-quality 1]
    if land-type = "oldorillegal-housing" [set building-quality ((random 5) / 10)]
    if land-type = "derelict-factory" [set building-quality ((random 5) / 10)]
    if land-type = "subhousing" [set building-quality 1]
    if land-type = "cbdland" [set building-quality 1]
    if land-type = "constructedland" [set building-quality ((random 10) / 10)]
    if land-type = "farmland" [set building-quality 0]  
  ]
  ask patches with [use-possible = 0]
  [set building-quality 0] ;; for calculation reseason, to prevent using of these plots
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-policy
  ask patches [set tax-reduction-rate 0]
  if policy-support = "none" [set support-number 0]
  if policy-support = "low" [set support-number 10]
  if policy-support = "medium" [set support-number 20]
  if policy-support = "high" [set support-number 30]
  
  create-UGs support-number
  [ setup-policy-turtle-property
    setup-policy-package
    setup-policy-distribution
    setup-policy-influence-plot
    set real-time-in-service 1;; policy has been in place for 1 turn
    ]
     
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-patch-volume-property
  ask patches with [use-possible = 0] 
  [set f-max-volume 0 set f-real-volume 0 set w-max-volume 0 set w-real-volume 0]
  
  ask patches with [use-possible = 1]
  [if land-type = "cbdland" 
    [set f-max-volume 20000 set f-real-volume 0 set w-max-volume 15000 set w-real-volume 0]
   if urban-area = "inner-city-district"
   [ifelse land-type = "road"  
     [set f-max-volume 10000 set f-real-volume 0 set w-max-volume 8000 set w-real-volume 0]
     [set f-max-volume 15000 set f-real-volume 0 set w-max-volume 12000 set w-real-volume 0]
     ]
   if urban-area = "outer-city-district"
   [ifelse land-type = "road"  
     [set f-max-volume 7500 set f-real-volume 0 set w-max-volume 6000 set w-real-volume 0]
     [set f-max-volume 12500 set f-real-volume 0 set w-max-volume 10000 set w-real-volume 0]
     ]
   if urban-area = "inner-suburb"
   [ifelse land-type = "road"  
     [set f-max-volume 5000 set f-real-volume 0 set w-max-volume 4000 set w-real-volume 0]
     [set f-max-volume 10000 set f-real-volume 0 set w-max-volume 7500 set w-real-volume 0]
     ]
   if urban-area = "outer-suburb"
   [ifelse land-type = "road"  
     [set f-max-volume 2500 set f-real-volume 0 set w-max-volume 2000 set w-real-volume 0]
     [set f-max-volume 5000 set f-real-volume 0 set w-max-volume 5000 set w-real-volume 0]
     ]
  ]
   
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-firms
  set-default-shape CIs "dot"
  create-CIs initial-number-firm
  [set hidden? true
    set color white
    set size 3
    setup-firm-originalweight
    setup-firm-property
    calculate-f-weight
    find-office    
  ]
 
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-workers
  set-default-shape CWs "person"
  create-CWs initial-number-CW
  [set hidden? true
   set color gray
   set size 1
   set about-to-move 0
   setup-worker-originalweight
   setup-worker-property
   calculate-w-weight
   find-housing
   find-job   
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-firm-originalweight
    set mark1 1
    set mark2 1
    set mark3 1
    set mark4 1
    set mark5 1
    set mark6 1
    set mark7 1
    set mark8 1  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-worker-originalweight
    set grade1 1
    set grade2 1
    set grade3 1
    set grade4 1
    set grade5 1  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-firm-property
  set got-land-or-not 0
  set off-land-time 0
  set expected-size (int (random-normal 93 176))
    if expected-size <= 5 [set expected-size 5] ;;minium size is 5
    if expected-size >= 1200 [set expected-size 1200];; maximum size is 1200
  set real-size 0
  set wage (int (random-normal 6879 10266))
    if ((expected-size < 10) and (wage > 10000)) [set wage 10000]
    if ((expected-size > 300) and (wage < 1000)) [set wage 1000]
    if (wage > 40000) [set wage 40000]
    if (wage < 1000) [set wage 1000]
  set capital (expected-size * 15 * 75 * 12)
  ;; we assume the base price per square meter per month is 75 yuan. each worker needs 15 m2
  ;; we assume a company's original capital can pay the land-rent for a year if it cannot make any profit.
  set tax-percent b-tax-rate
  
  set CI-utility 0
  set output 0
  set total-wagepaid 0
  
  
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to setup-worker-property
  set got-job-or-not 0
  set off-job-time 0
  set got-housing-or-not 0
  set off-home-time 0
  set housing-area (int (random-normal 26 15))
    if housing-area < 10 [set housing-area 10]
    if housing-area > 60 [set housing-area 60]
  set CW-utility 0
  set expected-income (int (random-normal 6879 10266))
    if (expected-income > 40000) [set expected-income 40000]
    if (expected-income < 1000) [set expected-income 1000]
  set real-income 0
  set capability (expected-income * (1 + (random 11) / 10 ));; we suppose average individual productivity (in value) is 1 -2 the expected-income.
  set company-id "none"
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-f-weight
  let f-decider1 (random 100)
       if f-decider1 >= 0 and f-decider1 < 36 [set mark1 mark1 * 1.5 ]
       if (f-decider1 >= 36 and f-decider1 < 42) [set mark1 mark1 * 1.4]
       if (f-decider1 >= 42 and f-decider1 < 49) [set mark1 mark1 * 1.3]
       if (f-decider1 >= 49 and f-decider1 < 55) [set mark1 mark1 * 1.2]
       if (f-decider1 >= 55 and f-decider1 < 62) [set mark1 mark1 * 1.1]
       if (f-decider1 >= 62 and f-decider1 < 100) [set mark1 mark1 * 1.0]
       
   let f-decider2 (random 100)
       if f-decider2 >= 0 and f-decider2 < 21 [set mark2 mark2 * 1.5]
       if (f-decider2 >= 21 and f-decider2 < 30) [set mark2 mark2 * 1.4]
       if (f-decider2 >= 30 and f-decider2  < 39) [set mark2 mark2 * 1.3]
       if (f-decider2 >= 39 and f-decider2  < 42) [set mark2 mark2 * 1.2]
       if (f-decider2 >= 42 and f-decider2  < 55) [set mark2 mark2 * 1.1]
       if (f-decider2 >= 55 and f-decider2  < 100) [set mark2 mark2 * 1.0]
       
    let f-decider3 (random 100)
       if f-decider3 >= 0 and f-decider3 < 5 [set mark3 mark3 * 1.5]
       if (f-decider3 >= 5 and f-decider3 < 20) [set mark3 mark3 * 1.4]
       if (f-decider3 >= 20 and f-decider3 < 30) [set mark3 mark3 * 1.3]
       if (f-decider3 >= 30 and f-decider3 < 40) [set mark3 mark3 * 1.2]
       if (f-decider3 >= 40 and f-decider3 < 50) [set mark3 mark3 * 1.1]
       if (f-decider3 >= 50 and f-decider3 < 100) [set mark3 mark3 * 1.0]
       
    let f-decider4 (random 100)
       if f-decider4 >= 0 and f-decider4 < 10 [set mark4 mark4 * 1.5]
       if (f-decider4 >= 10 and f-decider4 < 20) [set mark4 mark4 * 1.4]
       if (f-decider4 >= 20 and f-decider4 < 29) [set mark4 mark4 * 1.3]
       if (f-decider4 >= 29 and f-decider4 < 38) [set mark4 mark4 * 1.2]
       if (f-decider4 >= 38 and f-decider4 < 42) [set mark4 mark4 * 1.1]
       if (f-decider4 >= 42 and f-decider4 < 100) [set mark4 mark4 * 1.0]
       
    let f-decider5 (random 100)
       if f-decider5 >= 0 and f-decider5 < 8 [set mark5 mark5 * 1.5]
       if (f-decider5 >= 8 and f-decider5 < 23) [set mark5 mark5 * 1.4]
       if (f-decider5 >= 23 and f-decider5 < 30) [set mark5 mark5 * 1.3]
       if (f-decider5 >= 30 and f-decider5 < 34) [set mark5 mark5 * 1.2]
       if (f-decider5 >= 34 and f-decider5 < 37) [set mark5 mark5 * 1.1]
       if (f-decider4 >= 37 and f-decider4 < 100) [set mark5 mark5 * 1.0]
       
    let f-decider6 (random 100)
       if f-decider6 >= 0 and f-decider6 < 3 [set mark6 mark6 * 1.5]
       if (f-decider6 >= 3 and f-decider6 < 17) [set mark6 mark6 * 1.4]
       if (f-decider6 >= 17 and f-decider6 < 29) [set mark6 mark6 * 1.3]
       if (f-decider6 >= 29 and f-decider6 < 33) [set mark6 mark6 * 1.2]
       if (f-decider6 >= 33 and f-decider6 < 37) [set mark6 mark6 * 1.1]
       if (f-decider4 >= 37 and f-decider4 < 100) [set mark6 mark6 * 1.0]
       
    let f-decider7 (random 100)
       if f-decider7 >= 0 and f-decider7 < 8 [set mark7 mark7 * 1.5]
       if (f-decider7 >= 8 and f-decider7 < 11) [set mark7 mark7 * 1.4]
       if (f-decider7 >= 11 and f-decider7 < 20) [set mark7 mark7 * 1.3]
       if (f-decider7 >= 20 and f-decider7 < 36) [set mark7 mark7 * 1.2]
       if (f-decider7 >= 36 and f-decider7 < 40) [set mark7 mark7 * 1.1]
       if (f-decider4 >= 40 and f-decider4 < 100) [set mark7 mark7 * 1.0]
       
    let f-decider8 (random 100)
       if f-decider8 >= 0 and f-decider8 < 2 [set mark8 mark8 * 1.5]
       if (f-decider8 >= 2 and f-decider8 < 11) [set mark8 mark8 * 1.4]
       if (f-decider8 >= 11 and f-decider8 < 23) [set mark8 mark8 * 1.3]
       if (f-decider8 >= 23 and f-decider8 < 36) [set mark8 mark8 * 1.2]
       if (f-decider8 >= 36 and f-decider8 < 39) [set mark8 mark8 * 1.1]
       if (f-decider4 >= 39 and f-decider4 < 100) [set mark8 mark8 * 1.0]
       
    set mark1 (mark1 * (1 + (42 / 68))) 
    set mark2 (mark2 * (1 + (37 / 68))) 
    set mark3 (mark3 * (1 + (34 / 68))) 
    set mark4 (mark4 * (1 + (28 / 68))) 
    set mark5 (mark5 * (1 + (25 / 68))) 
    set mark6 (mark6 * (1 + (25 / 68))) 
    set mark7 (mark7 * (1 + (27 / 68))) 
    set mark8 (mark8 * (1 + (26 / 68)))     
  
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-w-weight
  let w-decider1 (random 100)
   if (w-decider1 >= 0 and w-decider1 < 59) [set grade1 grade1 * 1.1]
   if (w-decider1 >= 59 and w-decider1 < 100) [set grade1 grade1 * 1.0]
   
   let w-decider2 (random 100)
   if (w-decider2 >= 0 and w-decider2 < 42) [set grade2 grade2 * 1.1]
   if (w-decider2 >= 42 and w-decider2 < 100) [set grade2 grade2 * 1.0]
   
   
   let w-decider3 (random 100)
   if (w-decider3 >= 0 and w-decider3 < 41) [set grade3 grade3 * 1.1]
   if (w-decider3 >= 41 and w-decider3 < 100) [set grade3 grade3 * 1.0]
   
   
   let w-decider4 (random 100)
   if (w-decider4 >= 0 and w-decider4 < 32) [set grade4 grade4 * 1.1]
   if (w-decider4 >= 32 and w-decider4 < 100) [set grade4 grade4 * 1.0]
   
   
   let w-decider5 (random 100)
   if (w-decider5 >= 0 and w-decider5 < 13) [set grade5 grade5 * 1.1]
   if (w-decider5 >= 13 and w-decider5 < 100) [set grade5 grade5 * 1.0]
   
   set grade1 (grade1 * (1 + (183 / 310))) 
   set grade2 (grade2 * (1 + (130 / 310))) 
   set grade3 (grade3 * (1 + (126 / 310))) 
   set grade4 (grade4 * (1 + (98 / 310))) 
   set grade5 (grade5 * (1 + (41 / 310)))   
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
to find-office
  ifelse (real-size != 0)
  [let f-sizebehalf (expected-size * 15);; we assume office area per worker is 15 square metres
    let wage-decider wage
    let f-possible-plots (patches with [(use-possible = 1) and ((any? CWs-here) = false) and 
      ((f-real-volume + f-sizebehalf) < f-max-volume) and (wage-decider > land-rent) and land-type != "subhousing"])
    let f-decider (count f-possible-plots)
    ifelse (f-decider <= 0 ) 
     [set hidden? false set got-land-or-not 1  set off-land-time 0]
     [ifelse (f-decider < maxtimes-officesearching ) 
       [set f-targeted-plots f-possible-plots]
       [set f-targeted-plots n-of maxtimes-officesearching f-possible-plots]
     ]
     
       let f-mark1 mark1
       let f-mark2 mark2
       let f-mark3 mark3
       let f-mark4 mark4
       let f-mark5 mark5
       let f-mark6 mark6
       let f-mark7 mark7
       let f-mark8 mark8
        
       ask f-targeted-plots
       [let f-utility1 (f-mark1 * policy-mark)
        let f-utility2 (f-mark2 * s-transport-mark)
        let f-utility3 (f-mark3 * s-rapidtrans-mark)
        let f-utility4 (f-mark4 * s-milieu-mark)
        let f-utility5 (f-mark5 * s-proximity-mark)
        let f-utility6 (f-mark6 * s-land-rent)
        let f-utility7 (f-mark7 * s-talent-mark)
        let f-utility8 (f-mark8 * s-environment-mark)
        set firm-utility ((f-utility1 + f-utility2 + f-utility3 + f-utility4 + f-utility5 + f-utility7 + f-utility8) -  f-utility6 ) * building-quality;
        if (firm-utility < 0) [set firm-utility 0]
         ]
       let f-best-plot max-one-of f-targeted-plots [firm-utility]
       ifelse (([firm-utility] of f-best-plot) > CI-utility)
       ;; if the candidate is not better, then remain where it is
       [ f-decrease-building-quality
         decrease-land-rent
         decrease-proximity-mark
         decrease-milieu-mark
         set f-real-volume (f-real-volume - (expected-size * 15));; 15 square metre per worker
         if f-real-volume < 0 [set f-real-volume 0] 
          ;; to change the properties of the  original land plot           
         move-to f-best-plot
          set hidden? false;; to control the visibility of CIs
          set CI-utility firm-utility
          f-increase-building-quality
          increase-land-rent
          increase-proximity-mark
          increase-milieu-mark
          set f-real-volume (f-real-volume + (expected-size * 15))  
          set got-land-or-not 1  
          set off-land-time 0
         ]
       [set hidden? false set got-land-or-not 1  set off-land-time 0]
    
    ]
  
  [let f-sizebehalf (expected-size * 15);; we assume office area per worker is 15 square metres
  let wage-decider wage
  let f-possible-plots (patches with [(use-possible = 1) and ((any? CWs-here) = false) and 
      ((f-real-volume + f-sizebehalf) < f-max-volume) and (wage-decider > land-rent) and land-type != "subhousing"])
  let f-decider (count f-possible-plots)
    ifelse (f-decider <= 0 ) 
      [set hidden? true set got-land-or-not 0  set off-land-time (off-land-time + 1)]
      
      [ifelse (f-decider < maxtimes-officesearching ) 
        [set f-targeted-plots f-possible-plots]
        [set f-targeted-plots n-of maxtimes-officesearching f-possible-plots]
   
   
       let f-mark1 mark1
       let f-mark2 mark2
       let f-mark3 mark3
       let f-mark4 mark4
       let f-mark5 mark5
       let f-mark6 mark6
       let f-mark7 mark7
       let f-mark8 mark8
        
       ask f-targeted-plots
       [let f-utility1 (f-mark1 * policy-mark)
        let f-utility2 (f-mark2 * s-transport-mark)
        let f-utility3 (f-mark3 * s-rapidtrans-mark)
        let f-utility4 (f-mark4 * s-milieu-mark)
        let f-utility5 (f-mark5 * s-proximity-mark)
        let f-utility6 (f-mark6 * s-land-rent)
        let f-utility7 (f-mark7 * s-talent-mark)
        let f-utility8 (f-mark8 * s-environment-mark)
        set firm-utility ((f-utility1 + f-utility2 + f-utility3 + f-utility4 + f-utility5 + f-utility7 + f-utility8) -  f-utility6 ) * building-quality;
        if (firm-utility < 0) [set firm-utility 0]
         ]
      let f-best-plot max-one-of f-targeted-plots [firm-utility]
      if (([firm-utility] of f-best-plot) > CI-utility )
        [move-to f-best-plot
          if (f-visibility = 1) [set hidden? false];; to control the visibility of CIs
          set CI-utility firm-utility
          f-increase-building-quality
          increase-land-rent
          increase-proximity-mark
          increase-milieu-mark
          set f-real-volume (f-real-volume + (expected-size * 15))  
          set got-land-or-not 1  
          set off-land-time 0
          ]          
    ]
  ]

end




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
to find-housing
 ifelse (about-to-move = 1);; deal with those who think the housing-rent is too high.
 [ifelse (inheritance? = 1)
   ;; 1 means yes, 0 means no
   [set got-housing-or-not 1 
     set off-home-time 0
     set hidden? false
     set about-to-move 0
      ]         ;;if it is inheritance, let the worker stay where he is
  [let w-housingsizebehalf housing-area
    let max-income-for-housing (real-income / 2)
    let w-possible-plots (patch-set (patches with [(use-possible = 1) and ((any? CIs-here) = false) and (land-type != "farmland") 
      and ((w-real-volume + w-housingsizebehalf) < w-max-volume) and (policy-mark = 1) and (land-type != "ind-park") 
      and (land-type != "derelict-factory") and (urban-area != "outer-suburb") 
      and (housing-rent * w-housingsizebehalf) < max-income-for-housing])
    
      patches with [urban-area = "outer-suburb" and land-type = "subhousing" 
        and (housing-rent * w-housingsizebehalf) < max-income-for-housing]) 
 
      let w-housing-decider (count w-possible-plots)
       
       ifelse (w-housing-decider <= 0) 
       [set got-housing-or-not 1 
        set off-home-time 0
        set hidden? false
        set about-to-move 0]
       
       [set w-real-volume (w-real-volume - housing-area);; influence the w-real-volume
        w-decrease-building-quality
        decrease-housing-rent
        decrease-talent-mark
        decrease-transport-mark          
         ;; before moving, influence the properties of the plot the worker is on
         ifelse (w-housing-decider < maxtimes-housingfinding) 
         [set w-targeted-housings w-possible-plots]
         [set w-targeted-housings n-of maxtimes-housingfinding w-possible-plots]
        ;; to define  the candidate plots for the worker
        
          let w-grade1 grade1
          let w-grade2 grade2
          let w-grade3 grade3
          let w-grade4 grade4
          let w-grade5 grade5
          
        ask w-targeted-housings
          [let w-utility1 (w-grade1 * ((s-transport-mark + s-rapidtrans-mark) / 2))
           let w-utility2 (w-grade2 * s-shopping-mark)
           let w-utility3 (w-grade3 * s-housing-rent)
           let w-utility4 (w-grade4 * s-environment-mark)
           let w-utility5 (w-grade5 * s-culture-mark)
           set worker-utility (( w-utility1 + w-utility2 + w-utility4 + w-utility5) -  w-utility3 )* building-quality 
           if (worker-utility < 0) [set worker-utility 0] 
           ]
          let w-best-plot max-one-of w-targeted-housings [worker-utility]
          move-to w-best-plot
          w-increase-building-quality
          increase-housing-rent
          increase-talent-mark
          increase-transport-mark
          set w-real-volume (w-real-volume + housing-area)
          set got-housing-or-not 1  
          set off-home-time 0
          set inheritance? 0
          set hidden? false;; to control the visibility of CWs
          set CW-utility worker-utility
         ]       
       ]
   ]
 
  
 [let w-housingsizebehalf housing-area
   let max-income-for-housing (expected-income / 2)
   ;; we assume approximately half of the income at most can be used for renting.
     
   let inheritance (random 100)
   ifelse (inheritance  < 15);; deal with inheritance probability 15% based on questionnaire. 
    [let w-possible-plots (patch-set (patches with [(use-possible = 1) and ((any? CIs-here) = false) and (land-type != "farmland") 
      and ((w-real-volume + w-housingsizebehalf) < w-max-volume) and (policy-mark = 1) and (land-type != "ind-park") 
      and (land-type != "derelict-factory") and (urban-area != "outer-suburb")])    
      patches with [urban-area = "outer-suburb" and land-type = "subhousing"])      ;; define the suitable set of patches
      let w-housing-decider (count w-possible-plots)
      ifelse ( w-housing-decider <= 0)
      [set got-housing-or-not 0  
          set off-home-time 1
          set inheritance? 1
          set hidden? true
        ]
      [move-to one-of (w-possible-plots with [urban-area != "outer-suburb"]) 
       calculate-worker-utility set CW-utility worker-utility
        w-increase-building-quality
        increase-housing-rent
        increase-talent-mark
        increase-transport-mark
        set w-real-volume (w-real-volume + housing-area)
       set got-housing-or-not 1 set off-home-time 0 set inheritance? 1  
       set hidden? false;; to control the visibility of CWs
       ]
      ]
         ;;we assume those flats/houses inherited are possibly not in outersuburb.
    
    [let w-possible-plots (patch-set (patches with [(use-possible = 1) and ((any? CIs-here) = false) and (land-type != "farmland") 
      and ((w-real-volume + w-housingsizebehalf) < w-max-volume) and (policy-mark = 1) and (land-type != "ind-park") 
      and (land-type != "derelict-factory") and (urban-area != "outer-suburb") 
      and (housing-rent * w-housingsizebehalf) < max-income-for-housing]);; define the maximum housing rent     
      patches with [urban-area = "outer-suburb" and land-type = "subhousing" 
        and (housing-rent * w-housingsizebehalf) < max-income-for-housing])      ;; define the suitable set of patches
  
      let w-housing-decider (count w-possible-plots)
     ifelse (w-housing-decider <= 0) 
      [set got-housing-or-not 0  set off-home-time (off-home-time + 1) set inheritance? 0   set hidden? true]
      
      [ifelse (w-housing-decider < maxtimes-housingfinding) 
        [set w-targeted-housings w-possible-plots]
        [set w-targeted-housings n-of maxtimes-housingfinding w-possible-plots]
        
          let w-grade1 grade1
          let w-grade2 grade2
          let w-grade3 grade3
          let w-grade4 grade4
          let w-grade5 grade5
          
        ask w-targeted-housings
          [let w-utility1 (w-grade1 * ((s-transport-mark + s-rapidtrans-mark) / 2));(w-grade1 * (s-rapidtrans-mark) )
           let w-utility2 (w-grade2 * s-shopping-mark)
           let w-utility3 (w-grade3 * s-housing-rent)
           let w-utility4 (w-grade4 * s-environment-mark)
           let w-utility5 (w-grade5 * s-culture-mark)
           set worker-utility (( w-utility1 + w-utility2 + w-utility4 + w-utility5) -  w-utility3 )* building-quality 
           if (worker-utility < 0) [set worker-utility 0] 
           ]
          let w-best-plot max-one-of w-targeted-housings [worker-utility]
          move-to w-best-plot
          w-increase-building-quality
          increase-housing-rent
          increase-talent-mark
          increase-transport-mark
          set w-real-volume (w-real-volume + housing-area)
          set got-housing-or-not 1  
          set off-home-time 0
          set inheritance? 0
          set hidden? false;; to control the visibility of CWs
          set CW-utility worker-utility
        ]
      ]
    ]
 end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
to find-job
  let income-decider expected-income
  let w-possible-firms  (CIs with [(wage > income-decider) and (wage < (income-decider * 2)) and
       (expected-size - real-size >= 1) and (got-land-or-not = 1)]) 
  ;; consistent with the supposed individual productivity, and to avoid "very high pay but quite low productivity" conflicts 
  let w-decider (count w-possible-firms)
  ifelse (w-decider = 0) 
  [set got-job-or-not 0  set off-job-time (off-job-time + 1)]
  [if (w-decider > 0 and w-decider < maxtimes-jobhunting ) [set w-targeted-firms w-possible-firms]
    if (w-decider > maxtimes-jobhunting) [set w-targeted-firms n-of maxtimes-jobhunting w-possible-firms]
    let w-best-firm   max-one-of w-possible-firms [wage]
    let wage-decider ([wage] of w-best-firm)
    set real-income (wage-decider * (1 + (((random 5) - 2) / 10))) ;;;suppose small fluctuation
    create-link-with w-best-firm [set hidden? true]
    set company-id [who] of w-best-firm
    set got-job-or-not 1 
    set off-job-time 0
    
    let worker-created capability
    let wage-actually-paid real-income
    ask w-best-firm ;; to change the output of a firm and capital of a firm
    [set real-size (real-size + 1)
      set output (output + worker-created)
      set total-wagepaid (total-wagepaid + wage-actually-paid)      
      ]
    ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
to calculate-firm-utility
  let f-utility1 (mark1 * policy-mark)
  let f-utility2 (mark2 * s-transport-mark)
  let f-utility3 (mark3 * s-rapidtrans-mark)
  let f-utility4 (mark4 * s-milieu-mark)
  let f-utility5 (mark5 * s-proximity-mark)
  let f-utility6 (mark6 * s-land-rent)
  let f-utility7 (mark7 * s-talent-mark)
  let f-utility8 (mark8 * s-environment-mark)
    
  set firm-utility (f-utility1 + f-utility2 + f-utility3 + f-utility4 + f-utility5 - f-utility6 + f-utility7 + f-utility8) * building-quality
  if (firm-utility < 0) [set firm-utility 0]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
to calculate-worker-utility
 let w-utility1 (grade1 * ((s-transport-mark + s-rapidtrans-mark) / 2))
  let w-utility2 (grade2 * s-shopping-mark)
  let w-utility3 (grade3 * s-housing-rent)
  let w-utility4 (grade4 * s-environment-mark)
  let w-utility5 (grade5 * s-culture-mark)
    
  set worker-utility (w-utility1 + w-utility2 - w-utility3 + w-utility4 + w-utility5) * building-quality   ;; 
  if (worker-utility < 0) [set worker-utility 0]
  
end
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; f-building quality 
to f-increase-building-quality;;quality range (0, 1]
  ask patch-here 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.01) 
        if (building-quality > 1) [set building-quality 1]]]
  ask patches in-radius 1 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.01) 
        if (building-quality > 1) [set building-quality 1]]]
  ask patches in-radius 2 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.01) 
        if (building-quality > 1) [set building-quality 1]]]  
end


to f-decrease-building-quality
  ask patch-here 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.01) 
        if (building-quality < 0) [set building-quality 0]]]
  ask patches in-radius 1 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.01) 
        if (building-quality < 0) [set building-quality 0]]]
  ask patches in-radius 2 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.01) 
        if (building-quality < 0) [set building-quality 0]]]  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;land-rent,firm
to increase-land-rent
  ask patch-here 
    [set land-rent (land-rent * 1.01) set s-land-rent (s-land-rent * 1.01)]
  ask patches in-radius 1 
    [set land-rent (land-rent * 1.01) set s-land-rent (s-land-rent * 1.01)]
  ask patches in-radius 2 
    [set land-rent (land-rent * 1.01) set s-land-rent (s-land-rent * 1.01)]  
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;land-rent-firm
to decrease-land-rent
  ask patch-here 
    [set land-rent (land-rent / 1.01) set s-land-rent (s-land-rent / 1.01)]
  ask patches in-radius 1 
    [set land-rent (land-rent / 1.01) set s-land-rent (s-land-rent / 1.01)]
  ask patches in-radius 2 
    [set land-rent (land-rent / 1.01) set s-land-rent (s-land-rent / 1.01)]  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;housing-rent
to increase-housing-rent
  ask patch-here 
    [set housing-rent (housing-rent * 1.002)  set s-housing-rent (s-housing-rent * 1.002)]
  ask patches in-radius 1 
    [set housing-rent (housing-rent * 1.002) set s-housing-rent (s-housing-rent * 1.002)]     
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;housing-rent
to decrease-housing-rent
  ask patch-here 
    [set housing-rent (housing-rent / 1.002)  set s-housing-rent (s-housing-rent / 1.002)]
  ask patches in-radius 1 
    [set housing-rent (housing-rent / 1.002) set s-housing-rent (s-housing-rent / 1.002)] 
 end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; w-building-quality
to w-increase-building-quality
  ask patch-here 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.002) 
        if (building-quality > 1) [set building-quality 1]]]
  ask patches in-radius 1 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.002) 
        if (building-quality > 1) [set building-quality 1]]]
  ask patches in-radius 2 
    [if ((land-type != "cbdland") and (building-quality < 1))
      [set building-quality (building-quality * 1.002) 
        if (building-quality > 1) [set building-quality 1]]]  
end


to w-decrease-building-quality
  ask patch-here 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.002) 
        if (building-quality < 0) [set building-quality 0]]]
  ask patches in-radius 1 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.002) 
        if (building-quality < 0) [set building-quality 0]]]
  ask patches in-radius 2 
    [if ((land-type != "cbdland") and (building-quality > 0))
      [set building-quality (building-quality / 1.002) 
        if (building-quality < 0) [set building-quality 0]]]  
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; building-quality 
to building-quality-decreasing
  ask patches with [use-possible = 1]
  [if land-type = "cbdland" []
    if land-type = "road" [set building-quality (building-quality * 0.99)]
    if land-type = "ind-park" [set building-quality (building-quality * 0.99)]
    if land-type = "derelict-factory" [set building-quality (building-quality * 0.99)]
    if land-type = "oldorillegal-housing" [set building-quality (building-quality * 0.99)]
    if land-type = "subhousing" [set building-quality (building-quality * 0.99)]
    if land-type = "farmland" []
    if land-type = "constructedland" [if ((random 100) < 30) [set building-quality (building-quality * 0.99)]]
     ;; assume that 70% of constructed land plots are updated or sustained by other urban activities
    ]   
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;proximity
to increase-proximity-mark
  ask patch-here 
  [if(s-proximity-mark < 2) 
  [set proximity-mark (proximity-mark * 1.01) 
    set s-proximity-mark (s-proximity-mark * 1.01)
      if (s-proximity-mark >= 2) [set s-proximity-mark 2]];; make sure the value is within [1, 2]
    ]
  ask patches in-radius 1 
  [if (s-proximity-mark < 2) 
    [set proximity-mark proximity-mark * 1.01  
      set s-proximity-mark s-proximity-mark * 1.01
      if (s-proximity-mark >= 2) [set s-proximity-mark 2]]
    ]
  ask patches in-radius 2 
  [if (s-proximity-mark < 2) 
    [set proximity-mark proximity-mark * 1.01  
      set s-proximity-mark s-proximity-mark * 1.01
      if(s-proximity-mark >= 2) [set s-proximity-mark 2]]
    ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;proximity  
to decrease-proximity-mark
  ask patch-here 
  [if (s-proximity-mark > 1) 
    [set proximity-mark proximity-mark / 1.01  
      set s-proximity-mark s-proximity-mark / 1.01
      if s-proximity-mark <= 1 [set s-proximity-mark 1]];; make sure the value is within [1, 2]
     ]
  ask patches in-radius 1 
  [if (s-proximity-mark > 1) 
    [set proximity-mark proximity-mark / 1.01  
      set s-proximity-mark s-proximity-mark / 1.01
      if s-proximity-mark <= 1 [set s-proximity-mark 1]]
    ]
  ask patches in-radius 2 
  [if (s-proximity-mark > 1) 
    [set proximity-mark proximity-mark / 1.01  
      set s-proximity-mark s-proximity-mark / 1.01
      if s-proximity-mark <= 1 [set s-proximity-mark 1]]
    ]
 end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;milieu
to increase-milieu-mark
  ask patch-here 
  [if (s-milieu-mark < 2) 
    [set milieu-mark milieu-mark * 1.01  
      set s-milieu-mark s-milieu-mark * 1.01
      if s-milieu-mark >= 2 [set s-milieu-mark 2]];; make sure the value is within [1, 2]
    ]
  ask patches in-radius 1 
  [if (s-milieu-mark < 2) 
    [set milieu-mark milieu-mark * 1.01  
      set s-milieu-mark s-milieu-mark * 1.01
      if s-milieu-mark >= 2 [set s-milieu-mark 2]]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;milieu 
to decrease-milieu-mark
  ask patch-here 
  [if (s-milieu-mark > 1) 
    [set milieu-mark milieu-mark / 1.01  
      set s-milieu-mark s-milieu-mark / 1.01
      if s-milieu-mark <= 1 [set s-milieu-mark 1]]
    ]
  ask patches in-radius 1 
  [if (s-milieu-mark > 1) 
    [set milieu-mark milieu-mark / 1.01  
      set s-milieu-mark s-milieu-mark / 1.01
      if s-milieu-mark <= 1 [set s-milieu-mark 1]]
    ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;talent
to increase-talent-mark
  ask patch-here 
  [if (s-talent-mark < 2) 
    [set talent-mark talent-mark * 1.001  
      set s-talent-mark s-talent-mark * 1.001
      if s-talent-mark >= 2 [set s-talent-mark 2]]
    ]
  ask patches in-radius 2 
  [if (s-talent-mark < 2) 
    [set talent-mark talent-mark * 1.001  
      set s-talent-mark s-talent-mark * 1.001
      if s-talent-mark >= 2 [set s-talent-mark 2]]
    ]
  ask patches in-radius 4 
  [if (s-talent-mark < 2) 
    [set talent-mark talent-mark * 1.01  
      set s-talent-mark s-talent-mark * 1.01
      if s-talent-mark >= 2 [set s-talent-mark 2]]
    ]
  ask patches in-radius 6 
  [if (s-talent-mark < 2) 
    [set talent-mark talent-mark * 1.001  
      set s-talent-mark s-talent-mark * 1.001
      if s-talent-mark >= 2 [set s-talent-mark 2]]
    ]
  ask patches in-radius 8 
  [if (s-talent-mark < 2) 
    [set talent-mark talent-mark * 1.001  
      set s-talent-mark s-talent-mark * 1.001
      if s-talent-mark >= 2 [set s-talent-mark 2]]
    ]
    
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;talent
to decrease-talent-mark
  ask patch-here 
  [if (s-talent-mark > 1) 
    [set talent-mark talent-mark / 1.001  
      set s-talent-mark s-talent-mark / 1.001
      if s-talent-mark <= 1 [set s-talent-mark 1]]
    ]
  ask patches in-radius 2 
  [if (s-talent-mark > 1) 
    [set talent-mark talent-mark / 1.001  
      set s-talent-mark s-talent-mark / 1.001
      if s-talent-mark <= 1 [set s-talent-mark 1]]
    ]
  ask patches in-radius 4 
  [if (s-talent-mark > 1) 
    [set talent-mark talent-mark / 1.001  
      set s-talent-mark s-talent-mark / 1.001
      if s-talent-mark <= 1 [set s-talent-mark 1]]
    ]
  ask patches in-radius 6 
  [if (s-talent-mark > 1) 
    [set talent-mark talent-mark / 1.001  
      set s-talent-mark s-talent-mark / 1.001
      if s-talent-mark <= 1 [set s-talent-mark 3]]
    ]
  ask patches in-radius 8 
  [if (s-talent-mark > 1) 
    [set talent-mark talent-mark / 1.001  
      set s-talent-mark s-talent-mark / 1.001
      if s-talent-mark <= 1 [set s-talent-mark 1]]
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to increase-transport-mark ;assume that people agglomeration can bring foward new bus lines gradually
  ask patch-here 
    [if (s-transport-mark < 2)
      [set transport-mark (transport-mark * 1.002)  
        set s-transport-mark (s-transport-mark * 1.002)
        if s-talent-mark >= 2 [set s-talent-mark 2]]
      ]
  ask patches in-radius 4 
    [if (s-transport-mark < 2)
      [set transport-mark (transport-mark * 1.002)  
        set s-transport-mark (s-transport-mark * 1.002)
        if s-talent-mark >= 2 [set s-talent-mark 2]]
      ]
  ask patches in-radius 8 
    [if (s-transport-mark < 2)
      [set transport-mark (transport-mark * 1.002)  
        set s-transport-mark (s-transport-mark * 1.002)
        if s-talent-mark >= 2 [set s-talent-mark 2]]
      ]
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to decrease-transport-mark ;assume that people leaving can bring away new bus lines gradually
ask patch-here 
    [if (s-transport-mark > 1)
      [set transport-mark (transport-mark / 1.002)  
        set s-transport-mark (s-transport-mark / 1.002)
        if s-talent-mark <= 1 [set s-talent-mark 1]]
      ]
  ask patches in-radius 4 
    [if (s-transport-mark > 1)
      [set transport-mark (transport-mark / 1.002)  
        set s-transport-mark (s-transport-mark / 1.002)
        if s-talent-mark <= 1 [set s-talent-mark 1]]
      ]
  ask patches in-radius 8 
    [if (s-transport-mark > 1)
      [set transport-mark (transport-mark / 1.002)  
        set s-transport-mark (s-transport-mark / 1.002)
        if s-talent-mark <= 1 [set s-talent-mark 1]]
      ]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
to view-marks
 
 
 end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

to go
 ifelse (f-visibility = 1);;to set whether to see firms or not
   [ask CIs with [got-land-or-not = 1]
     [if (hidden? = true) [set hidden? false]]]
   [ask CIs with [got-land-or-not = 1]
     [if (hidden? = false) [set hidden? true]]]
 ifelse (w-visibility = 1);; to set whether to see workers or not
   [ask CWs with [got-housing-or-not = 1]
      [if (hidden? = true) [set hidden? false]]]
   [ask CWs with [got-housing-or-not = 1]
     [if (hidden? = false) [set hidden? true]]]
 
 if (total-demand = 0) [set total-demand 1];; to avoid demand is set to zero
 
 ask CIs     
 ;; assume company will die if capital is dried out or being with no office longer than maxtime (set by control interface).
  [ calculate-profit-rate
    calculate-capital 
    ifelse (got-land-or-not = 1) ;; only calculate those who has found office
     [ifelse (capital >= 0)
          [if (land-expense-rate > f-moving-critical-land-expense-rate)
            [set got-land-or-not 0
             set hidden? true
             set off-land-time 1              
            ]
            
            
            if (profit-rate >= f-size-expansion-critical-profit-rate) [firm-size-expansion];;size expansion
            if (profit-rate <= (f-size-decline-critical-negprofit-rate)) [firm-size-wage-decline]
              ];;size shrink if profit rate < f-size-decline-critical-negprofit-rate
           
           [let id who
             ask CWs with [company-id = id]
             [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]          
               f-decrease-building-quality
               decrease-land-rent
               decrease-proximity-mark
               decrease-milieu-mark
               set f-real-volume (f-real-volume - (expected-size * 15));; 15 square metres per worker
               if f-real-volume < 0 [set f-real-volume 0] ;;change the property of the plot 
               die
              ]
         ]
     
     [ifelse (capital >= 0)
       [if (off-land-time > maxtime-failure-finding-office)
        [let id who
         ask CWs with [company-id = id]
          [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]          
           f-decrease-building-quality
           decrease-land-rent
           decrease-proximity-mark
           decrease-milieu-mark
           set f-real-volume (f-real-volume - (expected-size * 15));; 15 square metre per worker
           if f-real-volume < 0 [set f-real-volume 0]  
           die
           ]
         ]
       
       [die]
       
       
       ]      
    ]
  


ask CWs
  ;;assume workers will no longer hunting for jobs in software and cartoon, 
  ;;and then turn to be other sectors' employees or leave the city, if they cannot find jobs in software or cartoon 
  ;;longer than maxtime-failure-finding-jobs or cannot not find suitable housing longer than maxtime-suffering-housing-rent
    [ifelse (got-housing-or-not = 1)
     [ifelse (got-job-or-not = 1)
      [if ((housing-rent * housing-area) > (real-income / 2))
        [ set got-housing-or-not 0
          set off-home-time 1
          set hidden? true
          set about-to-move 1] 
        ];;;to set the worker invisible temporarily waiting for finding another place
       [ if (off-job-time > maxtime-failure-finding-jobs)
         [set w-real-volume (w-real-volume - housing-area);; influence the w-real-volume
          w-decrease-building-quality
          decrease-housing-rent
          decrease-talent-mark
          decrease-transport-mark
          die
          ];;; the influence upon locational feature it caused
         ];;  have housing but no job, check if it is too long having no job
      ]
    
    [ifelse (got-job-or-not = 1);;got-housing-or-not=0
      [if (off-home-time > maxtime-suffer-housingrent) 
        [let x1 company-id
          let x2 capability 
          let x3 real-income
          ask CIs with [who = x1]
           [set real-size (real-size - 1)
            set output (output - x2)
            set total-wagepaid (total-wagepaid - x3) 
            ]         
           die
          ]
        ]
      [if ((off-job-time > maxtime-failure-finding-jobs) or (off-home-time > maxtime-suffer-housingrent))
         [die]
          ]
        ]    
      ]
    
    
 ask UGs 
 [ifelse (real-time-in-service >= planned-time-in-service)
     [setup-policy-stop-influence
       setup-policy-package
       setup-policy-distribution
       setup-policy-influence-plot
       set real-time-in-service 0]
     [set real-time-in-service (real-time-in-service + 1)]
   ]


if (policy-sensor = 1)
  [create-UGs add-or-abolish-number
    [ setup-policy-turtle-property
      setup-policy-package;; define the planned-time-in-service simultaneously
      setup-policy-distribution
      setup-policy-influence-plot
      set real-time-in-service 0
      ]
    set policy-sensor 0 ;; make it to be the original status: no change
    ]

if (policy-sensor = -1)
  [let total-support (count UGs)
    ifelse (total-support >= add-or-abolish-number)
      [ask max-n-of add-or-abolish-number UGs [real-time-in-service]
         [setup-policy-stop-influence die] ]
      [ask UGs [setup-policy-stop-influence  die] ]
    set policy-sensor 0 ;; make it to be the original status: no change
    ]
  
 


 ifelse (growth-rate-cycle = 0)
 [set total-demand (total-demand * (1 + demand-monthly-growth-rate))]
 [set growth-cycle-count int ((steps / growth-rate-cycle))
   let  cycle-number-define (remainder growth-cycle-count 2)
    ifelse (cycle-number-define = 0 )
    [set total-demand (total-demand * (1 + demand-monthly-growth-rate + ((random 10) / 100)))]
    [set total-demand (total-demand * (1 + (demand-monthly-growth-rate - ((random 10) / 100))))]
   ]
;;demand-monthly-growth-rate,0.1 means 10%
 ifelse (total-production <= 0);; to avoid the situation that the denominator is zero
 [firm-number-increase]
 [if ((total-demand / total-production) > f-num-increase-critical-D/S-rate) [firm-number-increase] ] ;; firm number increase
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   
 if (employment-rate > w-num-increase-critical-employ-rate) [worker-number-increase];; new workers emerged
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


 let CIs-no-office (CIs with [got-land-or-not = 0])   
 ask CIs-no-office [find-office]

 
 let CWs-no-job (CWs with [got-job-or-not = 0])     
 ask CWs-no-job [find-job]
 
 let CWs-no-housing (CWs with [got-housing-or-not = 0])
 ask CWs-no-housing [find-housing]     
    
   
 calculate-total-production
 calculate-employment-rate
 calcualte-output-sold-rate
 
 
 building-quality-decreasing

 ifelse (((count CIs) >= 2) and ((count CWs ) >= 2)) 
 
 
 [do-plots]
 
 [write "there are less than two creative firms or two workers, unable to do plots"
  stop]
 
 set steps (steps + 1);;to count the cycle of growth rate
 tick
 
end 



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-total-production
  ;; we assume total production is equal to total supply, do not consider product (service) stored for next month (year)
  let total-production-1 (sum [output] of CIs)
  set total-production (total-production-1 / 1000000);; manipulate value unit into million yuan
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calcualte-output-sold-rate
  ;; we assume total production is equal to total supply, do not consider product (service) stored for next month (year)
  ifelse (total-production <= 0)
  [set output-sold-rate 1]
  [ifelse (total-production <= total-demand)
    [set output-sold-rate 1];; assume that all firms will sold all the product that they produce
    [set output-sold-rate (total-demand / total-production)];; do not consider the different competency of different sizes 
   ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-profit-rate
  ifelse (output = 0)
  [set profit-rate 0 set land-expense-rate 0];; to let the firm to stay where it is
  [let sold-value (output * output-sold-rate)
   let land-expense (land-rent-after-policy * expected-size)
   let total-cost (land-expense + total-wagepaid)
   set profit (sold-value - total-cost)
   set land-expense-rate (land-expense / sold-value);; to calculate the expense in land for this firm
    ifelse (total-cost = 0);;if total-cost = 0, it means the firm has found office and enjoy free land but got no workers
      [set profit-rate 0]
      [set profit-rate (profit / total-cost)]
     ];; tax are not substracted from the profit,it is gross profit
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-capital
  set tax-percent ((b-tax-rate / 100) * (1 - tax-reduction-rate))
  ifelse (profit < 0)
  [set tax-paid 0]
  [set tax-paid (profit * tax-percent)]
  set capital (capital + profit - tax-paid)  ;; tax is levied only if company can make profit
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to firm-size-expansion
  let growth-percent (0.01 + (random 50) / 1000)
  ;this rate is according to the questionnaire result 10-50% per year, so the rate per month is about 0.01-0.06
  let demanding-space ((expected-size * growth-percent) * 15) ;;15 square metres per worker
  set expected-size (int (expected-size * (1 + growth-percent)))
  if ((demanding-space + f-real-volume) > f-max-volume) 
   [f-decrease-building-quality
     decrease-land-rent
     decrease-proximity-mark
     decrease-milieu-mark
     set f-real-volume (f-real-volume - (expected-size * 15 - demanding-space));; 15 square metre per worker
     if f-real-volume < 0 [set f-real-volume 0]
     find-office
     if (got-land-or-not = 0)
     [let id who 
       ask CWs with [company-id = id]
        [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]
         die;;it means if the company in operation can not find office immediately, it will move to other city, say die 
         ;;out from this dynamic system.
       ]
     ]
end
   ;; assume if the firm has many workers and want to expand
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to firm-size-wage-decline
  ;; we assume total production is equal to total supply, do not consider product (service) stored for next month (year)
let abs-profit-rate (abs (profit-rate))
let decline-rate abs (abs-profit-rate - (((random 20) - 10 ) / 100))
;; decline basically according to the negative-profit-rate, but randomly change a bit
  if (decline-rate >= 1) ;;if the profit-rate is almost -1, then the company closes down
   [let id who
      ask CWs with [company-id = id]
      [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]          
        f-decrease-building-quality
        decrease-land-rent
        decrease-proximity-mark
        decrease-milieu-mark
        set f-real-volume (f-real-volume - (expected-size * 15));; 15 square metre per worker
        if f-real-volume < 0 [set f-real-volume 0]  
        die    
       ]
  
  if (decline-rate <= 0) 
    [  ]
    
  if ((decline-rate < 1) and (decline-rate > 0)) 
  [let potential-size (int ((expected-size * (1 - decline-rate))))
    
    ifelse (potential-size < 5);; minium firm size is 5,
    [let id who
        ask CWs with [company-id = id]
        [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]          
        f-decrease-building-quality
        decrease-land-rent
        decrease-proximity-mark
        decrease-milieu-mark
        set f-real-volume (f-real-volume - (expected-size * 15));; 15 square metre per worker
        if f-real-volume < 0 [set f-real-volume 0]  
        die
        ]
            
         
    [ifelse (real-size <= potential-size) 
      ;; check whether the potential size is larger or smaller than the real-size, so as to decide to fire employees or not
      []
      [let fire-num (real-size - potential-size)
        let id who
        let fired-workers min-n-of fire-num (CWs with [company-id = id]) [capability]
        let output-firing-decline sum ([capability] of fired-workers)
        set output (output - output-firing-decline) 
        if (output < 0) [set output 0]
          ask fired-workers 
          [set got-job-or-not 0 set off-job-time (off-job-time + 1) set real-income 0 set company-id "none"]
          set real-size potential-size          
        ]
    
      set f-real-volume (f-real-volume - ((expected-size - potential-size) * 15))
        if (f-real-volume < 0 ) [set f-real-volume 0]
      set expected-size potential-size
      ]     
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to firm-number-increase
  ;;we assume it is proportional to the percentage of ((demand - supply) / demand)
  ;;but we assume the highest percent is 200%, by referring to the data of the firms' directory

  set f-growth-variable ((total-demand - total-production) / total-demand) 
  if (f-growth-variable < 0) [set f-growth-variable 0]
    let CIs-number (count CIs)
    let new-CIs-number (1 + int (CIs-number * ((2 ^ f-growth-variable) - 1)));;;;;;;;;(growth formula of number of new firms)
    create-CIs new-CIs-number
    [set color white
      set hidden? true
      set size 3
      setup-firm-originalweight
      setup-firm-property
      calculate-f-weight
     ]  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to calculate-employment-rate
  let CWs-number (count CWs)
  let employed-CWs-number (count (CWs with [got-job-or-not = 1]))
  set employment-rate (employed-CWs-number / CWs-number)   
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to worker-number-increase
  ;; we assume that if the employment rate is high in CIs, 
  ;then the probability citizens turn into CWs is high correspondingly.
  set w-growth-variable ((employment-rate - w-num-increase-critical-employ-rate) / employment-rate) 
  if (w-growth-variable < 0) [set w-growth-variable 0]
  
  let CWs-number (count CWs) 
   
  let new-CWs-number (1 + int (CWs-number * 10 * ((2 ^ w-growth-variable) - 1))) ;;;;;;;;growth formula of number of new workers
  
  create-CWs new-CWs-number
  [set color gray
   set hidden? true
   set size 1
   set about-to-move 0
   setup-worker-originalweight
   setup-worker-property
   calculate-w-weight
   ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-policy-turtle-property
  set hidden? true
  set shape "circle 2"
  set color red
  set size 5  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-policy-package
  let probability (random 3)
  if (probability = 0) 
   [set policy-code 1.5
     let probability1 (random 3)
      if (probability1 = 0) 
       [set milieu-promote-rate (0.1 + ((random 10) / 10));; maximum is two times
         set tax-abate-rate 0
         set land-rent-abate-rate 0
        ]
      if (probability1 = 1) 
       [set milieu-promote-rate 0
         set tax-abate-rate 0
         set land-rent-abate-rate (0.1 + ((random 9) / 10)) ;;extreme situtation is that the land is  free
         ; using  random 9 to avoid the price turns to be 0,causing problem in the final view mode of land-price   
         ]
      if (probability1 = 2) 
       [set milieu-promote-rate 0
         set tax-abate-rate (0.1 + ((random 10) / 10));; extreme situation is that tax will not be charged
         set land-rent-abate-rate 0
         ]
    ]
  
  
  if (probability = 1) 
   [set policy-code 2.0
     let probability2 (random 3)
      if (probability2 = 0) 
       [set milieu-promote-rate (0.1 + ((random 10) / 10))
        set tax-abate-rate 0
        set land-rent-abate-rate (0.1 + ((random 9) / 10))
        ]
      if (probability2 = 1)
       [set milieu-promote-rate (0.1 + ((random 10) / 10))
        set tax-abate-rate (0.1 + ((random 10) / 10))
        set land-rent-abate-rate 0
        ]
      if (probability2 = 2) 
       [set milieu-promote-rate (0.1 + ((random 10) / 10))
        set tax-abate-rate 0
        set land-rent-abate-rate (0.1 + ((random 9) / 10))
        ]
     ]
  
  
  
  if (probability = 2) ;; three supportive policies are offered
   [set policy-code 2.5
     set milieu-promote-rate (0.1 + ((random 10) / 10))
     set tax-abate-rate (0.1 + ((random 10) / 10))
     set land-rent-abate-rate (0.1 + ((random 9) / 10))
     ]
     
  set cover-size (2 + random 5);; maximum  width is 6 *100 m
  set planned-time-in-service (mean-tenure + ((random 24) - 12))
  ;; mean-tenure + or - several months, extreme is -12 months (a year) or +12 months (a year)
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup-policy-distribution

 if (prior-area = "inner-city-district") 
    [ifelse ((random 100) < 50)
      [let possible-patches1 (patches with [(urban-area = "inner-city-district") and 
            ((building-quality < 0.5 ) or land-type = "ind-park")  and (policy-mark = 1) and (use-possible = 1)])
         ifelse (any? possible-patches1)
           [move-to one-of possible-patches1  setup-policy-influence-plot]
           [let possible-patches (patches with [(urban-area = "inner-city-district") and (policy-mark = 1) and (use-possible = 1)])
            move-to one-of possible-patches setup-policy-influence-plot]
         ]
          
       [let possible-patches11 (patches with [(urban-area != "inner-city-district") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
          ifelse (any? possible-patches11)
           [move-to one-of possible-patches11 setup-policy-influence-plot]
           [let possible-patches (patches with [(urban-area != "inner-city-district") and (policy-mark = 1) and (use-possible = 1)])
            move-to one-of possible-patches   setup-policy-influence-plot]
         ]
     ]
        
     
 if (prior-area = "outer-city-district")
    [ifelse ((random 100) < 50)
       [let possible-patches2 (patches with [(urban-area = "outer-city-district") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
           ifelse (any? possible-patches2)
             [move-to one-of possible-patches2  setup-policy-influence-plot]
             [let possible-patches (patches with [(urban-area = "outer-city-district") and (policy-mark = 1) and (use-possible = 1)])
              move-to one-of possible-patches   setup-policy-influence-plot]
          ]
      
        [let possible-patches22 (patches with [(urban-area != "outer-city-district") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
          ifelse (any? possible-patches22)
             [move-to one-of possible-patches22  setup-policy-influence-plot]
             [let possible-patches (patches with [(urban-area != "outer-city-district") and (policy-mark = 1) and (use-possible = 1)])
              move-to one-of possible-patches  setup-policy-influence-plot]
          ]
       ]
    
    
 if (prior-area = "inner-suburb") 
    [ifelse ((random 100) < 50)
      [let possible-patches3 (patches with [(urban-area = "inner-suburb") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
         ifelse (any? possible-patches3) 
          [move-to one-of possible-patches3  setup-policy-influence-plot]
          [let possible-patches (patches with [(urban-area = "inner-suburb") and (policy-mark = 1) and (use-possible = 1)])
            move-to one-of possible-patches   setup-policy-influence-plot]
        ]
      
      
      [let possible-patches33 (patches with [(urban-area != "inner-suburb") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
        ifelse (any? possible-patches33) 
          [move-to one-of possible-patches33  setup-policy-influence-plot]
          [let possible-patches (patches with [(urban-area != "inner-suburb") and (policy-mark = 1) and (use-possible = 1)])
            move-to one-of possible-patches   setup-policy-influence-plot]
        ]
      ]
    

 if (prior-area = "outer-suburb") 
    [ifelse ((random 100) < 50)
      [let possible-patches4 (patches with [(urban-area = "outer-suburb") and (policy-mark = 1) and (use-possible = 1)
         and (land-type = "ind-park")]) ;(building-quality < 0.4 ) or 
         ifelse (any? possible-patches4) 
          [move-to one-of possible-patches4  setup-policy-influence-plot]
          [move-to one-of patches with [urban-area = "outer-suburb" and (policy-mark = 1) 
              and (any? ((patches in-radius 10) with [(land-type = "road")]))]          
            setup-policy-influence-plot]
          ;;it indicate that the government might use the farmland to develop creative industries (the influence of urban government)
         ]
      
      [let possible-patches44 (patches with [(urban-area != "outer-suburb") and 
            ((building-quality < 0.5 ) or land-type = "ind-park") and (policy-mark = 1) and (use-possible = 1)])
        ifelse (any? possible-patches44) 
          [move-to one-of possible-patches44  setup-policy-influence-plot]
          [let possible-patches (patches with [(urban-area != "outer-suburb") and (policy-mark = 1) and (use-possible = 1)])
           move-to one-of possible-patches   setup-policy-influence-plot]
        ]
      ]
    
 if (prior-area = "randomly") 
    [let possible-patches5 (patches with [((building-quality < 0.5 ) or land-type = "ind-park") 
          and (policy-mark = 1) and (use-possible = 1)])
         ifelse (any? possible-patches5) 
          [move-to one-of possible-patches5  setup-policy-influence-plot]
          [let possible-patches (patches with [(policy-mark = 1) and (use-possible = 1)])
           move-to one-of possible-patches   setup-policy-influence-plot]
       ]
    
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-policy-influence-plot
  let m1 policy-code
  let m2 tax-abate-rate
  let m3 milieu-promote-rate
  let m4 land-rent-abate-rate

  ask patches in-radius cover-size ;;ask the covered plots to change policy enjoyed
    [if (building-quality < 1) [set building-quality 1] ;; to renew the quality as if it is new
        if (policy-mark = 1) 
           [set policy-mark m1
             set tax-reduction-rate m2
             set milieu-mark (milieu-mark * (1 + m3)) 
             set s-milieu-mark (s-milieu-mark * (1 + m3))
             set land-rent-after-policy (land-rent * (1 - m4));;the land-rent for the firms changed, but the price itself does not change
             ] 
        ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup-policy-stop-influence
  let m1 policy-code
  let m2 tax-abate-rate
  let m3 milieu-promote-rate
  let m4 land-rent-abate-rate
  
  ask patches in-radius cover-size 
    [if (policy-mark != 1) 
        [set policy-mark 1
          set tax-reduction-rate 0
          set milieu-mark (milieu-mark / (1 + m3)) 
          set s-milieu-mark (s-milieu-mark / (1 + m3))
          set land-rent-after-policy land-rent
          ] 
       ]
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to urban-regeneration
  let possible-plots (patches with [(use-possible = 1) and (building-quality < 0.5)])
  let number (count possible-plots)
  ifelse (number = 0)
   []
   [ifelse (number < 5)
     [ask max-n-of number possible-plots [building-quality] 
       [ask patches in-radius 3 
         [if (land-type = "constructedland") [set building-quality 1]] ] ]
     [ask max-n-of 5 possible-plots [building-quality]  
       [ask patches in-radius 3 
         [if (land-type = "constructedland") [set building-quality 1]] ] ]
     ;;we assume to renew 5 plot-projects with the lowest building-quality per month
     ]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to develop-sub-housing
  let possible-plots (patches with [(urban-area = "outer-suburb" or urban-area = "inner-suburb") 
      and (land-type = "farmland" or land-type = "constructedland") 
      and (any? ((patches in-radius 10) with [terrain = "road"]))])
  let number (count possible-plots)
  ifelse (number = 0)
  []
  [ifelse (number < 5) ;; assume develop five new real-estate project per month
    [ask n-of number possible-plots
      [sprout-subhouses 1
        [set hidden? true set shape "house" set size (10 * patch-unit) set color 46
          ask patches in-radius ((4 + random 3) * patch-unit)
          [if (land-type = "farmland" or land-type = "constructedland")
            [set building-quality 1 set terrain "subhousing" set pcolor 44
              set land-type "subhousing" set use-possible 1]]
          ]
        ]
      ]
     
     [ask n-of 5 possible-plots ;; assume develop five new real-estate project per month
      [sprout-subhouses 1
        [set hidden? true set shape "house" set size (10 * patch-unit) set color 46
          ask patches in-radius ((4 + random 3) * patch-unit)
          [if (land-type = "farmland" or land-type = "constructedland")
            [set building-quality 1 set terrain "subhousing"  set pcolor 44
              set land-type "subhousing" set use-possible 1]]
          ]
        ]
      ]
   ]
 end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to hide-show-turtles
  
ifelse (f-visibility = 1);;to set whether to see firms or not
   [ask CIs with [got-land-or-not = 1]
     [if (hidden? = true) [set hidden? false]]]
   [ask CIs with [got-land-or-not = 1]
     [if (hidden? = false) [set hidden? true]]]
 ifelse (w-visibility = 1);; to set whether to see workers or not
   [ask CWs with [got-housing-or-not = 1]
      [if (hidden? = true) [set hidden? false]]]
   [ask CWs with [got-housing-or-not = 1]
     [if (hidden? = false) [set hidden? true]]]
end



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to do-plots
  set-current-plot "demand-supply"
  set-current-plot-pen "demand"
  plot total-demand  
  set-current-plot-pen "supply"
  plot total-production
  
 ;;;;;;;;;;;;;calculate basic data;;;;;;;;;;;;;;;;;;;;;  
  set CIs-num (count CIs)
  set CWs-num (count CWs)
  set UGs-num (count UGs)
  
  let got-land-CIs (CIs with [got-land-or-not = 1])
  let noland-CIs (CIs with [got-land-or-not = 0])
  
  let got-job-CWs (CWs with [got-job-or-not = 1])
  let got-house-CWs (CWs with [got-housing-or-not = 1])
  let nojob-CWs (CWs with [got-job-or-not = 0])
  let nohome-CWs (CWs with [got-housing-or-not = 0])
  
ask patches
   [ifelse (any? CIs-here) 
     [set patch-firm-number (count CIs-here)
       ifelse (any? (CIs-here with [got-land-or-not = 1]))
        [set patch-firm-ok-number (count (CIs-here with [got-land-or-not = 1]))]
        [set patch-firm-ok-number 0]
       ] 
     [set patch-firm-number 0  set patch-firm-ok-number 0]
     
    ifelse (any? CWs-here) 
     [set patch-worker-number (count CWs-here)
       ifelse (any? (CWs-here with [got-housing-or-not = 1]))
        [set patch-worker-ok-number (count (CWs-here with [got-housing-or-not = 1]))]
        [set patch-worker-ok-number 0]
       ] 
     [set patch-worker-number 0  set patch-worker-ok-number 0]
     ]
 ;;;;;;;;;;;;; calculate CIs CWs number, rate etc;;;;;;;;;;;;;   
 set noland-CIs-num (count noland-CIs)
  set nojob-CWs-num (count nojob-CWs)
  set nohome-CWs-num (count nohome-CWs)
  set noland-CIs-rate (noland-CIs-num / CIs-num)
  set nojob-CWs-rate (nojob-CWs-num / CWs-num)
  set nohome-CWs-rate (nohome-CWs-num / CWs-num)
  
  set-current-plot "firm-worker-number"
  set-current-plot-pen "firm"
  plot (CIs-num * 10)
  set-current-plot-pen "worker"
  plot (CWs-num / 10) ;;divide so as to see the plot more comfortable
  set-current-plot-pen "policy"
  plot (UGs-num * 10) ;; multiply so as to see the value
  
  set-current-plot "in-problem-agents"
  set-current-plot-pen "noland"
  plot noland-CIs-num
  set-current-plot-pen "nojob"  
  plot (nojob-CWs-num / 10) ;; divide 10 so as to make the plot more readable
  set-current-plot-pen "nohome"  
  plot noland-CIs-num
  
  set-current-plot "in-problem-rate"
  set-current-plot-pen "noland"
  plot noland-CIs-rate
  set-current-plot-pen "nojob"  
  plot nojob-CWs-rate
  set-current-plot-pen "nohome"  
  plot noland-CIs-rate
  
;;;;;;;;;;;;; calculate cluster via Quadrat;;;;;;;;;;;;;
  

  

;;;;;;;;;;;;; calculate cluster via nearest-distance;;;;;;;;;;;;;  
  

 
;;;;;;;;;;;to see the spatial distribution of firms' number;;;;;;;;;;

 

  
;;;;;;;;;;;to see firms' spatial density distribution through time ;;;;;;;;;;;




;;;;;;;;;;;to see the spatial distribution of workers' number;;;;;;;;;;




;;;;;;;;;;;to see worker' spatial density distribution through time ;;;;;;;;;;;




;;;;;;;;;;;to see policy' spatial number distribution through time ;;;;;;;;;;;


;;;;;;;;;;;to see policy' spatial density distribution through time ;;;;;;;;;;;



;; times 1000 in order to see the result more clelarly
;;;;;;;;;;;to see land price  change over time;;;;;;;;;;;


;;;;;;;;;;;to see land price  change over time;;;;;;;;;;;

  
;;;;;;;;;;;to see firms' size ;;;;;;;;;;;
let counted-CIs CIs with [(got-land-or-not = 1) and (real-size > 0)]
set firm-real-size-mean mean ([real-size] of counted-CIs)
set firm-real-size-max max ([real-size] of counted-CIs)
set firm-real-size-min min ([real-size] of counted-CIs)
set firm-real-size-median median ([real-size] of counted-CIs)
set-current-plot "firm-size"
set-current-plot-pen "max"     plot firm-real-size-max
set-current-plot-pen "median"   plot firm-real-size-median
set-current-plot-pen "min"      plot firm-real-size-min
set-current-plot-pen "s-dev"    
ifelse ((count got-land-CIs) >= 2)
[plot standard-deviation ([real-size] of counted-CIs)] 
[write "only one firm got land? unable to do plot of standard deviation of firms' real size"]
set-current-plot-pen "mean"     plot firm-real-size-mean


;;;;;;;;;;;to see worker' income ;;;;;;;;;;;
set-current-plot "worker-income"
set worker-income-max max ([real-income] of got-job-CWs)
set worker-income-median median ([real-income] of got-job-CWs)
set worker-income-min min ([real-income] of got-job-CWs)
set worker-income-mean mean ([real-income] of got-job-CWs)

set-current-plot-pen "max"     plot worker-income-max
set-current-plot-pen "median"   plot worker-income-median
set-current-plot-pen "min"      plot worker-income-min
set-current-plot-pen "s-dev"    
ifelse ((count got-job-CWs) >= 2)
[plot standard-deviation ([real-income] of got-job-CWs)]
[write "only one worker got job, unable to do plot of standard deviation of workers' income"]
set-current-plot-pen "mean"     plot worker-income-mean
 
end
@#$#@#$#@
GRAPHICS-WINDOW
499
81
1439
1042
100
100
4.63
1
10
1
1
1
0
0
0
1
-100
100
-100
100
0
0
1
ticks
30.0

BUTTON
895
10
950
43
Setup
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

SLIDER
3
464
157
497
initial-number-firm
initial-number-firm
1
1000
30
1
1
NIL
HORIZONTAL

SLIDER
3
499
157
532
initial-number-CW
initial-number-CW
1
6000
303
1
1
NIL
HORIZONTAL

MONITOR
954
10
1016
59
total-firm
count CIs
0
1
12

MONITOR
1019
10
1101
59
total-worker
count CWs
0
1
12

BUTTON
895
45
950
78
go
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

SLIDER
7
10
121
43
river-number
river-number
0
3
0
1
1
NIL
HORIZONTAL

SLIDER
123
10
234
43
lake-number
lake-number
0
3
0
1
1
NIL
HORIZONTAL

SLIDER
7
53
121
86
hill-number
hill-number
0
3
0
1
1
NIL
HORIZONTAL

CHOOSER
7
92
121
137
cloverleaf-number
cloverleaf-number
"high" "medium" "low"
1

CHOOSER
124
45
235
90
road-density
road-density
"high" "medium" "low"
1

CHOOSER
7
137
121
182
subway-number
subway-number
"high" "medium" "low" "none"
2

CHOOSER
6
339
121
384
policy-support
policy-support
"none" "low" "medium" "high"
2

CHOOSER
124
91
235
136
green-park-number
green-park-number
"high" "medium" "low"
1

CHOOSER
7
183
121
228
univ-etc-num
univ-etc-num
"high" "medium" "low"
1

CHOOSER
124
137
235
182
ind-park-num
ind-park-num
"high" "medium" "low" "none"
1

CHOOSER
7
229
121
274
old-factory-num
old-factory-num
"high" "medium" "low" "none"
1

CHOOSER
124
183
235
228
old-housing-num
old-housing-num
"high" "medium" "low" "none"
1

CHOOSER
7
275
121
320
suburban-housing
suburban-housing
"high" "medium" "low" "none"
1

CHOOSER
124
229
236
274
dailyshopping
dailyshopping
"high" "medium" "low" "none"
1

CHOOSER
123
276
238
321
culture-num
culture-num
"high" "medium" "low" "none"
1

BUTTON
293
321
444
354
view land-price
set view-mode \"land-price\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
292
44
444
77
view city road-transport
set view-mode \"transport\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
292
78
444
111
view underground service
set view-mode \"rapid-transport\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
292
113
444
146
view environment quality
set view-mode \"environment\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
147
444
180
view shopping service
set view-mode \"shopping\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
251
444
284
view talent pool
set view-mode \"talent\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
216
444
249
view trade milieu
set view-mode \"milieu\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
181
444
214
view cultural facility
set view-mode \"culture\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
286
444
319
view housing price
set view-mode \"housing-rent\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
355
444
388
view proximity mark
set view-mode \"proximity\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
293
389
444
422
view policy mark
set view-mode \"policy\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
292
10
444
43
view original elements
set view-mode \"original\"\nview-marks
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
0
599
186
632
maxtimes-jobhunting
maxtimes-jobhunting
1
300
30
1
1
NIL
HORIZONTAL

SLIDER
0
634
186
667
maxtimes-officesearching
maxtimes-officesearching
1
200
10
1
1
NIL
HORIZONTAL

CHOOSER
124
339
237
384
prior-area
prior-area
"inner-city-district" "outer-city-district" "inner-suburb" "outer-suburb" "randomly"
0

SLIDER
124
386
237
419
mean-tenure
mean-tenure
24
60
60
3
1
NIL
HORIZONTAL

SLIDER
188
633
398
666
maxtime-failure-finding-office
maxtime-failure-finding-office
1
12
6
1
1
NIL
HORIZONTAL

SLIDER
188
599
398
632
maxtime-failure-finding-jobs
maxtime-failure-finding-jobs
1
24
6
1
1
NIL
HORIZONTAL

SLIDER
6
386
121
419
b-tax-rate
b-tax-rate
15
40
20
1
1
%
HORIZONTAL

MONITOR
1192
10
1266
59
firm-noland
count CIs with [got-land-or-not = 0]
0
1
12

MONITOR
1268
11
1347
60
worker-nojob
count CWs with [got-job-or-not = 0]
2
1
12

SLIDER
0
669
186
702
maxtimes-housingfinding
maxtimes-housingfinding
1
500
200
1
1
NIL
HORIZONTAL

SLIDER
188
669
398
702
maxtime-suffer-housingrent
maxtime-suffer-housingrent
1
12
12
1
1
NIL
HORIZONTAL

MONITOR
1349
11
1439
60
worker-noflat
count CWs with [got-housing-or-not = 0]
0
1
12

SLIDER
1
710
284
743
f-size-expansion-critical-profit-rate
f-size-expansion-critical-profit-rate
0.01
5
0.2
0.01
1
NIL
HORIZONTAL

SLIDER
162
465
395
498
base-product-demand
base-product-demand
0
1000
116
1
1
m-yuan/mth
HORIZONTAL

SLIDER
162
500
395
533
demand-monthly-growth-rate
demand-monthly-growth-rate
-1
1
-0.01
0.01
1
per mth
HORIZONTAL

SLIDER
1
867
284
900
f-num-increase-critical-D/S-rate
f-num-increase-critical-D/S-rate
1
10
1
0.1
1
NIL
HORIZONTAL

SLIDER
1
744
284
777
f-size-decline-critical-negprofit-rate
f-size-decline-critical-negprofit-rate
-1
-0.01
-0.1
0.01
1
NIL
HORIZONTAL

SLIDER
1
832
284
865
w-num-increase-critical-employ-rate
w-num-increase-critical-employ-rate
0.05
1
0.8
0.01
1
NIL
HORIZONTAL

SLIDER
498
44
665
77
add-or-abolish-number
add-or-abolish-number
1
10
2
1
1
NIL
HORIZONTAL

BUTTON
498
11
578
44
add-policy
set policy-sensor 1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
579
11
665
44
cancel-policy
set policy-sensor -1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
760
11
884
44
hidden/view-firms
ifelse (f-visibility = 1)\n[set f-visibility 0] [set f-visibility 1]\nhide-show-turtles
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
760
45
884
78
hidden/view-workers
ifelse (w-visibility = 1)\n[set w-visibility 0] [set w-visibility 1]\nhide-show-turtles
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
667
10
750
43
plot-renew
urban-regeneration
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
667
44
751
77
newsubflat
develop-sub-housing
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
1103
10
1190
59
total-support
count UGs
0
1
12

PLOT
1473
10
1929
304
demand-supply
time
m-yuan/mth
0.0
24.0
0.0
24.0
true
true
"" ""
PENS
"supply" 1.0 0 -13840069 true "" ""
"demand" 1.0 0 -2674135 true "" ""

PLOT
1934
11
2389
305
firm-worker-number
time
number
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"firm" 1.0 0 -2674135 true "" ""
"worker" 1.0 0 -13840069 true "" ""
"policy" 1.0 0 -5825686 true "" ""

PLOT
1473
305
1928
600
f-cluster-check-Q
time
NIL
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"q-value" 1.0 0 -2674135 true "" ""
"z-stat" 1.0 0 -13840069 true "" ""

PLOT
1473
1202
1927
1500
w-number-distribution-time
distance
number
0.0
24.0
0.0
200.0
true
true
"" ""
PENS
"1" 1.0 0 -7500403 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -13840069 true "" ""
"8" 1.0 0 -14835848 true "" ""
"9" 1.0 0 -11221820 true "" ""
"10" 1.0 0 -13791810 true "" ""

PLOT
981
1344
1438
1640
house-rent
time
price
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"1" 1.0 0 -16777216 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -987046 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -6759204 true "" ""
"8" 1.0 0 -14462382 true "" ""
"9" 1.0 0 -13791810 true "" ""
"10" 1.0 0 -8630108 true "" ""

PLOT
1934
1206
2391
1501
w-density-distribution-time
time
density
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"1" 1.0 0 -16777216 true "" ""
"2" 1.0 0 -8053223 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -14835848 true "" ""
"8" 1.0 0 -11221820 true "" ""
"9" 1.0 0 -13791810 true "" ""
"10" 1.0 0 -10141563 true "" ""

PLOT
1935
904
2389
1200
f-density-distribution-time
time
density
0.0
24.0
0.0
3.0
true
true
"" ""
PENS
"1" 1.0 0 -16777216 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -5207188 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -14835848 true "" ""
"8" 1.0 0 -11221820 true "" ""
"9" 1.0 0 -13345367 true "" ""
"10" 1.0 0 -7858858 true "" ""

PLOT
1471
1504
1929
1798
p-number-distribution-time
time
number
0.0
24.0
0.0
5.0
true
true
"" ""
PENS
"1" 1.0 0 -16777216 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -14835848 true "" ""
"8" 1.0 0 -11221820 true "" ""
"9" 1.0 0 -13791810 true "" ""
"10" 1.0 0 -8630108 true "" ""

PLOT
1934
306
2389
602
w-cluster-check-Q
time
NIL
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"q-value" 1.0 0 -2674135 true "" ""
"z-stat" 1.0 0 -13840069 true "" ""

PLOT
513
1047
970
1341
in-problem-agents
time
NIL
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"nojob" 1.0 0 -16777216 true "" ""
"nohome" 1.0 0 -2674135 true "" ""
"noland" 1.0 0 -10899396 true "" ""

PLOT
50
1049
507
1342
in-problem-rate
time
NIL
0.0
24.0
0.0
0.5
true
true
"" ""
PENS
"nojob" 1.0 0 -16777216 true "" ""
"nohome" 1.0 0 -2674135 true "" ""
"noland" 1.0 0 -10899396 true "" ""

PLOT
1473
605
1929
901
f-cluster-check-N
time
NIL
0.0
24.0
0.0
1.0
true
true
"" ""
PENS
"r-value" 1.0 0 -2674135 true "" ""
"z-stat" 1.0 0 -13840069 true "" ""

PLOT
1934
606
2390
902
w-cluster-check-N
time
NIL
0.0
24.0
0.0
1.0
true
true
"" ""
PENS
"r-value" 1.0 0 -2674135 true "" ""
"z-stat" 1.0 0 -13840069 true "" ""

PLOT
511
1346
971
1640
firm-size
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"max" 1.0 0 -16777216 true "" ""
"median" 1.0 0 -2674135 true "" ""
"min" 1.0 0 -1184463 true "" ""
"s-dev" 1.0 0 -10899396 true "" ""
"mean" 1.0 0 -13345367 true "" ""

PLOT
49
1345
506
1639
worker-income
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"max" 1.0 0 -16777216 true "" ""
"median" 1.0 0 -2674135 true "" ""
"min" 1.0 0 -1184463 true "" ""
"s-dev" 1.0 0 -13791810 true "" ""
"mean" 1.0 0 -13840069 true "" ""

SLIDER
162
532
395
565
growth-rate-cycle
growth-rate-cycle
0
12
0
3
1
mth
HORIZONTAL

SLIDER
1
779
284
812
f-moving-critical-land-expense-rate
f-moving-critical-land-expense-rate
0.01
1
0.2
0.01
1
NIL
HORIZONTAL

PLOT
981
1046
1438
1342
land-rent
time
price
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"1" 1.0 0 -7500403 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -13840069 true "" ""
"8" 1.0 0 -14835848 true "" ""
"9" 1.0 0 -11221820 true "" ""
"10" 1.0 0 -13791810 true "" ""

PLOT
1473
905
1928
1199
f-number-distribution-time
time
number
0.0
24.0
0.0
10.0
true
true
"" ""
PENS
"1" 1.0 0 -7500403 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -13840069 true "" ""
"8" 1.0 0 -14835848 true "" ""
"9" 1.0 0 -11221820 true "" ""
"10" 1.0 0 -13791810 true "" ""

PLOT
1933
1505
2391
1797
p-density-distribution-time
time
density
0.0
24.0
0.0
0.01
true
true
"" ""
PENS
"1" 1.0 0 -7500403 true "" ""
"2" 1.0 0 -2674135 true "" ""
"3" 1.0 0 -955883 true "" ""
"4" 1.0 0 -6459832 true "" ""
"5" 1.0 0 -1184463 true "" ""
"6" 1.0 0 -10899396 true "" ""
"7" 1.0 0 -13840069 true "" ""
"8" 1.0 0 -14835848 true "" ""
"9" 1.0 0 -11221820 true "" ""
"10" 1.0 0 -13791810 true "" ""

@#$#@#$#@
## WHAT IS IT?

It is a model to examine the dynamics of the interaction between the development of creative industries and urban spatial structure.

## HOW IT WORKS

For more details of the mechanism, please refer to 
Liu, H. and Silva, E. A. (2013) 'Simulating the Dynamics Between the Development of Creative Industries and Urban Spatial Structure: An Agent-Based Model ' in Geertman, S., Toppen, F. and Stillwell, J., eds., Planning Support  Systems for Sustainable Urban Development, Berlin Heidelberg: Springer-Verlag Berlin Heidelberg.

## HOW TO USE IT

for more details, please refer to 
Liu, H. and Silva, E. A. (2013) 'Simulating the Dynamics Between the Development of Creative Industries and Urban Spatial Structure: An Agent-Based Model ' in Geertman, S., Toppen, F. and Stillwell, J., eds., Planning Support  Systems for Sustainable Urban Development, Berlin Heidelberg: Springer-Verlag Berlin Heidelberg.

Liu,H. and Silva, E. A. (2014) creative industries urban model:structure and functioning, Urban Design and Planning, 

## THINGS TO NOTICE

This is a simplified version of the original one. Some functionalities are not available. If you want to have the full version, please contact the author for more help.
## THINGS TO TRY

For more information, please refer to 
Liu, H. and Silva, E. A. (2013) 'Simulating the Dynamics Between the Development of Creative Industries and Urban Spatial Structure: An Agent-Based Model ' in Geertman, S., Toppen, F. and Stillwell, J., eds., Planning Support  Systems for Sustainable Urban Development, Berlin Heidelberg: Springer-Verlag Berlin Heidelberg.

## EXTENDING THE MODEL

The model is based on a case of Nanjing, China. It is also possible to apply it to other cases. However, to apply it to other cases, some adaption is needed. For more information, please refer to 

Liu, H. (2013). Dynamics of the interaction between the development of creative industries and urban spatial structure - A case study of Nanjing, China. (Ph. D), The University of Cambridge, Cambridge. 

http://www.landecon.cam.ac.uk/Research/lisa-lab-of-interdisciplinary-spatial-analysis
  

## NETLOGO FEATURES

This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

## RELATED MODELS

A further developed model based on GIS map and its application in Jiading, Shanghai,China gives more details of its application to real policy making. Please refer to the website 
http://www.landecon.cam.ac.uk/Research/lisa-lab-of-interdisciplinary-spatial-analysis

## CREDITS AND REFERENCES

To cite this model: 
Liu, H. and Silva, E. A. (2013) 'Simulating the Dynamics Between the Development of Creative Industries and Urban Spatial Structure: An Agent-Based Model ' in Geertman, S., Toppen, F. and Stillwell, J., eds., Planning Support  Systems for Sustainable Urban Development, Berlin Heidelberg: Springer-Verlag Berlin Heidelberg.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

firm
false
0
Rectangle -7500403 true true 30 30 255 180
Polygon -7500403 false true 0 210 30 180 255 180 285 210
Polygon -7500403 false true 0 210 60 225 225 225 285 210
Polygon -955883 true false 105 180 120 105 150 105 180 135 135 120
Rectangle -955883 true false 120 75 150 105
Circle -955883 true false 120 45 30
Polygon -955883 true false 120 75 105 75 90 105 120 75
Polygon -955883 true false 150 75 165 75 180 90
Circle -13840069 false false 150 135 30
Rectangle -13840069 true false 135 195 150 210
Rectangle -13840069 true false 105 195 120 210
Rectangle -13840069 true false 75 195 90 210
Rectangle -13840069 true false 45 195 60 210
Rectangle -13840069 true false 165 195 180 210
Rectangle -13840069 true false 195 195 210 210
Rectangle -13840069 true false 225 195 240 210
Rectangle -13840069 true false 30 180 45 195
Rectangle -13840069 true false 60 180 75 195
Rectangle -13840069 true false 90 180 105 195
Rectangle -13840069 true false 120 180 135 195
Rectangle -13840069 true false 150 180 165 195
Rectangle -13840069 true false 180 180 195 195
Rectangle -13840069 true false 210 180 225 195
Rectangle -13840069 true false 15 195 30 210
Rectangle -13840069 true false 240 180 255 195
Rectangle -13840069 true false 255 195 270 210

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

junct
true
0
Circle -7500403 false true 54 54 192
Line -7500403 true 150 60 60 150
Line -7500403 true 150 60 240 150
Line -7500403 true 60 150 150 240
Line -7500403 true 240 150 150 240
Line -7500403 true 150 60 150 240
Line -7500403 true 60 150 240 150
Circle -7500403 false true 129 39 42

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

oldfactory
true
0
Rectangle -7500403 false true 60 165 240 240
Rectangle -7500403 true true 75 165 90 240
Rectangle -7500403 true true 120 165 135 240
Rectangle -7500403 true true 165 165 180 240
Rectangle -7500403 true true 210 165 225 240
Polygon -7500403 false true 105 165 105 75 120 75 120 165
Polygon -7500403 false true 150 165 150 120 150 105 165 105 165 165
Polygon -7500403 false true 195 165 195 135 210 135 210 165
Polygon -7500403 false true 120 60 105 45 120 45 120 60
Polygon -7500403 false true 120 30 105 30 120 15
Polygon -7500403 false true 165 90 150 75 165 75 165 90
Polygon -7500403 false true 210 120 195 105 210 105 210 120
Polygon -7500403 false true 210 90 195 75 195 90 210 90
Polygon -7500403 false true 165 60 150 45 150 60 165 60
Polygon -7500403 false true 210 60 210 45 195 60 210 60

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

sub-creator
true
14
Polygon -2674135 true false 30 165 105 225 150 45 180 225 255 165

sub-station
true
0
Circle -7500403 true true 60 60 180
Circle -16777216 true false 105 105 90
Rectangle -2674135 true false 60 135 240 165

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

university
false
0
Polygon -7500403 false true 150 105 75 90 75 210 150 195 225 210 225 90
Polygon -7500403 false true 150 105 90 90 90 210 150 195 210 210 210 90
Polygon -7500403 false true 150 105 105 90 105 210 150 195 195 210 195 90
Polygon -955883 true false 120 120 135 180 165 180 180 120 165 120 150 165 135 120

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup
set CIs-special one-of (CIs with [got-land-or-not = 1])
set CWs-special one-of (CWs with [got-job-or-not = 1 and got-housing-or-not = 1])
set UGs-special one-of (UGs with [[urban-area] of patch-here = "outer-city-proper"])
set plot-special one-of (patches with [urban-area = "outer-city-proper"])</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>[xcor] of CIs-special</metric>
    <metric>[ycor] of CIs-special</metric>
    <metric>[ci-utility] of CIs-special</metric>
    <metric>[got-land-or-not] of CIs-special</metric>
    <metric>[off-land-time] of CIs-special</metric>
    <metric>[expected-size] of CIs-special</metric>
    <metric>[real-size] of CIs-special</metric>
    <metric>[output] of CIs-special</metric>
    <metric>[land-expense-rate] of CIs-special</metric>
    <metric>[profit-rate] of CIs-special</metric>
    <metric>[profit] of CIs-special</metric>
    <metric>[tax-percent] of CIs-special</metric>
    <metric>[tax-paid] of CIs-special</metric>
    <metric>[capital] of CIs-special</metric>
    <metric>[nearest-distance] of CIs-special</metric>
    <metric>[xcor] of CWs-special</metric>
    <metric>[ycor] of CWs-special</metric>
    <metric>[cw-utility] of CWs-special</metric>
    <metric>[got-housing-or-not] of CWs-special</metric>
    <metric>[off-home-time] of CWs-special</metric>
    <metric>[got-job-or-not] of CWs-special</metric>
    <metric>[off-job-time] of CWs-special</metric>
    <metric>[real-income] of CWs-special</metric>
    <metric>[capability] of CWs-special</metric>
    <metric>[company-id] of CWs-special</metric>
    <metric>[nearest-distance] of CWs-special</metric>
    <metric>[about-to-move] of CWs-special</metric>
    <metric>[policy-code] of UGs-special</metric>
    <metric>[tax-abate-rate] of UGs-special</metric>
    <metric>[land-rent-abate-rate] of UGs-special</metric>
    <metric>[milieu-promote-rate] of UGs-special</metric>
    <metric>[planned-time-in-service] of UGs-special</metric>
    <metric>[real-time-in-service] of UGs-special</metric>
    <metric>[pxcor] of plot-special</metric>
    <metric>[pycor] of plot-special</metric>
    <metric>[transport-mark] of plot-special</metric>
    <metric>[milieu-mark] of plot-special</metric>
    <metric>[talent-mark] of plot-special</metric>
    <metric>[proximity-mark] of plot-special</metric>
    <metric>[land-rent] of plot-special</metric>
    <metric>[housing-rent] of plot-special</metric>
    <metric>[building-quality] of plot-special</metric>
    <metric>[policy-mark] of plot-special</metric>
    <metric>[f-real-volume] of plot-special</metric>
    <metric>[w-real-volume] of plot-special</metric>
    <metric>[tax-reduction-rate] of plot-special</metric>
    <metric>[patch-firm-number] of plot-special</metric>
    <metric>[patch-worker-number] of plot-special</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="101"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment2" repetitions="1" runMetricsEveryStep="true">
    <setup>setup
set CIs-special one-of (CIs with [real-size &gt; 10])
set CWs-special one-of (CWs with [got-job-or-not = 1])
set UGs-special one-of (UGs with [[urban-area] of patch-here = "outer-city-proper"])
set plot-special one-of (patches with [urban-area = "outer-city-proper"])</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>[xcor] of CIs-special</metric>
    <metric>[ycor] of CIs-special</metric>
    <metric>[ci-utility] of CIs-special</metric>
    <metric>[got-land-or-not] of CIs-special</metric>
    <metric>[off-land-time] of CIs-special</metric>
    <metric>[expected-size] of CIs-special</metric>
    <metric>[real-size] of CIs-special</metric>
    <metric>[output] of CIs-special</metric>
    <metric>[land-expense-rate] of CIs-special</metric>
    <metric>[profit-rate] of CIs-special</metric>
    <metric>[profit] of CIs-special</metric>
    <metric>[tax-percent] of CIs-special</metric>
    <metric>[tax-paid] of CIs-special</metric>
    <metric>[capital] of CIs-special</metric>
    <metric>[nearest-distance] of CIs-special</metric>
    <metric>[xcor] of CWs-special</metric>
    <metric>[ycor] of CWs-special</metric>
    <metric>[cw-utility] of CWs-special</metric>
    <metric>[got-housing-or-not] of CWs-special</metric>
    <metric>[off-home-time] of CWs-special</metric>
    <metric>[got-job-or-not] of CWs-special</metric>
    <metric>[off-job-time] of CWs-special</metric>
    <metric>[real-income] of CWs-special</metric>
    <metric>[capability] of CWs-special</metric>
    <metric>[company-id] of CWs-special</metric>
    <metric>[nearest-distance] of CWs-special</metric>
    <metric>[about-to-move] of CWs-special</metric>
    <metric>[policy-code] of UGs-special</metric>
    <metric>[tax-abate-rate] of UGs-special</metric>
    <metric>[land-rent-abate-rate] of UGs-special</metric>
    <metric>[milieu-promote-rate] of UGs-special</metric>
    <metric>[planned-time-in-service] of UGs-special</metric>
    <metric>[real-time-in-service] of UGs-special</metric>
    <metric>[pxcor] of plot-special</metric>
    <metric>[pycor] of plot-special</metric>
    <metric>[transport-mark] of plot-special</metric>
    <metric>[milieu-mark] of plot-special</metric>
    <metric>[talent-mark] of plot-special</metric>
    <metric>[proximity-mark] of plot-special</metric>
    <metric>[land-rent] of plot-special</metric>
    <metric>[housing-rent] of plot-special</metric>
    <metric>[building-quality] of plot-special</metric>
    <metric>[policy-mark] of plot-special</metric>
    <metric>[f-real-volume] of plot-special</metric>
    <metric>[w-real-volume] of plot-special</metric>
    <metric>[tax-reduction-rate] of plot-special</metric>
    <metric>[patch-firm-number] of plot-special</metric>
    <metric>[patch-worker-number] of plot-special</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.9"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="73"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-stability" repetitions="40" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="73"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment2-individual" repetitions="1" runMetricsEveryStep="true">
    <setup>setup
set CIs-special n-of 5 (CIs with [real-size &gt; 10])
set CWs-special n-of 10 (CWs with [got-job-or-not = 1])
set UGs-special one-of (UGs with [[urban-area] of patch-here = "outer-city-proper"])
set plot-special n-of 10 (patches with [urban-area = "outer-city-proper"])</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>[xcor] of CIs-special</metric>
    <metric>[ycor] of CIs-special</metric>
    <metric>[ci-utility] of CIs-special</metric>
    <metric>[got-land-or-not] of CIs-special</metric>
    <metric>[off-land-time] of CIs-special</metric>
    <metric>[expected-size] of CIs-special</metric>
    <metric>[real-size] of CIs-special</metric>
    <metric>[output] of CIs-special</metric>
    <metric>[land-expense-rate] of CIs-special</metric>
    <metric>[profit-rate] of CIs-special</metric>
    <metric>[profit] of CIs-special</metric>
    <metric>[tax-percent] of CIs-special</metric>
    <metric>[tax-paid] of CIs-special</metric>
    <metric>[capital] of CIs-special</metric>
    <metric>[nearest-distance] of CIs-special</metric>
    <metric>[xcor] of CWs-special</metric>
    <metric>[ycor] of CWs-special</metric>
    <metric>[cw-utility] of CWs-special</metric>
    <metric>[got-housing-or-not] of CWs-special</metric>
    <metric>[off-home-time] of CWs-special</metric>
    <metric>[got-job-or-not] of CWs-special</metric>
    <metric>[off-job-time] of CWs-special</metric>
    <metric>[real-income] of CWs-special</metric>
    <metric>[capability] of CWs-special</metric>
    <metric>[company-id] of CWs-special</metric>
    <metric>[nearest-distance] of CWs-special</metric>
    <metric>[about-to-move] of CWs-special</metric>
    <metric>[policy-code] of UGs-special</metric>
    <metric>[tax-abate-rate] of UGs-special</metric>
    <metric>[land-rent-abate-rate] of UGs-special</metric>
    <metric>[milieu-promote-rate] of UGs-special</metric>
    <metric>[planned-time-in-service] of UGs-special</metric>
    <metric>[real-time-in-service] of UGs-special</metric>
    <metric>[pxcor] of plot-special</metric>
    <metric>[pycor] of plot-special</metric>
    <metric>[transport-mark] of plot-special</metric>
    <metric>[milieu-mark] of plot-special</metric>
    <metric>[talent-mark] of plot-special</metric>
    <metric>[proximity-mark] of plot-special</metric>
    <metric>[land-rent] of plot-special</metric>
    <metric>[housing-rent] of plot-special</metric>
    <metric>[building-quality] of plot-special</metric>
    <metric>[policy-mark] of plot-special</metric>
    <metric>[f-real-volume] of plot-special</metric>
    <metric>[w-real-volume] of plot-special</metric>
    <metric>[tax-reduction-rate] of plot-special</metric>
    <metric>[patch-firm-number] of plot-special</metric>
    <metric>[patch-worker-number] of plot-special</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.9"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="73"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="3030"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="40"/>
      <value value="80"/>
      <value value="100"/>
      <value value="200"/>
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="12"/>
      <value value="24"/>
      <value value="36"/>
      <value value="48"/>
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="1"/>
      <value value="10"/>
      <value value="30"/>
      <value value="60"/>
      <value value="120"/>
      <value value="180"/>
      <value value="270"/>
      <value value="360"/>
      <value value="450"/>
      <value value="500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.5"/>
      <value value="0.6"/>
      <value value="0.7"/>
      <value value="0.8"/>
      <value value="0.9"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="20"/>
      <value value="50"/>
      <value value="100"/>
      <value value="200"/>
      <value value="400"/>
      <value value="600"/>
      <value value="1000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="1"/>
      <value value="3"/>
      <value value="6"/>
      <value value="9"/>
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="1"/>
      <value value="3"/>
      <value value="6"/>
      <value value="9"/>
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="-1"/>
      <value value="-0.8"/>
      <value value="-0.5"/>
      <value value="-0.2"/>
      <value value="0.1"/>
      <value value="0"/>
      <value value="0.1"/>
      <value value="0.3"/>
      <value value="0.5"/>
      <value value="0.7"/>
      <value value="0.9"/>
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="1"/>
      <value value="10"/>
      <value value="30"/>
      <value value="60"/>
      <value value="90"/>
      <value value="180"/>
      <value value="360"/>
      <value value="720"/>
      <value value="1500"/>
      <value value="3000"/>
      <value value="6000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="15"/>
      <value value="20"/>
      <value value="25"/>
      <value value="30"/>
      <value value="35"/>
      <value value="40"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="1"/>
      <value value="3"/>
      <value value="6"/>
      <value value="9"/>
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-stability" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-city-proper&quot;"/>
      <value value="&quot;outer-city-proper&quot;"/>
      <value value="&quot;outer-suburb&quot;"/>
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="73"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-city-proper&quot;"/>
      <value value="&quot;outer-city-proper&quot;"/>
      <value value="&quot;outer-suburb&quot;"/>
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="73"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
      <value value="&quot;none&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;high&quot;"/>
      <value value="&quot;medium&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-policy" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-city-proper&quot;"/>
      <value value="&quot;outer-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-subway" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
      <value value="&quot;high&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-ind-park" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;high&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-road-density" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;high&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-green-park" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;inner-suburb&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;high&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-policy-num" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;high&quot;"/>
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-policy-duration" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-maxtime-jobhunting" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
      <value value="50"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-maxtime-failure-findingjobs" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="3"/>
      <value value="6"/>
      <value value="12"/>
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-maxtime-office-searching" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="5"/>
      <value value="60"/>
      <value value="100"/>
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-maxtime-failure-findingoffice" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="3"/>
      <value value="6"/>
      <value value="9"/>
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-sensitivity-base-product-demand" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="100"/>
      <value value="300"/>
      <value value="600"/>
      <value value="1000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-simulate Nanjing-final" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="117"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-scenario-06" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="117"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-scenario-07" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="120"/>
    <metric>total-production</metric>
    <metric>total-demand</metric>
    <metric>employment-rate</metric>
    <metric>f-quadrat</metric>
    <metric>w-quadrat</metric>
    <metric>Q-z-f-test</metric>
    <metric>Q-z-w-test</metric>
    <metric>R-f</metric>
    <metric>N-z-stat-f</metric>
    <metric>R-w</metric>
    <metric>N-z-stat-w</metric>
    <metric>CIs-num</metric>
    <metric>CWs-num</metric>
    <metric>UGs-num</metric>
    <metric>noland-CIs-num</metric>
    <metric>nojob-CWs-num</metric>
    <metric>nohome-CWs-num</metric>
    <metric>noland-CIs-rate</metric>
    <metric>nojob-CWs-rate</metric>
    <metric>nohome-CWs-rate</metric>
    <metric>total-patch-firm-ok-num-1</metric>
    <metric>total-patch-firm-ok-num-2</metric>
    <metric>total-patch-firm-ok-num-3</metric>
    <metric>total-patch-firm-ok-num-4</metric>
    <metric>total-patch-firm-ok-num-5</metric>
    <metric>total-patch-firm-ok-num-6</metric>
    <metric>total-patch-firm-ok-num-7</metric>
    <metric>total-patch-firm-ok-num-8</metric>
    <metric>total-patch-firm-ok-num-9</metric>
    <metric>total-patch-firm-ok-num-10</metric>
    <metric>f-1-density</metric>
    <metric>f-2-density</metric>
    <metric>f-3-density</metric>
    <metric>f-4-density</metric>
    <metric>f-5-density</metric>
    <metric>f-6-density</metric>
    <metric>f-7-density</metric>
    <metric>f-8-density</metric>
    <metric>f-9-density</metric>
    <metric>f-10-density</metric>
    <metric>total-patch-worker-ok-num-1</metric>
    <metric>total-patch-worker-ok-num-2</metric>
    <metric>total-patch-worker-ok-num-3</metric>
    <metric>total-patch-worker-ok-num-4</metric>
    <metric>total-patch-worker-ok-num-5</metric>
    <metric>total-patch-worker-ok-num-6</metric>
    <metric>total-patch-worker-ok-num-7</metric>
    <metric>total-patch-worker-ok-num-8</metric>
    <metric>total-patch-worker-ok-num-9</metric>
    <metric>total-patch-worker-ok-num-10</metric>
    <metric>w-1-density</metric>
    <metric>w-2-density</metric>
    <metric>w-3-density</metric>
    <metric>w-4-density</metric>
    <metric>w-5-density</metric>
    <metric>w-6-density</metric>
    <metric>w-7-density</metric>
    <metric>w-8-density</metric>
    <metric>w-9-density</metric>
    <metric>w-10-density</metric>
    <metric>land-rent-1-mean</metric>
    <metric>land-rent-2-mean</metric>
    <metric>land-rent-3-mean</metric>
    <metric>land-rent-4-mean</metric>
    <metric>land-rent-5-mean</metric>
    <metric>land-rent-6-mean</metric>
    <metric>land-rent-7-mean</metric>
    <metric>land-rent-8-mean</metric>
    <metric>land-rent-9-mean</metric>
    <metric>land-rent-10-mean</metric>
    <metric>housing-rent-1-mean</metric>
    <metric>housing-rent-2-mean</metric>
    <metric>housing-rent-3-mean</metric>
    <metric>housing-rent-4-mean</metric>
    <metric>housing-rent-5-mean</metric>
    <metric>housing-rent-6-mean</metric>
    <metric>housing-rent-7-mean</metric>
    <metric>housing-rent-8-mean</metric>
    <metric>housing-rent-9-mean</metric>
    <metric>housing-rent-10-mean</metric>
    <metric>firm-real-size-max</metric>
    <metric>firm-real-size-min</metric>
    <metric>firm-real-size-mean</metric>
    <metric>firm-real-size-median</metric>
    <metric>worker-income-max</metric>
    <metric>worker-income-min</metric>
    <metric>worker-income-mean</metric>
    <metric>worker-income-median</metric>
    <enumeratedValueSet variable="maxtimes-officesearching">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-num-increase-critical-D/S-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="w-num-increase-critical-employ-rate">
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="policy-support">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-suffer-housingrent">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="river-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-jobs">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-decline-critical-negprofit-rate">
      <value value="-0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="culture-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-factory-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lake-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="suburban-housing">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cloverleaf-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="add-or-abolish-number">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="subway-number">
      <value value="&quot;low&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="b-tax-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-housingfinding">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="growth-rate-cycle">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mean-tenure">
      <value value="60"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hill-number">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtime-failure-finding-office">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-size-expansion-critical-profit-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="base-product-demand">
      <value value="117"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ind-park-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="road-density">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="f-moving-critical-land-expense-rate">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-CW">
      <value value="303"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="demand-monthly-growth-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="univ-etc-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="old-housing-num">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxtimes-jobhunting">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="dailyshopping">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-number-firm">
      <value value="30"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="green-park-number">
      <value value="&quot;medium&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="prior-area">
      <value value="&quot;outer-city-proper&quot;"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

sub
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0

@#$#@#$#@
0
@#$#@#$#@
