globals
[
 
is-answered?  ;; this is a flag that indicates whether question was answered, if it does(true or false) set this flag to TRUE - this is how we know we want to continue to the next question
correct-answer-counter
questions-counter
max-questions
max-rounds
round-counter
]

;;; instead of TURTLES you can define your own agents:
breed [questions question]
breed [answers answer]
;;; this will be one of the answer agent attributes
answers-own[ am-i-the-answer? id]

to setup
  clear-all
  ;reset-timer
 
  fill-background
 
  set-current-plot-pen "round1"
  set is-answered? false
  set correct-answer-counter 0
  set questions-counter 1
  set max-questions 10
  set max-rounds number-of-rounds
  set round-counter 1
  ;;; setting first question - next question will be set in the go function
  create-questions 1 [set shape "shape1" set heading 0  setxy 0 6 set size size * 19 ]
  ;;; setting first answers
  create-answers 1 [set shape "shape1" set heading 0 setxy 10 -6 set heading 90 set size size * 15 set am-i-the-answer? true set id 1]
  create-answers 1 [set shape "shape2" set heading 0 setxy 0 -6 set size size * 15 set am-i-the-answer? false set id 2]
  create-answers 1 [set shape "shape4" set heading 0 setxy -10 -6 set size size * 15 set am-i-the-answer? false set id 3]
  reset-ticks
end

to fill-background
  let chosen-color blue
  ask patches [set pcolor chosen-color + pxcor / max-pxcor]
  ask patches with [pxcor > min-pxcor and pxcor < max-pxcor and pycor < 1 and pycor > -12][set pcolor black]
  ask patches with [pxcor > -8 and pxcor < 8 and pycor > -2 and pycor < 15][set pcolor black]
end

to go
  tick
  if ticks <= 1 [ reset-timer ]
  if mouse-down? and not is-answered?
  [
    ask questions[
    if mouse-ycor > ycor - size / 3  and mouse-ycor < ycor + size / 3 and mouse-xcor > xcor - size / 3 and mouse-xcor < xcor + size / 3
    [
      
     set heading heading + 12 
    ]
    ]
    
    if mouse-ycor > [ycor - size / 3] of one-of answers and mouse-ycor < [ycor + size / 3] of one-of answers
    [
      ask answers[
        if mouse-xcor > xcor - size / 3 and mouse-xcor < xcor + size / 3
        [
          
          ifelse  am-i-the-answer?
          [
            ;set size 10
            set shape "face happy"
            ;wait 
            set is-answered? true
            set correct-answer-counter correct-answer-counter + 1
            display
          ]
          
          [
            set shape "face sad"
            ;wait 1
            set is-answered? true
            display
          ]
          
          
          
        ]
      ]
      
    ]
    
    
  ]
  
  if is-answered?
  [
       plotxy questions-counter timer
       reset-timer
   set questions-counter questions-counter + 1 ;;; go to the next question
   wait 0.5

  ; reset-timer
   if questions-counter > max-questions ;;round ended
   [
     print (word "You got " correct-answer-counter " correct answers out of " max-questions "!") 
     ifelse round-counter < max-rounds
     [
       
     set round-counter round-counter + 1
     set-current-plot-pen (word "round" round-counter)
     set questions-counter 1
     set correct-answer-counter 0
     ]
     [stop]
     
     
     ] ;;; if no more questions print results and stop the main GO loop
   
   

   if questions-counter = 1
   [
     
       ask questions [set shape "shape1" set heading 0  ]
  ;;; setting first answers
  ask answers with [id = 1] [set shape "shape1"  set heading 90 set am-i-the-answer? true ]
  ask answers with [id = 2] [set shape "shape2" set heading 0  set am-i-the-answer? false ]
  ask answers with [id = 3] [set shape "shape4" set heading 0  set am-i-the-answer? false ]
     
     
   ]  
   if questions-counter = 2
   [
     ;;;; set next question 
     ask questions [set shape "shape5" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape6"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 90
       set shape "shape7"
       set am-i-the-answer? false
     ]
     ask answers with [id = 3] 
     [
       set heading 180
       set shape "shape5"
       set am-i-the-answer? true
     ]
   ]
   if questions-counter = 3
   [
     ;;;; set next question 
     ask questions [set shape "shape8" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape9"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 120
       set shape "shape8"
       set am-i-the-answer? true
     ]
     ask answers with [id = 3] 
     [
       set heading 90
       set shape "shape10"
       set am-i-the-answer? false
     ]
   ]
    if questions-counter = 4
   [
     ;;;; set next question 
     ask questions [set shape "shape11" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape12"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 120
       set shape "shape11"
       set am-i-the-answer? true
     ]
     ask answers with [id = 3] 
     [
       set heading 90
       set shape "shape13"
       set am-i-the-answer? false
     ]]
   if questions-counter = 5
   [
     ;;;; set next question 
     ask questions [set shape "shape14" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape15"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 90
       set shape "shape16"
       set am-i-the-answer? false
     ]
     ask answers with [id = 3] 
     [
       set heading 180
       set shape "shape14"
       set am-i-the-answer? true
     ]
   ]
    if questions-counter = 6
   [
      ;;;; set next question
       ask questions [set shape "shape17" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 90
       set shape "shape17"
       set am-i-the-answer? true
     ]
     ask answers with [id = 2] 
     [
       set heading 90
       set shape "shape18"
       set am-i-the-answer? false
     ]
     ask answers with [id = 3] 
     [
       set heading 180
       set shape "shape19"
       set am-i-the-answer? false]]
   
     if questions-counter = 7
   [
     ;;;; set next question 
     ask questions [set shape "shape20" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape21"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 45
       set shape "shape20"
       set am-i-the-answer? true
     ]
     ask answers with [id = 3] 
     [
       set heading 90
       set shape "shape22"
       set am-i-the-answer? false
     ]
   ]
     if questions-counter = 8
   [
     ;;;; set next question 
     ask questions [set shape "shape23" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape24"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 120
       set shape "shape23"
       set am-i-the-answer? true
     ]
     ask answers with [id = 3] 
     [
       set heading 90
       set shape "shape25"
       set am-i-the-answer? false
     ]]
       
         if questions-counter = 9
   [
      ;;;; set next question
       ask questions [set shape "shape26" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 90
       set shape "shape26"
       set am-i-the-answer? true
     ]
     ask answers with [id = 2] 
     [
       set heading 0
       set shape "shape27"
       set am-i-the-answer? false
     ]
     ask answers with [id = 3] 
     [
       set heading 180
       set shape "shape28"
       set am-i-the-answer? false]]
   
   if questions-counter = 10
   [
     ;;;; set next question 
     ask questions [set shape "shape29" set heading 0]
     ask answers with [id = 1] 
     [
       set heading 0
       set shape "shape30"
       set am-i-the-answer? false
     ]
     ask answers with [id = 2] 
     [
       set heading 90
       set shape "shape31"
       set am-i-the-answer? false
     ]
     ask answers with [id = 3] 
     [
       set heading 60
       set shape "shape29"
       set am-i-the-answer? true
     ]

   ]
   ;;;; set next answers
   ;;; for each and every answer set the "am-i-the-answer?" value to TRUE or FALSE
   set is-answered? false 
  ]
  
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
63
93
126
126
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
63
137
126
170
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
711
100
779
145
NIL
floor(timer)
17
1
11

PLOT
686
219
886
369
plot-speed
question number
seconds
1.0
10.0
0.0
30.0
true
false
"" ""
PENS
"round1" 1.0 0 -14439633 true "" ""
"round2" 1.0 0 -14070903 true "" ""
"round3" 1.0 0 -5298144 true "" ""
"round4" 1.0 0 -1184463 true "" ""
"round5" 1.0 0 -5825686 true "" ""
"round6" 1.0 0 -16710653 true "" ""
"round7" 1.0 0 -11085214 true "" ""
"round8" 1.0 0 -955883 true "" ""
"round9" 1.0 0 -15637942 true "" ""
"round10" 1.0 0 -2064490 true "" ""

SLIDER
45
208
176
241
number-of-rounds
number-of-rounds
1
10
3
1
1
NIL
HORIZONTAL

MONITOR
728
40
821
85
NIL
round-counter
17
1
11

@#$#@#$#@
## WHAT IS IT?

The model is considered as a kind of learning environment. It supports the learning procces of a phsycological ability of mental rotation. The model was build to give the pupils the chance to practice their abilities of shape recognition even after the shape has been rotated. The pupil will have fun, practise and learn by running and interacting with this model. 

## HOW IT WORKS
In order to start using the model (playing the game) the pupil needs to press on the button of "setup" then "go". The game will start. a shape will apear in the upper side of the screen. Three other smaller shapes will appear in the lower side of the screen. Only one of the three shapes is the same upper shape but after rotation.The pupil can press several times on the original shape and it will rotate, until he/she decides which one is the same shape. So he/she can press on the correct answer. and move automatically to the next question.  

## HOW TO USE IT

By pressing on the button of "setup" the model is ready for use. The pupil must decide the number of rounds he/she wants to play before starting the game.  after that the pupil needs to press on "go" to get started. A plot of "round counter" shows the round the pupil is playing in, when the pupil starts in the second round it will show the number 2. Another plot called "floor (timer)" shows the whole time from the beginning to the end. The last plot is showing the time of seconds the pupil takes to answer each question 1-10. Each round will appear in different color so the pupil or the guide can compare between the rounds and how it is turning the game to easier by the time. At the end of each round a feedback appears in the command center box telling the pupil how many correct answers out of 10 he/she has got.


## THINGS TO NOTICE

The pupil or the guide can notice the differences in the time (by seconds) the pupil spends in answering each question. Time differences may be noticed between the first round and the second.All the differences will be shown in the plot that shows the question from 1 until 10. And the time in seconds for each question. Each round has a different color.

## THINGS TO TRY
Try to change the number of the rounds in the slider before starting the game. Try to answer the questions will less time in each round. And less wrong answers.

## EXTENDING THE MODEL

The existing model contains only two-dimensional shapes. It can be extended to contain more questions. The shapes may be 3D shapes.Then it will be more complicated. The pupil may be asked to recognize the shape from the Top/front/side view.

## NETLOGO FEATURES

Many special Netlogo Features helped and supported building the "game" in this successful way. 
In the Code tab: The command of "If mouse down" made it capable to be activated by the pupils. It gives the chance to interact with the game. to click on the different shapes.
In order to make more shapes that are so similar I used "turtle shapes editor" in "tools". Something that can help anyone build a model with any shape in the mind. 
The command " Am I the answer" according to the place of the shape made it easy to set the answer as "true" or "false" according to the xcor and ycor (place) in the screen.From the turtles shapes: a happy face or a sad face for the answers. 



## CREDITS AND REFERENCES

http://modelingcommons.org/browse/one_model/3804#model_tabs_browse_discuss
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

shape1
true
0
Line -7500403 true 90 75 150 120
Line -7500403 true 150 120 210 75
Line -7500403 true 210 75 210 165
Line -7500403 true 90 75 90 165
Line -7500403 true 210 165 90 165

shape10
true
0
Line -7500403 true 225 90 225 195
Line -7500403 true 225 90 30 195
Line -7500403 true 225 195 30 195

shape11
true
0
Line -7500403 true 75 135 75 195
Line -7500403 true 75 195 225 195
Line -7500403 true 225 195 225 135
Line -7500403 true 225 135 180 105
Line -7500403 true 75 135 120 105
Line -7500403 true 180 105 120 105

shape12
true
0
Line -7500403 true 75 210 225 210
Line -7500403 true 75 210 75 180
Line -7500403 true 225 210 225 180
Line -7500403 true 75 180 120 135
Line -7500403 true 225 180 180 135
Line -7500403 true 180 135 120 135

shape13
true
0
Line -7500403 true 75 210 225 210
Line -7500403 true 75 210 75 180
Line -7500403 true 225 210 225 150
Line -7500403 true 225 150 195 120
Line -7500403 true 75 180 135 120
Line -7500403 true 135 120 195 120

shape14
true
0
Line -7500403 true 135 60 90 120
Line -7500403 true 135 60 180 120
Line -7500403 true 180 120 135 225
Line -7500403 true 90 120 135 225

shape15
true
0
Line -7500403 true 90 105 150 60
Line -7500403 true 150 60 210 105
Line -7500403 true 90 105 150 195
Line -7500403 true 210 105 150 195

shape16
true
0
Line -7500403 true 150 90 120 120
Line -7500403 true 150 90 195 120
Line -7500403 true 120 120 150 225
Line -7500403 true 195 120 150 225

shape17
true
0
Line -7500403 true 90 120 135 75
Line -7500403 true 135 75 180 120
Line -7500403 true 180 120 225 150
Line -7500403 true 225 150 180 180
Line -7500403 true 180 180 135 225
Line -7500403 true 90 120 45 150
Line -7500403 true 45 150 90 180
Line -7500403 true 90 180 135 225

shape18
true
0
Line -7500403 true 150 75 120 120
Line -7500403 true 150 75 180 120
Line -7500403 true 180 120 240 150
Line -7500403 true 240 150 180 165
Line -7500403 true 120 120 60 150
Line -7500403 true 180 165 150 210
Line -7500403 true 150 210 120 165
Line -7500403 true 120 165 60 150

shape19
true
0
Line -7500403 true 150 90 90 135
Line -7500403 true 150 90 210 135
Line -7500403 true 90 135 45 150
Line -7500403 true 45 150 90 165
Line -7500403 true 210 135 255 150
Line -7500403 true 255 150 210 165
Line -7500403 true 210 165 150 210
Line -7500403 true 90 165 150 210

shape2
true
0
Line -7500403 true 75 90 75 165
Line -7500403 true 75 165 225 165
Line -7500403 true 225 165 225 90
Line -7500403 true 225 90 105 135
Line -7500403 true 105 135 75 90

shape20
true
0
Line -7500403 true 120 75 165 75
Line -7500403 true 120 75 120 120
Line -7500403 true 120 120 75 120
Line -7500403 true 75 120 75 165
Line -7500403 true 165 75 165 120
Line -7500403 true 165 120 210 120
Line -7500403 true 210 120 210 165
Line -7500403 true 210 165 165 165
Line -7500403 true 165 165 165 210
Line -7500403 true 75 165 120 165
Line -7500403 true 120 165 120 210
Line -7500403 true 120 210 165 210

shape21
true
0
Line -7500403 true 135 75 180 75
Line -7500403 true 135 75 135 135
Line -7500403 true 135 135 90 135
Line -7500403 true 90 135 90 180
Line -7500403 true 180 75 180 135
Line -7500403 true 180 135 225 135
Line -7500403 true 90 180 135 180
Line -7500403 true 135 180 135 240
Line -7500403 true 225 135 225 180
Line -7500403 true 225 180 180 180
Line -7500403 true 180 180 180 240
Line -7500403 true 180 240 135 240

shape22
true
0
Line -7500403 true 135 60 165 60
Line -7500403 true 135 60 135 120
Line -7500403 true 165 60 165 120
Line -7500403 true 135 120 75 120
Line -7500403 true 75 120 75 150
Line -7500403 true 165 120 225 120
Line -7500403 true 225 120 225 150
Line -7500403 true 75 150 135 150
Line -7500403 true 135 150 135 210
Line -7500403 true 135 210 165 210
Line -7500403 true 165 210 165 150
Line -7500403 true 165 150 225 150

shape23
true
0
Line -7500403 true 75 135 76 192
Line -7500403 true 75 135 225 135
Line -7500403 true 225 135 225 195
Line -7500403 true 225 195 75 195

shape24
true
0
Line -7500403 true 180 195 75 195
Line -7500403 true 75 195 75 120
Line -7500403 true 75 120 180 120
Line -7500403 true 180 120 180 195

shape25
true
0
Line -7500403 true 45 135 45 180
Line -7500403 true 45 135 255 135
Line -7500403 true 255 135 255 180
Line -7500403 true 255 180 45 180

shape26
true
0
Line -7500403 true 90 90 120 120
Line -7500403 true 120 120 150 90
Line -7500403 true 150 90 180 120
Line -7500403 true 180 120 210 90
Line -7500403 true 90 90 90 180
Line -7500403 true 210 90 210 180
Line -7500403 true 210 180 90 180

shape27
true
0
Line -7500403 true 75 195 75 90
Line -7500403 true 75 195 225 195
Line -7500403 true 225 195 225 90
Line -7500403 true 75 90 120 150
Line -7500403 true 225 90 180 150
Line -7500403 true 180 150 150 90
Line -7500403 true 150 90 120 150

shape28
true
0
Line -7500403 true 90 105 90 195
Line -7500403 true 90 195 225 195
Line -7500403 true 225 195 225 105
Line -7500403 true 225 105 195 150
Line -7500403 true 90 105 120 150
Line -7500403 true 120 150 150 120
Line -7500403 true 195 150 150 120

shape29
true
0
Line -7500403 true 90 105 240 105
Line -7500403 true 90 105 30 180
Line -7500403 true 240 105 180 180
Line -7500403 true 180 180 30 180

shape3
true
0
Polygon -7500403 true true 150 240 15 120 60 285 240 285 285 120

shape30
true
0
Line -7500403 true 210 105 90 105
Line -7500403 true 90 105 45 195
Line -7500403 true 210 105 165 195
Line -7500403 true 165 195 45 195

shape31
true
0
Line -7500403 true 210 120 45 120
Line -7500403 true 45 120 15 165
Line -7500403 true 210 120 180 165
Line -7500403 true 180 165 15 165

shape4
true
0
Line -7500403 true 90 105 90 195
Line -7500403 true 90 195 225 195
Line -7500403 true 225 195 225 105
Line -7500403 true 90 105 150 120
Line -7500403 true 225 105 150 120

shape5
true
0
Line -7500403 true 75 75 75 240
Line -7500403 true 75 240 210 240
Line -7500403 true 210 240 210 165
Line -7500403 true 135 165 135 75
Line -7500403 true 135 75 75 75
Line -7500403 true 135 165 210 165

shape6
true
0
Line -7500403 true 90 75 90 240
Line -7500403 true 90 75 180 75
Line -7500403 true 180 75 180 180
Line -7500403 true 180 180 225 180
Line -7500403 true 225 180 225 240
Line -7500403 true 225 240 90 240

shape7
true
0
Line -7500403 true 210 60 180 60
Line -7500403 true 210 60 210 225
Line -7500403 true 180 60 180 150
Line -7500403 true 180 150 75 150
Line -7500403 true 75 150 75 225
Line -7500403 true 75 225 210 225

shape8
true
0
Line -13840069 false 45 195 150 105
Line -13840069 false 150 105 255 195
Line -13840069 false 45 195 255 195

shape9
true
0
Line -7500403 true 120 120 30 195
Line -7500403 true 30 195 270 195
Line -7500403 true 120 120 270 195

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
