;; swtiches: learn-subset?,learn-local?,learn-nearest?,method-mean?,method-median?,method-one?
;; sliders: learn-subset,learn-radius
breed [adults adult]
breed [children child]

adults-own [f1 f2 tempf1 tempf2 my-lifespan age my-group]
;children-own [f1 f2 my-group]

to setup
  clear-all
  
;  create-children population-size [
;    ; children start with no language
;    set color blue
;    set ycor random-ycor
;    set xcor random-xcor
;    ]
  ; only one can be chosen
  if network-clustered? [setup-cluster-network]
  if network-lattice? [setup-lattice-network]
  reset-ticks
end

to go
  ;; Run one generation (tick)
  ask adults [
    set my-group adults ;; default to all adults
    ;; none of these are intended to work together, though they theoretically could
    if learn-local? [set my-group link-neighbors] ;; all adults neighbors
        ;; if learn-radius is set too small, too many children die isolated to graduate to fill dying adult slots. problem :/
    ;if learn-subset? [set my-group n-of learn-subset my-group] ;; random N of adults
    ;if learn-nearest? [set my-group min-n-of learn-subset adults [distance myself]] ;; nearest N adults

    ifelse any? my-group ;; don't attempt learn if my-group is empty, instead die
    [listen]
    [
      let neighbor-nodes turtle-set other adults in-radius 2
      create-links-with neighbor-nodes
      [
        if random-float 1 > link-chance
        [ die ]
      ]
    ]
  update
  ]
  
;  ask adults [
;    set age age + 1 ;; increment age
;    if age > my-lifespan [die] ;; die if new age exceeds my-lifespan
;  ]
  
;  ask n-of (population-size - count adults) children [
;    ; only enough children graduate to replace deaths
;    set breed adults
;    set color red
;    ; children get lifespan upon graduation
;    set my-lifespan random lifespan + 1
;  ]
;  ask children [die] ; remaining children are cleaned out before 50 new created
;  create-children population-size [
;    set color blue
;    set ycor random-ycor
;    set xcor random-xcor
;  ]
  tick
  plot-vowel-space
end

to listen
  ; agent listens to all speaking agents (adults), computes idiolect
  ; learn-mean is one possible strategy: learn-mode
  ; noisy listening/learning is also possible
  ;; none of these are intended to interact, though it may be possible; this is still better than multiple setup buttons, because of the combinations
  ;; if none are picked, it's just pure noise effect
 
  if method-one? [learn-one]
  if method-mean? [learn-mean]
  if method-median? [learn-median]
  ; add noise as % of total (not current?)
  ;; this means that f2 has more absolute noise, because it's a larger value; problem?
  set tempf1 f1 + random-normal 0 noise-level * start-f1
  set tempf2 f2 + random-normal 0 noise-level * start-f2
  if f1 < 200 [set tempf1 200]
  if f2 < 500 [set tempf2 500]
  if f1 > 1200 [set tempf1 1200]
  if f2 > 3500 [set tempf2 3500]

end

to learn-mean ;;adopts mean of adults
    set tempf1 mean [f1] of my-group
    set tempf2 mean [f2] of my-group
end

to learn-one ;;randomly copies one adult
  set tempf1 one-of [f1] of my-group
  set tempf2 one-of [f2] of my-group
end

to learn-median ;;learns median of  adults
    set tempf1 median [f1] of my-group
    set tempf2 median [f2] of my-group
end

to plot-vowel-space
  ask adults [
    plotxy f2 f1]
end

to setup-cluster-network
  create-adults population-size / 2 [
    ; initialize adult formants near start-f1,-f2 (use random-normal)
    ; use realistic f1 (700), f2 (2000), deviation
    set f1 random-normal start-f1 150
    set f2 random-normal start-f2 500
    set color red
    set ycor random-ycor
    set xcor random-xcor
    set my-lifespan random lifespan
    ]
  let num-links (average-node-degree * population-size) / 2
  while [count links < num-links ]
  [
    ask one-of adults
    [
      let choice (min-one-of (other adults with [not link-neighbor? myself])
                   [distance myself])
      if choice != nobody [ create-link-with choice ]
    ]
  ]
  ; make the network look a little prettier
  repeat 10
  [
    layout-spring adults links 0.3 (world-width / (sqrt population-size)) 1
  ]
end

to update
  set f1 tempf1
  set f2 tempf2
end

to setup-lattice-network
  ; create the grid of nodes
  let grid-size 12
  ask patches with [abs pxcor < (grid-size / 2) and abs pycor < (grid-size / 2)]
    [ sprout 1 [set breed adults] ]
    ask adults [
    ; initialize adult formants near start-f1,-f2 (use random-normal)
    ; use realistic f1 (700), f2 (2000), deviation
    set f1 random-normal start-f1 150
    set f2 random-normal start-f2 500
    set color red
    ;set ycor random-ycor
    ;set xcor random-xcor
    set my-lifespan random lifespan
    ]

  ; create a directed network such that each node has a LINK-CHANCE percent chance of
  ; having a link established from a given node to one of its neighbors
  ask adults [
    let neighbor-nodes turtle-set [turtles-here] of neighbors4
    create-links-with neighbor-nodes
    [
      if random-float 1 > link-chance
      [ die ]
    ]
  ]
  ; spread the nodes out
  ask adults [
    setxy (xcor * (max-pxcor - 1) / (grid-size / 2 - 0.5))
          (ycor * (max-pycor - 1) / (grid-size / 2 - 0.5))
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
720
10
1140
451
20
20
10.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks
30.0

BUTTON
5
10
67
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
70
10
133
43
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
5
160
175
193
learn-subset?
learn-subset?
1
1
-1000

SWITCH
5
230
175
263
learn-local?
learn-local?
0
1
-1000

PLOT
5
500
205
650
Mean F1,F2
Ticks
Mean Formants
0.0
10.0
200.0
3500.0
true
false
"" ""
PENS
"pen-0" 1.0 0 -16777216 true "" "plot mean [f1] of adults"
"pen-1" 1.0 0 -7500403 true "" "plot mean [f2] of adults"

BUTTON
135
10
198
43
go*
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
280
177
313
noise-level
noise-level
0
1
0.05
.01
1
percent
HORIZONTAL

SLIDER
5
330
177
363
lifespan
lifespan
1
10
5
1
1
ticks
HORIZONTAL

PLOT
210
500
410
650
Standard Dev F1,F2
Ticks
SD Formants
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot standard-deviation [f1] of adults"
"pen-1" 1.0 0 -7500403 true "" "plot standard-deviation [f2] of adults"

PLOT
625
500
825
650
Mean Age, Mean Lifespan
Ticks
Life-Ticks
0.0
10.0
0.0
2.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [age] of adults"
"pen-1" 1.0 0 -7500403 true "" "plot mean [my-lifespan] of adults"

PLOT
830
500
1030
650
Population
Ticks
Turtles
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count adults"
"pen-1" 1.0 0 -7500403 true "" "plot count children"

SLIDER
185
230
357
263
learn-radius
learn-radius
3.0
10
3
0.5
1
NIL
HORIZONTAL

SLIDER
185
160
357
193
learn-subset
learn-subset
0
20
3
1
1
adults
HORIZONTAL

SWITCH
5
195
175
228
learn-nearest?
learn-nearest?
1
1
-1000

SLIDER
5
45
177
78
start-f1
start-f1
200
1200
700
5
1
Hz
HORIZONTAL

SLIDER
185
45
357
78
start-f2
start-f2
500
3500
2000
5
1
Hz
HORIZONTAL

SWITCH
5
380
180
413
method-mean?
method-mean?
0
1
-1000

SWITCH
5
415
180
448
method-median?
method-median?
1
1
-1000

SWITCH
5
450
180
483
method-one?
method-one?
1
1
-1000

PLOT
415
345
615
495
Histogram F1
Frequency F1
NIL
200.0
1200.0
0.0
1.0
true
false
"" ""
PENS
"default" 100.0 1 -16777216 true "" "histogram [f1] of adults"

PLOT
210
345
410
495
Vowel Space
F2
F1
500.0
3500.0
200.0
1200.0
false
false
"" "clear-plot\nplot-vowel-space"
PENS
"default" 1.0 2 -16777216 true "" ""
"pen-1" 1.0 2 -2674135 true "" "plotxy mean [f2] of adults mean [f1] of adults"

SLIDER
365
45
557
78
population-size
population-size
0
500
150
10
1
adults
HORIZONTAL

PLOT
415
500
615
650
Histogram F2
Frequency F2
NIL
500.0
3500.0
0.0
100.0
false
false
"" ""
PENS
"default" 300.0 1 -16777216 true "" "histogram [f2] of adults"

SLIDER
365
85
552
118
average-node-degree
average-node-degree
0
25
2
1
1
NIL
HORIZONTAL

SLIDER
185
85
357
118
link-chance
link-chance
0
1
0.75
.01
1
NIL
HORIZONTAL

SWITCH
365
10
542
43
network-clustered?
network-clustered?
1
1
-1000

SWITCH
205
10
357
43
network-lattice?
network-lattice?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This model demonstrates that language shifts can arise from a very simple model of noisy statistical learning. In this model, a group of adults speak a language, each learning from the other adults. Over time, language shifts occur in the overall language of the population. In this model, adults are placed on a network and communicate only with their network neighbors.

## HOW IT WORKS

Agents are adults.

At each tick, adults listen to other adults, learning a new version of the language (represented as a vowel sound in the form of an F1,F2 value-pair). Each adult replaces their old language with the new one after everyone is done listening.

Adults update their language according to the chosen learning method (switches 'method-mean?', etc.), which correspond to simple statistical learning options; they learn from a set of adults constrained by the chosen locality setting (switches 'learn-subset?', etc.).

## HOW TO USE IT

The sliders for 'start-f1', 'start-f2', 'population-size', 'noise-level', and 'lifespan'  set the initial values of these factors for the 'setup' button. The 'network-clustered?' and 'network-lattice?' switches are used to choose the network structure prior to setup. The 'average-node-degree' slider controls the link density of the clustered network. The 'link-chance' slider controls the link density for the lattice network.

The switches for 'learn-subset?', 'learn-local?', 'learn-nearest?' constrain the adults each child can listen to. Only 'learn-local?' should be used for this network model.

The switches for 'method-mean?', 'method-median?', 'method-one?' choose the statistical learning method of the children; only one should be 'on' per model run.

The view shows the network structure of the adults, which is not itself informative; instead, there is an array of statistical plots provided to monitor the state of the language and how it is changing over time.


## THINGS TO NOTICE

Notice the trajectory of the mean F1 and F2, as well as the changing position of the values cluster on the vowel space plot.

## THINGS TO TRY

Try varying the noise level within the low regime (0.01, 0.1) and at more extreme values (> 0.3); notice the effect on the mean trajectories and the vowel space plot.

Try varying the average node degree of the clustered network, and compare the effect of this to the effect of varying the link chance of the lattice network.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="cluster-mean" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="cluster-median" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="cluster-one" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="lattice-one" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="lattice-median" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="lattice-mean" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>mean [f1] of turtles</metric>
    <metric>mean [f2] of turtles</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lifespan">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="noise-level">
      <value value="0.01"/>
      <value value="0.05"/>
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-local?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-clustered?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="link-chance">
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-mean?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f2">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population-size">
      <value value="150"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-subset?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network-lattice?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="start-f1">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-radius">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="method-median?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="learn-nearest?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
