turtles-own [ 
  viewed?
  quality-standard
  engagement-standard
  funny-standard
  emotional-standard
  facebook-standard
  twitter-standard
  standard-set
  tweet-out
  facebook-out
  friend-out
  tweet-care
  facebook-care
  friend-care
  publicity
  recommendations
  near-neighbor
  ]

to setup
  clear-all
  ask links [ set color white ]
  generate-viewers
  reset-ticks
  linkage
end

to generate-viewers
  crt 1000 [ 
    repeat 10 [let empty-patches neighbors with [not any? turtles-here]
    if any? empty-patches
    [let target one-of patches
      face target
      move-to target]
       ]
     set viewed? false
     set color gray
     set shape "person" 
     set quality-standard random 11
     set engagement-standard random 11
     set funny-standard random 11
     set emotional-standard random 11
     set facebook-standard random 51
     set twitter-standard random 51
     set standard-set 0
     set publicity random 101
     set tweet-out random 101
     set facebook-out random 101
     set friend-out random 101
     set tweet-care random 101
     set facebook-care random 101
     set friend-care random 101
     if quality > quality-standard  [ 
       set standard-set standard-set + 1]
     if engagement > engagement-standard [
       set standard-set standard-set + 1]
     if funny > funny-standard [
       set standard-set standard-set + 1]
     if emotional > emotional-standard [
       set standard-set standard-set + 1]
    ]
end



;;;;;;;;;;;;;;;;;
;;;GO COOMMAND;;;
;;;;;;;;;;;;;;;;;

to initial-viewers
  ask turtles [ 
    if standard-set = 4 [
      set color yellow
      set viewed? true ]
  ]
  ask turtles [
   if count turtles with [color = yellow] = 0 [ 
  repeat random 6 [
  ask one-of turtles [
    set color yellow
    set viewed? true ] ]
  ]
  ]
  tick
end

to go
  friend-share
  tweet-share
  facebook-share
  tick
end

to linkage
  let num-links (200)
  while [count links < num-links ]
  [ask one-of turtles
    [
      let choice (min-one-of (other turtles with [not link-neighbor? myself])
                   [distance myself])
      if choice != nobody [ create-link-with choice ]
    ]
    ]
   repeat 5
  [
    layout-spring turtles links 0.3 1 0.05
  ]
end

;;;
;;;SHARING & CARING PARAMETERS
;;;

to friend-share
  ask turtles [
    if friend-out < Friend-Sharing and color = yellow [
        ask link-neighbors [
          if friend-care < Friend-Check [
          set color lime ]
          ]
    ]
  ]
    ask turtles [
    if friend-out < Friend-Sharing and color = red [
        ask link-neighbors [
          if friend-care < Friend-Check [
          set color lime ]
          ]
    ]
  ]  ask turtles [
    if friend-out < Friend-Sharing and color = blue [
        ask link-neighbors [
          if friend-care < Friend-Check [
          set color lime ]
          ]
    ]
  ]
    ask turtles [
    if friend-out < Friend-Sharing and color = lime [
        ask link-neighbors [
          if friend-care < Friend-Check [
          set color lime ]
          ]
    ]
  ]
    ask turtles [
    if friend-out < Friend-Sharing and color = orange [
        ask link-neighbors [
          if friend-care < Friend-Check [
          set color lime ]
          ]
    ]
  ]
    tick
end

to tweet-share
  ask turtles [
      if tweet-out < Twitter-Sharing and color = yellow [
        ask (turtles-on neighbors4) [
        if tweet-care < Twitter-Check [
        set color red ]
      ]
      ]
  ]  
  
ask turtles [
      if tweet-out > Twitter-Sharing and color = red [
        ask (turtles-on neighbors4) [
        if tweet-care > Twitter-Check [
        set color red ]
      ]
      ]
  ]  
ask turtles [
      if tweet-out > Twitter-Sharing and color = blue [
        ask (turtles-on neighbors4) [
        if tweet-care > Twitter-Check [
        set color red ]
      ]
      ]
  ]  
ask turtles [
      if tweet-out > Twitter-Sharing and color = lime [
        ask (turtles-on neighbors4) [
        if tweet-care > Twitter-Check [
        set color red ]
      ]
      ]
  ]  
ask turtles [
      if tweet-out > Twitter-Sharing and color = orange [
        ask (turtles-on neighbors4) [
        if tweet-care > Twitter-Check [
        set color red ]
      ]
      ]
  ]  
tick
end

to facebook-share
  ask turtles [
      if facebook-out < Facebook-Sharing and color = yellow [
        ask (turtles-on neighbors4) [
        if facebook-care < Facebook-Check [
        set color blue ]
      ]
      ]
  ]  
  
ask turtles [
      if facebook-out < Facebook-Sharing and color = blue [
        ask (turtles-on neighbors4) [
        if facebook-care < Facebook-Check [
        set color blue ]
      ]
      ]
  ]  
ask turtles [
      if facebook-out < Facebook-Sharing and color = red [
        ask (turtles-on neighbors4) [
        if facebook-care < Facebook-Check [
        set color blue ]
      ]
      ]
  ]
ask turtles [
      if facebook-out < Facebook-Sharing and color = lime [
        ask (turtles-on neighbors4) [
        if facebook-care < Facebook-Check [
        set color blue ]
      ]
      ]
  ]
ask turtles [
      if facebook-out < Facebook-Sharing and color = orange [
        ask (turtles-on neighbors4) [
        if facebook-care < Facebook-Check [
        set color blue ]
      ]
      ]
  ]
tick
end

to increased-views
  repeat (count turtles with [publicity > 70]) [make-node find-partner]
    tick
end

 to wander
  rt random 360
  fd 1
 end
 
 ;;;;
 ;;;; FROM PREFERENTIAL ATTACHMENT
 ;;;; This is borrowed from the Preferential Attachment Model, which 
 ;;;; borrowed from the lottery model. It adds links for the new
 ;;;; oranage people, which are generated by publicity.
 ;;;;

to make-node [old-node]
  crt 1
  [
    set shape "person"
    set color orange
    if old-node != nobody
      [ create-link-with old-node [ set color pink ]
        ;; position the new node near its partner
        move-to old-node
        wander
      ]
     set quality-standard random 11
     set engagement-standard random 11
     set funny-standard random 11
     set emotional-standard random 11
     set facebook-standard random 51
     set twitter-standard random 51
     set standard-set 0
     set publicity random 101
     set tweet-out random 101
     set facebook-out random 101
     set friend-out random 101
     set tweet-care random 101
     set facebook-care random 101
     set friend-care random 101
     if quality > quality-standard  [ 
       set standard-set standard-set + 1]
     if engagement > engagement-standard [
       set standard-set standard-set + 1]
     if funny > funny-standard [
       set standard-set standard-set + 1]
     if emotional > emotional-standard [
       set standard-set standard-set + 1]
  ]
end

to-report find-partner
  let total random-float sum [count link-neighbors] of turtles
  let partner nobody
  ask turtles
  [
    let nc count link-neighbors
    ;; if there's no winner yet...
    if partner = nobody
    [
      ifelse nc > total
        [ set partner self ]
        [ set total total - nc ]
    ]
  ]
  report partner
end


@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
141
13
205
46
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
99
56
204
89
initial viewers
initial-viewers
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
30
213
202
246
quality
quality
0
10
6
1
1
NIL
HORIZONTAL

SLIDER
30
258
202
291
engagement
engagement
0
10
4
1
1
NIL
HORIZONTAL

SLIDER
30
302
202
335
emotional
emotional
0
10
4
1
1
NIL
HORIZONTAL

SLIDER
31
347
203
380
funny
funny
0
10
4
1
1
NIL
HORIZONTAL

BUTTON
661
10
762
43
close friends
friend-share
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
693
57
763
90
tweets
tweet-share
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
682
100
764
133
facebook
facebook-share
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
131
99
204
144
view count
count turtles with [color != gray]
17
1
11

BUTTON
686
145
763
178
publicity
increased-views
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
1052
143
1224
176
Twitter-Check
Twitter-Check
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
1052
188
1224
221
Facebook-Check
Facebook-Check
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
1052
98
1224
131
Friend-Check
Friend-Check
0
100
50
1
1
NIL
HORIZONTAL

BUTTON
686
188
766
221
Share All
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
1065
41
1215
83
These parameters adjust how receptive people are to different connections.
11
0.0
1

TEXTBOX
46
187
196
205
Video parameters
11
0.0
1

SLIDER
834
98
1006
131
Friend-Sharing
Friend-Sharing
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
834
144
1006
177
Twitter-Sharing
Twitter-Sharing
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
834
187
1006
220
Facebook-Sharing
Facebook-Sharing
0
100
100
1
1
NIL
HORIZONTAL

TEXTBOX
840
31
990
87
These parameters adjust how often people share with their friends via linked connections, twitter, and facebook
11
0.0
1

PLOT
722
269
922
419
Views
Time
Views
0.0
10.0
0.0
10.0
true
false
"set-plot-y-range min-pycor max-pycor" ""
PENS
"watched" 1.0 0 -16777216 true "" "plot count turtles with [color != gray]"

PLOT
976
268
1234
418
View Source
View Type
People Watching
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"initial" 1.0 0 -1184463 true "" "plot count turtles with [color = yellow]"
"friends" 1.0 0 -13840069 true "" "plot count turtles with [color = lime]"
"twitter" 1.0 0 -2674135 true "" "plot count turtles with [color = red]"
"publicity" 1.0 0 -955883 true "" "plot count turtles with [color = orange]"
"facebook" 1.0 0 -13345367 true "" "plot count turtles with [color = blue]"

@#$#@#$#@
## WHAT IS IT?

If you're familiar with YouTube and Vimeo, then you are probably familiar with what it means for a video to go "viral." This model simulates the ways in which a video can be disseminated for viewing, making it possible to explore and understand the phenomena of viral videos, as well as general video viewing. 

## HOW IT WORKS

The model uses _viewers_ to represent individuals engaged in watching a video. Viewership increases (aka becomes viral) or decreases based on three types of variables: video parameters, sharing parameters, and receptiveness to connections from an individual's social network. Individuals start out as potential viewers who have yet to watch a video (gray people). They can then become initial viewers (yellow people), viewers watching as a result of their close friends telling them (green people), viewers watching as a result of Facebook (blue people), viewers watching as a result of a tweet (red people), and viewers watching as a result of publicity (orange people). 

## HOW TO USE IT

To use the model, press SETUP. This will create a potential group of 1000 people who may or may not watch a video based on the video parameters you select, located on the left of the Interface screen. You can increase the number of viewers by moving one or more of the sliders under VIDEO PARAMETERS to the right. To decrease the number of viewers, move the sliders to the left. Press INITIAL VIEWERS to set the model in motion. If, after you've pressed INITIAL VIEWERS, there appears to be very few viewers (you can determine the exact number of viewers by looking at the VIEW COUNT monitor), you can adjust the VIDEO PARAMETERS to see how different measures affect the decision to view a video.

Now comes the interesting part, namely adjusting the sliders located to the right of the Interface screen in order to produce the conditions you want to explore or study. In order to increase viewership even further, click on any of the buttons to the right of the model: CLOSE FRIENDS, TWEETS, FACEBOOK, PUBLICITY or SHARE ALL (the last button is a shortcut and clicking on it activates CLOSE FRIENDS, TWEETS, and FACEBOOK). 

The number of additional viewers that appear are directly related to the value of the sliders positioned to the far right: FRIEND-SHARING, TWITTER-SHARING, FACEBOOK-SHARING, FRIEND-CHECK, TWITTER-CHECK, and FACEBOOK-CHECK. The first three sliders control the probability of viewers sharing a video while the last three sliders control how receptive viewers are to different connections. If the sliders are close to zero, fewer viewers will appear in the model, setting in motion an overall decrease in the number of new viewers when the simulation is running.

Finally, there are two line graphs located on the bottom right of the Interface screen. The line graph entitled VIEWS tracks the overall number of views that a video has received. The line graph entitled VIEW SOURCE tracks viewers by their point of entry, whether or not they are watching as a result of Facebook, Twitter, Publicity, Close Friends, or were part of the initial set of viewers. 


## THINGS TO NOTICE

Viral videos are often distributed through an individual viewer's social media networks--which typically means more social connections will lead to a higher probability of additional views of a video. The more extensive your friend group, the higher the views a video will receive. You can simulate this by moving the sliders located on the right side of the model all the way to the right. Watch the number of viewers as a direct result of tweets and Facebook posts dramatically increase!

## THINGS TO TRY

Can you adjust the settings so that you have very few viewers? How about trying to get as many viewers as possible? How about trying to get as many viewers as possible from one source only, such as Facebook? Mix things up by experimenting with the sliders to understand what combination of parameters result in more viewers or less viewers. Make sure to look at the graphs to see how the different slider values you have selected are impacting viewing patterns.

## EXTENDING THE MODEL

In real life, videos can go viral for many reasons. Try and change the model by including additional video parameters such as duration and the presence or lack of music. You might also try and tweak the parameters and unpack what it means to be quality, engaging, funny, and emotional. 

The model is simple in that it accounts for only three sources of viewers: Facebook, Twitter, and publicity. Extend the model by incorporating more sources such as marketing or emailing outside of social media. YOu migh also want to incorporate an element of randomness as to what kind of publicity yields different amounts of new viewers.

Finally, try thinking of new ways to count viewers and plot data generated by the model. Experiment with adding new monitors or changing the sliders to switches--how does this change the model?   

## RELATED MODELS

The AIDS and Preferential Attachment models demonstrate similar patterns of diffusion across individuals.

## CREDITS AND REFERENCES

Thanks to Michelle Carr and Krystal Villanosa for their work on this model. Thanks to Dave Weintrop, Aditi Wagh, and Uri Wilensky for their assistance with this model.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
