breed [suns sun]
breed [clouds cloud]
breed [raindrops raindrop]
breed [winds wind]
breed [amoebaeR amoebaR]
breed [amoebaeKW amoebaKW]
breed [amoebaeKD amoebaKD]

raindrops-own [
  location          
  amount-of-water]
winds-own [          
  evaporation]
clouds-own [
  moisture]
patches-own [
  SurfMoist ;surface moisture (diffuses faster)
  SMoist ;Sphagnum Moisture
  WTD]
amoebaeR-own [
  locationA
  Ideal
  cyst-energy
  energy
  birth-energy
  decay
  ]
amoebaeKD-own [
  locationA
  Ideal
  cyst-energy
  energy
  birth-energy
  decay
  ]
amoebaeKW-own [
  locationA
  Ideal
  cyst-energy
  energy
  birth-energy
  decay
  ]

globals [
  surface
  sphagnum  
  peat       
  WTDstart
]
;****SETUP**********************************************  
to setup
  clear-all
  do-plots
  set surface min-pycor + 11
  set sphagnum min-pycor + 10
  set peat min-pycor + 5
  set-default-shape raindrops "drop"
  set-default-shape clouds "cloud"
  set-default-shape winds "line2"
  set-default-shape amoebaeR "amoebaer"
  set-default-shape amoebaeKD "amoebaekd"
  set-default-shape amoebaeKW "amoebaekw"
     
 ;; On the first day....
create-suns 1 [
    setxy max-pxcor - 2
          max-pycor - 3
     set color yellow 
     set shape "circle" 
     set size 4]

 ;; And on the second day...Create sky and grass 
ask patches [if pycor > 11 [  
    set pcolor 98]] ;sky
ask patches [if pycor < 11 and pycor > 1 [  
    set pcolor 54]] ;sphagnum
ask patches [if pycor = 11  [ 
    set pcolor green]] ;surface
ask patches [if pycor < 5 [
    set pcolor 33]] ;peat
end    

;*****GO>>>>GO>>>>>GO!!!!!*********************************************
to go
  make-wind-blow
  make-rain-fall
  make-clouds
  make-groundwater
  display-labels
  update-world
  breed-amoebaeR
  make-live-amoebaeR
  hatch-ameobaeR
  breed-amoebaeKD
  make-live-amoebaeKD
  hatch-ameobaeKD
  breed-amoebaeKW
  make-live-amoebaeKW
  hatch-ameobaeKW
  tick
  do-plots
end

;********And on the third day....*****************************************************
;;make clouds that make rain
 to make-clouds
   if random-float 730 < (2.5 * Climate) and Climate-Variability = 1
    ;; add climate and variability to cloudyness ; make clouds when cloudy
   and Cloudy [create-clouds (random-float 10) [
     setxy (random-float 40) (random-float 9 + 11)  
     set heading 90
     set size 4
     set color white
     set moisture random-float 3
     ask clouds [fd random 0.8 + 0.05]
     ;;ask clouds [set label moisture]
     ask clouds [if count clouds > 10 [die]]
   ]]
  if random-float 730 < (Climate) and Climate-Variability > 1
    ;; add climate and variability to cloudyness ; make clouds when cloudy
   and Cloudy and (Climate-Variability) < ((count clouds / 4) + random-normal 2 1) [create-clouds (random-float 10) [
     setxy (random-float 40) (random-float 9 + 11)  
     set heading 90
     set size 4
     set color white
     set moisture random-float 3
     ask clouds [fd random 0.8 + 0.05]
     ;;ask clouds [set label moisture]
     ask clouds [if count clouds > 10 [die]]
   ]]
  ask clouds with [pycor > 10 ] [ 
    fd 2 ]
  ask clouds at-points [[40 11] [40 12] [40 13] [40 14] [40 15] [40 16] [40 17] [40 18] [40 19] [40 20]]
    [die]
 if not Cloudy [ask clouds [fd 2]
    ask clouds at-points [[40 11] [40 12] [40 13] [40 14] [40 15] [40 16] [40 17] [40 18] [40 19] [40 20]]
    [die]]
   end
 
 ;; Create new rain
to make-rain-fall
if random-float 730 < (8 * Climate) and random-float 3 <= Climate-Variability [create-raindrops random-normal 100 50 [
    setxy random-xcor max-pycor
    set heading 180
    set color blue
    set location "falling"
    set amount-of-water ((count clouds) * (Climate-Variability ^ 2)) ;make raindrops same size per event!! ; make climate variable! by raindrop size
    set size (0.1 * amount-of-water)
  ]]
ask raindrops with [location = "falling"] [ 
    fd 1 ]
ask raindrops [if count clouds = 0 [ die]]
end 
 
;;Create WTD ; starts with no groundwater -> takes few days to equilibrate. 
to make-groundwater
  ask raindrops with [location = "falling"][ 
  if pycor = 10 [ 
  set pcolor 84
  set SurfMoist amount-of-water
    die]]
  
;ask patches [if pcolor = 84 [
 ;    set SMoist random-float 10
  ;   ]]
ask patches [if pycor = (13 + (count clouds / 3)) [ ;max 10 clouds, slows down evaporation
    set SurfMoist 0]]
ask patches [if pycor = 11 [
    set Smoist SurfMoist]]  ;convert surface water to ground water doing down, no converstion going up. 

;;make groundwater leave
ask patches [if pycor = 12 [
    set SMoist 0]]
ask patches [if pycor = 1 [
    set SMoist (6 + Basin-hydrology)]] ;;if mega drought, set to -5 to simulate lower regional groundwater table

diffuse SurfMoist .2 ; make surface water diffuse quicker than groundwater 
diffuse SMoist Conductivity  ;;make groundwater behave 
end

to update-world ;make things look correct
ask patches [if pycor < 11 and pycor > 4 and SMoist > 5 [  
    set pcolor 93]]
ask patches [if pycor < 11 and pycor > 4 and SMoist < 4 [ 
    set pcolor 54]]
ask patches [if pycor = 11 and SMoist < 4 [ 
    set pcolor green]]
ask patches [if pycor > 9 and SMoist > 5 [
    set pcolor 85]]
ask patches [if pycor <= 4 [
    set pcolor 33]]
ask patches [if pycor > 11 and SMoist < 4 [ 
    set pcolor 98]]  
end
 
to display-labels  ;;display groundwater values;; values >5 are saturated?
 ask patches [set plabel ""]
if Labels [ask patches [ 
  set plabel round SMoist]]
end

 ;;WIND and Evaporation
to make-wind-blow
 if random-float 100 < Windy-days and Windy [ create-winds random-float 10 [
      setxy 0 14 - random-float 4
      set heading 90 
      set size 1
      set color cyan]]
 
      ask winds [fd 1]
      ask winds at-points [[40 10] [40 11] [40 12] [40 13] [40 14]]
        [die]
;;have wind remove SurfMoist and Smoist at surface
ask winds [if SurfMoist > 0 [
    set SurfMoist (SurfMoist - 0.5)]]
ask winds [if SMoist > 0 [
    set SMoist (SMoist - 0.5)]]
if not Windy [ 
      ask winds [die]]
    end  

;**********MAKE AmoebaeR!***************************************************************

to breed-amoebaeR ;ameobae input from atmosphere, then rain, not recycled
if random-float 730 < Amoebae-Input [create-amoebaeR 1 [
     set size random-normal 0.75 0.5 
     setxy (random-float 40) (20 - random-float 5)
    ; set color scale-color red Ideal -6 6 ;; "???-------------------------------
     set heading 90 
     set locationA "atmosphere"
     set energy (size + 0.5 )
     set Ideal (random-float 4 + 3) ;make variable 
     set cyst-energy 0.0005 ;make variable? or initial energy?----------------------------------
     set birth-energy ((size + 1) * 1.15) ]]
  ask amoebaeR with [locationA = "atmosphere"] 
     [ set heading (heading + random-normal 0 75 )
       fd random-normal 0.75 0.2]
  ask amoebaeR with [locationA = "atmosphere"] 
     [if count raindrops < 50 [
     set heading 90]]
  ask amoebaeR with [locationA = "atmosphere"] [if count raindrops >= 50 [
    set heading 180
    fd (random-float 5)]]
  ask amoebaeR at-points [[40 11] [40 12] [40 13] [40 14] [40 15] [40 16] [40 17] [40 18] [40 19] [40 20]]
        [die]  
  ask amoebaeR with [pycor < 12 and pycor > 4][
    set locationA "sphagnum" ]
        ;set variables such as cyst time with countdown till die
        ;set shape based on r vs. k variables ?
end

to make-live-amoebaeR
  ask-concurrent amoebaeR with [locationA = "sphagnum"] [if SMoist <= Ideal + 2 and SMoist >= Ideal - 5 [
    set heading random-float 360
    fd 0.1
    set energy (energy + (size / 25) - ((12 - pycor) / 100))]]  ;add energy in ideal conditions realitive to size, less energy deeper
  ;make amoebae move toward ideal - NO!
  ;Cysting takes initial energy plus time
  ask-concurrent amoebaeR with [locationA = "sphagnum"] [if SMoist > Ideal + 5 or SMoist < Ideal - 2  [ ;or not AND!
    fd 0
    set energy (energy - cyst-energy - ((12 - pycor) / 100))]] 
  ;kill amoebae
  ask-concurrent amoebaeR with [pycor < 12 and pycor > 4][if energy <= 0 [ 
      set heading 180
      fd 2]] ;dead amoebae move to peat
  
;Accumulate dead amoebae in peat   
ask amoebaeR [if pycor <= 4 and locationA = "sphagnum" [
  set locationA "peat"
  set energy 0
  set decay 365 ]]
ask amoebaeR with [locationA = "peat"] [
  set heading 180
  fd 0.003
  set decay (decay - (1 / (decay-rate + 0.1)))]
ask amoebaeR with [locationA = "peat"] [
  if decay <= 0 [die]]

ask amoebaeR [if pycor > 11 [
   set locationA "atmosphere"]]
;limit # of ameobae per patch (intraspecific competition)
ask amoebaeR [if (count amoebaeR-here > 2) [ 
    set energy (energy - 0.2) ]]
;interspecific competition dominates R species
ask amoebaeR [if (count amoebaeKD-here > 0) [ 
    set energy (energy - 0.4) ]]
ask amoebaeR [if (count amoebaeKW-here > 0) [ 
    set energy (energy - 0.4) ]]
end

to hatch-ameobaeR
  ;; give birth to a new amoebaeR that inherits SAME variables of parent, but takes lots energy
  ask-concurrent amoebaeR with [locationA = "sphagnum"] [if energy > birth-energy
    [ set energy ((energy - 0.5) / 2)
     hatch 1 [ 
     set energy (size)
     fd 1
     set cyst-energy 0.0005 ;make variable
     set birth-energy ((size + 1) * 1.15) ]]]
end

;*********;MAKE AmoebaeKD!********************************************************

to breed-amoebaeKD ;ameobae input from atmosphere, then rain, not recycled
if random-float 730 < Amoebae-Input [create-amoebaeKD 1 [
     set size random-normal 0.75 0.5 
     setxy (random-float 40) (20 - random-float 5)
     set heading 90 
     set locationA "atmosphere"
     set energy (size + 1)
     set Ideal (random-float 1 + 2) ;make variable 
     set cyst-energy 0.05 ;make variable
     set birth-energy ((size + 1) * 4) ]]
  ask amoebaeKD with [locationA = "atmosphere"] 
     [ set heading (heading + random-normal 0 75 )
       fd random-normal 0.75 0.2]
  ask amoebaeKD with [locationA = "atmosphere"] 
     [if count raindrops < 50 [
     set heading 90]]
  ask amoebaeKD with [locationA = "atmosphere"] [if count raindrops >= 50 [
    set heading 180
    fd (random-float 5)]]
  ask amoebaeKD at-points [[40 11] [40 12] [40 13] [40 14] [40 15] [40 16] [40 17] [40 18] [40 19] [40 20]]
        [die]  
  ask amoebaeKD with [pycor < 12 and pycor > 4][
    set locationA "sphagnum" ]
        ;set variables such as cyst time with countdown till die
        ;set shape based on r vs. k variables ?
end

to make-live-amoebaeKD
  ask-concurrent amoebaeKD with [locationA = "sphagnum"] [if SMoist <= (Ideal + 1.5) and SMoist >= (Ideal - 1.5) [
    set heading random-float 360
    fd 0.1
    set energy (energy + (size / 10) - ((12 - pycor) / 100))]] 
  ;make amoebae move toward ideal - NO!
  ask-concurrent amoebaeKD with [locationA = "sphagnum"] [if SMoist > Ideal + 1.5 or SMoist < Ideal + -1.5  [ ;or not AND!
    fd 0
   ;Cysting takes energy
    set energy (energy - cyst-energy  - ((12 - pycor) / 100))]] 
  ;kill amoebae
  ask-concurrent amoebaeKD with [pycor < 12 and pycor > 4][if energy <= 0 [ 
      set heading 180
      fd 2]] ;dead amoebae move to peat
  
;Accumulate dead amoebae in peat   
ask amoebaeKD [if pycor <= 4 and locationA = "sphagnum" [
  set locationA "peat"
  set energy 0
  set decay 365 ]]
ask amoebaeKD with [locationA = "peat"] [
  set heading 180
  fd 0.003
  set decay (decay - (1 / (decay-rate + 0.1)))]
ask amoebaeKD with [locationA = "peat"] [
  if decay <= 0 [die]]

;amoebae hatched in air float away
ask-concurrent amoebaeKD [if pycor > 11 [
   set locationA "atmosphere"]]
;limit # of ameobae per patch (intraspecific competition)
ask-concurrent amoebaeKD [if (count amoebaeKD-here > 1) [ 
   set energy (energy - 0.5) ]]
;intraspecific competition dominates R species
ask-concurrent amoebaeKD [if (count amoebaeR-here > 1) [ 
   set energy (energy - 0.3) ]]
ask-concurrent amoebaeR [if (count amoebaeKW-here > 1) [ 
    set energy (energy - 0.5) ]]
end

to hatch-ameobaeKD
  ;; give birth to a new amoebaeR that inherits SAME variables of parent, but takes lots energy
  ask-concurrent amoebaeKD with [locationA = "sphagnum"] [if energy > birth-energy
    [ set energy ((energy - 0.5) / 2)
     hatch 1 [ 
     set energy (size + 1)
     fd 1
     set cyst-energy 0.005 ;make variable
     set birth-energy ((size + 1) * 4) ]]]
end

;;
;*********;MAKE AmoebaeKW!***********************************************

to breed-amoebaeKW ;ameobae input from atmosphere, then rain, not recycled
if random-float 730 < Amoebae-Input [create-amoebaeKW 1 [
     set size random-normal 0.75 0.5 
     setxy (random-float 40) (20 - random-float 5)
     set heading 90 
     set locationA "atmosphere"
     set energy (size + 1)
     set Ideal (random-float 2 + 4) ;make variable 
     set cyst-energy 0.05 ;make variable
     set birth-energy ((size + 1) * 4) ]]
  ask amoebaeKW with [locationA = "atmosphere"] 
     [ set heading (heading + random-normal 0 75 )
       fd random-normal 0.75 0.2]
  ask amoebaeKW with [locationA = "atmosphere"] 
     [if count raindrops < 50 [
     set heading 90]]
  ask amoebaeKW with [locationA = "atmosphere"] [if count raindrops >= 50 [
    set heading 180
    fd (random-float 5)]]
  ask amoebaeKW at-points [[40 11] [40 12] [40 13] [40 14] [40 15] [40 16] [40 17] [40 18] [40 19] [40 20]]
        [die]  
  ask amoebaeKW with [pycor < 12 and pycor > 4][
    set locationA "sphagnum" ]
        ;set variables such as cyst time with countdown till die
        ;set shape based on r vs. k variables ?
end

to make-live-amoebaeKW
  ask-concurrent amoebaeKW with [locationA = "sphagnum"] [if SMoist > (Ideal) [
    set heading random-float 360
    fd 0.1
    set energy (energy + (size / 10) - ((12 - pycor) / 100)) ]]
  ;make amoebae move toward ideal - NO!
  ;Cysting takes energy
  ask-concurrent amoebaeKW with [locationA = "sphagnum"] [if  SMoist < (Ideal)  [ ;or not AND!
    fd 0
    set energy (energy - cyst-energy - ((12 - pycor) / 100))]] 
  ;kill amoebae
  ask-concurrent amoebaeKW with [pycor < 12 and pycor > 4][if energy <= 0 [ 
      set heading 180
      fd 2]] ;dead amoebae move to peat
  
;Accumulate dead amoebae in peat for 3 year  
ask amoebaeKW [if pycor <= 4 and locationA = "sphagnum" [
  set locationA "peat"
  set energy 0
  set decay 365]]
ask amoebaeKW with [locationA = "peat"] [
  set heading 180
  fd 0.003
  set decay (decay - (1 / (decay-rate + 0.1)))]
ask amoebaeKW with [locationA = "peat"] [
  if decay <= 0 [die]]

ask-concurrent amoebaeKW [if pycor > 11 [
   set locationA "atmosphere"]]
;limit # of ameobae per patch (intraspecific competition)
ask-concurrent amoebaeKW [if (count amoebaeKW-here > 1) [ 
   set energy (energy - 0.5) ]]
;intraspecific competition dominates R species
ask-concurrent amoebaeKW [if (count amoebaeR-here > 1) [ 
   set energy (energy - 0.3) ]]
ask-concurrent amoebaeKW [if (count amoebaeKD-here > 1) [ 
   set energy (energy - 0.5) ]]
end

to hatch-ameobaeKW
  ;; give birth to a new amoebaeKW that inherits SAME variables of parent, but takes lots energy
  ask-concurrent amoebaeKW with [locationA = "sphagnum"] [if energy > birth-energy
    [ set energy ((energy - 0.5) / 2)
     hatch 1 [ 
     set energy (size + 1)
     fd 1
     set cyst-energy 0.005 ;make variable
     set birth-energy ((size + 1) * 4) ]]]
end

 
 ;*************DISPLAY DATA************************************** 

to do-plots
  set-current-plot "Plot"
  set-current-plot-pen "AmoebaeR"
  plot count amoebaeR
  set-current-plot-pen "AmoebaeKD"
  plot count amoebaeKD
  set-current-plot-pen "AmoebaeKW"
  plot count amoebaeKW
  ask patches [if (pycor = 7) and (pxcor = 10)[
  set-current-plot-pen "WTD"
  plot  (SMoist *  50) ]]
  
end
 
 ;histogram
;Differences btw R, KW, and KD variables table needed!
@#$#@#$#@
GRAPHICS-WINDOW
220
10
1182
529
-1
-1
23.24
1
10
1
1
1
0
1
0
1
0
40
0
20
0
0
1
Daylight Hours

BUTTON
2
10
57
43
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
57
10
112
43
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
3
119
192
152
Conductivity
Conductivity
0
1
0.1
0.1
1
NIL
HORIZONTAL

SWITCH
102
52
192
85
Windy
Windy
1
1
-1000

SWITCH
3
52
101
85
Cloudy
Cloudy
0
1
-1000

SWITCH
113
10
203
43
Labels
Labels
1
1
-1000

SLIDER
2
187
192
220
Basin-hydrology
Basin-hydrology
-5
5
0
1
1
NIL
HORIZONTAL

SLIDER
3
86
193
119
Climate
Climate
0
30
14
1
1
rainy days/month
HORIZONTAL

SLIDER
2
155
193
188
Climate-Variability
Climate-Variability
1
3
1
0.1
1
NIL
HORIZONTAL

SLIDER
2
221
193
254
Windy-Days
Windy-Days
0
30
8
1
1
NIL
HORIZONTAL

SLIDER
2
255
192
288
Amoebae-Input
Amoebae-Input
0
100
15
1
1
/month
HORIZONTAL

SLIDER
2
287
192
320
decay-rate
decay-rate
0
100
1
1
1
years
HORIZONTAL

PLOT
2
530
1180
650
Plot
Time
Totals
0.0
100.0
0.0
100.0
true
true
PENS
"WTD" 1.0 1 -13345367 true
"AmoebaeKW" 1.0 0 -11221820 true
"AmoebaeKD" 1.0 0 -2674135 true
"AmoebaeR" 1.0 0 -10899396 true

@#$#@#$#@
WHAT IS IT?
-----------
This model simulates the community dynamics of living testate amoebae and monitors the asssocaited preserved tests in the top of an accumulating sphagnum bog. The ecology of testate amoebae is poorly understood; however, relationships to watertable depth are observed. Testates with different watertable depth (WTD) preference are represented by triangle shaped turtles pointing in different directions with different sizes. For more information read the associated paper posted on my website:
https://sites.google.com/a/lehigh.edu/wanderswest/home/current-research 


HOW IT WORKS
------------
One theory proposed to explain differences between variable and stable WTD loving testate amoebae suggests they may exhibit traits of r-selection and K-selection respectively. Aspects of the ecological principle of r/K selection suggest that r-selected species reproduce quickly with less energy and persist in unfavorable conditions longer. Species that are K-selected take longer to reproduce but are better at competing for resources. This principle has not been previously tested with testate amoebae. The goal of this study is to apply r/K selection traits to three types of amoebae, then determine which environments each prefer. The three groups are: 1) K-selected species with ideal WTD ranging from dry to neutral (termed _D-species_in this model); 2) K-selected species with ideal WTD of neutral to wet (_W-species_; 3) r-selected species with ideal WTD circumneutral (_-species_. Note, KD and KW-species are separated for model testing but should function as one K-type species with a wide range of ideal WTD. This model seeks to answer the question: what testate amoebae characteristics allow species to dominate during variable conditions?


THINGS TO NOTICE
----------------
The goal of this study is to test whether r-selected species dominate the communities during variable climate. To this end, the following objectives were completed using Netlogo modeling software:

1. Create a simplified bog-like habitat with hydrology that responds to precipitation, peat hydraulic conductivity, and regional groundwater levels (termed _asin-hydrology_in the model).    
2. Create an adjustable climate that uses randomly generated weather to produce consistent stable wet, stable dry, and variable conditions.  
3. Use the turtles feature of Netlogo to represent testate amoebae with characteristics summarized in Table 1. 
4. Verify the model by simulating stable wet, stable dry, stable intermediate, and variable conditions such that WTD remains high, low, circumneutral, or fluctuates over a period of a few months respectively. 
5. Verify KD or KW-species dominate during stable dry, stable wet, and intermediate conditions.
6. Verify R-species do not dominate during stable conditions at any WTD.   
7. Simulate variable conditions and see how testate amoebae respond! 


EXTENDING THE MODEL
-------------------
This project was written from scratch using open source code that allows the opportunity to add variables, such as humidity, and increasing levels of complexity. To further improve the model, better ecological equations for things like competition and reproduction energy cost should be integrated. One potential use would be to adjust climate to simulate the typical seasonality in region of interest. The model may also support future research identifying the importance of frequency and amplitude of external forcing on ecosystems.


CREDITS AND REFERENCES
----------------------
Travis Andrews. 2011. TESTATEWORLDWORKS2011!. Lehigh University, Bethlehem PA. 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

amoebaekd
false
12
Polygon -5825686 true true 255 255 150 0 60 255
Polygon -16777216 true false 180 210 120 210 150 0

amoebaekw
false
12
Polygon -5825686 true true 45 45 150 300 240 45
Polygon -16777216 true false 120 90 180 90 150 300

amoebaer
false
12
Polygon -5825686 true true 255 45 0 150 255 240
Polygon -16777216 true false 210 120 210 180 0 150

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cloud
false
0
Circle -7500403 true true 13 118 94
Circle -7500403 true true 86 101 127
Circle -7500403 true true 51 51 108
Circle -7500403 true true 118 43 95
Circle -7500403 true true 158 68 134

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

drop
false
0
Circle -7500403 true true 73 133 152
Polygon -7500403 true true 219 181 205 152 185 120 174 95 163 64 156 37 149 7 147 166
Polygon -7500403 true true 79 182 95 152 115 120 126 95 137 64 144 37 150 6 154 165

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line half
true
0
Line -7500403 true 150 0 150 150

line2
false
0
Line -7500403 true 75 120 210 195
Line -7500403 true 210 195 240 180
Line -7500403 true 75 120 45 135

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tile water
false
0
Rectangle -7500403 true true -1 0 299 300
Polygon -1 true false 105 259 180 290 212 299 168 271 103 255 32 221 1 216 35 234
Polygon -1 true false 300 161 248 127 195 107 245 141 300 167
Polygon -1 true false 0 157 45 181 79 194 45 166 0 151
Polygon -1 true false 179 42 105 12 60 0 120 30 180 45 254 77 299 93 254 63
Polygon -1 true false 99 91 50 71 0 57 51 81 165 135
Polygon -1 true false 194 224 258 254 295 261 211 221 144 199

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
