breed [nodes node]

nodes-own [
  state ; 0 or 1
  rule ; this number of the rule to follow (between 0 and 255)
  input-nodes ; this is the nodes whose states I take as input
  community ; used for finding components
  visits ; how frequency I am visited during strong component calculation
]

to setup
  __clear-all-and-reset-ticks
  set-default-shape nodes "circle"
  create-nodes 9 [
    set label who + 1
    set state random 2
    set color item state [red blue]

;    to decide a random set of rules
;    set rule random 256
;    set links-to []
;    repeat 3 [
;      set input-nodes lput random 8 input-nodes
;    ]

;   to visualize links
;    foreach links-to [
;      if not (who = ?)
;      [ create-link-with node ? ]
;    ]
  ]
  
;  setup hard coded rules and links for node
;  note - this was initially decided using the above commented out lines
  ask node 0 [ set rule 92 set input-nodes [3 7 0] ]
  ask node 1 [ set rule 229 set input-nodes [0 6 7] ]
  ask node 2 [ set rule 70 set input-nodes [3 6 5] ]
  ask node 3 [ set rule 160 set input-nodes [4 8 1] ]
  ask node 4 [ set rule 75 set input-nodes [7 1 1] ]
  ask node 5 [ set rule 107 set input-nodes [0 3 1] ]
  ask node 6 [ set rule 245 set input-nodes [7 3 2] ]
  ask node 7 [ set rule 105 set input-nodes [3 5 2] ]
  ask node 8 [ set rule 11 set input-nodes [5 0 8] ]          
  
  layout-circle (sort nodes) (max-pxcor - 1)
  reset-ticks
end

; iterates through every possible state and figures out what state it will transistion to
to map-out-network
  let future-network-state []
  let state-iter 0
  let c 0
  let my-inputs []
  let element-of-rule-to-follow 0
  
  ; for each possible state in the network
  while [ state-iter < 2 ^ count nodes ] [
    
    ; set each nodes state to match state-iter
    ask nodes [ set state item who to-binary state-iter ]
    
    set future-network-state []
    set c 0
    
    ;calculate next state based on current configuration
    ; ask each node in order, what it's next state will be
    while [ c < count nodes ] [
      set my-inputs []
      ask node c [
        ; figure out which element of my rule to follow
        set my-inputs lput [state] of node (item 0 input-nodes) my-inputs
        set my-inputs lput [state] of node (item 1 input-nodes) my-inputs
        set my-inputs lput [state] of node (item 2 input-nodes) my-inputs
        
        ; I know know which element of my rule to follow
        set element-of-rule-to-follow to-decimal my-inputs
        
        ; add future state for this node to array for future network state
        set future-network-state lput item element-of-rule-to-follow to-binary rule future-network-state
      ]
      set c c + 1
    ]
;    show (se "from " state-iter " to: " to-decimal future-network-state)    
    
    ; write out the current state and future state
    ; this file can be read in later
    file-close
    file-open "Final_3_P3_network.txt"
 
    file-write state-iter
    file-write to-decimal future-network-state
    file-print " "
  
    file-close
    set state-iter state-iter + 1
  ]
end

; helper function, takes in a number and returns an array of the binary version ex: 5 -> [1 0 1]
to-report to-binary [in-number]
  let i 10
  let binary []
  ; set each node to be 1 or 0
  while [i >= 0] [
    ifelse in-number >= 2 ^ i
    [
      set binary fput 1 binary
      set in-number in-number - 2 ^ i
    ]
    [
      set binary fput 0 binary
    ]
    set i i - 1
  ]
  report binary
end

; helper function, takes in a binary array and returns the number ex: [1 0 1] -> 5
to-report to-decimal [binary]
  let i 0
  let num 0
  while [ i < length binary] [
    if 1 = item i binary 
    [ set num num + 2 ^ i ]
    set i i + 1
  ]
  report num
end

to load-network
  clear-all
  create-nodes 512 [
    set color red
    set community 0
    set size .5
  ]
  
  layout-circle (sort nodes) (max-pxcor - 1)
  
  file-open "Final_3_P3_network.txt"
  ;; Read in all the data in the file
  while [not file-at-end?]
  [
    ;; this reads a single line into a three-item list
    let items read-from-string (word "[" file-read-line "]")

    ask node item 0 items
    [ create-link-to node item 1 items ]      
  ]
  file-close
end

; control logic to find strong components
to find-strong-components
;  reset network
  ask nodes [
    set color white
    set community 0
    set visits 0
  ]
  
  let community-id 1
  while [any? nodes with [community = 0] ]
  [
    ask one-of nodes with [community = 0] [
      ;first node is definately in the network, so set visits to 2 to ensure it is included
      set visits 1
      
      find-component community-id
    ]
   
   ; look at every visited node, if visited more than 1, it is part of a strong component
   ask nodes with [community = community-id] [
     ;; if only visited once, you're a weak connection, reset state
     if visits <= 1 [
       set visits 0
       set community 0
     ]
   ]
   if count nodes with [community = community-id] > 1 [
     let com-color random 256
     ask nodes with [community = community-id] [ set color com-color]
   ]
   set community-id community-id + 1
  ]
  display-component-info
end

; recursively visit neighbors at least once
to find-component [community-id]
  ifelse visits > 2
  [set visits visits + 1 ] ; i've seen this node before, mark the second visit and stop to prevent infinite loops
  [
    set visits visits + 1
    
    ;visit neighbors in your component or in no component
    if  community = 0 or community = community-id [
      ;;set color item community-id base-colors
      set community community-id
      ask out-link-neighbors [find-component community-id]
    ]
  ]
end

; this outputs info about the components to the console
to display-component-info
  let community-size-count []
  let largest-community 0
  foreach [community] of nodes [
    if count nodes with [community = ?] > largest-community
    [ set largest-community count nodes with [community = ?] ]
  ]
  repeat largest-community + 1 [
    set community-size-count lput 0 community-size-count
  ]

  foreach [community] of nodes [
    set community-size-count replace-item count nodes with [community = ?] community-size-count (item count nodes with [community = ?] community-size-count + 1) 
  ]
  let c 1
  while [c < largest-community + 1] [
    show (se (item c community-size-count / c) " strong component(s) of size: " c)
    set c c + 1
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
335
19
751
456
16
16
12.303030303030303
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
66
15
192
48
Load Rules (P1)
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
209
17
359
45
State 0: red\\nState 1: blue
11
0.0
1

BUTTON
76
57
239
90
Map out Network (P2)
map-out-network
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
23
110
318
244
  node 0 follows rule 92 and listens to nodes: 3 7 0\\n  node 1 follows rule 229 and listens to nodes: 0 6 7\\n  node 2 follows rule 70 and listens to nodes: 3 6 5\\n  node 3 follows rule 160 and listens to nodes: 4 8 1\\n  node 4 follows rule 75 and listens to nodes: 7 1 1\\n  node 5 follows rule 107 and listens to nodes: 0 3 1\\n  node 6 follows rule 245 and listens to nodes: 7 3 2\\n  node 7 follows rule 105 and listens to nodes: 3 5 2\\n  node 8 follows rule 11 and listens to nodes: 5 0 8\\n
11
0.0
1

BUTTON
71
275
214
308
Load Network (P2)
load-network
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
50
333
263
366
Find Strong Components (P3)
find-strong-components
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
4
Line -7500403 false 150 150 90 180
Line -7500403 false 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
