breed[patrons patron]
breed[vacancy-lights vacancy-light]
breed[trains train]

patrons-own[t-radius hunger searching eating returning bypassing R0x R0y R1x R1y R1p]   ; R0x and R0y are the disliked restaurant coords, R1x and R1y are the liked restaurant coords
                                                                                        ; R1p is the loyalty rating (or preference) of the liked restaurant
patches-own[capacity taste patronage restaurant? orig-x orig-y]                         ; orig-x and orig-y refer to the original coordinates of the restaurant
globals[rush-countdown fiscal-term-count taste-patronage-corr dist-patronage-corr dist-taste-corr]


to setup
  ifelse two-dimensional?
  [setup-2D]
  [setup-1D]
  
  
end

;;==================================================SETUP 1D MODE=================================================================

to setup-1D       ;; setup the environment
  ca
  set rush-countdown 1000
  set fiscal-term-count 1
  
  ask patches[
    set pcolor white
    set orig-x pxcor
    set orig-y pycor
    set restaurant? 0
    if(pxcor = -7)[set pcolor 17]
    if((pxcor > -7) and (abs(pycor) = 2))[                       ;; setup restaurants  1-D for this first model
      set restaurant? 1
      set pcolor lime
      set patronage 0
      set taste random 100
      set capacity  (random capacity-variation) + (average-capacity - (capacity-variation / 2))
      if(capacity < 1)[set capacity 1]
      
    
      sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        set label-color black
      ]
      ]
    if((pxcor > -7) and (abs(pycor) > 2))[set pcolor brown]    
    if((pxcor = -7) and (abs(pycor) < 2))[set pcolor blue]         ;; setup home base for turtles to live between meals
 
     
     
       if((pxcor = -7) and (pycor = 0))[
        sprout-trains 1[
          set shape "train passenger car"
          set color gray + 3
          set size 2
          set heading 0
        ]
    ]   
    ]
  
  
  
  create-patrons number-patrons[
    initialize-patrons
  ]
  
end


;==============================================================TO SETUP-2D===========================================================

to setup-2D       ;; setup the environment
  ca
  set rush-countdown 1000
  set fiscal-term-count 5000
  set fiscal-term-count 1
  
  ask patches[
    set orig-x pxcor
      set orig-y pycor
    set pcolor white
    set restaurant? 0
    if(pxcor = -7)[set pcolor 17]
    if((pxcor = -7) and (pycor = 0))[
        sprout-trains 1[
          set shape "train passenger car"
          set color gray + 3
          set size 2
          set heading 0
        ]
    ]
    
    
    
    if((pxcor > -6) and ((pxcor mod (7 - N-S-street-density)) != 0) and ((pycor mod (7 - E-W-street-density))!= 0))[                       ;; setup restaurants  1-D for this first model
     
     ifelse(wide-boulevards?)[
     if((abs(pxcor) > 1) and (abs(pycor) > 1))[
     ifelse(random 100 < restaurant-density)[
      set restaurant? 1
      set pcolor lime
      set patronage 0
      set taste random 100
      set capacity (random capacity-variation) + (average-capacity - (capacity-variation / 2))
      if(capacity < 1)[set capacity 1] ;make sure each restaurant has at least capacity of 1
      sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        
        set label-color black
      ]
      ]      
     [
       set pcolor brown
       
       
       ]
    ]
    ]
     
     
     [
       
     ifelse(random 100 < restaurant-density)[
      set restaurant? 1
      set pcolor lime
      set patronage 0
      set taste random 100
      set capacity (random capacity-variation) + (average-capacity - (capacity-variation / 2))
      if(capacity < 1)[set capacity 1] ;make sure each restaurant has at least capacity of 1
      sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        
        set label-color black
      ]
      ]      
     [
       set pcolor brown
       
       
       ]
    ]
     
    ]    
      
    if((pxcor = -7) and (abs(pycor) < 2))[set pcolor blue]         ;; setup home base for turtles to live between meals
 
  ]
  
  ask patches with [restaurant? = 1][
    if ((count neighbors4 with [pcolor = white]) = 0)[         ;; if they have no street access, don't make them a restaurant
      set pcolor brown
      set restaurant? 0
      ask turtles-here[die]
    ]
    
  ]
  
  
  create-patrons number-patrons[
   initialize-patrons
  ]
  
end

;==============================================================TO GO==================================================================
to go
  check-rush
  check-fiscal
  
  ask patrons[
    check-bypass
    check-eating
    check-hunger
    check-returning
    check-searching
    if(random 100000 < patron-turnover) [die]
   
  ]
  
  ask vacancy-lights[
    check-capacity
  ]
  
  ask patches[
    update-patronage
  ]
  
  ask vacancy-lights[
    set label [patronage] of patch-here
  ]
  
  ask trains[
    move
  ]
  
  update-charts
    

end


;====================================================================================================================================

to check-location      ;; check if this is somewhere the turtle wants to eat
  if([restaurant?] of patch-here = 1)[
    ifelse(random 200 < hunger)       ;; the hungrier the turtle is, the more likely it is to enter a restaurant        
    [enter-restaurant]      ;; if the turtles are on a restaurant and like it, they will stop searching. Otherwise, turn around                  
    [keep-searching]
  ]  
  if([pcolor] of patch-here = brown)[keep-searching]
 
end


to check-eating
  if(eating = 1)[
    set searching 0
    set hunger (hunger - 5)   ;; while eating, the turtle becomes less hungry
    if(hunger <= 0)[
      set eating 0     ;; no longer hungry
      set returning 1
     
    ] ;; when the turtle is no longer hungry, it will return home
  ]
  
  
  
  
end



to check-hunger
  if((hunger > 100) and ([pcolor] of patch-here = blue))[ 
    
    ifelse((random 200 < R1p ) and (R1y != 0))       ;; choose if the turtle is going to search, or go straight to it's favorite restaurant
      [set bypassing 1]
      [set searching 1]
   ]
  set hunger (hunger + 1)    ;; every tick the turtle gets more hungry
  
end



to check-returning
  if(returning = 1)[
    facexy -7 0
    fd .2
    if([pcolor] of patch-here = blue)[set returning 0]
    
  ]
  
end


to check-searching
  if(searching = 1)[
  set heading (heading + (random t-radius) - (random t-radius))     ;; have the turtles wiggle, then move forward
  if(xcor < -6)[set heading 90]                         ;; if turtle is out of bounds, send them in the right direction
  fd .1
  check-location
  ]
  
end

 
to check-bypass
  if(bypassing = 1)[
    let t-R1x R1x
    let t-R1y R1y
    let x-go [pxcor] of (patches with [(orig-x = t-R1x) and (orig-y = t-R1y)])         ;; go to the favorite restaurant, even if it has changed location
    let y-go [pycor] of (patches with [(orig-x = t-R1x) and (orig-y = t-R1y)])
    facexy (one-of x-go) (one-of y-go)
    fd .1
    if(([orig-x] of patch-here = R1x) and ([orig-y] of patch-here = R1y))[enter-restaurant]
   
  ]
  
end

to enter-restaurant
  
  if(([orig-x] of patch-here = R0x) and ([orig-y] of patch-here = R0y))[
    keep-searching];; if this is a restaurant the turtle dislikes, keep searching
  
  
  
  ifelse((count patrons-here) > ([capacity] of patch-here))   ;; make sure the restaurant hasn't reached capacity. If it has, we continue searching
  [
    
    keep-searching
  ]
  [
  set bypassing 0 ;; no longer in bypass mode
  set searching 0  ;; no longer in search mode
  set eating 1   ;; we found the restaurant, we're happy!  
  ask patch-here[
    set patronage patronage + 1
    if(pcolor > 60)[
      set pcolor (pcolor - 1) ;; readjust patch color
      if(pcolor < 60)[set pcolor 60]  ;; make sure readjustment doesn't overshoot
      ]
    
    ] ;; have the restaurant remember that they had another customer
  ]
  
  ifelse((R1x = [orig-x] of patch-here) and (R1y = [orig-y] of patch-here))
  [
    set R1p (R1p + 20)
    if(R1p > 190)[set R1p 190]  ;; make sure the preference factor doesn't go over 90
    
    
    
  ]
   [if((random 100 < ([taste] of patch-here)) and ([taste] of patch-here >= 60))[
        set R1x ([orig-x] of patch-here)   ;; have the turtle remember this restaurant if they liked it
        set R1y ([orig-y] of patch-here)
        set R1p ([taste] of patch-here)
      ]
   ]
      if(([taste] of patch-here) < 30)[
        set R0x ([orig-x] of patch-here)   ;; have the turtle remember this restaurant if they disliked it
        set R0y ([orig-y] of patch-here)
      ]
      
      
      
end

to check-capacity
  ifelse((count patrons-here) >= [capacity] of patch-here)
  [set color red]         ;; if a restaurant's capacity has been reached, signal by turning red
  [set color white]
  
end

to keep-searching
  set searching 1
  set bypassing 0
  set heading (heading + 180 + random 80 - random 80)
  fd .5
     
end

to check-rush
  
  if(rush-countdown = 75)[
    ask patrons[
      if(random 2 < 1)[
        set hunger 0
        set searching 0
        set bypassing 0
        set returning 1
        
      ]  
    ]
  ]
  
  


  
    
  
  if(rush-countdown = 0)[

    ask patrons[if([pcolor] of patch-here = blue)[set hunger 100]] ;;have each turtle release every 1000 ticks
    set rush-countdown 1000
 
    
    
    
    create-patrons (.01 * patron-turnover * number-patrons)[
      initialize-patrons
  ]
      
      
  ]
  set rush-countdown (rush-countdown - 1)
end


to update-patronage  ;; have the restaurants display their normalized patronage
  if((restaurant? = 1) and (pcolor < 69))[set pcolor (pcolor + .01)]
  
  
end

to update-charts  ;; let's plot some stuff!
   
  set-current-plot "Distance vs. Taste"
  clear-plot
  set-plot-pen-mode 2
   ask patches with [restaurant? = 1][
    
    let my-x-dist (distancexy -7 pycor)
    let my-y-dist (distancexy pxcor 0)
   
    

   plotxy (my-x-dist + my-y-dist) taste
   ]
   
  
  set-current-plot "Patronage Distribution"   
  set-histogram-num-bars 10
  set-plot-pen-mode 1
  histogram ([70 - pcolor] of (patches with [restaurant? = 1]))
  tick 
  
  set-current-plot "Taste vs. Patronage"
  clear-plot
  set-plot-pen-mode 2
  ask patches with [restaurant? = 1][
    plotxy taste (100 * patronage / fiscal-term-count)
  ]
    
  set-current-plot "Distance vs. Patronage"
  clear-plot
  set-plot-pen-mode 2
  ask patches with [restaurant? = 1][
    
    let my-x-dist (distancexy -7 pycor)
    let my-y-dist (distancexy pxcor 0)
   plotxy (my-x-dist + my-y-dist) (100 * patronage / fiscal-term-count)
   
  ]
  
  
   
   let tlist sum [taste] of patches with [restaurant? = 1]                        ;; calculate some correlation coefficients!
   let plist sum [patronage] of patches with [restaurant? = 1]
   let dlist sum [distance patch -7 0] of patches with [restaurant? = 1]
   let N count patches with [restaurant? = 1]
 
   let tlist2 sum [taste ^ 2] of patches with [restaurant? = 1]
   let plist2 sum [patronage ^ 2] of patches with [restaurant? = 1]
   let dlist2 sum [(distance patch -7 0) ^ 2] of patches with [restaurant? = 1]
   
   let tplist sum [taste * patronage] of patches with [restaurant? = 1]
   let tdlist sum [taste * (distance patch -7 0)] of patches with [restaurant? = 1]
   let dplist sum [(distance patch -7 0) * patronage] of patches with [restaurant? = 1]
   
   if((N * (tlist2 - 1)) * (N * (plist2 - 1)) > 0)[
   set taste-patronage-corr ( ((N * tplist) - (tlist * plist)) / sqrt((N * (tlist2 - 1)) * (N * (plist2 - 1))))
   ]
   
   if((N * (dlist2 - 1)) * (N * (plist2 - 1)) > 0)[
   set dist-patronage-corr ( ((N * dplist) - (dlist * plist)) / sqrt((N * (dlist2 - 1)) * (N * (plist2 - 1))))
   ]
   
     if((N * (dlist2 - 1)) * (N * (tlist2 - 1)) > 0)[
   set dist-taste-corr ( ((N * tdlist) - (dlist * tlist)) / sqrt( (N * (dlist2 - 1)) * (N * (tlist2 - 1)) ))
   ]

   
   
   
  
end


to move
  fd .015
  if(ycor > 7.499999)[ set ycor -7.5]
end


to initialize-patrons
   setxy -7 0                  ;; have the turtles start out at their home base
   ifelse(pirate-mode?)[
    set shape "pirate"   
    set size ((random 4) + 1) / 2    ]
    [set shape "person"]
    set heading 90
    set hunger random 100
    set R0x 0
    set R0y 0
    set R1x 0
    set R1y 0
    set t-radius 20 + random 30
  
end



to check-fiscal
  
  set fiscal-term-count (fiscal-term-count + 1)
  if (fiscal-term-count = fiscal-period-length)[
    set fiscal-term-count 1

ask patches[                           ; switch restaurants
  
  
  if(patches-move?)[
  
  
  ifelse(abs(pycor) != max-pycor)[ 
    if((([pcolor] of patch pxcor (pycor + 1)) = white) or (([pcolor] of patch pxcor (pycor - 1)) = white)) [move-left]
  ]
  
  [ 
    
    ifelse(pycor > 0)
    [if(([pcolor] of patch pxcor (pycor - 1)) = white)[move-left]]
    [if(([pcolor] of patch pxcor (pycor + 1)) = white)[move-left]]
  
  ]
  
  
  
  ifelse(abs(pxcor) != max-pxcor)[
    if((([pcolor] of patch (pxcor + 1) pycor) = white) or (([pcolor] of patch (pxcor - 1) pycor) = white))[
    ifelse(pycor > 0)
    [move-down]
    [move-up]
    
  ]
  ]
  
  [

    ifelse(pycor > 0)
    [if((([pcolor] of patch pxcor (pycor - 1)) = white))[move-down]]
    [if((([pcolor] of patch pxcor (pycor + 1)) = white))[move-up]]
  ]
  
  
]
      set patronage 0
      
    ]

    
ask patches[  
 if(pcolor = brown)[ ask vacancy-lights-here[die]] ;; if no longer a restaurant, have the light die
 ]
    
  ]
  
  
end
  

to move-left
  
  if((patch (pxcor - 1) pycor != nobody) and ([pcolor] of patch (pxcor - 1) pycor != white) and (pxcor > -6))[
    
      if(([patronage] of patch (pxcor - 1) pycor) < patronage - (fiscal-period-length / 100))[
        let t-capacity ([capacity] of patch (pxcor - 1) pycor)
        let t-taste ([taste] of patch (pxcor - 1) pycor)
        let t-restaurant? ([restaurant?] of patch (pxcor - 1) pycor)
        let t-orig-x ([orig-x] of patch (pxcor - 1) pycor)
        let t-orig-y ([orig-y] of patch (pxcor - 1) pycor)
        let t-pcolor ([pcolor] of patch (pxcor - 1) pycor)
        
        ask (patch (pxcor - 1) pycor)[
          set capacity ([capacity] of myself)
          set taste ([taste] of myself)
          set restaurant? ([restaurant?] of myself)
          set orig-x ([orig-x] of myself)
          set orig-y ([orig-y] of myself)
          set pcolor ([pcolor] of myself)
          sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        
        set label-color black
      ]
          
        ]
        
          set capacity t-capacity
          set taste t-taste
          set restaurant? t-restaurant?
          set orig-x t-orig-x
          set orig-y t-orig-y
          set pcolor t-pcolor
       
        
      ]
    ]
  
  
end


to move-down
  
  if((patch pxcor (pycor - 1) != nobody) and ([pcolor] of patch pxcor (pycor - 1) != white))[
    
      if(([patronage] of patch pxcor (pycor - 1)) < patronage - (fiscal-period-length / 100))[
        let t-capacity ([capacity] of patch pxcor (pycor - 1))
        let t-taste ([taste] of patch pxcor (pycor - 1))
        let t-restaurant? ([restaurant?] of patch pxcor (pycor - 1))
        let t-orig-x ([orig-x] of patch pxcor (pycor - 1))
        let t-orig-y ([orig-y] of patch pxcor (pycor - 1))
        let t-pcolor ([pcolor] of patch pxcor (pycor - 1))
        
        ask(patch pxcor (pycor - 1))[
          set capacity ([capacity] of myself)
          set taste ([taste] of myself)
          set restaurant? ([restaurant?] of myself)
          set orig-x ([orig-x] of myself)
          set orig-y ([orig-y] of myself)
          set pcolor ([pcolor] of myself)
          sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        
        set label-color black
      ]
          
        ]
        
          set capacity t-capacity
          set taste t-taste
          set restaurant? t-restaurant?
          set orig-x t-orig-x
          set orig-y t-orig-y
          set pcolor t-pcolor
         
        
      ]
    ]
  
  
end


to move-up
   if((patch pxcor (pycor + 1) != nobody) and ([pcolor] of patch pxcor (pycor + 1) != white))[
    
      if(([patronage] of patch pxcor (pycor + 1)) < patronage - (fiscal-period-length / 100))[
        let t-capacity ([capacity] of patch pxcor (pycor + 1))
        let t-taste ([taste] of patch pxcor (pycor + 1))
        let t-restaurant? ([restaurant?] of patch pxcor (pycor + 1))
        let t-orig-x ([orig-x] of patch pxcor (pycor + 1))
        let t-orig-y ([orig-y] of patch pxcor (pycor + 1))
        let t-pcolor ([pcolor] of patch pxcor (pycor + 1))
        
        ask(patch pxcor (pycor + 1))[
          set capacity ([capacity] of myself)
          set taste ([taste] of myself)
          set restaurant? ([restaurant?] of myself)
          set orig-x ([orig-x] of myself)
          set orig-y ([orig-y] of myself)
          set pcolor ([pcolor] of myself)
          sprout-vacancy-lights 1[
        set shape "square"      ;; this will act as the restaurant's vacancy light!
        set color white
        set size .8
        
        set label-color black
      ]
          
        ]
        
          set capacity t-capacity
          set taste t-taste
          set restaurant? t-restaurant?
          set orig-x t-orig-x
          set orig-y t-orig-y
          set pcolor t-pcolor
          
        
      ]
    ]
  
  
end
@#$#@#$#@
GRAPHICS-WINDOW
644
33
1104
514
7
7
30.0
1
10
1
1
1
0
0
0
1
-7
7
-7
7
1
1
1
ticks

BUTTON
457
286
520
319
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
536
286
599
319
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
18
366
218
516
Patronage Distribution
Patronage
Number of Restaurants
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

SLIDER
454
34
626
67
number-patrons
number-patrons
0
500
50
5
1
NIL
HORIZONTAL

SLIDER
455
78
627
111
patron-turnover
patron-turnover
0
100
27
1
1
NIL
HORIZONTAL

MONITOR
26
197
116
242
patron pop.
count patrons\\n
17
1
11

SLIDER
458
396
630
429
restaurant-density
restaurant-density
0
100
74
1
1
NIL
HORIZONTAL

SLIDER
458
437
630
470
N-S-street-density
N-S-street-density
0
4
4
1
1
NIL
HORIZONTAL

SLIDER
458
481
630
514
E-W-street-density
E-W-street-density
0
4
2
1
1
NIL
HORIZONTAL

SLIDER
455
163
627
196
average-capacity
average-capacity
1
20
14
1
1
NIL
HORIZONTAL

SLIDER
455
201
627
234
capacity-variation
capacity-variation
0
6
3
1
1
NIL
HORIZONTAL

PLOT
238
35
438
185
Taste vs. Patronage
Taste
Patronage
0.0
100.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

PLOT
238
196
438
346
Distance vs. Patronage
Distance
Patronage
0.0
20.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

SWITCH
457
325
607
358
two-dimensional?
two-dimensional?
0
1
-1000

MONITOR
129
199
195
244
searching
count patrons with [searching = 1]
17
1
11

MONITOR
23
302
80
347
eating
count \\npatrons with [eating = 1]
17
1
11

MONITOR
24
250
81
295
waiting
count patrons with[([pcolor] of patch-here = blue) and (searching = 0)]
17
1
11

MONITOR
129
251
198
296
bypassing
count patrons with [bypassing = 1]
17
1
11

MONITOR
128
304
192
349
returning
count patrons with [returning = 1]
17
1
11

SWITCH
458
361
610
394
wide-boulevards?
wide-boulevards?
0
1
-1000

PLOT
240
366
440
516
Distance vs. Taste
Distance
Taste
0.0
20.0
0.0
100.0
true
false
PENS
"default" 1.0 0 -16777216 true

SLIDER
456
120
628
153
fiscal-period-length
fiscal-period-length
1000
10000
1000
1000
1
NIL
HORIZONTAL

MONITOR
22
33
153
78
NIL
taste-patronage-corr\\n
5
1
11

MONITOR
22
86
143
131
NIL
dist-patronage-corr\\n
5
1
11

MONITOR
22
145
115
190
NIL
dist-taste-corr
5
1
11

SWITCH
457
240
597
273
patches-move?
patches-move?
0
1
-1000

SWITCH
121
153
232
186
pirate-mode?
pirate-mode?
0
1
-1000

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

pirate
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 210 180 195 210 270 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Circle -1 false false 120 15 30
Line -16777216 false 165 45 165 45
Polygon -2674135 true false 120 60 135 75 165 75 150 60 120 60 120 60 120 60 120 60
Polygon -16777216 true false 165 75 165 75 120 60
Polygon -13840069 true false 90 60 90 60 75 60 90 60
Polygon -16777216 true false 240 150 240 150 255 165 240 180 285 180 270 225 270 225 240 240 225 210 255 210 255 195 225 195 225 165 240 150 240 150 255 165
Polygon -16777216 true false 225 165 210 195 225 195 225 165
Polygon -16777216 true false 120 15 135 15
Polygon -2674135 true false 120 15 150 0 165 0 180 15 195 30 195 45 120 15 120 15
Circle -16777216 true false 120 15 30
Rectangle -16777216 true false 165 45 165 45
Rectangle -16777216 true false 165 45 165 45
Rectangle -16777216 true false 165 45 165 45
Line -16777216 false 165 45 165 45
Polygon -16777216 true false 165 45 165 45 165 45
Circle -1 true false 150 30 30
Line -16777216 false 165 45 165 45
Circle -13840069 true false 54 24 42
Polygon -13840069 true false 90 60 90 60 105 75 105 105 75 120 45 120 75 60 90 60
Polygon -1184463 true false 90 30 90 30 90 60 120 60 90 30 90 30
Circle -16777216 true false 75 30 0
Polygon -6459832 true false 180 195 195 210 165 240 150 225 180 195
Polygon -6459832 true false 180 210 240 270 225 285 165 210 180 210

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

train passenger car
false
0
Polygon -7500403 true true 206 285 150 285 135 285 120 270 120 30 135 15 150 15 206 15 210 30 210 270
Circle -16777216 true false 195 30 30
Circle -16777216 true false 195 60 30
Circle -16777216 true false 195 210 30
Circle -16777216 true false 195 240 30
Rectangle -16777216 true false 140 32 165 270
Line -7500403 true 135 240 165 240
Line -7500403 true 135 240 165 240
Line -7500403 true 135 210 165 210
Line -7500403 true 135 180 165 180
Line -7500403 true 135 150 165 150
Line -7500403 true 135 120 165 120
Line -7500403 true 135 90 165 90
Line -7500403 true 135 60 165 60
Rectangle -16777216 true false 195 281 207 295
Rectangle -16777216 true false 195 5 207 19
Rectangle -13345367 true false 165 15 173 285
Rectangle -2674135 true false 180 15 188 285

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="7900"/>
    <metric>taste-patronage-corr</metric>
    <metric>dist-patronage-corr</metric>
    <metric>dist-taste-corr</metric>
    <enumeratedValueSet variable="N-S-street-density">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fiscal-period-length">
      <value value="1000"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-patrons" first="100" step="100" last="500"/>
    <steppedValueSet variable="average-capacity" first="1" step="2" last="15"/>
    <enumeratedValueSet variable="capacity-variation">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wide-boulevards?">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="patron-turnover" first="0" step="10" last="99"/>
    <steppedValueSet variable="E-W-street-density" first="0" step="1" last="3"/>
    <enumeratedValueSet variable="two-dimensional?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="restaurant-density" first="10" step="20" last="100"/>
  </experiment>
  <experiment name="experiment2" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="7900"/>
    <metric>taste-patronage-corr</metric>
    <metric>dist-patronage-corr</metric>
    <metric>dist-taste-corr</metric>
    <enumeratedValueSet variable="N-S-street-density">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fiscal-period-length">
      <value value="1000"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-patrons" first="100" step="100" last="500"/>
    <steppedValueSet variable="average-capacity" first="1" step="2" last="15"/>
    <enumeratedValueSet variable="capacity-variation">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wide-boulevards?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="patron-turnover" first="0" step="10" last="99"/>
    <steppedValueSet variable="E-W-street-density" first="0" step="1" last="3"/>
    <enumeratedValueSet variable="two-dimensional?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="restaurant-density" first="10" step="20" last="100"/>
  </experiment>
  <experiment name="experiment1-d" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="9900"/>
    <metric>taste-patronage-corr</metric>
    <metric>dist-patronage-corr</metric>
    <metric>dist-taste-corr</metric>
    <enumeratedValueSet variable="N-S-street-density">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fiscal-period-length">
      <value value="1000"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-patrons" first="100" step="100" last="500"/>
    <steppedValueSet variable="average-capacity" first="2" step="2" last="16"/>
    <enumeratedValueSet variable="capacity-variation">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wide-boulevards?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patron-turnover">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="E-W-street-density">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="two-dimensional?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="restaurant-density">
      <value value="90"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="turnover-exp" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="9900"/>
    <metric>taste-patronage-corr</metric>
    <metric>dist-patronage-corr</metric>
    <metric>dist-taste-corr</metric>
    <enumeratedValueSet variable="N-S-street-density">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fiscal-period-length">
      <value value="1000"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-patrons" first="100" step="100" last="400"/>
    <enumeratedValueSet variable="average-capacity">
      <value value="14"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="capacity-variation">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wide-boulevards?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="patron-turnover" first="0" step="10" last="100"/>
    <enumeratedValueSet variable="E-W-street-density">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="two-dimensional?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="restaurant-density">
      <value value="90"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="turnover2" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="4900"/>
    <metric>taste-patronage-corr</metric>
    <metric>dist-patronage-corr</metric>
    <metric>dist-taste-corr</metric>
    <enumeratedValueSet variable="N-S-street-density">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fiscal-period-length">
      <value value="10000"/>
    </enumeratedValueSet>
    <steppedValueSet variable="number-patrons" first="100" step="100" last="400"/>
    <enumeratedValueSet variable="average-capacity">
      <value value="14"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patches-move?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="capacity-variation">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wide-boulevards?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="patron-turnover" first="0" step="10" last="100"/>
    <enumeratedValueSet variable="E-W-street-density">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="two-dimensional?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="restaurant-density">
      <value value="90"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
