globals [population birth-rate die-rate average-education new-baby]
turtles-own [ gender age education in-school kids ]
undirected-link-breed [mates mate]
undirected-link-breed [schools school]
schools-own [studytime studylevel]


to setup
clear-all
appear-schools
crt number-of-persons [
  set shape "person"
  set color red 
  setxy random-xcor random-ycor
  set-education
  ;; 0 means single , 1 means marriaged
  ;set mate-status 0  
  set age 18 
  ;;at the beginning , no body has the kind
  set kids 0
  ;;in-school shows the persons student status , 0 means this person is not in 
  ;;school currently , 1 means this person have been spent 1 year in the school, 
  ;;2 means this person has been in school for 2 years , and so forth .
  set in-school 0
  ;; 0 means female ,1 means male
  ifelse random 2 = 0 
  [set gender 0] 
  [set gender 1] 
  ]
end

to appear-schools
  ;;creat some turtle and set them as the school , shape as house , color as green 
  crt number-of-schools [ 
    set shape "house"
    set color green
    setxy random-xcor random-ycor 
    set age -5000000000000000
    ]
end

to set-education
  let n random-float 1.00
  ;; 1 means high-school , 20% high school person
  if n <= 0.20 [ set education  1] 
  ;; 2 means undergraduate , 50% undergraduate person
  if n <= 0.70 and n > 0.20 [ set education  2 ] 
  ;; 3 means Master , 20% MS person
  if n > 0.70 and n <= 0.90 [ set education  3 ] 
  ;; 4 means PhD , 10% PhD person
  if n > 0.90 and n <= 1 [ set education  4 ]  
end
  
to go
   ; ask turtles [set mylinkcount count my-links]
    move
    ask turtles [get-mate]
    reproduce
    go-to-school
    graduate
    old-to-die
  if not any? turtles [ stop ]
  tick
  ;;only interest the population of adute people with education degree, in other words , no including the children (less than 17 years-old)
  set population count turtles with [education >= 1 and color = red]
  update-average-education
  update-plot-population
  update-birth-rate
end

to move 
  ;; randomly walk 
  ask turtles with [color = red] [
  rt random 50
  lt random 50
  fd 0.3
  ]
  ask schools [ 
    set studytime studytime + 1
    ]
end

to get-mate ;;turtle procedure
  if count my-mates = 0 [
    ;; set my education as a temporary variable
    let my-education education
    ;; set my gender as a temporary variable 
    let my-gender gender
    ;; set my age as a temporary variable 
    let my-age age
    ;; find is there any persons in my neighbors who is single and have similar education level and opposite gender ,
    ;; and also in a similar age .
    let match one-of ( turtles-on neighbors ) with [count my-mates = 0 and gender != my-gender and education >= my-education - 1 
                                                    and education <= my-education + 1 and age >= my-age - 6 and age <= my-age + 6 ]
    ;;there is a probability to control the chance to get mate 
    if random-float 1.0 <= probability-to-mate [ 
    ;;if there is a turtle satisfing all of the constriants , then they will get mate   
    if match != nobody 
    [ create-mate-with match [set color pink ]
      ]
   ]
  ]
end 


to reproduce  
  ;;find the person who is female and marriaged
  ask turtles with [ count mate-neighbors > 0 and gender = 0  ] 
  [
   ;; also assume only the female in some age range[18,45] can have the possibility to reproduce a baby
   if age >= 18 and age <= 45 [
     ;; also only when the female is not studying in the school , will consider to have a baby
     if random-float 1.0 <= probability-to-reproduce ^ ((age / 10) + (kids * weight) + in-school * weight + (count turtles with [color = red])/ 1000 ) [
           ;;if this turtles satisfy all of these constraints , then she will reproduce a baby and then set 
           ;; the kids parameter + 1 , which means she have one more baby
           hatch 1 [  
                   set age  0 
                   set education  0
                   ifelse random 2 = 0 
                   [set gender 0] 
                   [set gender 1] 
                   set kids 0 
                   set color red
                   set in-school 0
                   lt random 90 
                   fd 0.3 
                   ]
          set kids kids + 1
          let my-kids kids
          ask mate-neighbors [set kids my-kids ]
      ]
    ]
  ]
  
  
end


to go-to-school
  ;; find the turtles that between the age range and also not studying in school now
  ask turtles with [ color = red and age >= 17 and age <= 36 and in-school = 0][
    ;; find any one school(green color turtles) and if the school capacity is not full
    go-to-undergraduate
    go-to-MS
    go-to-PhD    
    ]      
  
end

to go-to-undergraduate
  
  if education = 1 [
  let match one-of turtles with [ color = green and count (my-schools with [studylevel = 2]) < school-capacity * 0.5 ]
  if match != nobody and random-float 1.0 <= probability-to-school ^ (education * weight + kids * weight + (abs(18 - age) / 10 ) * weight ) [
  create-school-with match [
                            set color yellow
                            set studytime 0
                            set studylevel 2
                            ]
  set in-school 1
    ]
  ]
end

to go-to-MS
  if education = 2 [
  let match one-of turtles with [ color = green and count (my-schools with [studylevel = 3]) < school-capacity * 0.35 ]
  if match != nobody and random-float 1.0 <= probability-to-school ^ (education * weight + kids * weight + (abs(22 - age) )) [
  create-school-with match [set color gray 
                            set studytime 0
                            set studylevel 3]
  set in-school 1
  ]
  ]
end

to go-to-PhD
  if education = 3 [
  let match one-of turtles with [ color = green and count (my-schools with [studylevel = 4]) < school-capacity * 0.15 ]
  if match != nobody and random-float 1.0 <= probability-to-school ^ (education * weight + kids * weight + (abs(25 - age) )) [
  create-school-with match [set color green
                            set studytime 0
                            set studylevel 4]
  set in-school 1
  ]
  ]
end

to graduate
  ask schools [
    if studylevel = 2 and studytime >= 4 + random-normal 0 0.5 [ die ]
    if studylevel = 3 and studytime >= 2 + random-normal 0 0.5 [ die ]
    if studylevel = 4 and studytime >= 4 + random-normal 0 0.5 [ die ]
    ]
  ask turtles with [ color = red and in-school = 1] [
    ifelse education = 1 and count my-schools = 0 [
    set in-school 0
    set education 2
    ]
    [
      ifelse education = 2 and count my-schools = 0 [
        set in-school 0
        set education 3
       ]
      [if education = 3 and count my-schools = 0 [
        set in-school 0
        set education 4
       ] 
      ]
    ]
;  if education = 2 and count my-schools = 0 [
;    set in-school 0
;    set education 3
;    ] 
;  if education = 3 and count my-schools = 0 [
;    set in-school 0
;    set education 4
;    ]
  ]
end

to old-to-die 
  ask turtles with[ color = red ] [
  ;; get older each tick
  set age age + 1
  ;; if the child is 16 years-old , then assume he/she has a high-school education level
  if age = 17 [set education 1]
  
  ;; if the age is larger than a normal variable (Mean=80 & SD=3) , then die 
  if age >= random-normal 75 3   
  [die]
  ]
end

to update-plot-population
  if not any? turtles with[ color = red ] [ stop ]
  set-current-plot "population"
  set-current-plot-pen "high-school"
  plot count turtles with [education = 1] / population
  
  set-current-plot-pen "undergraduate"
  plot count turtles with [education = 2] / population
  
  set-current-plot-pen "Master"
  plot count turtles with [education = 3] / population
  
  set-current-plot-pen "PhD"
  plot count turtles with [education = 4] / population
end

to update-average-education
  if not any? turtles with [color = red] [ stop ]
  set-current-plot "average-education"
  set average-education  sum [ education ] of turtles with [ education >= 1 ]  / population
  plot average-education 
end

to update-birth-rate
  if not any? turtles with [color = red] [ stop ]
end

@#$#@#$#@
GRAPHICS-WINDOW
242
10
681
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks

BUTTON
9
34
75
67
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
108
35
171
68
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
11
82
183
115
number-of-persons
number-of-persons
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
11
126
183
159
number-of-schools
number-of-schools
0
20
5
1
1
NIL
HORIZONTAL

SLIDER
11
169
183
202
school-capacity
school-capacity
0
200
50
1
1
NIL
HORIZONTAL

PLOT
11
212
236
362
population
NIL
%
0.0
10.0
0.0
1.0
true
true
PENS
"undergraduate" 1.0 0 -1184463 true
"high-school" 1.0 0 -13345367 true
"Master" 1.0 0 -7500403 true
"PhD" 1.0 0 -10899396 true

PLOT
10
371
234
521
average-education
NIL
NIL
0.0
10.0
0.0
4.0
true
false
PENS
"default" 1.0 0 -16777216 true

SLIDER
3
534
219
567
probability-to-reproduce
probability-to-reproduce
0
1.00
0.77
0.01
1
NIL
HORIZONTAL

SLIDER
241
490
422
523
probability-to-mate
probability-to-mate
0
1.00
0.77
0.01
1
NIL
HORIZONTAL

SLIDER
234
535
429
568
probability-to-school
probability-to-school
0
1.00
0.7
0.01
1
NIL
HORIZONTAL

MONITOR
689
110
838
159
number of Undergraduate
count turtles with [color = red and education = 2]
17
1
12

MONITOR
689
59
820
108
number of Highschool
count turtles with [color = red and education = 1]
17
1
12

MONITOR
690
163
786
212
number of MS
count turtles with [color = red and education = 3]
17
1
12

MONITOR
691
217
794
266
number of PhD
count turtles with [color = red and education = 4]
17
1
12

MONITOR
689
10
860
55
number of people less than 18 yo
count turtles with [education = 0 and color = red]
17
1
11

SLIDER
440
490
612
523
weight
weight
1
10
1
0.1
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

dot1
0.0
-0.2 0 0.0 1.0
0.0 1 4.0 4.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
