globals
[
  supergame
  danger
  turtle1
  turtle2
  tieturtles
  closerturtlelink
  closerturtle
  turtletrust
  globalcit
  gameturtle
  gameturtlelink
  worstturtlelink
  worstturtle
  globaltrust
  group-size        ;; current running size of group being explored
  biggestgroup
  groups            ;; list of connected components
  truststore
]

breed[boths both]
breed[As A]
breed[Bs B]
breed[nones none]

undirected-link-breed[connectors connector]

turtles-own
[
  group
  explored?    ;; used to compute connected components in the graph
]

links-own
[
  linkgroup
  instcit
  mutualtrust  ;; true if the link represents a loner joining a group
]


;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;


to setup
  clear-all
  set-default-shape turtles "circle"

  ;; Set up the turtles and their characteristics
  setup-turtles
  color-turtles
  setup-links
  color-links
  
  set globaltrust 0
  set danger 0
  ;find-all-components

  reset-ticks
end

to setup-turtles
  create-turtles 100
  ask turtles [ 
    setxy random-xcor random-ycor
    ]
           
  ask turtles [
    if random 4 < buttonCCC [ set breed boths ]
    if breed != boths and random 3 < buttonA [ set breed As ]
    if breed != boths and breed != As and random 3 < buttonB [ set breed Bs ]
    if breed != boths and breed != As and breed != Bs [ set breed nones ]
  ]
  
end

to setup-links
  ask turtles [ create-links-with other turtles ]
  ask links [
   set instcit 0
   set mutualtrust trustcontrol ;; Starting trust
    if (is-both? end1 = true) and (is-both? end2 = true) [set mutualtrust (mutualtrust + 30)]
    if (is-A? end1 = true) and (is-A? end2 = true) [set mutualtrust (mutualtrust + 20)]
    if (is-B? end1 = true) and (is-B? end2 = true) [set mutualtrust (mutualtrust + 20)]
    if (is-B? end1 = true) and (is-both? end2 = true) [set mutualtrust (mutualtrust + 20)]
    if (is-both? end1 = true) and (is-B? end2 = true) [set mutualtrust (mutualtrust + 20)]
    if (is-A? end1 = true) and (is-both? end2 = true) [set mutualtrust (mutualtrust + 20)]
    if (is-both? end1 = true) and (is-A? end2 = true) [set mutualtrust (mutualtrust + 20)]
    hide-link
]

end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Main Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to go
  
  ifelse supergameswitch = TRUE [
  set-supergame ]
  [set supergame 0]
  
  interact
  institutions
  if conflictswitch = TRUE [
  conflict ]
  groupsize
  tick
end

to set-supergame
  let numberturtles count turtles
  set supergame (gamesleft * 1 * (1 / numberturtles))
end

to interact
  
  carefully [
  
  ask turtles [
    
    fd 1
    
    let closelinks my-links with [link-length < 10]
    let dangerouslinks closelinks with [mutualtrust < 25]
    let coollinks closelinks with [mutualtrust >= 25]
    set closerturtlelink max-one-of coollinks [mutualtrust] ; the guy who he is most close to
    set gameturtlelink one-of coollinks
    set worstturtlelink min-one-of dangerouslinks [mutualtrust]
    
    if worstturtlelink != nobody [
    ifelse [who] of self != [who] of [end2] of worstturtlelink
    [set worstturtle [end2] of worstturtlelink]
    [set worstturtle [end1] of worstturtlelink]
    ]
    
    ifelse [who] of self != [who] of [end2] of closerturtlelink
    [set closerturtle [end2] of closerturtlelink]
    [set closerturtle [end1] of closerturtlelink]
    
    let x [xcor] of closerturtle
    let y [ycor] of closerturtle
    facexy x y
    fd 2
    
    if worstturtlelink != nobody [
    let xw [xcor] of worstturtle
    let yw [ycor] of worstturtle
    facexy xw yw
    bk 4
    ]
    
    if dangerswitch = TRUE [
    ifelse group != biggestgroup 
    [set danger -0.5 * (biggestgroup - group) ]
    [set danger 0]
    ]
  
    ask gameturtlelink [
      
     if mutualtrust > 100 [
    set mutualtrust 100 ]
    if mutualtrust < 0 [
     set mutualtrust 0 ]
    
    let trust1 (random-normal mutualtrust 10) / 100
    let trust2 (random-normal mutualtrust 10) / 100
      
    ifelse (1 - trust1) * danger + trust1 * 2 > (1 - trust1) * -2 + trust1 * (supergame + instcit) ; Payoffs from cooperating, FALSE is cooperate
    [ifelse (1 - trust2) * danger + trust2 * 2 < (1 - trust2) * -2 + trust2 * (supergame + instcit) ; both parties
      [set mutualtrust (mutualtrust - 0)
       set globaltrust (globaltrust - 0)] ; other party cooperates
      [set mutualtrust (mutualtrust - 10)
       set globaltrust (globaltrust - 10)]
      ] ; other party does not cooperate/robs
    [ifelse (1 - trust2) * danger + trust2 * 2 < (1 - trust2) * -2 + trust2 * (supergame + instcit) ; turtle cooperates
      [set mutualtrust (mutualtrust + 10)
        set globaltrust (globaltrust + 10)] ; other party cooperates
      [set mutualtrust (mutualtrust - 20)
       set globaltrust (globaltrust - 20) ] ; other party does not cooperate/robs
    ]
   
    
  ]
    
  ]
  ]
  [print "Error, I am alone!"]
  
end
  
to institutions
  ask links with [mutualtrust > 80] [
    show-link
    set instcit 0.5
    set linkgroup TRUE
    set turtle1 [end2] of self
    set turtle2 [end1] of self
    set tieturtles (turtle-set turtle1 turtle2)
    set color white
    set thickness 0.3
    
    ask turtle1 [
    let x [xcor] of turtle2
    let y [ycor] of turtle2
    facexy x y
    fd 2
    ]
    
    ask turtle2 [
    let x [xcor] of turtle1
    let y [ycor] of turtle1
    facexy x y
    ]

    ]
  
    ask links with [mutualtrust <= 80] [
    set instcit 0
    set color black
    set thickness 0.3
    set linkgroup FALSE
    hide-link
    ]
    
    ask links with [mutualtrust < 25] [
    set color red - 3
    set thickness 0.1
    hide-link
    ]
    
end
  
to groupsize
  ask turtles [
    set group count my-links with [linkgroup = TRUE] + 1
  ]
  set biggestgroup max [group] of turtles
end

to conflict
  ask turtles [
    let closeturtles turtles in-radius 4
    let dangerousturtle max-one-of closeturtles [group]
    if [group] of dangerousturtle > [group] of self [
      if [mutualtrust] of (link [who] of self [who] of dangerousturtle) < 25 [
      die
    ]
  ]
  ]
  end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Visualization Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; color links according to past experience
to color-turtles
  ask turtles[
    if (is-both? self = true) [set color brown]
    if (is-A? self = true) [set color blue]
    if (is-B? self = true) [set color red]
    if (is-none? self = true) [set color yellow]
  ]
end
  
  
to color-links  
    ask links[
      set thickness 0
      set color black]
end
  




; Copyright 2007 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
480
10
876
443
48
50
3.9802
1
10
1
1
1
0
1
1
1
-48
48
-50
50
1
1
1
ticks
30.0

BUTTON
11
22
137
77
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
292
21
457
78
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
191
304
328
349
NIL
biggestgroup
0
1
11

SLIDER
15
97
264
130
trustcontrol
trustcontrol
0
100
50
1
1
NIL
HORIZONTAL

PLOT
900
22
1212
154
Average trust of each relationship
NIL
NIL
0.0
1000.0
0.0
100.0
true
true
"" ""
PENS
"pen-1" 1.0 0 -5298144 true "" "plot mean [mutualtrust] of links"

MONITOR
33
303
149
348
NIL
count turtles
17
1
11

MONITOR
325
92
429
137
Institutional links
count links with [mutualtrust > 80]
17
1
11

BUTTON
159
21
272
78
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
275
144
473
189
NIL
count links with [mutualtrust < 25]
17
1
11

PLOT
903
186
1216
306
Won trust minus lost trust, cumulative
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot globaltrust"

MONITOR
366
301
448
346
NIL
supergame
17
1
11

SLIDER
16
146
264
179
gamesleft
gamesleft
0
1000
400
5
1
NIL
HORIZONTAL

SLIDER
178
199
313
232
buttonA
buttonA
0
4
0
1
1
NIL
HORIZONTAL

SLIDER
17
198
157
231
buttonB
buttonB
0
4
0
1
1
NIL
HORIZONTAL

SLIDER
336
198
468
231
buttonCCC
buttonCCC
0
4
0
1
1
NIL
HORIZONTAL

SWITCH
43
358
185
391
conflictswitch
conflictswitch
1
1
-1000

TEXTBOX
206
369
356
387
Switch killing on or off.
11
0.0
1

TEXTBOX
43
246
454
298
ButtonA and Button B control the probability that an agent will be a member of a particular ethnic group. ButtonCCC controls the probability that an agent has cross-cutting cleavages.
11
0.0
1

SWITCH
45
412
185
445
dangerswitch
dangerswitch
0
1
-1000

TEXTBOX
205
399
485
459
Switch agents calculating the 'danger' of not cooperating by looking at the difference between the size of their group of friends and the person with the greatest group of friends on or off.
11
0.0
1

SWITCH
43
468
187
501
supergameswitch
supergameswitch
0
1
-1000

TEXTBOX
204
476
521
495
Set if agents consider the supergame in their calculations.
11
0.0
1

@#$#@#$#@
## What is this?

A model of insitutional formation I made for Constitutional Design class at Leiden University College.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
set layout? false
setup repeat 175 [ go ]
repeat 35 [ layout ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
