extensions[array view2.5d ]


globals[recursive-length last-approval-mean total-number-of-votes winner progress total-loyal-votes accuracy total-number-of-voters total-number-of-parties done cabinet prime-minister disproportionality bayesian-regret highest-sat satisfaction-list cabinet-mean unique-cabinets  average-utility]
breed[voters voter]
breed[parties party]
voters-own[approval-cutoff age preference-array strategize  christian utility approval-colorer ballot education populist]
parties-own[name primary-party-color secundary-party-color frontrunner votes seats loyalty-seats actual-seats party-utility utility-seats]


to setup
  clear-all
  initialize-preset
  set progress 0
  set-current-directory path
  ask patches[set pcolor white]
  initialize-parties
  actual-election-plot
  create-population
  vote
  update-election-results
  if(display-median = true)
  [
    plot-left-right
    plot-progressive-conservative
  ]

  if (view3d = true)
  [
    display-3d

  ]

end
;the modelling commons really needs this for some reason
to go

end

to initialize-preset
  if (presets = "Most accurate plurality setting" )
  [
    set percent-strategizing 0.27
    set maximum-noise 0.4
    set christianity-percentage 0.1
    set nonchristians-likelihood-to-CDA 0.61
    set christians-likelihood-to-CDA 0.72
    set possibility-populist-high-education 0.08
    set possibility-populist-low-education 0.15
    set party-loyalty true
  ]
  if (presets = "Most accurate approval setting(based on assumption)")
  [
    set percent-strategizing 0.27
    set maximum-noise 0
    set christianity-percentage 0.1
    set nonchristians-likelihood-to-CDA 0.61
    set christians-likelihood-to-CDA 0.72
    set possibility-populist-high-education 0.08
    set possibility-populist-low-education 0.15
    set party-loyalty false
    set use-approval-mean true
  ]
  if (presets = "Clear 3D view (no noise)")
  [
    set view3d true
    set maximum-noise 0
  ]
  if (presets = "All display options on")
  [
    set overlay true
    set display-median true
    set view3d true
    set display-strategy-in-graph true
    set show-approval-ballots true
  ]

  if (presets = "All display options off")
  [
    set overlay false
    set display-median false
    set view3d false
    set display-strategy-in-graph false
    set show-approval-ballots false
  ]

end

to display-3d
  let temp-utility 0
  let temp-color 0
  ask voters with [approval-colorer = true]
  [
    if any? (voters-on patch-here) with [approval-colorer != true]
    [
      ask (voters-on patch-here) with [approval-colorer != true]
      [
        set temp-utility utility
        set temp-color color
      ]
    ]
    if( show-approval-ballots = false) [set color temp-color]
    set utility temp-utility
  ]
  view2.5d:turtle-view "3d-view-utility" voters [ the-voter -> [utility] of the-voter ]
  view2.5d:set-observer-distance "3d-view-utility" 40
  view2.5d:set-z-scale "3d-view-utility" 250
  view2.5d:set-observer-angles "3d-view-utility" 250 300
  view2.5d:set-turtle-stem-thickness "3d-view-utility" .001


  view2.5d:set-turtle-stem-color "3d-view-utility" [ 0 ]
end

to initialize-parties

  let party-values [[ "Volt" -5 88 113 9.9 0 54.2 0 3]["D66" -5 70 65 9.9 19 42.8 0 24]["Bij1" -100 85 0 46 0 54.2 0 1]["PVDD" -100 65 61 9.9 5 35 0 6]["50+" -20 -13 114 9.9 4 54.2 0 2]["SP" -100 40 15 9.9 14 46.2 0 9]["GL" -70 68 15 65 14 49.3 0 8]["PVdA" -65 50 15 9.9 9 53.5 0 9]["DENK" -70 40 86 9.9 3 54.2 0 3]["CU" -20 15 105 85 5 55.9 1 5]["CDA" 5 -25 65 9.9 19 46.6 0.5 15]["PVV" -15 -75  15 95 20 74.9 0 17]["SGP" 35 -48 25 9.9 3 73 1 3]["VVD" 55 -20 25 105 33 54.2 0 34]["JA21" 60 -57 102 14 0 54.2 0 3]["FVD" 70 -75 13 9.9 2 34.8 0 8]]
  let frontrunnerlist read-from-string frontrunners

  set total-number-of-parties length party-values
  let loyal-votes-last-round  n-values total-number-of-parties [0]
  let counter 0





  set counter 0
  foreach party-values
  [
    [current-party] ->
    create-parties 1
    [
      ;set x and y coordinates from the party values
      set xcor item 1 current-party * 2
      set ycor item 2 current-party * 2

      ;sets the party name, the primary party color and the secundary party color
      set name item 0 current-party
      set primary-party-color item 4 current-party
      set secundary-party-color item 3 current-party

      ;visualizes above settings on the map
      set color primary-party-color
      ask [neighbors] of patch-here [ set pcolor [secundary-party-color] of myself]
      set plabel name
      set plabel-color black

      set frontrunner false
      ;applies a frontrunner value if given by user
      if ( member? name read-from-string frontrunners)
      [
        set frontrunner true
        set plabel-color red
      ]
      set actual-seats item 8 current-party


      set loyalty-seats item 5 current-party * (item 6 current-party / 100)

      set total-loyal-votes total-loyal-votes + loyalty-seats

    ]
  ]

  ;set a coloring for smallest distance to party for each patch
  if (overlay = true)
  [
    ask patches with [pcolor = white]
    [
      let current-party min-one-of parties[distance myself]
      ifelse ([primary-party-color] of current-party = 9.9)
      [
        set pcolor [secundary-party-color] of current-party + 2.5
      ]
      [
        set pcolor [primary-party-color] of current-party + 2.5
      ]
    ]
  ]
  ;display axis
  ask patches with [pxcor = 0 or pycor = 0]
  [
    ifelse (overlay = true)
    [
      set pcolor white
    ]
    [
      set pcolor blue
    ]
  ]
end

to create-population

 ; as i can not upload files to commons, the if statement is leftover code. contact me if you want the complete zip file
  if(population = "random" )
  [
    create-voters number-random-voters
    [
      ; this makes sure that voters are distributed realistically, as left-conservative is rarer than left progressive,
      ; and right-progressive rarer than right conservative
      let left-right-diagonal random-float 1.0
      ifelse( left-right-diagonal >= 0.5)[set left-right-diagonal 1][set left-right-diagonal -1]
      set left-right-diagonal left-right-diagonal * (random-exponential  40)
      let gaussian-x random-normal left-right-diagonal 50
      let gaussian-y random-normal (-1 * left-right-diagonal) 50
      if(gaussian-x > 220)[set gaussian-x 220]
      if(gaussian-x < -220)[set gaussian-x -220]
      if(gaussian-y > 220)[set gaussian-y 220]
      if(gaussian-y < -220)[set gaussian-y -220]
      setxy (gaussian-x) (gaussian-y)

      ;set education here according to distribution of educated voters
      ifelse ( random-float 1 < 0.629 )
      [
        set education 1
        ifelse( random-float 1 < possibility-populist-low-education )
        [
          set populist true
        ]
        [
          set populist false
        ]
      ]
      [
        set education 2
        ifelse( random-float 1 < possibility-populist-high-education )
          [
            set populist true
        ]
        [
          set populist false
        ]
      ]
      set age random 7
      create-preference-ballot
      set color grey
      set ballot (list 0 )
    ]
  ]
  ;;
  ask voters
  [
    set approval-cutoff random-normal approval-mean approval-SD
    set total-number-of-voters total-number-of-voters + 1

    if approval-cutoff < 0
    [
      set  approval-cutoff 0
    ]
    if approval-cutoff > 1
    [
      set  approval-cutoff 1
    ]
  ]

end

to vote
  let totalballotcounter 0
  ask voters
  [
    ifelse(voting-method = "plurality")
    [

      ifelse(strategize = true)
      [
        plurality-strategize
      ]
      [
        plurality
      ]
      set progress  (progress + (1 / total-number-of-votes) * 100)
    ]
    [

      ifelse(strategize = true)
      [
        approval-strategize
      ]
      [

        approval
      ]
      ;set total-number-of-votes total-number-of-votes + ballotsize
      set  progress (progress + (1 /  total-number-of-voters) * 100)
      if item 0 ballot = 0
      [
        set ballot remove-item 0 ballot
      ]
      let size-counter length ballot

      set total-number-of-votes total-number-of-votes + length ballot
      ifelse (show-approval-ballots = true)
      [
        foreach ballot
        [
          current-party ->
          hatch 1
          [


            set approval-colorer true
            set size size-counter
            set color [secundary-party-color] of current-party
          ]
          set shape "circle"
        set size-counter size-counter - 1
        ]
      ]
      [

        set color item 0 [secundary-party-color] of parties with [name = [name] of item 0 [ballot] of myself]
        set size length ballot
      ]
    ]
  ]
    set average-utility approval-mean

end
to plurality-strategize
  let i 0
  repeat total-number-of-parties [
    let current-prefered-array array:item preference-array i
    let current-party array:item current-prefered-array 0
    let current-weight array:item current-prefered-array 1
    if([frontrunner] of current-party = true)
    [
      set ballot lput current-party ballot
      ask current-party [ set votes votes + 1]
      set color [secundary-party-color] of current-party - 2.5
      set shape "square"
      stop
    ]
    set i i + 1
  ]


end

to plurality
  let most-prefered-array array:item preference-array 0
  let most-prefered-party array:item most-prefered-array 0
  ask  most-prefered-party  [set votes votes + 1]
  set color lput 200 extract-rgb [secundary-party-color] of most-prefered-party
  set ballot lput most-prefered-party ballot
end

to approval

  let i 0

  if(use-approval-mean = true)
  [
    get-approval-mean
  ]
  repeat total-number-of-parties [
    let current-pref array:item preference-array i
    let current-party array:item current-pref 0
    let current-weight array:item current-pref 1
    if(current-weight >= approval-cutoff)
    [
      ask current-party [ set votes votes + 1]
      set size size - 1
      ifelse ( item 0 ballot  = 0)
      [
        set shape "circle"
        set size 1
        set ballot (list current-party)
      ]
      [
        set ballot lput current-party ballot
      ]

    ]

    set i i + 1
  ]
end

to approval-strategize
  let i 0
  let first-frontrunner true

  if(use-approval-mean = true)
  [
    get-approval-mean
  ]
  repeat total-number-of-parties [
    let current-pref array:item preference-array i
    let current-party array:item current-pref 0
    let current-weight array:item current-pref 1
    if(current-weight >= approval-cutoff)
    [
      ifelse([frontrunner] of current-party = true)
      [
        if(first-frontrunner = true )
        [
          ask current-party [ set votes votes + 1]
          set color [secundary-party-color] of current-party - 2.5
          set shape "circle"
          ifelse ( item 0 ballot  = 0)
          [
            set shape "circle"
            set size 1
            set ballot (list current-party)
          ]
          [
            set ballot lput current-party ballot
          ]
        ]
      ]
      [
        ask current-party [ set votes votes + 1]
        ifelse ( item 0 ballot  = 0)
        [
          set shape "circle"
          set size 1
          set ballot (list current-party)
        ]
        [
          set ballot lput current-party ballot
        ]
      ]
    ]
    set i i + 1
  ]
end

to get-approval-mean
  set approval-cutoff 0
  let i 0
  repeat total-number-of-parties
  [
    let current-pref array:item preference-array i
    let current-weight array:item current-pref 1
    set approval-cutoff approval-cutoff + current-weight
    set i i + 1
  ]
  set approval-cutoff approval-cutoff / total-number-of-parties
end


;alters preferences based on the current agents. this is somewhat based on assumptions and some truth. In reality, age, christianity and education are all correlated, so it is hard to draw conclusions.
;most of this was based on the kieskompas dataset and studies by Ipsos for NOS.
;some conclusions of factors are drawn by the accuracy they give, tested on 1000 elections each.
to apply-values
  ; this method finds parties given certain parameters of users, and adjusts those to new values
  let index 0
  foreach array:to-list preference-array
  [
    preference ->
    let current-weight array:item preference 1
    let current-party array:item preference 0
    if([name] of current-party = "50+")
    [
      if(age <= 5 or education = 2)
      [
        set current-weight current-weight / 5
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
    ]
    ifelse(populist = true)
    [
      ifelse( member? [name] of current-party Populists)
      [
        set current-weight current-weight * 5 / 2
      ]
      [
        set current-weight current-weight / 3 * 2

      ]
      array:set preference-array index array:from-list (list current-party current-weight)
    ]
    [
      ifelse( member? [name] of current-party Populists)
      [
        set current-weight current-weight / 3 * 2
      ]
      [
        set current-weight current-weight * 3 / 2
      ]
      array:set preference-array index array:from-list (list current-party current-weight)
    ]
    ifelse(christian = true)
    [
      ;CDA has always been more of a mainline party, therefore it has a smaller christian following than other christian parties
      if([name] of current-party = "CDA")
      [
        set current-weight current-weight / christians-likelihood-to-CDA
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
      if([name] of current-party = "CU")
      [
        set current-weight current-weight * ( 3 / 2 )
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
      if([name] of current-party = "SGP")
      [
        set current-weight current-weight * (3 / 2)
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
    ]
    [
      ;CDA has always been more of a mainline party, therefore it has a bigger non-christian following than other christian parties (ie. not that hard on abortion or same sex marriage)
      if([name] of current-party = "CDA")
      [
        set current-weight (current-weight * nonchristians-likelihood-to-CDA)
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
      if([name] of current-party = "CU")
      [
        set current-weight (current-weight / 3)
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
      if([name] of current-party = "SGP")
      [
        set current-weight (current-weight / 3)
        array:set preference-array index array:from-list (list current-party current-weight)
      ]
    ]
    set index index + 1
  ]
end

to reorganize-array
  ; a bubblesort on all the parties and their weights after redistribution
  let i 0
  let j 0
  let array-as-list array:to-list preference-array
  repeat total-number-of-parties - 1
  [
    set array-as-list array:to-list preference-array

    set j 0
    let i-array array:to-list item i array-as-list
    let iw item 1 i-array
    let ip item 0 i-array
    repeat total-number-of-parties - 1 - i
    [
      let j-array array:to-list item j array-as-list
      let jw item 1 j-array
      let jp item 0 j-array
      let j+1-array array:to-list item (j + 1 ) array-as-list
      let jw+1 item 1 j+1-array
      let jp+1 item 0 j+1-array
      if(jw < jw+1)
      [
        set j-array array:from-list(list jp+1 jw+1)
        set j+1-array array:from-list(list jp jw)
        set array-as-list replace-item (j + 1 ) array-as-list j+1-array
        set array-as-list replace-item (j ) array-as-list j-array
        set preference-array array:from-list array-as-list
      ]
      set j j + 1
    ]
    set i i + 1
  ]
end

to create-preference-ballot
  ;initializes (biblebelt) christians
  if(random-float 1 < christianity-percentage)[set christian true]

  ;randomly assigns strategizing voters
  ifelse( random-float 1 < percent-strategizing) [set strategize true][set strategize false]

  ;determine closest and furthest parties for distance estimations
  let closest-party min-one-of parties [distance myself]
  let furthest-party max-one-of parties [distance myself]

  ; makes a nested array in the form of a[1] is most preferred party and its array.
  ; a[1][0] is the party, and a[1][1] is the weight, ie the normalized distance to a party, in which 1 is closest and 0 is furthest.
  set preference-array array:from-list n-values total-number-of-parties [0]

  ;indexer
  let i 0

  ;go through each party on distance to myself and put them in a preference array
  foreach sort-on [distance myself] parties
  [
    current-party ->
    ;calculates the maximum spread between all parties
    let max-distance   [distance myself] of furthest-party  -  [distance myself] of closest-party
    ;initialize an array for the party, to be put in the larger array
    let preference array:from-list n-values 2 [0]

    ;set first index of array to the current party
    array:set preference 0 current-party

    ; makes random noise, this will give every party distance some randomness. this is true to real life as kieskompas is an approximation, and not everyone actually chooses the closest option
    let noise random-float maximum-noise
    ifelse( random-float 1 < 0.5 )[set noise 1 - noise][set noise 1 + noise]

    ;this way, all parties have a preference from 0 (least approved) to 1 ( most approved)
    let weight 1 - ( 1 / max-distance ) * ([distance myself] of current-party - [distance myself] of closest-party)
    set weight weight * noise

    ;store the weight in the preference
    array:set preference 1 weight
    ;add that preference to this voters preference array for all parties
    array:set preference-array i preference

    set i i + 1
  ]

  ;the following functions are needed to reorganize the arrays according to preferences,
  ;    and prepare those for the voting algorithms
  ;checks if (very) christian or the age is to young to vote for 50+ etc, and reshuffles the array
  apply-values

  set shape "circle"
  set size 7

  ; sorts the array to have highest scoring first and least last via bubble-sort
  reorganize-array

  ;renormalizes array
  let first-party true
  let index 0
  let highest-weight 0
  foreach array:to-list preference-array
  [
    preference ->
    let current-weight array:item preference 1
    let current-party array:item preference 0
    if first-party = true
    [
      set highest-weight current-weight
      set first-party false
    ]
    set current-weight current-weight / highest-weight
    array:set preference-array index array:from-list (list current-party current-weight)

    set index index + 1
  ]

  ; we need to count the votes correctly for the calculation of seats in government
  if(voting-method != "approval")
  [
    set total-number-of-votes total-number-of-votes + 1
  ]

end

to form-cabinet

  let cabinet-seats 0
  set prime-minister ""
  set cabinet n-values 0 [0]
  foreach sort-by [[?1 ?2] -> [seats] of ?1 >[seats] of ?2] parties
  [
    current-party ->
    if(cabinet-seats < 75 )
    [

      if prime-minister = ""
      [
        set prime-minister [name] of current-party
      ]
      set cabinet-seats cabinet-seats + [seats] of current-party
      set cabinet lput [name] of current-party cabinet
    ]
  ]
  set cabinet-mean cabinet-seats / length cabinet
  initialize-satisfactions
end

to update-election-results
  set-current-plot "Election results"
  clear-plot
  set-plot-x-range 0 count parties
  let kiesdeler total-number-of-votes / 150
  let highest-vote 0
  let i 0
  let seatcounter 0
  if(party-loyalty = true)
  [
    set kiesdeler total-number-of-votes / (150 - total-loyal-votes )
  ]
  let total-seats-wrong 0
  foreach sort-on[name] parties
  [
    current-party ->
    ask current-party
    [
      ifelse(party-loyalty = false)
      [
        set seats round(votes / kiesdeler)
        set seatcounter seatcounter + seats
      ]
      [
        set seats round(votes / kiesdeler + loyalty-seats)
        set seatcounter seatcounter + seats
      ]
      set total-seats-wrong total-seats-wrong + sqrt((seats  - [actual-seats] of current-party  ) ^ 2)

    ]
    if( [seats] of current-party > highest-vote)
    [
      set highest-vote [seats] of current-party
      set winner [name] of current-party
    ]
    ;output-type [name] of current-party output-type ": " output-type [seats] of current-party output-type " actual seats:" output-print[actual-seats] of current-party
    create-temporary-plot-pen [name] of current-party
    set-plot-pen-mode 1 ; bar mode
    set-plot-pen-color [secundary-party-color] of current-party
    foreach (range 0 [seats] of current-party 0.05) [ _y -> plotxy i _y ]
    set-plot-pen-color black
    plotxy i [seats] of current-party
    set-plot-pen-color [secundary-party-color] of current-party ; to get the right color in the legend
    set i i + 1


  ]

  set accuracy (150 - total-seats-wrong) / 150
  form-cabinet
end

to actual-election-plot
  set-current-plot "Actual results"
  clear-plot
  set-plot-x-range 0 count parties
  let i 0


  foreach sort-on[name] parties
  [
    current-party ->
    ask current-party
    [

      set seats actual-seats


    ]
    create-temporary-plot-pen [name] of current-party
    set-plot-pen-mode 1 ; bar mode
    set-plot-pen-color [secundary-party-color] of current-party
    foreach (range 0 [seats] of current-party 0.05) [ _y -> plotxy i _y ]
    set-plot-pen-color black
    plotxy i [seats] of current-party
    set-plot-pen-color [secundary-party-color] of current-party ; to get the right color in the legend
    set i i + 1


  ]

end
to plot-left-right
  let current-xcor -220
  set-current-plot "Voter population on Left Right axis"
  clear-plot
  set-plot-pen-mode 2

  if (voting-method = "approval")
  [
    auto-plot-on
  ]
  set-current-plot-pen "voters"
  let current-party-number 0
  let counter 0
  let highest-voter-slice 0
  let highest-xcor 0
  repeat 440
  [
    set current-party-number 0
    set counter 0
    let voters-in-slice count voters with [ xcor >= current-xcor - 5 and xcor < current-xcor + 5 and approval-colorer != true]
    if voters-in-slice > highest-voter-slice
    [
      set highest-voter-slice voters-in-slice
      set highest-xcor current-xcor
    ]
    repeat total-number-of-parties
    [
      ask voters with [ xcor >= current-xcor - 5 and xcor < current-xcor + 5 and member? party current-party-number ballot = true and approval-colorer != true]
      [
        ifelse strategize = true and display-strategy-in-graph = true
        [
          set-plot-pen-color [primary-party-color] of party current-party-number

        ]
        [

          set-plot-pen-color [secundary-party-color] of party current-party-number

        ]
        ifelse voting-method = "approval"
        [
          set counter (counter + (1 * (voters-in-slice / total-number-of-voters) ) )
        ]
        [
          set counter counter + 1
        ]

        plotxy current-xcor counter
      ]
      set current-party-number current-party-number + 1
    ]
    set current-xcor current-xcor + 1
  ]
  if(display-median = true)
  [
    ask patches with [pxcor = highest-xcor][set pcolor black]
  ]
end


to plot-progressive-conservative
  let current-ycor -220
  set-current-plot "Voter population on Progressive Conservative axis"
  clear-plot
  set-plot-pen-mode 2
  if (voting-method = "approval")
  [
    auto-plot-on
  ]
  set-current-plot-pen "voters"
  let current-party-number 0
  let counter 0
  let highest-voter-slice 0
  let highest-ycor 0
  repeat 440
  [
    set current-party-number 0
    set counter 0
    let voters-in-slice count voters with [ ycor >= current-ycor - 5 and ycor < current-ycor + 5 and approval-colorer != true]
    if voters-in-slice > highest-voter-slice
    [
      set highest-voter-slice voters-in-slice
      set highest-ycor current-ycor
    ]
    repeat total-number-of-parties
    [
      ask voters with [ ycor >= current-ycor - 5 and ycor < current-ycor + 5 and  member? party current-party-number ballot = true and approval-colorer != true]
      [
        ifelse strategize = true and display-strategy-in-graph = true
        [
          set-plot-pen-color [primary-party-color] of party current-party-number

        ]
        [

          set-plot-pen-color [secundary-party-color] of party current-party-number

        ]
        ifelse voting-method = "approval"
        [
          set counter (counter + (1 * (voters-in-slice / total-number-of-voters) ) )
        ]
        [
          set counter counter + 1
        ]
        plotxy  counter current-ycor

      ]
      set current-party-number current-party-number + 1
    ]
    set current-ycor current-ycor + 1

  ]
  if (display-median = true)
  [
    ask patches with [pycor = highest-ycor][set pcolor black]
  ]
end

; Please note utility and weights can be used interchangably
to initialize-satisfactions
  calculate-bayesian-regret
  calculate-proportionality
end

; bayesian-regret measures the population satisfaction with the cabinet.
; bayesian regret does not measure from votes, only by the given weights/ utilities of the voter. it can be seen as the voters feeling of "being listened to" by the democratic system
; it is adjusted for proportionality by looking at party seats, as a voter might be unhappy that his preffered candidate only got 50% of the votes that the actual winner got.
to calculate-bayesian-regret
  let achieved-societal-utility 0
  let winner-seats item 0 [seats] of parties with [name = winner]
  ask voters
  [
    ;this is because of coloring with approval voting, which was kind of buggy due to Netlogo's insufficiencies
    if( approval-colorer != true)
    [

      let utility-winner 0
      foreach array:to-list preference-array
      [
        current-party-array ->
        let current-party array:item current-party-array 0
        ; we add 0.5 to the weight, because parties below 0.5 are disliked and above are liked, we can now measure that in [0.5 -> 1.5] which makes the weights more expressive when multiplied with seats.
        let current-weight (array:item current-party-array 1 + 0.5)  * ([seats] of current-party / winner-seats)
        if(member? [name] of current-party cabinet)
        [
          set utility utility + current-weight
        ]
      ]
      ;; utility is also a agent variable needed for 3D-view
      set utility utility / length cabinet
      set achieved-societal-utility achieved-societal-utility + utility
    ]
  ]
  set bayesian-regret (achieved-societal-utility / total-number-of-voters) - 0.5
end


to calculate-proportionality
  ask voters
  [
    ;first, we calculate the total ammount of utility for each party
    if( approval-colorer != true)[
      foreach array:to-list preference-array
      [
        current-party-array ->
        let current-party array:item current-party-array 0
        let current-weight array:item current-party-array 1
        ask current-party
        [
          set  party-utility  party-utility + current-weight
        ]
      ]
    ]
  ]
  ;then we divide those, so we have a good measure of population broad utility per party
  ;also, we add all those party utilities up to get a total utility which we can use later
  let total-utility 0
  ask parties
  [
    set party-utility precision (party-utility / total-number-of-voters) 2
    set total-utility total-utility + party-utility
  ]
  ; as total utility will have to be divided among 150 seats, we can calculate how much seats a utility of 1 can buy
  let seats-per-utility 150 / total-utility


  let total-dif 0
  foreach sort-on[party-utility ] parties
  [
    current-party ->
    ask current-party
    [
      ;utility seats is the actual average voters desired amount of seats for that party
      set utility-seats precision (seats-per-utility * party-utility ) 2
      ;then we calculate how much distance the utility seats are from the actual seats given, and add those up.
      ;this gives us the disproportionality between utility and actual votes.
      set total-dif total-dif + (sqrt((seats - utility-seats) ^ 2) / (seats ^ 2 + utility-seats)^ 2)
    ]
  ]
  ;finally, we can set disproportionality, and output it to the model
  set disproportionality total-dif
end
@#$#@#$#@
GRAPHICS-WINDOW
370
130
919
680
-1
-1
1.227
1
10
1
1
1
0
0
0
1
-220
220
-220
220
0
0
1
ticks
30.0

BUTTON
0
70
347
132
NIL
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
0
210
120
243
overlay
overlay
0
1
-1000

INPUTBOX
0
325
186
386
frontrunners
[\"VVD\" \"D66\"  ]
1
1
String

CHOOSER
0
245
185
290
voting-method
voting-method
"plurality" "approval"
0

SLIDER
0
385
185
418
percent-strategizing
percent-strategizing
0
1
0.27
0.01
1
NIL
HORIZONTAL

MONITOR
230
680
345
725
NIL
winner
17
1
11

PLOT
345
680
631
980
Election results
NIL
NIL
0.0
10.0
0.0
45.0
true
true
"" ""
PENS

MONITOR
0
680
110
725
NIL
progress
2
1
11

SWITCH
0
523
370
556
party-loyalty
party-loyalty
1
1
-1000

SLIDER
0
455
370
488
christianity-percentage
christianity-percentage
0
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
0
420
185
453
maximum-noise
maximum-noise
0
1
0.0
0.01
1
NIL
HORIZONTAL

CHOOSER
186
245
371
290
population
population
"random"
0

SLIDER
0
290
370
323
number-random-voters
number-random-voters
0
5000
1500.0
250
1
NIL
HORIZONTAL

MONITOR
110
680
230
725
NIL
accuracy
2
1
11

PLOT
630
680
920
980
Actual results
NIL
NIL
0.0
10.0
0.0
45.0
false
true
"" ""
PENS

TEXTBOX
10
251
160
269
NIL
11
0.0
1

TEXTBOX
0
559
150
577
Approval specific settings
11
0.0
1

PLOT
345
10
920
130
Voter population on Left Right axis
NIL
NIL
-220.0
220.0
120.0
0.0
true
false
"" ""
PENS
"voters" 3.0 0 -16777216 true "" ""

PLOT
920
110
1080
680
Voter population on Progressive Conservative axis
NIL
NIL
0.0
46.0
-220.0
220.0
true
false
"" ""
PENS
"voters" 1.0 0 -16777216 false "" ""

OUTPUT
920
680
1115
980
13

SWITCH
0
175
370
208
display-strategy-in-graph
display-strategy-in-graph
0
1
-1000

INPUTBOX
186
325
371
385
Populists
[\"FVD\" \"PVV\" \"SP\" \"JA21\" \"DENK\"]
1
0
String

SLIDER
186
385
371
418
possibility-populist-high-education
possibility-populist-high-education
0
1
0.08
0.01
1
NIL
HORIZONTAL

SLIDER
186
420
371
453
possibility-populist-low-education
possibility-populist-low-education
0
1
0.15
0.01
1
NIL
HORIZONTAL

SLIDER
185
491
371
524
christians-likelihood-to-CDA
christians-likelihood-to-CDA
0
1
0.72
0.01
1
NIL
HORIZONTAL

SLIDER
0
491
186
524
nonchristians-likelihood-to-CDA
nonchristians-likelihood-to-CDA
0
1
0.61
0.01
1
NIL
HORIZONTAL

SWITCH
121
210
251
243
display-median
display-median
0
1
-1000

SWITCH
251
210
371
243
view3d
view3d
0
1
-1000

MONITOR
0
725
345
770
NIL
cabinet
17
1
11

MONITOR
0
770
165
815
NIL
bayesian-regret
2
1
11

MONITOR
165
770
345
815
NIL
disproportionality
2
1
11

SLIDER
0
643
180
676
approval-mean
approval-mean
0.5
1
1.0
0.01
1
NIL
HORIZONTAL

SLIDER
180
643
370
676
approval-SD
approval-SD
0
1
0.0
0.001
1
NIL
HORIZONTAL

SWITCH
0
609
370
642
use-approval-mean
use-approval-mean
0
1
-1000

TEXTBOX
610
135
675
153
Progressive
11
0.0
0

TEXTBOX
375
395
400
413
Left
11
0.0
0

TEXTBOX
885
395
915
413
Right
11
0.0
0

TEXTBOX
605
655
680
673
Conservative
11
0.0
0

SWITCH
0
573
370
606
show-approval-ballots
show-approval-ballots
0
1
-1000

TEXTBOX
5
820
95
876
bayesian regret\nfrom 0 to 1\n1 is best\n0 is worst
11
0.0
1

TEXTBOX
165
820
315
876
disporportionality\nfrom 0 to 1\n0 is best\n1 is worst
11
0.0
1

CHOOSER
0
130
370
175
presets
presets
"Custom" "Most accurate plurality setting" "Most accurate approval setting(based on assumption)" "Clear 3D view (no noise)" "All display options on" "All display options off"
4

INPUTBOX
0
12
346
72
path
NIL
1
0
String

@#$#@#$#@
MAX OUT TICKS, IT MAKES THIS MODEL FASTER, AND AS IT IS NOT BASED ON STEPS IT DOES NOT AFFECT ANYTHING!!!
## WHAT IS IT?

This is a model explaining the benefits of approval voting versus (proportional) plurality voting. It aims to show that current voting systems are lacking and need improvement to ensure fairness. In plurality, a voter can use a single vote, which isn't quite as expressive and leads to insincere strategic voting. In approval voting, a voter can vote for as much parties as they want, which still enables strategical voting, but this time sincere.

Here is an easy example of plurality vs. approval. Suppose a group of friends want to decide on what to eat tonight. Suppose you have the options of burgers, moroccan, italian, sushi or mexican.

![Example](file:food-example.png)

In plurality, all the options would be mentioned, and they can all raise their hands only once for one option. Burgers would have the most votes, as marc and jeffrey both have burgers as their favourite. We can already see this is unfair, because jannete and mike hate and dislike burgers respectively (this is the sincere vote, notice that Jannete and Mike could work together to get italian by strategic voting).

In approval, they can vote for as many as they would like. suppose they all vote for those options they are neutral to or better. they can raise their hands for each option they would approve of. Then Italian food would win, as all members of the group would like or be neutral to italian. 

Thus, approval voting is fairer than plurality, which is what this model aims to show via a political spectrum map of a significant group of dutch voters. The model is as accurate as the exitpolls in 2021 on its best settings.

## HOW IT WORKS

Every voter is assigned a utility / weights distribution over all parties, mostly based on proximity to that party. However, those weights can be rebalanced as they may have other priorities at play. For instance, their age may cause them to vote for the elderly party 50+. Or they may want to vote strategically, which can cause their vote to change, or they are populists. The model than holds an election via either the plurality rule or the approval rule, and a winner is chosen. then that winner chooses a cabinet, and we trace the satisfaction of the voter for that cabinet.

## THINGS TO NOTICE

If you click on 3d view, you can see the utility of each voter. Noise messes up the weights a bit, because a voter can be misinformed on parties. if you set noise to 0 however, you can notice a convex function in 3d. the closer its peak is to the median, the better the voting system approximates the best winner, as this would mean that the highest number of voters are satisfied with the outcome.

## THINGS TO TRY

use the presettings for accurate outcomes, but you can also change everything you would like. if you want, you could set strategic voting higher, and see how both systems handle strategic voters. in plurality, this often converges to a two party system, not dissimilar to that of the USA.

## EXTENDING THE MODEL

More voting methods would be really nice.

## NETLOGO FEATURES

The approval ballot visualizations are a nightmare, and have been created by generating more voters on top of the original one. this is because netlogo cant add multiple colors to turtles.

## RELATED MODELS

As far as I know, none

## CREDITS AND REFERENCES
Made by Teun de Bilde for his AI bachelor thesis
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="approval-voting all cutoffs" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <metric>simple-satisfaction</metric>
    <metric>complicated-satisfaction</metric>
    <steppedValueSet variable="approval-mean" first="0.1" step="0.1" last="1"/>
  </experiment>
  <experiment name="christian values smaller" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <steppedValueSet variable="aversion-to-CDA" first="0.01" step="0.1" last="1"/>
    <steppedValueSet variable="christian-CDA" first="0.01" step="0.1" last="1"/>
    <steppedValueSet variable="christianity-percentage" first="0.01" step="0.01" last="0.1"/>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="percent-strategizing">
      <value value="0.22"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maximum-noise">
      <value value="0.57"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="possibility-populist-high-education">
      <value value="0.09"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="possibility-populist-low-education">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="approval-cut-off">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Populists">
      <value value="&quot;[\&quot;FVD\&quot; \&quot;PVV\&quot; \&quot;SP\&quot; \&quot;JA21\&quot;]&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="christianity-percentage">
      <value value="0.11"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="strategizing and noise detailed" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <steppedValueSet variable="percent-strategizing" first="0.01" step="0.05" last="0.31"/>
    <steppedValueSet variable="maximum-noise" first="0.51" step="0.05" last="1"/>
  </experiment>
  <experiment name="strategizing and noise broad" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <steppedValueSet variable="percent-strategizing" first="0.01" step="0.1" last="1"/>
    <steppedValueSet variable="maximum-noise" first="0.01" step="0.1" last="1"/>
  </experiment>
  <experiment name="all values broad" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <steppedValueSet variable="aversion-to-CDA" first="0.51" step="0.1" last="0.61"/>
    <steppedValueSet variable="christian-CDA" first="0.41" step="0.05" last="0.81"/>
    <steppedValueSet variable="christianity-percentage" first="0.07" step="0.01" last="0.1"/>
    <steppedValueSet variable="percent-strategizing" first="0.21" step="0.05" last="0.31"/>
    <steppedValueSet variable="maximum-noise" first="0.66" step="0.05" last="0.96"/>
  </experiment>
  <experiment name="all values broad random" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>accuracy</metric>
    <steppedValueSet variable="aversion-to-CDA" first="0.51" step="0.1" last="0.61"/>
    <steppedValueSet variable="christian-CDA" first="0.41" step="0.05" last="0.81"/>
    <steppedValueSet variable="christianity-percentage" first="0.07" step="0.01" last="0.1"/>
    <steppedValueSet variable="percent-strategizing" first="0.21" step="0.05" last="0.31"/>
    <steppedValueSet variable="maximum-noise" first="0.66" step="0.05" last="0.96"/>
  </experiment>
  <experiment name="experiment" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
  </experiment>
  <experiment name="satisfaction plurality" repetitions="1000" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
  </experiment>
  <experiment name="satisfaction approval" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <steppedValueSet variable="approval-cut-off" first="0.1" step="0.1" last="1"/>
  </experiment>
  <experiment name="satisfaction approval2" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <steppedValueSet variable="approval-cut-off" first="0.1" step="0.1" last="1"/>
  </experiment>
  <experiment name="satisfaction approval3" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <steppedValueSet variable="approval-cut-off" first="0.1" step="0.1" last="1"/>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="display-strategy-in-graph">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="overlay">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="approval-SD">
      <value value="0.173"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="&quot;kieskompas&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="voting-method">
      <value value="&quot;approval&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-random-voters">
      <value value="1250"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="nonchristians-likelihood-to-CDA">
      <value value="0.61"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="path">
      <value value="&quot;/Users/teundebilde/Desktop/scriptie/netlogofiles&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="christians-likelihood-to-CDA">
      <value value="0.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="display-median">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-strategizing">
      <value value="0.27"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="view3d">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maximum-noise">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="party-loyalty">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="frontrunners">
      <value value="&quot;[\&quot;VVD\&quot; \&quot;D66\&quot;  ]&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="approval-mean">
      <value value="0.69"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="possibility-populist-low-education">
      <value value="0.15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="approval-cut-off">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Populists">
      <value value="&quot;[\&quot;FVD\&quot; \&quot;PVV\&quot; \&quot;SP\&quot; \&quot;JA21\&quot;]&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="christianity-percentage">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="possibility-populist-high-education">
      <value value="0.09"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="satisfaction cutoffs" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <steppedValueSet variable="approval-mean" first="0.1" step="0.1" last="1"/>
    <steppedValueSet variable="approval-SD" first="0.1" step="0.1" last="1"/>
  </experiment>
  <experiment name="Plurality numbers" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <metric>accuracy</metric>
    <steppedValueSet variable="maximum-noise" first="0" step="0.1" last="0.9"/>
  </experiment>
  <experiment name="satisfaction approval and plurality" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>complicated-satisfaction</metric>
    <metric>simple-satisfaction</metric>
    <metric>accuracy</metric>
    <steppedValueSet variable="approval-mean" first="0" step="0.1" last="1"/>
  </experiment>
  <experiment name="satisfaction approval and plurality" repetitions="500" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>bayesian-regret</metric>
    <metric>disproportionality</metric>
    <metric>accuracy</metric>
    <enumeratedValueSet variable="voting-method">
      <value value="&quot;approval&quot;"/>
      <value value="&quot;plurality&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="party-loyalty">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="satisfaction approval and plurality kieskompas" repetitions="500" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>setup</go>
    <timeLimit steps="1"/>
    <exitCondition>done = true</exitCondition>
    <metric>bayesian-regret</metric>
    <metric>disproportionality</metric>
    <metric>accuracy</metric>
    <enumeratedValueSet variable="voting-method">
      <value value="&quot;approval&quot;"/>
      <value value="&quot;plurality&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="party-loyalty">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
