globals[
  proportion-extremists
  distribution-extremists
  change?
  prev-op
  initial-profile
  ]


breed [agents agent]
breed [points point]  ;; the points are used for visualisation only and don't affect the model's dynamics


agents-own[
  op            ;; a list that holds the opinions of the agent 
  extremist?    ;; a binary value that is set true if the agent's opinion is in the extremism-range
  ]

to setup 
  clear-all
  reset-ticks
  create-agents num-agents [
    set op (list) 
    repeat num-ops [set op lput (random-float 2 - 1) op]
    set hidden? true
    ifelse (abs (item 0 op) > 1 - extremism-range) [set extremist? true][set extremist? false]       
    ]
  
  visualise
  extremism-makro
  mk-initProfile
  set prev-op map [precision ? 2] reduce sentence map  [[op] of ?] sort agents ;; this is important for the change-occured? reporter
  set change? true
end

to go
  repeat num-agents * num-ops[ ask one-of agents [update-opinion]]
  if ( visuals) [visualise]
  extremism-makro
  tick 
end

to update-opinion
  ;;turtle procedure
  ;;makes the agents change their opinion values
  
  let i random num-ops
  let B one-of other agents
  let B-op [op] of B
  let AB attraction B-op
  

  if (AB )[
    if (opinion-change = "both change half")[
      let new-op (item i op + item i B-op) / 2
      
      if (not(extremist? and i = 0) )[
          set op replace-item i op (new-op)  
          if (abs (item 0 op) > 1 - extremism-range) [set extremist? true]
          ]
      
      ask B [
        if (not(extremist? and i = 0) )[
          set op replace-item i op (new-op)  
          if (abs (item 0 op) > 1 - extremism-range) [set extremist? true]
          ]
        ]
      ]

    if (opinion-change = "one changes complete")[
      if (not(extremist? and i = 0) )[
          set op replace-item i op (item i B-op)  
          if (abs (item 0 op) > 1 - extremism-range) [set extremist? true]
          ]
      ]
    
  ]  
    
  
end

to-report attraction [liste]
  ;; this reporter calculates the attraction between two agents based on the 
  ;; average of the differences between their opinions in all opinion-dimensions 
 
  
  let i 0
  let erg 0
  repeat num-ops [
    set erg erg + abs(item i op - item i liste)   
    set i i + 1
    ]
  report erg / num-ops < eps
end



to visualise
  ;; creates the visualisation in the world window. For every opinion of every agent 
  ;; a point is created and set to x coordinates of the world. the different dimensions are stacked to the y axis 
  
  ask points [die]
  foreach sort agents[
    let i 0
    let prev 0 
     create-points num-ops
    [
      set color 125
      set shape "dot"
      if (prev != 0)[create-link-with prev]
      setxy ([item i op] of ? * 9)  ((num-ops - i - 0.5) / num-ops) * max-pycor   
      set i i + 1 
      set prev self]
    
    ]
  
end


to extremism-makro
;;calculates the output of the monitors in the interface tab
set proportion-extremists count agents with [extremist?] / num-agents 
ifelse (proportion-extremists != 0)[
  set distribution-extremists (count agents with [extremist? and item 0 op > 0] - count agents with [extremist? and item 0 op < 0]) / count agents with [extremist?]
][set distribution-extremists "NA"]

end



to-report change-occured?
  ;; this reporter reports false if no change occured for more than 1000 ticks. It is used for behaviour space experiments.
 
  if (ticks mod 1001 = 1000)[
    
    let op-list map [precision ? 2] reduce sentence map  [[op] of ?] sort agents
    let i 0
    
    set change? false
    
    foreach op-list[
      if  (? != item i prev-op) [set change? true]
      set i i + 1] 
 
  set prev-op op-list
  ]  
  report change?


end

to mk-initProfile
   set initial-profile (list)
  foreach sort agents[
    set initial-profile lput (map [precision ? 2][op] of ?) initial-profile
    repeat 5 - num-ops[set initial-profile lput "NA" initial-profile]]
end



to-report format
  ;;This reporter organizes the data for statistical analysis.
  let current-profile (list)
  foreach sort agents[set current-profile lput (map [precision ? 2][op] of ?) current-profile
    repeat 5 - num-ops[set current-profile lput "NA" current-profile]]
  
  set current-profile  reduce sentence current-profile
  set initial-profile  reduce sentence initial-profile
  report (word txt current-profile ",," txt initial-profile)
  
end


to-report txt [liste]
  let text ""
  foreach liste [set text (word text  ? ",")]
  report text 
  
end





















@#$#@#$#@
GRAPHICS-WINDOW
414
21
666
524
10
-1
11.524
1
10
1
1
1
0
0
0
1
-10
10
0
40
1
1
1
ticks
30.0

SLIDER
740
10
912
43
num-agents
num-agents
0
500
500
1
1
NIL
HORIZONTAL

SLIDER
740
44
912
77
num-ops
num-ops
1
8
2
1
1
NIL
HORIZONTAL

SLIDER
740
83
912
116
eps
eps
0
2
0.48
0.01
1
NIL
HORIZONTAL

BUTTON
922
47
989
80
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
922
12
979
45
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
-9
62
394
251
opinion 1 and 5
NIL
NIL
-1.0
1.05
0.0
10.0
true
false
"" ""
PENS
"pen-0" 0.01 1 -2674135 true "" "histogram [item 0 op] of agents"
"pen-2" 0.01 0 -13840069 true "" "if (num-ops >= 5) [histogram [item 4 op] of agents]"

PLOT
694
164
1098
353
opinion 2 and 6
NIL
NIL
-1.0
1.05
0.0
10.0
true
false
"" ""
PENS
"pen-0" 0.01 1 -2674135 true "" "if (num-ops >= 2) [histogram [item 1 op] of agents]"
"pen-1" 0.01 0 -13840069 true "" "if (num-ops >= 6) [histogram [item 5 op] of agents]"

PLOT
-10
259
393
442
opinion 3 and 7
NIL
NIL
-1.0
1.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.01 1 -2674135 true "" "if (num-ops >= 3) [histogram [item 2 op] of agents]"
"pen-1" 0.01 0 -13840069 true "" "if (num-ops >= 7) [histogram [item 6 op] of agents]"

PLOT
694
361
1099
545
opinion 4 and 8
NIL
NIL
-1.0
1.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.01 1 -2674135 true "" "if (num-ops >= 4) [histogram [item 3 op] of agents]"
"pen-1" 0.01 0 -13840069 true "" "if (num-ops >= 8) [histogram [item 7 op] of agents]"

SWITCH
1004
44
1096
77
visuals
visuals
0
1
-1000

SLIDER
740
121
912
154
extremism-range
extremism-range
0
0.5
0
0.01
1
NIL
HORIZONTAL

MONITOR
63
465
202
510
NIL
distribution-extremists
17
1
11

MONITOR
209
464
350
509
NIL
proportion-extremists
17
1
11

CHOOSER
928
90
1095
135
opinion-change
opinion-change
"both change half" "one changes complete"
1

@#$#@#$#@

##General information

This is a model I used in my bachelor thesis entitled:

   Agentenbasierte Simulation in der Sozialwissenschaft. 
   Die Modellierung von Extremismus in Meinungsdynamiken.

(in english: Agentbased simulation in social science. The modelling of extremism in opinion dynamics.)


Basically it's a multidimensional version of a deffuant-style bounded confidence opinion dynamics  model. (Deffuant et al. 2000) The design is based on the article "An Approach to the Study of Communicative Acts" by TM Newcomb (1953). 
There is an extremism rule added. It is based on the simplified version of the relative agreement model (Deffuant et al. 2002) presented by Lorenz (2012).  

##Interaction rules

Pairs of Agents are randomly picked. They change their opinion according to the "opinion-change" variable (see below) if the average of the differences of their opinions in ALL dimensions is below the value of eps. The opinion modification appears in just ONE dimension that is randomly picked.

This sequence is repeatet (number of agents * number of opinion-dimensions) times per tick.

Also there is an extremism rule. Agents that have a very low or very high opinion in dimension one become extremists. They are characterized by the behavior not to change their opinion in this dimension. In all other dimensions they act normal. The variable extremism-range specifies how high or low the opinion must be to become an extremist.         

##Elements on the interface tab


num-agents:         Selects the number of agents

num-ops:            Selects the number of opinons every agent has 

eps:                Selects the confidence bound

extremism-range:    Selects the width of the margins where the extremist? variable
                    set true

opinion-change:	    Selects different rules for a pair of agents to change their opinion.                     The rules are:

                           one changes complete:   Agent A adopts the opinion of
                                                   agent B. Agent B doesn't change. 

                           both change half:       Agent A and B meet at the average 
                                                   of their opinions

visuals:            If activated, a visualisation of the dynamic appears in the world.                       Notice that this is computationally intensive.   


The visualisation in the world gives you the opportunity to track the behaviour of the model on a very basic level. The opinion dimensions are stacked. Every pink dot is one opinion. If the opinion is -1, the dot is on the left border of the world, if it's 1 the dot is on the right border. The grey lines connect the dots that belong to the same agent. 

It is hardly possible to see the size of the clusters in the world. Therefore the are a number of plot windows plotting histograms of the deviation of opinions in the dimensions. The dimensions they are plotting are listed in the title of the plot window.
The lower dimension is plottet as red bars, the higher dimension is plotted as green lines. The dimension one is the upmost dimension in the world view.

The monitor "proportion-extremists" shows the proportion of extremists in the overall population. It can gain values between 0 and 1.

The monitor "distribution-extremists" calculates the number of extremists with a very high opinion minus the number of extremists with a very low opinion, divided by the overall number of extremists. If abs(opinion)>(1-extremism-range) is true, the agent becomes an extremist.

## Additional reporters for behaviour space experiments

The reporter "change-occured?" reports false if the opinion profile did not change since 1000 ticks. This can be used to stop runs that reached a stable state.

The reporter "format" creates a string out of the agents current and initial opinion profiles with all values seperated by comma. The data is organized in the following way:

a(X, Y ,Z) stands for opinion Y of agent X. Z can either be c for the current opinion Y of agent X or i for the initial opinion.

the string then looks like:

"a(1,1,c), a(1,2,c),..., a(1,5,c), a(2,1,c),..., a(num-agents,5,c), , ,   
a(1,1,i),a(1,2,i),..., a(1,5,i), a(2,1,i),..., a(num-agents,5,i)"

If there are less than 5 opinion dimensions, the missing values are filled with "NA".
           


## References

Deffuant, Guillaume; Neau, David; Amblard, Frederic und Gerard Weisbuch (2000): Mixing beliefs among interacting agents In: Advances in Complex Systems, Vol. 3, 87 - 98.

Deffuant, Guillaume; Amblard, Frederic; Weisbuch Gerard und Thierry Faure (2002): How can extremism prevail? A study based on the relative agreement interaction model In: Journal of Artificial Societies and Social Simulation, Vol. 5 (4)

Lorenz, Jan (2012): Zur Methode der agenten-basierten Simulation in der Politikwissenschaft am Beispiel von Meinungsdynamik und Parteienwettstreit In: Braeuninger, Thomas; Baechtiger, Andre und Susumu Shikano (Hrsg.): Jahrbuch fuer Handlungs- und Entscheidungstheorie. Band 7: Experiment und Simulation. VS Verlag fuer Sozialwissenschaften

Newcomb, Theodore M.(1953): An approach to the study of communicative acts. In: Psychological Review, Vol. 60 (6), 393-404
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="without extremism" repetitions="150" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="10000"/>
    <exitCondition>not change-occured?</exitCondition>
    <metric>format</metric>
    <enumeratedValueSet variable="num-ops">
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
    </enumeratedValueSet>
    <steppedValueSet variable="eps" first="0.1" step="0.05" last="0.55"/>
    <enumeratedValueSet variable="extremism-range">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-agents">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opinion-change">
      <value value="&quot;one changes complete&quot;"/>
      <value value="&quot;both change half&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="visuals">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="with extremism-range 003" repetitions="150" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="10000"/>
    <exitCondition>not change-occured?</exitCondition>
    <metric>format</metric>
    <enumeratedValueSet variable="num-ops">
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
    </enumeratedValueSet>
    <steppedValueSet variable="eps" first="0.1" step="0.05" last="0.55"/>
    <enumeratedValueSet variable="extremism-range">
      <value value="0.03"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-agents">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opinion-change">
      <value value="&quot;one changes complete&quot;"/>
      <value value="&quot;both change half&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="visuals">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="with extremism-range 006" repetitions="150" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="10000"/>
    <exitCondition>not change-occured?</exitCondition>
    <metric>format</metric>
    <enumeratedValueSet variable="num-ops">
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
    </enumeratedValueSet>
    <steppedValueSet variable="eps" first="0.1" step="0.05" last="0.55"/>
    <enumeratedValueSet variable="extremism-range">
      <value value="0.06"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-agents">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="opinion-change">
      <value value="&quot;one changes complete&quot;"/>
      <value value="&quot;both change half&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="visuals">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
