;turtles-own [age withmask withglass status Susceptibility Treatmenttime Departure Destination movesize infecteddays treatmentdays infectedpros lockdown]
breed [airplanes airplane]
breed [peoples people]
breed [halos halo]
peoples-own[age withmask withglass status Susceptibility  Departure Destination movesize infecteddays treatmentdays infectedpros lockdown inplane inairport lockdownday]
;movesize: the turtles move distance in every step
;infecteddays: how long have be infected infected people can be health
;treatmentdays: after treatmentdays
;infectedpros: the possibility of infection
;lockdown:0 not lockdown,1 lockdown
;inplane: 0 one the plane, 1 not on the plane
;inairport:"0" not, "A" Acountry airport,"B" Bcountry airport
;status: 0 healthy(green); 2 infected(red); 4 lurking(yellow)
airplanes-own[flying Departure Destination speed]
;flying:1 flying; 0 at the airport
;Departure:country
;Destination:country
;speed: how many steps can more per tick
globals[x Apolicy Bpolicy Amaskrate Bmaskrate Apopulation Bpopulation Acenterx Bcenterx Acolor Bcolor infectdis ALurkingrate findingdays recoverdays withglassrate enableflight lockdowndays filename]
;Apopulation: the population of country A
;Bpopulation: the population of country B
;Acolor: the background color of country A
;Bcolor: the background color of country B
;infectdis: the maximum distance can be infected by others.
;ALurkingrate: at the beginning the lurking people rate of country A.
;findingdays: after findingdays people's status turns from lurking to infected status.
;recoverdays: after recoverdays, the infected people can be recovered
;withglassrate: the rate of people woth glass
;Acenterx Bcenterx: the x of country A and country B
;enableflight: 1, use airplane; 0 ,don't use airplane
;Apolicy,Bpolicy:0 no lockdown when fly to other country;1 lockdown when fly to other country
;lockdowndays: how many days people have to be lockdowned when take the airplain or infected

to make-halo  ;; runner procedure
  ;; when you use HATCH, the new turtle inherits the
  ;; characteristics of the parent.  so the halo will
  ;; be the same color as the turtle it encircles (unless
  ;; you add code to change it
  hatch-halos 1
  [ set size infectdis
    ;; Use an RGB color to make halo three fourths transparent
    set color lput 64 extract-rgb color
    ;; set thickness of halo to half a patch
    __set-line-thickness 0.5
    ;; We create an invisible directed link from the runner
    ;; to the halo.  Using tie means that whenever the
    ;; runner moves, the halo moves with it.
    create-link-from myself
    [ tie
      hide-link ] ]
end


to makelockdown ;make people lockdown
  set lockdown 1
  set lockdownday  0
end

to addlockdownday
  set lockdownday lockdownday + 1
end

to makefree;make people unlockdown
  set lockdown 0
  set lockdownday  0
end

to del-halos
  if count link-neighbors > 0 [
    ask one-of link-neighbors  [ die ]
  ]
end

to setup
  clear-all
  set-default-shape halos "circle 2"
  set Acolor black
  set Bcolor black
  set Apopulation $Apopulation
  set Bpopulation $Bpopulation
  set infectdis $infectdis
  set ALurkingrate  $ALurkingrate / 100 ;initial infected rate
  set findingdays $findingdays
  set recoverdays $recoverdays
  set Apolicy $Apolicy
  set Bpolicy $Bpolicy
  set Amaskrate $Amaskrate
  set Bmaskrate $Bmaskrate
  set withglassrate $withglassrate
  set Acenterx min-pxcor / 2
  set Bcenterx max-pxcor / 2
  set lockdowndays $lockdowndays
  enablefly
  setup-patches
  draw-walls
  setup-airplanes
  setup-turtles

  reset-ticks
end

to setup-airplanes
   create-airplanes 1
   ask airplanes [
     ask airplane 0 [
      setxy  Acenterx  0
      set Departure "A"
      set Destination "B"
      set color yellow
     ]
   ;  ask airplane 1 [
   ;   setxy  Bcenterx  0
   ;   set Departure "B"
   ;   set Destination "A"
   ;   set color white
   ;  ]
    set shape "airplane"
    set flying 0
    set size 3

   ; set label who
    set speed 8
    facexy 0 0
   ]

end

to enablefly
  ifelse $enableflight = True [set enableflight 1]
  [set enableflight 0 ]
end

to fly
  ;the airplanes fly to the other airport
  ask airplanes [
    ifelse Departure = "A" [
      if enableflight = 1 [
        flyAB
      ]
    ][
      if enableflight = 1 [
       flyBA
      ]
    ]
  ]
end

to checkifinairport
  ask peoples [
   ; if (pcolor = "red") and (xcor < 0)[; in A country airport
    set inairport "0"
    if (xcor > -19) and (xcor < -13) and (ycor > -3) and (ycor < 3)[
      set inairport "A"
    ]
    if (xcor > 13) and (xcor < 19) and (ycor > -3) and (ycor < 3)[; in B country airport
      set inairport "B"
    ]
 ;   if (pcolor != "red") [; not in the airports
 ;     set inairport "0"
  ;  ]
  ]
end

to flyAB
 ; checkifinairport
  ask airplanes [
   ifelse flying = 0 [ ; if not flying, start to flay
      if Departure = "A" [
        if (count peoples with [(inairport = "A") and (status != "2") and (lockdown = 0)]) > 0 [
          ask peoples with [(inairport = "A") and (status != "2")] [
            set inplane "1"
          ]
          set label count peoples with [(inairport = "A") and (status != "2") and (lockdown = 0)]
        ]
        facexy Bcenterx 0
        fd speed
        set flying 1
        ask peoples with [(inplane = "1") and (Departure = "A") and (lockdown = 0)][
          setxy [xcor] of airplane 0 [ycor] of airplane 0
        ]
      ]
    ][
 ;      ifelse xcor >= Bcenterx [ ; arrived
 ;         set flying 0
 ;         set Departure "B"
 ;         set Destination "A"
 ;         facexy Acenterx 0
 ;         setxy Bcenterx 0
 ;     ][  ;not arrived
        ifelse xcor + speed < Bcenterx [;flying
          fd speed
          ask peoples with [(inplane = "1") and (Departure = "A") and (lockdown = 0)][
            setxy [xcor] of airplane 0 [ycor] of airplane 0
          ]
        ][ ; arrived
         ; fd Bcenterx - speed
          set flying 0
          set Departure "B"
          set Destination "A"
          facexy Acenterx 0
          setxy Bcenterx 0
          ask peoples with [(inplane = "1") and (Departure = "A") and (lockdown = 0)][
            set inplane "0"
            set Departure "B"
            set Destination "A"
            ;setxy random movesize + [xcor] of airplane 0 random movesize + [ycor] of airplane 0
            setxy 4 + [xcor] of airplane 0 4 + [ycor] of airplane 0
            if Bpolicy = 1 [
              makelockdown
            ]
          ]
          set label  0
          setwithmask
          calinfectedpros
      ]
    ]
  ]
end

to flyBA
    ask airplanes [
      ifelse flying = 0  [ ; if not flying, start to flay

        if Departure = "B" [
          if (count peoples with [(inairport = "B") and (status != "2") and (lockdown = 0)]) > 0 [
          ask peoples with [(inairport = "B") and (status != "2") and (lockdown = 0)] [
            set inplane "1"
          ]
          set label count peoples with [(inairport = "B") and (status != "2") and (lockdown = 0)]
        ]
          facexy Acenterx 0
          fd speed
          set flying 1
          ask peoples with [(inplane = "1") and (Departure = "B") and (lockdown = 0)][
            setxy [xcor] of airplane 0 [ycor] of airplane 0
        ]
        ]
      ][

  ;     ifelse xcor <= Acenterx [ ; arrived
   ;       set flying 0
  ;        set Departure "A"
  ;        set Destination "B"
  ;        setxy Acenterx 0
  ;        facexy Bcenterx 0
  ;    ][  ;not arrived
        ifelse  xcor - Acenterx  > speed  [;flying
          fd speed
          ask peoples with [(inplane = "1") and (Departure = "B") and (lockdown = 0)][
            setxy [xcor] of airplane 0 [ycor] of airplane 0
          ]
        ][ ; arrived
          ;fd Acenterx + speed
          set flying 0
          set Departure "A"
          set Destination "B"
          setxy Acenterx 0
          facexy Bcenterx 0
          ask peoples with [(inplane = "1") and (Departure = "B")][
            set inplane "0"
            set Departure "A"
            set Destination "B"
           ; setxy random movesize + [xcor] of airplane 0 random movesize + [ycor] of airplane 0
            setxy  4 + [xcor] of airplane 0  4 + [ycor] of airplane 0
           if Apolicy = 1 [
            makelockdown
            ]
          ]
        set label  0
        setwithmask
        calinfectedpros
        ]
  ;    ]
    ]
  ]
end

to exportreport
  set x   "gr"
  set x word x  withglassrate
  set x word x  "am"
  set x word x  Amaskrate
  set x word x  "bm"
  set x word x  Bmaskrate
  set x word x  "bm"
  set x word x  Bmaskrate
  set x word x  "ms"
  set x word x  $movesize
  set x word x  "ef"
  set x word x enableflight
  set x word x  "ld"
  set x word x  lockdowndays
  set x word x  "rd"
  set x word x recoverdays
  set x word x  "lr"
  set x word x (ALurkingrate * 100)
  set x word x  "ind"
  set x word x  infectdis
  set x word x  "bo"
  set x word x  $bounce
  set x word x  "Ap"
  set x word x  Apolicy
  set x word x  "Bp"
  set x word x  Bpolicy
  set x word x  "fd"
  set x word x  findingdays
  set filename word user-directory  x
  set filename word filename random 100
  set filename word filename ".csv"
  print filename
  export-all-plots(filename)


end

to setup-patches
  ask patches [
    ifelse pxcor > 0 [
     set pcolor Bcolor ;in country B
    ][
     set pcolor Acolor  ;in country A
    ]
  draw-center ;drawn the airport
  ]
end

to setup-turtles
  setup-turtlesinA ;create turtles in country A
  setup-turtlesinB ;create turtles in country B
  ask peoples [
    randomize
   ; checkifinairport
  ]


End

to setup-turtlesinA
  create-peoples Apopulation
  ask peoples [
    if ( Departure !=  "A" ) and ( Departure !=  "B" )   [
    setxy random-xcor random-ycor
    set age random 90 + 1
    set withmask 0
    set status random 4
    set Susceptibility 0
   ; set Treatmenttime 14
    set Departure "A"
    set Destination "B"
    set infecteddays 0
    set treatmentdays 0
    set lockdown 0
    set inplane 0
    ifelse ALurkingrate * Apopulation > who [
        set status 4
        set color yellow
        make-halo
      ][
        set status 0
        set color green
      ]
    ;set energy 1
    set shape "person"
    setwithglass
    setwithmask
    calinfectedpros ; set the infectedpros
    changeshape
    set size 1
    set label who
    ;set color white
    ;randomize
   ]
  ]
end

to setwithmask
  ask peoples [
    ifelse xcor < 0 [; in country A
    ifelse (random 100 > Amaskrate)[
      set withmask 0
    ][
      set withmask 1
    ]
    ][;in country B
    ifelse (random 100 > Bmaskrate)[
      set withmask 0
    ][
      set withmask 1
    ]

    ]
  ]
end

to changeshape ;make people's shape change
  ask peoples [
    if (withmask = 0) and (withglass = 0) [
;      set shape "person"
    ]
    if  (withmask = 1) and (withglass = 1) [
;      set shape "glassmask"
    ]
    if  (withmask = 0) and (withglass = 1) [

;      set shape "glass"
    ]
    if  (withmask = 1) and (withglass = 0) [
 ;     set shape "mask"
    ]
  ]
end

to setwithglass
  ask peoples [
    ifelse (random 100 >= withglassrate)[
      set withglass 0
    ][
      set withglass 1
    ]
  ]
end

to calinfectedpros
  ask peoples [
    set infectedpros age *( (1 - withmask ) * 0.5 + (1 - withglass ) * 0.3 + 0.2) / 100
  ]
end

to setup-turtlesinB
  create-peoples Bpopulation
  ask peoples [
    if ( Departure !=  "A" ) and ( Departure !=  "B" ) [
    setxy random-xcor random-ycor
    set age random 90 + 1
    set withmask 0
    set status random 4
    set Susceptibility 0
   ; set Treatmenttime 14
    set Departure "B"
    set Destination "A"
    set treatmentdays 0
    set infecteddays 0
    set status 0
    set lockdown 0
    set inplane 0
    ;set energy 1
    set shape "person"
    setwithglass
    setwithmask
    calinfectedpros ; set the infectedpros
    changeshape
    set size 1
    set color green
   ; set label who
    ;randomize
   ]
  ]

end

to randomize
  if Departure = "A" [
  setxy random min-pxcor random-ycor
  if pcolor = blue or pcolor = red    ; if it's on the wall or airport...
    [ randomize ]        ; ...try again
  ]
  if Departure = "B" [
  setxy random max-pxcor random-ycor
  if pcolor = blue or pcolor = red    ; if it's on the wall or airport...
    [ randomize ]        ; ...try again
  ]
end



; draws the boundaries (walls) of the "billiard table"
to draw-walls
  ; draw left and right walls
  ask patches with [abs pxcor =  0  ]
    [ set pcolor blue ]
    ask patches with [abs pxcor = max-pxcor]
    [ set pcolor blue ]
  ; draw top and bottom walls
  ask patches with [abs pycor = max-pycor]
    [ set pcolor blue ]
end



to draw-center
  ask patches with [ ( abs pxcor >  max-pxcor / 2 - 3  and abs pxcor <  max-pxcor / 2 + 3 ) and ( pycor < 3 and  pycor > -3 )
  ]
    [ set pcolor red ]
end

to go
  move-peoples
  checkifinairport
  fly
  tick
end

to remove-peoples
  ask peoples [
  ifelse status = 7 [
    die
  ][
    forward random size
  ]
  ]
end

to bounce  ;; for people not across the border
  ; check: hitting the wall?
    if ($bounce = True)[; when next step can be across the border, change dirction
    if ((abs xcor ) - movesize  < infectdis / 2 ) [ ;people can't move across the borader
        if ((Departure = "B") and (heading > 180) and (heading < 360 ) ) or ((Departure = "A") and (heading < 180) and (heading > 0)) [
          set heading (- heading )
        ]
      ]
  ]
      forward movesize

end


to infecteachothers ; infect others or be infected by others
   if count other peoples-here in-radius infectdis > 0 [ ;if there is any one near
        ask other peoples-here in-radius infectdis [
          ifelse ([status] of myself = 0)[;self is healthy and can be infected
            if ((status = 4) and (lockdown = 0))[
              if (100 * infectedpros * [infectedpros] of myself / age >= (random 9 + 1 ) / 10 )[ ; only if the infectedpros is not good,being infected
                if ( [status] of myself = 0 ) and ([inplane] of myself = inplane) [
                  ask myself [
                     turnlurking
                  ]
               ]
              ]
            ]
          ][
          if ([status] of myself = 4)[ ;self is a lurking people and can infect others
            if ((status = 0) and (lockdown = 0))[
              if (100 * infectedpros * [infectedpros] of myself  / [age] of myself >= (random 9 + 1 ) / 10 )[ ; only if the infectedpros is not good,infect the other people
               if ( status = 0 ) and ([inplane] of myself = inplane) [
                 turnlurking
               ]
              ]
            ]
          ]
         ]
        ]
      ]
end



to move-peoples
  ask peoples [
    checkinfected; fisrtly  if lurking people can change to infected poeple
    ifelse ( lockdown != 1 ) [ ;unlockdown people
      left random 360
      set movesize random $movesize + 1
      bounce
      infecteachothers
    ][ ;For lockdown people, cannot infect others
      addlockdownday
      if (lockdownday > lockdowndays) [
        makefree
      ]
    ]

     if (status = 2 )[; for infected people
      set  treatmentdays treatmentdays + 1
      if ( treatmentdays > recoverdays )  [;the treatment process of infected people is over
        turnhealthy
      ]
    ]
  ]

end

to checkinfected; to check if lurking people can change to infected poeple, if yes, change their status
    if ( status = 4 ) and (infecteddays >= 0) [ set infecteddays infecteddays + 1]; for lurking people caculate the infected days
    if (status = 2) and (lockdown = 0)[  turnlurking ] ;if infected people not lockdown, he becomes a lurking one
    if ( infecteddays > findingdays ) ; from lurking to infected and lockdown them
      [
        turninfected
      ]
end

to turnlurking ;healthy people becomes lurking people
   set status 4
   set color yellow
   make-halo
end

to turninfected; lurking people becomes infected people
   set status 2
   makelockdown
   set color red
   set infecteddays 0
   del-halos
end

to turnhealthy ;the infected people become a healthy one
   set status 0
   set treatmentdays 0
   set infecteddays 0
   set color green
end

to color-change
   ask turtles[
    set color red
  ]

end
@#$#@#$#@
GRAPHICS-WINDOW
405
10
1258
448
-1
-1
13.0
1
10
1
1
1
0
0
0
1
-32
32
-16
16
0
0
1
ticks
30.0

BUTTON
263
181
329
214
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
265
225
331
258
go-go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
68
129
223
189
$recoverdays
12.0
1
0
Number

SLIDER
68
345
223
378
$movesize
$movesize
1
10
5.0
1
1
NIL
HORIZONTAL

PLOT
506
449
828
577
 A country
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"poplulation" 1.0 0 -7500403 true "" "plot count peoples with [xcor < 0]"
"infected" 1.0 0 -2674135 true "" "plot count peoples with [(color = red) and (xcor < 0)  ]"
"healthy" 1.0 0 -10899396 true "" "plot count peoples with [ color = green and (xcor < 0) ]"
"lurking" 1.0 0 -1184463 true "" "plot count peoples with [color = yellow and (xcor < 0) ]"

CHOOSER
403
450
505
495
$Apolicy
$Apolicy
0 1
0

INPUTBOX
68
190
223
250
$Apopulation
700.0
1
0
Number

INPUTBOX
69
252
224
312
$Bpopulation
0.0
1
0
Number

MONITOR
506
579
632
624
(A)Infected rate %
100 * count peoples with [(color = red) and (xcor < 0) ] / count peoples with [xcor < 0]
17
1
11

BUTTON
267
274
330
307
go
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
68
312
224
345
$ALurkingrate
$ALurkingrate
1
100
18.0
1
1
NIL
HORIZONTAL

CHOOSER
1156
448
1258
493
$Bpolicy
$Bpolicy
0 1
0

SLIDER
69
379
223
412
$withglassrate
$withglassrate
0
100
20.0
1
1
NIL
HORIZONTAL

SLIDER
656
577
829
610
$Amaskrate
$Amaskrate
0
100
100.0
1
1
NIL
HORIZONTAL

SLIDER
983
579
1156
612
$Bmaskrate
$Bmaskrate
0
100
0.0
1
1
NIL
HORIZONTAL

SLIDER
68
411
224
444
$infectdis
$infectdis
1
6
3.0
1
1
NIL
HORIZONTAL

PLOT
836
448
1155
579
B country
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"population" 1.0 0 -7500403 true "" "plot count peoples with [xcor > 0] "
"infected" 1.0 0 -2674135 true "" "plot count peoples with [(color = red) and (xcor > 0)  ]"
"healthy" 1.0 0 -10899396 true "" "plot count peoples with [(color = green) and (xcor > 0)  ]"
"lurking" 1.0 0 -1184463 true "" "plot count peoples with [(color = yellow) and (xcor > 0)  ]"

MONITOR
837
579
960
624
(B)Infected rate %
100 * count peoples with [(color = red) and (xcor > 0) ] / count peoples with [xcor > 0]
17
1
11

MONITOR
403
497
492
542
Apopulation
count peoples with [xcor < 0]
17
1
11

MONITOR
1170
495
1259
540
Bpopulation
count peoples with [xcor > 0]
17
1
11

SWITCH
69
444
223
477
$enableflight
$enableflight
1
1
-1000

INPUTBOX
67
70
222
130
$lockdowndays
12.0
1
0
Number

SWITCH
68
478
224
511
$bounce
$bounce
1
1
-1000

BUTTON
265
328
331
361
export
exportreport
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
68
513
224
546
$findingdays
$findingdays
1
25
12.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

It's a program trying to find how the Covid-19 spread in 1 or 2 countries.

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

glass
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Rectangle -7500403 true true 120 30 150 45
Rectangle -16777216 true false 120 30 135 45
Rectangle -16777216 true false 165 30 180 45
Line -16777216 false 135 30 165 30

glassmask
false
14
Circle -7500403 true false 110 5 80
Polygon -7500403 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true false 127 79 172 94
Polygon -7500403 true false 195 90 240 150 225 180 165 105
Polygon -7500403 true false 105 90 60 150 75 180 135 105
Rectangle -1 true false 120 45 180 75
Line -16777216 true 135 15 165 15
Rectangle -16777216 true true 120 15 135 30
Rectangle -16777216 true true 165 15 180 30
Rectangle -16777216 false true 120 45 180 75

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

mask
false
15
Circle -7500403 true false 110 5 80
Polygon -7500403 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true false 127 79 172 94
Polygon -7500403 true false 195 90 240 150 225 180 165 105
Polygon -7500403 true false 105 90 60 150 75 180 135 105
Rectangle -1 true true 120 45 180 75
Rectangle -16777216 false false 120 45 180 75

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
