breed [ humans human ]
breed [ zombies zombie ]
turtles-own [ user-id lives killed chrtype dead]
globals
[
 leader
 leaderpoints 
]

to setup
  clear-all
  hubnet-reset
  reset-ticks
end

to go
  every .1
  [
    ask turtles with [user-id != "auto"] [
      updateclientdata
    ]
    listen-clients
    move
    tick
  ]
end

to listen-clients 
  while [ hubnet-message-waiting? ]
  [
   hubnet-fetch-message
   
   ifelse ( hubnet-enter-message? ) 
   [ ;it's an enter message
     let type1 (random 100)
     ifelse (type1 < 50)[
     create-new-student-zombie
     ][
     create-new-student-human
     ]
   ]
   [
     ifelse (hubnet-exit-message?)
     [ ;it's an exit message
       ask turtles with [ user-id = hubnet-message-source ][ die ]
     ]
     [
       ;it's not either an enter or exit message...
       let handled false
       if (hubnet-message-tag = "front")[
         set handled true
         ask turtles with [ user-id = hubnet-message-source ] [
           fd 1
         ]
       ]
       if (hubnet-message-tag = "left")[
         set handled true
         ask turtles with [ user-id = hubnet-message-source ] [
           left 45
         ]
       ]
       if (hubnet-message-tag = "right")[
         set handled true
         ask turtles with [ user-id = hubnet-message-source ] [
           right 45
         ]
       ]
       if (hubnet-message-tag = "down")[
         set handled true
         ask turtles with [ user-id = hubnet-message-source ] [
           fd -1
         ]
       ]
       if (hubnet-message-tag = "attack")[
         set handled true
         ask turtles with [ user-id = hubnet-message-source ] [
           let xcor1 xcor
           let ycor1 ycor
           
           let victims other turtles in-radius (size * 3) with [user-id != "auto"]
           if any? victims
           [
             let poor-guy one-of victims
             ask poor-guy [
               hubnet-send user-id "ChatBox" (word "You were killed by " hubnet-message-source)
               setxy random-xcor random-ycor
               set lives (lives - 1)
               if (lives = 0)
               [
                 hubnet-send user-id "ChatBox" (word "You lost!")
                 
               ]
             ]
             set killed (killed + 1) 
             updateleader
           ]
         ]
       ]
       if (hubnet-message-tag = "ChatText")[
        set handled true
        ask turtles with [user-id != "auto"] [
        hubnet-send user-id "ChatBox" (word hubnet-message-source ": " hubnet-message)
        ]
       ]
       if (handled = false)[
      show ( word "Message from " hubnet-message-source " with tag = " hubnet-message-tag " and contents " hubnet-message )
       ]
     ]
   ]
  ]
end

to create-new-student-zombie
  create-zombies 1
  [
   setxy random-xcor random-ycor 
   set user-id hubnet-message-source
   set heading 0
   set shape "turtle"
   set color red
   set lives 5
   set killed 0
   set chrtype "zombie"
   set dead false
  ]
end

to create-new-student-human
  create-humans 1
  [
    setxy random-xcor random-ycor
    set user-id hubnet-message-source
    set heading 0
    set shape "turtle"
    set color blue
    set lives 5
    set killed 0
    set chrtype "human"
    set dead false
  ]
end


to create-new-ai-zombie
  create-zombies 1
  [
    setxy random-xcor random-ycor
    set user-id "auto"
    set heading 0
    set shape "turtle"
    set color red
  ]
end

to create-new-ai-human
  create-humans 1
  [
    setxy random-xcor random-ycor
    set user-id "auto"
    set heading 0
    set shape "turtle"
    set color blue
  ]
end


to send-data-to [ a-user a-widget a-value ]
  show a-user
  show count turtles with [ user-id = a-user ]
  ask turtles with [ user-id = a-user ]
  [
    ;//hubnet-send client-id tag content
    hubnet-send user-id a-widget a-value
  ]
end

to clientwatch
  ask turtles with [user-id != "auto"][ hubnet-send-watch user-id self]
end

to clientfollow
  ask turtles with [user-id != "auto"][ hubnet-send-follow user-id self dist]
end

to spawn
  repeat number-of-zombies[
    create-new-ai-zombie
  ]
  repeat number-of-humans[
    create-new-ai-human
  ]
end

to kill-spawns
  ask turtles with [user-id = "auto"][ die ]
end

to updateclientdata
  hubnet-send user-id "Killed" killed
  hubnet-send user-id "Lives left" lives
  hubnet-send user-id "Type" chrtype
  hubnet-send user-id "Leader" leader
  hubnet-send user-id "Leader points" leaderpoints
end

to updateleader
  if any? turtles with [user-id != "auto"] [
   let leaders turtles with-max [ killed ]
   let number-leaders count leaders
   ifelse number-leaders > 1
   [set leader word number-leaders "-way tie"]
   [ ask one-of leaders [ set leader user-id ] ]
   set leaderpoints [killed] of one-of leaders 
  ]
end

to move
  ask turtles with [user-id = "auto"][
  rt (random 11) - 5
  fd .2
  ]
  
end
@#$#@#$#@
GRAPHICS-WINDOW
352
10
791
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
11
18
77
51
NIL
setup\\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
86
18
149
51
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

OUTPUT
7
412
335
466
12

INPUTBOX
13
62
150
122
number-of-humans
5
1
0
Number

INPUTBOX
12
127
167
187
number-of-zombies
8
1
0
Number

BUTTON
12
193
150
226
NIL
Spawn
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
8
364
121
397
NIL
hubnet-reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
7
324
122
357
override view
clientwatch
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
130
323
302
356
dist
dist
1
10
10
1
1
NIL
HORIZONTAL

BUTTON
13
229
113
262
Kill Spawns
kill-spawns
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
175
230
325
263
Import Background
import-drawing user-file
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
10
281
93
314
override
clientfollow
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

ghost
false
0
Polygon -7500403 true true 30 165 13 164 -2 149 0 135 -2 119 0 105 15 75 30 75 58 104 43 119 43 134 58 134 73 134 88 104 73 44 78 14 103 -1 193 -1 223 29 208 89 208 119 238 134 253 119 240 105 238 89 240 75 255 60 270 60 283 74 300 90 298 104 298 119 300 135 285 135 285 150 268 164 238 179 208 164 208 194 238 209 253 224 268 239 268 269 238 299 178 299 148 284 103 269 58 284 43 299 58 269 103 254 148 254 193 254 163 239 118 209 88 179 73 179 58 164
Line -16777216 false 189 253 215 253
Circle -16777216 true false 102 30 30
Polygon -16777216 true false 165 105 135 105 120 120 105 105 135 75 165 75 195 105 180 120
Circle -16777216 true false 160 30 30

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person soldier
false
0
Rectangle -7500403 true true 127 79 172 94
Polygon -10899396 true false 105 90 60 195 90 210 135 105
Polygon -10899396 true false 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Polygon -10899396 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -6459832 true false 120 90 105 90 180 195 180 165
Line -6459832 false 109 105 139 105
Line -6459832 false 122 125 151 117
Line -6459832 false 137 143 159 134
Line -6459832 false 158 179 181 158
Line -6459832 false 146 160 169 146
Rectangle -6459832 true false 120 193 180 201
Polygon -6459832 true false 122 4 107 16 102 39 105 53 148 34 192 27 189 17 172 2 145 0
Polygon -16777216 true false 183 90 240 15 247 22 193 90
Rectangle -6459832 true false 114 187 128 208
Rectangle -6459832 true false 177 187 191 208

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC10
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
VIEW
238
17
706
485
0
0
0
1
1
1
1
1
0
1
1
1
-16
16
-16
16

BUTTON
85
18
148
51
front
NIL
NIL
1
T
OBSERVER
NIL
W

BUTTON
17
57
80
90
left
NIL
NIL
1
T
OBSERVER
NIL
A

BUTTON
84
57
149
90
down
NIL
NIL
1
T
OBSERVER
NIL
S

BUTTON
154
58
217
91
right
NIL
NIL
1
T
OBSERVER
NIL
D

BUTTON
18
103
217
136
attack
NIL
NIL
1
T
OBSERVER
NIL
P

MONITOR
18
146
97
195
Killed
NIL
3
1

MONITOR
18
206
97
255
Leader
NIL
3
1

MONITOR
104
206
201
255
Leader points
NIL
3
1

MONITOR
104
146
200
195
Lives left
NIL
3
1

MONITOR
821
21
1057
70
ChatBox
NIL
3
1

INPUTBOX
821
83
1056
143
ChatText
NIL
1
0
String

BUTTON
993
154
1056
187
send
NIL
NIL
1
T
OBSERVER
NIL
NIL

MONITOR
18
262
75
311
Type
NIL
3
1

@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
