;; This was created with old data and assumptions. By the time I was almost finished with this code,
;; I found this page which could help improve upon the data: http://pkmngotrading.com/forum/ .
;; Furthermore, the rarity of some pokemon (e.g. eevee) do not seem to align with other reports.

;; button referenced commands are Title-Cased with a dash

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MODEL GLOBALS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;               ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

globals [
  sprout?
  tgrass ;; grass type
  tfire ;; fire type
  twater
  tbug
  tnormal
  tpoison
  telectric
  tground
  tfairy
  tfighting
  tpsychic
  trock
  tghost
  tice
  tdragon
  tflying
  caught-pokemon
  uncaught-pokemon
  ]

breed [ trainer a-trainer ]
breed [ rivals a-rival ]
breed [ pokemon a-pokemon ]

trainer-own [ target ]
rivals-own [ target ]
;; number assigns pokemon to pokemon (e.g. bulbasaur)
;; commonness assigns pokemon to commonness
;; ptype assigns pokemon to a type (for sprout on patch types)
;; energy makes pokemon ephemeral
;; alive-number is assigned if they are caught, otherwise 0
pokemon-own [
  number
  ptype1
  ptype2 ;; internal recorded note for sprout at specific patches
  commonness
  energy
  alive-number
  ]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;             ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MODEL SETUP ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;             ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Setup
  clear-all
  outside-world ;; sets up the patches
  city ;; sets up the city composition
  sprout-player ;; sprouts player
  setup-player ;; sets up the trainer
  sprout-rival ;; sprouts trainer's rivals
  setup-rival ;; sets up the trainer's rivals
  reset-ticks
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; PATCH CREATION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; North of the outside-world is Someone's or Bill's PC. That is where we store the Pokemon.
to outside-world
  ;; Water
  ask patches [
    if (pxcor = 19) or (pxcor = 20) and (pycor <= 20) and (pycor >= -20) [
      set pcolor blue
    ]
  ]
  ;; Grass
  ask patches [
    if (pxcor = -19) or (pxcor = -20) and (pycor <= 20) and (pycor >= -20) [
      set pcolor green
    ]
  ]
  ;; Wetlands
  ask patches [
    if (pycor = 19) or (pycor = 20) and (pxcor <= 18) and (pxcor >= -18) [
      set pcolor turquoise
    ]
  ]
  ;; Beach
  ask patches [
    if (pycor = -19) or (pycor = -20) and (pxcor <= 18) and (pxcor >= -18) [
      set pcolor 28
    ]
  ]
end

to city
      ;; Concrete
      ;; tells random patches (the number decided by a slider) to turn gray
      ;; as long as they are not in the outside world nor already assigned
  ask n-of Concrete patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor gray
    ]
  ]
    ;; Open Spaces
  ask n-of Open-Spaces patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor lime
    ]
  ]
    ;; Landmarks
  ask n-of Landmarks patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor brown
    ]
  ]
    ;; Power Plants
  ask n-of Power-Plants patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor yellow
    ]
  ]
    ;; Hospitals
  ask n-of Hospitals patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor white
    ]
  ]
    ;; Gyms : not Pokemon gyms, but human gyms
  ask n-of Gyms patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor violet
    ]
  ]
    ;; Cinemas
  ask n-of Cinemas patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor sky
    ]
  ]
    ;; Houses-Of-Worship
  ask n-of Houses-Of-Worship patches [
    if (pxcor <= 18) and (pxcor >= -18) and (pycor <= 18) and (pycor >= -18) and pcolor = black [
      set pcolor red
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; TRAINER CREATION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Initially I had set it up to create trainer/rivals and send them to randomxycor in the setup button.
;; I noticed those turtles would move around a lot more than once per tick, while the pokemon
;; would only move once per tick. I decided to try to set up the random location of trainer/rivals by
;; following the same method: having them be sprouted by random patches.

;; trainer sprouts at random location
to sprout-player
  ask one-of patches [
    sprout-trainer 1
    ]
end

;; trainer is given its characteristics
to setup-player
  ask trainer [
    set color Trainer-Color
    set shape "trainer"
    set size 2
  ]
end

;; rivals sprout at random locations
to sprout-rival
  ;; allows the user to determine how much competition there is
  ask n-of Number-OF-Rivals patches [
    sprout-rivals 1
    ]
end

;; rival is given its characteristics
to setup-rival
  ask rivals [
    set color Rivals-Color
    set shape "person"
    set size 1.5
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MODEL GO ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to Pokemon-Go-!
  move-players
  catch-pokemons
  sprout-pokemons
  define-pokemon-by-type
  move-pokemons
  sprout-types
  kill-pokemons
  tick
end

to move-players
  ;; switch off = passive and switch on = active
  ifelse Trainer-Actively-Searches = TRUE [
    ask trainer [
      ;; Active:
      ;; if the trainer is within a distance set by user to the highest pokemon within that distance
      ;; they face that target and move forward twice as fast (trainer is more excited)
      ;; otherwise trainer wanders randomly and slowly
      set target max-one-of pokemon with [ number > 0 ] [ commonness ]
      ifelse target != nobody and distance target <= Pokemon-Radar-Distance [
        face target
        fd 2
    ] [
      rt random 360
      fd 1
    ]
  ]
  ] [
      ;; Passive:
      ;; the trainer wanders randomly and slowly always
      ;; only catches pokemon if trainer receives a notification on phone
      ;; that is a real function in the game
    ask trainer [
      rt random 360
      fd 1
    ]
  ]
  ifelse Rivals-Actively-Search = TRUE [
    ask rivals [
      set target max-one-of pokemon with [ number > 0 ] [ commonness ]
      ifelse target != nobody and distance target <= Pokemon-Radar-Distance [
        face target
        fd 2
    ] [
      rt random 360
      fd 1
    ]
  ]
  ] [
    ask rivals [
      rt random 360
      fd 1
  ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; CATCH POKEMON
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to catch-pokemons
  ask trainer [
    ;; identifies the highest level pokemon around
    let best-pokemon max-one-of pokemon with [ number > 0 ] in-radius Catch-Radius [ commonness ]
    ;; catches the highest level pokemon around
    if best-pokemon != nobody [
      ask best-pokemon [
        set caught-pokemon caught-pokemon + 1
        ;; tells the pokemon to go to their waiting corner
        if number >= 1 and number <= 41 [ setxy -21 + number 24 ]
        if number >= 42 and number <= 82 [ setxy -21 + (number - 41) 23 ]
        if number >= 83 and number <= 123 [ setxy -21 + (number - 82) 22 ]
        if number >= 124 and number <= 164 [ setxy -21 + (number - 123) 21 ]
        ;; assigns them a value to associate them with previous value
        ;; clears them from being caught again (number < 0)
        ;; assigns them a row
        ;; saves them from dying (energy -1)
        if number >= 1 and number <= 41 [
          set alive-number number
          set number -1
        ]
        if number >= 42 and number <= 82 [
          set alive-number number
          set number -2
        ]
        if number >= 83 and number <= 123 [
          set alive-number number
          set number -3
        ]
        if number >= 124 and number <= 164 [
          set alive-number number
          set number -4
        ]
        set energy -1
      ]
    ]
  ]
  ask rivals [
    ;; catches the highest level pokemon around
    let best-pokemon max-one-of pokemon with [ number > 0 ] in-radius Catch-Radius [ commonness ]
    if best-pokemon != nobody [
      ask best-pokemon [ die ]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; INDIVIDUAL POKEMON SPROUT RATES + ATTRIBUTION OF SOME CHARACTERISTICS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Pokemon sprout rates were calculated based on the rarity percentages from https://pokeassistant.com/main/pokemonstats
;; Pokemon sprout at rate: 1 per (60 / rarity*100) -> round to the nearest integer
;; For example, Bulbasaur has a rarity percentage of 1.18% so we will see it about 1 time for every 51
;; Pokemon move styles and lifespans are based on the same values
;; Very Common Pokemon:  1/3 -> 1/39
;; Common Pokemon: 1/40 -> 1/99
;; Uncommon Pokemon:  1/100 -> 1/299
;; Rare Pokemon: 1/300 and 1/857
;; Very Rare Pokemon: 1/6000 except
;; Special Pokemon: Venusaur, Charizard, Blastoise, Dragonite, and
;; Legendary Pokemon: Ditto, and
;; Unseen Pokemon (will never sprout in this simulation as there has yet to be a sighting:
;; Articuno, Zapdos, Moltres, and Mewtwo
;; Special and Legendary choices are a bit arbitrary/subjective based on experience and research
;; Pokemon move and have a life expectancey according to rare category
;; For example, caterpie is very common and will move short distances for long periods of time
;; while ditto is legendary and will move long distances for short periods of time

to sprout-pokemons
  ;; bulbasaur appears 1 out of 51
  set sprout? ( 1 + random 51 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 1
        set ptype1 "grass"
        set ptype2 "poison"
        common-pokemon
      ]
    ]
  ]
  ;; ivysaur appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 2
        set ptype1 "grass"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; venusaur appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 3
        set ptype1 "grass"
        set ptype2 "poison"
        special-pokemon
      ]
    ]
  ]
  ;; charmander appears 1 out of 261
  set sprout? ( 1 + random 261 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 4
        set ptype1 "fire"
        uncommon-pokemon
      ]
    ]
  ]
  ;; charmeleon appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 5
        set ptype1 "fire"
        rare-pokemon
      ]
    ]
  ]
  ;; charizard appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 6
        set ptype1 "grass"
        set ptype2 "flying"
        special-pokemon
      ]
    ]
  ]
  ;; squirtle appears 1 out of 107
  set sprout? ( 1 + random 107 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 7
        set ptype1 "water"
        uncommon-pokemon
      ]
    ]
  ]
  ;; wartortle appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 8
        set ptype1 "water"
        rare-pokemon
      ]
    ]
  ]
  ;; blastoise appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 9
        set ptype1 "water"
        special-pokemon
      ]
    ]
  ]
  ;; caterpie appears 1 out of 16
  set sprout? ( 1 + random 16 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 10
        set ptype1 "bug"
        very-common-pokemon
      ]
    ]
  ]
  ;; metapod appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 11
        set ptype1 "bug"
        rare-pokemon
      ]
    ]
  ]
  ;; butterfree appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 12
        set ptype1 "bug"
        set ptype2 "flying"
        very-rare-pokemon
      ]
    ]
  ]
  ;; weedle appears 1 out of 9
  set sprout? ( 1 + random 9 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 13
        set ptype1 "bug"
        set ptype2 "poison"
        very-common-pokemon
      ]
    ]
  ]
  ;; kakuna appears 1 out of 107
  set sprout? ( 1 + random 107 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 14
        set ptype1 "bug"
        set ptype2 "poison"
        uncommon-pokemon
      ]
    ]
  ]
  ;; beedrill appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 15
        set ptype1 "bug"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; pidgey appears 1 out of 3
  set sprout? ( 1 + random 3 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 16
        set ptype1 "normal"
        set ptype2 "flying"
        very-common-pokemon
      ]
    ]
  ]
  ;; pidgeotto appears 1 out of 52
  set sprout? ( 1 + random 52 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 17
        set ptype1 "normal"
        set ptype2 "flying"
        common-pokemon
      ]
    ]
  ]
  ;; pidgeot appears 1 out of 231
  set sprout? ( 1 + random 231 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 18
        set ptype1 "normal"
        set ptype2 "flying"
        uncommon-pokemon
      ]
    ]
  ]
  ;; rattata appears 1 out of 5
  set sprout? ( 1 + random 5 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 19
        set ptype1 "normal"
        very-common-pokemon
      ]
    ]
  ]
  ;; raticate appears 1 out of 261
  set sprout? ( 1 + random 261 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 20
        set ptype1 "normal"
        uncommon-pokemon
      ]
    ]
  ]
  ;; spearow appears 1 out of 16
  set sprout? ( 1 + random 16 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 21
        set ptype1 "normal"
        set ptype2 "flying"
        very-common-pokemon
      ]
    ]
  ]
  ;; fearow appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 22
        set ptype1 "normal"
        set ptype2 "flying"
        rare-pokemon
      ]
    ]
  ]
  ;; ekans appears 1 out of 24
  set sprout? ( 1 + random 24 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 23
        set ptype1 "poison"
        very-common-pokemon
      ]
    ]
  ]
  ;; arbok appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 24
        set ptype1 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; pikachu appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 25
        set ptype1 "electric"
        rare-pokemon
      ]
    ]
  ]
  ;; raichu appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 26
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; sandshrew appears 1 out of 54
  set sprout? ( 1 + random 54 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 27
        set ptype1 "ground"
        common-pokemon
      ]
    ]
  ]
  ;; sandslash appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 28
        set ptype1 "ground"
        rare-pokemon
      ]
    ]
  ]
  ;; nidoran-1 appears 1 out of 44
  set sprout? ( 1 + random 44 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 29
        set ptype1 "poison"
        common-pokemon
      ]
    ]
  ]
  ;; nidorina appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 30
        set ptype1 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; nidoqueen appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 31
        set ptype1 "poison"
        set ptype2 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; nidoran-2 appears 1 out of 38
  set sprout? ( 1 + random 38 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 32
        set ptype1 "poison"
        very-common-pokemon
      ]
    ]
  ]
  ;; nidorino appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 33
        set ptype1 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; nidoking appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 34
        set ptype1 "poison"
        set ptype2 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; clefairy appears 1 out of 40
  set sprout? ( 1 + random 40 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 35
        set ptype1 "fairy"
        common-pokemon
      ]
    ]
  ]
  ;; clefable appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 36
        set ptype1 "fairy"
        very-rare-pokemon
      ]
    ]
  ]
  ;; vulpix appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 37
        set ptype1 "fire"
        rare-pokemon
      ]
    ]
  ]
  ;; ninetales appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 38
        set ptype1 "fire"
        very-rare-pokemon
      ]
    ]
  ]
  ;; jigglypuff appears 1 out of 182
  set sprout? ( 1 + random 182 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 39
        set ptype1 "normal"
        set ptype2 "fairy"
        uncommon-pokemon
      ]
    ]
  ]
  ;; wigglytuff appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 40
        set ptype1 "normal"
        set ptype2 "fairy"
        very-rare-pokemon
      ]
    ]
  ]
  ;; zubat appears 1 out of 3
  set sprout? ( 1 + random 3 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 41
        set ptype1 "poison"
        set ptype2 "flying"
        very-common-pokemon
      ]
    ]
  ]
  ;; golbat appears 1 out of 91
  set sprout? ( 1 + random 91 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 42
        set ptype1 "poison"
        set ptype2 "flying"
        common-pokemon
      ]
    ]
  ]
  ;; oddish appears 1 out of 49
  set sprout? ( 1 + random 49 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 43
        set ptype1 "grass"
        set ptype2 "poison"
        common-pokemon
      ]
    ]
  ]
  ;; gloom appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 44
        set ptype1 "grass"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; vileplume appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 45
        set ptype1 "grass"
        set ptype2 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; paras appears 1 out of 23
  set sprout? ( 1 + random 23 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 46
        set ptype1 "bug"
        set ptype2 "grass"
        very-common-pokemon
      ]
    ]
  ]
  ;; parasect appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 47
        set ptype1 "bug"
        set ptype2 "grass"
        rare-pokemon
      ]
    ]
  ]
  ;; venonat appears 1 out of 18
  set sprout? ( 1 + random 18 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 48
        set ptype1 "bug"
        set ptype2 "poison"
        very-common-pokemon
      ]
    ]
  ]
  ;; venomoth appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 49
        set ptype1 "bug"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; diglett appears 1 out of 200
  set sprout? ( 1 + random 200 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 50
        set ptype1 "ground"
        uncommon-pokemon
      ]
    ]
  ]
  ;; dugtrio appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 51
        set ptype1 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; meowth appears 1 out of 154
  set sprout? ( 1 + random 154 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 52
        set ptype1 "normal"
        uncommon-pokemon
      ]
    ]
  ]
  ;; persian appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 53
        set ptype1 "normal"
        rare-pokemon
      ]
    ]
  ]
  ;; psyduck appears 1 out of 79
  set sprout? ( 1 + random 79 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 54
        set ptype1 "water"
        common-pokemon
      ]
    ]
  ]
  ;; golduck appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 55
        set ptype1 "water"
        rare-pokemon
      ]
    ]
  ]
  ;; mankey appears 1 out of 95
  set sprout? ( 1 + random 95 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 56
        set ptype1 "fighting"
        common-pokemon
      ]
    ]
  ]
  ;; primeape appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 57
        set ptype1 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; growlithe appears 1 out of 65
  set sprout? ( 1 + random 65 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 58
        set ptype1 "fire"
        common-pokemon
      ]
    ]
  ]
  ;; arcanine appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 59
        set ptype1 "fire"
        very-rare-pokemon
      ]
    ]
  ]
  ;; poliwag appears 1 out of 49
  set sprout? ( 1 + random 49 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 60
        set ptype1 "water"
        common-pokemon
      ]
    ]
  ]
  ;; poliwhirl appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 61
        set ptype1 "water"
        rare-pokemon
      ]
    ]
  ]
  ;; poliwrath appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 62
        set ptype1 "water"
        set ptype2 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; abra appears 1 out of 167
  set sprout? ( 1 + random 167 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 63
        set ptype1 "psychic"
        uncommon-pokemon
      ]
    ]
  ]
  ;; kadabra appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 64
        set ptype1 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; alakazam appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 65
        set ptype1 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; machop appears 1 out of 130
  set sprout? ( 1 + random 130 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 66
        set ptype1 "fighting"
        uncommon-pokemon
      ]
    ]
  ]
  ;; machoke appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 67
        set ptype1 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; machamp appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 68
        set ptype1 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; bellsprout appears 1 out of 37
  set sprout? ( 1 + random 37 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 69
        set ptype1 "grass"
        set ptype2 "poison"
        very-common-pokemon
      ]
    ]
  ]
  ;; weepinbell appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 70
        set ptype1 "grass"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; victreebel appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 71
        set ptype1 "grass"
        set ptype2 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; tentacool appears 1 out of 182
  set sprout? ( 1 + random 182 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 72
        set ptype1 "water"
        set ptype2 "poison"
        uncommon-pokemon
      ]
    ]
  ]
  ;; tentacruel appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 73
        set ptype1 "water"
        set ptype2 "poison"
        rare-pokemon
      ]
    ]
  ]
  ;; geodude appears 1 out of 63
  set sprout? ( 1 + random 63 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 74
        set ptype1 "rock"
        set ptype2 "ground"
        common-pokemon
      ]
    ]
  ]
  ;; graveler appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 75
        set ptype1 "rock"
        set ptype2 "ground"
        rare-pokemon
      ]
    ]
  ]
  ;; golem appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 76
        set ptype1 "rock"
        set ptype2 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; ponyta appears 1 out of 130
  set sprout? ( 1 + random 130 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 77
        set ptype1 "fire"
        uncommon-pokemon
      ]
    ]
  ]
  ;; rapidash appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 78
        set ptype1 "fire"
        very-rare-pokemon
      ]
    ]
  ]
  ;; slowpoke appears 1 out of 261
  set sprout? ( 1 + random 261 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 79
        set ptype1 "water"
        set ptype2 "psychic"
        uncommon-pokemon
      ]
    ]
  ]
  ;; slowbro appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 80
        set ptype1 "water"
        set ptype2 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; magnemite appears 1 out of 200
  set sprout? ( 1 + random 200 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 83 ;; real number is 81
        set ptype1 "electric"
        uncommon-pokemon
      ]
    ]
  ]
  ;; magneton appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 84 ;; real number is 82
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; farfetch'd appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 85 ;; real number is 83
        set ptype1 "normal"
        set ptype2 "flying"
        very-rare-pokemon
      ]
    ]
  ]
  ;; doduo appears 1 out of 11
  set sprout? ( 1 + random 11 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 81 ;; real number is 84 (was causing the graph to overscale)
        set ptype1 "normal"
        set ptype2 "flying"
        very-common-pokemon
      ]
    ]
  ]
  ;; dodrio appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 82 ;; real number is 85
        set ptype1 "normal"
        set ptype2 "flying"
        rare-pokemon
      ]
    ]
  ]
  ;; seel appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 86
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; dewgong appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 87
        set ptype1 "water"
        set ptype2 "ice"
        very-rare-pokemon
      ]
    ]
  ]
  ;; grimer appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 88
        set ptype1 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; muk appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 89
        set ptype1 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; shellder appears 1 out of 300
  set sprout? ( 1 + random 300 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 90
        set ptype1 "water"
        rare-pokemon
      ]
    ]
  ]
  ;; cloyster appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 91
        set ptype1 "water"
        set ptype2 "ice"
        very-rare-pokemon
      ]
    ]
  ]
  ;; gastly appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 92
        set ptype1 "ghost"
        set ptype2 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; haunter appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 93
        set ptype1 "ghost"
        set ptype2 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; gengar appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 94
        set ptype1 "ghost"
        set ptype2 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; onix appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 95
        set ptype1 "rock"
        set ptype2 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; drowzee appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 96
        set ptype1 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; hypno appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 97
        set ptype1 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; krabby appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 98
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; kingler appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 99
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; voltorb appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 100
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; electrode appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 101
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; exeggcute appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 102
        set ptype1 "grass"
        set ptype2 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; exeggutor appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 103
        set ptype1 "grass"
        set ptype2 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; cubone appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 104
        set ptype1 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; marowak appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 105
        set ptype1 "ground"
        very-rare-pokemon
      ]
    ]
  ]
  ;; hitmonlee appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 106
        set ptype1 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; hitmonchan appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 107
        set ptype1 "fighting"
        very-rare-pokemon
      ]
    ]
  ]
  ;; lickitung appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 108
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; koffing appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 109
        set ptype1 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; weezing appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 110
        set ptype1 "poison"
        very-rare-pokemon
      ]
    ]
  ]
  ;; rhyhorn appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 111
        set ptype1 "ground"
        set ptype2 "rock"
        very-rare-pokemon
      ]
    ]
  ]
  ;; rhydon appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 112
        set ptype1 "ground"
        set ptype2 "rock"
        very-rare-pokemon
      ]
    ]
  ]
  ;; chansey appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 113
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; tangela appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 114
        set ptype1 "grass"
        very-rare-pokemon
      ]
    ]
  ]
  ;; kangaskhan appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 115
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; horsea appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 116
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; seadra appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 117
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; goldeen appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 118
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; seaking appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 119
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; staryu appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 120
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; starmie appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 121
        set ptype1 "water"
        set ptype2 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; mr. mime appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 122
        set ptype1 "psychic"
        set ptype2 "fairy"
        very-rare-pokemon
      ]
    ]
  ]
  ;; scyther appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 123
        set ptype1 "flying"
        set ptype2 "bug"
        very-rare-pokemon
      ]
    ]
  ]
  ;; jynx appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 124
        set ptype1 "ice"
        set ptype1 "psychic"
        very-rare-pokemon
      ]
    ]
  ]
  ;; electabuzz appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 125
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; magmar appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 126
        set ptype1 "fire"
        very-rare-pokemon
      ]
    ]
  ]
  ;; pinsir appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 127
        set ptype1 "bug"
        very-rare-pokemon
      ]
    ]
  ]
  ;; tauros appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 128
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; magikarp appears 1 out of 857
  set sprout? ( 1 + random 857 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 129
        set ptype1 "water"
        rare-pokemon
      ]
    ]
  ]
  ;; gyarados appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 130
        set ptype1 "water"
        set ptype2 "flying"
        very-rare-pokemon
      ]
    ]
  ]
  ;; lapras appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 131
        set ptype1 "water"
        set ptype2 "ice"
        very-rare-pokemon
      ]
    ]
  ]
  ;; ditto appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 132
        set ptype1 "normal"
        legendary-pokemon
      ]
    ]
  ]
  ;; eevee appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 133
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; vaporeon appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 134
        set ptype1 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; jolteon appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 135
        set ptype1 "electric"
        very-rare-pokemon
      ]
    ]
  ]
  ;; flareon appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 136
        set ptype1 "fire"
        very-rare-pokemon
      ]
    ]
  ]
  ;; porygon appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 137
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]
  ;; omanyte appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 138
        set ptype1 "rock"
        set ptype2 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; omastar appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 139
        set ptype1 "rock"
        set ptype2 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; kabuto appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 140
        set ptype1 "rock"
        set ptype2 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; kabutops appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 141
        set ptype1 "rock"
        set ptype2 "water"
        very-rare-pokemon
      ]
    ]
  ]
  ;; aerodactyl appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 142
        set ptype1 "rock"
        set ptype2 "flying"
        very-rare-pokemon
      ]
    ]
  ]
  ;; snorlax appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 143
        set ptype1 "normal"
        very-rare-pokemon
      ]
    ]
  ]

  ;; articuno, 144, ice, flying
  ;; zapdos, 145, electric, flying
  ;; moltres, 146, fire, flying

  ;; dratini appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 147
        set ptype1 "dragon"
        very-rare-pokemon
      ]
    ]
  ]
  ;; dragonair appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 148
        set ptype1 "dragon"
        very-rare-pokemon
      ]
    ]
  ]
  ;; dragonite appears 1 out of 6000
  set sprout? ( 1 + random 6000 )
  if sprout? = 1 [
    ask one-of patches [
      sprout-pokemon 1 [
        set number 149
        set ptype1 "dragon"
        set ptype2 "flying"
        special-pokemon
      ]
    ]
  ]

  ;; mewtwo, 150, psychic
  ;; mew, 151, psychic

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SPROUT BY TYPE OF PATCH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to sprout-types
  ;; sets which pokemon (their numbers) are associated with their type (e.g. 1 = bulbasaur)
  set tgrass [ 1 2 3 43 44 45 46 47 69 70 71 102 103 114 ]
  set tfire [ 4 5 6 37 38 58 59 77 78 126 136 ]
  set twater [ 7 8 9 54 55 60 61 62 72 73 79 80 86 87 90 91 98 99 116 117 118 119 120 121 129 130 131 134 138 139 140 141 ]
  set tbug [ 10 11 12 13 14 15 46 47 48 49 123 127 ]
  set tnormal [ 16 17 18 19 20 21 22 39 40 52 53 85 81 82 108 113 115 128 132 133 137 143 ]
  set tpoison [ 1 2 3 13 14 15 23 24 29 30 31 32 33 34 41 42 43 44 45 48 49 69 70 71 72 73 88 89 92 93 94 109 110 ]
  set telectric [ 25 26 83 84 100 101 125 135 ]
  set tground [ 27 28 31 34 50 51 74 75 76 95 104 105 111 112 ]
  set tfairy [ 35 36 39 40 122 ]
  set tfighting [ 56 57 62 66 67 68 106 107 ]
  set tpsychic [ 63 64 65 79 80 96 97 102 103 121 122 124 ]
  set trock [ 74 75 76 95 111 112 138 139 140 141 142 ]
  set tghost [ 92 93 94 ]
  set tice [ 87 91 124 131 ]
  set tdragon [ 147 148 149 ]
  set tflying [ 6 12 16 17 18 21 22 41 42 85 81 82 123 130 142 149 ]

  ;; water sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let waterpatch round ((count patches with [ pcolor = blue ]) / (1 + random (count patches with [ pcolor = blue ])) )
    ask n-of waterpatch patches with [ pcolor = blue ] [
      water-sprout
    ]
  ]
  if sprout? = 2 [
    let waterpatch round ((count patches with [ pcolor = blue ]) / (1 + random (count patches with [ pcolor = blue ])) )
    ask n-of waterpatch patches with [ pcolor = blue ] [
      poison-sprout
    ]
  ]
  if sprout? = 3 [
    let waterpatch round ((count patches with [ pcolor = blue ]) / (1 + random (count patches with [ pcolor = blue ])) )
    ask n-of waterpatch patches with [ pcolor = blue ] [
      ice-sprout
    ]
  ]

  ;; grass sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let grasspatch round ((count patches with [ pcolor = green ]) / (1 + random (count patches with [ pcolor = green ])) )
    ask n-of grasspatch patches with [ pcolor = green ] [
      grass-sprout
    ]
  ]
  if sprout? = 2 [
    let grasspatch round ((count patches with [ pcolor = green ]) / (1 + random (count patches with [ pcolor = green ])) )
    ask n-of grasspatch patches with [ pcolor = green ] [
      bug-sprout
    ]
  ]
  if sprout? = 3 [
    let grasspatch round ((count patches with [ pcolor = green ]) / (1 + random (count patches with [ pcolor = green ])) )
    ask n-of grasspatch patches with [ pcolor = green ] [
      psychic-sprout
    ]
  ]
  if sprout? = 4 [
    let grasspatch round ((count patches with [ pcolor = green ]) / (1 + random (count patches with [ pcolor = green ])) )
    ask n-of grasspatch patches with [ pcolor = green ] [
      flying-sprout
    ]
  ]

  ;; wetland sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let wetlandpatch round ((count patches with [ pcolor = turquoise ]) / (1 + random (count patches with [ pcolor = turquoise ])) )
    ask n-of wetlandpatch patches with [ pcolor = turquoise ] [
      poison-sprout
    ]
  ]

  ;; beach sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let beachpatch round ((count patches with [ pcolor = 28 ]) / (1 + random (count patches with [ pcolor = 28 ])) )
    ask n-of beachpatch patches with [ pcolor = 28 ] [
      ground-sprout
    ]
  ]
  if sprout? = 2 [
    let beachpatch round ((count patches with [ pcolor = 28 ]) / (1 + random (count patches with [ pcolor = 28 ])) )
    ask n-of beachpatch patches with [ pcolor = 28 ] [
      psychic-sprout
    ]
  ]

  ;; concrete sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let concretepatch round ((count patches with [ pcolor = gray ]) / (1 + random (count patches with [ pcolor = gray ])) )
    ask n-of concretepatch patches with [ pcolor = gray ] [
      fire-sprout
    ]
  ]
  if sprout? = 2 [
    let concretepatch round ((count patches with [ pcolor = gray ]) / (1 + random (count patches with [ pcolor = gray ])) )
    ask n-of concretepatch patches with [ pcolor = gray ] [
      normal-sprout
    ]
  ]
  if sprout? = 3 [
    let concretepatch round ((count patches with [ pcolor = gray ]) / (1 + random (count patches with [ pcolor = gray ])) )
    ask n-of concretepatch patches with [ pcolor = gray ] [
      ground-sprout
    ]
  ]
  if sprout? = 4 [
    let concretepatch round ((count patches with [ pcolor = gray ]) / (1 + random (count patches with [ pcolor = gray ])) )
    ask n-of concretepatch patches with [ pcolor = gray ] [
      rock-sprout
    ]
  ]

  ;; open space sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      grass-sprout
    ]
  ]
  if sprout? = 2 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      bug-sprout
    ]
  ]
  if sprout? = 3 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      ground-sprout
    ]
  ]
  if sprout? = 4 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      psychic-sprout
    ]
  ]
  if sprout? = 5 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      ghost-sprout
    ]
  ]
  if sprout? = 6 [
    let openspacepatch round ((count patches with [ pcolor = lime ]) / (1 + random (count patches with [ pcolor = lime ])) )
    ask n-of openspacepatch patches with [ pcolor = lime ] [
      flying-sprout
    ]
  ]

  ;; landmarks sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let landmarkpatch round ((count patches with [ pcolor = brown ]) / (1 + random (count patches with [ pcolor = brown ])) )
    ask n-of landmarkpatch patches with [ pcolor = brown ] [
      fairy-sprout
    ]
  ]
  if sprout? = 2 [
    let landmarkpatch round ((count patches with [ pcolor = brown ]) / (1 + random (count patches with [ pcolor = brown ])) )
    ask n-of landmarkpatch patches with [ pcolor = brown ] [
      dragon-sprout
    ]
  ]

  ;; power plant sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let powerplantpatch round ((count patches with [ pcolor = yellow ]) / (1 + random (count patches with [ pcolor = yellow ])) )
    ask n-of powerplantpatch patches with [ pcolor = yellow ] [
      electric-sprout
    ]
  ]

  ;; hospital sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let hospitalpatch round ((count patches with [ pcolor = white ]) / (1 + random (count patches with [ pcolor = white ])) )
    ask n-of hospitalpatch patches with [ pcolor = white ] [
      psychic-sprout
    ]
  ]

  ;; gym sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let gympatch round ((count patches with [ pcolor = violet ]) / (1 + random (count patches with [ pcolor = violet ])) )
    ask n-of gympatch patches with [ pcolor = violet ] [
      fighting-sprout
    ]
  ]

  ;; cinema sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let cinemapatch round ((count patches with [ pcolor = sky ]) / (1 + random (count patches with [ pcolor = sky ])) )
    ask n-of cinemapatch patches with [ pcolor = sky ] [
      ghost-sprout
    ]
  ]

  ;; house of worship sprout
  set sprout? ( 1 + random 100 )
  if sprout? = 1 [
    let houseofworshippatch round ((count patches with [ pcolor = red ]) / (1 + random (count patches with [ pcolor = red ])) )
    ask n-of houseofworshippatch patches with [ pcolor = red ] [
      fairy-sprout
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; POKEMON TYPES FOR SPROUT BY TYPE OF PATCH + ATTRIBUTION OF SOME CHARACTERISTICS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; grass type pokemon
to grass-sprout
  sprout-pokemon 1 [
    set number one-of tgrass
    ifelse number != 46 and number != 47 [ set ptype1 "grass" ] [ set ptype1 "bug" ]
    if number != 46 or number != 47 or number != 102 or number != 103 or number != 114 [ set ptype2 "poison" ]
    if number = 46 or number = 47 [ set ptype2 "grass" ]
    if number = 102 or number = 103 [ set ptype2 "psychic" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 54 or number = 60 [
      common-pokemon
    ]
    if number = 7 or number = 72 or number = 79 [
      uncommon-pokemon
    ]
    if number = 8 or number = 55 or number = 61 or number = 73 or number = 90 or number = 129 [
      rare-pokemon
    ]
    if number = 62 or number = 80 or number = 86 or number = 87 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; fire type pokemon
to fire-sprout
  sprout-pokemon 1 [
    set number one-of tfire
    set ptype1 "fire"
    if number = 6 [ set ptype2 "flying" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 58 [
      common-pokemon
    ]
    if number = 4 or number = 77 [
      uncommon-pokemon
    ]
    if number = 5 or number = 37 or number = 129[
      rare-pokemon
    ]
    if number = 38 or number = 59 or number = 78 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; water type pokemon
to water-sprout
  sprout-pokemon 1 [
    set number one-of twater
    ifelse number != 138 or number != 139 or number != 140 or number != 141 [ set ptype1 "water" ] [ set ptype1 "rock" set ptype2 "water" ]
    if number = 62 [ set ptype2 "fighting" ]
    if number = 72 or number = 73 [ set ptype2 "poison" ]
    if number = 79 or number = 80 or number = 121 [ set ptype2 "psychic" ]
    if number = 87 or number = 91 or number = 131 [ set ptype2 "ice" ]
    if number = 130 [ set ptype2 "flying" ]
    if number = 13 or number = 23 or number = 32 or number = 41 or number = 48 or number = 69 [
      very-common-pokemon
    ]
    if number = 1 or number = 29 or number = 42 or number = 43 [
      common-pokemon
    ]
    if number = 14 or number = 72 [
      uncommon-pokemon
    ]
    if number = 15 or number = 24 or number = 30 or number = 33 or number = 44 or number = 49 or number = 70 or number = 73 or number = 129 [
      rare-pokemon
    ]
    if number = 31 or number = 34 or number = 45 or number = 71 or number = 88 or number = 89 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; bug type pokemon
to bug-sprout
  sprout-pokemon 1 [
    set number one-of tbug
    set ptype1 "bug"
    if number = 12 or number = 123 [ set ptype2 "flying" ]
    if number = 13 or number = 14 or number = 15 or number = 48 or number = 49 [ set ptype2 "poison" ]
    if number = 46 or number = 47 [ set ptype2 "grass" ]
    if number = 10 or number = 13 or number = 46 or number = 48 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 14 [
      uncommon-pokemon
    ]
    if number = 11 or number = 15 or number = 47 or number = 49 or number = 129 [
      rare-pokemon
    ]
    if number = 12 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; normal type pokemon
to normal-sprout
  sprout-pokemon 1 [
    set number one-of tnormal
    set ptype1 "normal"
    if number = 16 or number = 17 or number = 18 or number = 21 or number = 22 or number = 85 or number = 81 or number = 82 [ set ptype2 "flying" ]
    if number = 39 or number = 40 [ set ptype2 "fairy" ]
    if number = 16 or number = 19 or number = 21 or number = 81 [
      very-common-pokemon
    ]
    if number = 17 [
      common-pokemon
    ]
    if number = 18 or number = 20 or number = 39 or number = 52 [
      uncommon-pokemon
    ]
    if number = 22 or number = 53 or number = 82 or number = 129 [
      rare-pokemon
    ]
    if number = 40 or number = 85 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; poison type pokemon
to poison-sprout
  sprout-pokemon 1 [
    set number one-of tpoison
    if number = 1 or number = 2 or number = 3 or number = 43 or number = 44 or number = 45 or number = 69 or number = 70 or number = 71 [ set ptype1 "grass" set ptype2 "poison" ]
    if number = 13 or number = 14 or number = 15 or number = 48 or number = 49 [ set ptype1 "bug" set ptype2 "poison" ]
    ;; split these so the line wasn't too long
    if number = 23 or number = 24 or number = 29 or number = 30 or number = 32 [ set ptype1 "poison" ]
    if number = 33 or number = 88 or number = 89 or number = 109 or number = 110 [ set ptype1 "poison" ]
    if number = 72 or number = 73 [ set ptype1 "water" set ptype2 "poison" ]
    if number = 92 or number = 93 or number = 94 [ set ptype1 "ghost" set ptype2 "poison" ]
    if number = 31 or number = 34 [ set ptype1 "poison" set ptype2 "ground" ]
    if number = 41 or number = 42 [ set ptype1 "poison" set ptype2 "flying" ]
    if number = 13 or number = 23 or number = 32 or number = 41 or number = 48 or number = 69 [
      very-common-pokemon
    ]
    if number = 1 or number = 29 or number = 42 or number = 43 [
      common-pokemon
    ]
    if number = 14 or number = 72 [
      uncommon-pokemon
    ]
    if number = 15 or number = 24 or number = 30 or number = 33 or number = 44 or number = 49 or number = 70 or number = 73 or number = 129 [
      rare-pokemon
    ]
    if number = 31 or number = 34 or number = 45 or number = 71 or number = 88 or number = 89 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; electric type pokemon
to electric-sprout
  sprout-pokemon 1 [
    set number one-of telectric
    set ptype1 "electric"
    if number = 200 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 83 [
      uncommon-pokemon
    ]
    if number = 25 or number = 129 [
      rare-pokemon
    ]
    if number = 26 or number = 84 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; ground type pokemon
to ground-sprout
  sprout-pokemon 1 [
    set number one-of tground
    ifelse number != 31 or number != 34 or number != 74 or number != 75 or number != 76 or number != 95 [ set ptype1 "ground" ] [ set ptype2 "ground" ]
    if number = 31 or number = 34 [ set ptype1 "poison" ]
    if number = 74 or number = 75 or number = 76 or number = 95 [ set ptype1 "rock" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 27 or number = 74 [
      common-pokemon
    ]
    if number = 50 [
      uncommon-pokemon
    ]
    if number = 28 or number = 75 or number = 129 [
      rare-pokemon
    ]
    if number = 31 or number = 34 or number = 51 or number = 76 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; fairy type pokemon
to fairy-sprout
  sprout-pokemon 1 [
    set number one-of tfairy
    ifelse number = 35 or number = 36 [ set ptype1 "fairy" ] [ set ptype2 "fairy" ]
    if number = 39 or number = 40 [ set ptype1 "normal" ]
    if number = 122 [ set ptype1 "psychic" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 35 [
      common-pokemon
    ]
    if number = 39 [
      uncommon-pokemon
    ]
    if number = 129 or number = 129 [
      rare-pokemon
    ]
    if number = 36 or number = 40 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; fighting type pokemon
to fighting-sprout
  sprout-pokemon 1 [
    set number one-of tfighting
    ifelse number != 62 [ set ptype1 "fighting" ] [ set ptype1 "water" set ptype2 "fighting" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 56 [
      common-pokemon
    ]
    if number = 66 [
      uncommon-pokemon
    ]
    if number = 200 or number = 129 [
      rare-pokemon
    ]
    if number = 57 or number = 62 or number = 67 or number = 68 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; psychic type pokemon
to psychic-sprout
  sprout-pokemon 1 [
    set number one-of tpsychic
    ifelse number = 63 or number = 64 or number = 65 or number = 96 or number = 97 or number = 122 [ set ptype1 "psychic" ] [ set ptype2 "psychic" ]
    if number = 79 or number = 80 or number = 121 [ set ptype1 "water" ]
    if number = 102 or number = 103 [ set ptype1 "grass" ]
    if number = 124 [ set ptype1 "ice" ]
    if number = 122 [ set ptype2 "fairy" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 63 or number = 79 [
      uncommon-pokemon
    ]
    if number = 200 or number = 129 [
      rare-pokemon
    ]
    if number = 64 or number = 65 or number = 80 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; rock type pokemon
to rock-sprout
  sprout-pokemon 1 [
    set number one-of trock
    if number = 74 or number = 75 or number = 76 or number = 95 [ set ptype1 "rock" set ptype2 "ground" ]
    if number = 138 or number = 139 or number = 140 or number = 141 [ set ptype1 "rock" set ptype2 "water" ]
    if number = 142 [ set ptype1 "rock" set ptype2 "flying" ]
    if number = 111 or number = 112 [ set ptype1 "ground" set ptype2 "rock" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 74 [
      common-pokemon
    ]
    if number = 200 [
      uncommon-pokemon
    ]
    if number = 75 or number = 129 [
      rare-pokemon
    ]
    if number = 76 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; ghost type pokemon
to ghost-sprout
  sprout-pokemon 1 [
    set number one-of tghost
    set ptype1 "ghost"
    set ptype2 "poison"
    if number = 200 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 200 [
      uncommon-pokemon
    ]
    if number = 129 [
      rare-pokemon
    ]
    if number >= 91 and number <= 150 and number != 129 and number != 132 [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; ice type pokemon
to ice-sprout
  sprout-pokemon 1 [
    set number one-of tice
    if number = 87 or number = 91 or number = 131 [ set ptype1 "water" set ptype2 "ice" ]
    if number = 124 [ set ptype1 "ice" set ptype2 "psychic" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 200 [
      uncommon-pokemon
    ]
    if number = 129 [
      rare-pokemon
    ]
    if number = 87 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; dragon type pokemon
to dragon-sprout
  sprout-pokemon 1 [
    set number one-of tdragon
    set ptype1 "dragon"
    if number = 149 [ set ptype2 "flying" ]
    if number = 200 [
      very-common-pokemon
    ]
    if number = 200 [
      common-pokemon
    ]
    if number = 200 [
      uncommon-pokemon
    ]
    if number = 129 [
      rare-pokemon
    ]
    if number >= 91 and number <= 150 and number != 129 and number != 132 [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;; flying type pokemon
to flying-sprout
  sprout-pokemon 1 [
    set number one-of tflying
    if number = 16 or number = 17 or number = 18 or number = 21 or number = 22 or number = 85  or number = 81 or number = 82 [ set ptype1 "normal" ]
    if number = 12 or number = 123 [ set ptype1 "bug" ]
    if number = 41 or number = 42 [ set ptype1 "poison" ]
    if number = 6 [ set ptype1 "fire" ]
    if number = 130 [ set ptype1 "water" ]
    if number = 142 [ set ptype1 "rock" ]
    if number = 149 [ set ptype1 "dragon" ]
    set ptype2 [ "flying" ]
    if number = 16 or number = 21 or number = 41 or number = 81 [
      very-common-pokemon
    ]
    if number = 17 or number = 42 [
      common-pokemon
    ]
    if number = 18 [
      uncommon-pokemon
    ]
    if number = 22 or number = 82 [
      rare-pokemon
    ]
    if number = 12 or number = 85 or (number >= 91 and number <= 150 and number != 129 and number != 132) [
      very-rare-pokemon
    ]
    if number = 3 or number = 6 or number = 9 or number = 149 [
          special-pokemon
    ]
    if number = 132 [
         legendary-pokemon
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; FURTHER ATTRIBUTION OF CHARACTERISTICS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to define-pokemon-by-type
  ;; coloring of pokemon
  ask pokemon [
      if ptype1 = "grass" [ set color green ]
      if ptype1 = "fire" [ set color red ]
      if ptype1 = "water" [ set color blue ]
      if ptype1 = "bug" [ set color lime ]
      if ptype1 = "normal" [ set color 7 ]
      if ptype1 = "poison" [ set color violet ]
      if ptype1 = "electric" [ set color yellow ]
      if ptype1 = "ground" [ set color brown ]
      if ptype1 = "fairy" [ set color pink ]
      if ptype1 = "fighting" [ set color orange ]
      if ptype1 = "psychic" [ set color magenta ]
      if ptype1 = "rock" [ set color 2 ]
      if ptype1 = "ghost" [ set color sky ]
      if ptype1 = "ice" [ set color cyan ]
      if ptype1 = "dragon" [ set color white ]
  ]
end

;; the following energy values are arbitrary, but with the decreasing magnitude purposeful

;; very common pokemon traits
to very-common-pokemon
  set energy 70
  set size 1
  set shape "dot"
  set commonness 1
end

;; common pokemon traits
to common-pokemon
  set energy 60
  set size 1
  set shape "x"
  set commonness 2
end

;; uncommon pokemon traits
to uncommon-pokemon
  set energy 50
  set size 1
  set shape "triangle"
  set commonness 3
end

;; rare pokemon traits
to rare-pokemon
  set energy 40
  set size 1
  set shape "square"
  set commonness 4
end

;; very rare pokemon traits
to very-rare-pokemon
  set energy 30
  set size 1
  set shape "pentagon"
  set commonness 5
end

;; special pokemon traits
to special-pokemon
  set energy 20
  set size 1
  set shape "circle"
  set commonness 6
end

;; legendary pokemon traits
;; although only one exists at the moment, this will make adding others easier
to legendary-pokemon
  set energy 10
  set size 1
  set shape "ditto"
  set commonness 7
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; POKEMON MOVEMENT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to move-pokemons
  ask pokemon [
    if number > 0 [
      rt random 360
      fd commonness
      set energy energy - 1
    ]
  ]
end

;; uncaught pokemon
to kill-pokemons
  ask pokemon [
    if energy = 0 [
      ;;set uncaught-pokemon uncaught-pokemon + 1
      die
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; REFERENCES ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This code helped to sprout pokemon at varying rates.
;; Abrahamson, D. and Wilensky, U. (2004). NetLogo Prob Graphs Basic model.
;;   http://ccl.northwestern.edu/netlogo/models/ProbGraphsBasic.
;;   Center for Connected Learning and Computer-Based Modeling,
;;   Northwestern University, Evanston, IL.

;; This code helped to understand how to make trainers catch pokemon.
;; Wilensky, U. (2010). NetLogo Communication T-T Example model.
;;   http://modelingcommons.org/browse/one_model/2278.

;; This code helped to understand how to make trainers actively play.
;; Wilensky, U. (2010). NetLogo Move Towards Target Example model.
;;   http://modelingcommons.org/browse/one_model/2765.

;; This code was often revisited as reference to NetLogo basics and commands
;; Wilensky, U. (1997). NetLogo Wolf Sheep Predation model.
;;   http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation.
;;   Center for Connected Learning and Computer-Based Modeling,
;;   Northwestern University, Evanston, IL.
@#$#@#$#@
GRAPHICS-WINDOW
565
85
985
566
20
-1
10.0
1
10
1
1
1
0
0
0
1
-20
20
-20
24
1
1
1
ticks
30.0

BUTTON
415
490
481
523
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
415
530
557
563
Pokemon-GO-!
Pokemon-Go-!
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
10
400
180
433
Houses-Of-Worship
Houses-Of-Worship
1
135
20
1
1
NIL
HORIZONTAL

TEXTBOX
10
55
160
73
City Setup
11
0.0
1

SLIDER
10
85
182
118
Concrete
Concrete
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
130
182
163
Open-Spaces
Open-Spaces
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
175
182
208
Landmarks
Landmarks
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
264
182
297
Hospitals
Hospitals
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
354
182
387
Cinemas
Cinemas
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
220
182
253
Power-Plants
Power-Plants
1
135
20
1
1
NIL
HORIZONTAL

SLIDER
10
309
182
342
Gyms
Gyms
1
135
20
1
1
NIL
HORIZONTAL

CHOOSER
365
175
555
220
Trainer-Color
Trainer-Color
17 47 57 107
0

SLIDER
365
275
555
308
Number-Of-Rivals
Number-Of-Rivals
0
100
11
1
1
NIL
HORIZONTAL

CHOOSER
365
320
555
365
Rivals-Color
Rivals-Color
12 42 52 102
0

TEXTBOX
8
570
358
716
This model estimates, based on a variety of assumptions, how long it would take to catch every Pokemon and how many of each Pokemon are being caught. This means it isn't estimating how long it would take to fill a Pokedex through other means such as evolving caught Pokemon.\n\nIf someone wanted to include this, it could be done by tracking each caught Pokemon and when a certain number of each Pokemon was caught, it would evolve to the next level and adding an extra count in the Pokedex.
11
0.0
1

TEXTBOX
368
60
518
78
Trainer and Rivals Setup
11
0.0
1

PLOT
1185
875
1705
1025
Total Pokemon Caught by Trainer
ticks
count
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "plot caught-pokemon"

PLOT
1185
15
1705
230
Distribution of Caught Pokemon (1 through 41)
x-coordinate storage location of caught Pokemon
count
0.0
10.0
0.0
10.0
true
false
"set-plot-x-range -21 21\nset-histogram-num-bars 41" ""
PENS
"1-41" 1.0 1 -16777216 true "" "histogram [xcor] of pokemon with [ number = -1 ]"

PLOT
1185
230
1705
445
Distribution of Caught Pokemon (42 through 82*)
x-coordinate storage location of caught Pokemon
count
0.0
10.0
0.0
10.0
true
false
"set-plot-x-range -21 21\nset-histogram-num-bars 41" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [xcor] of pokemon with [ number = -2 ]"

PLOT
1185
445
1705
660
Distribution of Caught Pokemon (83 through 123*)
x-coordinate storage location of caught Pokemon
count
0.0
10.0
0.0
10.0
true
false
"set-plot-x-range -21 21\nset-histogram-num-bars 41" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [xcor] of pokemon with [ number = -3 ]"

PLOT
1185
660
1705
875
Distribution of Caught Pokemon (123 through 151**)
x-coordinate storage location of caught Pokemon
count
0.0
10.0
0.0
10.0
true
false
"set-plot-x-range -21 21\nset-histogram-num-bars 41" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [xcor] of pokemon with [ number = -4 ]"

SLIDER
365
85
555
118
Catch-Radius
Catch-Radius
1
5
2
1
1
NIL
HORIZONTAL

MONITOR
195
85
355
130
Concrete-Check
count patches with [ pcolor = gray ]
17
1
11

MONITOR
195
130
355
175
Open-Spaces-Check
count patches with [ pcolor = lime ]
17
1
11

MONITOR
195
175
355
220
Landmarks-Check
count patches with [ pcolor = brown ]
17
1
11

MONITOR
195
220
355
265
Power-Plants-Check
count patches with [ pcolor = yellow ]
17
1
11

MONITOR
195
265
355
310
Hospitals-Check
count patches with [ pcolor = white ]
17
1
11

MONITOR
195
310
355
355
Gyms-Check
count patches with [ pcolor = violet ]
17
1
11

MONITOR
195
355
355
400
Cinemas-Check
count patches with [ pcolor = sky ]
17
1
11

MONITOR
195
400
355
445
Houses-Of-Worship-Check
count patches with [ pcolor = red ]
17
1
11

TEXTBOX
194
5
354
80
These numbers will not be exactly what you chose in the city setup, but must be at least 1 in order for the model to run correctly.
11
0.0
1

MONITOR
995
390
1170
435
Number-Of-Tracked-Pokemon
count pokemon with [ alive-number = Track-Which-Pokemon-? ]
17
1
11

INPUTBOX
995
314
1170
374
Track-Which-Pokemon-?
16
1
0
Number

TEXTBOX
994
82
1170
310
At any point during the simulation write a Pokemon's Pokedex number in the green box below to see how many have been caught, then hit tab.\n\nNote: Magnemite = 83, Magneton = 84, Farfetch'd = 85, Doduo = 81, and Dodrio = 82, .\n\nNote: A value of 0 tracks how many Pokemon are available for catching at a given tick.
11
0.0
1

TEXTBOX
490
462
560
536
Placeholder to choose to end Process\n
11
0.0
1

TEXTBOX
565
575
705
871
Patches Legend\n\n\nLeft side: Grass\nRight side: Water\nTop side: Wetland\nBottom side: Beach\n\nGray: Concrete\nLime: Open Spaces\nBrown: Landmarks\nYellow: Power Plants\nWhite: Hospitals\nViolet: Gyms\nSky: Cinemas\nRed: House of Worship
11
0.0
1

TEXTBOX
705
574
835
739
Pokemon Shape Legend\n\n\nDot: Very Common\nX: Common\nTriangle: Uncommon\nSquare: Rare\nPentagon: Very Rare\nCircle: Special\nBlob: Legendary (Ditto)
11
0.0
1

TEXTBOX
861
574
991
883
Pokemon Color Legend\nPrimary Types\n\nGreen: Grass\nRed: Fire\nBlue: Water\nLime: Bug\nDark Gray: Normal\nViolet: Poison\nYellow: Electric\nBrown: Ground\nPink: Fairy\nOrange: Fighting\nMagenta: Psychic\nLight Gray: Rock\nSky: Ghost\nCyan: Ice\nWhite: Dragon\n
11
0.0
1

TEXTBOX
565
30
985
91
Pokemon line up according to their Pokedex number. Number 1 (Bulbasaur) is found at the the top left. Going from left to right they line up in increasing order. At the end of the line they drop down and start again from the left.
11
0.0
1

TEXTBOX
1710
230
1925
390
* Due to the higher basic frequency of Doduo (Pokemon 83), I changed Dodouo's and Dodrio's numbers to 81 and 82 respectively to move them to a different graph.\n\nMagnemite, Magneton, and Farfetch'd each increased their numbers by 2 to be 83, 84, and 85, respectively.
11
0.0
1

TEXTBOX
1710
660
1925
760
** Some legendary Pokemon have yet to be seen and so are not included in this simulation. They are Articuno (144), Zapdos (145), Moltres (146), Mewtwo (150), and Mew (151).
11
0.0
1

SLIDER
365
130
555
163
Pokemon-Radar-Distance
Pokemon-Radar-Distance
1
10
6
1
1
NIL
HORIZONTAL

SWITCH
365
230
555
263
Trainer-Actively-Searches
Trainer-Actively-Searches
1
1
-1000

SWITCH
365
375
555
408
Rivals-Actively-Search
Rivals-Actively-Search
1
1
-1000

TEXTBOX
365
415
515
490
Trainer and Rival Colors\n12 and 17: Red\n42 and 47: Yellow\n52 and 57: Green\n102 and 107: Blue
11
0.0
1

TEXTBOX
1710
15
1920
196
Bulbasaur, Pokemon #1, is located at patch -21, 24, therefore -21 on the x-axis of the graph represents the number of Bulbasaur. Pokemon #2 is the next patch and so on until the end of the row, then the numbering continues on the row below from left to right in the same way and carries into the next graph.\n\n
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

ditto
false
0
Circle -7500403 true true 180 165 120
Circle -7500403 true true 14 60 90
Circle -7500403 true true 15 165 120
Circle -7500403 true true 208 48 94
Circle -7500403 true true 104 30 90
Rectangle -7500403 true true 60 105 240 240

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

trainer
false
2
Rectangle -7500403 true false 123 76 176 95
Polygon -1 true false 105 90 60 195 90 210 115 162 184 163 210 210 240 195 195 90
Polygon -955883 true true 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Circle -7500403 true false 110 5 80
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -955883 true true 180 90 195 90 195 165 195 195 150 195 150 120 180 90
Polygon -955883 true true 120 90 105 90 105 165 105 195 150 195 150 120 120 90
Rectangle -16777216 true false 135 114 150 120
Rectangle -16777216 true false 135 144 150 150
Rectangle -16777216 true false 135 174 150 180
Polygon -955883 true true 105 42 111 16 128 2 149 0 178 6 190 18 192 28 220 29 216 34 201 39 167 35
Circle -2674135 true false 30 165 60
Line -16777216 false 30 195 90 195
Circle -1 true false 52 187 16

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

wolf 3
false
0
Polygon -7500403 true true 105 180 75 180 45 75 45 0 105 45 195 45 255 0 255 75 225 180 195 180 165 300 135 300 105 180 75 180
Polygon -16777216 true false 225 90 210 135 150 90
Polygon -16777216 true false 75 90 90 135 150 90

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
