breed [students student]
breed [teachers teacher]
breed [dialogs dialog]

;current functionality:
;teacher asks answers, students give answers, teacher clarifies

globals [
  rows
  columns 
  student-color ;base color of the students
  high-clarity ;how high of clarity something has to be before clear
  correct-idea ;denotes which idea is correct
  change-idea ;how likely students are to change idea when asked challenging questions
  random-report
  ;counts for reports
  student-student-dialog
  student-teacher-dialog
  open-questions-count
  probing-questions-count
  more-questions-count
  evaluations-count
  advancing-questions-count
  recruiting-questions-count
  explanations-count
]

students-own [
  idea ; what idea you have
  participation ; how willing you are to participate
  respond ;how likely you are to respond to other students
  clarity ; how clear your ideas are
  explanation ; how in depth you explain
  questioning ; how likely you are to ask questions 
              ; students only ask probing questions
  speaker? ; 1 if they are speaking   
  name ; give the student a name 
  student? ;whether they are a student       
]

teachers-own [
  info-question ; how likely you are to ask information questions
  probe-question ; how likely you are to ask probing questions
  more-question ; how likely you are to ask generating questions
  evaluate ; how likely you are to evaluate student ideas
  advancing ; how likely you are to push student ideas further
  recruit ; how likely you are to get students to ask others questions
  explain ; how likely you are to explain ideas to students
  student? ;whether they are a student
]

dialogs-own [
  category ; what type of thing is said
  student? ; did a student say it
  sayer ; agent who said it
  target ; who the thing is targeted at (not always someone)
  text ; the words it is
  last-idea ; what student idea was discussed last
]

to setup
  clear-all
  reset-ticks
  ;set globals
  set rows 5
  set columns 6
  set high-clarity 50 
  set student-color 50
  set correct-idea 3 ;set which idea is correct
  set change-idea 30 ;30 percent chance of changing ideas
  set student-student-dialog 0
  set student-teacher-dialog 0
  set open-questions-count 0
  set probing-questions-count 0
  set more-questions-count 0
  set evaluations-count 0
  set advancing-questions-count 0
  set recruiting-questions-count 0
  set explanations-count 0
  ;create rows of students
  let yrepeat 3
  let xrepeat 3
  let yoffset 4
  let xoffset -11
  let student-count 0
  repeat rows [
    repeat columns [ create-students 1 [ ;put them into 'desk' formation
    set shape "person"
    set ycor (yrepeat + yoffset)
    set xcor (xrepeat + xoffset)
    set xrepeat (xrepeat + 3)
    set idea random 4
    set participation ((Average-participation - 20) + random 40)
    set explanation ((Average-explanation - 20) + random 40)
    set questioning ((Average-questioning - 20) + random 20)
    set respond ((Average-responding - 20) + random 20)
    set clarity random 100
    set speaker? 0
    set student? 1
    set size 2
    set name (word student-count)
    set student-count student-count + 1
    ;sets the color of the turtles according to participation level 
    set color scale-color student-color (participation + 10) 0 100 
    ]
  ]
    set yrepeat (yrepeat - 3)
    set xrepeat 3
  ]
  ;give students ideas
  label-by-idea
  ;make the teacher
  create-teachers 1 [
    set ycor (yoffset + 6)
    set xcor (xoffset + 2 * columns - 1) 
    set shape "face happy"
    set color 15
    set size 2
    set info-question Info-questions
    set probe-question Clarifying-questions
    set more-question Generating-questions
    set evaluate Evaluation
    set advancing Advancing-questions
    set recruit Encourage-student-talk
    set explain Give-explanations
    set student? 0
  ]
  ;make the dialog
  create-dialogs 1 [
    set ycor 14
    set xcor 14
    set color 0
    set shape "dot"
    set target "nobody"
    set category "nothing"
  ]
end

to go
;  ask dialogs [set label-color white]
  ifelse all? dialogs [category = "nothing"]
  [teacher-ask-question] [
    ifelse all? dialogs [category = "probe-question"]
    [student-clarify] [
      ifelse all? dialogs [category = "question"]
      [answer-question] [
        ifelse all? dialogs [category = "student-request"]
        [student-request] [
          ifelse all? dialogs [category = "targeted-question"]
          [targeted-response] [
            ifelse all? dialogs [category = "idea"]
            [respond-idea] [
              stop]
          ]
        ]
      ]
    ]
  ]
  label-by-idea
  tick
end

to answer-question
  ifelse all? dialogs [student? = 0]
  [student-answer-question]
  [teacher-answer-question]
end

to respond-idea
  ifelse all? dialogs [student? = 0]
  ;a teacher idea was experssed
  [teacher-ask-question]
  ;a student idea was expressed
  [respond-to-student-idea]
end

to respond-to-student-idea
  ;if the idea is unclear, see if someone will probe it
  ifelse all? dialogs [ [clarity] of sayer < high-clarity]
  ;see if a student will respond to it
    [let responder one-of students with [questioning > random 100 and speaker? = 0 and participation > random 100] ;want to sometimes not get a student
    ;if we get a student to respond, have them probe
      ifelse is-student? responder 
      [probe-student-thinking responder] 
      [low-clarity-teacher-moves]
    ]
  ;if the idea is clear
  ;does a student want to add to the idea
    [let responder one-of students with [respond > random 100 and speaker? = 0 and participation > random 100]
      ifelse is-student? responder 
      [ask dialogs [set target sayer]
        student-to-student responder 
        ]
      ;ask for another idea
      [high-clarity-teacher-moves]
      ]
end

to low-clarity-teacher-moves
  ;see if we can recruit a student to probe
  ifelse all? teachers [recruit > random 100]
    [recruit-student]
  ;otherwise see if the teacher will probe
    [probing-teacher-moves]
end

to probing-teacher-moves
  ifelse all? teachers [probe-question > random 100] 
    [probe-student-thinking one-of teachers] 
  ;if no probing, either ask for another idea or evaluate current idea
    [ifelse all? teachers [more-question > random 100] 
      [generate-student-idea] 
    ;do we evaluate the idea?
      [ifelse all? teachers [evaluate > random 100] 
        [eval-wrong]
        [no-eval]
      ]
    ]
end

to high-clarity-teacher-moves
  ifelse all? teachers [more-question > random 100]
    [generate-student-idea]
  ;is it correct?
    [ifelse all? dialogs [ [idea] of sayer = correct-idea]
      [correct-teacher-moves]  
    ;wrong: recruit or 
      [wrong-teacher-moves]
    ]
end

to correct-teacher-moves
  ;are we going to push student thinking further 
  ifelse all? teachers [advancing > random 100]
    [push-student-idea one-of teachers]
  ;are we going to explain the right answer
    [ifelse all? teachers [explain > random 100]
      [teacher-explains]
    ;are we going to evaluate?
      [ifelse all? teachers [evaluate > random 100]
        ;if the idea is correct, eval-correct
        [eval-correct]
      ;otherwise don't evaluate the idea
        [no-eval]
      ]
    ]
end  

to wrong-teacher-moves
  ifelse all? teachers [recruit > random 100]
    [recruit-student]
    [no-recruit-wrong-teacher-moves]
end

to no-recruit-wrong-teacher-moves
  ifelse all? teachers [advancing > random 100]
    [push-student-idea one-of teachers]
    [ifelse all? teachers [explain > random 100]
      [teacher-explains]
      [ifelse all? teachers [evaluate > random 100]
        ;if the idea is wrong, eval-wrong ;ifelse all? dialogs [ [idea] of sayer = 3]  
        [eval-wrong]
      ;otherwise don't evaluate the idea
        [no-eval]
      ]
    ]
end

to student-request
  ifelse all? dialogs [ [clarity] of target < high-clarity]
  ;see if a student will respond to it
    [let responder one-of students with [questioning + 20 > random 100 and speaker? = 0 and participation > random 100] ;want to sometimes not get a student
    ;if we get a student to respond, have them probe
      ifelse is-student? responder 
      [probe-student-thinking responder]
      ;otherwise see if the teacher will probe
      [probing-teacher-moves]
    ]
  [let responder one-of students with [respond + 20 > random 100 and speaker? = 0 and participation > random 100]
    ifelse is-student? responder
    [student-to-student responder]
    [no-recruit-wrong-teacher-moves]
  ]
end

to student-to-student [responder]
  ;students respond to each other
  ifelse all? dialogs [[idea] of target = [idea] of responder]
  [student-agree responder]
  [ifelse [questioning] of responder > random 100
    [push-student-idea responder]
    [student-disagree responder]
  ]
end

to student-agree [responder]
  ask dialogs [
    set category "idea"
    ifelse is-student? responder
    [set student? 1]
    [set student? 0]
    ask links [die]
    if target != responder [
      ask target [create-link-from responder]
      count-links
    ]
    set target "nobody"
    set sayer responder
    ifelse student? = 1
    [ask students [
      set speaker? 0
    ]
    ask sayer [
      set speaker? 1
    ]
    ]
    [ask students [
      set speaker? 0
    ]
    ]
    set last-idea [idea] of sayer
    set text "I agree"
    set label text
  ]
end

to student-disagree [responder]
    ask dialogs [
    set category "idea"
    ifelse is-student? responder
    [set student? 1]
    [set student? 0]
    ask links [die]
    if target != responder [
      ask target [create-link-from responder]
      count-links
    ]
    set target "nobody"
    set sayer responder
    ifelse student? = 1
    [ask students [
      set speaker? 0
    ]
    ask sayer [
      set speaker? 1
    ]
    ]
    [ask students [
      set speaker? 0
    ]
    ]
    set last-idea [idea] of sayer
    set text (word "I disagree. I think " generate-idea sayer)
    set label text
  ]
end

to push-student-idea [responder]
  ;ask students questions to push understanding forward
  ask dialogs [
    set category "targeted-question"
    ifelse is-student? responder
    [set student? 1]
    [set student? 0
      set advancing-questions-count advancing-questions-count + 1]
    ask links [die]
    ;if the teacher is facilitating, we want link btwn target and responder

    if is-teacher? sayer
    [set sayer target]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    ask students [
      set speaker? 0
    ]
    if is-student? responder
    [ask responder [
      set speaker? 1
    ]
    ]
    set target sayer
    set sayer responder    
    set text (word "What about " generate-question target)
 ;   set label-color red
    set label text
  ]
end

to recruit-student
  ;get student to ask advancing question
  ask dialogs [
    set category "student-request"
    set recruiting-questions-count recruiting-questions-count + 1
    set student? 0
    let responder one-of teachers
;    let participation-level random 100
;    ifelse any? students with [participation > participation-level and speaker? = 0] 
;    [set target one-of students with [participation > participation-level and speaker? = 0]]
;    [set target max-one-of students [participation]]
    set target sayer
;we want to keep the speaker the same
;    ask students [
;      set speaker? 0
;    ]
    ask links [die]
;    if sayer != responder [
;      ask target [create-link-from responder]
;    ]
    set sayer responder    
    set text (word "Does anyone have a question or reply to " [name] of target "'s comment?"
      )
    set label text
  ]
end

to teacher-explains
  ;teacher explains math idea
  ask dialogs [
    set explanations-count explanations-count + 1
    set student? 0
    let responder one-of teachers
    ask links [die]
    ask students [
      set speaker? 0
    ]
    let explained-idea last-idea
    ask students with [idea = explained-idea] [ 
      raise-clarity 10
    ]
    set sayer responder
    set category "idea"
    set target "nobody"
    set text "Teacher explanation" ;include idea
    set label text
  ]
end

to targeted-response
  ask dialogs [
    set student? 1
    let responder target
    set category "idea"
    ask links [die]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set sayer responder
    ask students [
      set speaker? 0
    ]
    ask sayer [
      set speaker? 1
    ]
    set target "nobody"
    let change-level random 100
    ifelse change-idea > change-level and [idea] of sayer != correct-idea
    [ask sayer [
      set idea correct-idea
      set clarity random 100
    ]
    set text (word "I change my mind. " generate-idea responder)]
    [set text generate-idea sayer]
    set last-idea [idea] of sayer  
    set label text
  ]
end
    
to teacher-ask-question
  ask dialogs [
    set open-questions-count open-questions-count + 1
    set student? 0
    let responder one-of teachers
    if is-agent? sayer [
      ask links [die]
      if sayer != responder [
        ask sayer [create-link-from responder]
        count-links
      ]
    ]
    set sayer responder
    ask students [
      set speaker? 0
    ]
    set category "question"
    set target "nobody"
    set text "Teacher Question"
    set label text
  ]
end

to teacher-answer-question
end

to student-answer-question
  ;if the student 
  ask dialogs [
   ;I want the students with more participation to be more likely to be called on
   let responder one-of students with [participation > random 100]
   ;if we don't get any students with participation high enough, use one with highest
   if not is-student? responder
   [set responder max-one-of students [participation]]
   ;if we had a specific student in mind
   if is-student? target
   [set responder target]
   set student? 1
   ask links [die]
   if sayer != responder [
     ask sayer [create-link-from responder]
     count-links
   ]
   set sayer responder
   ask students [
     set speaker? 0
   ]
   ask sayer [
     set speaker? 1
   ]
   set target "nobody"
   set category "idea"
   set last-idea [idea] of sayer  
   set text generate-idea sayer
   set label text
  ]    
end

to probe-student-thinking [responder]
  ask dialogs [
    set category "probe-question"
    ifelse is-student? responder
    [set student? 1]
    [set student? 0
      set probing-questions-count probing-questions-count + 1]
    if is-student? target
    [set sayer target]
    ask sayer [
      raise-participation 10
    ]
    ask links [die]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set target sayer
    set sayer responder
    ifelse is-student? sayer
    [ask students [
      set speaker? 0
    ]
    ask sayer [
      set speaker? 1
    ]
    ]
    [ask students [
      set speaker? 0
    ]
    ]
    set text "What did you mean?"
    set label text
  ]
end

to student-clarify
  ask dialogs [
    set category "idea"
    set student? 1
    let responder target
    set target "nobody"
    ask links [die]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set sayer responder
    ask students [
      set speaker? 0
    ]
    ask sayer [
      set speaker? 1
    ]
    set last-idea [idea] of sayer  
    set text (word generate-idea responder " - clarity")
    ask responder [
      raise-clarity 10
    ]
    set label text
  ]
end

to generate-student-idea
  ask dialogs [
    set category "question"
    set more-questions-count more-questions-count + 1
    set student? 0
    let responder one-of teachers
    let participation-level random 100
    ifelse any? students with [participation > participation-level and speaker? = 0] 
    [set target one-of students with [participation > participation-level and speaker? = 0]]
    [set target max-one-of students with [speaker? = 0] [participation]]
    ask students [
      set speaker? 0
    ]
    ask links [die]
    if sayer != responder [
      ask target [create-link-from responder]
      count-links
    ]
    set sayer responder    
    set text (word "What did you think " [name] of target "?"
      )
    set label text
  ]
end

to no-eval
  ask dialogs [
    set category "idea"
    set student? 0
    let responder one-of teachers
    ask links [die]
    ask students [
      set speaker? 0
    ]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set sayer responder
    set target "nobody"
    set text "Interesting"
    set label text
  ]
end

to eval-correct ;teacher saying an idea is correct
  ask dialogs [
    set category "idea"
    set evaluations-count evaluations-count + 1
    set student? 0
    let eval-idea [idea] of sayer
    ask students with [idea = eval-idea] [ ;ask sayer [
      raise-participation 10
    ]
    let responder one-of teachers
    ask links [die]
    ask students [
      set speaker? 0
    ]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set sayer responder
    set target "nobody"
    set text "Good!"
    set label text
  ]
end

to eval-wrong ;teacher saying an idea is wrong
  ask dialogs [
    let eval-idea last-idea
    ask sayer [
      lower-participation 30
    ]
    ask sayer [ask other students with [idea = eval-idea] [ ;how do I make it not the sayer student? ;ask sayer [
      lower-participation 10
    ]
    ]
    let responder one-of teachers
    ask links [die] 
    ask students [
      set speaker? 0
    ]
    if sayer != responder [
      ask sayer [create-link-from responder]
      count-links
    ]
    set category "idea"
    set evaluations-count evaluations-count + 1
    set student? 0
    set sayer responder
    set target "nobody"
    set text "You're wrong!"
    set label text
  ]
end

to-report generate-idea [responder]
  if [idea] of responder = 0
    [report "Student response A"]
  if [idea] of responder = 1
    [report "Student response B"]    
  if [idea] of responder = 2
    [report "Student response C"]
  if [idea] of responder = 3
    [report "Student response D"]
  if [idea] of responder = 4
    [report "Student response E"]
end

to-report generate-question [recipient]
  if [idea] of recipient = 0
    [report "Question for response A"]
  if [idea] of recipient = 1
    [report "Question for response B"]    
  if [idea] of recipient = 2
    [report "Question for response C"]
  if [idea] of recipient = 3
    [report "Question for response D"]
  if [idea] of recipient = 4
    [report "Question for response E"]
end

to raise-clarity [amount]
  ifelse clarity < 100 - amount
  [set clarity (clarity + amount)]
  [set clarity 100]
end

to raise-participation [amount]
  ifelse participation < 100 - amount
    [set participation (participation + amount)]
    [set participation 100]
  set color scale-color student-color (participation + 10) 0 100
end

to lower-participation [amount]
  ifelse participation > amount
    [set participation (participation - amount)]
    [set participation 0]
  set color scale-color student-color (participation + 10) 0 100
end

to label-by-idea
  ask students [
    if idea = 0
      [set label "A"]
    if idea = 1
      [set label "B"]
    if idea = 2
      [set label "C"]
    if idea = 3
      [set label "D"]
    if idea = 4
      [set label "E"]
  ]
end

to count-links
  ask links [
    ifelse all? both-ends [student? = 1]
    [set student-student-dialog student-student-dialog + 1]
    [set student-teacher-dialog student-teacher-dialog + 1]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
212
10
651
444
16
15
13.0
1
10
1
1
1
0
1
1
1
-16
16
-15
15
1
1
1
ticks
30.0

BUTTON
4
166
70
199
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
75
166
138
199
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
653
162
853
294
Participation
Participation
Students
0.0
100.0
0.0
5.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [participation] of students"

SLIDER
20
22
205
55
Average-participation
Average-participation
20
80
20
1
1
NIL
HORIZONTAL

SLIDER
20
56
204
89
Average-explanation
Average-explanation
00
50
0
1
1
NIL
HORIZONTAL

SLIDER
20
91
205
124
Average-questioning
Average-questioning
0
75
0
1
1
NIL
HORIZONTAL

SLIDER
19
220
191
253
Info-questions
Info-questions
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
19
254
200
287
Clarifying-questions
Clarifying-questions
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
19
322
208
355
Generating-questions
Generating-questions
0
100
0
1
1
NIL
HORIZONTAL

TEXTBOX
19
205
169
223
Teacher controls
11
0.0
1

SLIDER
19
390
191
423
Evaluation
Evaluation
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
20
125
202
158
Average-responding
Average-responding
0
75
0
1
1
NIL
HORIZONTAL

PLOT
653
10
853
160
Student Ideas
Ideas
Students
-1.0
5.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "histogram [idea] of students"

MONITOR
696
342
804
387
NIL
random-report
17
1
11

TEXTBOX
23
5
185
33
Average Student Parameters
11
0.0
1

SLIDER
19
288
206
321
Advancing-questions
Advancing-questions
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
19
356
201
389
Encourage-student-talk
Encourage-student-talk
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
20
424
192
457
Give-explanations
Give-explanations
0
100
0
1
1
NIL
HORIZONTAL

BUTTON
143
166
208
199
Step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
67
466
414
660
Types of dialog
Ticks
Instances
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Student and Student" 1.0 0 -13345367 true "" "plot student-student-dialog"
"Teacher and Student" 1.0 0 -2674135 true "" "plot student-teacher-dialog"

PLOT
441
445
808
672
Teacher Talk
Ticks
Instances
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Open Questions" 1.0 0 -5825686 true "" "plot open-questions-count"
"Probing Questions" 1.0 0 -13345367 true "" "plot probing-questions-count"
"Advancing Questions" 1.0 0 -4079321 true "" "plot advancing-questions-count"
"Ask Specific Students" 1.0 0 -2674135 true "" "plot more-questions-count"
"Facilitate Student Talk" 1.0 0 -10899396 true "" "plot recruiting-questions-count"
"Evaluations" 1.0 0 -955883 true "" "plot evaluations-count"
"Explanations" 1.0 0 -11221820 true "" "plot explanations-count"

@#$#@#$#@
## WHAT IS IT?

This is a model of discourse in a mathematics classroom. The model is based off of the math-talk learning community framework from Hufferd-Ackles et al. (2004). 

## HOW IT WORKS

The model shows a classroom with a number of students (shown as people), and a teacher (shown as the red smiley face). The dialog is shown at the top of the screen. At each tick, someone adds a piece of dialog to the discussion. What and who talks is based on what was previously said, along with the parameters that you can see to the side of the model. When someone in the model responds to a person's comment or directs their comment at a person, an arrow from the speaker is shown.

The students in the model are colored according to how willing they are to participate in the discussion. Students with darker colors are less likely to participate, and students with lighter colors are more likely to participate. The idea the student has (either idea A, B, C, or D) is shown to their right. 

## HOW TO USE IT

To set up the the class, click the setup button. The classroom discussion starts after the go button is clicked. You can also click the step button to advance one turn at a time. You can change the characteristics of the teacher and the students using the sliders on the left. Changing them after the setup will not change the model.

###STUDENT CONTROLS
There are three student characteristics that can be changed, participation, questioning, and responding. Each student is given a random value for these characteristics, and the average is centered around the value of the slider. The values that students are given correspond to what percentage of the time they would be willing to do each act (either participate, question another student, and respond to another student's idea). For example, if an individual student has a value of 5 for participation, 5% of the time they would be willing to participate.

###TEACHER CONTROLS
There are controls for four types of questions teachers can ask and two types of ideas teachers can say:

Probing Questions - Ask a student to clarify unclear ideas
Advancing Questions - Ask questions that challenge or further a students' idea
Generating Questions - Ask specific students to share their idea
Encouraging Student Talk Questions - Asking if students have any questions or comments for the current speaker
Evaluation - Evaluating student ideas
Explanations - Giving explanations of mathematics ideas

The value of each of the sliders corresponds to what percent of the time the teacher will do the action when given the opportunity. 

###GRAPHS

You will notice several graphs. The histograms show the distribution of the different participation of students and the different ideas they have. The graph at the bottom shows the number of things that are said that are between a teacher and a student (red) and between students (blue). The next graph shows the type of things the teacher says, including:

Pink - Open questions
Dark Blue - Probing Questions
Red - Asking specific students for their ideas (generating more ideas in the discussion)
Yellow - Advancing questions
Green - Facilitation of student-to-student talk
Orange - Evaluations
Light Blue - Explanations

## THINGS TO NOTICE

What happens to students' participation when the teacher tells them a student is correct?
What happens to students' participation when the teacher tells them a student is wrong?
What happens to students' participation when a student is asked for clarification?

## THINGS TO TRY

Start by playing around with the model. 

Try creating each of the four levels of the math-talk learning community. For each level record how you set each of the parameters and answer the following questions:
- What evidence do you have from the model that you have set the parameters correctly to achieve the desired level?
- What is the general behavior of the students in this set-up?
- What is the general behavior of the teacher in this set-up?
- How is this result different than the framework level?
- In what ways does this set-up seem similar to your classroom?
- In what ways does this set-up seem different from your classroom?

## EXTENDING THE MODEL

An extension of the model replaces you as the teacher of the class. Whenever a decision about what teacher action should be made comes up, you will be able to choose what to do. 

## CREDITS AND REFERENCES

Created by Elizabeth
(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
