globals [trees]  ;; keep track of how many trees there are
;; Blue Longneck Bluebles, Green Longneck Bluebles and Yeeblows are all breeds of turtle.

breed [bluelongneckbluebles bluelongneckblueble] 
breed [greenlongneckbluebles greenlongneckblueble] 
breed [yeeblows yeeblow]
turtles-own [energy]       ;;delete
patches-own [countdown]

to setup
  clear-all
  ask patches [ set pcolor 64 ]
    ask patches [
      set countdown random 10 ;; initialize trees grow clocks randomly
      set pcolor one-of [64 white] ;; green or white
    ]
 
   set-default-shape bluelongneckbluebles "longneck blueble"
  create-bluelongneckbluebles initial-number-bluelongneckbluebles  ;; create the blue longneck bluebles, then initialize their variables
  [
    set color 105 ;; blue
    set size 7  ;; easier to see    
    set energy random 2
    setxy random-xcor random-ycor
  ]
   set-default-shape greenlongneckbluebles "longneck blueble"
  create-greenlongneckbluebles initial-number-greenlongneckbluebles  ;; create the green longneck bluebles, then initialize their variables
  [
    set color 64 ;; green
    set size 7  ;; easier to see    
    set energy random 2
    setxy random-xcor random-ycor
  ]
  set-default-shape yeeblows "yeeblow"
  create-yeeblows initial-number-yeeblows  ;; create the yeeblows, then initialize their variables
  [
    set color yellow 
    set size 7  ;; easier to see
    set energy random 50
    setxy random-xcor random-ycor
  ]
  set trees count patches with [pcolor = 64]
  reset-ticks
end

to go
  if not any? turtles [ stop ]
   ask bluelongneckbluebles [
    move
      set energy energy - 1  ;; deduct energy for bluelongneckbluebles 
      eat-trees
    death
    reproduce-bluelongneckbluebles
  ]
  ask greenlongneckbluebles [
    move
      set energy energy - 1  ;; deduct energy for greenlongneckbluebles
      eat-trees
    death
    reproduce-greenlongneckbluebles
  ]
  ask yeeblows [
    move
    set energy energy - 1  ;; yeeblows lose energy as they move
    catch-bluelongneckbluebles ;; yeeblows eat only blue longneck bluebles
    death
    reproduce-yeeblows
  ]
  ask patches [ grow-trees ] 
  set trees count patches with [pcolor = 64] ;; green
  tick
end

to move  ;; turtle procedure
  rt random 50
  lt random 50
  fd 1
end

to eat-trees  ;; bluebles procedure
  ;; bluebles eat trees, turn the patch white
  if pcolor = 64 [ ;; green
    set pcolor white 
    set energy energy + 2 ;; bluebles gain energy by eating
  ]
end

to reproduce-bluelongneckbluebles  ;; bluelongneckbluebles procedure
  if random-float 100 < bluebles-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)                ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd 1 ]   ;; hatch an offspring and move it forward 1 step
  ]
end

to reproduce-greenlongneckbluebles  ;; greenlongneckbluebles procedure
  if random-float 100 < bluebles-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)                ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd 1 ]   ;; hatch an offspring and move it forward 1 step
  ]
end

to reproduce-yeeblows  ;; yeeblow procedure
  if random-float 100 < yeeblows-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)               ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd 1 ]  ;; hatch an offspring and move it forward 1 step
  ]
end

to catch-bluelongneckbluebles  ;; yeeblow procedure
  let prey one-of bluelongneckbluebles-here     ;; grab a random bluelongneckblueble
  if prey != nobody                             ;; did we get one?  if so,
    [ ask prey [ die ]                          ;; kill it
      set energy energy + 100 ]                 ;; get energy from eating
end

to death  ;; turtle procedure
  ;; when energy dips below zero, die
  if energy < 0 [ die ]
end

to grow-trees  ;; patch procedure
  ;; countdown on white patches: if reach 0, grow some trees
  if pcolor = white [
    ifelse countdown <= 0
      [ set pcolor 64
        set countdown 10 ]
      [ set countdown countdown - 1 ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
488
15
957
505
25
25
9.0
1
14
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks
30.0

SLIDER
234
211
475
244
bluebles-reproduce
bluebles-reproduce
1.0
20.0
3
1.0
1
%
HORIZONTAL

SLIDER
277
28
474
61
initial-number-yeeblows
initial-number-yeeblows
0
50
28
1
1
NIL
HORIZONTAL

SLIDER
277
69
474
102
yeeblows-reproduce
yeeblows-reproduce
0.0
20.0
1
1.0
1
%
HORIZONTAL

BUTTON
17
42
86
75
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
107
42
174
75
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
8
259
324
517
Populations
Time
Population
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"Blue Longneck Bluebles" 1.0 0 -13345367 true "" "plot count bluelongneckbluebles"
"Green Longneck Bluebles" 1.0 0 -14439633 true "" "plot count greenlongneckbluebles"
"Yeeblows" 1.0 0 -1184463 true "" "plot count yeeblows"

MONITOR
333
259
476
304
Blue Longneck Bluebles
count bluelongneckbluebles
3
1
11

MONITOR
333
361
477
406
Yeeblows
count yeeblows
3
1
11

TEXTBOX
236
110
376
129
Blueble settings
11
0.0
0

TEXTBOX
279
10
392
28
Yeeblow settings
11
0.0
0

SLIDER
234
131
476
164
initial-number-bluelongneckbluebles
initial-number-bluelongneckbluebles
0
50
22
1
1
NIL
HORIZONTAL

SLIDER
234
171
475
204
initial-number-greenlongneckbluebles
initial-number-greenlongneckbluebles
0
50
22
1
1
NIL
HORIZONTAL

MONITOR
333
310
477
355
Green Longneck Bluebles
count greenlongneckbluebles
17
1
11

TEXTBOX
16
107
211
264
To find out what happens to the Bluebles when the Yeeblows move to Greeville, run the model by clicking \\"Setup\\" and then \\"Go.\\" To stop the model, click \\"Go\\" again. Adjust the sliders to change the number of Bluebles and Yeeblows and their chances of reproducing. For additional information, click the \\"Info\\" button. 
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

Bluebles3 is a model of natural selection via predation. In this model there are two types of Bluebles: Green Longneck Bluebles and Blue Longneck Bluebles. The model shows what happens to the Bluebles in the presence of a predatory species, Yeeblows, that only eat Bluebles they can see (the blue ones) not the ones that are camouflaged (the green ones).

## HOW IT WORKS

The model starts with a random arrangement of Yeeblows and the two different types of Bluebles, the amounts of which are determined by the initial-number-x sliders (eg. "initial-number-yeeblows", "initial-number-greenlongneckbluebles," "initial-number-bluelongneckbluebles). Both Bluebles and Yeeblows use energy to move around, which they must regain by eating. Bluebles eat trees (the green patches) to regain energy. After it has been eaten, the trees regrows after a random number of ticks (0-10). Yeeblows prey on the Bluebles, with the rule that they only eat the blue Bluebles, not any of the green ones. If a Blueble's or Yeeblow's energy drops below zero it dies. 

Both the Bluebles and the Yeeblows will also reproduce. The likelihood or proability (%) of their reproduction will be based on the "Bluebles-reproduce" and "Yeeblows-reproduce" sliders. Each Blueble will _hatch_ a Blueble of the same type when it reproduces. In other words, Blue Longneck Bluebles will hatch more Blue Longneck Bluebles, while Green Longneck Bluebles will hatch more Green Longneck Bluebles. Yeeblows will also hatch more Yeeblows. 

## HOW TO USE IT

Adjust the "initial-number-yeeblows", "initial-number-bluelongneckbluebles," and "initial-number-greenlongneckbluebles" sliders to determine how many of each breed the model will start with. Then adjust the "Bluebles-reproduce" and "Snurples-reproduce" sliders to set the likelihood of reproduction for Bluebles and Snurple. 

*Note that the "Bluebles-reproduce" slider adjusts the likelihood of reproduction for both types of Bluebles.*

After adjusting the sliders, press the "Setup" button to populate the model and then the "Go" button to run it. To stop the model, simply press the "Go" button a second time.


## THINGS TO NOTICE

Notice that if you set the model so that there are 28 Yeeblows, 22 Blue Longneck Bluebles and 22 Green Longneck Bluebles and so that Yeeblows have a 1% chance of reproducing and Bluebles have a 3% chance, the model shows trait extinction of the Blue Longneck Blueble body type. It is also important to note both that this happens gradually and that after the Blue Longneck Bluebles have all died, the Yeeblows begin die as well because of lack of food. 

Also notice that with other settings, especially ones were the Yeeblow reproduction rate is higher than that of the Bluebles, the ecosystem is unstable and the Yeeblows die out before they have eaten all of the Blue Longneck Bluebles.


## THINGS TO TRY

First, try adjusting the settings so that there are 28 Yeeblows, 22 Blue Longneck Bluebles and 22 Green Longneck Bluebles and so that Yeeblows have a 1% chance of reproducing and Bluebles have a 3% chance. 

After you have run the model once with the settings above, try adjusting the Yeeblow and Blueble settings to see if you can get different results. 

Now try adjusting the settings to see if you can create a stable ecosystem consisting of Bluebles, Yeeblows and Trees. Can you find any settings that generate a stable ecosystem?

## EXTENDING THE MODEL

One way to extend the model would be to try changing the reproduction rules. For example, what would happen if reproduction depended on energy rather than being determined by a fixed probability? What would happen if Blue Longneck Bluebles didn't produce only Blue Longneck Bluebles, but were also able to produce Green Longneck Bluebles?

Another way to extend the model would be to try changing the rules for Yeeblows eating Bluebles. What would happen if Yeeblows were not limited to only eating Blue Bluebles but had a fixed probability of eating both types of Blueble?

## NETLOGO FEATURES

Note the use of breeds to model five different kinds of "turtles": Blue Longneck Bluebles, Green Longneck Bluebles and Yeeblows. 

Note the use of patches to model trees.

Note the use of the ONE-OF agentset reporter to select a random Blue Longneck Blueble to be eaten by a Yeeblow.

Note the use of the "Turtle Shapes Editor" tool to create unique and relatively complex turtle shapes.

## RELATED MODELS

Look at "Wolf-Sheep Predation" for another example of predator prey relationships. 

For another example of predator prey relationships and natural selection, look at the "Bug Hunt Coevolution" model.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

longneck blueble
false
0
Circle -7500403 true true 109 9 88
Circle -7500403 true true 83 147 140
Circle -1 true false 147 22 28
Circle -1 true false 173 23 28
Circle -16777216 true false 154 36 14
Circle -16777216 true false 180 36 14
Circle -7500403 true true 165 49 40
Circle -7500403 true true 96 264 30
Circle -7500403 true true 171 263 31
Polygon -7500403 true true 206 216 217 237 235 225 210 216
Polygon -7500403 true true 212 193 218 217 235 199 212 187
Polygon -7500403 true true 202 172 215 191 224 173 206 172
Polygon -7500403 true true 191 243 202 264 224 255 210 241
Polygon -7500403 true true 102 170 107 177 124 159 101 147
Polygon -7500403 true true 88 197 89 196 106 178 77 168
Polygon -7500403 true true 84 223 82 222 96 196 68 201
Polygon -7500403 true true 90 247 91 245 90 218 63 235
Polygon -7500403 true true 104 267 105 265 104 238 77 255
Polygon -7500403 true true 167 292 172 270 167 263 140 280
Polygon -7500403 true true 135 292 154 277 150 260 123 277
Polygon -7500403 true true 106 15 119 34 128 16 131 17
Polygon -7500403 true true 185 155 198 174 207 156 189 155
Polygon -7500403 true true 127 88 128 86 127 59 100 76
Polygon -7500403 true true 122 72 123 70 122 43 95 60
Polygon -7500403 true true 121 56 122 54 123 30 90 39
Polygon -7500403 true true 122 1 136 27 145 9 151 12
Polygon -7500403 true true 149 13 172 22 175 1 152 13
Rectangle -7500403 true true 137 92 165 162
Line -16777216 false 157 3 156 13
Line -16777216 false 116 7 135 21
Line -16777216 false 103 29 125 36
Line -16777216 false 98 51 122 50
Line -16777216 false 98 71 124 66
Line -16777216 false 111 86 132 81
Line -16777216 false 116 143 126 160
Line -16777216 false 94 159 104 178
Line -16777216 false 75 187 92 200
Line -16777216 false 65 217 91 224
Line -16777216 false 74 245 100 242
Line -16777216 false 84 267 104 261
Line -16777216 false 186 146 172 162
Line -16777216 false 198 174 217 166
Line -16777216 false 208 191 230 186
Line -16777216 false 212 218 231 217
Line -16777216 false 208 241 230 242
Line -16777216 false 194 257 215 268
Line -16777216 false 154 277 158 293
Line -16777216 false 169 275 183 285
Line -16777216 false 136 277 121 285
Line -16777216 false 143 279 142 295
Circle -5825686 true false 161 76 18

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Rectangle -1 true true 166 225 195 285
Rectangle -1 true true 62 225 90 285
Rectangle -1 true true 30 75 210 225
Circle -1 true true 135 75 150
Circle -7500403 true false 180 76 116

smooth blueble
false
0
Circle -7500403 true true 105 60 88
Circle -7500403 true true 80 138 140
Circle -1 true false 140 76 28
Circle -1 true false 167 76 28
Circle -16777216 true false 147 90 14
Circle -16777216 true false 175 89 14
Circle -7500403 true true 159 99 42
Circle -7500403 true true 100 251 30
Circle -7500403 true true 169 251 31
Circle -5825686 true false 158 129 16

snurple
false
0
Circle -7500403 true true 150 15 88
Circle -1 true false 185 31 28
Circle -1 true false 212 31 28
Circle -16777216 true false 192 45 14
Circle -16777216 true false 220 44 14
Circle -7500403 true true 204 54 42
Polygon -5825686 true false 210 88 216 98 228 117 227 104 241 108 222 96 213 89 211 88
Line -16777216 false 193 25 211 33
Line -16777216 false 215 33 231 25
Circle -5825686 true false 203 83 14
Polygon -7500403 true true 151 62 138 70 126 79 121 83 116 89 111 97 107 109 107 117 110 127 116 137 124 146 133 153 148 161 158 172 167 181 176 192 184 206 186 219 185 228 177 228 169 219 162 214 148 208 139 208 121 207 109 210 98 214 87 220 81 225 91 208 92 201 92 195 88 186 79 182 70 181 62 182 54 188 49 196 44 202 40 211 37 223 36 235 37 244 41 250 47 259 55 262 66 261 76 260 87 255 95 252 101 249 110 245 124 244 138 247 149 256 166 270 185 276 210 271 229 252 237 234 237 220 231 204 220 181 212 171 202 158 193 150 182 139 171 128 156 113 158 106 164 101 176 95 158 65 157 63 158 57 157 63 159 57 166 59
Circle -16777216 true false 46 184 16
Circle -16777216 true false 41 180 14
Circle -16777216 true false 35 176 10
Polygon -16777216 true false 145 66 144 80 130 76 144 66
Polygon -16777216 true false 127 78 129 94 115 90 126 78
Polygon -16777216 true false 111 97 119 112 106 115 110 98
Polygon -16777216 true false 109 122 125 127 116 138 109 124
Polygon -16777216 true false 117 141 134 141 133 153 118 140
Polygon -16777216 true false 138 154 156 154 155 167 138 154
Polygon -16777216 true false 158 170 175 172 173 188 158 170
Polygon -16777216 true false 174 190 191 196 186 212 174 190
Polygon -16777216 true false 186 217 196 227 182 230 186 217
Polygon -16777216 true false 164 215 179 229 163 229 164 216
Polygon -16777216 true false 149 208 159 213 144 219 138 208
Polygon -16777216 true false 121 207 134 208 124 218 111 209
Polygon -16777216 true false 99 213 108 210 104 223 89 218
Polygon -16777216 true false 87 212 87 213 81 227 73 217
Polygon -16777216 true false 92 199 91 204 87 212 80 203
Polygon -16777216 true false 83 184 91 189 91 198 81 192
Polygon -16777216 true false 69 182 76 181 83 184 74 191
Polygon -16777216 true false 60 184 65 181 69 182 67 192
Polygon -16777216 true false 150 46 161 58 148 61 152 44
Polygon -16777216 true false 164 26 167 42 152 42 163 27
Polygon -16777216 true false 183 16 181 29 165 25 182 16
Polygon -16777216 true false 210 18 208 25 184 17 195 14

spiny blueble
false
0
Circle -7500403 true true 104 57 88
Circle -7500403 true true 82 140 140
Circle -1 true false 140 76 28
Circle -1 true false 167 76 28
Circle -16777216 true false 147 90 14
Circle -16777216 true false 175 89 14
Circle -7500403 true true 160 100 40
Circle -7500403 true true 100 251 30
Circle -7500403 true true 169 251 31
Polygon -7500403 true true 208 203 219 224 237 212 212 203
Polygon -7500403 true true 208 180 214 204 231 186 208 174
Polygon -7500403 true true 197 157 210 176 219 158 201 157
Polygon -7500403 true true 192 232 203 253 225 244 211 230
Polygon -7500403 true true 101 163 106 170 123 152 100 140
Polygon -7500403 true true 89 186 90 185 107 167 78 157
Polygon -7500403 true true 83 212 81 211 95 185 67 190
Polygon -7500403 true true 90 238 91 236 90 209 63 226
Polygon -7500403 true true 103 262 104 260 103 233 76 250
Polygon -7500403 true true 167 287 172 265 167 258 140 275
Polygon -7500403 true true 133 284 152 269 148 252 121 269
Polygon -7500403 true true 104 64 117 83 126 65 129 66
Polygon -7500403 true true 179 146 192 165 201 147 183 146
Polygon -7500403 true true 128 138 129 136 128 109 101 126
Polygon -7500403 true true 119 121 120 119 119 92 92 109
Polygon -7500403 true true 118 104 119 102 120 78 87 87
Polygon -7500403 true true 124 48 138 74 147 56 153 59
Polygon -7500403 true true 147 60 170 69 173 48 150 60
Line -16777216 false 117 56 132 71
Line -16777216 false 148 63 145 47
Line -16777216 false 156 64 163 49
Line -16777216 false 170 69 180 59
Line -16777216 false 101 77 120 85
Line -16777216 false 95 99 111 97
Line -16777216 false 97 115 115 111
Line -16777216 false 101 122 119 123
Line -16777216 false 115 138 129 130
Line -16777216 false 94 151 107 165
Line -16777216 false 111 142 121 157
Line -16777216 false 70 173 98 184
Line -16777216 false 67 200 94 211
Line -16777216 false 72 240 97 234
Line -16777216 false 86 263 108 251
Line -16777216 false 124 282 134 267
Line -16777216 false 145 271 141 283
Line -16777216 false 158 270 175 283
Line -16777216 false 189 256 212 264
Line -16777216 false 199 242 219 253
Line -16777216 false 211 232 229 232
Line -16777216 false 211 210 233 204
Line -16777216 false 210 187 226 177
Line -16777216 false 197 167 215 150
Line -16777216 false 173 154 193 143
Circle -5825686 true false 155 128 16

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Rectangle -7500403 true true 195 106 285 150
Rectangle -7500403 true true 195 90 255 105
Polygon -7500403 true true 240 90 217 44 196 90
Polygon -16777216 true false 234 89 218 59 203 89
Rectangle -1 true false 240 93 252 105
Rectangle -16777216 true false 242 96 249 104
Rectangle -16777216 true false 241 125 285 139
Polygon -1 true false 285 125 277 138 269 125
Polygon -1 true false 269 140 262 125 256 140
Rectangle -7500403 true true 45 120 195 195
Rectangle -7500403 true true 45 114 185 120
Rectangle -7500403 true true 165 195 180 270
Rectangle -7500403 true true 60 195 75 270
Polygon -7500403 true true 45 105 15 30 15 75 45 150 60 120

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

yeeblow
false
0
Circle -7500403 true true 106 15 82
Circle -7500403 true true 85 86 100
Circle -1 true false 146 35 24
Circle -1 true false 171 35 24
Circle -16777216 true false 152 47 12
Circle -16777216 true false 178 48 12
Circle -7500403 true true 168 60 34
Circle -7500403 true true 102 170 30
Circle -7500403 true true 150 165 31
Polygon -7500403 true true 101 163 106 170 123 152 100 140
Polygon -7500403 true true 115 9 127 34 136 16 139 17
Polygon -7500403 true true 120 84 123 84 118 61 91 78
Polygon -7500403 true true 109 64 110 62 114 42 90 50
Polygon -7500403 true true 120 51 121 49 122 25 98 30
Polygon -7500403 true true 146 4 138 22 157 16 163 19
Polygon -7500403 true true 155 19 178 28 179 10 158 19
Line -16777216 false 147 28 170 38
Line -16777216 false 172 39 195 28
Circle -5825686 true false 160 82 12
Polygon -7500403 true true 115 101 102 97 94 94 83 91 76 89 68 87 58 86 49 85 27 88 17 93 9 96 5 104 2 121 5 141 17 125 18 150 32 135 33 158 48 135 51 162 70 143 70 166 86 144 94 166 121 105 118 102 113 100 117 103 123 104 120 107 122 109 121 113 127 104 125 110
Polygon -7500403 true true 174 100 187 96 195 93 206 90 213 88 221 86 231 85 240 84 262 87 273 91 283 95 289 105 288 116 283 136 272 124 270 147 257 134 256 156 241 134 238 161 219 142 219 165 203 143 195 165 168 104 171 101 176 99 172 102 166 103 169 106 167 108 168 112 162 103 164 109
Line -16777216 false 172 189 179 197
Line -16777216 false 166 192 170 201
Line -16777216 false 177 183 187 188
Line -16777216 false 121 195 128 206
Line -16777216 false 113 196 116 207
Line -16777216 false 126 192 136 198

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
setup
set grass? true
repeat 75 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
