patches-own [ country ]
turtles-own [ origin citizen prof employed]
globals [
  ;;countries
  countries
  ;;professions
  profes
  ;;patches for countries
  patches-1 patches-2 patches-3 patches-4
  ;;wages  
  wage-1A wage-1B wage-1C wage-1D
  wage-2A wage-2B wage-2C wage-2D
  wage-3A wage-3B wage-3C wage-3D
  wage-4A wage-4B wage-4C wage-4D
]

to setup
  set countries [ 1 2 3 4 ]
  set profes [ "A" "B" "C" "D" ]
  setup-patches
  setup-labels
  setup-turtles
  calc-wage
end

to calc-wage
  ;;Wage for country 1
  set wage-1A calc-wage-for 1 "A"
  ;;type "wage 1A: " print wage-1A
  set wage-1B calc-wage-for 1 "B"
  ;;type "wage 1B: " print wage-1B
  set wage-1C calc-wage-for 1 "C"
  ;;type "wage 1C: " print wage-1C
  set wage-1D calc-wage-for 1 "D"
  ;;type "wage 1D: " print wage-1D
  ;;Wage for country 2
  set wage-2A calc-wage-for 2 "A"
  ;;type "wage 2A: " print wage-2A
  set wage-2B calc-wage-for 2 "B"
  ;;type "wage 2B: " print wage-2B
  set wage-2C calc-wage-for 2 "C"
  ;;type "wage 2C: " print wage-2C
  set wage-2D calc-wage-for 2 "D"
  ;;type "wage 2D: " print wage-2D
  ;;Wage for country 3
  set wage-3A calc-wage-for 3 "A"
  ;;type "wage 3A: " print wage-3A
  set wage-3B calc-wage-for 3 "B"
  ;;type "wage 3B: " print wage-3B
  set wage-3C calc-wage-for 3 "C"
  ;;type "wage 3C: " print wage-3C
  set wage-3D calc-wage-for 3 "D"
  ;;type "wage 3D: " print wage-3D
  ;;Wage for country 4
  set wage-4A calc-wage-for 4 "A"
  ;;type "wage 4A: " print wage-4A
  set wage-4B calc-wage-for 4 "B"
  ;;type "wage 4B: " print wage-4B
  set wage-4C calc-wage-for 4 "C"
  ;;type "wage 4C: " print wage-4C
  set wage-4D calc-wage-for 4 "D"
  ;;type "wage 4D: " print wage-4D

end

to go-wage
  immigrate-by-wage
  calc-wage
  tick
end

to immigrate-by-wage
    ask turtles [
      let max-wage-desc 0
      let max-wage-country 0
      foreach [ 1 2 3 4 ]
      [
        if not (citizen = ?) [
           let twage-desc calc-wage-desc prof citizen ?
           if max-wage-desc < twage-desc
           [
             set max-wage-desc twage-desc
             set max-wage-country ? 
           ] 
        ]
      ]
      if max-wage-desc >= wage-discrepancy and max-wage-country != 0
      [
        move-to-empty-one-of patches with [ country = max-wage-country ]
        set citizen max-wage-country
      ]
    ]
end

to-report calc-wage-desc [ profs state nstate ]
let result (((get-wage nstate profs) - (get-wage state profs)) / (get-wage state profs)) * 100
report result
end

to-report get-wage [ state profs ]
  if state = 1 [
    if profs = "A" [ report wage-1A ]
    if profs = "B" [ report wage-1B ]
    if profs = "C" [ report wage-1C ]
    if profs = "D" [ report wage-1D ]
  ]
  if state = 2 [
    if profs = "A" [ report wage-2A ]
    if profs = "B" [ report wage-2B ]
    if profs = "C" [ report wage-2C ]
    if profs = "D" [ report wage-2D ]
  ]
  if state = 3 [
    if profs = "A" [ report wage-3A ]
    if profs = "B" [ report wage-3B ]
    if profs = "C" [ report wage-3C ]
    if profs = "D" [ report wage-3D ]
  ]
  if state = 4 [
    if profs = "A" [ report wage-4A ]
    if profs = "B" [ report wage-4B ]
    if profs = "C" [ report wage-4C ]
    if profs = "D" [ report wage-4D ]
  ]
end
 
to-report calc-wage-for [ state profs ]
  let pop count turtles with [ citizen = state ]
  let prof-pop count turtles with [ citizen = state and prof = profs ]
  let ideal-prof floor (pop * (get-ideal profs)) / 100
  let totinv ideal-prof * 50
  ifelse ideal-prof < prof-pop
  [ ask n-of ideal-prof turtles with [ citizen = state and prof = profs ]
    [ set employed true ]
  ]
  [ ask turtles with [ citizen = state and prof = profs ]
    [ set employed true ]
  ]
  ifelse prof-pop = 0
  [report totinv]
  [report totinv / prof-pop]
end

to-report get-ideal [ profs ]
  if profs = "A"
  [ report ideal-A-perc ]
  if profs = "B"
  [ report ideal-B-perc ]
  if profs = "C"
  [ report ideal-C-perc ]
  if profs = "D"
  [ report ideal-D-perc ]
end

to setup-patches
  clear-all
  set-default-shape turtles "person"
  set patches-1 patches with [pycor > 0 and pxcor < 0]
  ask patches-1
  [ set pcolor green 
    set country 1
    ]
  set patches-2 patches with [pycor > 0 and pxcor > 0]
  ask patches-2
  [ set pcolor blue 
    set country 2]
  set patches-3 patches with [pycor < 0 and pxcor < 0]
  ask patches-3
  [ set pcolor orange 
    set country 3]
  set patches-4 patches with [pycor < 0 and pxcor > 0]
  ask patches-4
  [ set pcolor grey 
    set country 4]
end

to setup-labels
  ask patch (min-pxcor / 2) (max-pycor / 2 ) [
    set plabel "1"
  ]
  ask patch (max-pxcor / 2) (max-pycor / 2 ) [
    set plabel "2"
  ]
  ask patch (min-pxcor / 2) (min-pycor / 2 ) [
    set plabel "3"
  ]
  ask patch (max-pxcor / 2) (min-pycor / 2 ) [
    set plabel "4"
  ]
end

to move-to-empty-one-of [locations]  ;; turtle procedure
  move-to one-of locations
  while [any? other turtles-here] [
    move-to one-of locations
  ]
end

to setup-turtles
  crt population-1 [
    set citizen 1
    set origin 1
    set prof one-of [ "A" "B" "C" "D" ]
    set employed false
    move-to-empty-one-of patches-1
    ]
  crt population-2 [
    set citizen 2
    set origin 2
    set prof one-of [ "A" "B" "C" "D" ]
    set employed false
    move-to-empty-one-of patches-2
  ]
  crt population-3 [
    set citizen 3
    set origin 3
    set prof one-of [ "A" "B" "C" "D" ]
    set employed false
    move-to-empty-one-of patches-3
  ]
  crt population-4 [
    set citizen 4
    set origin 4
    set prof one-of [ "A" "B" "C" "D" ]
    set employed false
    move-to-empty-one-of patches-4
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
675
496
17
17
13.0
1
10
1
1
1
0
1
1
1
-17
17
-17
17
0
0
1
ticks

BUTTON
10
63
76
96
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
11
126
183
159
population-1
population-1
0
100
90
1
1
NIL
HORIZONTAL

SLIDER
10
165
182
198
population-2
population-2
0
100
51
1
1
NIL
HORIZONTAL

SLIDER
9
207
181
240
population-3
population-3
0
100
52
1
1
NIL
HORIZONTAL

SLIDER
10
252
182
285
population-4
population-4
0
100
18
1
1
NIL
HORIZONTAL

SLIDER
762
67
934
100
ideal-A-perc
ideal-A-perc
0
100
40
1
1
NIL
HORIZONTAL

SLIDER
763
105
935
138
ideal-B-perc
ideal-B-perc
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
763
145
935
178
ideal-C-perc
ideal-C-perc
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
765
187
937
220
ideal-D-perc
ideal-D-perc
0
100
20
1
1
NIL
HORIZONTAL

MONITOR
709
272
766
317
1-A%
100 * (count turtles with [ citizen = 1 and prof = \\"A\\" ]) / (count turtles with [ citizen = 1 ])
1
1
11

MONITOR
710
321
767
366
1-B%
100 * (count turtles with [ citizen = 1 and prof = \\"B\\" ]) / (count turtles with [ citizen = 1 ])
1
1
11

MONITOR
711
370
768
415
1-C%
100 * (count turtles with [ citizen = 1 and prof = \\"C\\" ]) / (count turtles with [ citizen = 1 ])
1
1
11

MONITOR
712
421
769
466
1-D%
100 * (count turtles with [ citizen = 1 and prof = \\"D\\" ]) / (count turtles with [ citizen = 1 ])
17
1
11

MONITOR
778
272
835
317
2-A%
100 * (count turtles with [ citizen = 2 and prof = \\"A\\" ]) / (count turtles with [ citizen = 2 ])
1
1
11

MONITOR
779
321
836
366
2-B%
100 * (count turtles with [ citizen = 2 and prof = \\"B\\" ]) / (count turtles with [ citizen = 2 ])
1
1
11

MONITOR
783
370
833
415
2-C%
100 * (count turtles with [ citizen = 2 and prof = \\"C\\" ]) / (count turtles with [ citizen = 2 ])
1
1
11

MONITOR
784
418
841
463
2-D%
100 * (count turtles with [ citizen = 2 and prof = \\"A\\" ]) / (count turtles with [ citizen = 2 ])
1
1
11

MONITOR
849
270
906
315
3-A%
100 * (count turtles with [ citizen = 3 and prof = \\"A\\" ]) / (count turtles with [ citizen = 3 ])
1
1
11

MONITOR
849
318
906
363
3-B%
100 * (count turtles with [ citizen = 3 and prof = \\"B\\" ]) / (count turtles with [ citizen = 3 ])
1
1
11

MONITOR
850
368
907
413
3-C%
100 * (count turtles with [ citizen = 3 and prof = \\"C\\" ]) / (count turtles with [ citizen = 3 ])
1
1
11

MONITOR
853
418
910
463
3-D%
100 * (count turtles with [ citizen = 3 and prof = \\"D\\" ]) / (count turtles with [ citizen = 3 ])
1
1
11

MONITOR
916
269
973
314
4-A%
100 * (count turtles with [ citizen = 4 and prof = \\"A\\" ]) / (count turtles with [ citizen = 4 ])
1
1
11

MONITOR
918
319
975
364
4-B%
100 * (count turtles with [ citizen = 4 and prof = \\"B\\" ]) / (count turtles with [ citizen = 4 ])
1
1
11

MONITOR
919
368
976
413
4-C%
100 * (count turtles with [ citizen = 4 and prof = \\"C\\" ]) / (count turtles with [ citizen = 4 ])
1
1
11

MONITOR
921
418
978
463
4-D%
100 * (count turtles with [ citizen = 4 and prof = \\"D\\" ]) / (count turtles with [ citizen = 4 ])
1
1
11

SLIDER
9
312
181
345
wage-discrepancy
wage-discrepancy
0
100
21
1
1
NIL
HORIZONTAL

BUTTON
95
64
181
97
NIL
go-wage
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
1001
71
1070
116
NIL
wage-1A
17
1
11

MONITOR
1002
122
1071
167
NIL
wage-2A
17
1
11

MONITOR
1002
172
1071
217
NIL
wage-3A
17
1
11

MONITOR
1003
225
1072
270
NIL
wage-4A
17
1
11

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
