;;=====================================================================|=======|
;; SECTION A – AUTHOR IDENTIFICATION AND CODE ABSTRACT
;;=====================================================================|=======|
;;
;; File Name: SimEvo_V5.08.nlogo
;; By Orrery Software
;; Dated: 2018-11-21
;; Author contact:
;;   Garvin H Boyle
;;   orrery@rogers.com
;;   http://orrery-software.webs.com

;;---------------------------------------------------------------------|-------|
;; This simEvo ABM is based on "Simulated Evolution" by Dr Michael Palmiter
;;   as described in the Scientific American article by A.K.Dewdney of 1989.

;; In this model, energy arrives in a steady stream from the Sun and is
;;   captured in algae, which appears randomly in patches in the pond. 
;;   Blind seekers roam the pond searching for food, but they cannot sense
;;   it.  Each must develop a heuristic strategy, an informed pattern of 
;;   behaviour, to seek the algae mats currently having food, and harvest it.
;;   The strategies start as ineffective bland heuristics, and evolve to be 
;;   much more sophisticated.  Only those with the best search pattern
;;   survive to reproduce.
;;---------------------------------------------------------------------|-------|
;; This program was developed on NetLogo Version 5.0.5
;;

;;=====================================================================|=======|
;; SECTION B – INITIAL DECLARATIONS OF GLOBAL VARIABLES AND BREEDS
;;=====================================================================|=======|
;;

;;---------------------------------------------------------------------|-------|
;; Code-determined global variables
globals
[
;;---------------------------------------------------------------------|-------|
;; MODELING ENGINE
;;---------------------------------------------------------------------|-------|
;; BIOPHYSICAL SUB-SYSTEM PARAMETERS
;;---------------------------------------------------------------------|-------|

  ;; Biophyscial life function parameters, seekers, 
  ;;   derived from Dr. Michael Palmiter's model.
  g-c2-dat-parm  ;; The death age threshold
  g-c2-det-parm  ;; The death energy threshold
  g-c2-rat-parm  ;; The reproductive age threshold
  g-c2-ret-parm  ;; The reproductive energy threshold
  g-c2-epm-parm  ;; The energy per move
  g-c2-epa-parm  ;; The maximum energy an agent may hold
  
  ;; Various parameters - soft coded
  g-energy-per-deposit ;; Energy placed in a patch
  g-prob-of-mutation   ;; Probability that a seeker mutates at birth.

  ;; The global list of possible heading deltas for moves.
  gl-heading-list  ;; List of heading deltas.
  gl-base-factors  ;; List of factors, used to mutate bases
  
  ;; Energy control variables
  g-prob-of-deposit        ;; Probability that energy will be deposited. 
  g-energy-in-sunshine     ;; Daily influx of energy held in the sunshine.

  ;; List of counts of deaths, by cause.
  gl-cod                   ;; Counts of deaths, by cause.
  
  ;; Global enumeration (ge-) codes for cause of death.
  ge-cod-none
  ge-cod-fission
  ge-cod-hunger
  ge-cod-oldage

  ;; For display.
  g-energy-entropic-index  ;; For [energy] of seekers.
  gl-ave-phenotype         ;; Average values of c1-pheno
  g-pheno-entropic-index   ;; For average phenotypes
]

;;---------------------------------------------------------------------|-------|
;; DEFINING PATCHES AND BREEDS
;;---------------------------------------------------------------------|-------|
  
;;---------------------------------------------------------------------|-------|
;; Attributes of patches
patches-own 
[
  algae  ;; The amount of energy in algae in this patch.
]

;;---------------------------------------------------------------------|-------|
;; Turtles and breeds
breed [ seekers seeker ]

;;---------------------------------------------------------------------|-------|
;; Attributes of seekers
seekers-own 
[
  ;; Chromosome 1 (C1) genes are used to distinguish behaviours.
  c1-bases ;; list of 8 [B]ases for genes. 
  c1-expos ;; list of 8 [E]xponents for the genes.
  c1-stren ;; list of 8 [S]trengths             [ Si=Bi^Ei ]
  c1-pheno ;; list of 8 [P]henotypic characteristics [Pi=(Si/Sum(Si))]
  
  ;; Chromosome 2 (C2) genes are static in this model.
  c2-DAT   ;; Death Age Threshold.
  c2-DET   ;; Death Energy Threshold.
  c2-RAT   ;; Reproductive Age Threshold.
  c2-RET   ;; Reproductive Energy Threshold.
  c2-EPM   ;; Energy Per Move.
  c2-EPA   ;; Maximum Energy Per Agent.
  
  ;; Chromosome 3 (C3) genes are not present in this model.
  
  ;; Other variable characteritics.
  mas-who                  ;; Serial number of mother agent.
  age                      ;; Age of the seeker in ticks
  energy                   ;; Energy in this seeker
  cause-of-death           ;; A switch
  b-is-ready-to-move?      ;; 0 = no; 1 = ready to move
  b-is-ready-to-reproduce? ;; Mature (in age) and healthy (in energy)
  b-is-ready-to-die?       ;; Old (in age) or starved (in energy)
]

;;=====================================================================|=======|
;; SECTION C – INITIALIZATION OR SETUP PROCEDURE(S)
;;=====================================================================|=======|

;;---------------------------------------------------------------------|-------|
;; The 'autostart' startup routine
to startup
  ;; This routine is to be executed by the observer.
  ;; It is automatically run when the model is first loaded.
  ;; This ensures that key startup variables stored in persistent controls
  ;;   such as sliders are returned to their default values after a save.

  ;; Any globals not initialized in setup should be initialized here.
  set g-random-seed 7

  ;; Run the setup routine to initialize (other) globals.
  setup
end

;;---------------------------------------------------------------------|-------|
;; The setup button(s)
to setup
  ;; This routine is to be executed by the observer.

  ;; NOTE: The contents of switches, sliders, and choosers seem to be 
  ;;   immune to these 'clear' commands.
  clear-ticks       ;; Clears the tick counter, must be followed by reset-ticks.
  clear-turtles     ;; Kills all turtles and resets the who counter to zero.
  clear-links       ;; Kills all links.
  clear-patches     ;; Sets all attributes of patches to default values. 
  clear-drawing     ;; Clears all lines and stamps drawn by turtles.
  clear-all-plots   ;; Clears all plots and sets attributes to default values.
  clear-output      ;; Clears the output area, if there is one.
  
  random-seed ( g-random-seed )
  
  ;; Set the energy (encoded in the variable algae) in all of the patches to zero.
  ask patches
  [
    set algae 0
    set pcolor brown  ;; Empty patches (no algae) are brown.
  ]
  
  random-seed 7      ;; Tells the PRNG (a Mersene Twister) to use this seed.
  
  ;; Various global parameters - soft-coded
  set g-energy-per-deposit 40   ;; Energy placed in a patch
  set g-prob-of-deposit 0.2
  set g-prob-of-mutation 0.2 ;; Probability that a seeker mutates at birth.
  ;; Chromosome 2 (C2) biophysical controls - borrowed from Palmiter's model.
  ;; In this model these values are static.  C2 does not mutate.
  set g-c2-dat-parm        1600  ;; Death Age Threshold
  set g-c2-det-parm           4  ;; Death Energy Threshold
  set g-c2-rat-parm         800  ;; Reproductive Age Threshold
  set g-c2-ret-parm        1000  ;; Reproductive Energy Threshold
  set g-c2-epm-parm           4  ;; Energy Per Move (Metabolic cost)
  set g-c2-epa-parm        1600  ;; Maximum Energy Per Agent

  ;; Establish the list of allowed headings, each 45 degrees from the last.
  ;;   These are the possible deltas that will be added to the current heading
  ;;   based on which of the 8 genes is expressed during a move.
  set gl-heading-list [ 0 45 90 135 180 225 270 315 ] 

  ;; The factors used to mutate the base values of the genes need to be 
  ;;   calculated.
  let prime-list [ 7 11 13 17 ]
  let factor-list ( map [ 1 + ( 1 / ? ) ] prime-list )
  let inverse-list ( map [ 1 - ( 1 / ? ) ] prime-list )
  set gl-base-factors ( sentence factor-list inverse-list )

  ;; Suppressed debug code
  ;; show ( word "     prime-list: " prime-list )
  ;; show ( word "    factor-list: " factor-list )
  ;; show ( word "   inverse-list: " inverse-list )
  ;; show ( word "gl-base-factors: " gl-base-factors )

  set gl-cod [ 0 0 0 0 ]        ;; Counts of deaths, by cause.

  ;; Global enumeration (ge-) codes for cause of death.
  set ge-cod-none     0
  set ge-cod-fission  1
  set ge-cod-hunger   2
  set ge-cod-oldage   3
  
  set-default-shape seekers "arrow" ;; pulled from shapes library

  set g-energy-entropic-index 0 ;; For [energy] of seekers.
  set gl-ave-phenotype ( n-values 8 [0] ) ;; Average values of c1-pheno
  set g-pheno-entropic-index  0 ;; For average phenotypes
  
  ;; Initialize the seekers.
  f-initialize-seekers
  
  ;; Update the statistics used in the plots.
  ;; show [energy] of seekers
  f-update-aggregates
  
  reset-ticks ;; restarts tick counter, runs setup commands within plots
  
  ;; end of setup
end

;;---------------------------------------------------------------------|-------|
;; Initialize a population of seekers.
to f-initialize-seekers
  ;; This routine is to be executed by the observer.

  ;; Initialize the seekers.
  create-seekers 100 [ f-initialize-new-seeker ]
  
  ;; Place more energy into patches.
  ask patches
  [
    set algae 0
    set pcolor brown
  ]

  ;; End of f-initialize-seekers
end

;;---------------------------------------------------------------------|-------|
;; Calculate the strengths and phenotypic values.
to f-find-strens-n-phenos
  ;; This routine is to be executed by a seeker.

  ;; It uses the second example of the map feature.
  ;; Examples of the map feature.
  ;; show (map + [1 2 3] [2 4 6])
  ;; => [3 6 9]
  ;; show (map [?1 + ?2 = ?3] 
  ;;           [1 2 3] 
  ;;           [2 4 6] 
  ;;           [3 5 9])
  ;; => [true false true]
    
  ;; Compute the strength as Si=Bi^Ei.
  set c1-stren ( map [?1 ^ ?2] 
                     c1-bases 
                     c1-expos )
  ;; Compute the phenotypic character as Pi=(Si/sum(Si)).
  set c1-pheno 
    ( map [?1 / ?2] 
          c1-stren 
          ( n-values 8 [sum c1-stren] ) )

  ;; End of f-find-strens-n-phenos
end

;;---------------------------------------------------------------------|-------|
;; Initialize a single seeker.
to f-initialize-new-seeker
  ;; This routine is to be executed by a seeker.

  set color yellow
  
  ;; Load chromosome 1 with Palmiter genes.
  set c1-bases [ 2 2 2 2 2 2 2 2 ]  ;; 8 unbiased genes
  set c1-expos [ 0 0 0 0 0 0 0 0 ]  ;; 8 unbiased genes
  ;; Calculate the strengths and phenotypic characters.
  f-find-strens-n-phenos
      
  ;; The biophysical body function genes are static in this model.
  ;; I.e. this chromosome does not suffer mutations.
  ;; Load chromosome 2 with the parameters from sliders.
  set c2-DAT g-c2-dat-parm
  set c2-DET g-c2-det-parm
  set c2-RAT g-c2-rat-parm
  set c2-RET g-c2-ret-parm
  set c2-EPM g-c2-epm-parm
  set c2-EPA g-c2-epa-parm

  ;; Associated with seeker dynamics.
  set energy ( g-c2-rat-parm )
  set age ( random ( g-c2-ret-parm / 2 ) )
  set mas-who -1                 ;; serial number of parent seeker.

  ;; Set the logic trigger flags.
  set b-is-ready-to-move?      true     
  set b-is-ready-to-reproduce? false 
  set b-is-ready-to-die?       false 
  
  ;; end f-initialize-new-seeker
end

;;=====================================================================|=======|
;; SECTION D – GO OR MAIN-LOOP PROCEDURE(S)
;;=====================================================================|=======|

;;---------------------------------------------------------------------|-------|
;; The go button
to go
  ;; This routine is to be executed by the observer.

  let b-should-stop-now false
  if( count turtles <= 0 ) [ set b-should-stop-now true ]
  if( b-should-stop-now = true )
  [
    stop
  ]
  ;; stop commands should only be seen in the go routine.

  ;; Major steps or functions, done once per tick, in order of execution.
  do-pre-tick   ;; Mai                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               